/*******************************************************************************
 * Projector generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class Projector extends RenderActor
    native
    collapsecategories
    notplaceable
    hidecategories(Collision,Filter,HeatVision,Interactivity,Karma,KarmaObject,KarmaOverride,Lighting,Networking,Sound,SpawnOnDestroyed);

cpptext
{
// Stripped
}

var() noexport MaterialEx ProjTexture "Texture to project";
var() noexport int FOV "FOV of projection frustum. 0 == Orthogonal.";
var() noexport int MaxTraceDistance "How far out projector will affect the world.";
var() noexport float MaxViewDistance "How far away till this projector will no longer render.";
var() noexport float FadeOutStart "When to start fading out.";
var() noexport bool bProjectBSP "If true, the projector will draw itself on the BSP.";
var() noexport bool bProjectMesh "If true, the projector will draw itself on meshes.";
var() noexport bool bProjectStaticMesh "If true, the projector will draw itself on static meshes.";
var() noexport bool bProjectActor "If true, the projector will draw itself on actors.";
var() noexport bool bProjectPawn "If true, the projector will draw itself on pawns.";
var() noexport bool bProjectOwner "If true, then the projector will draw itself on the actor that spawned it as well.";
var() noexport bool bProjectAmmoCasings "If true, then the projector will draw on top of shell casings";
var() noexport bool bLevelStatic "Set this to true if you never plan on moving the projector around.";
var() noexport bool bProjectNonStatic "Set this to true if you have bLevelStatic and want to attach to actors that have bStatic = false.  This was added instead of changing the logic for bLevelStatic, just in case that would have broken stuff.";
var() noexport bool bClipBSP "If true, the projector will clip itself to the frustum (only for BSP).";
var() noexport bool bClipStaticMesh "If true, the projector will clip itself to the frustum (only for StaticMeshes).";
var() noexport bool bProjectOnUnlit "If true, the projector will draw itself on Unlit surfaces.";
var() noexport bool bBackFaceCull "If true, the projector will backface cull BSP surfaces from the POV of the projector.";
var() noexport bool FlipX "Flip this projector across it's X Axis.";
var() noexport bool FlipY "Flip this projector across it's Y Axis.";
var() bool bIsDecal;
var() noexport bool bDestroyOnTrigger "Destroy the projector when it gets triggered.";
var() noexport bool bProjectingShadow "Flag to allow control over projector with shadow display settings.  Projector should never be turned off any other way.";
var() deprecated name ProjectTag;
var() noexport float BackFaceThreshold "Threshold amount for backface culling the BSP nodes.  Valid ranges are -1.0f to 1.0f.";
var() noexport float ScaleX "Independent scaling of the x axis";
var() noexport float ScaleY "Independent scaling of the y axis";
var() noexport float MinSpawnDistance "The closest distance another projector is allowed to spawn";
var() float OverrideNearPlaneDist;
var() float ProjectorOpacity;
var() noexport name TurnOnTag "Trigger this event to turn the Projector on.  Will not work when bLevelStatic = true.";
var() noexport name TurnOffTag "Trigger this event to turn the Projector off.  Will not work when bLevelStatic = true.";
var const editconst transient nontrans pointer InternalData;
var() deprecated Actor ExclusiveActor;

// Export UProjector::execAttachProjector(FFrame&, void* const)
native(849) final function AttachProjector();

// Export UProjector::execDetachProjector(FFrame&, void* const)
native(850) final function DetachProjector(optional bool Force);

// Export UProjector::execAbandonProjector(FFrame&, void* const)
native(851) final function AbandonProjector(optional float Lifetime);

// Export UProjector::execAttachActor(FFrame&, void* const)
native(852) final function AttachActor(Actor A);

// Export UProjector::execDetachActor(FFrame&, void* const)
native(853) final function DetachActor(Actor A);

// Export UProjector::execGetLastRenderTime(FFrame&, void* const)
native(854) final function float GetLastRenderTime();

// Export UProjector::execTurnOff(FFrame&, void* const)
native(855) final function TurnOff(bool bOff);

// Export UProjector::execUpdateMatrix(FFrame&, void* const)
native(856) final simulated function UpdateMatrix();

final function TriggerFunc_TurnOn()
{
    __NFUN_855__(false);
    return;
}

final function TriggerFunc_TurnOff()
{
    __NFUN_855__(true);
    return;
}

event PostBeginPlay()
{
    __NFUN_849__();
    // End:0x14
    if(bLevelStatic)
    {
        __NFUN_851__();
        __NFUN_614__();
        return;
    }
    __NFUN_718__('TurnOn', TurnOnTag);
    __NFUN_718__('TurnOff', TurnOffTag);
    // End:0x3D
    if(bProjectActor)
    {
        __NFUN_621__(true, false, false);
    }
    super.PostBeginPlay();
    return;
}

event Touch(Actor Other)
{
    __NFUN_852__(Other);
    return;
}

event UnTouch(Actor Other)
{
    __NFUN_853__(Other);
    return;
}

function Trigger(Actor Other, Pawn EventInstigator)
{
    // End:0x0C
    if(bDestroyOnTrigger)
    {
        __NFUN_614__();
    }
    return;
}

event PhysicsChange(optional Object.EPhysics PreviousPhysics)
{
    super(KarmaActor).PhysicsChange(PreviousPhysics);
    // End:0x2C
    if(int(Physics) + int(0))
    {
        bNoNativeTick = false;
        __NFUN_361__('Tick');        
    }
    else
    {
        bNoNativeTick = true;
        __NFUN_362__('Tick');
    }
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    super(Actor).RegisterPrecacheComponents(PrecacheIndex);
    PrecacheIndex.__NFUN_1269__(ProjTexture);
    return;
}

defaultproperties
{
    FOV=45
    MaxTraceDistance=1000
    MaxViewDistance=1024
    bProjectBSP=true
    bProjectMesh=true
    bProjectStaticMesh=true
    bProjectActor=true
    bProjectPawn=true
    bProjectOwner=true
    bProjectAmmoCasings=true
    bClipBSP=true
    BackFaceThreshold=0.01
    ScaleX=1
    ScaleY=1
    ProjectorOpacity=1
    bTraceUsable=false
    bTraceShootable=false
    bBlockCamera=false
    bHidden=true
    bIsProjector=true
    bNoNativeTick=true
    bAcceptsProjectors=false
    bAcceptsDecalProjectors=false
    bDirectional=true
    TickStyle=0
    Texture=Texture'S_Projector'
}