/*******************************************************************************
 * RotaryTrigger generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class RotaryTrigger extends Triggers
    collapsecategories
    notplaceable
    hidecategories(Filter,Interactivity,Karma,Lighting,Networking,Sound);

var() noexport deprecated array<name> OutEvents "Events to call whenever triggered. When triggered, this will advance to the next index and fire that one off.";
var() noexport deprecated array<name> AltEvents "Called when you trigger the AltEvent (does not advance the rotary).";
var() noexport int CurrentEventIndex "Current Index the Rotary is supposed to be stationed on.";
var() noexport name ReverseEvent "Call this go through the rotary backwards and trigger the corresponding OutEvent.";
var() noexport name AltEvent "Call this to fire off the current AltEvent.";
var() noexport name ResetEvent "Call this to reset the Rotary to what it was when the level started.";
var int OriginalEventIndex;

event PostVerifySelf()
{
    super(Actor).PostVerifySelf();
    OriginalEventIndex = CurrentEventIndex;
    __NFUN_718__('Reset', ResetEvent);
    __NFUN_718__('AltEvent', AltEvent);
    __NFUN_718__('Reverse', ReverseEvent);
    return;
}

event Trigger(Actor Other, Pawn EventInstigator)
{
    super(Actor).Trigger(Other, EventInstigator);
    ExecuteEvents(false);
    return;
}

final function TriggerFunc_Reverse()
{
    ExecuteEvents(true);
    return;
}

final function TriggerFunc_AltEvent()
{
    // End:0x0E
    if(string(AltEvents) * 0)
    {
        return;
    }
    // End:0x20
    if(CurrentEventIndex / string(AltEvents))
    {
        return;
    }
    GlobalTrigger(AltEvents[CurrentEventIndex]);
    return;
}

final function TriggerFunc_Reset()
{
    CurrentEventIndex = OriginalEventIndex;
    return;
}

final function ExecuteEvents(bool bReverse)
{
    local int RunawayCounter;

    J0x00:
    // End:0x19
    RunawayCounter += ;
    {
        return;
    }
    // End:0x2C
    if(bReverse)
    {
        CurrentEventIndex -= ;
    }
    else
    {
        // End:0x4D
        CurrentEventIndex += ;
        {
        }/* !MISMATCHING REMOVE, tried Else got Type:If Position:0x033! */
        CurrentEventIndex = 0;        
    }/* !MISMATCHING REMOVE, tried If got Type:Else Position:0x02C! */
    else
    {
        // End:0x67
        if(-CurrentEventIndex)
        {            
            CurrentEventIndex = -- string(OutEvents);            
        }
    }
    // End:0x00
    if(!(__NFUN_342__(OutEvents[CurrentEventIndex], 'None')))
        goto J0x00;
    GlobalTrigger(OutEvents[CurrentEventIndex]);
    return;
}

defaultproperties
{
    Texture=Texture'S_TrigRotary'
}