/*******************************************************************************
 * SoftParticleSystem generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class SoftParticleSystem extends ParticleSystemBase
    native
    collapsecategories
    notplaceable
    hidecategories(Filter,HeatVision,Interactivity,KarmaObject,KarmaOverride,Networking)
    nativedestructor;

enum EPLightingType
{
    PLT_NoLight,
    PLT_PerSystem,
    PLT_PerParticle
};

enum EParticleDetail
{
    PD_High,
    PD_Medium,
    PD_Low
};

enum ESoftParticleSystemTriggerType
{
    SPT_None,
    SPT_Enable,
    SPT_Disable,
    SPT_Toggle,
    SPT_Pulse,
    SPT_UpdateEnable,
    SPT_UpdateDisable,
    SPT_UpdateToggle,
    SPT_UpdatePulse,
    SPT_Prime,
    SPT_TimeWarpEnable,
    SPT_TimeWarpDisable,
    SPT_TimeWarpToggle,
    SPT_TimeWarpPulse,
    SPT_TimeWarpPulseUp,
    SPT_PulseOnce
};

enum EMaxParticleTest
{
    PMAXTEST_Skip,
    PMAXTEST_Random,
    PMAXTEST_Oldest
};

enum EParticleSpawnShape
{
    PSHAPE_None,
    PSHAPE_Sphere,
    PSHAPE_Cone,
    PSHAPE_MuzzleCone,
    PSHAPE_SphereEdge,
    PSHAPE_ConeEdge
};

enum EParticleVolumeResponse
{
    PVR_AlwaysSpawn,
    PVR_OnlyWater,
    PVR_OnlyNonWater
};

enum EFriendStyle
{
    FRIEND_All,
    FRIEND_OneRandom,
    FRIEND_OneLinear
};

enum EPSoundType
{
    PST_ParticleCreated,
    PST_ParticleDied,
    PST_ParticleBounced
};

enum EPSystemSoundType
{
    PSST_SystemCreated,
    PSST_SystemDestroyed,
    PSST_SystemEnabled,
    PSST_SystemDisabled,
    PSST_SystemTriggered
};

struct SPRenderData
{
    var float SortKey;
    var int SpawnNumber;
    var Vector Velocity;
    var float Rotation;
    var Rotator Rotation3d;
    var Vector Location;
    var Vector PreviousLocation;
    var float CurTextureScaleX;
    var float CurTextureScaleY;
    var float MidTextureScaleX;
    var float MidTextureScaleY;
    var float Alpha;
    var float DrawScale;
    var float Lifetime;
    var float RemainingLifetime;
    var float RotationInitial;
    var Rotator RotationInitial3d;
    var PointRegion Region;
    var MaterialEx Texture;
    var const editconst transient nontrans pointer TexAnimController;
};

struct Particle
{
    var float SortKey;
    var int SpawnNumber;
    var Vector Velocity;
    var float Rotation;
    var Rotator Rotation3d;
    var Vector Location;
    var Vector PreviousLocation;
    var float CurTextureScaleX;
    var float CurTextureScaleY;
    var float MidTextureScaleX;
    var float MidTextureScaleY;
    var float Alpha;
    var float DrawScale;
    var float Lifetime;
    var float RemainingLifetime;
    var float RotationInitial;
    var Rotator RotationInitial3d;
    var PointRegion Region;
    var MaterialEx Texture;
    var const editconst transient nontrans pointer TextureAnimControllers;
    var float SystemSizeScale;
    var SoftParticleSystem ControllerSystem;
    var bool RespectControllerSystem;
    var bool HaveCollisionActor;
    var bool PhysicsTerminated;
    var bool ParticleCollidesWithWorld;
    var bool OscillateDir;
    var bool SkipControllerDelta;
    var Vector Acceleration;
    var float LinearDamping;
    var float AngularDamping;
    var float RotationVelocity;
    var float RotationAcceleration;
    var Rotator RotationVelocity3d;
    var Rotator RotationAcceleration3d;
    var PhysicsVolume PhysVolume;
    var float InitialAlpha;
    var float AlphaMid;
    var float FinalAlpha;
    var float NextFrameDelay;
    var int OscillateCount;
    var float PRandomFriendsTimer;
    var float InitialDrawScale;
    var float MidDrawScale;
    var float FinalDrawScale;
    var float DrawScaleMidLife;
    var float InitialTextureScaleX;
    var float FinalTextureScaleX;
    var float InitialTextureScaleY;
    var float FinalTextureScaleY;
    var Actor Base;
};

struct AdditionalSpawnStruct
{
    var() noexport class<Actor> SpawnClass "Class to spawn.";
    var() noexport bool TakeParentTag "Spawned actor will take the tagname of it's parent.";
    var() noexport bool Mount "Mount actor to myself.";
    var() noexport Vector MountOrigin "Origin if not on top of.";
    var() noexport Rotator MountAngles "Angles if not on top of.";
    var() noexport Object.EMountType MountType "How to mount the actor to myself.";
    var() noexport name AppendToTag "Append to the tag, dammit!";
    var() noexport Rotator SpawnRotation "Range of rotation to give to this actor.";
    var() noexport Rotator SpawnRotationVariance "The spawn rotation will vary by this amount.";
    var() noexport bool SpawnRotationNotRelative "The spawn rotation is not relative to this actor.";
    var() noexport float SpawnSpeed "Gives the spawned actor a velocity of this magnitude in the direction of it's rotation.";
    var() noexport float SpawnSpeedVariance "This amount times a random number from -1 to 1 will be added to the speed.";
    var() noexport bool DestroyOnDeath "Destroy this spawned actor when this particle system dies.";
    var() noexport float SpawnDelay "Delay this additional spawn by this much";
    var() noexport int MaxConcurrentSpawns "Maximum number of these guys that can exist at once.  0 means no limit.";
    var array<Actor> SpawnedActors;
};

struct SRequestingParticleInfo
{
    var() noexport bool bMatchLocation "When true, the spawned particle will match the location of the particle that requested it after being spawned.";
    var() noexport bool bMatchRotation "When true, the spawned particle will match the rotation of the particle that requested it after being spawned.";
    var() noexport bool bMatchScale "When true, the spawned particle will match the scale of the particle that requested it after being spawned.";
    var() noexport bool bRelativeVelocity "When true, the spawned particle will adjust it's velocity based on the difference of the requesting particle's rotation and it's own rotation.";
    var() noexport bool bRelativeAcceleration "Same as velocity, but for acceleration.";
    var() noexport bool bInheritVelocity "When true, the spawned particle will adjust it's velocity based on the requesting particle's velocity.";
    var() noexport bool bInheritAcceleration "When true, the spawned particle will adjust it's acceleration based on the requesting particle's acceleration.";
};

struct SFriendInfo
{
    var() noexport SRequestingParticleInfo RequestingParticleInfo "Information applied when a specific particle requests the new particle, as opposed to just a system.";
    var() noexport SoftParticleSystem.EParticleVolumeResponse VolumeResponse "Controls what types of volumes particles can spawn in.  This is a bit of an optimization because it checks before the particles are spawned and uses cached information instead of doing a lookup.";
    var() noexport bool bFireAndForget "If this is true, the particle will be spawned by its controller system, but from then on it will no longer have any knowledge of its controller's movements or location.";
    var() noexport float SpawnChance "Percentage chance that this friend info will successfully execute. Value from 0 to 1.";
    var() noexport int SpawnCount "Each time a particle requests a friend to join the party, how many of them to request.";
    var() noexport int SpawnCountVariance "How many the SpawnCount can vary by.";
    var() noexport class<SoftParticleSystem> FriendClass "The class to use as this friend generator.";
    var() noexport float FriendDelay "Time in seconds before this friend can go.";
    var() noexport float FriendDuration "Time in seconds after this friend has started before it can't go anymore.";
    var() noexport bool bUseParticleTime "If true, FriendDelay and FriendDuration will be matched against the particle's life time instead of the system.";
    var SoftParticleSystem FriendActor;
};

struct SFriendData
{
    var() noexport SoftParticleSystem.EFriendStyle FriendStyle "Method to use for picking and spawning friends.";
    var() noexport array<SFriendInfo> FriendInfos "Actual different friends and their setups to use.";
    var int FriendIndex;
    var bool bDisabled;
    var float FriendDuration;
    var float FriendDelay;
};

struct SNamedFriendData
{
    var() noexport SFriendData FriendData "The data to execute when this name is specified.";
    var() noexport name FriendName "Unique name to identify this friend data when you want to have it executed. SysCreationFriend, SysDeathFriend, SysTriggeredFriend are some prefabs available to hand created systems.";
};

struct SSupportedSystem
{
    var int SupportedCount;
    var SoftParticleSystem SupportedSystem;
};

struct SPTransientSound
{
    var() noexport bool bIgnoreVelocity "If this is true, then the sound will NOT take the velocity of the particle at playtime and apply it to itself.";
    var() noexport SoftParticleSystem.EPSoundType ParticleSoundType "Defines when you want this sound to occur";
    var() noexport SSoundInfo ParticleSound "The actual sound you want played and all the associated properties.";
};

struct SPStopSound
{
    var() noexport SoftParticleSystem.EPSoundType ParticleSoundType "Defines when you want these SoundSlots to be stopped during Particle actions.";
    var() noexport array<Object.ESoundSlot> ParticleSoundSlots "The actual SoundSlots you want stopped.";
};

struct SPSystemAmbientSound
{
    var() noexport SoftParticleSystem.EPSystemSoundType SystemSoundType "Defines when you want this ambient sound to occur during System actions.";
    var() noexport SAmbientSoundInfo SystemSound "The actual ambient sound you want played and all the associated properties.";
};

struct SPSystemTransientSound
{
    var() noexport bool bPlayRelative "If this is true, then the sound will not be overriden at playtime to be positioned in the world where the system is and stay there... it will instead move with the system wherever it goes.";
    var() noexport bool bIgnoreVelocity "If this is true, then the sound will NOT take the velocity of the system at playtime and apply it to itself.";
    var() noexport SoftParticleSystem.EPSystemSoundType SystemSoundType "Defines when you want this sound to occur during System actions.";
    var() noexport SSoundInfo SystemSound "The actual sound you want played and all the associated properties.";
};

struct SPSystemStopSound
{
    var() noexport SoftParticleSystem.EPSystemSoundType SystemSoundType "Defines when you want these SoundSlots to be stopped during System actions.";
    var() noexport array<Object.ESoundSlot> SystemSoundSlots "The actual SoundSlots you want stopped.";
};

struct SPColorTimePoint
{
    var() noexport float LifeScale "Value 0.0-1.0 when particles will be fully this color.";
    var() noexport Color LifeColor "Color at lifescale.";
};

var(pSystem) noexport bool Enabled "Whether particle spawning is enabled.";
var(pSystem) noexport bool UpdateEnabled "Whether or not to enable updating.";
var(pSystem) noexport bool DestroyWhenEmpty "Self destruct when no particles remain.";
var(pSystem) noexport bool DestroyWhenEmptyAfterSpawn "Destroys the particle system when empty IF at least one particle has been spawned since it's creation.";
var(pSystem) noexport bool SaveParticles "Whether or not to save the particles in this system during a save game.";
var(pSystem) noexport bool bBoundParticles "If true, particle's collision radius will be updated to encompass all particles.";
var(pSystem) noexport bool DisableTickWhenEmpty "If true, then disable ticking when the particle system is empty, and re-enable when it has new particles again.";
var(pSystem) noexport bool UpdateRateEnforced "If true, then the system will be forced to update at a consistent rate, even if the game is currently running slower (or faster) than those values. This will cause multiple internal updates, so use with caution.";
var(pSystem) noexport bool bMovedUpdatesCurrentPosition "If true, then whenever the particle system is moved, it will force itself to update the CurrentUpdateLocation and CurrentUpdateRotation immediately.";
var(pSystem) noexport bool bCopyStandardOwnerProperties "If this is true, then when spawned in, it will force the particle system to copy the lighting (and other) properties from the owner. Otherwise just use our defaults no matter what";
var(pSystem) noexport bool bDisableOnDismount "Disable this system on dismount.";
var(pSystem) noexport bool bSetDestroyWhenEmptyOnDismount "If true, when this system is dismounted from an Actor, DestroyWhenEmpty will be set to true.";
var(pAdditionalSpawn) noexport bool AdditionalSpawnTakesOwner "Spawned actors take my owner and owner related visibility.";
var(pAdditionalSpawn) noexport bool bAdditionalSpawnOnTrigger "When true, spawn additional stuff whenever we get triggered.";
var(pAdditionalSpawn) noexport bool bAdditionalSpawnOnSpawn "When true, spawn additional stuff when the particle system spawns.";
var bool bAdditionalSpawnStarted;
var(pSounds) bool bDontAutoPlayCreationSounds;
var(pSpawnPrime) noexport bool PrimeOnSpawn "Spawns the prime particles on startup.";
var(pSpawnInfo) noexport bool bOscillateLifetime "If true, particles will never die, but rather oscillate";
var(pSpawnPosition) noexport bool bSpawnOnGround "If true, move the particle spawn point onto the ground when system is created.  This effectively changes the SpawnOffset.";
var(pSpawnPosition) noexport bool bSpawnOnGround_DieNoGround "If true and using bSpawnOnGround, if a particle is unable to find the ground within SpawnOnGroundLength, the particle will be destroyed.";
var(pSpawnPosition) noexport bool bSpawnAtOrigin "Spawn at the particle system's origin, even if we have a collision radius / height.";
var(pSpawnPosition) noexport bool SpawnInALine "If true, particles will spawn in a line along the actor's direction.";
var(pSpawnPosition) noexport bool SpawnAtApex "Particles will spawn at the apex.";
var(pSpawnPosition) noexport bool SpawnAtRadius "Particles will be spawned at the maximum radial extent (ie on the radius circle).";
var(pSpawnPosition) noexport bool SpawnAtHeight "Particles will be spawned at the maximum height extent (ie on the box).";
var(pSpawnPosition) noexport bool SpawnAtExistingParticle "Randomly pick an existing particle and spawn on top of it.";
var(pPhysicsRelativity) noexport bool RelativeSpawn "Particles all spawn relative to the SoftParticleSystem actor's rotation, but behave independantly afterwards.";
var(pPhysicsRelativity) noexport bool RelativeSpawnAcceleration "Particle acceleration will be relative to the SoftParticleSystem's rotation at the time the the particle spawns.";
var(pPhysicsRelativity) noexport bool RelativeSpawnVelocity "Particle velocity will be relative to the SoftParticleSystem's rotation at the time the particle spawns.";
var(pPhysicsRelativity) noexport bool RelativeLocation "Particles all move relative to the parent ParticleSystemActor.";
var(pPhysicsRelativity) noexport bool RelativeRotation "Particles all move their location relative to the parent ParticleSystemActor.";
var(pPhysicsRelativity) noexport bool RelativeRotation3D "Particles all rotate their physical rotation relative to the parent ParticleSystemActor.";
var(pPhysicsRelativity) noexport bool RelativeRotationToMove "Particles will rotate relative to their motion.";
var(pPhysicsRelativity) noexport bool RelativeMoveToRotation "Particles will move relative to their rotation. Only uses Rotation3d.";
var(pPhysicsRelativity) noexport bool RelativeRealtimeAccelerationVariance "Particles will alter their Acceleration in realtime relative to the parent system.";
var(pPhysicsRelativity) noexport bool RelativeRealtimeVelocityVariance "Particles will alter their velocity in relatime relative to the parent system.";
var(pPhysics) noexport bool bAllowEffectors "If true, particle system can be affected by ParticleEffectors (Not ParticleAffectors!)";
var(pPhysics) noexport bool bAggressivePhysicsDisable "If this is set to TRUE, then the particle won't even update when it's physics have been terminated due to coming to rest on something. WARNING: This forces *extremely* aggressive system update disabling. Lifetime, animation, etc. won't happen.";
var(pPhysics) noexport bool bInheritMountParentPhysicsVelocity "If true, the particles that spawn will add linear velocity at point of the mount parent to their velocity.  Only works if MountParent is PHYS_Meqon.";
var(pPhysicsCollision) noexport bool Bounce "If the particle should bounce at the control's Z-Height when not colliding with world.";
var(pPhysicsCollision) noexport bool DieOnBounce "Destroys the particle when it bounces off the world or the Z-Height when Bounce is true.";
var(pPhysicsCollision) noexport bool ParticlesCollideWithWorld "If the particles actually collide with the world.";
var(pZoneInfo) noexport bool WaterZoneOnly "Restrict the particle system to water PhysicsVolume.";
var(pZoneInfo) noexport bool WaterZoneDie "The particle dies if it enters a water PhysicsVolume.";
var(pZoneInfo) noexport bool UseZoneGravity "Whether to use the PhysicsVolume gravity in acceleration computations.";
var(pZoneInfo) noexport bool UseZoneVelocity "Whether to use PhysicsVolume velocity in acceleration computations.";
var(pZoneInfo) noexport bool UseZoneFluidFriction "Use PhysicsVolume fluid friction.";
var(pZoneInfo) noexport bool UseZoneTerminalVelocity "Use PhysicsVolume terminal velocity.";
var(pZoneInfo) noexport bool DieOutsideWorld "When this is true, the particle will die if it ever goes outside the world.";
var(pZoneInfo) noexport bool DieZoneNotRendered "When true, the particle will die after the zone it is in hasn't been rendered for DieZoneNotRenderedTime.";
var(pFlocking) noexport bool FlockMountToCenter "Mount particle system actor to the center of the flock.";
var(pFlocking) noexport bool FlockMountToDirection "Face particle system actor in the same direction as the flock.";
var(pTexAlpha) noexport bool bSpawnOnGround_ScaleAlpha "If true and using bSpawnOnGround, the overall alpha of a particle will be scaled down depending on how far the ground is.  The further the ground, the more transparent it will be.";
var(pTexAlpha) noexport bool bSpawnOnGround_ScaleAlphaInverse "Reverses the effect of bSpawnOnGround_ScaleAlpha  Instead, the further the ground is, the more opaque it becomes.";
var(pTexAlpha) bool AlphaStartUseSystemAlpha;
var(pTexAlpha) noexport bool bUseAlphaRamp "Whether or not to consider the mid value in alpha ramping.";
var(pTexLines) noexport bool UseLines "true if use lines instead of textures/meshes.";
var(pTexLines) noexport bool Connected "true if lines are connected.";
var(pTexLines) noexport bool ConstantLength "true if lines length is completely based off draw scale.  Doesn't work when connected is set.";
var(pTexInfo) noexport bool bLockPitch "If true, particles will lock to pitch of main particle system";
var(pTexInfo) noexport bool bLockYaw "If true, particles will lock to yaw of main particle system";
var(pTexInfo) noexport bool bLockRoll "If true, particles will lock to roll of main particle system";
var(pTexInfo) noexport bool bRandomFlipTextureX "Randomly flip the texture along the x-axis.";
var(pTexInfo) noexport bool bRandomFlipTextureY "Randomly flip the texture along the y-axis.";
var(pTexInfo) noexport bool SynchAnimFrame "If true and using animated textures, all particles will be on the same frame instead of doing their own thing.  This can help render performance greatly when you have a lot of frames of animation.";
var(pTexInfo) noexport bool DieOnLastFrame "If this particle dies on the last frame of the texture.";
var(pTexInfo) noexport bool CorrectBackfacingUVs "If true, does a dot product for each particle to make sure the texture isn't flipped when viewing the back side of a two-sided polygon.";
var(pTexInfo) noexport bool bOffsetByTextureSize "If true, each particle's spawn location is moved 1/2 it's texture width along the vOffsetSpawnDirection vector.";
var(pTexScale) noexport bool bUseDrawScaleRamp "Whether or not to consider the mid value in draw scale ramping.";
var(pSystemLOD) noexport bool UpdateWhenNotVisible "Whether to update particles even when the particle system actor is not visible.";
var(pSystemLOD) noexport bool bKillParticlesOnNotVisible "If true, kill all active particles as soon as this system becomes invisible.";
var(pSystemLOD) noexport bool bRePrimeOnVisible "If true, do PrimeTime when system becomes visible again.";
var(pSystemLOD) noexport bool bCullNonVisibleParticles "If true, then attempt to cull out non-visible particles even if part of the system is still visible.";
var(pTrigger) noexport bool TriggerOnSpawn "Trigger self when spawned.";
var(pTrigger) noexport bool TriggerOnDismount "Trigger self once when I dismount from my parent.";
var(pColActors) bool UseParticleCollisionActors;
var bool bInitialized;
var bool bPulsed;
var bool bWasVisible;
var const bool bHaveAnimatedTextures;
var const bool LastEnabled;
var const bool bParticlePhysicsDirty;
var const transient bool bPriming;
var private const bool bIsParticleFriend;
var const bool bIsFriendSpawner;
var bool EditorDeleteMe;
var bool EditorSystem;
var(pSystem) noexport bool bScaleByDrawScale "If true, will scale SystemSizeScale by DrawScale before applying it.  Does not use DrawScale3D.";
var(pSpawnInfo) noexport bool bMaintainSpawnOrder "If true, will sort by the order particles were spawned.";
var(pSpawnInfo) noexport bool bReverseSpawnOrder "If using bMaintainSpawnOrder, set this to true to reverse the sort order.";
var(pSpawnPosition) noexport bool SpawnAtRadiusSpacingRandom "IF SpawnAtRadius AND SpawnAtRadiusSpacing > 0 AND this is true, we'll randomly spawn them at the spawn points instead of sequentially";
var(pPhysics) noexport bool InitialVelocityAwayFromPoint "Base initial velocity";
var(pLighting) noexport bool bUseFakeLighting "If true, and a BumpShader is used on the particles, fake lighting will be applied to the particles";
var(pDamage) noexport bool bDamageOnlyWhenEnabled "If true, system must be enabled to cause damage.";
var int LastUpdateFrame;
var float EditorPulsingCountdown;
var float EditorGameTimeSeconds;
var(pSystem) noexport float DieOutsideRadius "Particles die when they leave this radius (when nonzero).";
var(pSystem) noexport int GroupID "ID of the group this particle system belongs to.";
var(pSystem) noexport Vector ExtraRenderMins "Amount to add to final render bounding box mins";
var(pSystem) noexport Vector ExtraRenderMaxs "Amount to add to final render bounding box maxs";
var(pSystem) noexport float fBoundInterval "If bBoundParticles = true, collision radius will be updated at this interval.";
var(pSystem) noexport float SystemSizeScale "Used primarily for shrinking the entire effect. Scales all appropriate values based on this number (velocity, texture sizes, etc).";
var(pSystem) const noexport float UpdateRateMax "Force system to never update at a rate slower than this. Never smaller than 100fps (0.01). This ensures the system will visually hold up even in lower framerates, but at the cost of being a bit slower since it has to do multiple updates to compensate.";
var(pSystem) const noexport float UpdateRateMin "Force system to never update at a rate faster than this. Only useful if you want a rigid update rate that never varies at all (so you would make it match UpdateRateMax). Is not allowed to be larger than UpdateRateMax. 0.0 means use internal rate.";
var(pSystem) noexport float ZoneUpdateRate "How frequently to update the ZoneInfo/PhysicsVolume information for this system.";
var(pAdditionalSpawn) array<AdditionalSpawnStruct> AdditionalSpawn;
var(pFriendP) noexport SFriendData PCreationFriends "Friends to spawn when a particle is created.";
var(pFriendP) noexport SFriendData PDeathFriends "Friends to spawn when a particle is destroyed.";
var(pFriendP) noexport SFriendData PBounceFriends "Friends to spawn when a particle bounces.";
var(pFriendP) noexport SFriendData PRandomFriends "Friends to spawn randomly during a particle's lifetime.";
var(pFriendP) noexport float PRandomFriendsRate "How frequently during the particle's lifetime to spawn the random friends.";
var(pFriendP) float PRandomFriendsRateVariance;
var(pFriendSys) array<SNamedFriendData> NamedFriends;
var(pFriendSys) noexport SFriendData SysRandomFriends "Friends to spawn randomly during the particle systems's lifetime.";
var(pFriendSys) noexport float SysRandomFriendsRate "How frequently during the system's lifetime to spawn the random friends.";
var(pFriendSys) float SysRandomFriendsRateVariance;
var(pSounds) noexport int MaxBounceSounds "Max number of sounds you can have playing at one time before allowing another bounce sound to play.";
var(pSounds) noexport array<SPTransientSound> ParticleSounds "List of sounds you want played by individual particles.";
var(pSounds) noexport array<SPStopSound> ParticleStopSounds "List of sound slots you want to be stopped by individual particle actions.";
var(pSounds) noexport array<SPSystemAmbientSound> ParticleSystemAmbientSounds "List of ambient sounds you want played by this system.";
var(pSounds) noexport array<SPSystemTransientSound> ParticleSystemSounds "List of sounds you want played by this system.";
var(pSounds) noexport array<SPSystemStopSound> ParticleSystemStopSounds "List of sound slots you want to be stopped by system actions.";
var(pSpawnPrime) noexport int PrimeCount "Number of particles spawn immedietely when the particle system is created.";
var(pSpawnPrime) noexport float PrimeTime "Amount of time to 'Prime' the texture with - note that priming works even when UpdateEnabled is false.";
var(pSpawnPrime) noexport float PrimeTimeIncrement "Time increment for above  - note that priming works even when UpdateEnabled is false.";
var(pSpawnInfo) noexport int SpawnNumber "Number of particles to spawn.";
var(pSpawnInfo) noexport float SpawnPeriod "Period at which to spawn them.";
var(pSpawnInfo) noexport int MaximumParticles "Maximum particles that this system will allocate.";
var(pSpawnInfo) noexport float Lifetime "Time to live in seconds, 0 if forever.";
var(pSpawnInfo) noexport float LifetimeVariance "Lifetime varies by +/- this many.";
var(pSpawnInfo) noexport float SpawnPeriodVariance "Max variance + or - in spawn period";
var(pSpawnInfo) noexport int SpawnNumberVariance "Max variance + or - in SpawnNumber.";
var(pSpawnInfo) noexport SoftParticleSystem.EMaxParticleTest MaxSpawnLimitTest "How to handle spawning a new particle when the MaximumParticles limit is reached.";
var(pSpawnInfo) noexport int OscillateLifetimeCount "How many times to oscillate the lifetime when bOscillateLifetime is true. 0 means go forever.";
var(pSpawnInfo) int OscillateLifetimeCountVariance;
var(pSpawnPosition) noexport Vector SpawnOffset "Amount to offset all spawning physics from actor center.";
var(pSpawnPosition) noexport Vector SpawnOffsetVariance "Amount to vary the SpawnOffset by.";
var(pSpawnPosition) noexport Vector SpawnOffsetPost "Amount to offset the particle by after all other positioning information has occured.";
var(pSpawnPosition) noexport Vector SpawnOffsetPostVariance "Amount to vary the SpawnOffsetPost by.";
var(pSpawnPosition) noexport float SpawnInALineLength "Half the length of the line to spawn along.";
var(pSpawnPosition) noexport float SpawnOnGroundLength "How far to trace downward when attempting to spawn on the ground. If no ground is reached the particle will be moved downward this far.";
var(pSpawnPosition) noexport int SpawnAtRadiusSpacing "If Spawn at radius, we'll space them this many UNREAL ANGLE UNITS apart.";
var(pPhysics) noexport Vector InitialVelocityAwayFromPointOffset "Base initial velocity";
var(pPhysics) noexport Vector InitialVelocity "Base initial velocity";
var(pPhysics) noexport Vector InitialAcceleration "Base initial acceleration.";
var(pPhysics) noexport Vector MaxVelocityVariance "Maximum initial Velocity variance (+/- this amount)";
var(pPhysics) noexport Vector MaxAccelerationVariance "Maximum acceleration variance (+/-) this amount.";
var(pPhysics) noexport Vector RealtimeVelocityVariance "Maximum velocity variance (+/-) this amount per second in realtime.";
var(pPhysics) noexport Vector RealtimeAccelerationVariance "Maximum acceleration variance (+/-) this amount per second in realtime.";
var(pPhysics) noexport float LocalFriction "My own local friction, zero by default.";
var(pPhysics) noexport float SlideFriction "Amount of energy lost (per second) when a particle collides.  0 = no energy is lost,  0.5 = half energy is lost, 1.0 = all energy lost.  LocalFriction will still affect the particle's speed in addition to this.";
var(pPhysics) noexport float KLinearDampingVariance "How much to vary KLinearDamping by.";
var(pPhysics) noexport float KAngularDampingVariance "How much to vary KAngularamping by.";
var(pPhysicsCollision) noexport float BounceElasticity "How much energy is retained after each bounce.";
var(pPhysicsCollision) noexport Vector BounceVelocityVariance "Amount by which bounce may randomly alter the velocity of bouncing things.";
var(pPhysicsCollision) noexport float ParticlesCollidePercent "When ParticlesCollideWithWorld is true, the percent of the particles that will actually collide. Value from 0 to 1. If left as 0, then will auto assume 1.";
var(pPhysicsCollision) noexport float ParticleCollisionRadius "How large a particle's collision size is considered to be for collision with the world. This is based off the texture being at a scale of 1.0 and is then adjusted from there. This helps prevent particles being clipped halfway through the world.";
var(pPhysicsCollision) noexport float PhysicsTimeoutThreshold "How long a particle can sit in one place before the physics are auto-terminated, even if they for some reason haven't managed to hit the ground.";
var(pPhysicsApex) noexport Vector Apex "Apex. Relative offset from particle system location. Bounce uses relative Z of this.";
var(pPhysicsApex) noexport float ApexInitialVelocity "When not 0, this is the initial velocity added towards the apex.";
var(pPhysicsApex) float ApexInitialVelocityVariance;
var(pPhysicsApex) noexport float ApexInitialAcceleration "When not 0, this is the acceleration given towards the apex.";
var(pPhysicsApex) float ApexInitialAccelerationVariance;
var(pPhysicsApex) noexport name ApexActorTag "When not None, the apex will take it's position from this actor.";
var(pZoneInfo) noexport name TagZoneOnly "Restrict the particle system to zones that match this tag.";
var(pZoneInfo) noexport float DieZoneNotRenderedTime "How long to wait after the zone the particle is currently in hasn't been rendered to kill the particle.";
var(pZoneInfo) noexport float ZoneGravityScaler "Scales the amount of force the zone's gravity applies to these particles by this much.";
var(pZoneInfo) noexport float ZoneVelocityScaler "Scales the amount of force the zone's velocity applies to these particles by this much.";
var(pFlocking) noexport float FlockToCenterVelocity "Velocity with which particles will move towards center.";
var(pFlocking) noexport float FlockToCenterAcceleration "Acceleration with which particles will move towards center.";
var(pFlocking) noexport float FlockToDirectionScale "Scale towards average direction.";
var(pFlocking) noexport float FlockCenterWeight "How many particles the particle system itself counts towards the center.";
var(pFlocking) noexport float FlockDirectionWeight "How many particles the particle system itself counts towards the direction.";
var(pPhysicsSineWave) noexport float SineWaveFrequency "Sine wave motion frequency - 0 disables";
var(pPhysicsSineWave) noexport Vector VelocityAmplitude "Amount of sine wave to apply to each velocity component.";
var(pPhysicsSineWave) noexport Vector AccelerationAmplitude "Amount of sine wave to apply to each acceleration component.";
var(pTexAlpha) noexport float SystemAlphaScale "Amount to scale the alpha of the entire system.";
var(pTexAlpha) noexport float SystemAlphaScaleVelocity "Rate at which SystemAlphaScale changes.";
var(pTexAlpha) noexport float SystemAlphaScaleAcceleration "Rate at which SystemAlphaAcceleration changes.";
var(pTexAlpha) noexport float AlphaVariance "+/- this amount of alpha at the start.";
var(pTexAlpha) noexport float AlphaStart "Initial alpha.";
var(pTexAlpha) noexport float AlphaMid "Middle alpha.";
var(pTexAlpha) noexport float AlphaMidVariance "+/- this amount of alpha at the mid.";
var(pTexAlpha) noexport float AlphaEnd "Ending alpha.";
var(pTexAlpha) noexport float AlphaEndVariance "+/- this amount of alpha at the end.";
var(pTexAlpha) noexport float AlphaRampMid "Where during the lifetime the alpha should consider the middle. 0-1";
var(pTexAlpha) noexport float EdgeFadeDist "The dist from wall edges where the particle will have its full alpha.  Set to 0 for no effect.  Only works when using STY_AlphaBlend.";
var(pTexLines) noexport Color LineStartColor "Color at the line's start.";
var(pTexLines) noexport Color LineStartColorVariance "+/- the color at the start of the line.";
var(pTexLines) noexport Color LineEndColor "Color at the line's end.";
var(pTexLines) noexport Color LineEndColorVariance "+/- the color at the end of the line.";
var(pTexLines) noexport float LineStartWidth "Starting line width.";
var(pTexLines) noexport float LineStartWidthVariance "+/- the width of the LineStart.";
var(pTexLines) noexport float LineEndWidth "Ending line width.";
var(pTexLines) noexport float LineEndWidthVariance "+/- the width of the LineEnd.";
var(pTexLines) noexport float LineWidthVariance "Variance applied to both the start and end of the line (calculated once per line)";
var(pTexMesh) noexport int MaxMeshParticles "Maximum number of mesh particles to exist at once under this system if bForceOwnMeshParticles is set.";
var(pTexMesh) noexport array<Mesh> Meshes "Random meshes to choose from.";
var(pTexMesh) noexport array<StaticMesh> StaticMeshes "Random static meshes to choose from.";
var(pTexInfo) noexport array<MaterialEx> Textures "Random textures to choose from.";
var(pTexInfo) noexport float AnimStopThreshold "If >0, stop animating the texture when below this velocity limit.";
var(pTexInfo) noexport float AnimRateScaler "Scales the animation rate of our textures by this much. Use to speed up or slow down an animated texture.";
var(pTexInfo) noexport Vector vOffsetSpawnDirection "Direction to offset the particle's spawn position if bOffsetByTextureSize is true.";
var(pTexInfo) noexport array<SPColorTimePoint> ColorOverTime "Points of color definining a changing color over time.";
var(pTexScale) noexport float StartDrawScale "Initial Draw Scale.";
var(pTexScale) noexport float EndDrawScale "Ending Draw Scale.";
var(pTexScale) noexport float DrawScaleMid "Draw scale to have at the middle of our lifetime.";
var(pTexScale) noexport float DrawScaleRampMid "Where during the particle's lifetime to consider the middle (0-1)";
var(pTexScaleVariance) noexport float DrawScaleVariance "+/- this amount to the initial drawscale of the particle.";
var(pTexScaleVariance) noexport float DrawScaleEndVariance "+/- this amount to the final drawscale of the particle. If this is less than 0, then DrawScaleVariance will be applied to both the start and end evenly.";
var(pTexScaleVariance) noexport float DrawScaleMidVariance "+/- this amount to the middle drawscale of the particle. If this is less than 0, then DrawScaleVariance will be applied to both the start and mid evenly.";
var(pTexScaleScaler) noexport float TextureScaleX "Additional amount to scale all particles in this system along the x texture axis.";
var(pTexScaleScaler) noexport float TextureScaleY "Additional amount to scale all particles in this system along the y texture axis.";
var(pTexScaleScaler) noexport float TextureScaleMidX "Middle scale on X texture axis.  TextureScaleMidRampX must be greater than 0 for this to apply.";
var(pTexScaleScaler) noexport float TextureScaleMidY "Middle scale on Y texture axis.  TextureScaleMidRampY must be greater than 0 for this to apply.";
var(pTexScaleScaler) noexport float TextureScaleMidRampX "Where to consider the middle for TextureScaleX calculation.";
var(pTexScaleScaler) noexport float TextureScaleMidRampY "Where to consider the middle for TextureScaleY calculation.";
var(pTexScaleScaler) noexport float TextureScaleEndX "Final scale on X texture axis.";
var(pTexScaleScaler) noexport float TextureScaleEndY "Final scale on Y texture axis.";
var(pTexScaleScaler) noexport float TextureScaleVarianceX "Max amount to vary initial scale on X texture axis.";
var(pTexScaleScaler) noexport float TextureScaleVarianceY "Max amount to vary initial scale on Y texture axis.";
var(pTexRotation) noexport float RotationInitial "Base initial particle rotation.";
var(pTexRotation) noexport float RotationVariance "Base rotation variance.";
var(pTexRotation) noexport float RotationVelocity "Rotation velocity.";
var(pTexRotation) noexport float RotationVelocityMaxVariance "Rotation velocity variance.";
var(pTexRotation) noexport float RotationAcceleration "Rate of rotation acceleration.";
var(pTexRotation) noexport float RotationAccelerationMaxVariance "Maximum rotation acceleration variance.";
var(pTexRotation3D) noexport Rotator RotationInitial3d "Base initial particle rotation.";
var(pTexRotation3D) noexport Rotator RotationVariance3d "Base rotation variance.";
var(pTexRotation3D) noexport Rotator RotationVelocity3d "Rotation velocity.";
var(pTexRotation3D) noexport Rotator RotationVelocityMaxVariance3d "Rotation velocity variance.";
var(pTexRotation3D) noexport Rotator RotationAcceleration3d "Rate of rotation acceleration.";
var(pTexRotation3D) noexport Rotator RotationAccelerationMaxVariance3d "Maximum rotation acceleration variance.";
var(pTexRotation3D) noexport Rotator RotationVarianceOnBounce3d "Amount to vary rotation on bounce.";
var(pTexRotation3D) noexport Rotator RestingRotation3D "Rotation to set the particle to when it comes to rest.";
var(pTexRotation3D) noexport Rotator RestingRotation3DVariance "Variance value to apply to the resting rotation.";
var(pLighting) noexport Color ParticleAmbientLight "Minimun intensity of the light at the particle system's origin";
var(pLighting) noexport Color FakeLightColor "Color to use for fake lighting if bUseFakeLighting is true";
var(pLighting) noexport float FakeLightIntensity "Intensity to use for fake lighting if bUseFakeLighting is true";
var(pSpawnActor) noexport float SpawnOnBounceChance "Percentage chance to spawn the below class on bounce.";
var(pSpawnActor) noexport class<Actor> SpawnOnBounce "Spawn this class on bounce.";
var(pSpawnActor) noexport float SpawnOnDeathChance "Percentage chance to spawn below actor on death.";
var(pSpawnActor) noexport class<Actor> SpawnOnDeath "Spawn this actor when the particle dies.";
var(pSystemLOD) noexport float fNotVisibleDelay "How long the particle system must go unrendered to be considered not visible.";
var(pSystemLOD) noexport int nRePrimeCount "Number of particles spawn immedietely when the particle system becomes visible after being invisible.";
var(pSystemLOD) noexport float fRePrimeTime "Amount of time to 'Prime' the system with with.";
var(pSystemLOD) noexport float fRePrimeTimeIncrement "Time increment for above.";
var(pSystemLOD) noexport SoftParticleSystem.EParticleDetail ParticleDetail "Under which detail levels is this particle system rendered?";
var(pTrigger) noexport float TriggerAfterSeconds "Trigger after this many seconds have elapsed.";
var(pTrigger) SoftParticleSystem.ESoftParticleSystemTriggerType TriggerType;
var(pTrigger) noexport float PulseSeconds "Seconds that the pulse is active for.";
var(pTrigger) noexport float PulseSecondsVariance "Number of seconds to vary the pulse duration by.";
var(pTrigger) noexport float PulseMagnitude "Peak magnitude of the pulse.";
var(pDamage) noexport float DamageAmount "Amount of damage to cause on spawn.";
var(pDamage) noexport float DamageRadius "Damage radius.";
var(pDamage) noexport class<DamageType> DamageName "Damage category class.";
var(pDamage) noexport float DamagePeriod "Rate at which damage is applied. 0=only on startup";
var(pColActors) int ParticlesPerCollision;
var(pColActors) int NumCollisionActors;
var(pColActors) class<ParticleCollisionActor> CollisionActorClass;
var(pSpawnPosition) noexport SoftParticleSystem.EParticleSpawnShape SpawnShape "Shape to use for determining the spawn positions of particles.";
var(pSpawnPosition) noexport Vector SpawnShapeScale "Scale to apply to spawn shape on local X, Y and Z axes.";
var(pSpawnPosition) noexport Rotator SpawnShapeRotation "Rotational offset to apply to the shape of the spawn.";
var float ZoneUpdateTime;
var float PulseStartTime;
var float PulseEndTime;
var float DamagePeriodRemaining;
var Actor ApexActor;
var Actor InheritVelocityActor;
var float fCurSpawnPeriod;
var int CurSpawnNumber;
var int nMinFlockNumber;
var int CurSpawnAtRadiusAngle;
var Vector AverageCenter;
var Vector AverageDirection;
var const float fOriginalCollisionHeight;
var const float fOriginalCollisionRadius;
var const int LowestDirtyParticle;
var const int CurrentSpawnNumber;
var const int ParticlesSinceCollision;
var const int UsedCollisionActors;
var const float ElapsedTime;
var const transient int HighestParticleNumber;
var const transient int AllocatedParticles;
var const editconst transient nontrans pointer ParticleSystemHandle;
var const transient Vector BoundingBoxMin;
var const transient Vector BoundingBoxMax;
var const float fNextBoundTime;
var const ParticleEffector m_pEffector;
var const float SysRandomFriendsTimer;
var const float PhysicsTimeoutTimer;
var const float SystemLifetime;
var const array<ParticleCollisionActor> CollisionActors;
var const array<SSupportedSystem> SupportedSystems;
var const array<SoftParticleSystem> FriendSystems;
var const Vector PreviousLocation;
var const Rotator PreviousRotation;
var const Vector CurrentUpdateLocation;
var const Rotator CurrentUpdateRotation;
var const Vector CurrentDeltaLocation;
var const Rotator CurrentDeltaRotation;
var const Vector ThisDeltaLocation;
var const Rotator ThisDeltaRotation;
var const float CurrentDeltaPeriod;
var float UpdateCapOverride;
var array<Actor> VolumeActors;
var array<SoftParticleSystem> EditorSpawns;
var const editconst transient nontrans array<transient pointer> PendingDeleteTextureAnimControllers;
var int CacheRenderParticleNumber;
var int AllocatedRenderData;
var const editconst transient nontrans pointer ParticleRenderDataHandle;
var array<int> PendingDeleteParticles;
var float SystemSizeScaleScale;
var float LifetimeScale;
var float FakeLightIntensityOverride;

replication
{
    // Pos:0x000
    reliable if(int(Role) % int(ROLE_Authority))
        Enabled, UpdateEnabled;
}

// Export USoftParticleSystem::execForceTick(FFrame&, void* const)
native(1033) final simulated function ForceTick(float DeltaSeconds);

// Export USoftParticleSystem::execResetParticles(FFrame&, void* const)
native(1034) final simulated function ResetParticles();

// Export USoftParticleSystem::execFreeParticle(FFrame&, void* const)
native(1035) final simulated function FreeParticle(int i);

// Export USoftParticleSystem::execGetParticle(FFrame&, void* const)
native(1036) final simulated function bool GetParticle(int i, out Particle P);

// Export USoftParticleSystem::execSetParticle(FFrame&, void* const)
native(1037) final simulated function bool SetParticle(int i, out Particle P);

// Export USoftParticleSystem::execSpawnParticle(FFrame&, void* const)
native(1038) final simulated function int SpawnParticle(optional int Count);

// Export USoftParticleSystem::execSpawnParticleEx(FFrame&, void* const)
native(1039) final simulated function SpawnParticleEx(SoftParticleSystem RequestingParticleSystem, out Particle RequestingParticle, SRequestingParticleInfo RequestingParticleInfo);

// Export USoftParticleSystem::execDrawParticles(FFrame&, void* const)
native(1040) final simulated function DrawParticles(Canvas C);

// Export USoftParticleSystem::execDestroyParticleCollisionActors(FFrame&, void* const)
native(1041) final simulated function DestroyParticleCollisionActors();

// Export USoftParticleSystem::execDoAdditionalSpawn(FFrame&, void* const)
native(1042) final simulated function DoAdditionalSpawn();

// Export USoftParticleSystem::execPrimeParticles(FFrame&, void* const)
native(1043) final simulated function PrimeParticles(float fTotalTime, float fIncrement);

// Export USoftParticleSystem::execInitFriendData(FFrame&, void* const)
native(1044) final simulated function InitFriendData(SFriendData FriendData);

// Export USoftParticleSystem::execSetUpdateRate(FFrame&, void* const)
native(1045) final simulated function SetUpdateRate(float NewMaxRate, float NewMinRate);

// Export USoftParticleSystem::execNativeInitializeParticleSystem(FFrame&, void* const)
native(1046) final simulated function bool NativeInitializeParticleSystem();

// Export USoftParticleSystem::execPlayParticleSystemSounds(FFrame&, void* const)
native(1047) final simulated function PlayParticleSystemSounds(SoftParticleSystem.EPSystemSoundType SystemSoundType);

// Export USoftParticleSystem::execInitializeParticleSystem(FFrame&, void* const)
native(1048) final simulated function InitializeParticleSystem(bool bInitialSpawn);

// Export USoftParticleSystem::execParticleHurtRadius(FFrame&, void* const)
native(1049) final simulated function ParticleHurtRadius();

// Export USoftParticleSystem::execDoPrimeSpawn(FFrame&, void* const)
native(1050) final simulated function DoPrimeSpawn();

// Export USoftParticleSystem::execInitializeFriends(FFrame&, void* const)
native(1051) final simulated function InitializeFriends();

// Export USoftParticleSystem::execResetParticleSystem(FFrame&, void* const)
native(1052) final simulated function ResetParticleSystem();

// Export USoftParticleSystem::execDelayedActivityInternal(FFrame&, void* const)
native(1053) final simulated function DelayedActivityInternal();

// Export USoftParticleSystem::execForceSelfDisabled(FFrame&, void* const)
native(1054) final simulated function ForceSelfDisabled();

// Export USoftParticleSystem::execForceSelfEnabled(FFrame&, void* const)
native(1055) final simulated function ForceSelfEnabled();

// Export USoftParticleSystem::execStopFlocking(FFrame&, void* const)
native(1056) final simulated function StopFlocking();

// Export USoftParticleSystem::execSetUpdateWhenNotVisible(FFrame&, void* const)
native(1057) final simulated function SetUpdateWhenNotVisible(bool inUpdateWhenNotVisible);

// Export USoftParticleSystem::execSetOwnerSeeSpecial(FFrame&, void* const)
native(1058) final simulated function SetOwnerSeeSpecial(bool OwnerSeeSpecial);

// Export USoftParticleSystem::execSetScaleFactor(FFrame&, void* const)
native(1059) final simulated function SetScaleFactor(float factor);

// Export USoftParticleSystem::execSetParticleSystemHidden(FFrame&, void* const)
native(1060) final simulated function SetParticleSystemHidden(bool Hidden);

// Export USoftParticleSystem::execSetDontReflect(FFrame&, void* const)
native(1061) final simulated function SetDontReflect(bool DontReflect);

// Export USoftParticleSystem::execSetAllOwner(FFrame&, void* const)
native(1062) final simulated function SetAllOwner(Actor NewOwner);

// Export USoftParticleSystem::execDoTrigger(FFrame&, void* const)
native(1063) final simulated function DoTrigger();

// Export USoftParticleSystem::execTriggeredActivities(FFrame&, void* const)
native(1064) final simulated function TriggeredActivities(bool bPlaySounds);

final simulated function DelayedActivity()
{
    __NFUN_1053__();
    return;
}

function CopyOwnerProperties()
{
    // End:0x0F
    if(bCopyStandardOwnerProperties)
    {
        super(Actor).CopyOwnerProperties();
    }
    return;
}

simulated event EnabledStateChange()
{
    // End:0x11
    if(Enabled)
    {
        __NFUN_1047__(2);        
    }
    else
    {
        __NFUN_1047__(3);
    }
    return;
}

simulated event Trigger(Actor Other, Pawn Instigator)
{
    local float f;
    local bool InitialEnabled;

    InitialEnabled = Enabled;
    switch(TriggerType)
    {
        // End:0x1D
        case 0:
            // End:0x2B4
            break;
        // End:0x2D
        case 1:
            Enabled = true;
            // End:0x2B4
            break;
        // End:0x3D
        case 2:
            Enabled = false;
            // End:0x2B4
            break;
        // End:0x54
        case 3:
            // End:0x2B4
            Enabled = Enabled / ;
        // End:0x59
        case 15:
        // End:0x13E
        case 4:
            // End:0x7C
            if((int(TriggerType) % int(15)) << bPulsed + true)
            {
                return;
            }
            bPulsed = true;
            /* Statement decompilation error: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
                
            */

            // End:0xFFFF
            /*@Error*/;
            // Failed to format nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
            // 29 & Type:Default Position:0x2B1
            // Failed to format remaining nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
            // 29 & Type:Default Position:0x2B1
}

// Export USoftParticleSystem::execScaleSoundRadius(FFrame&, void* const)
native(1065) simulated function float ScaleSoundRadius(bool bSpoken, float InRadius);

simulated event float ScaleSoundPitch(bool bSpoken, float InPitch)
{
    return Normal2D(InPitch *= Round(1, SystemSizeScale), FRand(InPitch, 0.5), FRand(InPitch, 1.5));
    return;
}

defaultproperties
{
    Enabled=true
    UpdateEnabled=true
    AdditionalSpawnTakesOwner=true
    bAdditionalSpawnOnSpawn=true
    PrimeOnSpawn=true
    UseZoneGravity=true
    SynchAnimFrame=true
    UpdateWhenNotVisible=true
    bWasVisible=true
    ExtraRenderMins=(X=-5,Y=-5,Z=-5)
    ExtraRenderMaxs=(X=5,Y=5,Z=5)
    fBoundInterval=0.5
    SystemSizeScale=1
    ZoneUpdateRate=0.2
    MaxBounceSounds=2
    PrimeTimeIncrement=0.05
    SpawnNumber=1
    SpawnPeriod=0.1
    Lifetime=1.1
    SpawnOnGroundLength=256
    InitialVelocity=(X=0,Y=0,Z=475)
    MaxVelocityVariance=(X=180,Y=180,Z=0)
    SlideFriction=0.1
    BounceElasticity=1
    ParticleCollisionRadius=24
    PhysicsTimeoutThreshold=2.5
    DieZoneNotRenderedTime=5
    ZoneGravityScaler=1
    ZoneVelocityScaler=1
    SystemAlphaScale=1
    AlphaStart=1
    AlphaEnd=1
    AlphaRampMid=0.5
    LineStartColor=(R=255,G=255,B=255,A=0)
    LineEndColor=(R=255,G=255,B=255,A=0)
    LineStartWidth=1
    LineEndWidth=1
    AnimStopThreshold=-1
    AnimRateScaler=1
    vOffsetSpawnDirection=(X=0,Y=0,Z=1)
    StartDrawScale=1
    EndDrawScale=1
    DrawScaleEndVariance=-1
    DrawScaleMidVariance=-1
    TextureScaleX=1
    TextureScaleY=1
    TextureScaleEndX=1
    TextureScaleEndY=1
    ParticleAmbientLight=(R=64,G=64,B=64,A=255)
    FakeLightColor=(R=255,G=255,B=255,A=0)
    FakeLightIntensity=2
    SpawnOnBounceChance=1
    SpawnOnDeathChance=1
    fNotVisibleDelay=0.25
    ParticleDetail=2
    TriggerType=3
    PulseSeconds=1
    DamageRadius=200
    DamageName='ExplosionDamage'
    SpawnShapeScale=(X=1,Y=1,Z=1)
    SystemSizeScaleScale=1
    LifetimeScale=1
    KLinearDamping=0
    KAngularDamping=0
    bTraceShootable=false
    bIsSoftParticleSystem=true
    bNoNativeTick=true
    bTickOnlyRecent=true
    bTickOnlyZoneRecent=true
    bTickOnlyNearby=false
    bLateTicker=true
    bAcceptsProjectors=false
    bAcceptsDecalProjectors=false
    bCastStencilShadows=false
    bUnlit=true
    DrawType=9
    AlphaSortGroup=8
    Texture='dt_editor.Icons.ParticleSystem'
    ActorColorList(0)=(ActorColor=(R=255,G=255,B=255,A=255),ActorColor_LightEx=none,ActorColor_LightExScale=(X=0,Y=0,Z=0),id=SystemColor)
    RemoteRole=0
    TransientSoundRadius=1024
    TransientSoundInnerRadius=512
}