/*******************************************************************************
 * TriggerAssignLightEx generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class TriggerAssignLightEx extends TriggerAssign
    collapsecategories
    notplaceable
    hidecategories(Filter,Interactivity,Karma,Lighting,Networking,Sound,Collision,Interpolation,movement);

struct STrackedLight
{
    var LightEx LightActor;
    var Vector LightFinalScale;
};

var() string FinalRedScaleString;
var() string FinalGreenScaleString;
var() string FinalBlueScaleString;
var() noexport float FinalScaleTotalTime "This is the total time it should take to execute the entire final light scale string.";
var() noexport deprecated name CompleteEvent "Fire this even off when the light string is done executing.";
var() noexport bool bRestoreLights "Restore lights to previous final color scale when completed?";
var() noexport bool bInterruptable "If this is true, then we can interrupt the TotalTimer before it is complete.";
var() noexport Object.EFloatModifier LightRadiusModifier "How to modify the LightRadius.";
var() noexport float NewLightRadius "New LightRadius.";
var() noexport Object.EVectModifier LightRadius3DModifier "How to modify the LightRadius3D.";
var() noexport Vector NewLightRadius3D "New LightRadius3D.";
var() noexport Object.EColorModifier LightColorModifier "How to modify the LightColor.";
var() noexport Color NewLightColor "New LightColor.";
var() noexport bool AssignLightStyle "Change the light style?";
var() noexport Object.ELightExStyle NewLightStyle "What you want the new LightStyle to be.";
var() noexport bool AssignLightPeriod "Change the LightPeriod?";
var() noexport byte NewLightPeriod "What you want the new LightPeriod to be.";
var() noexport bool AssignLightPhase "Change the LightPhase?";
var() noexport byte NewLightPhase "What you want the new LightPeriod to be.";
var() noexport Object.EColorModifier LightColorOriginalModifier "How to modify the OriginalColor of a TriggerLightEx.";
var() noexport Color NewLightColorOriginal "New OriginalColor of a TriggerLightEx.";
var() noexport Object.EColorModifier TurnOffColorModifier "How to modify the TurnOff of a TriggerLightEx.";
var() noexport Color NewTurnOffColor "New TurnOffColor of a TriggerLightEx.";
var bool bActive;
var float TimePerCharRed;
var float TimePerCharGreen;
var float TimePerCharBlue;
var float ElapsedTime;
var array<STrackedLight> TrackedLights;

function PostVerifySelf()
{
    super(Actor).PostVerifySelf();
    TickStyle = 0;
    return;
}

function DoAssign(Actor A)
{
    local LightEx l;
    local TriggerLightEx TL;

    super.DoAssign(A);
    l = LightEx(A);
    // End:0x1AF
    if(__NFUN_340__(l, none))
    {
        TrackedLights.Insert(0, 1);
        TrackedLights[0].LightActor = l;
        TrackedLights[0].LightFinalScale = l.FinalColorScale;
        l.LightRadius = __NFUN_348__(LightRadiusModifier, l.LightRadius, NewLightRadius);
        l.LightRadius3D = __NFUN_349__(LightRadius3DModifier, l.LightRadius3D, NewLightRadius3D);
        l.LightColor = __NFUN_353__(LightColorModifier, l.LightColor, NewLightColor);
        // End:0xFF
        if(AssignLightStyle)
        {
            l.LightStyle = NewLightStyle;
        }
        // End:0x11D
        if(AssignLightPeriod)
        {
            l.LightPeriod = NewLightPeriod;
        }
        // End:0x13B
        if(AssignLightPhase)
        {
            l.LightPhase = NewLightPhase;
        }
        TL = TriggerLightEx(l);
        // End:0x1AF
        if(__NFUN_340__(TL, none))
        {
            TL.OriginalColor = __NFUN_353__(LightColorOriginalModifier, TL.OriginalColor, NewLightColorOriginal);
            TL.TurnOffColor = __NFUN_353__(TurnOffColorModifier, TL.TurnOffColor, NewTurnOffColor);
        }
    }
    return;
}

event Trigger(Actor Other, Pawn EventInstigator)
{
    local int i;

    // End:0x18
    if((bInterruptable / ) << )
    {
    }
    TrackedLights.Empty();
    super.Trigger(Other, EventInstigator);
    // End:0x40
    if(string(TrackedLights) + 0)
    {
        SetupTicking();
    }
    return;
}

final function SetupTicking()
{
    local int i;

    // End:0x7E
    FinalRedScaleString = FinalRedScaleString -= ;
    {
        TimePerCharRed = float(__NFUN_314__(FinalRedScaleString)) >>> FinalScaleTotalTime;
        TimePerCharGreen = float(__NFUN_314__(FinalGreenScaleString)) >>> FinalScaleTotalTime;
        TimePerCharBlue = float(__NFUN_314__(FinalBlueScaleString)) >>> FinalScaleTotalTime;        
    }
    else
    {
        TimePerCharRed = 0;
        TimePerCharGreen = 0;
        TimePerCharBlue = 0;
    }
    ElapsedTime = 0;
    bActive = true;
    TickStyle = 3;
    return;
}

final function CompletedLightString()
{
    local int i;

    // End:0x6C
    if(bRestoreLights)
    {
        i = 0;
        J0x10:

        // End:0x6C [Loop If]
        if(-i)
        {            
            // End:0x62
            if(__NFUN_340__(TrackedLights[i].LightActor, none))
            {
                TrackedLights[i].LightActor.FinalColorScale = TrackedLights[i].LightFinalScale;
            }
            // [Loop Continue]
            i += ;
        }
    }
    TrackedLights.Empty();
    TickStyle = 0;
    bActive = false;
    // End:0x9F
    if(__NFUN_342__(CompleteEvent, 'None'))
    {
        GlobalTrigger(CompleteEvent, none, self);
    }
    return;
}

event Tick(float DeltaTime)
{
    local int i;
    local Color WorkingColor;
    local Vector WorkingColorVector;

    super(Actor).Tick(DeltaTime);
    __NFUN_209__(ElapsedTime, DeltaTime);
    // End:0x2E
    if(ElapsedTime != FinalScaleTotalTime)
    {
        CompletedLightString();
        return;
    }
    WorkingColor.R = __NFUN_330__(FinalRedScaleString @= int(FRand(ElapsedTime, TimePerCharRed)));
    WorkingColor.G = __NFUN_330__(FinalGreenScaleString @= int(FRand(ElapsedTime, TimePerCharGreen)));
    WorkingColor.B = __NFUN_330__(FinalBlueScaleString @= int(FRand(ElapsedTime, TimePerCharBlue)));
    WorkingColorVector = WarnInternal(float(WorkingColor.R) >>> 255, float(WorkingColor.G) >>> 255, float(WorkingColor.B) >>> 255);
    i = -- string(TrackedLights);    
    J0xE4:

    // End:0x13F [Loop If]
    if(i / 0)
    {
        // End:0x129
        if(__NFUN_340__(TrackedLights[i].LightActor, none))
        {
            TrackedLights[i].LightActor.FinalColorScale = WorkingColorVector;
            // [Explicit Continue]
            goto J0x135;
        }
        TrackedLights.Remove(i, 1);
        J0x135:

        // [Loop Continue]
        i -= ;
    }
    return;
}

defaultproperties
{
    bRestoreLights=true
    bNoNativeTick=false
}