/*******************************************************************************
 * TriggerAssignPhysicsVolume generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class TriggerAssignPhysicsVolume extends TriggerAssignVolume
    collapsecategories
    notplaceable
    hidecategories(Filter,Interactivity,Karma,Lighting,Networking,Sound,Collision,Interpolation,movement);

var(AssignPhysVolumeInfo) noexport Object.EIntModifier NewPriorityMod "Modifier method for this variable.";
var(AssignPhysVolumeInfo) noexport int NewPriority "Determines which PhysicsVolume takes precedence if they overlap.";
var(AssignPhysVolumeInfo) noexport Object.EBitModifier NewbWaterVolume "If true, pawns will use water physics while in volume.";
var(AssignPhysVolumeInfo) noexport Object.EBitModifier NewbKillVolume "If true, will kill pawns that enter volume.";
var(AssignPhysVolumeInfo) noexport Object.EBitModifier NewbKillAI "If true, volume will kill AI's instantly.";
var(AssignPhysVolumePhysics) noexport Object.EBitModifier NewbMoveProjectiles "Projectiles that enter this volume are modified by the zone velocity.";
var(AssignPhysVolumePhysics) noexport Object.EBitModifier NewbRelativeVolumeVelocity "If true, velocity will be rotated by the PhysicsVolume rotation.";
var(AssignPhysVolumePhysics) noexport Object.EFloatModifier NewGroundFrictionMod "Modifier method for this variable.";
var(AssignPhysVolumePhysics) noexport float NewGroundFriction "Friction used for braking.";
var(AssignPhysVolumePhysics) noexport Object.EFloatModifier NewFluidFrictionMod "Modifier method for this variable.";
var(AssignPhysVolumePhysics) noexport float NewFluidFriction "Friction used while in water, falling, etc.";
var(AssignPhysVolumePhysics) noexport Object.EVectModifier NewVolumeVelocityMod "Modifier method for this variable.";
var(AssignPhysVolumePhysics) noexport Vector NewVolumeVelocity "Move actors in this volume with this much velocity.";
var(AssignPhysVolumePhysics) noexport Object.EVectModifier NewGravityMod "Modifier method for this variable.";
var(AssignPhysVolumePhysics) noexport Vector NewGravity "Direction that objects in this volume 'fall', and how fast.";
var(AssignPhysVolumePhysics) noexport Object.EFloatModifier NewTerminalVelocityMod "Modifier method for this variable.";
var(AssignPhysVolumePhysics) noexport float NewTerminalVelocity "When objects are falling/moving, this is the fastest they are allowed to move.";
var(AssignPhysVolumePhysics) noexport Object.EFloatModifier NewKLinearDampingScaleMod "Modifier method for this variable.";
var(AssignPhysVolumePhysics) noexport float NewKLinearDampingScale "Damping force to apply to the linear motion of Karma objects entering the zone.";
var(AssignPhysVolumePhysics) noexport Object.EFloatModifier NewKAngularDampingScaleMod "Modifier method for this variable.";
var(AssignPhysVolumePhysics) noexport float NewKAngularDampingScale "Damping force to apply tot he angular motion of Karma objects entering the zone.";
var(AssignPhysVolumePhysics) noexport Object.EFloatModifier NewPhysicsTimeScaleMod "Modifier method for this variable.";
var(AssignPhysVolumePhysics) noexport float NewPhysicsTimeScale "Amount to scale physics speed by.";
var(AssignPhysVolumePhysics) noexport bool bSetKGravityActor "If true, will set KGravityActor to NewKGravityActor.";
var(AssignPhysVolumePhysics) noexport deprecated Actor NewKGravityActor "What to change KGravityActor to.";
var(AssignPhysVolumeEvents) noexport Object.ENameModifier NewVolumePlayerEventMod "Modifier method for this variable.";
var(AssignPhysVolumeEvents) noexport name NewVolumePlayerEvent "Event to trigger when the player enters the volume.";
var(AssignPhysVolumeEvents) noexport Object.ENameModifier NewVolumePlayerExitEventMod "Modifier method for this variable.";
var(AssignPhysVolumeEvents) noexport name NewVolumePlayerExitEvent "Event to trigger when the player exits the volume.";
var(AssignPhysVolumeEffects) noexport Object.EFloatModifier NewActorTimeScaleMod "Modifier method for this variable.";
var(AssignPhysVolumeEffects) noexport float NewActorTimeScale "Amount to scale actor thinking/physics time by.";
var(AssignPhysVolumeEffects) noexport bool NewHUDEffectMaterialMod "If true, then assign this variable.";
var(AssignPhysVolumeEffects) noexport MaterialEx NewHUDEffectMaterial "Material to use for HUD effect while in volume.";
var(AssignPhysVolumeEffects) noexport Object.EFloatModifier NewHUDEffectFadeTimeMod "Modifier method for this variable.";
var(AssignPhysVolumeEffects) noexport float NewHUDEffectFadeTime "Time it takes for HUD Effect Material to fade in/out.";
var(AssignPhysVolumeEffects) noexport Object.EBitModifier NewbVolumeWalkMaterialOnly "When this is true, then the pawns will not do normal walk effects when in this volume.";
var(AssignPhysVolumeEffects) noexport Object.EBitModifier NewbVolumeHitMaterialOnly "When this is true, then the pawns will not do normal hit effects when in this volume.";
var(AssignPhysVolumeEffects) noexport bool NewVolumeMaterialMod "If true, then assign this variable.";
var(AssignPhysVolumeEffects) noexport class<Material> NewVolumeMaterial "Cause this material effect to happen whenever the pawn is in this volume. Example: Making an entire room 'dusty'.";
var(AssignPhysVolumeEffects) noexport bool NewVolumeFlotsamEffectMod "If true, then assign this variable.";
var(AssignPhysVolumeEffects) noexport Actor.EZoneFlotsamEffect NewVolumeFlotsamEffect "A particle system to mount to players moving through the Volume.";
var(AssignPhysVolumeEffects) noexport Object.ERotModifier NewVolumeFlotsamRotationMod "Modifier method for this variable.";
var(AssignPhysVolumeEffects) noexport Rotator NewVolumeFlotsamRotation "Rotation to apply to this effect to give it a different direction (primarily for windy type effects). Some types might override this with their own internal logic.";
var(AssignPhysVolumeReverb) noexport Object.EBitModifier NewbReverbVolume "Enable reverb for the volume.";
var(AssignPhysVolumeReverb) noexport Object.EBitModifier NewbUseExtendedReverb "Use extended reverb settings for the volume.";
var(AssignPhysVolumeReverb) noexport bool NewReverbPresetMod "If true, then assign this variable.";
var(AssignPhysVolumeReverb) noexport Actor.EReverbEnvironment NewReverbPreset "Type of reverb to apply when an actor is in this volume. Pawns check their HeadVolume.";
var(AssignPhysVolumeReverbEx) noexport Object.EFloatModifier ReverbTimeModifier "How to apply ReverbTime.";
var(AssignPhysVolumeReverbEx) noexport float ReverbTime "Total reverb time.  Must be between 0.0 and 8.0 seconds.";
var(AssignPhysVolumeReverbEx) noexport Object.EFloatModifier ReverbPreDelayModifier "How to apply ReverbPreDelay.";
var(AssignPhysVolumeReverbEx) noexport float ReverbPreDelay "Delay before reverb is heard.  Must be between 0.0 and 0.25.";
var(AssignPhysVolumeReverbEx) noexport Object.EFloatModifier ReverbDampingModifier "How to apply ReverbDamping.";
var(AssignPhysVolumeReverbEx) noexport float ReverbDamping "LowPass cutoff applied to sounds before they are put in the reverb engine.";
var(AssignPhysVolumeReverbEx) noexport Object.EFloatModifier ReverbDryLevelModifier "How to apply ReverbDryLevel.";
var(AssignPhysVolumeReverbEx) noexport float ReverbDryLevel "Scaling factor for non-reverbed sound.  Must be between 0.0 and 1.0.";
var(AssignPhysVolumeReverbEx) noexport Object.EFloatModifier ReverbWetLevelModifier "How to apply ReverbWetLevel.";
var(AssignPhysVolumeReverbEx) noexport float ReverbWetLevel "Scaling factor for reverbed sound.  Must be between 0.0 and 1.0.";

function DoAssign(Actor A)
{
    local PhysicsVolume V;
    local Pawn P;

    super.DoAssign(A);
    V = PhysicsVolume(A);
    // End:0x551
    if(__NFUN_340__(V, none))
    {
        V.Priority = __NFUN_347__(NewPriorityMod, V.Priority, NewPriority);
        V.bWaterVolume = __NFUN_346__(NewbWaterVolume, V.bWaterVolume);
        V.bKillVolume = __NFUN_346__(NewbKillVolume, V.bKillVolume);
        V.bKillAI = __NFUN_346__(NewbKillAI, V.bKillAI);
        V.bMoveProjectiles = __NFUN_346__(NewbMoveProjectiles, V.bMoveProjectiles);
        V.GroundFriction = __NFUN_348__(NewGroundFrictionMod, V.GroundFriction, NewGroundFriction);
        V.FluidFriction = __NFUN_348__(NewFluidFrictionMod, V.FluidFriction, NewFluidFriction);
        V.Gravity = __NFUN_349__(NewGravityMod, V.Gravity, NewGravity);
        V.TerminalVelocity = __NFUN_348__(NewTerminalVelocityMod, V.TerminalVelocity, NewTerminalVelocity);
        V.KLinearDampingScale = __NFUN_348__(NewKLinearDampingScaleMod, V.KLinearDampingScale, NewKLinearDampingScale);
        V.KAngularDampingScale = __NFUN_348__(NewKAngularDampingScaleMod, V.KAngularDampingScale, NewKAngularDampingScale);
        V.PhysicsTimeScale = __NFUN_348__(NewPhysicsTimeScaleMod, V.PhysicsTimeScale, NewPhysicsTimeScale);
        V.VolumePlayerEvent = __NFUN_351__(NewVolumePlayerEventMod, V.VolumePlayerEvent, NewVolumePlayerEvent);
        V.VolumePlayerExitEvent = __NFUN_351__(NewVolumePlayerExitEventMod, V.VolumePlayerExitEvent, NewVolumePlayerExitEvent);
        V.ActorTimeScale = __NFUN_348__(NewActorTimeScaleMod, V.ActorTimeScale, NewActorTimeScale);
        V.HUDEffectFadeTime = __NFUN_348__(NewHUDEffectFadeTimeMod, V.HUDEffectFadeTime, NewHUDEffectFadeTime);
        V.bVolumeWalkMaterialOnly = __NFUN_346__(NewbVolumeWalkMaterialOnly, V.bVolumeWalkMaterialOnly);
        V.bVolumeHitMaterialOnly = __NFUN_346__(NewbVolumeHitMaterialOnly, V.bVolumeHitMaterialOnly);
        V.VolumeFlotsamRotation = __NFUN_350__(NewVolumeFlotsamRotationMod, V.VolumeFlotsamRotation, NewVolumeFlotsamRotation);
        V.bReverbVolume = __NFUN_346__(NewbReverbVolume, V.bReverbVolume);
        V.bUseExtendedReverb = __NFUN_346__(NewbUseExtendedReverb, V.bUseExtendedReverb);
        V.ReverbTime = __NFUN_348__(ReverbTimeModifier, V.ReverbTime, ReverbTime);
        V.ReverbPreDelay = __NFUN_348__(ReverbPreDelayModifier, V.ReverbPreDelay, ReverbPreDelay);
        V.ReverbDamping = __NFUN_348__(ReverbDampingModifier, V.ReverbDamping, ReverbDamping);
        V.ReverbDryLevel = __NFUN_348__(ReverbDryLevelModifier, V.ReverbDryLevel, ReverbDryLevel);
        V.ReverbWetLevel = __NFUN_348__(ReverbWetLevelModifier, V.ReverbWetLevel, ReverbWetLevel);
        // End:0x4A5
        if(NewHUDEffectMaterialMod)
        {
            V.HUDEffectMaterial = NewHUDEffectMaterial;
        }
        // End:0x4C3
        if(NewVolumeMaterialMod)
        {
            V.VolumeMaterial = NewVolumeMaterial;
        }
        // End:0x4E1
        if(NewVolumeFlotsamEffectMod)
        {
            V.VolumeFlotsamEffect = NewVolumeFlotsamEffect;
        }
        // End:0x4FF
        if(bSetKGravityActor)
        {
            V.KGravityActor = NewKGravityActor;
        }
        V.bRelativeVolumeVelocity = __NFUN_346__(NewbRelativeVolumeVelocity, V.bRelativeVolumeVelocity);
        V.__NFUN_847__(__NFUN_349__(NewVolumeVelocityMod, V.VolumeVelocity_Orig, NewVolumeVelocity));
    }
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    super(TriggerAssign).RegisterPrecacheComponents(PrecacheIndex);
    // End:0x26
    if(NewHUDEffectMaterialMod)
    {
        PrecacheIndex.__NFUN_1269__(NewHUDEffectMaterial);
    }
    // End:0x41
    if(NewVolumeMaterialMod)
    {
        PrecacheIndex.__NFUN_1280__(NewVolumeMaterial);
    }
    return;
}
