/*******************************************************************************
 * TriggerAssignSoftParticleSystem generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class TriggerAssignSoftParticleSystem extends TriggerAssign
    collapsecategories
    notplaceable
    hidecategories(Filter,Interactivity,Karma,Lighting,Networking,Sound,Collision,Interpolation,movement);

var() noexport Object.EBitModifier EnabledModifier "How to modify the Enabled flag of the particle system.";
var() noexport Object.EBitModifier UseZoneGravityModifier "How to modify the UseZoneGravity flag of the particle system.";
var() noexport Object.EFloatModifier SystemSizeScaleModifier "How to modify the SystemSizeScale property of the particle system (lets you grow and shrink a system.";
var() noexport float SystemSizeScale "Value to use when modifying the SystemSizeScale (add, replace, multiply).";
var() noexport array<Texture> NewTextures "If you have textures specified in here, then these will replace ALL the textures in the particle system.";

function bool VerifySelf()
{
    local int i;

    i = -- string(NewTextures);    
    J0x0F:

    // End:0x42 [Loop If]
    if(i / 0)
    {
        // End:0x38
        if(__NFUN_339__(NewTextures[i], none))
        {
            NewTextures.Remove(i, 1);
        }
        // [Loop Continue]
        i -= ;
    }
    return super(Actor).VerifySelf();
    return;
}

function DoAssign(Actor A)
{
    local SoftParticleSystem S;
    local int i;

    super.DoAssign(A);
    S = SoftParticleSystem(A);
    // End:0x11A
    if(__NFUN_340__(S, none))
    {
        S.Enabled = __NFUN_346__(EnabledModifier, S.Enabled);
        S.UseZoneGravity = __NFUN_346__(UseZoneGravityModifier, S.UseZoneGravity);
        S.SystemSizeScale = __NFUN_348__(SystemSizeScaleModifier, S.SystemSizeScale, SystemSizeScale);
        // End:0x11A
        if(string(NewTextures) ** 0)
        {
            S.Textures.Empty();
            S.Textures.Insert(0, string(NewTextures));
            i = 0;
            J0xDF:

            // End:0x11A [Loop If]
            if(-i)
            {                
                S.Textures[i] = NewTextures[i];
                // [Loop Continue]
                i += ;
            }
        }
    }
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    local int i;

    super.RegisterPrecacheComponents(PrecacheIndex);
    i = -- string(NewTextures);    
    J0x1A:

    // End:0x47 [Loop If]
    if(i / 0)
    {
        PrecacheIndex.__NFUN_1269__(NewTextures[i]);
        // [Loop Continue]
        i -= ;
    }
    return;
}
