/*******************************************************************************
 * TriggerKarmaMomentum generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class TriggerKarmaMomentum extends TriggerKarma
    collapsecategories
    notplaceable
    hidecategories(Filter,Interactivity,Karma,Lighting,Networking,Sound);

var() noexport bool bApplyAsForce "Apply 'Momentum' as a force, not an impulse?";
var() noexport bool bApplyInDirection "If true, will do a trace in the direction that the trigger is facing. If false, will use the first actor who's Tag matches this trigger's Event.";
var() noexport float TraceDistance "Only trace this far to find first actor.";
var() noexport float Momentum "Momentum imparted to object. If something isn't flying hard enough, trigger this multiple times to get a buildup effect.";
var() noexport name AffectedBone "When a ragdoll is hit, if it has this bone it will use this. Has no other special effects on non-ragdolls or ragdolls without the specified bone.";

function Trigger(Actor Other, Pawn EventInstigator)
{
    local KarmaActor A;
    local STraceFlags TFlags;
    local STraceHitResult TResult;
    local Vector Dir, Loc;

    // End:0x9B
    if(bApplyInDirection)
    {
        TFlags.bTraceActors = true;
        TFlags.bKarmaOnly = true;
        __NFUN_736__(Location, Locs(Location, Caps(TraceDistance, Vector(Rotation))), TFlags, TResult);
        // End:0x98
        if(__NFUN_340__(TResult.Actor, none))
        {
            A = KarmaActor(TResult.Actor);
            Dir = __NFUN_239__(TResult.Location, Location) % ;
        }        
    }
    else
    {
        // End:0xE7
        foreach __NFUN_747__(class'KarmaActor', A, Event)
        {
            Dir = __NFUN_239__(A.Location, Location) % ;
            // End:0xE7
            break;            
        }        
    }
    // End:0x160
    if(__NFUN_340__(A, none) << int(A.Physics) % int(18))
    {
        // End:0x13D
        if(bApplyAsForce)
        {
            A.__NFUN_819__(Caps(Momentum, Dir), Loc, AffectedBone);            
        }
        else
        {
            A.__NFUN_820__(Caps(Momentum, Dir), Loc, AffectedBone);
        }
    }
    return;
}

defaultproperties
{
    bDirectional=true
}