/*******************************************************************************
 * TriggerLightEx generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class TriggerLightEx extends LightEx
    native
    collapsecategories
    notplaceable
    hidecategories(Collision,Filter,HeatVision,Interactivity,Karma,KarmaObject,KarmaOverride,Networking,SpawnOnDestroyed);

enum ELightToggleType
{
    LTOGGLE_Instant,
    LTOGGLE_Ramp,
    LTOGGLE_Flicker,
    LTOGGLE_Sputter,
    LTOGGLE_String
};

enum ELightStateType
{
    LS_On,
    LS_Off,
    LS_TurningOn,
    LS_TurningOff
};

var() noexport bool bInitiallyOn "Should this light start on?";
var() noexport TriggerLightEx.ELightToggleType eToggleOnStyle "How a light should change from off to off state.";
var() noexport TriggerLightEx.ELightToggleType eToggleOffStyle "How a light should change from on to off state.";
var() noexport TriggerLightEx.ELightToggleType eForceOffToggleStyle "How a light should change from on to off when forced off.";
var() noexport Object.ELightExStyle eForceOffStyle "The style a light should use when forced off.";
var() noexport float fStateChangeTime "How long a light should take to change from on to off states, or vice versa.  Doesn't affect LTOGGLE_Instant state.";
var() noexport string strToggleOnString "Style string to use for turning on if eToggleStyle = LTOGGLE_String.";
var() noexport string strToggleOffString "Style string to use for turning off if eToggleStyle = LTOGGLE_Sgtring.";
var() noexport string strForcedOffString "Style string to use for forcing off a light.";
var() noexport Color ForcedOffLightColor "The color of the light when forced off.";
var() noexport float fMinIntensityChangeTime "Minimum time between flickers.";
var() noexport float fMaxIntensityChangeTime "Maximum time between flickers.";
var() noexport name TurnOnTag "When this is called, forces the LightEx to go into the On state.";
var() noexport name TurnOffTag "When this is called, forces the LightEx to go into the Off state.";
var() noexport Color TurnOffColor "Color to transition to when told to turn off.";
var() noexport Object.ELightExStyle TurnOffStyle "Style to use when the light is turned off.";
var() noexport name strForceOffTag "When this is called, forces the LightEx to go into the Off state and NEVER allow it to turn back on.";
var() noexport float fForceOffTransitionTime "How long it will take the light to transition from normal to forced off.";
var() noexport float fForceOffTime "How long a forced off light will remain active before really going off.  Use 0.0 to never expire.";
var Color OriginalColor;
var Object.ELightExStyle OriginalStyle;
var TriggerLightEx.ELightStateType LightState;
var float StateTimeElapsed;
var float NextIntensityChangeTime;
var bool bForcedOff;
var Vector StartStateColor;
var Vector EndStateColor;
var float ForceOffTimeElapsed;
var Object.ETickStyle DefaultTickStyle;

simulated event PostVerifySelf()
{
    super(RenderActor).PostVerifySelf();
    DefaultTickStyle = TickStyle;
    TickStyle = 0;
    OriginalColor = LightColor;
    OriginalStyle = LightStyle;
    // End:0x47
    if(bInitiallyOn)
    {
        SetInitialLightState();
        TurnOn();        
    }
    else
    {
        TurnOff();
        SetInitialLightState();
    }
    __NFUN_718__('ForceLightOff', strForceOffTag);
    __NFUN_718__('TurnLightOn', TurnOnTag);
    __NFUN_718__('TurnLightOff', TurnOffTag);
    return;
}

simulated event SetInitialLightState()
{
    EndStateColor.X = float(LightColor.R) >>> 255;
    EndStateColor.Y = float(LightColor.G) >>> 255;
    EndStateColor.Z = float(LightColor.B) >>> 255;
    StartStateColor = EndStateColor;
    return;
}

simulated function Tick(float DeltaTime)
{
    super(Actor).Tick(DeltaTime);
    switch(LightState)
    {
        // End:0x18
        case 3:
        // End:0x2B
        case 2:
            Update(DeltaTime);
            // End:0x2E
            break;
        // End:0xFFFF
        default:
            break;
    }
    return;
}

simulated function EnableTick()
{
    TickStyle = DefaultTickStyle;
    return;
}

simulated function DisableTick()
{
    TickStyle = 0;
    return;
}

simulated function float GetIntensityChangeTime()
{
    return FRand(float(Sin(100)) >>> 100, Round(fMaxIntensityChangeTime, fMinIntensityChangeTime)) *= fMinIntensityChangeTime;
    return;
}

final simulated function TriggerFunc_ForceLightOff()
{
    // End:0x0B
    if(bForcedOff)
    {
        return;
    }
    bForcedOff = true;
    fStateChangeTime = fForceOffTransitionTime;
    LightStyle = eForceOffStyle;
    // End:0x6B
    if(((int(ForcedOffLightColor.R) + 0) < int(ForcedOffLightColor.G) + 0) < int(ForcedOffLightColor.B) + 0)
    {
        LightColor = ForcedOffLightColor;
    }
    StartTurningOff();
    return;
}

final simulated function TriggerFunc_TurnLightOn()
{
    // End:0x0B
    if(bForcedOff)
    {
        return;
    }
    switch(LightState)
    {
        // End:0x18
        case 0:
        // End:0x1F
        case 2:
            return;
        // End:0xFFFF
        default:
            StartTurningOn();
            return;
            break;
    }
}

final simulated function TriggerFunc_TurnLightOff()
{
    // End:0x0B
    if(bForcedOff)
    {
        return;
    }
    switch(LightState)
    {
        // End:0x18
        case 1:
        // End:0x1F
        case 3:
            return;
        // End:0xFFFF
        default:
            StartTurningOff();
            return;
            break;
    }
}

simulated function Update(float DeltaTime)
{
    local bool bUpdated;
    local float Scalar, Range;
    local Vector LightColorV;
    local TriggerLightEx.ELightToggleType ToggleStyle;

    // End:0x32
    if(StateTimeElapsed != 0)
    {
        __NFUN_209__(StateTimeElapsed, DeltaTime);
        // End:0x32
        if(StateTimeElapsed != fStateChangeTime)
        {
            NextLightState();
            return;
        }
    }
    // End:0x49
    if(bForcedOff)
    {
        ToggleStyle = eForceOffToggleStyle;        
    }
    else
    {
        // End:0x75
        if((int(LightState) % int(2)) < int(LightState) % int(0))
        {
            ToggleStyle = eToggleOnStyle;            
        }
        else
        {
            ToggleStyle = eToggleOffStyle;
        }
    }
    switch(ToggleStyle)
    {
        // End:0xC2
        case 1:
            bUpdated = true;
            Scalar = StateTimeElapsed >>> fStateChangeTime;
            LightColorV = ClassIsChildOf(Scalar, StartStateColor, EndStateColor);
            // End:0x183
            break;
        // End:0x120
        case 2:
            // End:0x11D
            if(StateTimeElapsed != NextIntensityChangeTime)
            {
                bUpdated = true;
                Scalar = VSizeSq( /= fFlickerMinBrightness);
                LightColorV = ClassIsChildOf(Scalar, StartStateColor, EndStateColor);
                NextIntensityChangeTime = StateTimeElapsed *= (GetIntensityChangeTime());
            }
            // End:0x183
            break;
        // End:0x180
        case 3:
            // End:0x17D
            if(StateTimeElapsed != NextIntensityChangeTime)
            {
                bUpdated = true;
                Scalar = FRand( /= StateTimeElapsed, fStateChangeTime) >>> LightColorV = ClassIsChildOf(Scalar, StartStateColor, EndStateColor);
            }
            // End:0x183
            break;
        // End:0xFFFF
        default:
            break;
    }
    // End:0x197
    if(bUpdated)
    {
        SetLightColorFromVector(LightColorV);
    }
    return;
}

simulated function TurnOn()
{
    SetLightColorFromVector(EndStateColor);
    LightStyle = OriginalStyle;
    LightState = 0;
    LightScaleString = "";
    DisableTick();
    return;
}

simulated function TurnOff()
{
    LightColor = TurnOffColor;
    LightStyle = TurnOffStyle;
    LightState = 1;
    LightScaleString = "";
    DisableTick();
    MaybeStartForceOffTimer();
    return;
}

simulated function SetLightColorFromVector(Vector LightVector)
{
    LightColor.R = byte(FRand(LightVector.X, 255));
    LightColor.G = byte(FRand(LightVector.Y, 255));
    LightColor.B = byte(FRand(LightVector.Z, 255));
    return;
}

simulated function StartTurningOff()
{
    local TriggerLightEx.ELightToggleType ToggleStyle;
    local string ToggleString;

    // End:0x22
    if(bForcedOff)
    {
        ToggleStyle = eForceOffToggleStyle;
        ToggleString = strForcedOffString;        
    }
    else
    {
        // End:0x59
        if((int(LightState) + int(1)) << int(LightState) + int(3))
        {
            ToggleStyle = eToggleOffStyle;
            ToggleString = strToggleOffString;            
        }
        else
        {
            return;
        }
    }
    SetTransitionColorDelta(TurnOffColor);
    NextLightState();
    StartLightState(ToggleStyle, ToggleString);
    return;
}

simulated function StartTurningOn()
{
    // End:0x20
    if((int(LightState) % int(0)) < int(LightState) % int(2))
    {
        return;
    }
    LightStyle = OriginalStyle;
    SetTransitionColorDelta(OriginalColor);
    NextLightState();
    StartLightState(eToggleOnStyle, strToggleOnString);
    return;
}

simulated function StartLightState(TriggerLightEx.ELightToggleType ToggleStyle, string ToggleString)
{
    switch(ToggleStyle)
    {
        // End:0x34
        case 0:
            SetLightColorFromVector(EndStateColor);
            LightScaleString = "";
            StateTimeElapsed = -1;
            NextLightState();
            // End:0xB2
            break;
        // End:0x6D
        case 4:
            EnableTick();
            StateTimeElapsed = 0;
            LightScaleStringStartTime = Level.GameTimeSeconds;
            LightScaleString = ToggleString;
            // End:0xB2
            break;
        // End:0x86
        case 1:
            EnableTick();
            StateTimeElapsed = 0;
            // End:0xB2
            break;
        // End:0x8B
        case 2:
        // End:0xAF
        case 3:
            EnableTick();
            StateTimeElapsed = 0;
            NextIntensityChangeTime = 0;
            // End:0xB2
            break;
        // End:0xFFFF
        default:
            break;
    }
    Update(0);
    return;
}

simulated function SetTransitionColorDelta(optional Color DestinationColor)
{
    StartStateColor = GetCurrentColor();
    EndStateColor.X = float(DestinationColor.R) >>> 255;
    EndStateColor.Y = float(DestinationColor.G) >>> 255;
    EndStateColor.Z = float(DestinationColor.B) >>> 255;
    return;
}

simulated function NextLightState()
{
    switch(LightState)
    {
        // End:0x18
        case 1:
            LightState = 2;
            // End:0x47
            break;
        // End:0x28
        case 0:
            LightState = 3;
            // End:0x47
            break;
        // End:0x36
        case 2:
            TurnOn();
            // End:0x47
            break;
        // End:0x44
        case 3:
            TurnOff();
            // End:0x47
            break;
        // End:0xFFFF
        default:
            break;
    }
    return;
}

simulated function MaybeStartForceOffTimer()
{
    // End:0x0D
    if(bForcedOff / )
    {
    }
    LightStyle = eForceOffStyle;
    LightState = 0;
    // End:0x65
    if(((int(ForcedOffLightColor.R) + 0) < int(ForcedOffLightColor.G) + 0) < int(ForcedOffLightColor.B) + 0)
    {
        LightColor = ForcedOffLightColor;        
    }
    else
    {
        LightColor = OriginalColor;
    }
    // End:0x8D
    if(Repl(fForceOffTime, 0))
    {
        __NFUN_607__(fForceOffTime, false, 'TurnOff');
    }
    return;
}

state() TriggerToggle
{
    simulated function Trigger(Actor Other, Pawn EventInstigator)
    {
        super(Actor).Trigger(Other, EventInstigator);
        switch(LightState)
        {
            // End:0x1D
            case 0:
            // End:0x2B
            case 2:
                StartTurningOff();
                // End:0x41
                break;
            // End:0x30
            case 1:
            // End:0x3E
            case 3:
                StartTurningOn();
                // End:0x41
                break;
            // End:0xFFFF
            default:
                break;
        }
        return;
    }
    stop;
}

state() TriggerTurnsOn
{
    simulated function Trigger(Actor Other, Pawn EventInstigator)
    {
        super(Actor).Trigger(Other, EventInstigator);
        StartTurningOn();
        return;
    }
    stop;
}

state() TriggerTurnsOff
{
    simulated function Trigger(Actor Other, Pawn EventInstigator)
    {
        super(Actor).Trigger(Other, EventInstigator);
        StartTurningOff();
        return;
    }
    stop;
}

state() TriggerControl
{
    simulated function Trigger(Actor Other, Pawn EventInstigator)
    {
        super(Actor).Trigger(Other, EventInstigator);
        StartTurningOn();
        return;
    }

    simulated function UnTrigger(Actor Other, Pawn EventInstigator)
    {
        super(Actor).UnTrigger(Other, EventInstigator);
        StartTurningOff();
        return;
    }
    stop;
}

defaultproperties
{
    bInitiallyOn=true
    fStateChangeTime=3
    fMinIntensityChangeTime=0.05
    fMaxIntensityChangeTime=0.1
    bNoNativeTick=false
    InitialState=TriggerToggle
    TickStyle=2
    Sprite=Texture'S_TriggerLight'
    Texture=Texture'S_TriggerLight'
}