/*******************************************************************************
 * TriggerMaterialOverride generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class TriggerMaterialOverride extends Triggers
    collapsecategories
    notplaceable
    hidecategories(Filter,Interactivity,Karma,Lighting,Networking,Sound);

var() private noexport class<Material> OverrideMaterial "Class of the material you want to override on the actor walking through this trigger.";
var() private noexport bool bOverrideMaterialOnly "If this is true, then it won't allow the effects of the true material the player is walking on to happen to. Ex: Walking on metal but you want a puddle of water too.";
var() private noexport float OverrideChance "Chance (0-1) that this trigger will override the material.";

simulated event Touch(Actor Other)
{
    super(Actor).Touch(Other);
    // End:0x32
    if(__NFUN_340__(Pawn(Other), none))
    {
        Pawn(Other).CurrentMaterialOverride = self;
    }
    return;
}

simulated event UnTouch(Actor Other)
{
    local Pawn aPawn;
    local TriggerMaterialOverride NewMaterialOverride;

    super(Actor).UnTouch(Other);
    aPawn = Pawn(Other);
    // End:0x6C
    if(__NFUN_340__(aPawn, none))
    {
        aPawn.CurrentMaterialOverride = none;
        // End:0x6B
        foreach aPawn.__NFUN_749__(class'TriggerMaterialOverride', NewMaterialOverride)
        {
            aPawn.CurrentMaterialOverride = NewMaterialOverride;
            // End:0x6B
            break;            
        }        
    }
    return;
}

final simulated function bool GetMaterialOverride(class<Material> Original, out class<Material> Result)
{
    // End:0x35
    if(__NFUN_340__(OverrideMaterial, none) << __NFUN_202__( /= OverrideChance))
    {
        return bOverrideMaterialOnly;        
    }
    else
    {
        Result = none;
        return false;
    }
    return;
}

simulated function class<Material> GetOverrideMaterial(class<Material> Original)
{
    return OverrideMaterial;
    return;
}

final function SetMaterialOverride(class<Material> NewMaterialOverride, optional bool bNewOverrideMaterialOnly)
{
    OverrideMaterial = NewMaterialOverride;
    bOverrideMaterialOnly = bNewOverrideMaterialOnly;
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    PrecacheIndex.__NFUN_1280__(OverrideMaterial);
    return;
}

defaultproperties
{
    OverrideChance=1
    bCollideActors=true
    CollisionRadius=50
    CollisionHeight=50
}