/*******************************************************************************
 * TriggerMount generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class TriggerMount extends Triggers
    collapsecategories
    notplaceable
    hidecategories(Filter,Interactivity,Karma,Lighting,Networking,Sound);

var() noexport bool bGenerateOffsets "When mounting, generate the MountOrigin/MountAngles based on where the mountee currently is relative to the MountParent. Otherwise use what is typed in here for NewMountOrigin/Angles.";
var() noexport bool MatchParentLocation "Attach to the center of the parent";
var() noexport bool MatchParentAngles "Attach using the parent's exact angles.";
var() noexport bool bHideable "Toggle hidden state of MountWhat when MountToWhat changes?";
var() noexport bool bTransferToCorpse "If true, when MountToWhat is a pawn, MountWhat will be transfered to the corpse on death.";
var() noexport deprecated name MountWhat "What to attach";
var() noexport deprecated name MountToWhat "What to attach to. When empty just dismounts";
var() noexport name NewMountMeshItem "MeshItem to mount to (bone/surface mount)";
var() noexport Object.EMountType NewMountType "Method of mounting to use.";
var() noexport Vector NewMountOrigin "MountOrigin to assign when the actor gets mounted.";
var() noexport Object.EBitModifier NewIndependentRotation "How to modify the IndependentRotation flag, which controls whether the actor will take the rotation of the mount into account or not.";
var() noexport Object.EBitModifier NewIndependentLocation "How to modify the IndependentLocation flag, which controls whether the actor will take the location of the mount into account or not.";
var() noexport Rotator NewMountAngles "MountAngles to assign when the actor gets mounted.";
var(TriggerMountAdvanced) noexport bool MountOther "Mount 'Other' (parameter passed in from Trigger function call). Overrides MountWhat.";
var(TriggerMountAdvanced) noexport bool MountInstigator "Mount the Instigator. Overrides MountWhat and MountOther.";
var(TriggerMountAdvanced) noexport bool MountToOther "Mount to 'Other' (parameter passed in from Trigger function call). Overrides MountToWhat.";
var(TriggerMountAdvanced) noexport bool MountToInstigator "Mount to the Instigator. Overrides MountToWhat. Overrides MountToOther and MountToWhat.";
var(TriggerMountAdvanced) noexport Object.EPhysics NewMounteePhysics "When mounting, set the Mountee's physics to this if set to anything besides PHYS_Null.";
var(TriggerMountAdvanced) noexport Object.EPhysics NewDismountPhysics "When dismounting, set the Mountee's physics to this if set to anything besides PHYS_Null.";
var(TriggerMountCollision) noexport Object.EBitModifier Mount_bCollideActors "How to modify the bCollideActors flag when mounting.";
var(TriggerMountCollision) noexport Object.EBitModifier Mount_bCollideWorld "How to modify the bCollideWorld flag when mounting.";
var(TriggerMountCollision) noexport Object.EBitModifier Mount_bBlockActors "How to modify the bBlockActors flag when mounting.";
var(TriggerMountCollision) noexport Object.EBitModifier Mount_bBlockKarma "How to modify the bBlockKarma flag when mounting.";
var(TriggerMountCollision) noexport Object.EBitModifier Mount_bBlockPlayers "How to modify the bBlockPlayers flag when mounting.";
var(TriggerMountCollision) noexport Object.EBitModifier Dismount_bCollideActors "How to modify the bCollideActors flag when dismounting.";
var(TriggerMountCollision) noexport Object.EBitModifier Dismount_bCollideWorld "How to modify the bCollideWorld flag when dismounting.";
var(TriggerMountCollision) noexport Object.EBitModifier Dismount_bBlockActors "How to modify the bBlockActors flag when dismounting.";
var(TriggerMountCollision) noexport Object.EBitModifier Dismount_bBlockKarma "How to modify the bBlockKarma flag when dismounting.";
var(TriggerMountCollision) noexport Object.EBitModifier Dismount_bBlockPlayers "How to modify the bBlockPlayers flag when dismounting.";

event Trigger(Actor Other, Pawn EventInstigator)
{
    local Actor NewMountParent, NewMountee;
    local bool bSearchForMountWhat;

    // End:0x17
    if(MountInstigator)
    {
        NewMountee = EventInstigator;        
    }
    else
    {
        // End:0x2E
        if(MountOther)
        {
            NewMountee = Other;            
        }
        else
        {
            bSearchForMountWhat = true;
        }
    }
    // End:0x51
    if((bSearchForMountWhat / ) << )
    {
    }
    // End:0x68
    if(MountToInstigator)
    {
        NewMountParent = EventInstigator;        
    }
    else
    {
        // End:0x7F
        if(MountToOther)
        {
            NewMountParent = Other;            
        }
        else
        {
            NewMountParent = FindActor(class'Actor', MountToWhat, true);
        }
    }
    // End:0xB4
    if(bSearchForMountWhat / )
    {        
    }
    else
    {
        // End:0xF3
        if(__NFUN_341__(MountWhat, 'None'))
        {
            __NFUN_355__("MountWhat not set, aborting TriggerMount");
            return;
        }
        // End:0x11A
        foreach __NFUN_747__(class'Actor', NewMountee, MountWhat, true)
        {
            Mount(NewMountee, NewMountParent);            
        }        
    }
    return;
}

final function Mount(Actor NewMountee, Actor NewMountParent)
{
    // End:0x0E
    if(__NFUN_339__(NewMountee, none))
    {
        return;
    }
    // End:0x27
    if(__NFUN_339__(NewMountParent, none))
    {
        Dismount(NewMountee);
        return;
    }
    NewMountee.MountMeshItem = NewMountMeshItem;
    NewMountee.MountType = NewMountType;
    NewMountee.MountOrigin = NewMountOrigin;
    NewMountee.MountAngles = NewMountAngles;
    NewMountee.IndependentRotation = __NFUN_346__(NewIndependentRotation, NewMountee.IndependentRotation);
    NewMountee.IndependentLocation = __NFUN_346__(NewIndependentLocation, NewMountee.IndependentLocation);
    NewMountee.__NFUN_635__(NewMountParent, MatchParentLocation, MatchParentAngles, bGenerateOffsets, bHideable, bTransferToCorpse);
    NewMountee.__NFUN_621__(__NFUN_346__(Mount_bCollideActors, NewMountee.bCollideActors), __NFUN_346__(Mount_bBlockActors, NewMountee.bBlockActors), __NFUN_346__(Mount_bBlockPlayers, NewMountee.bBlockPlayers), __NFUN_346__(Mount_bBlockKarma, NewMountee.bBlockKarma), __NFUN_346__(Mount_bCollideWorld, NewMountee.bCollideWorld));
    // End:0x1A2
    if(int(NewMounteePhysics) + int(11))
    {
        NewMountee.__NFUN_642__(NewMounteePhysics);
    }
    // End:0x1C5
    if(int(NewDismountPhysics) + int(11))
    {
        NewMountee.DismountPhysics = NewDismountPhysics;
    }
    return;
}

final function Dismount(Actor Dismountee)
{
    local Vector V;

    // End:0x0E
    if(__NFUN_339__(Dismountee, none))
    {
        return;
    }
    Dismountee.__NFUN_631__();
    // End:0x29
    if(__NFUN_339__(Dismountee, none))
    {
        return;
    }
    Dismountee.__NFUN_621__(__NFUN_346__(Dismount_bCollideActors, Dismountee.bCollideActors), __NFUN_346__(Dismount_bBlockActors, Dismountee.bBlockActors), __NFUN_346__(Dismount_bBlockPlayers, Dismountee.bBlockPlayers), __NFUN_346__(Dismount_bBlockKarma, Dismountee.bBlockKarma), __NFUN_346__(Dismount_bCollideWorld, Dismountee.bCollideWorld));
    // End:0xD6
    if(Dismountee.bIsPawn)
    {
        Pawn(Dismountee).ClientRestart_Normal();
    }
    return;
}

defaultproperties
{
    bGenerateOffsets=true
    bHideable=true
    NewMounteePhysics=11
    NewDismountPhysics=11
    Texture=Texture'S_TriggerMount'
}