/*******************************************************************************
 * TriggerTimeWarp generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class TriggerTimeWarp extends Triggers
    collapsecategories
    notplaceable
    hidecategories(Filter,Interactivity,Karma,Lighting,Networking,Sound);

var() noexport float TimeDilation "Value to set TimeWarp to on the actors being affected by us.";
var() noexport bool ActivateOnTouch "Whenever something touches us, set the time dilation on that actor. When they untouch us we reset it back to 1.0";
var() noexport bool ActivateInstigator "Whoever triggers us gets affected by the time dilation as well.";

final function SetTimeDilation(Actor Other, float NewTimeDilation)
{
    // End:0x0E
    if(__NFUN_339__(Other, none))
    {
        return;
    }
    Other.TimeWarp = NewTimeDilation;
    return;
}

event Touch(Actor Other)
{
    super(Actor).Touch(Other);
    // End:0x24
    if(ActivateOnTouch)
    {
        SetTimeDilation(Other, TimeDilation);
    }
    return;
}

event UnTouch(Actor Other)
{
    super(Actor).UnTouch(Other);
    // End:0x24
    if(ActivateOnTouch)
    {
        SetTimeDilation(Other, 1);
    }
    return;
}

event Trigger(Actor Other, Pawn EventInstigator)
{
    local Actor A;

    super(Actor).Trigger(Other, EventInstigator);
    // End:0x37
    if(ActivateInstigator << __NFUN_340__(EventInstigator, none))
    {
        SetTimeDilation(EventInstigator, TimeDilation);
    }
    // End:0x6F
    if(__NFUN_342__(Event, 'None'))
    {
        // End:0x6E
        foreach __NFUN_747__(class'Actor', A, Event, true)
        {
            SetTimeDilation(A, TimeDilation);            
        }        
    }
    return;
}

defaultproperties
{
    TimeDilation=1
    ActivateOnTouch=true
    bCollideActors=true
    Texture=Texture'S_TrigTimeWarp'
}