/*******************************************************************************
 * TriggerZoneAssign generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class TriggerZoneAssign extends TriggerAssign
    collapsecategories
    notplaceable
    hidecategories(Filter,Interactivity,Karma,Lighting,Networking,Sound,Collision,Interpolation,movement);

var(AssignZone) noexport bool bForceReentrance "If this is set, all actors in the zone will act as if they just entered the zone for the first time. (Effects that only happen on zone entrance will happen, etc.)";
var(AssignZone_Display) bool SetMaxCorpses;
var(AssignZone_Display) bool SetDefaultVisibilityRadius;
var(AssignZone_Display) int NewMaxCorpses;
var(AssignZone_Display) float NewDefaultVisibilityRadius;
var(AssignZone_Display) Object.EFloatModifier NewAmbientLightScaleMod;
var(AssignZone_Display) float NewAmbientLightScale;
var(AssignZone_Display) array<SScaleModifier> AmbientLightScaleModifierAddList;
var(AssignZone_Display) noexport SSceneInfoAssign Scene "Various modifiers for SceneInfo";
var(AssignZone_Display_Fog) noexport Object.EBitModifier bHasDistanceFogModifier "Modifier for zone bHasDistanceFog";
var(AssignZone_Display_Fog) noexport bool SetDistanceFog "Should we set new distance fog values";
var(AssignZone_Display_Fog) noexport float DistanceFogFadeTime "new distance fog fade time";
var(AssignZone_Display_Fog) noexport SDistanceFog DistanceFog "New distance fog";
var(AssignZone_Display_DOF) noexport Object.EBitModifier bHasDOFModifier "Modifier for zone bHasDOF";
var(AssignZone_Display_DOF) noexport bool SetDOFBlurAmount "Should we set a new DOF blur amount";
var(AssignZone_Display_DOF) noexport SScaleModifier DOFBlurAmount "new DOFBlurAmount modifier";
var(AssignZone_Display_DOF) noexport bool SetDOFFocalDist "Should we set a new DOF focal dist";
var(AssignZone_Display_DOF) noexport SScaleModifier DOFFocalDist "new DOFFocalDist modifier";
var(AssignZone_Display_DOF) noexport bool SetDOFFocalRangeMin "Should we set a new DOF focal range min";
var(AssignZone_Display_DOF) noexport SScaleModifier DOFFocalRangeMin "new DOFFocalRangeMin modifier";
var(AssignZone_Display_DOF) noexport bool SetDOFFocalRangeMax "Should we set a new DOF focal range max";
var(AssignZone_Display_DOF) noexport SScaleModifier DOFFocalRangeMax "new DOFFocalRangeMax modifier";
var(AssignZone_Info) Object.EBitModifier SetNeutralZone;
var(AssignZone_Info) Object.EBitModifier SetBombDetectorZone;
var(AssignZone_Event) bool SetZonePlayerEvent;
var(AssignZone_Event) bool SetZonePlayerExitEvent;
var(AssignZone_Event) bool SetZoneName;
var(AssignZone_Event) bool SetZoneTag;
var(AssignZone_Event) name ZonePlayerEvent;
var(AssignZone_Event) name NewZonePlayerExitEvent;
var(AssignZone_Event) localized string NewZoneName;
var(AssignZone_Event) name NewZoneTag;
var(AssignZone_WarpZoneInfo) bool SetOtherSideURL;
var(AssignZone_WarpZoneInfo) string OtherSideURL;
var(AssignZone_Effects) noexport name SkyZoneTag "If set, the SkyZone on the target zone(s) will be replaced by the the SkyZone with this tag.";

function DoAssign(Actor A)
{
    local ZoneInfo Z;
    local WarpZoneInfo WZ;
    local SkyZoneInfo SZ;
    local Pawn P;
    local PlayerPawn Player;
    local int i;
    local bool bNotifyActorsInZone;

    bNotifyActorsInZone = false;
    super.DoAssign(A);
    Z = ZoneInfo(A);
    // End:0x9EA
    if(__NFUN_340__(Z, none))
    {
        // End:0x7B
        if(__NFUN_342__(SkyZoneTag, 'None'))
        {
            SZ = SkyZoneInfo(FindActor(class'SkyZoneInfo', SkyZoneTag));
            // End:0x7B
            if(__NFUN_340__(SZ, none))
            {
                Z.SkyZone = SZ;
            }
        }
        // End:0x99
        if(SetMaxCorpses)
        {
            Z.MaxCorpses = NewMaxCorpses;
        }
        // End:0xB7
        if(SetDefaultVisibilityRadius)
        {
            Z.DefaultVisibilityRadius = NewDefaultVisibilityRadius;
        }
        Z.AmbientLightScale = __NFUN_348__(NewAmbientLightScaleMod, Z.AmbientLightScale, NewAmbientLightScale);
        Z.bNeutralZone = __NFUN_346__(SetNeutralZone, Z.bNeutralZone);
        Z.bBombDetectorZone = __NFUN_346__(SetBombDetectorZone, Z.bBombDetectorZone);
        // End:0x153
        if(SetZonePlayerEvent)
        {
            Z.ZonePlayerEvent = ZonePlayerEvent;
        }
        // End:0x171
        if(SetZonePlayerExitEvent)
        {
            Z.ZonePlayerExitEvent = NewZonePlayerExitEvent;
        }
        // End:0x18F
        if(SetZoneName)
        {
            Z.ZoneName = NewZoneName;
        }
        // End:0x1AD
        if(SetZoneTag)
        {
            Z.ZoneTag = NewZoneTag;
        }
        // End:0x1F0
        if(Z.__NFUN_358__('WarpZoneInfo'))
        {
            WZ = WarpZoneInfo(Z);
            // End:0x1F0
            if(SetOtherSideURL)
            {
                WZ.OtherSideURL = OtherSideURL;
            }
        }
        i = -- string(AmbientLightScaleModifierAddList);        
        J0x1FF:

        // End:0x231 [Loop If]
        if(i / 0)
        {
            Z.__NFUN_578__('AmbientLightScale', AmbientLightScaleModifierAddList[i]);
            // [Loop Continue]
            i -= ;
        }
        Z.Scene.Shadows = __NFUN_349__(Scene.ShadowsModifier, Z.Scene.Shadows, Scene.Shadows);
        Z.Scene.MidTones = __NFUN_349__(Scene.MidTonesModifier, Z.Scene.MidTones, Scene.MidTones);
        Z.Scene.Highlights = __NFUN_349__(Scene.HighlightsModifier, Z.Scene.Highlights, Scene.Highlights);
        Z.Scene.Desaturation = __NFUN_348__(Scene.DesaturationModifier, Z.Scene.Desaturation, Scene.Desaturation);
        Z.Scene.BloomScale = __NFUN_348__(Scene.BloomScaleModifier, Z.Scene.BloomScale, Scene.BloomScale);
        Z.Scene.HDRMiddleGray = __NFUN_348__(Scene.HDRMiddleGrayModifier, Z.Scene.HDRMiddleGray, Scene.HDRMiddleGray);
        Z.Scene.HDRMinScale = __NFUN_348__(Scene.HDRMinScaleModifier, Z.Scene.HDRMinScale, Scene.HDRMinScale);
        Z.Scene.HDRMaxScale = __NFUN_348__(Scene.HDRMaxScaleModifier, Z.Scene.HDRMaxScale, Scene.HDRMaxScale);
        Z.Scene.HDRClip = __NFUN_348__(Scene.HDRClipModifier, Z.Scene.HDRClip, Scene.HDRClip);
        Z.Scene.AmbientOcclusionSpeed = __NFUN_348__(Scene.AmbientOcclusionSpeedModifier, Z.Scene.AmbientOcclusionSpeed, Scene.AmbientOcclusionSpeed);
        Z.Scene.AmbientOcclusionStrength = __NFUN_348__(Scene.AmbientOcclusionStrengthModifier, Z.Scene.AmbientOcclusionStrength, Scene.AmbientOcclusionStrength);
        Z.Scene.AmbientOcclusionRadius = __NFUN_348__(Scene.AmbientOcclusionRadiusModifier, Z.Scene.AmbientOcclusionRadius, Scene.AmbientOcclusionRadius);
        Z.Scene.StarBloomScale = __NFUN_348__(Scene.StarBloomScaleModifier, Z.Scene.StarBloomScale, Scene.StarBloomScale);
        Z.Scene.StarAngle = __NFUN_348__(Scene.StarAngleModifier, Z.Scene.StarAngle, Scene.StarAngle);
        Z.Scene.StarLength1 = __NFUN_348__(Scene.StarLength1Modifier, Z.Scene.StarLength1, Scene.StarLength1);
        Z.Scene.StarLength2 = __NFUN_348__(Scene.StarLength2Modifier, Z.Scene.StarLength2, Scene.StarLength2);
        Z.Scene.StarBlur = __NFUN_348__(Scene.StarBlurModifier, Z.Scene.StarBlur, Scene.StarBlur);
        Z.Scene.StarSamples = __NFUN_347__(Scene.StarSamplesModifier, Z.Scene.StarSamples, Scene.StarSamples);
        Z.Scene.StarBloomMinIntensity = __NFUN_348__(Scene.StarBloomMinIntensityModifier, Z.Scene.StarBloomMinIntensity, Scene.StarBloomMinIntensity);
        Z.Scene.StarBloomFullIntensity = __NFUN_348__(Scene.StarBloomFullIntensityModifier, Z.Scene.StarBloomFullIntensity, Scene.StarBloomFullIntensity);
        Z.Scene.PixelMotionBlurScale = __NFUN_348__(Scene.PixelMotionBlurScaleModifier, Z.Scene.PixelMotionBlurScale, Scene.PixelMotionBlurScale);
        Z.Scene.PixelMotionBlurFar = __NFUN_348__(Scene.PixelMotionBlurFarModifier, Z.Scene.PixelMotionBlurFar, Scene.PixelMotionBlurFar);
        Z.Scene.PixelMotionBlurMaxVelocityNear = __NFUN_348__(Scene.PixelMotionBlurMaxVelocityNearModifier, Z.Scene.PixelMotionBlurMaxVelocityNear, Scene.PixelMotionBlurMaxVelocityNear);
        Z.Scene.PixelMotionBlurMaxVelocityFar = __NFUN_348__(Scene.PixelMotionBlurMaxVelocityFarModifier, Z.Scene.PixelMotionBlurMaxVelocityFar, Scene.PixelMotionBlurMaxVelocityFar);
        Z.bHasDistanceFog = __NFUN_346__(bHasDistanceFogModifier, Z.bHasDistanceFog);
        // End:0x870
        if(int(bHasDistanceFogModifier) + int(0))
        {
            bNotifyActorsInZone = true;
        }
        Z.bHasDOF = __NFUN_346__(bHasDOFModifier, Z.bHasDOF);
        // End:0x8AF
        if(int(bHasDOFModifier) + int(0))
        {
            bNotifyActorsInZone = true;
        }
        // End:0x8EA
        if(SetDistanceFog)
        {
            Z.DistanceFogFadeTime = DistanceFogFadeTime;
            Z.DistanceFog = DistanceFog;
            bNotifyActorsInZone = true;
        }
        // End:0x910
        if(SetDOFBlurAmount)
        {
            Z.DOFBlurAmount = DOFBlurAmount;
            bNotifyActorsInZone = true;
        }
        // End:0x936
        if(SetDOFFocalDist)
        {
            Z.DOFFocalDist = DOFFocalDist;
            bNotifyActorsInZone = true;
        }
        // End:0x95C
        if(SetDOFFocalRangeMin)
        {
            Z.DOFFocalRangeMin = DOFFocalRangeMin;
            bNotifyActorsInZone = true;
        }
        // End:0x982
        if(SetDOFFocalRangeMax)
        {
            Z.DOFFocalRangeMax = DOFFocalRangeMax;
            bNotifyActorsInZone = true;
        }
        // End:0x9D1
        if(bNotifyActorsInZone)
        {
            // End:0x9D0
            foreach __NFUN_747__(class'PlayerPawn', Player)
            {
                // End:0x9CF
                if(__NFUN_339__(Player.Region.Zone, Z))
                {
                    Player.EnteredZone(Z);
                }                
            }            
        }
        // End:0x9EA
        if(bForceReentrance)
        {
            Z.ZoneAltered();
        }
    }
    return;
}

defaultproperties
{
    Texture=Texture'S_AssignZone'
}