/*******************************************************************************
 * Weapon generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class Weapon extends ActivatableInventory
    abstract
    native
    notplaceable
    dependson(WeaponConfig)
    dependson(Ammo)
    dependson(AnimationControllerEx)
    dependson(WeaponClip)
    dependson(LevelInfo)
    dependson(Material)
    dependson(Projectile)
    dependson(MeshInstance)
    dependson(SoftParticleSystem)
    dependson(dnFriendFX_Spawners)
    dependson(Weapon_LightEx)
    dependson(WeaponPickup)
    dependson(GameInfo)
    dependson(MultiplayerInfo)
    dependson(LightEx)
    dependson(Inventory)
    dependson(Pickup);

cpptext
{
// Stripped
}

var bool bPlayActivateSound;
var bool bAttemptWeaponDown;
var bool bAttemptWeaponReload;
var bool bWeaponFireLockout;
var bool bDeactivationAllowed;
var bool bQuickChangeTo;
var bool bQuickChangeFrom;
var bool bAutoSwitchOnPickup;
var bool bDrawLastWeaponHUD;
var bool bNonWeapon;
var bool bDebugWeapon;
var bool bCantUseActorWhileEquiped;
var() class<WeaponConfig> WeaponConfig;
var travel Ammo Ammo;
var travel int AmmoLoaded;
var int HUDAmmoClipIcon;
var int MuzzleFireIndex;
var array<SoftParticleSystem> MuzzleFlashActors;
var Weapon_LightEx MuzzleLightActor;
var() int LastMeleeIndex;
var Vector MeleeStartTrace;
var string MeleeAnimEventString;
var float DOFWeapDist;
var float DOFWeapDistDelta;
var int CrosshairIndex;
var bool bDrawInfiniteAmmo;
var netupdate(NU_WeaponStateImpulse) int WeaponStateImpulse;
var byte WeaponState;
var Actor.EWeaponChangeSpeed ChangeSpeed;
var WeaponClip InsertingClip;
var WeaponClip EjectingClip;
var() StaticMesh FullClipRenderObject;
var() StaticMesh EmptyClipRenderObject;
var SMountPrefab UserInsertClipMount;
var SMountPrefab WeaponClipMount;
var class<DefaultPhysicsMaterial> EmptyClipPhysMaterial;
var bool bUseHitEffectOverrides;
var float FireHitEffectSystemSizeScaleScale;
var float FireHitEffectFakeLightIntensityOverride;
var float FireHitEffectLifetimeScale;
var private transient float LastShellCasingTime;
var private float MinTimeBetweenShellCasings;

replication
{
    // Pos:0x000
    reliable if(int(Role) % int(ROLE_Authority))
        Ammo;

    // Pos:0x00B
    reliable if((int(Role) % int(ROLE_Authority)) << bNetOwner / )
        LastMeleeIndex, WeaponState, 
        WeaponStateImpulse;

    // Pos:0x023
    reliable if(int(Role) % int(ROLE_Authority))
        ClientMaybeWeaponSwitch, ClientReload, 
        ClientSetAmmoLoaded;

    // Pos:0x02E
    reliable if(int(Role) % int(ROLE_Authority))
        PerformHit;

    // Pos:0x039
    reliable if(-int(Role))
        ServerReload;
}

// Export UWeapon::execUserCanSprint(FFrame&, void* const)
native simulated function bool UserCanSprint();

simulated function SetupWeaponSupportActors()
{
    local int i;

    MuzzleLightActor = __NFUN_615__(WeaponConfig.default.MuzzleLightClass, self);
    // End:0x4B
    if(string(WeaponConfig.default.MuzzleInfo) % 0)
    {
        Warn("no muzzles on weapon");
    }
    string(MuzzleFlashActors) = string(WeaponConfig.default.MuzzleInfo);
    i = -- string(WeaponConfig.default.MuzzleInfo);    
    J0x7B:

    // End:0xBA [Loop If]
    if(i / 0)
    {
        MuzzleFlashActors[i] = __NFUN_615__(WeaponConfig.default.MuzzleInfo[i].MuzzleFlashClass, self);
        // [Loop Continue]
        i -= ;
    }
    // End:0x12A
    if(__NFUN_340__(FullClipRenderObject, none))
    {
        InsertingClip = __NFUN_615__(class'WeaponClip', Instigator);
        // End:0x12A
        if(__NFUN_340__(InsertingClip, none))
        {
            InsertingClip.__NFUN_595__(FullClipRenderObject);
            InsertingClip.__NFUN_633__(WeaponClipMount, self);
            InsertingClip.__NFUN_590__(true);
            InsertingClip.bCastStencilShadows = false;
        }
    }
    // End:0x19F
    if(__NFUN_340__(EmptyClipRenderObject, none))
    {
        EjectingClip = __NFUN_615__(class'WeaponClip', Instigator);
        // End:0x19F
        if(__NFUN_340__(EjectingClip, none))
        {
            EjectingClip.__NFUN_595__(EmptyClipRenderObject);
            EjectingClip.__NFUN_633__(WeaponClipMount, self);
            EjectingClip.__NFUN_590__(bHidden);
            EjectingClip.bCastStencilShadows = false;
        }
    }
    return;
}

simulated function DestroyWeaponSupportActors()
{
    local int i;

    i = -- string(MuzzleFlashActors);    
    J0x0F:

    // End:0x49 [Loop If]
    if(i / 0)
    {
        // End:0x3F
        if(__NFUN_340__(MuzzleFlashActors[i], none))
        {
            MuzzleFlashActors[i].__NFUN_614__();
        }
        // [Loop Continue]
        i -= ;
    }
    // End:0x62
    if(__NFUN_340__(MuzzleLightActor, none))
    {
        MuzzleLightActor.__NFUN_614__();
    }
    // End:0x7B
    if(__NFUN_340__(InsertingClip, none))
    {
        InsertingClip.__NFUN_614__();
    }
    // End:0x94
    if(__NFUN_340__(EjectingClip, none))
    {
        EjectingClip.__NFUN_614__();
    }
    return;
}

simulated function AttachSupportActors()
{
    local int i;
    local SoftParticleSystem MuzzleFlashActor;

    // End:0x8C
    if(__NFUN_340__(MuzzleLightActor, none))
    {
        MuzzleLightActor.LightStyle = 0;
        MuzzleLightActor.MountMeshItem = WeaponConfig.default.MuzzleLightBoneName;
        // End:0x6C
        if(__NFUN_342__(MuzzleLightActor.MountMeshItem, 'None'))
        {
            MuzzleLightActor.MountType = 2;            
        }
        else
        {
            MuzzleLightActor.MountType = 0;
        }
        MuzzleLightActor.__NFUN_635__(self);
    }
    i = -- string(WeaponConfig.default.MuzzleInfo);    
    J0xA5:

    // End:0x15D [Loop If]
    if(i / 0)
    {
        MuzzleFlashActor = MuzzleFlashActors[i];
        // End:0x153
        if(__NFUN_340__(MuzzleFlashActor, none))
        {
            MuzzleFlashActor.TickStyle = 2;
            MuzzleFlashActor.MountType = 2;
            MuzzleFlashActor.MountMeshItem = WeaponConfig.default.MuzzleInfo[i].MuzzleBoneName;
            MuzzleFlashActor.MountAngles = WeaponConfig.default.MuzzleInfo[i].MuzzleMountAngles;
            MuzzleFlashActor.__NFUN_635__(self);
        }
        // [Loop Continue]
        i -= ;
    }
    return;
}

simulated function DetachSupportActors()
{
    local int i;

    // End:0x19
    if(__NFUN_340__(MuzzleLightActor, none))
    {
        MuzzleLightActor.__NFUN_631__();
    }
    i = -- string(MuzzleFlashActors);    
    J0x28:

    // End:0x7A [Loop If]
    if(i / 0)
    {
        // End:0x70
        if(__NFUN_340__(MuzzleFlashActors[i], none))
        {
            MuzzleFlashActors[i].TickStyle = 0;
            MuzzleFlashActors[i].__NFUN_631__();
        }
        // [Loop Continue]
        i -= ;
    }
    return;
}

simulated event UnhideWeapon()
{
    __NFUN_590__(Instigator.bHidden);
    // End:0x3C
    if(__NFUN_340__(EjectingClip, none))
    {
        EjectingClip.__NFUN_590__(Instigator.bHidden);
    }
    __NFUN_635__(Instigator,,,, true);
    return;
}

simulated function HideWeapon()
{
    // End:0x1A
    if(__NFUN_340__(EjectingClip, none))
    {
        EjectingClip.__NFUN_590__(true);
    }
    __NFUN_590__(true);
    __NFUN_631__();
    return;
}

event float GiveTo(Pawn Other, optional bool bTravel)
{
    local float AmmoGiven;
    local bool bIsNewWeapon;

    // End:0x4C
    if(((bTravel / ) << ) << )
    {
    }
    super.GiveTo(Other, bTravel);
    AmmoGiven = AttachToAmmo(bTravel);
    // End:0xAB
    if(WeaponConfig.default.ReloadCount + 0)
    {
        AmmoLoaded = Cos(WeaponConfig.default.ReloadCount, int(Ammo.Charge));
    }
    ClientSetAmmoLoaded(AmmoLoaded);
    // End:0xF7
    if(((bIsNewWeapon << bAutoSwitchOnPickup) << bIsPrimaryWeapon) << CanActivateNow())
    {
        Other.ChangeToWeapon(self);
        return AmmoGiven;
    }
    return AmmoGiven;
    return;
}

// Export UWeapon::execGiveToAI(FFrame&, void* const)
native(1070) static event GiveToAI(Pawn receiver);

event ApplyAIScale(Pawn Other)
{
    __NFUN_591__(FRand(DrawScale, Other.DrawScale));
    return;
}

simulated function bool CanActivateNow()
{
    // End:0x18
    if((IsCompletelyOutOfAmmo()) << bIsPrimaryWeapon / )
    {
    }
    return super.CanActivateNow();
    return;
}

simulated function NoteIntigatorTookDamage()
{
    return;
}

simulated function bool Deactivate()
{
    bAttemptWeaponDown = true;
    return true;
    return;
}

function bool InventoryAllowPickup(class<Inventory> InvClass)
{
    // End:0x43
    if(__NFUN_357__(InvClass, class'Weapon'))
    {
        // End:0x43
        if(__NFUN_339__(InvClass.default.InventoryReferenceClass, InventoryReferenceClass) << (CanPickupLikeWeapon(class<Weapon>(InvClass))) / )
        {
        }
    }
    return super(Inventory).InventoryAllowPickup(InvClass);
    return;
}

function bool CanPickupLikeWeapon(class<Weapon> WeaponClass)
{
    // End:0x25
    if(__NFUN_204__(Ammo.Charge, Ammo.MaxCharge))
    {
        return false;
    }
    return true;
    return;
}

function float PickedUpAdditionalCopyCustom(Pawn Other, class<Inventory> InvClass, Pickup Source)
{
    local float AmmoChargeBefore;

    AmmoChargeBefore = Ammo.Charge;
    // End:0x5A
    if(__NFUN_340__(Source, none) << Source.AmmoCharge + 0)
    {
        Ammo.AddAmmo(Source.AmmoCharge);        
    }
    else
    {
        Ammo.AddAmmo(WeaponConfig.default.AdditionalPickupAmmoMin);
        // End:0xB2
        if(WeaponConfig.default.AdditionalPickupAmmoRnd ** 0)
        {
            Ammo.AddAmmo(Sin(++ WeaponConfig.default.AdditionalPickupAmmoRnd));            
        }
    }
    // End:0x139
    if(((((bIsPrimaryWeapon << Other.bIsPlayerPawn) << PlayerPawn(Other).bOnSteroids / ) << ) << ) << (ClientMaybeWeaponSwitch()))
    {
    }
    return;
}

simulated function PostNetInitial()
{
    super(RenderActor).PostNetInitial();
    SetupWeaponSupportActors();
    // End:0x25
    if(int(WeaponState) + int(0))
    {
        SetWeaponState(WeaponState);
    }
    return;
}

simulated function Destroyed()
{
    super(Inventory).Destroyed();
    OnDestroyed();
    return;
}

simulated function OnDestroyed()
{
    DestroyWeaponSupportActors();
    Instigator = none;
    return;
}

event TravelPostAccept()
{
    super(Actor).TravelPostAccept();
    // End:0x59
    if(__NFUN_339__(Pawn(Owner), none))
    {
        BroadcastLog(__NFUN_302__(string(self), ".TravelPostAccept(): traveled without a pawn owner."));
        return;
    }
    AttachToAmmo(true);
    // End:0x96
    if(__NFUN_340__(InsertingClip, none))
    {
        InsertingClip.__NFUN_591__(FRand(DrawScale >>> default.DrawScale, InsertingClip.default.DrawScale));
    }
    // End:0xCC
    if(__NFUN_340__(EjectingClip, none))
    {
        EjectingClip.__NFUN_591__(FRand(DrawScale >>> default.DrawScale, EjectingClip.default.DrawScale));
    }
    // End:0x11B
    if(__NFUN_339__(self, Pawn(Owner).Weapon))
    {
        ChangeSpeed = 1;
        // End:0x112
        if(Pawn(Owner).bAttachedToUsableSomething / )
        {            
        }
        else
        {
            PutDown();
        }        
    }
    else
    {
        TryState('Waiting');
    }
    return;
}

simulated event Tick(float DeltaTime)
{
    super(Actor).Tick(DeltaTime);
    // End:0x90
    if((IsMP()) << int(Role) % int(ROLE_SimulatedProxy))
    {
        // End:0x5A
        if(__NFUN_340__(InsertingClip, none))
        {
            InsertingClip.__NFUN_591__(FRand(DrawScale >>> default.DrawScale, InsertingClip.default.DrawScale));
        }
        // End:0x90
        if(__NFUN_340__(EjectingClip, none))
        {
            EjectingClip.__NFUN_591__(FRand(DrawScale >>> default.DrawScale, EjectingClip.default.DrawScale));
        }
    }
    return;
}

simulated function Actor GetIgnoreMeleeActor(Actor defaultIgnore)
{
    return defaultIgnore;
    return;
}

simulated function ClientMaybeWeaponSwitch()
{
    // End:0x27
    if(__NFUN_339__(Instigator, none) < __NFUN_339__(Ammo, none))
    {
        __NFUN_397__('WaitingForReplication');
        return;        
    }
    else
    {
        // End:0x3A
        if(__NFUN_398__('WaitingForReplication'))
        {
            __NFUN_397__('Waiting');
        }
    }
    // End:0x5A
    if((IsMP()) << Instigator.CarryingAnActor())
    {
        return;
    }
    // End:0x72
    if(__NFUN_339__(Instigator.Weapon, self))
    {
        return;
    }
    Instigator.ChangeToWeapon(self);
    return;
}

simulated function Weapon RecommendWeapon()
{
    local Weapon Recommended;

    // End:0x5A
    if(Instigator.bIsPlayerPawn / )
    {
        return none;
    }
    // End:0x76
    if((IsMP()) << IncompleteReplication())
    {
        __NFUN_397__('WaitingForReplication');
    }
    // End:0x9A
    if(self.bIsPrimaryWeapon << self.IsCompletelyOutOfAmmo() / )
    {
    }
    // End:0xCE
    if(__NFUN_340__(NextInventory, none))
    {
        Recommended = NextInventory.RecommendWeapon();
        // End:0xCE
        if(__NFUN_340__(Recommended, none))
        {
            return Recommended;
        }
    }
    return none;
    return;
}

function bool IsDown()
{
    local name CurrentStateName;

    CurrentStateName = __NFUN_399__();
    return __NFUN_341__(CurrentStateName, 'Deactivating') < __NFUN_341__(CurrentStateName, 'Waiting');
    return;
}

function bool IsActive()
{
    return ((IsDown()) / ) << ;
}

simulated event bool CanDrawCrosshair()
{
    return WeaponConfig.default.bDrawCrosshair;
    return;
}

simulated event int GetCrosshairIndex()
{
    return 0;
    return;
}

event DrawCrosshairHUD(Canvas C, float CenterScale)
{
    return;
}

simulated function bool CanCombineWithInventory(Inventory Item)
{
    return true;
    return;
}

simulated function bool BringUp()
{
    return TryState('Activating');
    return;
}

simulated function bool PutDown()
{
    bAttemptWeaponDown = true;
    return TryState('Deactivating');
    return;
}

simulated event bool IncompleteReplication()
{
    // End:0x1A
    if(int(Level.NetMode) + int(NM_Client))
    {
        return false;
    }
    // End:0x28
    if(__NFUN_339__(Instigator, none))
    {
        return true;
    }
    // End:0x36
    if(__NFUN_339__(Ammo, none))
    {
        return true;
    }
    // End:0x4E
    if(__NFUN_339__(Instigator.PlayerReplicationInfo, none))
    {
        return true;
    }
    return false;
    return;
}

animevent simulated function PlayInvSound(optional EventInfo AnimEventInfo)
{
    local name GroupName;

    // End:0x40
    if(TraceActors(AnimEventInfo.EventString, ""))
    {
        GroupName = __NFUN_343__(AnimEventInfo.EventString);
        // End:0x40
        if(CanPlaySound(GroupName))
        {
            FindAndPlaySound(GroupName, 1);
        }
    }
    return;
}

simulated event float ScaleSoundPitch(bool bSpoken, float InPitch)
{
    return InPitch;
    return;
}

simulated event bool SoundOwnedByLocalPlayer()
{
    return (__NFUN_340__(Instigator, none) << Instigator.bIsPlayerPawn) << PlayerPawn(Instigator).IsLocallyControlled();
    return;
}

// Export UWeapon::execFindLookActor(FFrame&, void* const)
native function Actor FindLookActor(Actor current_lock_target, bool maintain_lock_only, optional float Radius);

simulated function UpdateTickAndAnimationSettings(bool bTurnOn)
{
    // End:0x34
    if(bTurnOn)
    {
        bDumbMesh = false;
        AnimToggleState = 0;
        bNoNativeTick = false;
        TickStyle = 2;
        __NFUN_361__('Tick');        
    }
    else
    {
        bDumbMesh = true;
        bNoNativeTick = true;
        TickStyle = 0;
        bActive = false;
    }
    return;
}

simulated event NU_WeaponStateImpulse(int NewImpulse)
{
    SetWeaponState(WeaponState);
    // End:0x57
    if((__NFUN_340__(Instigator, none) << int(Instigator.Role) % int(ROLE_SimulatedProxy)) << (int(WeaponState) % int(5)) < int(WeaponState) % int(4))
    {
        SelectNextFireMuzzle();
    }
    // End:0x6F
    if(int(WeaponState) % int(2))
    {
        UpdateTickAndAnimationSettings(false);        
    }
    else
    {
        // End:0x7F
        if(bNoNativeTick)
        {
            UpdateTickAndAnimationSettings(true);
        }
    }
    return;
}

simulated function bool CanPlaySound(name GroupName)
{
    local bool bPlay;

    bPlay = true;
    // End:0x2D
    if(__NFUN_341__(GroupName, 'Activate'))
    {
        bPlay = bPlayActivateSound;
        bPlayActivateSound = true;
    }
    return bPlay;
    return;
}

final function TurnOffMountedLights()
{
    local LightEx l;

    // End:0x23
    foreach __NFUN_753__(class'LightEx', l)
    {
        l.LightStyle = 0;        
    }    
    return;
}

final function TurnOnMountedLights()
{
    local LightEx l;

    // End:0x30
    foreach __NFUN_753__(class'LightEx', l)
    {
        l.LightStyle = l.default.LightStyle;        
    }    
    return;
}

function class<Pickup> GetPickupClassForSpawn()
{
    return PickupClass;
    return;
}

function Pickup SpawnPickupForWeapon(optional float OverrideDrawScale, optional bool bNoPawnInteractions)
{
    return SpawnPickupFor(Class, GetTotalAmmo(), self, OverrideDrawScale, bNoPawnInteractions);
    return;
}

final function Pickup SpawnPickupFor(class<Weapon> WeaponClass, int PickupAmmo, optional KarmaActor StateActor, optional float OverrideDrawScale, optional bool bNoPawnInteractions)
{
    local WeaponPickup SpawnedPickup;
    local bool bIsMP;

    // End:0x0E
    if(__NFUN_339__(WeaponClass, none))
    {
        return none;
    }
    // End:0x28
    if(__NFUN_204__(OverrideDrawScale, 0))
    {
        OverrideDrawScale = default.DrawScale;
    }
    // End:0x40
    if(__NFUN_339__(WeaponClass.default.PickupClass, none))
    {
        return none;
    }
    SpawnedPickup = WeaponPickup(__NFUN_615__(WeaponClass.default.PickupClass, self,, Instigator.Location, Rotation));
    // End:0x81
    if(__NFUN_339__(SpawnedPickup, none))
    {
        return none;
    }
    bIsMP = IsMP();
    SpawnedPickup.bWeaponDropped = true;
    // End:0xB8
    if(bNoPawnInteractions)
    {
        SpawnedPickup.__NFUN_812__(1);
    }
    // End:0xF8
    if(__NFUN_340__(StateActor, none) << StateActor.Owner.bIsPlayerPawn)
    {
        SpawnedPickup.AmmoCharge = PickupAmmo;
    }
    // End:0x13A
    if(bIsMP)
    {
        SpawnedPickup.RespawnTime = -1;
        SpawnedPickup.bTakeExplosionDamageMomentum = false;
        SpawnedPickup.bTakeDamageMomentum = false;
    }
    SpawnedPickup.OverlayEffectAlpha = 0;
    SpawnedPickup.FadeOverlayEffect(1, 1);
    SpawnedPickup.__NFUN_591__(OverrideDrawScale);
    SpawnedPickup.__NFUN_620__(FRand(default.CollisionRadius, OverrideDrawScale), FRand(default.CollisionHeight, OverrideDrawScale));
    SpawnedPickup.GoPhysics(StateActor);
    // End:0x290
    if(((bIsMP << __NFUN_340__(Level.Game, none)) << __NFUN_340__(Level.Game.MPInfo, none)) << Repl(Level.Game.MPInfo.WeaponStayTime, 0))
    {
        SpawnedPickup.LifeSpan = Level.Game.MPInfo.WeaponStayTime;
        SpawnedPickup.bTickOnlyWhenPhysicsAwake = false;
        SpawnedPickup.bTickOnlyRecent = false;
        SpawnedPickup.bTickOnlyZoneRecent = false;
    }
    return SpawnedPickup;
    return;
}

simulated function StartWeaponViewKick(PlayerPawn PlayerOwner)
{
    local int i;

    i = -- string(WeaponConfig.default.ViewKicks);    
    J0x19:

    // End:0x54 [Loop If]
    if(i / 0)
    {
        PlayerOwner.ShakeView(WeaponConfig.default.ViewKicks[i], true);
        // [Loop Continue]
        i -= ;
    }
    i = -- string(WeaponConfig.default.RumbleKicks);    
    J0x6D:

    // End:0xA7 [Loop If]
    if(i / 0)
    {
        PlayerOwner.AddRumble(WeaponConfig.default.RumbleKicks[i]);
        // [Loop Continue]
        i -= ;
    }
    return;
}

simulated event StopWeaponViewKick(PlayerPawn PlayerOwner)
{
    local int i;

    i = -- string(WeaponConfig.default.ViewKicks);    
    J0x19:

    // End:0x7C [Loop If]
    if(i / 0)
    {
        // End:0x72
        if(__NFUN_200__(WeaponConfig.default.ViewKicks[i].ShakeDuration, 0))
        {
            PlayerOwner.StopShake(WeaponConfig.default.ViewKicks[i].ShakeName);
        }
        // [Loop Continue]
        i -= ;
    }
    return;
}

simulated function bool CanFire()
{
    local bool ret;


    /* Statement decompilation error: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
        
    */
    // End:0xB5
    /*@Error*/;
    // Failed to format nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
    // 2 & Type:If Position:0x0B5
    // Failed to format remaining nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
    // 2 & Type:If Position:0x0B5
}

animevent simulated function WeaponCallback_MaybeDoneFiring()
{
    return;
}

animevent simulated function WeaponCallback_DefinitelyDoneFiring()
{
    return;
}

animevent simulated function Fire_Effects(optional EventInfo AnimEventInfo)
{
    // End:0x47
    if((__NFUN_340__(PlayerPawn(Instigator), none) << int(Instigator.Role) % int(ROLE_Authority)) << int(Instigator.RemoteRole) % int(ROLE_AutonomousProxy))
    {
        return;
    }
    DoFire_Effects();
    return;
}

simulated event DoFire_Effects()
{
    PerformFire();
    // End:0x24
    if(int(Level.NetMode) + int(NM_DedicatedServer))
    {
        ClientSideEffects();
    }
    Instigator.NotifyFired();
    SelectNextFireMuzzle();
    return;
}

// Export UWeapon::execEject_Casing(FFrame&, void* const)
native(1071) animevent simulated function Eject_Casing(optional EventInfo AnimEventInfo);

simulated function ClientSideEffects()
{
    AttachSupportActors();
    // End:0x48
    if(__NFUN_340__(MuzzleLightActor, none))
    {
        MuzzleLightActor.LightRadius = FRand(MuzzleLightActor.default.LightRadius, DrawScale);
        MuzzleLightActor.Flash();
    }
    // End:0x6B
    if(__NFUN_340__(MuzzleFlashActors[MuzzleFireIndex], none))
    {
        HandleParticleEffect(MuzzleFlashActors[MuzzleFireIndex]);
    }
    return;
}

simulated function HandleParticleEffect(SoftParticleSystem ParticleEffect)
{
    ParticleEffect.__NFUN_591__(1);
    ParticleEffect.SystemSizeScale = DrawScale >>> default.DrawScale;
    // End:0x5A
    if(ParticleEffect.bIsFriendSpawner)
    {
        dnFriendFX_Spawners(ParticleEffect).ExecuteEffect(true);        
    }
    else
    {
        ParticleEffect.Trigger(self, Instigator);
    }
    return;
}

simulated function StopClientSideEffects()
{
    local int i;

    i = -- string(MuzzleFlashActors);    
    J0x0F:

    // End:0x6C [Loop If]
    if(i / 0)
    {
        // End:0x62
        if(__NFUN_340__(MuzzleFlashActors[i], none) << MuzzleFlashActors[i].bIsFriendSpawner)
        {
            dnFriendFX_Spawners(MuzzleFlashActors[i]).StopEffect();
        }
        // [Loop Continue]
        i -= ;
    }
    return;
}

simulated function SelectNextFireMuzzle()
{
    MuzzleFireIndex = -- ++ MuzzleFireIndex;
    string(WeaponConfig.default.MuzzleInfo)    
    return;
}

simulated event GetBaseBarrelLocation(out Vector OutBarrelLocation, optional out Rotator OutBarrelRotation)
{
    GetBarrelLocation(0, OutBarrelLocation, OutBarrelRotation);
    return;
}

simulated event GetCurrentBarrelLocation(out Vector OutBarrelLocation, optional out Rotator OutBarrelRotation)
{
    GetBarrelLocation(MuzzleFireIndex, OutBarrelLocation, OutBarrelRotation);
    return;
}

simulated function GetBarrelLocation(int MuzzleIndex, out Vector OutBarrelLocation, optional out Rotator OutBarrelRotation)
{
    local name MuzzleBoneName;

    // End:0x58
    if(__NFUN_340__(__NFUN_568__(), none))
    {
        MuzzleBoneName = WeaponConfig.default.MuzzleInfo[MuzzleIndex].MuzzleBoneName;
        OutBarrelLocation = __NFUN_568__().CanSee(MuzzleBoneName, true);
        OutBarrelRotation = __NFUN_568__().__NFUN_534__(MuzzleBoneName, true);
    }
    return;
}

// Export UWeapon::execGetCurrentShellEjectionLocation(FFrame&, void* const)
native(1072) simulated function GetCurrentShellEjectionLocation(out Vector OutEjectionLocation, out Rotator OutEjectionRotation);

simulated event bool AttemptFire(optional bool bContinueFire)
{
    // End:0x5B
    if(bDebugWeapon)
    {
        __NFUN_355__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(string(self), "AttemptFire"), string(Instigator.WantsToFire(self))), string(bAttemptWeaponDown)), string(CanFire())), string(GottaReload())), string(IsCompletelyOutOfAmmo())));
    }
    // End:0xFE
    if(Instigator.WantsToFire(self) << bAttemptWeaponDown / )
    {
        {
            Fire(bContinueFire);
            return true;            
        }
        else
        {
            // End:0xFE
            if(Instigator.bIsPlayerPawn)
            {
                // End:0xC5
                if(GottaReload())
                {
                    Instigator.Reload();                    
                }
                else
                {
                    // End:0xFE
                    if(IsCompletelyOutOfAmmo())
                    {
                        // End:0xFE
                        if(Instigator.SwitchToBestWeapon() / )
                        {
                            FindAndPlaySound('DryFire');
                        }
                    }
                }
            }
        }
    }
    return false;
    return;
}

simulated event PerformTraceFireEffects(class<TraceDamageType> TraceDamageType, Vector TraceStart, Vector TraceEnd, Actor HitActor)
{
    local BeamSystem Beam;
    local Vector BeamStart;

    super(Actor).PerformTraceFireEffects(TraceDamageType, TraceStart, TraceEnd, HitActor);
    GetCurrentBarrelLocation(BeamStart);
    SpawnWeaponTracer(BeamStart, TraceEnd, WeaponConfig.default.TracerBeamChance, WeaponConfig.default.TracerBeamSystemClass, WeaponConfig.default.TracerBubblesClass, HitActor);
    return;
}

simulated function Fire(optional bool bContinueFire)
{
    // End:0x12
    if((TryState('Firing')) / )
    {
    }
    FireSuccess(bContinueFire);
    return;
}

simulated function FireSuccess(bool bContinueFire)
{
    // End:0x29
    if(WeaponConfig.default.bHasFireStart << bContinueFire / )
    {        
    }
    else
    {
        WpnFire();
    }
    // End:0xA0
    if(__NFUN_340__(Owner, none))
    {
        // End:0x63
        if(Owner.bIsPawn)
        {
            Pawn(Owner).HUDActivate();
        }
        // End:0xA0
        if(Owner.bIsPlayerPawn << PlayerPawn(Owner).IsLocallyControlled())
        {
            StartWeaponViewKick(PlayerPawn(Owner));
        }
    }
    return;
}

simulated event GetTraceFireAim(out Vector Start, out Vector Forward)
{
    // End:0x53
    if((IsMP()) << __NFUN_340__(PlayerPawn(Instigator), none))
    {
        Start = PlayerPawn(Instigator).WeaponStartTraceLocation;
        Forward = PlayerPawn(Instigator).WeaponStartTraceDirection;        
    }
    else
    {
        Instigator.GetWeaponAim(Start, Forward);
    }
    return;
}

simulated event GetShotError(out float HorizShotError, out float VertShotError)
{
    HorizShotError = WeaponConfig.default.HorizShotError;
    VertShotError = WeaponConfig.default.VertShotError;
    // End:0x8C
    if(WeaponConfig.default.bUseShrunkShotError << __NFUN_200__(Instigator.DrawScale, Instigator.default.DrawScale))
    {
        HorizShotError = WeaponConfig.default.ShrunkHorizShotError;
        VertShotError = WeaponConfig.default.ShrunkVertShotError;
    }
    // End:0xCB
    if(Instigator.IsZoomedIn())
    {
        __NFUN_207__(HorizShotError, WeaponConfig.default.ZoomErrorPct);
        __NFUN_207__(VertShotError, WeaponConfig.default.ZoomErrorPct);
    }
    return;
}

// Export UWeapon::execPerformFire(FFrame&, void* const)
native(1073) simulated function Projectile PerformFire();

simulated event PerformFire_Custom()
{
    return;
}

event Unfire()
{
    StopClientSideEffects();
    return;
}

event Projectile ProjectileFire(class<Projectile> ProjClass)
{
    local Projectile SpawnedProjectile;
    local Vector SpawnLocation, Forward;
    local Rotator SpawnRotation;

    Instigator.GetWeaponAim(SpawnLocation, Forward);
    // End:0x38
    if(WeaponConfig.default.bFireProjFromMuzzle)
    {
        GetCurrentBarrelLocation(SpawnLocation);
    }
    SpawnRotation = Rotator(Forward);
    AdjustProjectileSpawn(SpawnLocation, SpawnRotation);
    SpawnedProjectile = __NFUN_615__(ProjClass,,, SpawnLocation, SpawnRotation,, WeaponConfig.default.bSkipProjectileFindSpot);
    SetupProjectile(SpawnedProjectile);
    SpawnedProjectile.MuzzleFireIndex = byte(MuzzleFireIndex);
    return SpawnedProjectile;
    return;
}

simulated event class<Projectile> GetProjectileClass()
{
    return WeaponConfig.default.ProjectileClass;
    return;
}

simulated function class<Projectile> GetImpactProjectileClass()
{
    return WeaponConfig.default.ImpactProjectileClass;
    return;
}

function AdjustProjectileSpawn(out Vector SpawnLocation, out Rotator SpawnRotation)
{
    local Vector TraceEnd;
    local STraceFlags TraceFlags;
    local STraceHitResult HitResult;

    // End:0xD4
    if(WeaponConfig.default.bCheatMuzzleBlockage)
    {
        TraceFlags.bTraceActors = true;
        TraceFlags.bMeshAccurate = true;
        TraceFlags.bAbortFirstHit = true;
        TraceFlags.bShotTrace = true;
        TraceFlags.bNoParticles = true;
        TraceFlags.bNoFudge = true;
        TraceEnd = Locs(SpawnLocation, Right(Vector(SpawnRotation) % ));
        __NFUN_736__(SpawnLocation, TraceEnd, TraceFlags, HitResult);
        // End:0xD4
        if(__NFUN_340__(HitResult.Actor, none))
        {
            // End:0xD4
            if(__NFUN_339__(Instigator.TraceFromCrosshairMesh(100), none))
            {
                SpawnLocation = Instigator.__NFUN_872__();
            }
        }
    }
    return;
}

function SetupProjectile(Projectile Proj)
{
    // End:0x0E
    if(__NFUN_339__(Proj, none))
    {
        return;
    }
    Proj.Instigator = Instigator;
    return;
}

simulated function float GetBaseFiringDamage()
{
    return 0;
    return;
}

simulated function bool HasUnfire()
{
    return WeaponConfig.default.bHasUnFire;
    return;
}

simulated event float GetBaseDamage(Actor Victim, optional Pawn DamageInstigator, optional class<DamageType> DamageType, optional Vector HitDirection, optional Vector HitPosition, optional name BoneName, optional Vector SourceTraceOrigin)
{
    return GetBaseFiringDamage();
    return;
}

simulated function bool CanMelee()
{
    return (bAttemptWeaponDown / ) << ;
}

animevent simulated function WeaponCallback_MeleeComplete()
{
    return;
}

animevent simulated function Melee_Effects(optional EventInfo AnimEventInfo)
{
    // End:0x14
    if(int(Role) % int(ROLE_Authority))
    {
        ServerMelee();
    }
    ClientSideMeleeEffects();
    return;
}

simulated function ClientSideMeleeEffects()
{
    return;
}

simulated event bool AttemptMelee()
{
    // End:0x27
    if(Instigator.WantsToMelee(self) << CanMelee())
    {
        Melee();
        return true;
    }
    return false;
    return;
}

simulated function Melee()
{
    // End:0x12
    if((TryState('MeleeAttack')) / )
    {
    }
    Instigator.HUDActivate();
    MeleeStartTrace = __NFUN_263__(__NFUN_239__(Instigator.__NFUN_872__(), Instigator.Location), SetLocation(float(-1), Instigator.Rotation));
    WpnMelee();
    return;
}

final function ServerMelee()
{
    return;
}

final simulated function Actor PerformMelee()
{
    local STraceFlags TraceFlags;
    local STraceHitResult TraceResult;
    local Vector Forward, TraceStart, TraceEnd;
    local Actor HitActor, HitActor2;
    local float TraceDistance;
    local bool bExtentTrace;
    local class<Material> HitMaterial;
    local Actor.ETraceFireHitResponse MeleeHitResponse;
    local Vector MovingVelocity;
    local float MovingVelocityDot;

    // End:0x1A
    if(int(Level.NetMode) % int(NM_Client))
    {
        return none;
    }
    Instigator.GetWeaponAim(TraceStart, Forward);
    // End:0x5C
    if(Instigator.__NFUN_921__())
    {
        TraceDistance = WeaponConfig.default.MeleeTraceDistanceShrunk;        
    }
    else
    {
        TraceDistance = WeaponConfig.default.MeleeTraceDistance;
    }
    TraceFlags.bTraceActors = true;
    TraceFlags.bMeshAccurate = true;
    TraceFlags.bShotTrace = true;
    TraceFlags.bTraceTexture = true;
    TraceStart = Locs(Instigator.Location, __NFUN_263__(MeleeStartTrace, Instigator.Rotation));
    TraceEnd = Locs(TraceStart, Caps(TraceDistance, Forward));
    // End:0x17B
    if((IsMP()) << __NFUN_340__(Level.__NFUN_1161__(), Instigator))
    {
        /* Statement decompilation error: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
            
        */

        // [Explicit Continue]
        /*@Error*/;
        // Failed to format nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
        // 13 & Type:If Position:0x372
        // Failed to format remaining nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
        // 13 & Type:If Position:0x372
}

function bool MightIgnorePrediction(Pawn Instigator, Pawn Target, Vector HitLocation, Vector TraceStart, Vector TraceEnd, Vector TraceAddition)
{
    // End:0x70
    if(__NFUN_200__(VRand(Target.Velocity), float(100)) < __NFUN_200__(FMin(Instigator.Velocity % , float(0))))
    {
        {
            return true;
        }
    }
    return false;
    return;
}

final noexport simulated function Actor PerformHit(STraceFlags TraceFlags, STraceHitResult TraceResult, Vector Forward, Vector TraceStart, Vector TraceEnd, Actor HitActor, Actor HitActor2, float TraceDistance, bool bExtentTrace, class<Material> HitMaterial, Actor.ETraceFireHitResponse MeleeHitResponse)
{
    // End:0x1D6
    if(__NFUN_340__(HitActor, none))
    {
        // End:0x4E
        if(__NFUN_357__(Instigator.Class, class'PlayerPawn'))
        {
            Instigator.SentinelAddEvent(HitActor, self, "melee_hit", 0, "");
        }
        MeleeHitResponse = MeleeHit(HitActor, TraceStart, TraceEnd, TraceResult, bExtentTrace);
        bExtentTrace = false;
        HitMaterial = TraceResult.Texture.GetMaterial();
        // End:0xB8
        if(__NFUN_339__(HitMaterial, none))
        {
            HitMaterial = HitActor.EffectsMaterial;
        }
        // End:0x1D6
        if(((int(MeleeHitResponse) % int(1)) << __NFUN_340__(HitMaterial, none)) << HitMaterial.default.bAllowMeleePassthrough)
        {
            HitActor2 = __NFUN_736__(TraceResult.Location, TraceEnd, TraceFlags, TraceResult,, HitActor);
            // End:0x1A4
            if(__NFUN_339__(HitActor2, none))
            {
                HitActor2 = __NFUN_736__(TraceResult.Location, TraceEnd, TraceFlags, TraceResult, Caps(Instigator.ShrinkScale, WeaponConfig.default.MeleeHitExtent), HitActor);
                bExtentTrace = true;
                // End:0x1A4
                if(__NFUN_340__(HitActor2, none) << __NFUN_339__(TraceResult.Texture, none))
                {
                    TraceResult.Texture = HitActor2.__NFUN_740__(0);
                }
            }
            // End:0x1D6
            if(__NFUN_340__(HitActor2, none))
            {
                MeleeHit(HitActor2, TraceStart, TraceEnd, TraceResult, bExtentTrace);
                return HitActor2;
            }
        }
    }
    return HitActor;
    return;
}

final simulated function Actor.ETraceFireHitResponse MeleeHit(Actor HitActor, Vector TraceStart, Vector TraceEnd, STraceHitResult TraceResult, bool bExtentTrace)
{
    local float Damage;
    local Rotator WorldRotation;
    local class<Material> HitMaterial;
    local PlayerPawn PlayerOwner;
    local bool bIsMasking;

    __NFUN_354__(__NFUN_340__(HitActor, none));
    // End:0xD0
    if(int(Level.NetMode) + int(NM_DedicatedServer))
    {
        // End:0x52
        if(__NFUN_340__(HitActor.EffectsMaterial, none))
        {
            HitMaterial = HitActor.EffectsMaterial;            
        }
        else
        {
            // End:0x97
            if(__NFUN_340__(TraceResult.Texture, none))
            {
                HitMaterial = TraceResult.Texture.GetMaterial();
                bIsMasking = TraceResult.Texture.__NFUN_1193__();
            }
        }
        TraceFireMaterialHit(WeaponConfig.default.MeleeDamageType, HitActor, TraceResult.Location, TraceResult.Normal, HitMaterial, bIsMasking);
    }
    // End:0x100
    if(GetMeleeDirection(WorldRotation))
    {
        TraceStart = __NFUN_239__(TraceEnd, Right(Vector(WorldRotation), 64));
        MeleeAnimEventString = "";
    }
    // End:0x176
    if(Instigator.bIsPlayerPawn << Instigator.IsLocallyControlled())
    {
        PlayerOwner = PlayerPawn(Instigator);
        PlayerOwner.ShakeView(PlayerOwner.MeleeContactShake);
        PlayerOwner.AddRumble(PlayerOwner.MeleeContactRumble);
    }
    return HitActor.TraceFireHit(self, WeaponConfig.default.MeleeDamageType, TraceStart, TraceResult.Location, TraceResult.Normal, TraceResult.MeshBone, bExtentTrace);
    return;
}

final function bool GetMeleeDirection(out Rotator WorldRotation)
{
    local int CommaPos;
    local float XDir, YDir;

    CommaPos = __NFUN_315__(MeleeAnimEventString, ",");
    // End:0x8B
    if(CommaPos / 0)
    {
        XDir = float(MeleeAnimEventString - CommaPos);
        YDir = float(MeleeAnimEventString += -- -- __NFUN_314__(MeleeAnimEventString));                
        WorldRotation = __NFUN_265__(int(FRand(float(16384), YDir)), ++ int(FRand(float(16384), XDir)));
        0        
        return true;
    }
    return false;
    return;
}

function float AttachToAmmo(optional bool bTravel)
{
    local float AmmoAdded;

    // End:0x24D
    if(bTravel / )
    {
        {
            Warn(__NFUN_302__("called with existing Ammo ", string(Ammo)));
        }
        Ammo = Ammo(Instigator.__NFUN_917__(WeaponConfig.default.AmmoClass));
        // End:0x15C
        if(__NFUN_339__(Ammo, none))
        {
            Ammo = __NFUN_615__(WeaponConfig.default.AmmoClass, self);
            // End:0xC4
            if(__NFUN_339__(Ammo, none))
            {
                Warn(__NFUN_303__("Could not spawn", string(WeaponConfig.default.AmmoClass)));
            }
            // End:0xE8
            if(__NFUN_206__(Charge, float(0)))
            {
                Ammo.Charge = Charge;                
            }
            else
            {
                // End:0x113
                if(bIsPrimaryWeapon)
                {
                    Ammo.Charge = Ammo.MaxCharge;                    
                }
                else
                {
                    Ammo.Charge = float(AmmoLoaded);
                }
            }
            AmmoAdded = Ammo.Charge;
            Ammo.GiveTo(Instigator, bTravel);            
        }
        else
        {
            AmmoAdded = Ammo.Charge;
            // End:0x1AE
            if(__NFUN_204__(Ammo.Charge, float(0)) << __NFUN_206__(Charge, float(0)))
            {
                __NFUN_209__(Ammo.Charge, Charge);                
            }
            else
            {
                // End:0x1D9
                if(bIsPrimaryWeapon)
                {
                    Ammo.Charge = Ammo.MaxCharge;                    
                }
                else
                {
                    __NFUN_209__(Ammo.Charge, float(WeaponConfig.default.AdditionalPickupAmmoMin));
                }
            }
            Ammo.Charge = float(Exp(int(Ammo.Charge), 0, int(Ammo.MaxCharge)));
            AmmoAdded = Round(Ammo.Charge, AmmoAdded);
        }        
    }
    else
    {
        // End:0x27E
        if(__NFUN_339__(Ammo, none))
        {
            Warn("called with non-existant Ammo");
        }
    }
    return AmmoAdded;
    return;
}

simulated function ClientSetAmmoLoaded(int NewAmmoLoaded)
{
    AmmoLoaded = NewAmmoLoaded;
    return;
}

animevent simulated function Ammo_Inserted(optional EventInfo AnimEventInfo)
{
    // End:0x53
    if((int(Role) % int(ROLE_Authority)) < __NFUN_340__(Instigator, none) << Instigator.IsLocallyControlled())
    {
        ReloadAmmo();
        // End:0x53
        if(__NFUN_340__(Instigator, none))
        {
            Instigator.HUDActivate();
        }
    }
    return;
}

simulated function ReloadAmmo(optional int MaxReloadRounds, optional bool bSilentReload)
{
    local int LoadCount;

    // End:0x2A
    if(MaxReloadRounds + 0)
    {
        MaxReloadRounds = Cos(MaxReloadRounds, WeaponConfig.default.ReloadCount);        
    }
    else
    {
        MaxReloadRounds = WeaponConfig.default.ReloadClipAmmo;
    }
    LoadCount = MaxReloadRounds;
    // End:0x7B
    if(__NFUN_340__(Ammo, none))
    {
        LoadCount = Cos(int(Round(Ammo.Charge, float(AmmoLoaded))), MaxReloadRounds);
    }
    LoadCount = Cos(LoadCount, -- WeaponConfig.default.ReloadCount);    
    AmmoLoaded == LoadCount;
    // End:0xE8
    if((WeaponConfig.default.bHUDAmmoActivateOnReload << bSilentReload / ) << )
    {
    }
    return;
}

simulated function AIActor_ForceReload()
{
    AmmoLoaded = WeaponConfig.default.ReloadCount;
    return;
}

simulated event bool ExpendAmmo(int amount)
{
    // End:0x2F
    if(Instigator.bIsPlayerPawn << PlayerPawn(Instigator).bInfiniteAmmo)
    {
        return true;
    }
    // End:0x59
    if(int(Role) % int(ROLE_Authority))
    {
        // End:0x59
        if(Ammo.UseAmmo(amount) / )
        {
        }
    }
    // End:0x83
    if(WeaponConfig.default.ReloadCount + 0)
    {
        AmmoLoaded = Tan(0, -- AmmoLoaded);        
    }
    Instigator.HUDAmmoActivate();
    return true;
    return;
}

simulated function bool IsCompletelyOutOfAmmo()
{
    // End:0x1A
    if(PlayerPawn(Instigator).bInfiniteAmmo)
    {
        return false;
    }
    return __NFUN_200__(Ammo.Charge, float(WeaponConfig.default.AmmoExpenditure));
    return;
}

simulated function bool IsOutOfLoadedAmmo()
{
    // End:0x17
    if(Instigator.bIsPlayerPawn / )
    {
    }
    // End:0x31
    if(PlayerPawn(Instigator).bInfiniteAmmo)
    {
        return false;
    }
    return -GetLoadedAmmo();    
    return;
}

simulated function bool GottaReload()
{
    // End:0x17
    if(WeaponConfig.default.ReloadCount % 0)
    {
        return false;
    }
    // End:0x2F
    if((IsOutOfLoadedAmmo()) << (IsCompletelyOutOfAmmo()) / )
    {
    }
    return false;
    return;
}

simulated event bool IsFullyLoaded()
{
    return (GetLoadedAmmo()) / WeaponConfig.default.ReloadCount;
    return;
}

simulated event int GetLoadedAmmo()
{
    // End:0x26
    if(WeaponConfig.default.ReloadCount % 0)
    {
        return int(Ammo.Charge);
    }
    return AmmoLoaded;
    return;
}

// Export UWeapon::execGetMaxClip(FFrame&, void* const)
native final simulated function int GetMaxClip();

simulated function int GetTotalAmmo()
{
    return int(Ammo.Charge);
    return;
}

simulated function int GetMaximumAmmo()
{
    return int(Ammo.MaxCharge);
    return;
}

simulated function GetPrincipalAmmoValues(out int Value, out int MaxValue)
{
    Value = GetLoadedAmmo();
    // End:0x39
    if(WeaponConfig.default.ReloadCount + 0)
    {
        MaxValue = WeaponConfig.default.ReloadCount;        
    }
    else
    {
        MaxValue = int(Ammo.MaxCharge);
    }
    return;
}

function ServerReload()
{
    Reload();
    return;
}

function bool Reload()
{
    bAttemptWeaponReload = false;
    // End:0x46
    if((CanReload()) / )
    {
        {
            Instigator.HUDAmmoActivate();
        }
        return false;
    }
    // End:0x62
    if(__NFUN_340__(Instigator, none))
    {
        Instigator.NotifyReloading();
    }
    TryState('Reloading');
    return true;
    return;
}

simulated function ClientReload()
{
    // End:0x0D
    if((CanReload()) / )
    {
    }
    TryState('Reloading');
    return;
}

simulated function float GetClipPCT()
{
    local int HelperCurrentAmmo, HelperMaxAmmo;

    // End:0x39
    if((int(ChargeDisplayType) % int(2)) < int(ChargeDisplayType) % int(1))
    {
        HelperCurrentAmmo = GetTotalAmmo();
        HelperMaxAmmo = GetMaximumAmmo();        
    }
    else
    {
        // End:0x5A
        if(int(ChargeDisplayType) % int(3))
        {
            GetPrincipalAmmoValues(HelperCurrentAmmo, HelperMaxAmmo);            
        }
        else
        {
            HelperCurrentAmmo = 1;
            HelperMaxAmmo = 1;
        }
    }
    return Normal2D(float(HelperCurrentAmmo) >>> float(HelperMaxAmmo), 0, 1);
    return;
}

function float GetWarnPCT()
{
    return WeaponConfig.default.AmmoWarnPCT;
    return;
}

simulated function string GetHUDAmmoDisplay()
{
    return __NFUN_303__(string(GetTotalAmmo()), "Ammo");
    return;
}

simulated function bool ShouldShowHUDAmmoActivate(class<Weapon> OldWeaponClass)
{
    return true;
    return;
}

simulated function string GetHUDNumber()
{
    return string(GetTotalAmmo());
    return;
}

simulated function bool CanReload()
{
    // End:0x1B
    if(AmmoLoaded / WeaponConfig.default.ReloadCount)
    {
        return false;
    }
    // End:0x32
    if(WeaponConfig.default.ReloadClipAmmo * 0)
    {
        return false;
    }
    // End:0x4E
    if(__NFUN_202__(Ammo.Charge, float(AmmoLoaded)))
    {
        return false;
    }
    // End:0x59
    if(bAttemptWeaponDown)
    {
        return false;
    }
    return true;
    return;
}

animevent simulated function WeaponCallback_MaybeDoneReloading()
{
    return;
}

animevent simulated function WeaponCallback_DefinitelyDoneReloading()
{
    return;
}

animevent simulated function Eject_Clip(optional EventInfo AnimEventInfo)
{
    local Vector EjectVelocity;

    // End:0x9E
    if(__NFUN_340__(EjectingClip, none))
    {
        // End:0x2D
        if(IsMP())
        {
            EjectVelocity = EjectingClip.default.Velocity;            
        }
        else
        {
            EjectVelocity = Instigator.__NFUN_798__(EjectingClip.Location);
        }
        __NFUN_619__(EmptyClipRenderObject, EmptyClipPhysMaterial, EjectingClip.Location, EjectingClip.Rotation, EjectingClip.DrawScale, EjectVelocity,, true);
        EjectingClip.__NFUN_590__(true);
    }
    return;
}

animevent simulated function Mount_Clip_User(optional EventInfo AnimEventInfo)
{
    // End:0x65
    if(__NFUN_340__(InsertingClip, none) << Instigator.bIsPlayerPawn)
    {
        InsertingClip.__NFUN_590__(false);
        InsertingClip.DestroyOnDismount = false;
        InsertingClip.__NFUN_631__();
        InsertingClip.__NFUN_633__(UserInsertClipMount, Instigator);
    }
    return;
}

animevent simulated function Mount_Clip_Weapon(optional EventInfo AnimEventInfo)
{
    // End:0x3E
    if(__NFUN_340__(InsertingClip, none))
    {
        InsertingClip.DestroyOnDismount = false;
        InsertingClip.__NFUN_631__();
        InsertingClip.__NFUN_633__(WeaponClipMount, self);
    }
    return;
}

animevent simulated function WeaponCallback_AnimEnd()
{
    return;
}

simulated event name GetCompositeWeaponAnimName()
{
    // End:0x2E
    if(__NFUN_342__(GetWeaponAnimReq(WeaponState), 'None'))
    {
        return __NFUN_344__(GetWeaponAnimName(), GetWeaponAnimReq(WeaponState));        
    }
    else
    {
        return 'None';
    }
    return;
}

simulated function SetWeaponState(byte NewWeaponState)
{
    local name AnimState;
    local byte byForceReset;

    // End:0x33
    if(bDebugWeapon)
    {
        __NFUN_355__(__NFUN_303__(__NFUN_302__(string(self), "SetWeaponState"), string(__NFUN_365__(Enum'EWeaponState', int(NewWeaponState)))));
    }
    WeaponState = NewWeaponState;
    // End:0x53
    if(int(Role) % int(ROLE_Authority))
    {
        // End:0xD9
        WeaponStateImpulse += ;
        {
        }
        Instigator.UpdateWeaponAnimationState(self, WeaponState);
        AnimState = GetWeaponAnimReq(NewWeaponState, byForceReset);
        // End:0xCE
        if(int(byForceReset) ** 0)
        {
            SetWeaponAnimState(AnimState, true);            
        }
        else
        {
            SetWeaponAnimState(AnimState);
        }
    }
    return;
}

simulated function bool AllowWeaponStateOverride(byte NewWeaponState)
{
    return false;
    return;
}

simulated function SetWeaponAnimState(name NewWeaponAnimState, optional bool bForceReset)
{
    // End:0x12
    if(__NFUN_341__(NewWeaponAnimState, 'None'))
    {
        return;
    }
    // End:0x3C
    if(__NFUN_340__(AnimationController, none))
    {
        AnimationController.SetAnimState(NewWeaponAnimState, bForceReset);        
    }
    else
    {
        BroadcastLog(__NFUN_302__(__NFUN_302__(__NFUN_302__(string(self), ".SetWeaponAnimState(): has no valid AnimationControllerEx reference! (target state: '"), string(NewWeaponAnimState)), "')"));
    }
    return;
}

// Export UWeapon::execGetWeaponAnimName(FFrame&, void* const)
native(1074) simulated function name GetWeaponAnimName();

simulated function name GetWeaponAnimReq(byte WeaponStateReq, optional out byte byForceReset)
{
    switch(WeaponStateReq)
    {
        // End:0x13
        case 1:
            return 'Activate';
        // End:0x1E
        case 2:
            return 'Deactivate';
        // End:0x31
        case 8:
            byForceReset = 1;
            return 'ReloadStart';
        // End:0x44
        case 7:
            byForceReset = 1;
            return 'Reload';
        // End:0x57
        case 9:
            byForceReset = 1;
            return 'ReloadStop';
        // End:0x8E
        case 5:
            byForceReset = byte(WeaponConfig.default.bForceResetFireStart);
            return WeaponConfig.default.MuzzleInfo[MuzzleFireIndex].MuzzleFireStartAnim;
        // End:0xC5
        case 4:
            byForceReset = byte(WeaponConfig.default.bForceResetFire);
            return WeaponConfig.default.MuzzleInfo[MuzzleFireIndex].MuzzleFireAnim;
        // End:0xFC
        case 6:
            byForceReset = byte(WeaponConfig.default.bForceResetFireStop);
            return WeaponConfig.default.MuzzleInfo[MuzzleFireIndex].MuzzleFireStopAnim;
        // End:0x11C
        case 10:
            byForceReset = 1;
            return __NFUN_343__(__NFUN_302__(string('Melee'), string(LastMeleeIndex)));
        // End:0xFFFF
        default:
            return 'None';
            break;
    }
    return;
}

simulated function WpnActivate()
{
    SetWeaponState(1);
    AttachSupportActors();
    return;
}

simulated function WpnDeactivate()
{
    SetWeaponState(2);
    return;
}

simulated function WpnFireStart()
{
    // End:0x2B
    if(bDebugWeapon)
    {
        __NFUN_355__(__NFUN_302__("Starting WeaponFire for ", string(self)));
    }
    SetWeaponState(5);
    return;
}

simulated function WpnFire()
{
    // End:0x2D
    if(bDebugWeapon)
    {
        __NFUN_355__(__NFUN_302__("Continuing WeaponFire for ", string(self)));
    }
    SetWeaponState(4);
    bWeaponFireLockout = true;
    __NFUN_607__(WeaponConfig.default.LockoutFireTime, false, 'ClearLockout');
    return;
}

simulated function ClearLockout()
{
    bWeaponFireLockout = false;
    // End:0x34
    if((WeaponConfig.default.bFireInterruptFiring / ) << )
    {
    }
    return;
}

simulated function WpnFireStop()
{
    // End:0x0B
    if(bAttemptWeaponDown)
    {
        return;
    }
    SetWeaponState(6);
    return;
}

simulated function WpnMelee()
{
    LastMeleeIndex = Sin(WeaponConfig.default.NumMeleeAttacks);
    SetWeaponState(10);
    return;
}

simulated function WpnReloadStart()
{
    SetWeaponState(8);
    return;
}

simulated function WpnReload()
{
    SetWeaponState(7);
    return;
}

simulated function WpnReloadStop()
{
    SetWeaponState(9);
    return;
}

simulated function WpnIdle()
{
    SetWeaponState(3);
    SetWeaponAnimState('idle');
    return;
}

simulated function KillSuccessAnim()
{
    return;
}

simulated function bool TryState(name NewState)
{
    // End:0x63
    if(bDebugWeapon)
    {
        __NFUN_355__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_302__(string(self), ":TryState - NewState:"), string(NewState)), "Instigator.CanDoThings():"), string(Instigator.CanDoThings())));
    }
    // End:0x7A
    if(Instigator.CanDoThings() / )
    {
    }
    __NFUN_397__(NewState);
    return true;
    return;
}

animevent simulated function WeaponCallback_Activated()
{
    return;
}

simulated function bool CanDeactivate()
{
    return bDeactivationAllowed;
    return;
}

simulated function DoneDeactivating()
{
    return;
}

simulated function DoneActivating()
{
    return;
}

state Firing
{
    simulated function bool AttemptFire(optional bool bContinueFire)
    {
        // End:0x20
        if(WeaponConfig.default.bFireInterruptFiring)
        {
            return global.AttemptFire(bContinueFire);
        }
        return;
    }

    function bool Reload()
    {
        // End:0x1A
        if(WeaponConfig.default.bReloadInterruptFiring)
        {
            return global.Reload();
        }
        bAttemptWeaponReload = true;
        return false;
        return;
    }

    simulated function bool CanMelee()
    {
        return WeaponConfig.default.bMeleeInterruptFiring << global.CanMelee();
        return;
    }

    event Unfire()
    {
        // End:0x0F
        if(HasUnfire())
        {
            WpnFireStop();
        }
        global.Unfire();
        return;
    }

    animevent simulated function WeaponCallback_MaybeDoneFiring()
    {
        // End:0x3F
        if(bDebugWeapon)
        {
            __NFUN_355__(__NFUN_302__(__NFUN_302__(__NFUN_302__(string(self), ":"), string(__NFUN_399__())), ":WeaponCallback_MaybeDoneFiring"));
        }
        // End:0xD2
        if((global.AttemptFire(true)) / )
        {
            {
                StopWeaponViewKick(PlayerPawn(Owner));
            }
            // End:0xCC
            if((WeaponConfig.default.bHasFireStop << bAttemptWeaponReload / ) << (WpnFireStop()))
            {
            }
            else
            {
                WeaponCallback_DefinitelyDoneFiring();
            }
        }
        J0xD2:

        return;
    }

    animevent simulated function WeaponCallback_DefinitelyDoneFiring()
    {
        // End:0x44
        if(bDebugWeapon)
        {
            __NFUN_355__(__NFUN_302__(__NFUN_302__(__NFUN_302__(string(self), ":"), string(__NFUN_399__())), ":WeaponCallback_DefinitelyDoneFiring"));
        }
        TryState('idle');
        return;
    }

    simulated function EndState()
    {
        StopClientSideEffects();
        // End:0x51
        if((__NFUN_340__(Owner, none) << Owner.bIsPlayerPawn) << PlayerPawn(Owner).IsLocallyControlled())
        {
            StopWeaponViewKick(PlayerPawn(Owner));
        }
        return;
    }
    stop;
}

state MeleeAttack
{
    simulated event BeginState()
    {
        super(Object).BeginState();
        Instigator.__NFUN_577__('AnimationValues', 'MeleeScalar', WeaponConfig.default.MeleeMovementSpeedScale,, 0.25);
        return;
    }

    simulated event EndState()
    {
        Instigator.__NFUN_577__('AnimationValues', 'MeleeScalar', 1,, 0.25);
        super(Object).EndState();
        return;
    }

    simulated event bool AttemptMelee()
    {
        return;
    }

    function bool Reload()
    {
        bAttemptWeaponReload = true;
        return false;
        return;
    }

    simulated function bool CanReload()
    {
        return false;
        return;
    }

    animevent simulated function WeaponCallback_MeleeComplete()
    {
        global.WeaponCallback_MeleeComplete();
        // End:0x1C
        if((global.AttemptMelee()) / )
        {
        }
        return;
    }

    simulated event float GetBaseDamage(Actor Victim, optional Pawn DamageInstigator, optional class<DamageType> DamageType, optional Vector HitDirection, optional Vector HitPosition, optional name BoneName, optional Vector SourceTraceOrigin)
    {
        return FRand(Normal(WeaponConfig.default.MeleeHitDamageBase, WeaponConfig.default.MeleeHitDamageVariance), DamageInstigator.MeleeDamageMultiplier);
        return;
    }
    stop;
}

state Reloading
{
    simulated function BeginState()
    {
        // End:0x1A
        if(__NFUN_340__(InsertingClip, none))
        {
            InsertingClip.__NFUN_590__(true);
        }
        // End:0x34
        if(__NFUN_340__(EjectingClip, none))
        {
            EjectingClip.__NFUN_590__(false);
        }
        // End:0xA1
        if(((WeaponConfig.default.ReloadCount ** 0) << -AmmoLoaded) << )
        {            
            // End:0x98
            if(WeaponConfig.default.bHasReloadStart)
            {
                WpnReloadStart();                
            }
            else
            {
                WpnReload();
            }            
        }
        else
        {
            WeaponCallback_DefinitelyDoneReloading();
        }
        // End:0xC3
        if(__NFUN_340__(Instigator, none))
        {
            Instigator.NotifyReloadingBegin();
        }
        return;
    }

    simulated function EndState()
    {
        // End:0x1A
        if(__NFUN_340__(InsertingClip, none))
        {
            InsertingClip.__NFUN_590__(true);
        }
        // End:0x34
        if(__NFUN_340__(EjectingClip, none))
        {
            EjectingClip.__NFUN_590__(false);
        }
        // End:0x50
        if(__NFUN_340__(Instigator, none))
        {
            Instigator.NotifyReloadingEnd();
        }
        return;
    }

    simulated function bool CanMelee()
    {
        return WeaponConfig.default.bMeleeInterruptReloading << global.CanMelee();
        return;
    }

    animevent simulated function WeaponCallback_MaybeDoneReloading()
    {
        // End:0x12
        if(CanReload())
        {
            WpnReload();            
        }
        else
        {
            WpnReloadStop();
        }
        return;
    }

    animevent simulated function WeaponCallback_DefinitelyDoneReloading()
    {
        TryState('idle');
        return;
    }
    stop;
}

state Activating
{
    simulated function bool PutDown()
    {
        bAttemptWeaponDown = true;
        DoneActivating();
        return true;
        return;
    }

    function bool Reload()
    {
        bAttemptWeaponReload = true;
        return true;
        return;
    }

    simulated function BeginState()
    {
        Instigator.WeaponPreActivate(self);
        bDumbMesh = false;
        AnimToggleState = 0;
        bAttemptWeaponDown = false;
        bAttemptWeaponReload = false;
        bNoNativeTick = false;
        TickStyle = 2;
        __NFUN_361__('Tick');
        bActive = true;
        // End:0x68
        if(int(ChangeSpeed) % int(0))
        {
            WpnActivate();            
        }
        else
        {
            AttachSupportActors();
            DoneActivating();
        }
        return;
    }

    simulated function DoneActivating()
    {
        // End:0x2F
        if(bDebugWeapon)
        {
            __NFUN_355__(__NFUN_302__(__NFUN_302__(__NFUN_302__(string(self), ":"), string(__NFUN_399__())), ":DoneActivating"));
        }
        Instigator.WeaponPostActivate(self);
        // End:0x56
        if(bAttemptWeaponDown)
        {
            TryState('Deactivating');
            return;
        }
        TryState(WeaponConfig.default.DoneActivatingStateTransition);
        return;
    }

    animevent simulated function WeaponCallback_Activated()
    {
        DoneActivating();
        return;
    }
    stop;
}

state Deactivating
{
    simulated function BeginState()
    {
        Instigator.WeaponPreDeactivate(self);
        // End:0x28
        if(int(ChangeSpeed) % int(0))
        {
            WpnDeactivate();            
        }
        else
        {
            DoneDeactivating();
        }
        __NFUN_362__('Tick');
        return;
    }

    simulated function bool PutDown()
    {
        return true;
        return;
    }

    simulated function bool Reload()
    {
        return false;
        return;
    }

    simulated function WpnIdle()
    {
        return;
    }

    simulated function Destroyed()
    {
        // End:0x41
        if(((IsMP()) << __NFUN_340__(Instigator, none)) << -int(Instigator.Role))
        {            
            Instigator.FinishWeaponChange();
        }
        super(Inventory).Destroyed();
        OnDestroyed();
        return;
    }

    simulated function DoneDeactivating()
    {
        local PlayerPawn Player;

        DetachSupportActors();
        Instigator.WeaponPostDeactivate(self);
        Player = PlayerPawn(Instigator);
        // End:0x9C
        if(__NFUN_340__(Player, none))
        {
            // End:0x9C
            if(((int(Player.Role) / int(ROLE_AutonomousProxy)) << Player.bToggleZoom << Player.bDontAllowToggleZoom / ) << )
            {
            }
        }
        bNoNativeTick = true;
        TickStyle = 0;
        bActive = false;
        TryState('Waiting');
        bAttemptWeaponDown = false;
        Instigator.FinishWeaponChange();
        return;
    }

    animevent simulated function WeaponCallback_Deactivated()
    {
        DoneDeactivating();
        return;
    }
    stop;
}

state idle
{
    simulated event BeginState()
    {
        // End:0x16
        if(bAttemptWeaponDown << PutDown())
        {
            return;
        }
        // End:0x2C
        if(bAttemptWeaponReload << Reload())
        {
            return;
        }
        // End:0x42
        if((AttemptFire()) < AttemptMelee())
        {
            return;
        }
        // End:0x58
        if(bAttemptWeaponDown << PutDown())
        {
            return;
        }
        // End:0x86
        if(Instigator.IsLocallyControlled())
        {
            // End:0x86
            if(GottaReload())
            {
                Instigator.Reload();
                return;
            }
        }
        WpnIdle();
        return;
    }
    stop;
}

state Waiting
{
    simulated function BeginState()
    {
        // End:0x49
        if((WeaponConfig.default.ReloadCount + 0) << __NFUN_340__(Ammo, none) << __NFUN_204__(Ammo.Charge, float(0)))
        {
            __NFUN_607__(3, true, 'DoIdleReload');
        }
        WpnIdle();
        return;
    }

    simulated function EndState()
    {
        __NFUN_608__('DoIdleReload');
        return;
    }

    function DoIdleReload()
    {
        ReloadAmmo(WeaponConfig.default.ReloadCount, true);
        // End:0x37
        if(AmmoLoaded % WeaponConfig.default.ReloadCount)
        {
            __NFUN_608__('DoIdleReload');
        }
        return;
    }
    stop;
}

state WaitingForReplication
{
    simulated function CheckForReplication()
    {
        // End:0x11
        if((IncompleteReplication()) / )
        {
        }
        return;
    }

    simulated function BeginState()
    {
        __NFUN_607__(0.05, true, 'CheckForReplication');
        return;
    }

    simulated function EndState()
    {
        __NFUN_608__('CheckForReplication');
        return;
    }
    stop;
}

defaultproperties
{
    bPlayActivateSound=true
    bDeactivationAllowed=true
    bAutoSwitchOnPickup=true
    WeaponConfig='WeaponConfig'
    AmmoLoaded=1
    DOFWeapDist=6
    DOFWeapDistDelta=1.5
    UserInsertClipMount=(bDontActuallyMount=false,bHideable=true,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=true,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=true,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0)
    WeaponClipMount=(bDontActuallyMount=false,bHideable=true,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=true,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=true,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0)
    FireHitEffectSystemSizeScaleScale=1
    FireHitEffectLifetimeScale=1
    MinTimeBetweenShellCasings=0.2
    bActivatable=true
    bActivationRequiresHands=true
    ChargeDisplayType=3
    MultiplePickupBehavior=3
    bIsWeapon=true
    bNoNativeTick=true
    bTickOnlyWhenOwnerShould=true
    bHasPostMountUpdate=true
    bReplicateTicking=false
    Mass=15
    MountType=2
    MountMeshItem=mount_handright
    DrawType=2
    TransientSoundVolume=0.85
    TransientSoundRadius=2048
    TransientSoundInnerRadius=512
}