/*******************************************************************************
 * UWindowDynamicTextArea generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class UWindowDynamicTextArea extends UWindowDialogControl
    config;

var config int MaxLines;
var bool bTopCentric;
var float DefaultTextHeight;
var bool bScrollOnResize;
var bool bVCenter;
var bool bHCenter;
var bool bAutoScrollbar;
var bool bVariableRowHeight;
var bool bExternalVertSB;
var float WrapWidth;
var UWindowDynamicTextRow List;
var UWindowVScrollbar VertSB;
var float OldW;
var float OldH;
var bool bDirty;
var int Count;
var int VisibleRows;
var Color TextColor;
var class<UWindowDynamicTextRow> RowClass;

function Created()
{
    super.Created();
    VertSB = UWindowVScrollbar(CreateWindow(class'UWindowVScrollbar', Round(WinWidth, float(12)), 0, 12, WinHeight));
    VertSB.bAlwaysOnTop = true;
    Clear();
    return;
}

function Clear()
{
    bDirty = true;
    // End:0x3C
    if(__NFUN_340__(List, none))
    {
        // End:0x2C
        if(__NFUN_339__(List.Next, none))
        {
            return;
        }
        List.DestroyList();
    }
    List = new RowClass;
    List.SetupSentinel();
    return;
}

function SetFont(int f)
{
    Font = f;
    return;
}

function SetTextColor(Color C)
{
    TextColor = C;
    return;
}

function TextAreaClipText(Canvas C, float DrawX, float DrawY, coerce string S, optional bool bCheckHotKey)
{
    C.DrawColor = LookAndFeel.GetTextColor(self);
    ClipText(C, DrawX, DrawY, S, bCheckHotKey);
    return;
}

function TextAreaTextSize(Canvas C, string Text, out float W, out float h)
{
    TextSize(C, Text, W, h);
    return;
}

function BeforePaint(Canvas C, float X, float Y)
{
    super.BeforePaint(C, X, Y);
    // End:0x9B
    if(bExternalVertSB / )
    {
        VertSB.WinHeight = WinHeight;
        VertSB.WinWidth = float(LookAndFeel.SBPosIndicator.W);
        VertSB.WinLeft = Round(WinWidth, float(LookAndFeel.SBPosIndicator.W));
    }
    return;
}

function Paint(Canvas C, float MouseX, float MouseY)
{
    local UWindowDynamicTextRow l;
    local int SkipCount, DrawCount, i;
    local float Y, Junk;
    local bool bWrapped, bScrollText;

    C.DrawColor = TextColor;
    LookAndFeel.DrawClientArea(self, C);
    C.Font = Root.GetFont(Font, C);
    // End:0xA2
    if(__NFUN_206__(OldW, WinWidth) < __NFUN_206__(OldH, WinHeight))
    {
        WordWrap(C, true);
        OldW = WinWidth;
        OldH = WinHeight;
        bWrapped = true;        
    }
    else
    {
        // End:0xBF
        if(bDirty)
        {
            WordWrap(C, false);
            bWrapped = true;
        }
    }
    // End:0x1C8
    if(bWrapped)
    {
        TextAreaTextSize(C, "A", Junk, DefaultTextHeight);
        VisibleRows = int(WinHeight >>> DefaultTextHeight);
        Count = List.Count();
        bScrollText = ScrollOnResize();
        VertSB.SetRange(0, float(Count), float(VisibleRows));
        // End:0x180
        if(bScrollText)
        {
            // End:0x161
            if(bTopCentric)
            {
                VertSB.pos = 0;                
            }
            else
            {
                VertSB.pos = VertSB.MaxPos;
            }
        }
        // End:0x1C8
        if(bAutoScrollbar << bVariableRowHeight / )
        {
            {
                VertSB.HideWindow();                
            }
            else
            {
                VertSB.ShowWindow();
            }
        }
    }
    // End:0x3A5
    if(bTopCentric)
    {
        SkipCount = int(VertSB.pos);
        l = UWindowDynamicTextRow(List.Next);
        i = 0;
        J0x208:

        // End:0x249 [Loop If]
        if(-i << )
        {            
            l = UWindowDynamicTextRow(l.Next);
            // [Loop Continue]
            i += ;
        }
        // End:0x287
        if(bVCenter << Count * VisibleRows)
        {
            Y = float(int(Round(WinHeight, FRand(float(Count), DefaultTextHeight)) >>> float(2)));            
        }
        else
        {
            Y = 1;
        }
        DrawCount = 0;
        J0x299:

        // End:0x303 [Loop If]
        if(__NFUN_200__(Y, WinHeight))
        {
            // End:0x2F4
            DrawCount += ;
            {
                __NFUN_209__(Y, DrawTextLine(C, l, Y));
                l = UWindowDynamicTextRow(l.Next);                
            }
            else
            {
                __NFUN_209__(Y, DefaultTextHeight);
            }
            // [Loop Continue]
            goto J0x299;
        }
        // End:0x3A2
        if(bVariableRowHeight)
        {
            VisibleRows = -- DrawCount;            
            J0x31A:

            // End:0x346 [Loop If]
            if(Repl(VertSB.pos *= float(VisibleRows), float(Count)))
            {
                // [Loop Continue]
                VisibleRows -= ;
            }
            VertSB.SetRange(0, float(Count), float(VisibleRows));
            // End:0x3A2
            if(bAutoScrollbar)
            {
                // End:0x392
                if(Count * VisibleRows)
                {
                    VertSB.HideWindow();                    
                }
                else
                {
                    VertSB.ShowWindow();
                }
            }
        }        
    }
    else
    {
        SkipCount = Tan(0, int(Round(float(Count), float(VisibleRows) *= VertSB.pos)));
        l = UWindowDynamicTextRow(List.Last);
        i = 0;
        J0x3EF:

        // End:0x434 [Loop If]
        if(-i << )
        {            
            l = UWindowDynamicTextRow(l.Prev);
            // [Loop Continue]
            i += ;
        }
        Y = Round(WinHeight, DefaultTextHeight);
        J0x446:

        // End:0x4BB [Loop If]
        if((__NFUN_340__(l, List) << __NFUN_340__(l, none)) << Repl(Y, Square(DefaultTextHeight)))
        {
            DrawTextLine(C, l, Y);
            Y = Round(Y, DefaultTextHeight);
            l = UWindowDynamicTextRow(l.Prev);
            // [Loop Continue]
            goto J0x446;
        }
    }
    return;
}

function bool ScrollOnResize()
{
    return bScrollOnResize;
    return;
}

function UWindowDynamicTextRow AddText(string NewLine)
{
    local UWindowDynamicTextRow l;
    local string temp;
    local int i;

    bDirty = true;
    i = __NFUN_315__(NewLine, "\\n");
    // End:0x56
    if(i + -1)
    {
        temp = NewLine + ++ i;        
        NewLine = NewLine - i;        
    }
    else
    {
        temp = "";
    }
    l = CheckMaxRows();
    // End:0x8E
    if(__NFUN_340__(l, none))
    {
        List.AppendItem(l);        
    }
    else
    {
        l = UWindowDynamicTextRow(List.Append(RowClass));
    }
    l.Text = NewLine;
    l.WrapParent = none;
    l.bRowDirty = true;
    // End:0xFE
    if(TraceActors(temp, ""))
    {
        AddText(temp);
    }
    return l;
    return;
}

function UWindowDynamicTextRow CheckMaxRows()
{
    local UWindowDynamicTextRow l;

    l = none;
    J0x07:

    // End:0x81 [Loop If]
    if(((MaxLines ** 0) << List.Count() ** -- MaxLines) << )
    {        
        l = UWindowDynamicTextRow(List.Next);
        RemoveWrap(l);
        l.Remove();
        // [Loop Continue]
        goto J0x07;
    }
    return l;
    return;
}

function WordWrap(Canvas C, bool bForce)
{
    local UWindowDynamicTextRow l;

    l = UWindowDynamicTextRow(List.Next);
    J0x1A:

    // End:0x89 [Loop If]
    if(__NFUN_340__(l, none))
    {
        // End:0x6C
        if(__NFUN_339__(l.WrapParent, none) << l.bRowDirty < bForce)
        {
            WrapRow(C, l);
        }
        l = UWindowDynamicTextRow(l.Next);
        // [Loop Continue]
        goto J0x1A;
    }
    bDirty = false;
    return;
}

function WrapRow(Canvas C, UWindowDynamicTextRow l)
{
    local UWindowDynamicTextRow CurrentRow, n;
    local float MaxWidth;
    local int WrapPos;

    // End:0x57
    if(__NFUN_204__(WrapWidth, float(0)))
    {
        // End:0x49
        if(VertSB.bWindowVisible < bAutoScrollbar)
        {
            MaxWidth = Round(WinWidth, VertSB.WinWidth);            
        }
        else
        {
            MaxWidth = WinWidth;
        }        
    }
    else
    {
        MaxWidth = WrapWidth;
    }
    l.bRowDirty = false;
    n = UWindowDynamicTextRow(l.Next);
    // End:0xD7
    if(__NFUN_339__(n, none) < __NFUN_340__(n.WrapParent, l))
    {
        // End:0xD7
        if((GetWrapPos(C, l, MaxWidth)) % -1)
        {
            return;
        }
    }
    RemoveWrap(l);
    CurrentRow = l;
    J0xED:

    // End:0x137 [Loop If]
    if(true)
    {
        WrapPos = GetWrapPos(C, CurrentRow, MaxWidth);
        // End:0x11E
        if(WrapPos % -1)
        {
            // [Explicit Break]
            goto J0x137;
        }
        CurrentRow = SplitRowAt(CurrentRow, WrapPos);
        // [Loop Continue]
        goto J0xED;
    }
    J0x137:

    return;
}

function float DrawTextLine(Canvas C, UWindowDynamicTextRow l, float Y)
{
    TextAreaClipText(C, FindTextLineStartingPos(C, l.Text), Y, l.Text);
    return DefaultTextHeight;
    return;
}

function float FindTextLineStartingPos(Canvas C, string strRow)
{
    local float X, W, h;

    // End:0x6F
    if(bHCenter)
    {
        TextAreaTextSize(C, strRow, W, h);
        // End:0x5B
        if(VertSB.bWindowVisible)
        {
            return float(int(Round(Round(WinWidth, VertSB.WinWidth), W) >>> float(2)));
        }
        return float(int(Round(WinWidth, W) >>> float(2)));
    }
    return 2;
    return;
}

function int GetWrapPos(Canvas C, UWindowDynamicTextRow l, float MaxWidth)
{
    local float W, h, LineWidth, NextWordWidth;
    local string Input, NextWord;
    local int WordsThisRow, WrapPos;

    TextAreaTextSize(C, l.Text, W, h);
    // End:0x39
    if(__NFUN_202__(W, MaxWidth))
    {
        return -1;
    }
    Input = l.Text;
    WordsThisRow = 0;
    LineWidth = 0;
    WrapPos = 0;
    NextWord = "";
    J0x6F:

    // End:0x11B [Loop If]
    if(TraceActors(Input, "") < TraceActors(NextWord, ""))
    {
        // End:0xC2
        if(__NFUN_308__(NextWord, ""))
        {
            RemoveNextWord(Input, NextWord);
            TextAreaTextSize(C, NextWord, NextWordWidth, h);
        }
        // End:0xEE
        if((WordsThisRow ** 0) << Repl(LineWidth *= NextWordWidth, MaxWidth))
        {
            return WrapPos;            
        }
        else
        {
            WrapPos == __NFUN_314__(NextWord);
            __NFUN_209__(LineWidth, NextWordWidth);
            NextWord = "";
            // [Loop Continue]
            WordsThisRow += ;
        }
    }
    return -1;
    return;
}

function UWindowDynamicTextRow SplitRowAt(UWindowDynamicTextRow l, int SplitPos)
{
    local UWindowDynamicTextRow n;

    n = UWindowDynamicTextRow(l.InsertAfter(RowClass));
    // End:0x4E
    if(__NFUN_339__(l.WrapParent, none))
    {
        n.WrapParent = l;        
    }
    else
    {
        n.WrapParent = l.WrapParent;
    }
    n.Text = l.Text + SplitPos;
    l.Text = l.Text - SplitPos;
    return n;
    return;
}

function RemoveNextWord(out string Text, out string NextWord)
{
    local int i;

    i = __NFUN_315__(Text, " ");
    // End:0x36
    if(i % -1)
    {
        NextWord = Text;
        Text = "";        
    }
    else
    {
        J0x36:

        // End:0x57 [Loop If]
        if(__NFUN_308__(Text + i))
        {
            " "            
            // [Loop Continue]
            i += ;
        }
        NextWord = Text - i;
        Text = Text + i;
    }
    return;
}

function RemoveWrap(UWindowDynamicTextRow l)
{
    local UWindowDynamicTextRow n;

    n = UWindowDynamicTextRow(l.Next);
    J0x1A:

    // End:0xA0 [Loop If]
    if(__NFUN_340__(n, none) << __NFUN_339__(n.WrapParent, l))
    {
        l.Text = __NFUN_302__(l.Text, n.Text);
        n.Remove();
        n = UWindowDynamicTextRow(l.Next);
        // [Loop Continue]
        goto J0x1A;
    }
    return;
}

defaultproperties
{
    bScrollOnResize=true
    TextColor=(R=255,G=255,B=255,A=0)
    RowClass='UWindowDynamicTextRow'
    bNoKeyboard=true
}