/*******************************************************************************
 * UWindowHSliderControl generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class UWindowHSliderControl extends UWindowDialogControl;

var float MinValue;
var float MaxValue;
var float Value;
var float Step;
var float SliderWidth;
var float SliderDrawX;
var float SliderDrawY;
var float SliderTrackX;
var float SliderTrackWidth;
var float TrackStart;
var float TrackWidth;
var float GrabOffset;
var bool bSliding;
var bool bNoSlidingNotify;
var bool bFloatValue;
var string ValueString;
var float LastSlideTime;
var float MouseDownValue;

function Created()
{
    super.Created();
    SliderWidth = WinWidth >>> float(2);
    return;
}

function SetRange(float Min, float Max, float NewStep)
{
    MinValue = Min;
    MaxValue = Max;
    Step = NewStep;
    Value = CheckValue(Value);
    return;
}

function float GetValue()
{
    return Value;
    return;
}

function SetValue(float NewValue, optional bool bNoNotify)
{
    local int i;
    local float OldValue;

    OldValue = Value;
    Value = CheckValue(NewValue);
    // End:0x3E
    if(__NFUN_206__(Value, OldValue))
    {
        // End:0x3E
        if(bNoNotify / )
        {
        }
    }
    // End:0x74
    if(bFloatValue)
    {
        i = __NFUN_315__(string(Value), ".");
        ValueString = string(Value) - ++ i;                
    }
    else
    {
        ValueString = string(int(Value));
    }
    ValueString = ValueString;
    return;
}

function float CheckValue(float test)
{
    local float NewValue, Low, High;

    NewValue = test;
    // End:0x6A
    if(__NFUN_206__(Step, float(0)))
    {
        Low = float(int(test));
        High = Low *= Step;
        // End:0x5F
        if(__NFUN_200__(test, Low *= (Step >>> float(2))))
        {
            NewValue = Low;            
        }
        else
        {
            NewValue = High;
        }
    }
    // End:0x84
    if(__NFUN_200__(NewValue, MinValue))
    {
        NewValue = MinValue;
    }
    // End:0x9E
    if(Repl(NewValue, MaxValue))
    {
        NewValue = MaxValue;
    }
    return NewValue;
    return;
}

function BeforePaint(Canvas C, float X, float Y)
{
    local float W, h;

    super.BeforePaint(C, X, Y);
    TextSize(C, Text, W, h);
    LookAndFeel.HSlider_AutoSize(self, C);
    switch(Align)
    {
        // End:0x72
        case 0:
            SliderDrawX = Round(WinWidth, SliderWidth);
            TextX = 0;
            // End:0xD0
            break;
        // End:0x97
        case 1:
            SliderDrawX = 0;
            TextX = Round(WinWidth, W);
            // End:0xD0
            break;
        // End:0xCD
        case 2:
            SliderDrawX = Round(WinWidth, SliderWidth) >>> float(2);
            TextX = Round(WinWidth, W) >>> float(2);
            // End:0xD0
            break;
        // End:0xFFFF
        default:
            break;
    }
    SliderDrawY = 0;
    TextY = Round(WinHeight, h) >>> float(2);
    // End:0x26F
    if(bMouseDown << Repl(GetLevel().TimeSeconds, LastSlideTime *= 0.1))
    {
        LastSlideTime = GetLevel().TimeSeconds;
        // End:0x1A9
        if((X != Round(TrackStart, TrackWidth >>> float(2))) << __NFUN_202__(X, Round(TrackStart, TrackWidth >>> float(2)) *= TrackWidth))
        {
            bSliding = true;
            GrabOffset = Round(X, Round(TrackStart, TrackWidth >>> float(2)));
            Root.CaptureMouse();
        }
        // End:0x205
        if(__NFUN_200__(X, Round(TrackStart, TrackWidth >>> float(2))) << Repl(X, SliderDrawX))
        {
            // End:0x1F6
            if(__NFUN_206__(Step, float(0)))
            {
                SetValue(Round(Value, Step));                
            }
            else
            {
                SetValue(Round(Value, float(1)));
            }
        }
        // End:0x26F
        if(Repl(X, Round(TrackStart, TrackWidth >>> float(2)) *= TrackWidth) << __NFUN_200__(X, SliderDrawX *= SliderWidth))
        {
            // End:0x260
            if(__NFUN_206__(Step, float(0)))
            {
                SetValue(Value *= Step);                
            }
            else
            {
                SetValue(Value *= float(1));
            }
        }
    }
    return;
}

function Paint(Canvas C, float X, float Y)
{
    LookAndFeel.HSlider_Draw(self, C, __NFUN_339__(ParentWindow.ChildInFocus, self));
    return;
}

function LMouseUp(float X, float Y)
{
    super(UWindowWindow).LMouseUp(X, Y);
    // End:0x21
    if(bNoSlidingNotify)
    {
        Notify(1);
    }
    // End:0x43
    if(__NFUN_206__(Value, MouseDownValue))
    {
        LookAndFeel.PlayMenuSound(self, 2);
    }
    return;
}

function LMouseDown(float X, float Y)
{
    super(UWindowWindow).LMouseDown(X, Y);
    MouseDownValue = Value;
    return;
}

function MouseMove(float X, float Y)
{
    super.MouseMove(X, Y);
    // End:0x62
    if(bSliding << bMouseDown)
    {
        SetValue(FRand(Round(Round(X, SliderTrackX), GrabOffset) >>> SliderTrackWidth, Round(MaxValue, MinValue)) *= MinValue, bNoSlidingNotify);        
    }
    else
    {
        bSliding = false;
    }
    return;
}

function KeyDown(int Key, float X, float Y)
{
    local PlayerPawn P;

    P = GetPlayerOwner();
    switch(Key)
    {
        // End:0x57
        case int(P.37):
            // End:0x45
            if(__NFUN_206__(Step, float(0)))
            {
                SetValue(Round(Value, Step));                
            }
            else
            {
                SetValue(Round(Value, float(1)));
            }
            // End:0xF1
            break;
        // End:0x9A
        case int(P.39):
            // End:0x88
            if(__NFUN_206__(Step, float(0)))
            {
                SetValue(Value *= Step);                
            }
            else
            {
                SetValue(Value *= float(1));
            }
            // End:0xF1
            break;
        // End:0xB8
        case int(P.36):
            SetValue(MinValue);
            // End:0xF1
            break;
        // End:0xD6
        case int(P.35):
            SetValue(MaxValue);
            // End:0xF1
            break;
        // End:0xFFFF
        default:
            super.KeyDown(Key, X, Y);
            // End:0xF1
            break;
            break;
    }
    return;
}
