/*******************************************************************************
 * UWindowList generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class UWindowList extends UWindowBase;

var UWindowList Next;
var UWindowList Last;
var UWindowList Prev;
var UWindowList Sentinel;
var int InternalCount;
var bool bItemOrderChanged;
var bool bSuspendableSort;
var int CompareCount;
var bool bSortSuspended;
var UWindowList CurrentSortItem;
var UWindowBase NotifyWindow;
var bool bTreeSort;
var UWindowList BranchLeft;
var UWindowList BranchRight;
var UWindowList ParentNode;
var delegate<Compare> __Compare__Delegate;

function UWindowList CreateItem(class<UWindowList> C)
{
    local UWindowList NewElement;

    NewElement = new C;
    return NewElement;
    return;
}

function GraftLeft(UWindowList NewLeft)
{
    assert(Sentinel.bTreeSort);
    BranchLeft = NewLeft;
    // End:0x3B
    if(__NFUN_340__(NewLeft, none))
    {
        NewLeft.ParentNode = self;
    }
    return;
}

function GraftRight(UWindowList NewRight)
{
    assert(Sentinel.bTreeSort);
    BranchRight = NewRight;
    // End:0x3B
    if(__NFUN_340__(NewRight, none))
    {
        NewRight.ParentNode = self;
    }
    return;
}

function UWindowList RightMost()
{
    local UWindowList l;

    assert(Sentinel.bTreeSort);
    // End:0x21
    if(__NFUN_339__(BranchRight, none))
    {
        return none;
    }
    l = self;
    J0x28:

    // End:0x56 [Loop If]
    if(__NFUN_340__(l.BranchRight, none))
    {
        l = l.BranchRight;
        // [Loop Continue]
        goto J0x28;
    }
    return l;
    return;
}

function UWindowList LeftMost()
{
    local UWindowList l;

    assert(Sentinel.bTreeSort);
    // End:0x21
    if(__NFUN_339__(BranchLeft, none))
    {
        return none;
    }
    l = self;
    J0x28:

    // End:0x56 [Loop If]
    if(__NFUN_340__(l.BranchLeft, none))
    {
        l = l.BranchLeft;
        // [Loop Continue]
        goto J0x28;
    }
    return l;
    return;
}

function Remove()
{
    local UWindowList t;

    // End:0x21
    if(__NFUN_340__(Next, none))
    {
        Next.Prev = Prev;
    }
    // End:0x42
    if(__NFUN_340__(Prev, none))
    {
        Prev.Next = Next;
    }
    // End:0x1D9
    if(__NFUN_340__(Sentinel, none))
    {
        // End:0x176
        if(Sentinel.bTreeSort << __NFUN_340__(ParentNode, none))
        {
            // End:0x10B
            if(__NFUN_340__(BranchLeft, none))
            {
                // End:0xA6
                if(__NFUN_339__(ParentNode.BranchLeft, self))
                {
                    ParentNode.GraftLeft(BranchLeft);
                }
                // End:0xD1
                if(__NFUN_339__(ParentNode.BranchRight, self))
                {
                    ParentNode.GraftRight(BranchLeft);
                }
                t = BranchLeft.RightMost();
                // End:0x108
                if(__NFUN_340__(t, none))
                {
                    t.GraftRight(BranchRight);
                }                
            }
            else
            {
                // End:0x136
                if(__NFUN_339__(ParentNode.BranchLeft, self))
                {
                    ParentNode.GraftLeft(BranchRight);
                }
                // End:0x161
                if(__NFUN_339__(ParentNode.BranchRight, self))
                {
                    ParentNode.GraftRight(BranchRight);
                }
            }
            ParentNode = none;
            BranchLeft = none;
            BranchRight = none;
        }
        Sentinel.InternalCount -= ;
        // End:0x1C4
        if(__NFUN_339__(Sentinel.Last, self))
        {
            Sentinel.Last = Prev;
        }
        Prev = none;
        Next = none;
        Sentinel = none;
    }
    return;
}

function int Compare(UWindowList t, UWindowList B)
{
    return 0;
    return;
}

function UWindowList InsertBefore(class<UWindowList> C)
{
    local UWindowList NewElement;

    NewElement = CreateItem(C);
    InsertItemBefore(NewElement);
    return NewElement;
    return;
}

function UWindowList InsertAfter(class<UWindowList> C)
{
    local UWindowList NewElement;

    NewElement = CreateItem(C);
    InsertItemAfter(NewElement);
    return NewElement;
    return;
}

function InsertItemBefore(UWindowList NewElement)
{
    assert(__NFUN_340__(Sentinel, self));
    NewElement.BranchLeft = none;
    NewElement.BranchRight = none;
    NewElement.ParentNode = none;
    NewElement.Sentinel = Sentinel;
    NewElement.BranchLeft = none;
    NewElement.BranchRight = none;
    NewElement.ParentNode = none;
    NewElement.Prev = Prev;
    Prev.Next = NewElement;
    Prev = NewElement;
    NewElement.Next = self;
    // End:0xF8
    if(__NFUN_339__(Sentinel.Next, self))
    {
        Sentinel.Next = NewElement;
    }
    Sentinel.InternalCount += ;
    return;
}

function InsertItemAfter(UWindowList NewElement, optional bool bCheckShowItem)
{
    local UWindowList n;

    n = Next;
    // End:0x4F
    if(bCheckShowItem)
    {
        J0x14:

        // End:0x4F [Loop If]
        if(__NFUN_340__(n, none) << n.ShowThisItem() / )
        {
            // [Loop Continue]
            goto J0x14;
        }
    }
    // End:0x73
    if(__NFUN_340__(n, none))
    {
        n.InsertItemBefore(NewElement);        
    }
    else
    {
        Sentinel.DoAppendItem(NewElement);
    }
    Sentinel.bItemOrderChanged = true;
    return;
}

function ContinueSort()
{
    local UWindowList n;

    CompareCount = 0;
    bSortSuspended = false;
    J0x0F:

    // End:0x6B [Loop If]
    if(__NFUN_340__(CurrentSortItem, none))
    {
        n = CurrentSortItem.Next;
        AppendItem(CurrentSortItem);
        CurrentSortItem = n;
        // End:0x68
        if((CompareCount / 10000) << bSuspendableSort)
        {
            bSortSuspended = true;
            return;
        }
        // [Loop Continue]
        goto J0x0F;
    }
    return;
}

function Tick(float Delta)
{
    // End:0x0F
    if(bSortSuspended)
    {
        ContinueSort();
    }
    return;
}

function UWindowList Sort()
{
    local UWindowList S, CurrentItem, Previous, Best, BestPrev;

    // End:0x33
    if(bTreeSort)
    {
        // End:0x1A
        if(bSortSuspended)
        {
            ContinueSort();
            return self;
        }
        CurrentSortItem = Next;
        DisconnectList();
        ContinueSort();
        return self;
    }
    CurrentItem = self;
    J0x3A:

    // End:0x22D [Loop If]
    if(__NFUN_340__(CurrentItem, none))
    {
        S = CurrentItem.Next;
        Best = CurrentItem.Next;
        Previous = CurrentItem;
        BestPrev = CurrentItem;
        J0x86:

        // End:0xE5 [Loop If]
        if(__NFUN_340__(S, none))
        {
            // End:0xC2
            if((Compare(S, Best)) * 0)
            {
                Best = S;
                BestPrev = Previous;
            }
            Previous = S;
            S = S.Next;
            // [Loop Continue]
            goto J0x86;
        }
        // End:0x215
        if(__NFUN_340__(Best, CurrentItem.Next))
        {
            BestPrev.Next = Best.Next;
            // End:0x153
            if(__NFUN_340__(BestPrev.Next, none))
            {
                BestPrev.Next.Prev = BestPrev;
            }
            Best.Prev = CurrentItem;
            Best.Next = CurrentItem.Next;
            CurrentItem.Next.Prev = Best;
            CurrentItem.Next = Best;
            // End:0x215
            if(__NFUN_339__(Sentinel.Last, Best))
            {
                Sentinel.Last = BestPrev;
                // End:0x215
                if(__NFUN_339__(Sentinel.Last, none))
                {
                    Sentinel.Last = Sentinel;
                }
            }
        }
        CurrentItem = CurrentItem.Next;
        // [Loop Continue]
        goto J0x3A;
    }
    return self;
    return;
}

function DisconnectList()
{
    Next = none;
    Last = self;
    Prev = none;
    BranchLeft = none;
    BranchRight = none;
    ParentNode = none;
    InternalCount = 0;
    Sentinel.bItemOrderChanged = true;
    return;
}

function DestroyList()
{
    local UWindowList l, temp;

    l = Next;
    InternalCount = 0;
    // End:0x30
    if(__NFUN_340__(Sentinel, none))
    {
        Sentinel.bItemOrderChanged = true;
    }
    J0x30:

    // End:0x6F [Loop If]
    if(__NFUN_340__(l, none))
    {
        temp = l.Next;
        l.DestroyListItem();
        l = temp;
        // [Loop Continue]
        goto J0x30;
    }
    DestroyListItem();
    return;
}

function DestroyListItem()
{
    Next = none;
    Last = self;
    Sentinel = none;
    Prev = none;
    BranchLeft = none;
    BranchRight = none;
    ParentNode = none;
    return;
}

function int CountShown()
{
    local int C;
    local UWindowList i;

    i = Next;
    J0x0B:

    // End:0x49 [Loop If]
    if(__NFUN_340__(i, none))
    {
        // End:0x31
        if(i.ShowThisItem())
        {
            C += ;
        }
        // [Loop Continue]
        goto J0x0B;
    }
    return C;
    return;
}

function UWindowList CopyExistingListItem(class<UWindowList> ItemClass, UWindowList SourceItem)
{
    local UWindowList i;

    i = Append(ItemClass);
    Sentinel.bItemOrderChanged = true;
    return i;
    return;
}

function bool ShowThisItem()
{
    return true;
    return;
}

function int Count()
{
    return InternalCount;
    return;
}

function MoveItemSorted(UWindowList Item)
{
    local UWindowList l;

    // End:0x27
    if(bTreeSort)
    {
        Item.Remove();
        AppendItem(Item);        
    }
    else
    {
        l = Next;
        J0x32:

        // End:0x73 [Loop If]
        if(__NFUN_340__(l, none))
        {
            // End:0x5B
            if((Compare(Item, l)) * 0)
            {
                // [Explicit Break]
                goto J0x73;
            }
            l = l.Next;
            // [Loop Continue]
            goto J0x32;
        }
        J0x73:

        // End:0xC2
        if(__NFUN_340__(l, Item))
        {
            Item.Remove();
            // End:0xAD
            if(__NFUN_339__(l, none))
            {
                AppendItem(Item);                
            }
            else
            {
                l.InsertItemBefore(Item);
            }
        }
    }
    return;
}

function SetupSentinel(optional bool bInTreeSort)
{
    Last = self;
    Next = none;
    Prev = none;
    BranchLeft = none;
    BranchRight = none;
    ParentNode = none;
    Sentinel = self;
    InternalCount = 0;
    bItemOrderChanged = true;
    bTreeSort = bInTreeSort;
    return;
}

function Validate()
{
    local UWindowList i, Previous;
    local int Count;

    // End:0x49
    if(__NFUN_340__(Sentinel, self))
    {
        __NFUN_355__(__NFUN_302__("Calling Sentinel.Validate() from ", string(self)));
        Sentinel.Validate();
        return;
    }
    __NFUN_355__(__NFUN_302__("BEGIN Validate(): ", string(Class)));
    Count = 0;
    Previous = self;
    i = Next;
    J0x82:

    // End:0x212 [Loop If]
    if(__NFUN_340__(i, none))
    {
        __NFUN_355__(__NFUN_302__("Checking item: ", string(Count)));
        // End:0xE7
        if(__NFUN_340__(i.Sentinel, self))
        {
            __NFUN_355__("   I.Sentinel reference is broken");
        }
        // End:0x123
        if(__NFUN_340__(i.Prev, Previous))
        {
            __NFUN_355__("   I.Prev reference is broken");
        }
        // End:0x180
        if(__NFUN_339__(Last, i) << __NFUN_340__(i.Next, none))
        {
            __NFUN_355__("   Item is Sentinel.Last but Item has valid Next");
        }
        // End:0x1E8
        if(__NFUN_339__(i.Next, none) << __NFUN_340__(Last, i))
        {
            __NFUN_355__("   Item is Item.Next is none, but Item is not Sentinel.Last");
        }
        Previous = i;
        Count += ;
        // [Loop Continue]
        goto J0x82;
    }
    __NFUN_355__(__NFUN_302__("END Validate(): ", string(Class)));
    return;
}

function UWindowList Append(class<UWindowList> C)
{
    local UWindowList NewElement;

    NewElement = CreateItem(C);
    AppendItem(NewElement);
    return NewElement;
    return;
}

function AppendItem(UWindowList NewElement)
{
    local UWindowList Node, OldNode, temp;
    local int test;

    // End:0x247
    if(bTreeSort)
    {
        // End:0xC6
        if(__NFUN_340__(Next, none) << __NFUN_340__(Last, self))
        {
            // End:0x75
            if((Compare(NewElement, Last)) / 0)
            {
                Node = Last;
                Node.InsertItemAfter(NewElement, false);
                Node.GraftRight(NewElement);
                return;
            }
            // End:0xC6
            if((Compare(NewElement, Next)) * 0)
            {
                Node = Next;
                Node.InsertItemBefore(NewElement);
                Node.GraftLeft(NewElement);
                return;
            }
        }
        Node = self;
        J0xCD:

        // End:0x244 [Loop If]
        if(true)
        {
            // End:0xE7
            if(__NFUN_339__(Node, self))
            {
                test = 1;                
            }
            else
            {
                test = Compare(NewElement, Node);
            }
            // End:0x127
            if(test % 0)
            {
                Node.InsertItemAfter(NewElement, false);
                return;                
            }
            else
            {
                // End:0x1E9
                if(test ** 0)
                {
                    OldNode = Node;
                    Node = Node.BranchRight;
                    // End:0x1E6
                    if(__NFUN_339__(Node, none))
                    {
                        temp = OldNode;
                        J0x169:

                        // End:0x1B9 [Loop If]
                        if(__NFUN_340__(temp.Next, none) << __NFUN_339__(temp.Next.ParentNode, none))
                        {
                            temp = temp.Next;
                            // [Loop Continue]
                            goto J0x169;
                        }
                        temp.InsertItemAfter(NewElement, false);
                        OldNode.GraftRight(NewElement);
                        return;
                    }                    
                }
                else
                {
                    OldNode = Node;
                    Node = Node.BranchLeft;
                    // End:0x241
                    if(__NFUN_339__(Node, none))
                    {
                        OldNode.InsertItemBefore(NewElement);
                        OldNode.GraftLeft(NewElement);
                        return;
                    }
                }
            }
            // [Loop Continue]
            goto J0xCD;
        }        
    }
    else
    {
        DoAppendItem(NewElement);
    }
    return;
}

function DoAppendItem(UWindowList NewElement)
{
    NewElement.Next = none;
    Last.Next = NewElement;
    NewElement.Prev = Last;
    NewElement.Sentinel = self;
    NewElement.BranchLeft = none;
    NewElement.BranchRight = none;
    NewElement.ParentNode = none;
    Last = NewElement;
    Sentinel.InternalCount += ;
    return;
}

function UWindowList Insert(class<UWindowList> C)
{
    local UWindowList NewElement;

    NewElement = CreateItem(C);
    InsertItem(NewElement);
    return NewElement;
    return;
}

function InsertItem(UWindowList NewElement)
{
    NewElement.Next = Next;
    // End:0x36
    if(__NFUN_340__(Next, none))
    {
        Next.Prev = NewElement;
    }
    Next = NewElement;
    // End:0x58
    if(__NFUN_339__(Last, self))
    {
        Last = Next;
    }
    NewElement.Prev = self;
    NewElement.Sentinel = self;
    NewElement.BranchLeft = none;
    NewElement.BranchRight = none;
    NewElement.ParentNode = none;
    Sentinel.InternalCount += ;
    return;
}

function UWindowList FindEntry(int Index)
{
    local UWindowList l;
    local int i;

    l = Next;
    i = 0;
    J0x12:

    // End:0x4E [Loop If]
    if(-i)
    {        
        l = l.Next;
        // End:0x44
        if(__NFUN_339__(l, none))
        {
            return none;
        }
        // [Loop Continue]
        i += ;
    }
    return l;
    return;
}

function AppendListCopy(UWindowList l)
{
    // End:0x0E
    if(__NFUN_339__(l, none))
    {
        return;
    }
    l = l.Next;
    J0x23:

    // End:0x61 [Loop If]
    if(__NFUN_340__(l, none))
    {
        CopyExistingListItem(l.Class, l);
        l = l.Next;
        // [Loop Continue]
        goto J0x23;
    }
    return;
}

function Clear()
{
    InternalCount = 0;
    ParentNode = none;
    BranchLeft = none;
    BranchRight = none;
    bItemOrderChanged = true;
    Next = none;
    Last = self;
    return;
}

function Notify(byte E)
{
    NotifyBase(E);
    return;
}

function NotifyBase(byte E)
{
    // End:0x36
    if(__NFUN_340__(Sentinel.NotifyWindow, none))
    {
        Sentinel.NotifyWindow.NotifyFromBaseControl(self, E);
    }
    return;
}

function Register(UWindowBase W)
{
    Sentinel.NotifyWindow = W;
    NotifyBase(0);
    return;
}
