/*******************************************************************************
 * UWindowScrollingDialogClient generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class UWindowScrollingDialogClient extends UWindowPageWindow;

var bool bShowHorizSB;
var bool bShowVertSB;
var UWindowDialogClientWindow ClientArea;
var UWindowDialogClientWindow FixedArea;
var class<UWindowDialogClientWindow> ClientClass;
var class<UWindowDialogClientWindow> FixedAreaClass;
var UWindowVScrollbar VertSB;
var UWindowHScrollbar HorizSB;
var UWindowBitmap BRBitmap;

function Created()
{
    super(UWindowWindow).Created();
    // End:0x56
    if(__NFUN_340__(FixedAreaClass, none))
    {
        FixedArea = UWindowDialogClientWindow(CreateWindow(FixedAreaClass, 0, 0, 100, 100, OwnerWindow));
        FixedArea.bAlwaysOnTop = true;        
    }
    else
    {
        FixedArea = none;
    }
    ClientArea = UWindowDialogClientWindow(CreateWindow(ClientClass, 0, 0, WinWidth, WinHeight, OwnerWindow));
    ClientArea.ScrollParent = self;
    VertSB = UWindowVScrollbar(CreateWindow(class'UWindowVScrollbar', Round(WinWidth, float(12)), 0, 12, WinHeight));
    VertSB.bAlwaysOnTop = true;
    VertSB.HideWindow();
    HorizSB = UWindowHScrollbar(CreateWindow(class'UWindowHScrollbar', 0, Round(WinHeight, float(12)), WinWidth, 12));
    HorizSB.bAlwaysOnTop = true;
    HorizSB.HideWindow();
    BRBitmap = UWindowBitmap(CreateWindow(class'UWindowBitmap', Round(WinWidth, float(12)), Round(WinHeight, float(12)), 12, 12));
    BRBitmap.bAlwaysOnTop = true;
    BRBitmap.HideWindow();
    BRBitmap.bStretch = true;
    return;
}

function BeforePaint(Canvas C, float X, float Y)
{
    local float ClientWidth, ClientHeight, FixedHeight;

    // End:0x24
    if(__NFUN_340__(FixedArea, none))
    {
        FixedHeight = FixedArea.WinHeight;        
    }
    else
    {
        FixedHeight = 0;
    }
    ClientWidth = ClientArea.DesiredWidth;
    ClientHeight = ClientArea.DesiredHeight;
    // End:0x73
    if(__NFUN_202__(ClientWidth, WinWidth))
    {
        ClientWidth = WinWidth;
    }
    // End:0x9B
    if(__NFUN_202__(ClientHeight, Round(WinHeight, FixedHeight)))
    {
        ClientHeight = Round(WinHeight, FixedHeight);
    }
    ClientArea.SetSize(ClientWidth, ClientHeight);
    bShowVertSB = Repl(ClientHeight, Round(WinHeight, FixedHeight));
    bShowHorizSB = Repl(ClientWidth, WinWidth);
    // End:0x187
    if(bShowHorizSB)
    {
        ClientHeight = ClientArea.DesiredHeight;
        // End:0x156
        if(__NFUN_202__(ClientHeight, Round(Round(WinHeight, float(LookAndFeel.SBPosIndicator.h)), FixedHeight)))
        {
            ClientHeight = Round(Round(WinHeight, float(LookAndFeel.SBPosIndicator.h)), FixedHeight);
        }
        bShowVertSB = Repl(ClientHeight, Round(Round(WinHeight, float(LookAndFeel.SBPosIndicator.h)), FixedHeight));
    }
    // End:0x371
    if(bShowVertSB)
    {
        VertSB.ShowWindow();
        VertSB.WinTop = 0;
        VertSB.WinLeft = Round(WinWidth, float(LookAndFeel.SBPosIndicator.W));
        VertSB.WinWidth = float(LookAndFeel.SBPosIndicator.W);
        // End:0x314
        if(bShowHorizSB)
        {
            BRBitmap.ShowWindow();
            BRBitmap.WinWidth = float(LookAndFeel.SBPosIndicator.W);
            BRBitmap.WinHeight = float(LookAndFeel.SBPosIndicator.h);
            BRBitmap.WinTop = Round(Round(WinHeight, float(LookAndFeel.SBPosIndicator.h)), FixedHeight);
            BRBitmap.WinLeft = Round(WinWidth, float(LookAndFeel.SBPosIndicator.W));
            BRBitmap.t = GetLookAndFeelTexture();
            VertSB.WinHeight = Round(Round(WinHeight, float(LookAndFeel.SBPosIndicator.h)), FixedHeight);            
        }
        else
        {
            BRBitmap.HideWindow();
            VertSB.WinHeight = Round(WinHeight, FixedHeight);
        }
        VertSB.SetRange(0, ClientHeight, VertSB.WinHeight, 10);        
    }
    else
    {
        BRBitmap.HideWindow();
        VertSB.HideWindow();
        VertSB.pos = 0;
    }
    // End:0x4AA
    if(bShowHorizSB)
    {
        HorizSB.ShowWindow();
        HorizSB.WinLeft = 0;
        HorizSB.WinTop = Round(Round(WinHeight, float(LookAndFeel.SBPosIndicator.h)), FixedHeight);
        HorizSB.WinHeight = float(LookAndFeel.SBPosIndicator.h);
        // End:0x464
        if(bShowVertSB)
        {
            HorizSB.WinWidth = Round(WinWidth, float(LookAndFeel.SBPosIndicator.W));            
        }
        else
        {
            HorizSB.WinWidth = WinWidth;
        }
        HorizSB.SetRange(0, ClientWidth, HorizSB.WinWidth, 10);        
    }
    else
    {
        HorizSB.HideWindow();
        HorizSB.pos = 0;
    }
    ClientArea.WinLeft = Square(HorizSB.pos);
    ClientArea.WinTop = Square(VertSB.pos);
    // End:0x58B
    if(__NFUN_340__(FixedArea, none))
    {
        FixedArea.WinLeft = 0;
        FixedArea.WinTop = Round(WinHeight, FixedHeight);
        // End:0x58B
        if(__NFUN_206__(FixedArea.WinWidth, WinWidth))
        {
            FixedArea.SetSize(WinWidth, FixedArea.WinHeight);
        }
    }
    super(UWindowWindow).BeforePaint(C, X, Y);
    return;
}

function GetDesiredDimensions(out float W, out float h)
{
    super(UWindowWindow).GetDesiredDimensions(W, h);
    return;
}

function Paint(Canvas C, float X, float Y)
{
    return;
}

function ScrollUp()
{
    // End:0x30
    if(__NFUN_340__(VertSB, none))
    {
        VertSB.Scroll(FRand(VertSB.ScrollAmount, float(6)));
    }
    return;
}

function ScrollDown()
{
    // End:0x32
    if(__NFUN_340__(VertSB, none))
    {
        VertSB.Scroll(FRand(Square(VertSB.ScrollAmount), float(6)));
    }
    return;
}

defaultproperties
{
    ClientClass='UWindowDialogClientWindow'
}