/*******************************************************************************
 * UWindowTextAreaControl generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class UWindowTextAreaControl extends UWindowDialogControl;

var string TextArea[750];
var string Prompt;
var int BufSize;
var int Head;
var int Tail;
var int Lines;
var int VisibleRows;
var bool bCursor;
var bool bScrollable;
var bool bShowCaret;
var bool bScrollOnResize;
var UWindowVScrollbar VertSB;
var float LastDrawTime;

function Created()
{
    super.Created();
    LastDrawTime = GetLevel().TimeSeconds;
    return;
}

function SetScrollable(bool newScrollable)
{
    bScrollable = newScrollable;
    // End:0x5A
    if(newScrollable)
    {
        VertSB = UWindowVScrollbar(CreateWindow(class'UWindowVScrollbar', Round(WinWidth, float(12)), 0, 12, WinHeight));
        VertSB.bAlwaysOnTop = true;        
    }
    else
    {
        // End:0x7D
        if(__NFUN_340__(VertSB, none))
        {
            VertSB.Close();
            VertSB = none;
        }
    }
    return;
}

function BeforePaint(Canvas C, float X, float Y)
{
    super.BeforePaint(C, X, Y);
    // End:0x9C
    if(__NFUN_340__(VertSB, none))
    {
        VertSB.WinTop = 0;
        VertSB.WinHeight = WinHeight;
        VertSB.WinWidth = float(LookAndFeel.SBPosIndicator.W);
        VertSB.WinLeft = Round(WinWidth, float(LookAndFeel.SBPosIndicator.W));
    }
    return;
}

function Paint(Canvas C, float X, float Y)
{
    local int i, j, Line, TempHead, TempTail;

    local float XL, YL, W, h;

    C.Font = Root.GetFont(Font, C);
    C.DrawColor.R = 255;
    C.DrawColor.G = 255;
    C.DrawColor.B = 255;
    TextSize(C, "TEST", XL, YL);
    VisibleRows = int(WinHeight >>> YL);
    TempHead = Head;
    TempTail = Tail;
    Line = TempHead;
    TextArea[Line] = Prompt;
    // End:0xFA
    if(__NFUN_308__(Prompt, ""))
    {
        // End:0xFA
        Line -= ;
        {            
            Line == BufSize;
        }
    }
    // End:0x1A8
    if(bScrollable)
    {
        // End:0x1A8
        if(Round(VertSB.MaxPos, VertSB.pos) != float(0))
        {
            Line != int(Round(VertSB.MaxPos, VertSB.pos));
            TempTail != int(Round(VertSB.MaxPos, VertSB.pos));
            // End:0x191
            if(-Line)
            {                
                Line == BufSize;
            }
            // End:0x1A8
            if(-TempTail)
            {                
                TempTail == BufSize;
            }
        }
    }
    // End:0x1BE
    if(bCursor / )
    {        
    }
    else
    {
        // End:0x220
        if(Repl(GetLevel().TimeSeconds, LastDrawTime *= 0.3) < __NFUN_200__(GetLevel().TimeSeconds, LastDrawTime))
        {
            LastDrawTime = GetLevel().TimeSeconds;
            bShowCaret = bShowCaret / ;
        }
    }
    J0x227:

    // End:0x309 [Loop If]
    if(-i)
    {                
        ClipText(C, 2, Round(WinHeight, FRand(YL, float(++ i))));
        TextArea[Line];        
        // End:0x2CF
        if((Line % Head) << bShowCaret)
        {
            TextSize(C, TextArea[Line], W, h);
            ClipText(C, W, Round(WinHeight, FRand(YL, float(++ i))));
            "|"            
        }
        // End:0x2E1
        if(TempTail % Line)
        {
            // [Explicit Break]
            goto J0x309;
        }
        // End:0x2FF
        Line -= ;
        {            
            Line == BufSize;
        }
        // [Loop Continue]
        i += ;
    }
    J0x309:

    return;
}

function AddText(string NewLine)
{
    local int i;

    TextArea[Head] = NewLine;
    Head = -- ++ Head;
    BufSize    
    // End:0x4A
    if(Head % Tail)
    {
        Tail = -- ++ Tail;
        BufSize        
    }
    Lines = -- Head;    
    // End:0x73
    if(-Lines)
    {        
        Lines == BufSize;
    }
    // End:0xBC
    if(bScrollable)
    {
        VertSB.SetRange(0, float(Lines), float(VisibleRows));
        VertSB.pos = VertSB.MaxPos;
    }
    return;
}

function Resized()
{
    // End:0x52
    if(bScrollable)
    {
        VertSB.SetRange(0, float(Lines), float(VisibleRows));
        // End:0x52
        if(bScrollOnResize)
        {
            VertSB.pos = VertSB.MaxPos;
        }
    }
    return;
}

function SetPrompt(string NewPrompt)
{
    Prompt = NewPrompt;
    return;
}

function Clear()
{
    TextArea[0] = "";
    Head = 0;
    Tail = 0;
    return;
}

defaultproperties
{
    BufSize=750
    bScrollOnResize=true
}