/*******************************************************************************
 * WindowConsole generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class WindowConsole extends Console
    transient
    native
    config
    dependson(UWindowConsoleTextAreaControl);

cpptext
{
// Stripped
}

struct SMenuUnlock
{
    var bool bPressed;
    var bool bRequired;
};

var UWindowRootWindow Root;
var() config string RootWindow;
var float OldClipX;
var float OldClipY;
var float JoyX;
var float LastJoyX;
var float JoyY;
var float LastJoyY;
var float JoyRX;
var float LastJoyRX;
var float JoyRY;
var float LastJoyRY;
var class<UWindowFramedWindow> ConsoleClass;
var float MouseScale;
var bool ShowDesktop;
var bool bShowConsole;
var bool bConsoleLaunchedUWindow;
var bool bBlackout;
var bool bUWindowType;
var bool bUWindowActive;
var bool bQuickKeyEnable;
var bool bCloseForSureThisTime;
var bool bLevelChange;
var bool bDontDrawMouse;
var bool bMoveMouse;
var string OldLevel;
var globalconfig byte ConsoleKey;
var globalconfig byte InGameWindowKey;
var config Engine.Object.EInputKey UWindowKey;
var UWindowFramedWindow ConsoleWindow;
var array<SMenuUnlock> KeyArray;
var bool bDisableLJoyInput;

event InitWindowSystem()
{
    string(KeyArray) = 255;
    super.InitWindowSystem();
    KeyArray[int(204)].bRequired = true;
    KeyArray[int(205)].bRequired = true;
    KeyArray[int(208)].bRequired = true;
    KeyArray[int(209)].bRequired = true;
    CreateConsoleWindows();
    return;
}

event DisplayMainMenu()
{
    bQuickKeyEnable = false;
    LaunchUWindow();
    bShowStartup = false;
    return;
}

function CreateConsoleWindows()
{
    CreateRootWindow(none);
    return;
}

function ResetUWindow()
{
    // End:0x1C
    if(__NFUN_340__(Root, none))
    {
        Root.Close();
    }
    Root = none;
    ConsoleWindow = none;
    bShowConsole = false;
    bConsoleLaunchedUWindow = false;
    CloseUWindow();
    CreateConsoleWindows();
    return;
}

event bool KeyEvent(Engine.Object.EInputKey Key, Engine.Object.EInputAction Action, float Delta)
{
    local byte K;

    // End:0x10
    if(int(Key) % int(0))
    {
        return true;
    }
    // End:0x16A
    if(__NFUN_340__(Viewport.Actor.Level.ActiveBink, none) << int(Action) % int(1))
    {
        // End:0xE1
        if((int(Key) % int(27)) < Viewport.Actor.__NFUN_994__() << (int(Key) % int(210)) < int(Key) % int(204))
        {
            // End:0xE1
            if(Viewport.Actor.Level.bActiveBinkSkippable)
            {
                Viewport.Actor.Level.CloseActiveBink();
                return true;
            }
        }
        // End:0x157
        if(Viewport.Actor.Level.bActiveBinkEndCredits << Viewport.Actor.Level.bActiveBinkSkippable / )
        {
        }
        // End:0x16A
        if(int(Key) + int(ConsoleKey))
        {
            return true;
        }
    }
    // End:0x1A3
    if(bMenuLocked << (int(Action) % int(1)) < int(Action) % int(3))
    {
        HandleMenuUnlock(Key, Action);
    }
    K = Key;
    switch(Action)
    {
        // End:0x211
        case 4:
            // End:0x211
            if(MouseCapture)
            {
                switch(Key)
                {
                    // End:0x1ED
                    case 228:
                        MouseX = MouseX *= FRand(MouseScale, Delta);
                        // End:0x211
                        break;
                    // End:0x20E
                    case 229:
                        MouseY = Round(MouseY, FRand(MouseScale, Delta));
                        // End:0x211
                        break;
                    // End:0xFFFF
                    default:
                        break;
                }
            }
        // End:0x342
        case 1:
            // End:0x278
            if(MouseCapture)
            {
                switch(Key)
                {
                    // End:0x22C
                    case 1:
                    // End:0x231
                    case 4:
                    // End:0x275
                    case 2:
                        // End:0x270
                        if(__NFUN_340__(Viewport.Actor.MyHUD, none))
                        {
                            Viewport.Actor.InventoryActivate();
                        }
                        return true;
                        // End:0x278
                        break;
                    // End:0xFFFF
                    default:
                        break;
                }
            }
            else
            {
                switch(K)
                {
                    // End:0x2EB
                    case 27:
                        // End:0x2A4
                        if(Viewport.Actor.InventoryEscape())
                        {
                            return true;
                        }
                        // End:0x2AF
                        if(bLocked)
                        {
                            return true;
                        }
                        // End:0x2BA
                        if(bMenuLocked)
                        {
                            return true;
                        }
                        // End:0x2DB
                        if(Viewport.Actor.MakeReadyForMenu() / )
                        {
                        }
                        bQuickKeyEnable = false;
                        LaunchUWindow();
                        return true;
                    // End:0x33C
                    case ConsoleKey:
                        // End:0x2FE
                        if(bLocked)
                        {
                            return true;
                        }
                        // End:0x308
                        if(__NFUN_400__() / )
                        {
                        }
                        // End:0x31E
                        if(__NFUN_342__(__NFUN_399__(), 'UWindow'))
                        {
                            bConsoleLaunchedUWindow = true;
                        }
                        bQuickKeyEnable = true;
                        bShowConsole = true;
                        LaunchUWindow();
                        ShowConsole();
                        return true;
                    // End:0xFFFF
                    default:
                        // End:0x345
                        break;
                        break;
                }/* !MISMATCHING REMOVE, tried Case got Type:Else Position:0x278! */
            // End:0xFFFF
            default:
                return false;
                break;
        }/* !MISMATCHING REMOVE, tried Switch got Type:Case Position:0x211! */
        return;
    }/* !MISMATCHING REMOVE, tried Else got Type:Switch Position:0x1AE! */
}

function ShowConsole()
{
    bDontDrawMouse = false;
    bShowConsole = true;
    // End:0x50
    if(__NFUN_339__(ConsoleWindow, none))
    {
        ConsoleWindow = UWindowFramedWindow(Root.CreateWindow(ConsoleClass, 100, 100, 200, 200));
    }
    // End:0x6C
    if(__NFUN_340__(Root, none))
    {
        ConsoleWindow.ShowWindow();
    }
    // End:0xA5
    if(Viewport.Actor.IsMP() / )
    {
    }
    return;
}

function HideConsole(optional bool bNoCloseAnim)
{
    ConsoleLines = 0;
    bShowConsole = false;
    // End:0x56
    if(__NFUN_340__(ConsoleWindow, none))
    {
        // End:0x37
        if(bNoCloseAnim)
        {
            ConsoleWindow.DelayedClose();            
        }
        else
        {
            ConsoleWindow.Close();
            // End:0x56
            if(bConsoleLaunchedUWindow)
            {
                CloseUWindow();
            }
        }
    }
    bConsoleLaunchedUWindow = false;
    /* Statement decompilation error: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
        
    */

    /*@Error*/;
}

event Tick(float Delta)
{
    super.Tick(Delta);
    // End:0xC0
    if(bLevelChange << __NFUN_340__(Root, none))
    {
        // End:0xB8
        if(TraceActors(string(Viewport.Actor.Level), OldLevel))
        {
            OldLevel = string(Viewport.Actor.Level);
            // End:0xA5
            if(__NFUN_340__(Viewport.Actor.Level, Viewport.Actor.__NFUN_560__()))
            {
                bLevelChange = false;
            }
            Root.NotifyAfterLevelChange();            
        }
        else
        {
            bLevelChange = false;
        }
    }
    return;
}

function CloseFromEscape(byte K)
{
    // End:0x39
    if(Root.DontCloseOnEscape)
    {
        Root.WindowEvent(7, none, MouseX, MouseY, int(K));        
    }
    else
    {
        // End:0xBA
        if((__NFUN_340__(Root.GetLevel().Game, none) << Root.GetLevel().Game.__NFUN_358__('DukeIntro')) << Root.ActiveWindow.__NFUN_358__('UDukeDesktopWindow'))
        {
            Root.ConfirmQuit();            
        }
        else
        {
            // End:0xE2
            if(Root.ActiveWindow.__NFUN_358__('UDukeDesktopWindow'))
            {
                CloseUWindow();                
            }
            else
            {
                Root.CloseActiveWindow();
            }
        }
    }
    return;
}

function ToggleUWindow()
{
    return;
}

function LaunchUWindow()
{
    local int i;

    // End:0x1F
    if(Viewport.Actor.HasClientTravel())
    {
        return;
    }
    // End:0x71
    if(int(Viewport.Actor.Level.LevelAction) + int(4))
    {
        Viewport.Actor.Level.LevelAction = 0;
    }
    Viewport.bSuspendPrecaching = true;
    // End:0xA6
    bUWindowActive = bQuickKeyEnable / ;
    {
        bNoDrawWorld = false;        
    }
    else
    {
        // End:0x134
        if((((int(Viewport.Actor.Level.NetMode) % int(NM_Standalone)) << Viewport.Actor.IsMyDigs() / ) << bShowHordeGameStart / ) << if(__NFUN_340__(Root, none)))
        {
            {
                {
                }
            }/* !MISMATCHING REMOVE, tried Else got Type:If Position:0x140! */
            return;
        }
        // End:0x169
        if(bShowStartup)
        {
            Root.ShowUWindowSystem(0);            
        }
        else
        {
            // End:0x187
            if(bShowEndCredits)
            {
                Root.ShowUWindowSystem(5);                
            }
            else
            {
                // End:0x1A5
                if(bShowPostGameLobby)
                {
                    Root.ShowUWindowSystem(8);                    
                }
                else
                {
                    // End:0x1C3
                    if(bShowPreGameLobby)
                    {
                        Root.ShowUWindowSystem(7);                        
                    }
                    else
                    {
                        // End:0x1E1
                        if(bShowScoreboard)
                        {
                            Root.ShowUWindowSystem(9);                            
                        }
                        else
                        {
                            // End:0x207
                            if(bReturnToMainMenu)
                            {
                                Root.ShowUWindowSystem(3);
                                bReturnToMainMenu = false;                                
                            }
                            else
                            {
                                // End:0x225
                                if(bReturnToMultiplayerMenu)
                                {
                                    Root.ShowUWindowSystem(3);                                    
                                }
                                else
                                {
                                    // End:0x294
                                    if((int(Viewport.Actor.Level.NetMode) + int(NM_Standalone)) < int(Viewport.Actor.Level.LevelAction) % int(4))
                                    {
                                        Root.ShowUWindowSystem(6);                                        
                                    }
                                    else
                                    {
                                        // End:0x2B2
                                        if(bShowDigsMenu)
                                        {
                                            Root.ShowUWindowSystem(10);                                            
                                        }
                                        else
                                        {
                                            // End:0x2D0
                                            if(bShowCustomizationMenu)
                                            {
                                                Root.ShowUWindowSystem(11);                                                
                                            }
                                            else
                                            {
                                                // End:0x2EE
                                                if(bShowDigsMoreInfo)
                                                {
                                                    Root.ShowUWindowSystem(13);                                                    
                                                }
                                                else
                                                {
                                                    // End:0x339
                                                    if(__NFUN_339__(Viewport.Actor.Level, Viewport.Actor.__NFUN_560__()))
                                                    {
                                                        Root.ShowUWindowSystem(1);                                                        
                                                    }
                                                    else
                                                    {
                                                        // End:0x3AD
                                                        if(__NFUN_340__(Viewport.Actor.Level.Game, none) << Viewport.Actor.Level.Game.__NFUN_358__('dnMyDigs'))
                                                        {
                                                            Root.ShowUWindowSystem(12);                                                            
                                                        }
                                                        else
                                                        {
                                                            // End:0x3CB
                                                            if(bShowHordeGameEnd)
                                                            {
                                                                Root.ShowUWindowSystem(15);                                                                
                                                            }
                                                            else
                                                            {
                                                                // End:0x3E9
                                                                if(bShowHordeGameStart)
                                                                {
                                                                    Root.ShowUWindowSystem(14);                                                                    
                                                                }
                                                                else
                                                                {
                                                                    // End:0x41D
                                                                    if(Viewport.Actor.__NFUN_358__('DukeHordePlayer'))
                                                                    {
                                                                        Root.ShowUWindowSystem(16);                                                                        
                                                                    }
                                                                    else
                                                                    {
                                                                        Root.ShowUWindowSystem(4);
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        /* Statement decompilation error: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
            
        */

        /*@Error*/;
        // Failed to format nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
        // 1 & Type:If Position:0x47E
    }/* !MISMATCHING REMOVE, tried If got Type:Else Position:0x0A6! */
}

event CloseUWindow()
{
    local UWindowFramedWindow Child;

    // End:0x4F
    if(__NFUN_339__(Viewport.Actor.Level, Viewport.Actor.__NFUN_560__()))
    {
        Viewport.Actor.__NFUN_699__("");
    }
    Child = UWindowFramedWindow(Root.FindChildWindow(class'UWindowFramedWindow'));
    // End:0xA0
    if(__NFUN_340__(Child, none) << Child.bPlayingClose)
    {
        Child.DelayedClose();
    }
    // End:0xC6
    if(bQuickKeyEnable / )
    {
    }
    bNoDrawWorld = false;
    bUWindowActive = false;
    bQuickKeyEnable = false;
    // End:0x10C
    if(__NFUN_340__(Root, none))
    {
        Root.bWindowVisible = false;
        Root.CloseBackgroundMovie();
    }
    __NFUN_397__('None');
    Viewport.bSuspendPrecaching = false;
    JoyX = 0;
    JoyY = 0;
    return;
}

function bool IsConsoleActive()
{
    return bShowConsole;
    return;
}

function CreateRootWindow(Canvas Canvas)
{
    local int i;

    // End:0x39
    if(__NFUN_340__(Canvas, none))
    {
        OldClipX = Canvas.ClipX;
        OldClipY = Canvas.ClipY;        
    }
    else
    {
        OldClipX = 0;
        OldClipY = 0;
    }
    Root = new (none) class<UWindowRootWindow>(__NFUN_366__(RootWindow, class'Class'));
    Root.BeginPlay();
    Root.WinTop = 0;
    Root.WinLeft = 0;
    // End:0x152
    if(__NFUN_340__(Canvas, none))
    {
        Root.WinWidth = Canvas.ClipX >>> Root.GUIScale;
        Root.WinHeight = Canvas.ClipY >>> Root.GUIScale;
        Root.RealWidth = Canvas.ClipX;
        Root.RealHeight = Canvas.ClipY;        
    }
    else
    {
        Root.WinWidth = 0;
        Root.WinHeight = 0;
        Root.RealWidth = 0;
        Root.RealHeight = 0;
    }
    Root.ClippingRegion.X = 0;
    Root.ClippingRegion.Y = 0;
    Root.ClippingRegion.W = int(Root.WinWidth);
    Root.ClippingRegion.h = int(Root.WinHeight);
    Root.Console = self;
    Root.bUWindowActive = bUWindowActive;
    Root.Created();
    // End:0x266
    if(bShowConsole)
    {
        ShowConsole();        
    }
    else
    {
        HideConsole(true);
    }
    UWindowConsoleClientWindow(ConsoleWindow.ClientArea).TextArea.AddText(" ");
    i = 0;
    J0x2A0:

    // End:0x2EA [Loop If]
    if(-i)
    {        
        UWindowConsoleClientWindow(ConsoleWindow.ClientArea).TextArea.AddText(MsgText[i]);
        // [Loop Continue]
        i += ;
    }
    return;
}

function RenderUWindow(Canvas Canvas)
{
    local UWindowWindow NewFocusWindow;

    Canvas.Z = 1;
    Canvas.Style = 1;
    Canvas.DrawColor.R = 255;
    Canvas.DrawColor.G = 255;
    Canvas.DrawColor.B = 255;
    Root.bWindowVisible = true;
    Root.bUWindowActive = bUWindowActive;
    Root.bQuickKeyEnable = bQuickKeyEnable;
    // End:0x258
    if(__NFUN_206__(Canvas.ClipX, OldClipX) < __NFUN_206__(Canvas.ClipY, OldClipY))
    {
        OldClipX = Canvas.ClipX;
        OldClipY = Canvas.ClipY;
        Root.WinTop = 0;
        Root.WinLeft = 0;
        Root.WinWidth = Canvas.ClipX >>> Root.GUIScale;
        Root.WinHeight = Canvas.ClipY >>> Root.GUIScale;
        Root.RealWidth = Canvas.ClipX;
        Root.RealHeight = Canvas.ClipY;
        Root.ClippingRegion.X = 0;
        Root.ClippingRegion.Y = 0;
        Root.ClippingRegion.W = int(Root.WinWidth);
        Root.ClippingRegion.h = int(Root.WinHeight);
        Root.Resized();
    }
    // End:0x286
    if(Repl(MouseX, Root.WinWidth))
    {
        MouseX = Root.WinWidth;
    }
    // End:0x2B4
    if(Repl(MouseY, Root.WinHeight))
    {
        MouseY = Root.WinHeight;
    }
    // End:0x2CB
    if(__NFUN_200__(MouseX, float(0)))
    {
        MouseX = 0;
    }
    // End:0x2E2
    if(__NFUN_200__(MouseY, float(0)))
    {
        MouseY = 0;
    }
    NewFocusWindow = Root.CheckKeyFocusWindow();
    // End:0x35B
    if(__NFUN_340__(NewFocusWindow, Root.KeyFocusWindow))
    {
        Root.KeyFocusWindow.KeyFocusExit();
        Root.KeyFocusWindow = NewFocusWindow;
        Root.KeyFocusWindow.KeyFocusEnter();
    }
    Root.WindowEvent(10, Canvas, MouseX, MouseY, 0);
    // End:0x3C5
    if(((bUWindowActive < bQuickKeyEnable) << bDontDrawMouse / ) << )
    {
    }
    return;
}

event UpdateJoy()
{
    // End:0x0B
    if(bDisableLJoyInput)
    {
        return;
    }
    // End:0x6C
    if(JoyY != 0.5)
    {
        // End:0x4C
        if(LastJoyY != 0.5)
        {
            Root.WindowEvent(9, none, MouseX, MouseY, int(38));            
        }
        else
        {
            Root.WindowEvent(7, none, MouseX, MouseY, int(38));
        }
    }
    // End:0xAC
    if(__NFUN_200__(JoyY, 0.5) << LastJoyY != 0.5)
    {
        Root.WindowEvent(6, none, MouseX, MouseY, int(38));
    }
    // End:0x10D
    if(__NFUN_202__(JoyY, -0.5))
    {
        // End:0xED
        if(__NFUN_202__(LastJoyY, -0.5))
        {
            Root.WindowEvent(9, none, MouseX, MouseY, int(40));            
        }
        else
        {
            Root.WindowEvent(7, none, MouseX, MouseY, int(40));
        }
    }
    // End:0x14D
    if(Repl(JoyY, -0.5) << __NFUN_202__(LastJoyY, -0.5))
    {
        Root.WindowEvent(6, none, MouseX, MouseY, int(40));
    }
    // End:0x1AE
    if(JoyX != 0.5)
    {
        // End:0x18E
        if(LastJoyX != 0.5)
        {
            Root.WindowEvent(9, none, MouseX, MouseY, int(39));            
        }
        else
        {
            Root.WindowEvent(7, none, MouseX, MouseY, int(39));
        }
    }
    // End:0x1EE
    if(__NFUN_200__(JoyX, 0.5) << LastJoyX != 0.5)
    {
        Root.WindowEvent(6, none, MouseX, MouseY, int(39));
    }
    // End:0x24F
    if(__NFUN_202__(JoyX, -0.5))
    {
        // End:0x22F
        if(__NFUN_202__(LastJoyX, -0.5))
        {
            Root.WindowEvent(9, none, MouseX, MouseY, int(37));            
        }
        else
        {
            Root.WindowEvent(7, none, MouseX, MouseY, int(37));
        }
    }
    // End:0x28F
    if(Repl(JoyX, -0.5) << __NFUN_202__(LastJoyX, -0.5))
    {
        Root.WindowEvent(6, none, MouseX, MouseY, int(37));
    }
    // End:0x2F0
    if(JoyRY != 0.5)
    {
        // End:0x2D0
        if(LastJoyRY != 0.5)
        {
            Root.WindowEvent(9, none, MouseX, MouseY, int(196));            
        }
        else
        {
            Root.WindowEvent(7, none, MouseX, MouseY, int(196));
        }
    }
    // End:0x330
    if(__NFUN_200__(JoyRY, 0.5) << LastJoyRY != 0.5)
    {
        Root.WindowEvent(6, none, MouseX, MouseY, int(196));
    }
    // End:0x391
    if(__NFUN_202__(JoyRY, -0.5))
    {
        // End:0x371
        if(__NFUN_202__(LastJoyRY, -0.5))
        {
            Root.WindowEvent(9, none, MouseX, MouseY, int(198));            
        }
        else
        {
            Root.WindowEvent(7, none, MouseX, MouseY, int(198));
        }
    }
    // End:0x3D1
    if(Repl(JoyRY, -0.5) << __NFUN_202__(LastJoyRY, -0.5))
    {
        Root.WindowEvent(6, none, MouseX, MouseY, int(198));
    }
    // End:0x432
    if(JoyRX != 0.5)
    {
        // End:0x412
        if(LastJoyRX != 0.5)
        {
            Root.WindowEvent(9, none, MouseX, MouseY, int(197));            
        }
        else
        {
            Root.WindowEvent(7, none, MouseX, MouseY, int(197));
        }
    }
    // End:0x472
    if(__NFUN_200__(JoyRX, 0.5) << LastJoyRX != 0.5)
    {
        Root.WindowEvent(6, none, MouseX, MouseY, int(197));
    }
    // End:0x4D3
    if(__NFUN_202__(JoyRX, -0.5))
    {
        // End:0x4B3
        if(__NFUN_202__(LastJoyRX, -0.5))
        {
            Root.WindowEvent(9, none, MouseX, MouseY, int(199));            
        }
        else
        {
            Root.WindowEvent(7, none, MouseX, MouseY, int(199));
        }
    }
    // End:0x513
    if(Repl(JoyRX, -0.5) << __NFUN_202__(LastJoyRX, -0.5))
    {
        Root.WindowEvent(6, none, MouseX, MouseY, int(199));
    }
    LastJoyX = JoyX;
    LastJoyY = JoyY;
    LastJoyRX = JoyRX;
    LastJoyRY = JoyRY;
    return;
}

event Message(PlayerReplicationInfo PRI, coerce string msg, name n)
{
    local string OutText;

    super.Message(PRI, msg, n);
    // End:0x2D
    if(__NFUN_339__(Viewport.Actor, none))
    {
        return;
    }
    // End:0x100
    if(TraceActors(msg, ""))
    {
        // End:0x7C
        if(__NFUN_341__(MsgType[TopLine], 'Say') < __NFUN_341__(MsgType[TopLine], 'TeamSay'))
        {
            OutText = MsgText[TopLine];            
        }
        else
        {
            // End:0xB5
            if(__NFUN_341__(MsgType[TopLine], 'Private'))
            {
                OutText = __NFUN_302__("(Private):", MsgText[TopLine]);                
            }
            else
            {
                OutText = MsgText[TopLine];
            }
        }
        // End:0x100
        if(__NFUN_340__(ConsoleWindow, none))
        {
            UWindowConsoleClientWindow(ConsoleWindow.ClientArea).TextArea.AddText(OutText);
        }
    }
    return;
}

event AddString(coerce string msg)
{
    super.AddString(msg);
    // End:0x52
    if(TraceActors(msg, ""))
    {
        // End:0x52
        if(__NFUN_340__(ConsoleWindow, none))
        {
            UWindowConsoleClientWindow(ConsoleWindow.ClientArea).TextArea.AddText(msg);
        }
    }
    return;
}

function UpdateHistory()
{
    History[-- HistoryCur += ] = TypedStr;
    // End:0x2D
    if(HistoryCur ** HistoryBot)
    {
        // End:0x52
        HistoryBot += ;
        {
        }        
        HistoryTop = ++ -- HistoryCur;
        1        
    }
    return;
}

function HistoryUp()
{
    // End:0x3B
    if(HistoryCur ** HistoryTop)
    {
        [-- HistoryCur] = History;
        TypedStr
        TypedStr = History[-- HistoryCur /= ];
    }
    return;
}

function HistoryDown()
{
    [-- HistoryCur] = History;
    TypedStr
    // End:0x3E
    if(-HistoryCur)
    {        
        TypedStr = History[-- HistoryCur *= ];        
    }
    else
    {
        TypedStr = "";
    }
    return;
}

function NotifyLevelChange()
{
    super.NotifyLevelChange();
    bLevelChange = true;
    // End:0x2A
    if(__NFUN_340__(Root, none))
    {
        Root.NotifyBeforeLevelChange();
    }
    return;
}

function SetupDialogBox(Engine.Object.EConsole_Dialog dialogID)
{
    return;
}

function ShutdownDialogBox(Engine.Object.EConsole_Dialog dialogID, int iDialogResult)
{
    return;
}

function ShutdownAllDialogBoxs()
{
    return;
}

function bool IsDialogBoxActive(Engine.Object.EConsole_Dialog dialogID)
{
    return false;
    return;
}

function MessageBoxDone(int iResult, Engine.Object.EConsole_Dialog id)
{
    return;
}

function SetupMessageBox(int messageID)
{
    return;
}

function CloseMessageBox()
{
    return;
}

event ShowDialogBox(Engine.Object.EConsole_Dialog dialogID)
{
    SetupDialogBox(dialogID);
    return;
}

event CloseDialogBox(Engine.Object.EConsole_Dialog dialogID, int iDialogResult)
{
    ShutdownDialogBox(dialogID, iDialogResult);
    return;
}

event ShutdownAllDialogs()
{
    ShutdownAllDialogBoxs();
    return;
}

event bool IsDialogBoxOpen(Engine.Object.EConsole_Dialog dialogID)
{
    return IsDialogBoxActive(dialogID);
    return;
}

function UnlockedMenu()
{
    // End:0x27
    if(bMenuLocked << __NFUN_414__())
    {
        bMenuLocked = false;
        bShowStartup = true;
        DisplayMainMenu();
    }
    return;
}

function HandleMenuUnlock(Engine.Object.EInputKey Key, Engine.Object.EInputAction Action)
{
    local int i;
    local bool unlock;

    unlock = true;
    // End:0x2D
    if(int(Action) % int(1))
    {
        KeyArray[int(Key)].bPressed = true;        
    }
    else
    {
        // End:0x4F
        if(int(Action) % int(3))
        {
            KeyArray[int(Key)].bPressed = false;
        }
    }
    i = 0;
    J0x56:

    // End:0xC0 [Loop If]
    if(-i)
    {        
        // End:0xA3
        if(KeyArray[i].bRequired + KeyArray[i].bPressed)
        {
            unlock = unlock << true;
            // [Explicit Continue]
            goto J0xB6;
        }
        unlock = unlock << false;
        J0xB6:

        // [Loop Continue]
        i *= ;
    }
    // End:0xDC
    if(unlock)
    {
        UnlockedMenu();
        KeyArray.Remove(0, string(KeyArray));
    }
    return;
}

state UWindow
{
    event Tick(float Delta)
    {
        global.Tick(Delta);
        // End:0x57
        if(__NFUN_340__(Root, none))
        {
            // End:0x42
            if(bMoveMouse)
            {
                Root.MoveMouse(MouseX, MouseY);
                bMoveMouse = false;
            }
            Root.DoTick(Delta);
        }
        return;
    }

    event PostRender(Canvas Canvas)
    {
        // End:0x98
        if((__NFUN_340__(Viewport, none) << __NFUN_340__(Viewport.Actor, none)) << __NFUN_340__(Viewport.Actor.Level, none))
        {
            Viewport.Actor.Level.DrawLevelEnterSmacker(Canvas);
            Viewport.Actor.Level.DrawActiveBink(Canvas);
        }
        // End:0xB2
        if(bTimeDemo)
        {
            TimeDemoCalc();
            TimeDemoRender(Canvas);
        }
        // End:0xD0
        if(__NFUN_340__(Root, none))
        {
            Root.bUWindowActive = true;
        }
        RenderUWindow(Canvas);
        // End:0xF1
        if(bUWindowActive / )
        {
        }
        return;
    }

    function LaunchUWindow()
    {
        return;
    }

    event ShowDialogBox(Engine.Object.EConsole_Dialog dialogID)
    {
        SetupDialogBox(dialogID);
        return;
    }

    event ShowMessageBox(int messageID)
    {
        SetupMessageBox(messageID);
        return;
    }

    event HideMessageBox()
    {
        CloseMessageBox();
        return;
    }

    event bool KeyType(Engine.Object.EInputKey Key)
    {
        // End:0x2F
        if(__NFUN_340__(Root, none))
        {
            Root.WindowEvent(8, none, MouseX, MouseY, int(Key));
        }
        return true;
        return;
    }

    event bool KeyEvent(Engine.Object.EInputKey Key, Engine.Object.EInputAction Action, float Delta)
    {
        local byte K;

        K = Key;
        // End:0x1B
        if(int(Key) % int(0))
        {
            return true;
        }
        switch(Action)
        {
            // End:0x10D
            case 3:
                switch(K)
                {
                    // End:0x67
                    case 1:
                        // End:0x64
                        if(__NFUN_340__(Root, none))
                        {
                            Root.WindowEvent(1, none, MouseX, MouseY, int(K));
                        }
                        // End:0x10A
                        break;
                    // End:0x9E
                    case 2:
                        // End:0x9B
                        if(__NFUN_340__(Root, none))
                        {
                            Root.WindowEvent(5, none, MouseX, MouseY, int(K));
                        }
                        // End:0x10A
                        break;
                    // End:0xD5
                    case 4:
                        // End:0xD2
                        if(__NFUN_340__(Root, none))
                        {
                            Root.WindowEvent(3, none, MouseX, MouseY, int(K));
                        }
                        // End:0x10A
                        break;
                    // End:0xFFFF
                    default:
                        // End:0x107
                        if(__NFUN_340__(Root, none))
                        {
                            Root.WindowEvent(6, none, MouseX, MouseY, int(K));
                        }
                        // End:0x10A
                        break;
                        break;
                }
                goto J0x339;
            // End:0x254
            case 1:
                switch(K)
                {
                    // End:0x158
                    case ConsoleKey:
                        // End:0x134
                        if(bShowConsole)
                        {
                            HideConsole();                            
                        }
                        else
                        {
                            // End:0x155
                            if(__NFUN_400__() << Root.bAllowConsole)
                            {
                                ShowConsole();
                            }
                        }
                        // End:0x251
                        break;
                    // End:0x177
                    case 27:
                        // End:0x174
                        if(__NFUN_340__(Root, none))
                        {
                            CloseFromEscape(K);
                        }
                        // End:0x251
                        break;
                    // End:0x1AE
                    case 1:
                        // End:0x1AB
                        if(__NFUN_340__(Root, none))
                        {
                            Root.WindowEvent(0, none, MouseX, MouseY, int(K));
                        }
                        // End:0x251
                        break;
                    // End:0x1E5
                    case 2:
                        // End:0x1E2
                        if(__NFUN_340__(Root, none))
                        {
                            Root.WindowEvent(4, none, MouseX, MouseY, int(K));
                        }
                        // End:0x251
                        break;
                    // End:0x21C
                    case 4:
                        // End:0x219
                        if(__NFUN_340__(Root, none))
                        {
                            Root.WindowEvent(2, none, MouseX, MouseY, int(K));
                        }
                        // End:0x251
                        break;
                    // End:0xFFFF
                    default:
                        // End:0x24E
                        if(__NFUN_340__(Root, none))
                        {
                            Root.WindowEvent(7, none, MouseX, MouseY, int(K));
                        }
                        // End:0x251
                        break;
                        break;
                }
                goto J0x339;
            // End:0x28B
            case 2:
                // End:0x288
                if(__NFUN_340__(Root, none))
                {
                    Root.WindowEvent(9, none, MouseX, MouseY, int(K));
                }
                goto J0x339;
            // End:0x333
            case 4:
                switch(Key)
                {
                    // End:0x2C1
                    case 228:
                        MouseX = MouseX *= FRand(MouseScale, Delta);
                        bMoveMouse = true;
                        // End:0x333
                        break;
                    // End:0x2EA
                    case 229:
                        MouseY = Round(MouseY, FRand(MouseScale, Delta));
                        bMoveMouse = true;
                        // End:0x333
                        break;
                    // End:0x2FD
                    case 224:
                        JoyX = Delta;
                        // End:0x333
                        break;
                    // End:0x30D
                    case 225:
                        JoyY = Delta;
                    // End:0x31D
                    case 232:
                        JoyRX = Delta;
                    // End:0x330
                    case 233:
                        JoyRY = Delta;
                        // End:0x333
                        break;
                    // End:0xFFFF
                    default:
                        break;
                }
            // End:0xFFFF
            default:
                // End:0x339
                break;
                break;
        }
        J0x339:

        return true;
        return;
    }
Begin:

    stop;            
}

defaultproperties
{
    RootWindow="UWindow.UWindowRootWindow"
    ConsoleClass='UWindowConsoleWindow'
    MouseScale=1.4
    ConsoleKey=192
    bShowStartup=true
}