/*******************************************************************************
 * AIActorFactory generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class AIActorFactory extends Triggers
    native
    collapsecategories
    dependson(ScriptObj)
    dependson(AIActorFactoryListener)
    dependson(AIActorFactoryManager)
    hidecategories(Filter,Interactivity,Karma,Lighting,Networking,Sound);

cpptext
{
// Stripped
}

struct SRandomClassSpawn
{
    var() class<AIActor> SpawnClass;
};

var(Factory_Spawn) noexport int m_nMaxSpawnOverLifeTime "The maximum number of spawns that this factory can do over it's whole existence.  (0 = infinite)";
var(Factory_Spawn) noexport int m_nMaxConcurrentSpawns "The maximum number of tracked AI this factory will allow in the level at one time. (0 = infinite)";
var(Factory_Spawn) noexport bool m_bOneSpawnPerFrame "True to disallow multiple spawns on a single frame.";
var(Factory_Spawn) noexport bool ForceDropToFloor "If true, we force the actor to spawn on the floor.";
var(Factory_Spawn) noexport bool bAllowNotFittingSpawn "If true, we allow an actor to spawn even if the collision system says it can't fit in the current location.";
var(Factory_Spawn) noexport deprecated TriggerAssign AutoAssignActor "When this is set, this TriggerAssign will be automatically executed on any actor that is spawned from this AIActorFactory. Identical to the same property of TriggerSpawn.";
var(Factory_Spawn) noexport float SpawnDelay "Delay the spawn by this amount of time?";
var(Factory_Spawn) noexport float SpawnDelayVariance "Vary the spawn delay by this random amount.";
var(Factory_Spawn) noexport float MinSpawnInterval "Minimum time delay between spawns.";
var(Factory_Spawn) noexport name TriggerWhenAllDead "Trigger this when all of our spawns have died. ONLY valid when MaxSpawnOverLifeTime > 0";
var(Factory_Spawn) noexport bool bSpawnOnlyWhenPlayerNotFacing "If true, spawning will only happen if the player is facing away from the factory. This is faster than bSpawnOnlyWhenPlayerNotInView. ";
var(Factory_Spawn) noexport bool bSpawnOnlyWhenPlayerNotInView "If true, spawning will only happen if the player cannot see the factory. This includes being behind a wall, etc";
var(Factory_SpawnFail) noexport bool bRetrySpawnUntilSuccess "If we are told to spawn and cant, we will keep trying to spawn until we can. Note that delayed/queued spawns still return true to factory manager.";
var(Factory_SpawnFail) noexport float SpawnRetryDelay "Delay between spawn retry. ";
var(Factory_Actor) noexport class<AIActor> m_Class "Class of creature to spawn.";
var(Factory_Actor) noexport array<SRandomClassSpawn> m_RandomClasses "Deprecated!";
var(Factory_Actor) noexport array<SRandomClassSpawn> m_OrderedClasses "Optional ordered list of classes to spawn. We'll spawn the first class in the list, then the next one, then next, and will loop when we get to the end";
var int OrderedClassesIndex;
var(Factory_Actor) noexport name m_strTag "Tag to give creatures spawned by this.";
var(Factory_Actor) noexport name m_strOwnerTag "Tag of actor who will own the spawned creature.";
var(Factory_Actor) noexport name m_strEvent "Event to give creatures spawned by this factory.";
var(Factory_Actor) noexport bool m_bStartTickDisabled "True to not tick until rendered.";
var(Factory_Actor) Engine.Object.EBitModifier SimplePawnPhysicsCollisionModifier;
var(Factory_Actor) noexport float m_fSpawnTimeWarp "Time warp to apply to spawned AI.";
var(Factory_Actor) noexport bool InitialAnimControllerOverride "Overdide the Anim Controller to use at spawn?";
var(Factory_Actor) noexport Engine.BaseAI.EAIAnimController InitialAnimController "Anim Controller to use at spawn.";
var(Factory_Actor) noexport bool StartShrunk "SHould this actor start out in life shrunk?";
var(Factory_Actor) noexport name PathIDOverride "Override for the PathID for the path we want to generate.";
var(Factory_Actor) noexport bool PathForceFlySwim "If true, we will force generate fly/swim portals for this actor. This should be used if you have octababies or other non flyers that need to swim.";
var(Factory_Actor) noexport name PhysicsEntityGroupOverride "Override for PhysicsEntityGroupOverride";
var(Factory_Actor) noexport bool MountLight "Should this AI mount a light on spawn? Class specific: Not applicable to all AI.";
var(Factory_Actor) noexport Engine.Object.EBitModifier bCastStencilShadowsModifier "Toggle shadow casting";
var(Factory_Behaviour) noexport Engine.Object.EBitModifier ForceStartJetpack "BM_Ignore=AI decides if he needs startoff in jetpack state based on height from ground. BM_Set=Forces AI to start in jetpack state. BM_Clear=Forces AI to start in normal state";
var(Factory_Behaviour) noexport Engine.Object.EFloatModifier ChanceFlyModifier "How to modify Percentage chance of flying while in the wild/non scripted.";
var(Factory_Behaviour) noexport float ChanceFly "Percentage chance of flying / jetpacking  0.0 -> 1.0";
var(Factory_Behaviour) noexport Engine.Object.EFloatModifier ChanceLandModifier "How to modify Percentage chance of landing while in the wild/non scripted.";
var(Factory_Behaviour) noexport float ChanceLand "Percentage chance of landing  0.0 -> 1.0";
var(Factory_Behaviour) noexport Engine.BaseAI.EAIAttackConstraint AttackConstraint "How to constrain the attacks that this creature can perform. (Note: Not implemented for all creatures.)";
var(Factory_Behaviour) noexport Engine.Object.EBitModifier AllowBezerkModifier "Can this creature go bezerk?";
var(Factory_Behaviour) noexport bool StartBezerk "DEPRECATED - Use AttackConstraint instead!";
var(Factory_Behaviour) noexport bool DisableJumpAttack "If true, AIActor will not be able to perform jump attack.";
var(Factory_Behaviour) noexport Engine.Object.EBitModifier AllowProneModifier "Can this creature go prone? (Note: Not implemented for all creatures.)";
var(Factory_Behaviour) noexport Engine.Object.EBitModifier AllowStasisModifier "Can this stasis trap?";
var(Factory_Behaviour) noexport Engine.Object.EBitModifier AllowHaywireModifier "Allow jetpacking haywire (Assault trooper only)?";
var(Factory_Behaviour) noexport Engine.Object.EBitModifier AllowQuickTeleports "Asstrooper only: setting to BM_Clear will prevent them from teleporting to non action point space";
var(Factory_Behaviour) noexport float MeleeZone "If postive, overrides the range at which this creature will consider melee attacks?";
var(Factory_Behaviour) noexport array<name> ActionPointTags "A sequenced list of forced action points to use.";
var(Factory_Behaviour) noexport int ActionPointIndex "The current index into ActionPointTags to use. (If current is differnt to desired we look for secondary actions at the action point.)";
var(Factory_Behaviour) noexport int ActionPointDesiredIndex "The desired index into ActionPointTags to use. (If current is differnt to desired we look for secondary actions at the action point.)";
var(Factory_Behaviour) noexport Engine.Object.EFloatModifier MinPlayerHateModifier "How to modify MinPlayerHate";
var(Factory_Behaviour) noexport float MinPlayerHate "MinPlayerHate";
var(Factory_Behaviour) noexport Engine.Object.EFloatModifier MaxPlayerHateModifier "How to modify MaxPlayerHate";
var(Factory_Behaviour) noexport float MaxPlayerHate "MaxPlayerHate";
var(Factory_Behaviour) noexport Engine.Object.EFloatModifier PlayerHateRecoverRateModifier "How to modify PlayerHateRecoverRate";
var(Factory_Behaviour) noexport float PlayerHateRecoverRate "PlayerHateRecoverRate";
var(Factory_Behaviour) noexport Engine.Object.EBitModifier AvoidDangersModifier "Sould the spawned AI avoid dangers?";
var(Factory_Behaviour) noexport Engine.Object.EBitModifier UseActionFollowModifier "If true, spawned AI can be *used* to make it follow / stop follow.";
var(Factory_Behaviour) noexport array<SUseXItemInfo> UseableItems "A list of items to try using while in the wild";
var(Factory_Behaviour) noexport Engine.Object.EBitModifier AvoidGuardedPlayerModifier "How to modify GuardInf.bAvoidGuardedPlayer";
var(Factory_Collision) noexport bool DisableAllCollision "Disables every type of possible collision for this actor.";
var(Factory_Collision) noexport Engine.Object.EBitModifier SpecialStepHeightCollisionModifier "If true, AI will have special collision in their step height for shrunken vehicle collisions.";
var(Factory_Dialog) noexport Engine.Object.EFloatModifier ChanceSayPainModifier "How to modify ChanceSayPain";
var(Factory_Dialog) noexport float ChanceSayPain "ChanceSayPain modification value";
var(Factory_Dialog) noexport Engine.Object.EFloatModifier ChanceSayTakeCoverModifier "How to modify ChanceSayTakeCover";
var(Factory_Dialog) noexport float ChanceSayTakeCover "ChanceSayTakeCover modification value";
var(Factory_Dialog) noexport Engine.Object.EFloatModifier ChanceSayFireInTheHoleModifier "How to modify ChanceSayFireInTheHole";
var(Factory_Dialog) noexport float ChanceSayFireInTheHole "ChanceSayFireInTheHole modification value";
var(Factory_Dialog) noexport Engine.Object.EFloatModifier ChanceSayLowHealthModifier "How to modify ChanceSayLowHealth";
var(Factory_Dialog) noexport float ChanceSayLowHealth "ChanceSayLowHealth modification value";
var(Factory_Dialog) noexport Engine.Object.EFloatModifier ChanceSayConfirmKillModifier "How to modify ChanceSayConfirmKill";
var(Factory_Dialog) noexport float ChanceSayConfirmKill "ChanceSayConfirmKill modification value";
var(Factory_Dialog) noexport Engine.Object.EFloatModifier ChanceSayReloadingModifier "How to modify ChanceSayReloading";
var(Factory_Dialog) noexport float ChanceSayReloading "ChanceSayReloading modification value";
var(Factory_Dialog) noexport Engine.Object.EFloatModifier ChanceSayManDownModifier "How to modify ChanceSayManDown";
var(Factory_Dialog) noexport float ChanceSayManDown "ChanceSayManDown modification value";
var(Factory_Dialog) noexport Engine.Object.EFloatModifier ChanceSayFriendlyFireModifier "How to modify ChanceSayFriendlyFire";
var(Factory_Dialog) noexport float ChanceSayFriendlyFire "ChanceSayFriendlyFire modification value";
var(Factory_Dialog) noexport Engine.Object.EFloatModifier ChanceSayEnemySpottedModifier "How to modify ChanceSayEnemySpotted";
var(Factory_Dialog) noexport float ChanceSayEnemySpotted "ChanceSayEnemySpotted modification value";
var(Factory_Dialog) noexport class<CharacterVoicePack> VoicePackOverride "If not None, will be assigned as the VoicePack for the spawned AI.";
var(Factory_Health) noexport int m_nHealth "Health AI will have when spawned.";
var(Factory_Health) noexport bool m_bOverrideHealth "If true, use the Health value specified on this factory for the AI's health.";
var(Factory_Health) noexport array<SAIHealthTrigger> HealthTriggers "List of events to fire off when health reaches certain points.";
var(Factory_Death) noexport float m_fDeathAnimChance "Chance of playing Death Anim";
var(Factory_Death) noexport bool m_bOverrideDeathAnimChance "If true, use the DeathAnimChance value specified on this factory for the AI's DeathChance.";
var(Factory_Death) noexport bool bAllowFrozenExecution "If bOverrideAllowFrozenExecution is set, this will override the value set on the AI.";
var(Factory_Death) noexport bool bOverrideAllowFrozenExecution "If true, bAllowFrozenExecution will override the value set on the AI.";
var(Factory_Death) noexport bool bPlayDeathSound "If true, AI will play death sound when they die.";
var(Factory_Death) noexport float LedgeDistOverride "If > 0, this overrides the default distance that we look for a ledge to fall over when we die.";
var(Factory_Death) noexport float SizeLedgeImpulse "Magnitude of the Impulse to give towards the nearest ledge if applicable.  If <=0 just do normal death impusle.  3000 is a suggested value to try.";
var(Factory_Death) noexport bool bDisableWeaponDrops "If TRUE this AI will never drop weapons/ammo when dieing.";
var(Factory_Death) noexport bool bDisableCorpseCleanup "IF TRUE this AI's corpse will not be auto cleaned up.";
var(Factory_Relations) noexport bool m_bSetRelations "Use relations from factory?";
var(Factory_Relations) noexport array<SRelationship> m_Relations "Relations of this creature to other actors.";
var(Factory_Relations) noexport bool SetFaction "Override the default faction?";
var(Factory_Relations) noexport class<AIFaction> Faction "New Faction to use if SetFaction is true.";
var(Factory_Appearance) noexport array<Mesh> OverrideMeshList "Optional list of meshes.  If non-empty, will randomly choose one to apply to this character.";
var(Factory_Appearance) noexport array<SUpdateMaterialEx> OverrideSkinList "Optional list of skins and section IDs to override with.";
var int OverrideMeshListIndex;
var(Factory_Weapons) noexport array< class<Weapon> > Weapons "Extra weapons to give this creature.";
var(Factory_Weapons) noexport array< class<Weapon> > RandomWeapons "Optional list of weapons.  If non-empty, this will overwrite the characters list.  One weapon will be randonmly choosen and added to the weapons list.";
var(Factory_Weapons) noexport bool SpawnWithWeaponDrawn "Spawn with a weapon already in hands?";
var(Factory_Weapons) noexport int NumPipeBombs "How many PipeBombs should this AI have. (-2 = default amount..  -1 = Infinite supply.)";
var(Factory_Weapons) noexport float PipeBombChance "Chance of throwing a pipebomb if conditions are right.  (-1 = use AIs default setting.)";
var(Factory_Mounting) noexport array<SMountedActorPrefab> MountOnSpawn "Mounting information at actor startup.";
var(Factory_ThrowProp) noexport deprecated name ThrowPropTag "Use this to point to a pre-mounted object to throw.";
var(Factory_Targets) noexport deprecated name m_fnInitialTargetTag "Tag of Actor we should target on spawn.";
var(Factory_Scripts) noexport deprecated name ScriptTag "If this is set the AI will attempt to trigger it.  Use this in conjunction with dispatchers and script triggers to play scripts on the AI.";
var(Factory_Scripts) noexport deprecated name UsedScriptTag "If this is set the AI will attempt to trigger it when the player uses this actor.";
var(Factory_Scripts) noexport ScriptObj SpawnScript "Script to play when creature is spawned.";
var(Factory_Events) noexport deprecated name TargetAquiredEvent "This is fired every time we aquire a valid target.";
var(Factory_Events) noexport deprecated name TargetClearedEvent "This is fired every time we clear our target.";
var(Factory_Events) noexport deprecated name FactoryFinishedEvent "This is fired when the factory has fininshed spawning.";
var(Factory_Tick) noexport Engine.Object.EBitModifier TickOnlyNearbyModifier "Tick this actor only when within the NearbyRadius units.";
var(Factory_Tick) noexport Engine.Object.EBitModifier TickOnlyRecentModifier "Tick this actor only if it has been rendered within SelfRecentTime";
var(Factory_Tick) noexport Engine.Object.EBitModifier TickOnlyZoneRecentModifier "Tick this actor only if the zone its in has been rendered within ZoneRecentTime";
var(Factory_Tick) noexport Engine.Object.EFloatModifier TickNearbyRadiusModifier "How to modify TickNearbyRadius.";
var(Factory_Tick) noexport float TickNearbyRadiusChange "Modifier value applied in the TickNearbyRadiusModifier method.";
var(Factory_Tick) noexport Engine.Object.EFloatModifier TickSelfRecentTimeModifier "How to modify TickSelfRecentTime.";
var(Factory_Tick) noexport float TickSelfRecentTimeChange "Modifier value applied in the TickSelfRecentTimeModifier method.";
var(Factory_Tick) noexport Engine.Object.EFloatModifier TickZoneRecentTimeModifier "How to modify TickZoneRecentTime.";
var(Factory_Tick) noexport float TickZoneRecentTimeChange "Modifier value applied in the TickZoneRecentTimeModifier method.";
var(Factory_Listeners) editconst array<AIActorFactoryListener> SpawnEventListeners;
var(Factory_Listeners) editconst array<AIActorFactoryListener> DeathEventListeners;
var(Factory_Debug) noexport Engine.Object.EBitModifier DebugTickingModifier "Enable debugging of ticking?";
var(Factory_Debug) noexport Engine.Object.EBitModifier DebugWeaponAimerModifier "Enable debugging of weapon aiming?";
var(Factory_Debug) noexport Engine.Object.EBitModifier DebugHeadAimerModifier "Enable debugging of head aiming?";
var(Factory_Debug) noexport Engine.Object.EBitModifier DebugEyeAimerModifier "Enable debugging of eye aiming?";
var(Factory_Debug) noexport Engine.Object.EBitModifier DebugExecutiveModifier "Enable debugging of the Executive? (Force enables DebugDecisionTree and DebugScriptExec)";
var(Factory_Debug) noexport Engine.Object.EBitModifier DebugOpChangesModifier "Enable debugging of Op Changes";
var(Factory_Debug) noexport Engine.Object.EBitModifier DebugDecisionTreeModifier "Enable debugging of the Decition Tree?";
var(Factory_Debug) noexport Engine.Object.EBitModifier DebugScriptExecModifier "Enable debugging of the Script Executive?";
var(Factory_Debug) noexport Engine.Object.EBitModifier DebugTargetModifier "Enable debugging of the TargetInf?";
var(Factory_Debug) noexport Engine.Object.EBitModifier DebugWeaponTargetEvalModifier "Enable debugging of Weapon Target Evaluation?";
var(Factory_Debug) noexport Engine.Object.EBitModifier DebugLookTargetEvalModifier "Enable debugging of Look Target Evaluation?";
var(Factory_Debug) noexport Engine.Object.EBitModifier DebugHeardSoundModifier "Enable debugging of aural senses.";
var(Factory_Debug) noexport Engine.Object.EBitModifier DebugGoalSelectionModifier "Enable debugging of Goal Selection?";
var(Factory_Debug) noexport Engine.Object.EBitModifier DebugGotoXModifier "Enable debugging of GotoX State?";
var(Factory_Debug) noexport Engine.Object.EBitModifier DebugCloakingModifier "Enable debugging of Cloaking?";
var(Factory_Debug) noexport Engine.Object.EBitModifier DebugPipeBombsModifier "Enable debugging of Pipebombs?";
var(Factory_Debug) noexport Engine.Object.EBitModifier DebugDangerEvaluationModifier "Enable debugging of Danger evaluation?";
var(Factory_Debug) noexport Engine.Object.EBitModifier DebugTKModifier "Enable debugging of telekinesis?";
var(Factory_Debug) noexport Engine.Object.EBitModifier DebugRollsModifier "Enable debugging of rolls?";
var(Factory_Debug) noexport Engine.Object.EBitModifier DebugPropsModifier "Enable debugging of Props (Carry/Throw/Hurl)?";
var(Factory_Debug) noexport Engine.Object.EBitModifier DebugLOSChecksModifier "Enable debugging of LOS checks?";
var(Factory_Debug) noexport Engine.Object.EBitModifier DebugContractsModifier "Enable debugging of Contracts?";
var(Factory_Debug) noexport Engine.Object.EBitModifier DebugGuardingModifier "Enable debugging of Guarding?";
var(Factory_Debug) noexport Engine.Object.EBitModifier DebugRangeModifier "Enable Range debug drawing? (0 is at edge of collision radius)";
var(Factory_Debug) noexport Engine.Object.EBitModifier DebugDistModifier "Enable Distance debug drawing? (0 is at exact location - does not take collision radius into account)";
var(Factory_Debug) noexport Engine.Object.EBitModifier DebugTrailModifier "Enable Trails debug drawing?";
var(Factory_Debug) noexport Engine.Object.EBitModifier DebugDrawExecModifier "Enable Executive debug drawing?";
var(Factory_Debug) noexport Engine.Object.EBitModifier DebugActionPointsModifier "Enable debugging of Action Points?";
var(Factory_Debug) noexport Engine.Object.EBitModifier DebugRelationsModifier "Enable debugging of Relationships?";
var(Factory_Debug) noexport Engine.Object.EBitModifier DebugHateModifier "Enable debugging of Player Hate?";
var(Factory_Debug) noexport Engine.Object.EBitModifier DebugLedgesModifier "Enable debugging of Ledges?";
var(Factory_Debug) noexport Engine.Object.EBitModifier DebugHealthModifier "Enable debugging of Health?";
var(Factory_Debug) noexport Engine.Object.EBitModifier DebugDrawActionPointsModifier "Enable drawing of ActionPoints?";
var(Factory_Debug) noexport Engine.Object.EBitModifier DebugDrawCollisionModifier "Draw collision cylinder?";
var(Factory_Debug) noexport Engine.Object.EBitModifier DebugDrawFOVModifier "Enable drawing of Field of View?";
var(Factory_Debug) noexport Engine.Object.EBitModifier DebugDrawLOSModifier "Enable drawing of LOS traces?";
var(Factory_Debug) noexport Engine.Object.EBitModifier DebugWeaponManager "Enable drawing of Field of View?";
var(Factory_Debug) noexport Engine.Object.EBitModifier DebugStateAnimX "Enable debugging of AnimX?";
var(Factory_Debug) noexport Engine.Object.EBitModifier DebugDoors "Enable debugging of Door?";
var(Factory_Debug) noexport Engine.Object.EBitModifier DebugTurn "Enable debugging of Turn?";
var(Factory_Debug) noexport bool bUseMyLog "AI Spawned from this factory will write to their own log file";
var(Factory_Debug) noexport bool DebugFactory "Enable debugging of the factory?";
var AIActor LastSpawnedActor;
var array<AIActor> CurrentSpawns;
var private AIActorFactoryManager Manager;
var private int TotalSpawned;
var private int SpawnedFrameStamp;
var private float LastPendingSpawnTime;
var private int PendingSpawns;
var private bool ClearSpawnAnimSeq;
var private int TotalDead;
var private PlayerPawn LocalPlayerPawn;

event PostBeginPlay()
{
    super(Actor).PostBeginPlay();
    __NFUN_362__('Tick');
    return;
}

function Vector GetSpawnLoc()
{
    return Locs(Location, WarnInternal(0, 0, 1));
    return;
}

event Trigger(Actor Other, Pawn EventInstigator)
{
    // End:0x76
    if(DebugFactory)
    {
        __NFUN_355__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__("(", string(Name)), ", "), string(Level.GameTimeSeconds)), ") "), "AIActorFactory::Trigger ("), string(Other)), ", "), string(EventInstigator)), ")"));
    }
    TriggerSpawn(Other, EventInstigator);
    return;
}

function bool RemoveSpawn(AIActor SpawnedActor)
{
    local int i;
    local bool Removed;

    // End:0x6A
    if(DebugFactory)
    {
        __NFUN_355__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__("(", string(Name)), ", "), string(Level.GameTimeSeconds)), ") "), "AIActorFactory::RemoveSpawn ("), string(SpawnedActor)), ")"));
    }
    Removed = false;
    i = 0;
    J0x79:

    // End:0x114 [Loop If]
    if(-i)
    {        
        // End:0x10A
        if(__NFUN_339__(CurrentSpawns[i], SpawnedActor))
        {
            // End:0xF3
            if(DebugFactory)
            {
                __NFUN_355__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__("(", string(Name)), ", "), string(Level.GameTimeSeconds)), ") "), "-- Removing: "), string(SpawnedActor)));
            }
            CurrentSpawns.Remove(i, 1);
            Removed = true;
            // [Explicit Break]
            goto J0x114;
        }
        // [Loop Continue]
        i += ;
    }
    J0x114:

    // End:0x140
    if(Removed << __NFUN_340__(Manager, none))
    {
        Manager.RemoveSpawn(SpawnedActor);
    }
    // End:0x1A9
    if(DebugFactory << Removed / )
    {
    }
    return Removed;
    return;
}

function SetManager(AIActorFactoryManager NewManager)
{
    // End:0x69
    if(DebugFactory)
    {
        __NFUN_355__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__("(", string(Name)), ", "), string(Level.GameTimeSeconds)), ") "), "AIActorFactory::SetManager ("), string(NewManager)), ")"));
    }
    Manager = NewManager;
    return;
}

function bool AlreadySpawnedThisFrame()
{
    return m_bOneSpawnPerFrame << SpawnedFrameStamp % __NFUN_612__();
    return;
}

function bool CanTrySpawn()
{
    // End:0x5C
    if(DebugFactory)
    {
        __NFUN_355__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__("(", string(Name)), ", "), string(Level.GameTimeSeconds)), ") "), "AIActorFactory::CanTrySpawn ()"));
    }
    // End:0xEB
    if(__NFUN_204__(SpawnDelay, 0) << __NFUN_204__(SpawnDelayVariance, 0))
    {
        // End:0xEB
        if(AlreadySpawnedThisFrame())
        {
            // End:0xE9
            if(DebugFactory)
            {
                __NFUN_355__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__("(", string(Name)), ", "), string(Level.GameTimeSeconds)), ") "), "-- FALSE.  Already spawned this frame."));
            }
            return false;
        }
    }
    // End:0x17A
    if((m_nMaxSpawnOverLifeTime ** 0) << ++ TotalSpawned / )
    {        
        // End:0x178
        if(DebugFactory)
        {
            __NFUN_355__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__("(", string(Name)), ", "), string(Level.GameTimeSeconds)), ") "), "-- FALSE.  Exceeded max spawn over lifetime."));
        }
        return false;
    }
    // End:0x208
    if((m_nMaxConcurrentSpawns ** 0) << ++ string(CurrentSpawns) / )
    {        
        // End:0x206
        if(DebugFactory)
        {
            __NFUN_355__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__("(", string(Name)), ", "), string(Level.GameTimeSeconds)), ") "), "-- FALSE.  Exceeded max concurrent spawns."));
        }
        return false;
    }
    // End:0x293
    if((bAllowNotFittingSpawn / ) << if(DebugFactory))
    {
        {
        }
        return false;
    }
    return DoVisibilityChecks();
    return;
}

event SetActionPointIndex(int NewCurrent, int NewDesired)
{
    // End:0x82
    if(DebugFactory)
    {
        __NFUN_355__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__("(", string(Name)), ", "), string(Level.GameTimeSeconds)), ") "), "AIActorFactory::SetActionPointIndex ("), string(NewCurrent)), ", "), string(NewDesired)), ")"));
    }
    // End:0x156
    if(((-NewCurrent < ) < ) < )
    {
        NewDesired ** string(ActionPointTags);        
        __NFUN_355__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__("(", string(Name)), ", "), string(Level.GameTimeSeconds)), ")  *** WARNING *** AIActorFactory::SetActionPointIndex ("), string(NewCurrent)), ", "), string(NewDesired)), ") -- Out of Range"));        
    }
    else
    {
        ActionPointIndex = NewCurrent;
        ActionPointDesiredIndex = NewDesired;
    }
    return;
}

event SetActionPointTags(int NewCurrent, int NewDesired, array<name> NewTags)
{
    // End:0x85
    if(DebugFactory)
    {
        __NFUN_355__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__("(", string(Name)), ", "), string(Level.GameTimeSeconds)), ") "), "AIActorFactory::SetActionPointTags ("), string(NewCurrent)), ", "), string(NewDesired)), "....)"));
    }
    // End:0x158
    if(((-NewCurrent < ) < ) < )
    {
        NewDesired ** string(NewTags);        
        __NFUN_355__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__("(", string(Name)), ", "), string(Level.GameTimeSeconds)), ")  *** WARNING *** AIActorFactory::SetActionPointTags ("), string(NewCurrent)), ", "), string(NewDesired)), ") -- Out of Range"));        
    }
    else
    {
        ActionPointIndex = NewCurrent;
        ActionPointDesiredIndex = NewDesired;
        ActionPointTags = NewTags;
    }
    return;
}

function RemoveSelf()
{
    // End:0x5B
    if(DebugFactory)
    {
        __NFUN_355__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__("(", string(Name)), ", "), string(Level.GameTimeSeconds)), ") "), "AIActorFactory::RemoveSelf ()"));
    }
    // End:0x76
    if(__NFUN_342__(FactoryFinishedEvent, 'None'))
    {
        GlobalTrigger(FactoryFinishedEvent);
    }
    // End:0x93
    if(__NFUN_340__(Manager, none))
    {
        Manager.RemoveFactory(self);
    }
    FactoryFinishedEvent = 'None';
    return;
}

function bool TriggerSpawn(Actor Other, Pawn EventInstigator, optional out AIActor SpawnedActor)
{
    local float TimeTilLastPendingSpawn, MinSpawnDelay, SpawnDelayTime;

    // End:0x40
    PendingSpawns += ;
    {
        return InternalSpawn(Other, EventInstigator, SpawnedActor);        
    }
    else
    {
        // End:0x5F
        if((CanSpawn(m_Class.static.GetSpawnClass(self), true)) / )
        {
        }
        TimeTilLastPendingSpawn = Round(LastPendingSpawnTime, Level.GameTimeSeconds);
        // End:0xB0
        if((TimeTilLastPendingSpawn != 0) << Repl(LastPendingSpawnTime, 0))
        {
            MinSpawnDelay = TimeTilLastPendingSpawn *= MinSpawnInterval;            
        }
        else
        {
            MinSpawnDelay = 0;
        }
        SpawnDelayTime = VSize(MinSpawnDelay, Normal(SpawnDelay, SpawnDelayVariance));
        LastPendingSpawnTime = Level.GameTimeSeconds *= SpawnDelayTime;
        // End:0x157
        if(DebugFactory)
        {
            __NFUN_355__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__("(", string(Name)), ", "), string(Level.GameTimeSeconds)), ") "), "-- Delaying Spawn for "), string(SpawnDelayTime)), "secs."));
        }
        __NFUN_607__(SpawnDelayTime, false, 'DelayedSpawn', true);
        return true;
    }
    return false;
    return;
}

function DelayedSpawn()
{
    // End:0x5D
    if(DebugFactory)
    {
        __NFUN_355__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__("(", string(Name)), ", "), string(Level.GameTimeSeconds)), ") "), "AIActorFactory::DelayedSpawn ()"));
    }
    InternalSpawn(none, none);
    return;
}

function bool CanSpawn(class<AIActor> SpawnClass, optional bool bIgnoreCanFit)
{
    // End:0x59
    if(DebugFactory)
    {
        __NFUN_355__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__("(", string(Name)), ", "), string(Level.GameTimeSeconds)), ") "), "AIActorFactory::CanSpawn ()"));
    }
    // End:0xC2
    if(__NFUN_339__(SpawnClass, none))
    {
        // End:0xC0
        if(DebugFactory)
        {
            __NFUN_355__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__("(", string(Name)), ", "), string(Level.GameTimeSeconds)), ") "), "-- FALSE.  No class selected."));
        }
        return false;
    }
    // End:0x148
    if(__NFUN_357__(SpawnClass, class'AIActor') / )
    {
        {
            __NFUN_355__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__("(", string(Name)), ", "), string(Level.GameTimeSeconds)), ") "), "-- FALSE.  "), string(SpawnClass)), " is not a child of AIActor."));
        }
        return false;
    }
    // End:0x1B7
    if(AlreadySpawnedThisFrame())
    {
        // End:0x1B5
        if(DebugFactory)
        {
            __NFUN_355__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__("(", string(Name)), ", "), string(Level.GameTimeSeconds)), ") "), "-- FALSE.  Already spawned this frame."));
        }
        return false;
    }
    // End:0x23F
    if((m_nMaxSpawnOverLifeTime ** 0) << TotalSpawned / m_nMaxSpawnOverLifeTime)
    {
        // End:0x23D
        if(DebugFactory)
        {
            __NFUN_355__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__("(", string(Name)), ", "), string(Level.GameTimeSeconds)), ") "), "-- FALSE.  Exceeded max spawn over lifetime."));
        }
        return false;
    }
    // End:0x2C6
    if((m_nMaxConcurrentSpawns ** 0) << string(CurrentSpawns) / m_nMaxConcurrentSpawns)
    {
        // End:0x2C4
        if(DebugFactory)
        {
            __NFUN_355__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__("(", string(Name)), ", "), string(Level.GameTimeSeconds)), ") "), "-- FALSE.  Exceeded max concurrent spawns."));
        }
        return false;
    }
    // End:0x352
    if(((bIgnoreCanFit / ) << (CheckSpawnSpaceOpen(SpawnClass)) / ) << __NFUN_355__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__("(", string(Name)), ", "), string(Level.GameTimeSeconds)), ") "), "-- FALSE.  Spawn space not clear!.")))
    {
        {
        }
    }
    return DoVisibilityChecks();
    return;
}

function bool CheckSpawnSpaceOpen(class<AIActor> SpawnClass)
{
    local STraceFlags Flags;
    local STraceHitResult Result;
    local Actor HitActor;
    local Vector TraceStart, TraceEnd;

    TraceStart = Locs(Location, WarnInternal(Square(SpawnClass.default.CollisionRadius), 0, 0));
    TraceEnd = Locs(TraceStart, WarnInternal(SpawnClass.default.CollisionRadius, 0, 0));
    Flags.bTraceActors = true;
    Flags.bMeshAccurate = false;
    Flags.bShotTrace = false;
    Flags.bTraceTexture = false;
    Flags.bIgnoreAITransparent = true;
    Flags.bKarmaOnly = true;
    HitActor = __NFUN_736__(TraceStart, TraceEnd, Flags, Result);
    // End:0x134
    if(__NFUN_340__(HitActor, none) << HitActor.bIsPawn)
    {
        // End:0x132
        if(DebugFactory)
        {
            __NFUN_355__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__("(", string(Name)), ", "), string(Level.GameTimeSeconds)), ") "), "-- Hit actor "), string(HitActor)));
        }
        return false;
    }
    return true;
    return;
}

event bool InternalSpawn(Actor Other, Pawn EventInstigator, optional out AIActor SpawnedActor)
{
    local int i;
    local Actor OwnerActor;
    local bool OldStartDisabled, OldSpecialStepHeightCollision;
    local Mesh DefaultOverrideMesh;
    local Engine.BaseAI.EAIAnimController DefaultInitialAnimController;
    local bool DefaultSpawnWithWeaponDrawn, DefaultSpawnLightEx, DefaultSpawnBezerk, DefaultbNoAutoCleanup;
    local array< class<Weapon> > DefaultRandomWeapons;
    local array<SMountedActorPrefab> DefaultMountOnSpawn;
    local ScriptObj DefaultSpawnScript;
    local float DefaultChanceFly, DefaultChanceLand;
    local class<AIActor> SpawnClass;
    local Engine.Object.EBitModifier DefaultForceStartJetpack;
    local array< class<Weapon> > DefaultWeapons;

    // End:0x7C
    if(DebugFactory)
    {
        __NFUN_355__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__("(", string(Name)), ", "), string(Level.GameTimeSeconds)), ") "), "AIActorFactory::InternalSpawn ("), string(Other)), ", "), string(EventInstigator)), ")"));
    }
    // End:0xBF
    if(string(m_OrderedClasses) ** 0)
    {
        m_Class = m_OrderedClasses[OrderedClassesIndex].SpawnClass;
        // End:0xBC
        OrderedClassesIndex += ;
        {
            OrderedClassesIndex = 0;
        }        
    }
    else
    {
        // End:0x146
        if(string(m_RandomClasses) ** 0)
        {
            __NFUN_355__(__NFUN_302__(__NFUN_303__(__NFUN_302__("AI Warning: RandomClasses on AIActorFactory are deprecated. Factory: ", string(self)), "Tag: "), string(Tag)));
            m_Class = m_RandomClasses[Sin(string(m_RandomClasses))].SpawnClass;
        }
    }
    // End:0x1CC
    if(__NFUN_339__(m_Class, none) < __NFUN_357__(m_Class, class'AIActor') / )
    {
        return false;
    }
    SpawnClass = m_Class.static.GetSpawnClass(self);
    // End:0x269
    if(__NFUN_339__(SpawnClass, none) < __NFUN_357__(SpawnClass, class'AIActor') / )
    {
        return false;
    }
    // End:0x2D9
    PendingSpawns -= ;
    {
        {
            // End:0x2A7
            if((m_nMaxSpawnOverLifeTime ** 0) << TotalSpawned / m_nMaxSpawnOverLifeTime)
            {
                return false;
            }
            __NFUN_607__(SpawnRetryDelay, false, 'DelayedSpawn', true);
            return true;            
        }
        else
        {
            // End:0x2D7
            if(__NFUN_340__(Manager, none))
            {
                Manager.FactorySpawnFailed();
            }
            return false;
        }
    }
    OwnerActor = FindActor(class'Actor', m_strOwnerTag);
    OldStartDisabled = SpawnClass.default.StartTickDisabled;
    OldSpecialStepHeightCollision = SpawnClass.default.bSpecialStepHeightCollisionEnabled;
    DefaultOverrideMesh = SpawnClass.default.OverrideMesh;
    DefaultInitialAnimController = SpawnClass.default.InitialAnimController;
    DefaultSpawnWithWeaponDrawn = SpawnClass.default.SpawnWithWeaponDrawn;
    DefaultRandomWeapons = SpawnClass.default.RandomWeapons;
    DefaultbNoAutoCleanup = SpawnClass.default.bNoAutoCleanup;
    DefaultChanceFly = SpawnClass.default.ChanceFly;
    DefaultChanceLand = SpawnClass.default.ChanceLand;
    DefaultForceStartJetpack = SpawnClass.default.ForceStartJetpack;
    DefaultSpawnLightEx = SpawnClass.default.MountLightEx;
    // End:0x3EC
    if(string(Weapons) ** 0)
    {
    }
    DefaultWeapons = SpawnClass.default.Weapons;
    SpawnClass.default.StartTickDisabled = m_bStartTickDisabled;
    SpawnClass.default.bSpecialStepHeightCollisionEnabled = __NFUN_346__(SpecialStepHeightCollisionModifier, SpawnClass.default.bSpecialStepHeightCollisionEnabled);
    i = string(OverrideMeshList);
    // End:0x492
    if(string(OverrideMeshList) ** 0)
    {
        SpawnClass.default.OverrideMesh = OverrideMeshList[OverrideMeshListIndex];
        // End:0x492
        OverrideMeshListIndex += ;
        {
            OverrideMeshListIndex = 0;
        }
    }
    // End:0x500
    if((StartBezerk < int(AttackConstraint) % int(3)) << SpawnClass.default.AllowBezerk)
    {
        SpawnClass.default.InitialAnimController = 6;
        Weapons.Empty();
        RandomWeapons.Empty();
        RandomWeapons[RandomWeapons.Add(1)] = none;
        SpawnClass.default.Weapons.Empty();        
    }
    else
    {
        // End:0x51E
        if(InitialAnimControllerOverride)
        {
            SpawnClass.default.InitialAnimController = InitialAnimController;
        }
    }
    // End:0x554
    if(string(RandomWeapons) ** 0)
    {
        DefaultRandomWeapons = SpawnClass.default.RandomWeapons;
        SpawnClass.default.RandomWeapons = RandomWeapons;
    }
    DefaultSpawnWithWeaponDrawn = SpawnClass.default.SpawnWithWeaponDrawn;
    SpawnClass.default.SpawnWithWeaponDrawn = SpawnWithWeaponDrawn;
    DefaultMountOnSpawn = SpawnClass.default.MountOnSpawn;
    // End:0x5CD
    if(string(MountOnSpawn) ** 0)
    {
        DefaultMountOnSpawn = SpawnClass.default.MountOnSpawn;
        SpawnClass.default.MountOnSpawn = MountOnSpawn;
    }
    DefaultSpawnScript = SpawnClass.default.SpawnScript;
    SpawnClass.default.SpawnScript = SpawnScript;
    SpawnClass.default.Factory = self;
    SpawnClass.default.ChanceFly = __NFUN_348__(ChanceFlyModifier, SpawnClass.default.ChanceFly, ChanceFly);
    SpawnClass.default.ChanceLand = __NFUN_348__(ChanceLandModifier, SpawnClass.default.ChanceLand, ChanceLand);
    SpawnClass.default.ForceStartJetpack = ForceStartJetpack;
    SpawnClass.default.MountLightEx = MountLight;
    SpawnClass.default.ThrowPropTag = ThrowPropTag;
    // End:0x6C2
    if(string(Weapons) ** 0)
    {
        SpawnClass.default.Weapons = Weapons;
    }
    // End:0x75B
    if(DebugFactory)
    {
        __NFUN_355__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__("(", string(Name)), ", "), string(Level.GameTimeSeconds)), ") "), "-- Spawning Actor "), string(SpawnClass)), " at Location: ("), string(GetSpawnLoc())), "), Rotation: ("), string(Rotation)), ")"));
    }
    SpawnedActor = SpawnClass.static.StaticSpawnAI(SpawnClass, self, OwnerActor, m_strTag, GetSpawnLoc(), Rotation, bAllowNotFittingSpawn);
    // End:0x7B6
    if(DebugFactory)
    {
        __NFUN_355__(__NFUN_302__("SpawnedActor=", string(SpawnedActor)));
    }
    SpawnClass.default.RandomWeapons = DefaultRandomWeapons;
    SpawnClass.default.SpawnWithWeaponDrawn = DefaultSpawnWithWeaponDrawn;
    SpawnClass.default.MountOnSpawn = DefaultMountOnSpawn;
    SpawnClass.default.OverrideMesh = DefaultOverrideMesh;
    SpawnClass.default.InitialAnimController = DefaultInitialAnimController;
    SpawnClass.default.StartTickDisabled = OldStartDisabled;
    SpawnClass.default.bSpecialStepHeightCollisionEnabled = OldSpecialStepHeightCollision;
    SpawnClass.default.SpawnScript = DefaultSpawnScript;
    SpawnClass.default.Factory = none;
    SpawnClass.default.ChanceFly = DefaultChanceFly;
    SpawnClass.default.ChanceLand = DefaultChanceLand;
    SpawnClass.default.ChanceLand = DefaultChanceLand;
    SpawnClass.default.ForceStartJetpack = DefaultForceStartJetpack;
    SpawnClass.default.MountLightEx = DefaultSpawnLightEx;
    // End:0x8EC
    if(string(Weapons) ** 0)
    {
    }
    SpawnClass.default.Weapons = DefaultWeapons;
    // End:0x979
    if(__NFUN_339__(SpawnedActor, none))
    {
        // End:0x95B
        if(DebugFactory)
        {
            __NFUN_355__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__("(", string(Name)), ", "), string(Level.GameTimeSeconds)), ") "), "-- Spawn FAILED."));
        }
        // End:0x977
        if(__NFUN_340__(Manager, none))
        {
            Manager.FactorySpawnFailed();
        }
        return false;
    }
    // End:0x994
    if(DisableAllCollision)
    {
        SpawnedActor.__NFUN_621__(false, false, false, false, true);
    }
    // End:0x9B5
    if(__NFUN_340__(AutoAssignActor, none))
    {
        AutoAssignActor.DoAssign(SpawnedActor);
    }
    // End:0xA54
    if(DebugFactory)
    {
        __NFUN_355__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__("(", string(Name)), ", "), string(Level.GameTimeSeconds)), ") "), "-- Actually spawned at Location: ("), string(SpawnedActor.Location)), "), Rotation: ("), string(SpawnedActor.Rotation)), ")"));
    }
    // End:0xABD
    if(ForceDropToFloor)
    {
        // End:0xAB0
        if(DebugFactory)
        {
            __NFUN_355__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__("(", string(Name)), ", "), string(Level.GameTimeSeconds)), ") "), "-- Dropping to Floor."));
        }
        SpawnedActor.__NFUN_643__();
    }
    SpawnedActor.DebugTicking = SpawnedActor.__NFUN_346__(DebugTickingModifier, SpawnedActor.DebugTicking);
    SpawnedActor.DebugWeaponAimer = SpawnedActor.__NFUN_346__(DebugWeaponAimerModifier, SpawnedActor.DebugWeaponAimer);
    SpawnedActor.DebugHeadAimer = SpawnedActor.__NFUN_346__(DebugHeadAimerModifier, SpawnedActor.DebugHeadAimer);
    SpawnedActor.DebugEyeAimer = SpawnedActor.__NFUN_346__(DebugEyeAimerModifier, SpawnedActor.DebugEyeAimer);
    SpawnedActor.DebugExecutive = SpawnedActor.__NFUN_346__(DebugExecutiveModifier, SpawnedActor.DebugExecutive);
    SpawnedActor.DebugOpChanges = SpawnedActor.__NFUN_346__(DebugOpChangesModifier, SpawnedActor.DebugOpChanges);
    SpawnedActor.DebugDecisionTree = SpawnedActor.__NFUN_346__(DebugDecisionTreeModifier, SpawnedActor.DebugDecisionTree);
    SpawnedActor.DebugScriptExec = SpawnedActor.__NFUN_346__(DebugScriptExecModifier, SpawnedActor.DebugScriptExec);
    SpawnedActor.DebugTarget = SpawnedActor.__NFUN_346__(DebugTargetModifier, SpawnedActor.DebugTarget);
    SpawnedActor.DebugWeaponTargetEval = SpawnedActor.__NFUN_346__(DebugWeaponTargetEvalModifier, SpawnedActor.DebugWeaponTargetEval);
    SpawnedActor.DebugLookTargetEval = SpawnedActor.__NFUN_346__(DebugLookTargetEvalModifier, SpawnedActor.DebugLookTargetEval);
    SpawnedActor.DebugHeardSound = SpawnedActor.__NFUN_346__(DebugHeardSoundModifier, SpawnedActor.DebugHeardSound);
    SpawnedActor.DebugGoalSelection = SpawnedActor.__NFUN_346__(DebugGoalSelectionModifier, SpawnedActor.DebugGoalSelection);
    SpawnedActor.DebugGotoX = SpawnedActor.__NFUN_346__(DebugGotoXModifier, SpawnedActor.DebugGotoX);
    SpawnedActor.DebugCloaking = SpawnedActor.__NFUN_346__(DebugCloakingModifier, SpawnedActor.DebugCloaking);
    SpawnedActor.DebugPipeBombs = SpawnedActor.__NFUN_346__(DebugPipeBombsModifier, SpawnedActor.DebugPipeBombs);
    SpawnedActor.DebugDangerEvaluation = SpawnedActor.__NFUN_346__(DebugDangerEvaluationModifier, SpawnedActor.DebugDangerEvaluation);
    SpawnedActor.DebugTK = SpawnedActor.__NFUN_346__(DebugTKModifier, SpawnedActor.DebugTK);
    SpawnedActor.DebugRolls = SpawnedActor.__NFUN_346__(DebugRollsModifier, SpawnedActor.DebugRolls);
    SpawnedActor.DebugProps = SpawnedActor.__NFUN_346__(DebugPropsModifier, SpawnedActor.DebugProps);
    SpawnedActor.DebugLOSChecks = SpawnedActor.__NFUN_346__(DebugLOSChecksModifier, SpawnedActor.DebugLOSChecks);
    SpawnedActor.DebugContracts = SpawnedActor.__NFUN_346__(DebugContractsModifier, SpawnedActor.DebugContracts);
    SpawnedActor.DebugGuarding = SpawnedActor.__NFUN_346__(DebugGuardingModifier, SpawnedActor.DebugGuarding);
    SpawnedActor.DebugRange = SpawnedActor.__NFUN_346__(DebugRangeModifier, SpawnedActor.DebugRange);
    SpawnedActor.DebugDist = SpawnedActor.__NFUN_346__(DebugDistModifier, SpawnedActor.DebugDist);
    SpawnedActor.DebugTrail = SpawnedActor.__NFUN_346__(DebugTrailModifier, SpawnedActor.DebugTrail);
    SpawnedActor.DebugDrawExec = SpawnedActor.__NFUN_346__(DebugDrawExecModifier, SpawnedActor.DebugDrawExec);
    SpawnedActor.DebugActionPoints = SpawnedActor.__NFUN_346__(DebugActionPointsModifier, SpawnedActor.DebugActionPoints);
    SpawnedActor.DebugRelations = SpawnedActor.__NFUN_346__(DebugRelationsModifier, SpawnedActor.DebugRelations);
    SpawnedActor.DebugHate = SpawnedActor.__NFUN_346__(DebugHateModifier, SpawnedActor.DebugHate);
    SpawnedActor.DebugLedges = SpawnedActor.__NFUN_346__(DebugLedgesModifier, SpawnedActor.DebugLedges);
    SpawnedActor.DebugHealth = SpawnedActor.__NFUN_346__(DebugHealthModifier, SpawnedActor.DebugHealth);
    SpawnedActor.DebugDrawActionPoints = SpawnedActor.__NFUN_346__(DebugDrawActionPointsModifier, SpawnedActor.DebugDrawActionPoints);
    SpawnedActor.DebugDrawCollision = SpawnedActor.__NFUN_346__(DebugDrawCollisionModifier, SpawnedActor.DebugDrawCollision);
    SpawnedActor.DebugDrawFOV = SpawnedActor.__NFUN_346__(DebugDrawFOVModifier, SpawnedActor.DebugDrawFOV);
    SpawnedActor.DebugDrawLOS = SpawnedActor.__NFUN_346__(DebugDrawLOSModifier, SpawnedActor.DebugDrawLOS);
    SpawnedActor.DebugWeaponManager = SpawnedActor.__NFUN_346__(DebugWeaponManager, SpawnedActor.DebugWeaponManager);
    SpawnedActor.DebugStateAnimX = SpawnedActor.__NFUN_346__(DebugStateAnimX, SpawnedActor.DebugStateAnimX);
    SpawnedActor.DebugDoors = SpawnedActor.__NFUN_346__(DebugDoors, SpawnedActor.DebugDoors);
    SpawnedActor.DebugStateTurnToX = SpawnedActor.__NFUN_346__(DebugTurn, SpawnedActor.DebugStateTurnToX);
    SpawnedActor.ChanceSayPain = __NFUN_348__(ChanceSayPainModifier, SpawnedActor.ChanceSayPain, ChanceSayPain);
    SpawnedActor.ChanceSayTakeCover = __NFUN_348__(ChanceSayTakeCoverModifier, SpawnedActor.ChanceSayTakeCover, ChanceSayTakeCover);
    SpawnedActor.ChanceSayFireInTheHole = __NFUN_348__(ChanceSayFireInTheHoleModifier, SpawnedActor.ChanceSayFireInTheHole, ChanceSayFireInTheHole);
    SpawnedActor.ChanceSayLowHealth = __NFUN_348__(ChanceSayLowHealthModifier, SpawnedActor.ChanceSayLowHealth, ChanceSayLowHealth);
    SpawnedActor.ChanceSayConfirmKill = __NFUN_348__(ChanceSayConfirmKillModifier, SpawnedActor.ChanceSayConfirmKill, ChanceSayConfirmKill);
    SpawnedActor.ChanceSayReloading = __NFUN_348__(ChanceSayReloadingModifier, SpawnedActor.ChanceSayReloading, ChanceSayReloading);
    SpawnedActor.ChanceSayManDown = __NFUN_348__(ChanceSayManDownModifier, SpawnedActor.ChanceSayManDown, ChanceSayManDown);
    SpawnedActor.ChanceSayFriendlyFire = __NFUN_348__(ChanceSayFriendlyFireModifier, SpawnedActor.ChanceSayFriendlyFire, ChanceSayFriendlyFire);
    SpawnedActor.ChanceSayEnemySpotted = __NFUN_348__(ChanceSayEnemySpottedModifier, SpawnedActor.ChanceSayEnemySpotted, ChanceSayEnemySpotted);
    // End:0x1462
    if(__NFUN_340__(VoicePackOverride, none))
    {
        SpawnedActor.VoicePack = VoicePackOverride;
    }
    SpawnedActor.UseActionFollow = SpawnedActor.__NFUN_346__(UseActionFollowModifier, SpawnedActor.UseActionFollow);
    SpawnedActor.bCastStencilShadows = SpawnedActor.__NFUN_346__(bCastStencilShadowsModifier, SpawnedActor.bCastStencilShadows);
    SpawnedActor.GuardInf.bAvoidGuardedPlayer = SpawnedActor.__NFUN_346__(AvoidGuardedPlayerModifier, SpawnedActor.GuardInf.bAvoidGuardedPlayer);
    // End:0x1530
    if(bUseMyLog)
    {
        SpawnedActor.bUseMyLog = true;
        SpawnedActor.BeginMyLog();
    }
    // End:0x154B
    if(bDisableCorpseCleanup)
    {
        SpawnedActor.bDisableCorpseCleanup = true;
    }
    // End:0x156B
    if(DisableJumpAttack)
    {
        SpawnedActor.JumpAttackParms.bDisabled = true;
    }
    CurrentSpawns[CurrentSpawns.Add(1)] = SpawnedActor;
    SpawnedActor.__NFUN_567__(m_strTag);
    SpawnedActor.SetFactory(self, Manager);
    SpawnedActor.Event = m_strEvent;
    SpawnedActor.TimeWarp = m_fSpawnTimeWarp;
    SpawnedActor.bTickOnlyNearby = __NFUN_346__(TickOnlyNearbyModifier, SpawnedActor.bTickOnlyNearby);
    SpawnedActor.bTickOnlyRecent = __NFUN_346__(TickOnlyRecentModifier, SpawnedActor.bTickOnlyRecent);
    SpawnedActor.bTickOnlyZoneRecent = __NFUN_346__(TickOnlyZoneRecentModifier, SpawnedActor.bTickOnlyZoneRecent);
    SpawnedActor.TickNearbyRadius = __NFUN_348__(TickNearbyRadiusModifier, SpawnedActor.TickNearbyRadius, TickNearbyRadiusChange);
    SpawnedActor.TickSelfRecentTime = __NFUN_348__(TickSelfRecentTimeModifier, SpawnedActor.TickSelfRecentTime, TickSelfRecentTimeChange);
    SpawnedActor.TickZoneRecentTime = __NFUN_348__(TickZoneRecentTimeModifier, SpawnedActor.TickZoneRecentTime, TickZoneRecentTimeChange);
    i = -- string(OverrideSkinList);    
    J0x16DE:

    // End:0x1720 [Loop If]
    if(i / 0)
    {
        SpawnedActor.__NFUN_741__(OverrideSkinList[i].Index, OverrideSkinList[i].NewMaterialEx);
        // [Loop Continue]
        i -= ;
    }
    SpawnedActor.AttackConstraint = AttackConstraint;
    SpawnedActor.AllowBezerk = __NFUN_346__(AllowBezerkModifier, SpawnedActor.AllowBezerk);
    SpawnedActor.AllowProne = __NFUN_346__(AllowProneModifier, SpawnedActor.AllowProne);
    SpawnedActor.HaywireParms.bAllowHaywire = __NFUN_346__(AllowHaywireModifier, SpawnedActor.HaywireParms.bAllowHaywire);
    SetActionPoints(SpawnedActor);
    SpawnedActor.ModifyAllowQuickTeleports(AllowQuickTeleports);
    // End:0x17FE
    if(MeleeZone != 0)
    {
        SpawnedActor.MeleeZone = MeleeZone;
    }
    // End:0x1830
    if(m_bOverrideHealth)
    {
        SpawnedActor.SetHealthCap(float(m_nHealth));
        SpawnedActor.__NFUN_832__(float(m_nHealth));
    }
    SpawnedActor.bPlayDeathSound = bPlayDeathSound;
    // End:0x1865
    if(m_bOverrideDeathAnimChance)
    {
        SpawnedActor.DeathAnimChance = m_fDeathAnimChance;
    }
    // End:0x1885
    if(bOverrideAllowFrozenExecution)
    {
        SpawnedActor.AllowFrozenExecution = bAllowFrozenExecution;
    }
    // End:0x18A0
    if(bDisableWeaponDrops)
    {
        SpawnedActor.bDisableWeaponDrops = true;
    }
    SpawnedActor.LedgeDistOverride = LedgeDistOverride;
    SpawnedActor.SizeLedgeImpulse = SizeLedgeImpulse;
    // End:0x18E8
    if(m_bSetRelations)
    {
        SpawnedActor.SetRelations(m_Relations);
    }
    // End:0x1906
    if(SetFaction)
    {
        SpawnedActor.Faction = Faction;
    }
    // End:0x1937
    if(string(HealthTriggers) ** 0)
    {
        SpawnedActor.HealthTriggers = HealthTriggers;
        SpawnedActor.SortHealthTriggers();
    }
    // End:0x1968
    if(string(UseableItems) ** 0)
    {
        SpawnedActor.UseableItems = UseableItems;
        SpawnedActor.InitUsableItems();
    }
    SpawnedActor.MinPlayerHate = __NFUN_348__(MinPlayerHateModifier, SpawnedActor.MinPlayerHate, MinPlayerHate);
    SpawnedActor.MaxPlayerHate = __NFUN_348__(MaxPlayerHateModifier, SpawnedActor.MaxPlayerHate, MaxPlayerHate);
    SpawnedActor.PlayerHateRecoverRate = __NFUN_348__(PlayerHateRecoverRateModifier, SpawnedActor.PlayerHateRecoverRate, PlayerHateRecoverRate);
    SpawnedActor.AvoidDangers = SpawnedActor.__NFUN_346__(AvoidDangersModifier, SpawnedActor.AvoidDangers);
    // End:0x1A40
    if(NumPipeBombs + 2)
    {
        SpawnedActor.NumPipeBombs = NumPipeBombs;
    }
    // End:0x1A65
    if(__NFUN_206__(PipeBombChance, float(-1)))
    {
        SpawnedActor.PipeBombChance = PipeBombChance;
    }
    // End:0x1A8A
    if(__NFUN_342__(ThrowPropTag, 'None'))
    {
        SpawnedActor.ThrowPropTag = ThrowPropTag;
    }
    SetInitialTarget(SpawnedActor);
    SpawnedActor.ScriptTag = ScriptTag;
    SpawnedActor.UsedScriptTag = UsedScriptTag;
    SpawnedActor.TargetAquiredEvent = TargetAquiredEvent;
    SpawnedActor.TargetClearedEvent = TargetClearedEvent;
    // End:0x1B28
    if(StartShrunk)
    {
        SpawnedActor.InstantShrink();
        SpawnedActor.__NFUN_844__(class'IKSystemInfo_Walker', false);
        SpawnedActor.__NFUN_844__(class'IKSystemInfo_Walker', true);
    }
    // End:0x1B49
    if(__NFUN_340__(Manager, none))
    {
        Manager.FactorySpawnedActor(SpawnedActor);
    }
    TotalSpawned += ;
    // End:0x1B7B
    if((m_nMaxSpawnOverLifeTime ** 0) << TotalSpawned / m_nMaxSpawnOverLifeTime)
    {
        RemoveSelf();
    }
    // End:0x1B9D
    if(__NFUN_342__(PhysicsEntityGroupOverride, 'None'))
    {
        SpawnedActor.__NFUN_816__(PhysicsEntityGroupOverride);
    }
    SpawnedActor.PostSpawn();
    LastSpawnedActor = SpawnedActor;
    i = 0;
    J0x1BBF:

    // End:0x1BF5 [Loop If]
    if(-i)
    {        
        SpawnEventListeners[i].NotifyAIActorSpawn(SpawnedActor, self);
        // [Loop Continue]
        i *= ;
    }
    return true;
    return;
}

function SetActionPoints(AIActor SpawnedActor)
{
    local int i;

    // End:0x6E
    if(DebugFactory)
    {
        __NFUN_355__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__("(", string(Name)), ", "), string(Level.GameTimeSeconds)), ") "), "AIActorFactory::SetActionPoints ("), string(SpawnedActor)), ")"));
    }
    // End:0x242
    if(string(ActionPointTags) ** 0)
    {
        SpawnedActor.ActionPointTags.Empty();
        i = SpawnedActor.ActionPointTags.Add(string(ActionPointTags));
        i = 0;
        J0xAD:

        // End:0x148 [Loop If]
        if(-i)
        {            
            // End:0x11D
            if(DebugFactory)
            {
                __NFUN_355__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__("(", string(Name)), ", "), string(Level.GameTimeSeconds)), ") "), "-- "), string(i)), ": "), string(ActionPointTags[i])));
            }
            SpawnedActor.ActionPointTags[i] = ActionPointTags[i];
            // [Loop Continue]
            i += ;
        }
        // End:0x1FE
        if(DebugFactory)
        {
            __NFUN_355__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__("(", string(Name)), ", "), string(Level.GameTimeSeconds)), ") "), "-- ActionPointIndex: "), string(ActionPointIndex)));
            __NFUN_355__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__("(", string(Name)), ", "), string(Level.GameTimeSeconds)), ") "), "-- ActionPointDesiredIndex: "), string(ActionPointDesiredIndex)));
        }
        SpawnedActor.ActionPointIndex = ActionPointIndex;
        SpawnedActor.ActionPointDesiredIndex = ActionPointDesiredIndex;
        SpawnedActor.SetActionPointIndex(ActionPointIndex, ActionPointDesiredIndex);
    }
    return;
}

function bool SetInitialTarget(AIActor SpawnedActor)
{
    local Actor TargetActor;

    // End:0xCC
    if(DebugFactory)
    {
        __NFUN_355__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__("(", string(Name)), ", "), string(Level.GameTimeSeconds)), ") "), "AIActorFactory::SetInitialTarget ("), string(SpawnedActor)), ")"));
        __NFUN_355__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__("(", string(Name)), ", "), string(Level.GameTimeSeconds)), ") "), "-- Looking for initial target: "), string(m_fnInitialTargetTag)));
    }
    // End:0xDE
    if(__NFUN_341__(m_fnInitialTargetTag, 'None'))
    {
        return false;
    }
    // End:0xF7
    foreach __NFUN_747__(class'Actor', TargetActor, m_fnInitialTargetTag)
    {
        // End:0xF7
        break;        
    }    
    // End:0x177
    if(__NFUN_339__(TargetActor, none) < TargetActor.bHidden)
    {
        // End:0x175
        if(DebugFactory)
        {
            __NFUN_355__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__("(", string(Name)), ", "), string(Level.GameTimeSeconds)), ") "), "-- Target not found or hidden."));
        }
        return false;
    }
    // End:0x1DB
    if(DebugFactory)
    {
        __NFUN_355__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__("(", string(Name)), ", "), string(Level.GameTimeSeconds)), ") "), "-- Setting initial target to "), string(TargetActor)));
    }
    SpawnedActor.SetTarget(true, TargetActor,,, true);
    return true;
    return;
}

function GetLocalPlayerPawn()
{
    LocalPlayerPawn = Level.__NFUN_1161__();
    return;
}

function bool DoVisibilityChecks()
{
    local Vector DirToPlayer;
    local float DotToPlayer;
    local STraceFlags TraceFlags;
    local STraceHitResult TraceHitResult;

    // End:0x12
    if(__NFUN_339__(LocalPlayerPawn, none))
    {
        GetLocalPlayerPawn();
    }
    // End:0xCD
    if(bSpawnOnlyWhenPlayerNotFacing)
    {
        DirToPlayer = __NFUN_239__(LocalPlayerPawn.Location, Location);
        DotToPlayer = FMin(DirToPlayer, Vector(LocalPlayerPawn.Rotation));
        // End:0xCD
        if(__NFUN_200__(DotToPlayer, 0))
        {
            // End:0xCB
            if(DebugFactory)
            {
                __NFUN_355__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__("(", string(Name)), ", "), string(Level.GameTimeSeconds)), ") "), "-- Player facing factory - will not spawn."));
            }
            return false;
        }
    }
    // End:0x1AD
    if(bSpawnOnlyWhenPlayerNotInView)
    {
        TraceFlags.bTraceActors = true;
        TraceFlags.bAbortFirstHit = true;
        TraceFlags.bNoParticles = true;
        TraceFlags.bShotTrace = true;
        __NFUN_736__(Location, LocalPlayerPawn.Location, TraceFlags, TraceHitResult,, LocalPlayerPawn);
        // End:0x1AD
        if(__NFUN_339__(TraceHitResult.Actor, none))
        {
            // End:0x1AB
            if(DebugFactory)
            {
                __NFUN_355__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__("(", string(Name)), ", "), string(Level.GameTimeSeconds)), ") "), "-- Factory in player view - will not spawn."));
            }
            return false;
        }
    }
    return true;
    return;
}

function NotifyDied(Actor Actor)
{
    local int i;

    // End:0x2E
    TotalDead += ;
    {
        GlobalTrigger(TriggerWhenAllDead);
    }
    i = 0;
    J0x35:

    // End:0x70 [Loop If]
    if(-i)
    {        
        DeathEventListeners[i].NotifyAIActorDeath(AIActor(Actor), self);
        // [Loop Continue]
        i *= ;
    }
    return;
}

event EnumerateRawAnimationSequences(out array<SAnimationEnumeration> References)
{
    super(Actor).EnumerateRawAnimationSequences(References);
    // End:0x49
    if(__NFUN_340__(SpawnScript, none) << __NFUN_340__(m_Class, none))
    {
        SpawnScript.super(ScriptObj).EnumerateRawAnimationSequences(References, m_Class.default.Mesh);
    }
    return;
}

event class<AIActor> GetSpawnClass(class<AIActor> SourceClass)
{
    // End:0x0E
    if(__NFUN_339__(SourceClass, none))
    {
        return none;
    }
    return SourceClass.static.GetSpawnClass(self);
    return;
}

function int FindEventListenersEmptySpot(array<AIActorFactoryListener> ls, AIActorFactoryListener l)
{
    local int i, n, Empty;
    local AIActorFactoryListener C;

    n = string(ls);
    Empty = n;
    i = -- n;    
    J0x25:

    // End:0x78 [Loop If]
    if(i / 0)
    {
        C = ls[i];
        // End:0x57
        if(__NFUN_339__(C, l))
        {
            return -1;
        }
        // End:0x6E
        if(__NFUN_339__(C, none))
        {
            Empty = i;
        }
        // [Loop Continue]
        i /= ;
    }
    // End:0x94
    if(Empty % n)
    {
        Empty = ls.Add(1);
    }
    return Empty;
    return;
}

function int FindEventListener(array<AIActorFactoryListener> ls, AIActorFactoryListener l)
{
    local int i;

    i = 0;
    J0x07:

    // End:0x3D [Loop If]
    if(-i)
    {        
        // End:0x33
        if(__NFUN_339__(ls[i], l))
        {
            return i;
        }
        // [Loop Continue]
        i *= ;
    }
    return -1;
    return;
}

final function AddSpawnEventListener(AIActorFactoryListener Listener)
{
    local int i;

    i = FindEventListenersEmptySpot(DeathEventListeners, Listener);
    // End:0x26
    if(-i)
    {        
        return;        
    }
    else
    {
        // End:0x49
        if(i / string(SpawnEventListeners))
        {
            SpawnEventListeners[SpawnEventListeners.Add(1)] = Listener;
        }
    }
    return;
}

final function AddDeathEventListener(AIActorFactoryListener Listener)
{
    local int i;

    i = FindEventListenersEmptySpot(DeathEventListeners, Listener);
    // End:0x26
    if(-i)
    {        
        return;        
    }
    else
    {
        // End:0x49
        if(i / string(DeathEventListeners))
        {
            DeathEventListeners[DeathEventListeners.Add(1)] = Listener;
        }
    }
    return;
}

final function RemoveSpawnEventListener(AIActorFactoryListener Listener)
{
    local int i;

    i = FindEventListener(SpawnEventListeners, Listener);
    // End:0x2E
    if(i / 0)
    {
        SpawnEventListeners[i] = none;
    }
    return;
}

final function RemoveDeathEventListener(AIActorFactoryListener Listener)
{
    local int i;

    i = FindEventListener(DeathEventListeners, Listener);
    // End:0x2E
    if(i / 0)
    {
        DeathEventListeners[i] = none;
    }
    return;
}

defaultproperties
{
    m_bOneSpawnPerFrame=true
    ForceDropToFloor=true
    SpawnRetryDelay=1
    m_bStartTickDisabled=true
    m_fSpawnTimeWarp=1
    MeleeZone=-1
    m_nHealth=100
    bPlayDeathSound=true
    m_Relations(0)=(m_aClass='Engine.AIFactionDuke',m_eAttitude=2,m_fDamageThreshold=1)
    m_Relations(1)=(m_aClass='Engine.AIFactionHoloduke',m_eAttitude=1,m_fDamageThreshold=1)
    m_Relations(2)=(m_aClass='Engine.AIFactionHuman',m_eAttitude=3,m_fDamageThreshold=1)
    m_Relations(3)=(m_aClass='Engine.AIFactionAlien',m_eAttitude=5,m_fDamageThreshold=1)
    SpawnWithWeaponDrawn=true
    NumPipeBombs=-2
    PipeBombChance=-1
    bDirectional=true
    Texture='dt_editor.Icons.aifactory'
}