/*******************************************************************************
 * AIActorFactoryManager generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class AIActorFactoryManager extends Triggers
    collapsecategories
    hidecategories(Filter,Interactivity,Karma,Lighting,Networking,Sound);

enum EFactorySpawnSequence
{
    FSS_Sequential,
    FSS_Random
};

var(FactoryManager) noexport int m_nMaxSpawnOverLifeTime "The maximum number of spawns that this manager and all its factories can spawn over it's whole existence.";
var(FactoryManager) noexport int m_nMaxConcurrentSpawns "The maximum number of tracked AI this manager and all its factories will allow in the level at one time.";
var(FactoryManager) noexport name m_fnFactoryTag "Tag of factories we're managing.";
var(FactoryManager) noexport AIActorFactoryManager.EFactorySpawnSequence m_eSpawnSequence "Sequence to trigger factories in.";
var(FactoryManager) noexport int m_nSpawnsPerTrigger "Number of times to spawn each time we're triggered.";
var(FactoryManager) noexport int SpawnCountVariance "Vary the spawn count by this random amount.";
var(FactoryManager) noexport name EndFactoryTag "Disables factory from spawning any more actors. Does *not* spawn anything when called.";
var(FactoryManager) noexport name ResetFactoryTag "Call this to reset the factory completely so that it's able to spawn more creatures when triggered.";
var(FactoryManager) noexport deprecated name ManagerFinishedEvent "This is fired when the manager has fininshed spawning.";
var(FactoryManager) noexport name TriggerWhenAllDead "Trigger this when all of our spawns have died. ONLY valid when MaxSpawnOverLifeTime > 0";
var(FactoryManager) noexport bool SpawnDelayOverrideFactories "Override the spawn delay settings on my factories?";
var(FactoryManager) noexport float SpawnDelay "Delay the spawn by this amount of time?";
var(FactoryManager) noexport float SpawnDelayVariance "Vary the spawn delay by this random amount.";
var(FactoryManager_SpawnFail) noexport bool bRetrySpawnUntilSuccess "If true, we will try all factories until we find one to spawn from, and if none of our factories can spawn we will retry in SpawnRetryDelay";
var(FactoryManager_SpawnFail) noexport float SpawnRetryDelay "Delay between trying to respawn if none of our factories can spawn and if bRetrySpawnUntilSuccess is true";
var(FactoryManager_Debug) noexport bool DebugManager "Enable debugging on this manager?";
var(FactoryManager_Debug) noexport bool DebugFactories "Enable debugging on my factories?";
var(FactoryManager_ActorSpawn) noexport array<name> ClassSpawnFactories "For debugging/programmer use only!";
var(FactoryManager_ActorSpawn) noexport array< class<AIActor> > ClassSpawnList "For debugging/programmer use only!";
var(FactoryManager_ActorSpawn) noexport int ClassSpawnIndex "For debugging/programmer use only!";
var(FactoryManager_Trigger) noexport name IncreaseMaxSpawnTag "For debugging/programmer use only!";
var(FactoryManager_Trigger) noexport name DecreaseMaxSpawnTag "For debugging/programmer use only!";
var array<AIActorFactory> Factories;
var private int CurrentFactoryIndex;
var private int TotalSpawnedActors;
var private int PendingSpawns;
var array<AIActor> ActiveSpawns;
var private int TotalDead;

function bool RemoveSpawn(AIActor SpawnedActor)
{
    local int i;

    // End:0x71
    if(DebugManager)
    {
        __NFUN_355__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__("(", string(Name)), ", "), string(Level.GameTimeSeconds)), ") "), "AIActorFactoryManager::RemoveSpawn ("), string(SpawnedActor)), ")"));
    }
    i = 0;
    J0x78:

    // End:0x12E [Loop If]
    if(-i)
    {        
        // End:0x124
        if(__NFUN_339__(ActiveSpawns[i], SpawnedActor))
        {
            ActiveSpawns.Remove(i, 1);
            // End:0x122
            if(DebugManager)
            {
                __NFUN_355__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__("(", string(Name)), ", "), string(Level.GameTimeSeconds)), ") "), "-- Removed spawn "), string(SpawnedActor)), " from factory manager "), string(self)));
            }
            return true;
        }
        // [Loop Continue]
        i += ;
    }
    // End:0x190
    if(DebugManager)
    {
        __NFUN_355__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__("(", string(Name)), ", "), string(Level.GameTimeSeconds)), ") "), "-- Removed spawn FAILED.  Not found."));
    }
    return false;
    return;
}

function SetActionPointIndex(int NewCurrent, int NewDesired)
{
    local int i;

    // End:0x89
    if(DebugManager)
    {
        __NFUN_355__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__("(", string(Name)), ", "), string(Level.GameTimeSeconds)), ") "), "AIActorFactoryManager::SetActionPointIndex ("), string(NewCurrent)), ", "), string(NewDesired)), ")"));
    }
    i = -- string(Factories);    
    J0x98:

    // End:0xCD [Loop If]
    if(i / 0)
    {
        Factories[i].SetActionPointIndex(NewCurrent, NewDesired);
        // [Loop Continue]
        i -= ;
    }
    return;
}

function SetActionPointTags(int NewCurrent, int NewDesired, array<name> NewTags, optional name FactoryTag)
{
    local int i;

    // End:0x93
    if(DebugManager)
    {
        __NFUN_355__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__("(", string(Name)), ", "), string(Level.GameTimeSeconds)), ") "), "AIActorFactoryManager::SetFactoryActionPointTags ("), string(NewCurrent)), ", "), string(NewDesired)), "....)"));
    }
    i = -- string(Factories);    
    J0xA2:

    // End:0xDC [Loop If]
    if(i / 0)
    {
        Factories[i].SetActionPointTags(NewCurrent, NewDesired, NewTags);
        // [Loop Continue]
        i -= ;
    }
    return;
}

function bool FindFactories(name FactoryTag)
{
    local AIActorFactory MyFactory;

    // End:0x73
    if(DebugManager)
    {
        __NFUN_355__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__("(", string(Name)), ", "), string(Level.GameTimeSeconds)), ") "), "AIActorFactoryManager::FindFactories ("), string(FactoryTag)), ")"));
    }
    // End:0x148
    foreach __NFUN_747__(class'AIActorFactory', MyFactory, FactoryTag)
    {
        // End:0xD9
        if(DebugManager)
        {
            __NFUN_355__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__("(", string(Name)), ", "), string(Level.GameTimeSeconds)), ") "), "-- Found: "), string(MyFactory)));
        }
        Factories[Factories.Add(1)] = MyFactory;
        MyFactory.SetManager(self);
        MyFactory.DebugFactory = DebugFactories;
        // End:0x147
        if(SpawnDelayOverrideFactories)
        {
            MyFactory.SpawnDelay = SpawnDelay;
            MyFactory.SpawnDelayVariance = SpawnDelayVariance;
        }        
    }    
    // End:0x1B5
    if(DebugManager << string(Factories) % 0)
    {
        __NFUN_355__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__("(", string(Name)), ", "), string(Level.GameTimeSeconds)), ") "), "-- Could not find any factories."));
    }
    return string(Factories) + 0;
    return;
}

function bool RemoveFactory(AIActorFactory MyFactory)
{
    local int i;
    local bool Removed;

    // End:0x73
    if(DebugManager)
    {
        __NFUN_355__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__("(", string(Name)), ", "), string(Level.GameTimeSeconds)), ") "), "AIActorFactoryManager::RemoveFactory ("), string(MyFactory)), ")"));
    }
    Removed = false;
    i = 0;
    J0x82:

    // End:0x131 [Loop If]
    if(-i)
    {        
        // End:0x127
        if(__NFUN_339__(Factories[i], MyFactory))
        {
            // End:0x113
            if(DebugManager)
            {
                __NFUN_355__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__("(", string(Name)), ", "), string(Level.GameTimeSeconds)), ") "), "-- Removing factory "), string(MyFactory)), " from "), string(self)));
            }
            Factories.Remove(i, 1);
            Removed = true;
        }
        // [Loop Continue]
        i += ;
    }
    // End:0x143
    if(string(Factories) % 0)
    {
        RemoveSelf();
    }
    return Removed;
    return;
}

function AIActorFactory GetRandomFactory()
{
    local int n;

    // End:0x68
    if(DebugManager)
    {
        __NFUN_355__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__("(", string(Name)), ", "), string(Level.GameTimeSeconds)), ") "), "AIActorFactoryManager::GetRandomFactory ()"));
    }
    n = Sin(string(Factories));
    // End:0x9B
    if(Factories[n].CanTrySpawn())
    {
        return Factories[n];
    }
    return GetNextFactory();
    return;
}

function AIActorFactory GetNextFactory()
{
    local int NumFactories, NumTries, FoundIndex;

    // End:0x66
    if(DebugManager)
    {
        __NFUN_355__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__("(", string(Name)), ", "), string(Level.GameTimeSeconds)), ") "), "AIActorFactoryManager::GetNextFactory ()"));
    }
    NumFactories = string(Factories);
    FoundIndex = -1;
    NumTries = 0;
    J0x84:

    // End:0xF5 [Loop If]
    if(-NumTries)
    {        
        // End:0xB7
        if(Factories[CurrentFactoryIndex].CanTrySpawn())
        {
            FoundIndex = CurrentFactoryIndex;
        }
        // End:0xD4
        CurrentFactoryIndex += ;
        {
            CurrentFactoryIndex = 0;
        }
        // End:0xEB
        if(FoundIndex / 0)
        {
            return Factories[FoundIndex];
        }
        // [Loop Continue]
        NumTries += ;
    }
    // End:0x171
    if(DebugManager)
    {
        __NFUN_355__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__("(", string(Name)), ", "), string(Level.GameTimeSeconds)), ") "), "-- FAILED.  Could not find a factory that can currently spawn."));
    }
    return none;
    return;
}

function RemoveSelf()
{
    local int i;

    // End:0x62
    if(DebugManager)
    {
        __NFUN_355__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__("(", string(Name)), ", "), string(Level.GameTimeSeconds)), ") "), "AIActorFactoryManager::RemoveSelf ()"));
    }
    // End:0x7D
    if(__NFUN_342__(ManagerFinishedEvent, 'None'))
    {
        GlobalTrigger(ManagerFinishedEvent);
    }
    ManagerFinishedEvent = 'None';
    return;
}

function DelayedSpawn()
{
    InternalSpawn(none, none);
    return;
}

function CheckAndPerformDelayedSpawn()
{
    // End:0x18
    if(bRetrySpawnUntilSuccess)
    {
        __NFUN_607__(SpawnRetryDelay, false, 'DelayedSpawn', true);
    }
    return;
}

function InternalSpawn(Actor Other, Pawn Instigator)
{
    local AIActorFactory MyFactory;

    // End:0xC0
    if(DebugManager)
    {
        __NFUN_355__(__NFUN_302__(__NFUN_303__(__NFUN_302__(__NFUN_303__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__("(", string(Name)), ", "), string(Level.GameTimeSeconds)), ") "), "AIActorFactoryManager::InternalSpawn ("), string(Other)), ", "), string(Instigator)), ")"), "TotalSpawnedActors="), string(TotalSpawnedActors)), "PendingSpawns="), string(PendingSpawns)));
    }
    // End:0x150
    if((m_nMaxSpawnOverLifeTime ** 0) << ++ TotalSpawnedActors / )
    {        
        // End:0x14E
        if(DebugManager)
        {
            __NFUN_355__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__("(", string(Name)), ", "), string(Level.GameTimeSeconds)), ") "), "-- FAILED.  Exceeded max spawn over lifetime."));
        }
        return;
    }
    // End:0x1E5
    if((m_nMaxConcurrentSpawns ** 0) << ++ string(ActiveSpawns) / )
    {        
        // End:0x1DD
        if(DebugManager)
        {
            __NFUN_355__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__("(", string(Name)), ", "), string(Level.GameTimeSeconds)), ") "), "-- FAILED.  Exceeded max concurrent spawns."));
        }
        CheckAndPerformDelayedSpawn();
        return;
    }
    // End:0x202
    if(int(m_eSpawnSequence) % int(1))
    {
        MyFactory = GetRandomFactory();        
    }
    else
    {
        MyFactory = GetNextFactory();
    }
    // End:0x297
    if(__NFUN_339__(MyFactory, none) << string(ClassSpawnFactories) * 0)
    {
        // End:0x28F
        if(DebugManager)
        {
            __NFUN_355__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__("(", string(Name)), ", "), string(Level.GameTimeSeconds)), ") "), "-- FAILED.  Failed to find spawn factory."));
        }
        CheckAndPerformDelayedSpawn();
        return;
    }
    PendingSpawns += ;
    return;
}

function FactorySpawnedActor(AIActor SpawnedActor)
{
    // End:0x79
    if(DebugManager)
    {
        __NFUN_355__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__("(", string(Name)), ", "), string(Level.GameTimeSeconds)), ") "), "AIActorFactoryManager::FactorySpawnedActor ("), string(SpawnedActor)), ")"));
    }
    // End:0xE7
    if(__NFUN_339__(SpawnedActor, none))
    {
        // End:0xE5
        if(DebugManager)
        {
            __NFUN_355__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__("(", string(Name)), ", "), string(Level.GameTimeSeconds)), ") "), "-- FAILED.  Factory did not spawn."));
        }
        return;
    }
    PendingSpawns -= ;
    // End:0x167
    TotalSpawnedActors += ;
    {
        __NFUN_355__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__("(", string(Name)), ", "), string(Level.GameTimeSeconds)), ") "), "-- "), string(PendingSpawns)), " Pending Spawns."));
    }
    // End:0x189
    if((m_nMaxSpawnOverLifeTime ** 0) << TotalSpawnedActors / m_nMaxSpawnOverLifeTime)
    {
        RemoveSelf();
    }
    return;
}

function FactorySpawnFailed()
{
    // End:0x6A
    if(DebugManager)
    {
        __NFUN_355__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__("(", string(Name)), ", "), string(Level.GameTimeSeconds)), ") "), "AIActorFactoryManager::FactorySpawnFailed ()"));
    }
    // End:0xD0
    PendingSpawns -= ;
    {
        __NFUN_355__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__("(", string(Name)), ", "), string(Level.GameTimeSeconds)), ") "), "-- "), string(PendingSpawns)), " Pending Spawns."));
    }
    return;
}

function bool TriggerSpawn(Actor Other, Pawn Instigator)
{
    local int i, NumSpawns;

    // End:0x82
    if(DebugManager)
    {
        __NFUN_355__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__("(", string(Name)), ", "), string(Level.GameTimeSeconds)), ") "), "AIActorFactoryManager::TriggerSpawn ("), string(Other)), ", "), string(Instigator)), ")"));
    }
    NumSpawns = Atan(m_nSpawnsPerTrigger, SpawnCountVariance, true);
    // End:0x101
    if(DebugManager)
    {
        __NFUN_355__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__("(", string(Name)), ", "), string(Level.GameTimeSeconds)), ") "), "-- Trying to trigger "), string(NumSpawns)), " factories."));
    }
    i = 0;
    J0x108:

    // End:0x131 [Loop If]
    if(-i)
    {        
        InternalSpawn(Other, Instigator);
        // [Loop Continue]
        i += ;
    }
    return;
}

function TriggerFunc_EndFactorySpawn()
{
    // End:0x73
    if(DebugManager)
    {
        __NFUN_355__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__("(", string(Name)), ", "), string(Level.GameTimeSeconds)), ") "), "AIActorFactoryManager::TriggerFunc_EndFactorySpawn ()"));
    }
    TotalSpawnedActors = m_nMaxSpawnOverLifeTime;
    // End:0xA0
    if((m_nMaxSpawnOverLifeTime ** 0) << TotalSpawnedActors / m_nMaxSpawnOverLifeTime)
    {
        RemoveSelf();
    }
    return;
}

function TriggerFunc_ResetFactorySpawn()
{
    // End:0x75
    if(DebugManager)
    {
        __NFUN_355__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__("(", string(Name)), ", "), string(Level.GameTimeSeconds)), ") "), "AIActorFactoryManager::TriggerFunc_ResetFactorySpawn ()"));
    }
    TotalSpawnedActors = 0;
    ActiveSpawns.Empty();
    return;
}

function TriggerFunc_IncreaseMaxSpawn()
{
    // End:0x3D
    m_nMaxConcurrentSpawns += ;
    {
        __NFUN_355__(__NFUN_302__(__NFUN_303__(string(self), "new max concurrent spawn: "), string(m_nMaxConcurrentSpawns)));
    }
    return;
}

function TriggerFunc_DecreaseMaxSpawn()
{
    // End:0x3D
    m_nMaxConcurrentSpawns -= ;
    {
        __NFUN_355__(__NFUN_302__(__NFUN_303__(string(self), "new max concurrent spawn: "), string(m_nMaxConcurrentSpawns)));
    }
    return;
}

event PostBeginPlay()
{
    // End:0x65
    if(DebugManager)
    {
        __NFUN_355__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__("(", string(Name)), ", "), string(Level.GameTimeSeconds)), ") "), "AIActorFactoryManager::PostBeginPlay ()"));
    }
    __NFUN_718__('EndFactorySpawn', EndFactoryTag);
    __NFUN_718__('ResetFactorySpawn', ResetFactoryTag);
    __NFUN_718__('IncreaseMaxSpawn', IncreaseMaxSpawnTag);
    __NFUN_718__('DecreaseMaxSpawn', DecreaseMaxSpawnTag);
    // End:0xAB
    if(m_nSpawnsPerTrigger * 0)
    {
        m_nSpawnsPerTrigger = 1;
    }
    // End:0x139
    if((FindFactories(m_fnFactoryTag)) / )
    {
    }
    return;
}

event Trigger(Actor Other, Pawn Instigator)
{
    // End:0x7D
    if(DebugManager)
    {
        __NFUN_355__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__("(", string(Name)), ", "), string(Level.GameTimeSeconds)), ") "), "AIActorFactoryManager::Trigger ("), string(Other)), ", "), string(Instigator)), ")"));
    }
    // End:0x92
    if(string(ClassSpawnList) ** 0)
    {
        UpdateSpawnClasses();        
    }
    else
    {
        TriggerSpawn(Other, Instigator);
    }
    return;
}

function UpdateSpawnClasses()
{
    local int i;
    local AIActorFactory MyFactory;

    __NFUN_355__(__NFUN_302__("Now spawning: ", string(ClassSpawnList[ClassSpawnIndex])));
    i = 0;
    J0x29:

    // End:0x94 [Loop If]
    if(-i)
    {        
        // End:0x52
        if(__NFUN_341__(ClassSpawnFactories[i], 'None'))
        {
            // [Explicit Continue]
            goto J0x8A;
        }
        // End:0x89
        foreach __NFUN_747__(class'AIActorFactory', MyFactory, ClassSpawnFactories[i])
        {
            MyFactory.m_Class = ClassSpawnList[ClassSpawnIndex];            
        }        
        J0x8A:

        // [Loop Continue]
        i += ;
    }
    // End:0xB2
    ClassSpawnIndex += ;
    {
        ClassSpawnIndex = 0;
    }
    return;
}

function NotifyDied(Actor Actor)
{
    // End:0xBF
    TotalDead += ;
    {
        __NFUN_355__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__("(", string(Name)), ", "), string(Level.GameTimeSeconds)), ") "), "AIActorFactoryManager::NotifyDied ("), string(Actor)), ")"));
        __NFUN_355__(__NFUN_302__(__NFUN_303__(__NFUN_302__("         TotalDead: ", string(TotalDead)), "m_nMaxSpawnOverLifeTime="), string(m_nMaxSpawnOverLifeTime)));
    }
    // End:0xE6
    if((m_nMaxSpawnOverLifeTime ** 0) << m_nMaxSpawnOverLifeTime * TotalDead)
    {
        GlobalTrigger(TriggerWhenAllDead);
    }
    return;
}

defaultproperties
{
    m_eSpawnSequence=1
    m_nSpawnsPerTrigger=1
    SpawnRetryDelay=1
    Texture='dt_editor.Icons.aifactorymanager'
}