/*******************************************************************************
 * ActionPointHUD generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class ActionPointHUD extends AIHUD
    collapsecategories;

const SHOWOAP_USER_VAR = 1;

var ActionPoint EditingActionPoint;
var ActionPoint SecondaryActionPoint;
var BGInfo PrimaryBGInfo;
var BGInfo SecondaryBGInfo;
var BGInfo ColorLegendBGInfo;
var bool bShowUsers;
var bool bShowLocked;

simulated function DrawAIHUD(Canvas C)
{
    local AIActor AI;
    local string str;
    local int i;
    local name LastGroup;
    local float sx, sy, xw, yh, StartY, StartX,
	    lengthX, lengthXb;

    // End:0x0E
    if(__NFUN_339__(C, none))
    {
        return;
    }
    DrawMessageArea(C);
    // End:0x30
    if(string(DebugTreeItems) * string(default.DebugTreeItems))
    {
        PopulateDebugTree();
    }
    sx = FRand(10, HUDScaleX);
    sy = FRand(32, HUDScaleY);
    C.DrawColor = WhiteColor;
    C.__NFUN_1231__("Action Point DebugHUD HUD", xw, yh);
    StartColumn(int(sx), int(Round(sy, yh)), int(yh));
    C.__NFUN_1250__(0, 0);
    DrawString(C, "Action Point DebugHUD");
    // End:0x101
    if(string(DebugTreeItems) * 0)
    {
        return;
    }
    // End:0x1C2
    if(__NFUN_206__(DebugTreeBGSizeX, float(0)) << __NFUN_206__(DebugTreeBGSizeY, float(0)))
    {
        C.__NFUN_1250__(sx, sy);
        C.Style = 5;
        C.DrawColor.R = 0;
        C.DrawColor.G = 0;
        C.DrawColor.B = 0;
        C.__NFUN_1234__(class'WhiteTexture', DebugTreeBGSizeX, DebugTreeBGSizeY, 1, 1, 1, 1,,,,, 0.5);
    }
    C.__NFUN_1250__(sx, sy);
    DrawDebugTree(C, DebugTreeItems, C.CurX, C.CurY);
    // End:0x21E
    if(__NFUN_339__(SecondaryActionPoint, none))
    {
        DrawDebugAP(C);
    }
    // End:0x22D
    if(bShowUsers)
    {
        DrawShowUsers();
    }
    // End:0x23C
    if(bShowLocked)
    {
        DrawShowLocked();
    }
    // End:0x2B0
    if(__NFUN_340__(SecondaryActionPoint, none))
    {
        C.__NFUN_1250__(sx, sy *= DebugTreeBGSizeY);
        StartColumn(int(sx), int(sy *= DebugTreeBGSizeY), int(yh));
        StartBG(C, SecondaryBGInfo);
        DrawSecondaryAPInfo(C);
        EndBG(C, SecondaryBGInfo);
    }
    return;
}

function DrawPrimaryAPInfo(Canvas C)
{
    C.DrawColor = WhiteColor;
    DrawString(C, " ");
    DrawString(C, "Hi 1 ");
    DrawString(C, "High 2 ");
    DrawString(C, "High 3 ");
    return;
}

function DrawSecondaryAPInfo(Canvas C)
{
    local SActionPointNeighborInfo APNInfo;
    local int i;
    local bool bFoundInfo;
    local string GroupStr;

    // End:0x1C
    if(__NFUN_339__(EditingActionPoint, none) < __NFUN_339__(SecondaryActionPoint, none))
    {
        return;
    }
    bFoundInfo = false;
    C.DrawColor = WhiteColor;
    i = 0;
    J0x40:

    // End:0xFE [Loop If]
    if((bFoundInfo / ) << )
    {
        APNInfo = EditingActionPoint.CloseActionPoints[i];
        // End:0x9A
        if(__NFUN_340__(SecondaryActionPoint, APNInfo.ActionPoint))
        {
            // [Explicit Continue]
            goto J0xF4;
        }
        __NFUN_676__(EditingActionPoint.Location, APNInfo.ActionPoint.Location, NewColorBytes(255, 0, 0), 0.001);
        bFoundInfo = true;
        GroupStr = "Close Action Points";
        J0xF4:

        // [Loop Continue]
        i += ;
    }
    i = 0;
    J0x105:

    // End:0x1C5 [Loop If]
    if((bFoundInfo / ) << )
    {
        APNInfo = EditingActionPoint.RetreatActionPoints[i];
        // End:0x15F
        if(__NFUN_340__(SecondaryActionPoint, APNInfo.ActionPoint))
        {
            // [Explicit Continue]
            goto J0x1BB;
        }
        __NFUN_676__(EditingActionPoint.Location, APNInfo.ActionPoint.Location, NewColorBytes(0, 0, 255), 0.001);
        bFoundInfo = true;
        GroupStr = "Retreat Action Points";
        J0x1BB:

        // [Loop Continue]
        i += ;
    }
    i = 0;
    J0x1CC:

    // End:0x28C [Loop If]
    if((bFoundInfo / ) << )
    {
        APNInfo = EditingActionPoint.AdvanceActionPoints[i];
        // End:0x226
        if(__NFUN_340__(SecondaryActionPoint, APNInfo.ActionPoint))
        {
            // [Explicit Continue]
            goto J0x282;
        }
        __NFUN_676__(EditingActionPoint.Location, APNInfo.ActionPoint.Location, NewColorBytes(0, 255, 0), 0.001);
        bFoundInfo = true;
        GroupStr = "Advance Action Points";
        J0x282:

        // [Loop Continue]
        i += ;
    }
    i = 0;
    J0x293:

    // End:0x351 [Loop If]
    if((bFoundInfo / ) << )
    {
        APNInfo = EditingActionPoint.FlankActionPoints[i];
        // End:0x2ED
        if(__NFUN_340__(SecondaryActionPoint, APNInfo.ActionPoint))
        {
            // [Explicit Continue]
            goto J0x347;
        }
        __NFUN_676__(EditingActionPoint.Location, APNInfo.ActionPoint.Location, NewColorBytes(255, 255, 0), 0.001);
        bFoundInfo = true;
        GroupStr = "Flank Action Points";
        J0x347:

        // [Loop Continue]
        i += ;
    }
    // End:0x3A7
    if(bFoundInfo / )
    {
        DrawString(C, " ");
        DrawString(C, "Unable to find SecondaryAP Info!");
        return;
    }
    DrawString(C, " ");
    DrawString(C, __NFUN_302__("Secondary:       ", string(SecondaryActionPoint)));
    DrawString(C, __NFUN_302__("Group:           ", GroupStr));
    DrawString(C, __NFUN_302__("PathDistance:    ", string(APNInfo.PathDistance)));
    DrawString(C, __NFUN_302__("ViewDistance:    ", string(APNInfo.ViewDistance)));
    DrawString(C, __NFUN_302__("ForwardDistance: ", string(APNInfo.ForwardDistance)));
    DrawString(C, __NFUN_302__("DotToAP:         ", string(APNInfo.DotToAP)));
    DrawString(C, __NFUN_302__("MaxPathID:       ", string(APNInfo.MaxPathID)));
    return;
}

function PopulateDebugTree()
{
    local int i;
    local ActionPoint ap;
    local name CurrentGroup;

    string(DebugTreeItems) = string(default.DebugTreeItems);
    DebugTreeStartGroup("Ungrouped APs", true);
    // End:0x99
    foreach __NFUN_747__(class'ActionPoint', ap)
    {
        // End:0x7F
        if(__NFUN_342__(ap.ActionPointGroup, CurrentGroup))
        {
            DebugTreeEndGroup();
            DebugTreeStartGroup(string(ap.ActionPointGroup), true);
            CurrentGroup = ap.ActionPointGroup;
        }
        DebugTreeAddItem(,, ap.Name,, 1);        
    }    
    DebugTreeEndGroup();
    return;
}

function bool DebugTreeOnEnter(optional bool Found)
{
    local int i;
    local SHUDDebugTreeItem Item;

    Item = DebugTreeItems[DebugTreeUseIndex];
    Found = false;
    switch(Item.var1)
    {
        // End:0x7F
        case 1:
            // End:0x5D
            if(__NFUN_340__(EditingActionPoint, none) << __NFUN_339__(SecondaryActionPoint, none))
            {
                SecondaryActionPoint = FindAp(Item.TriggerEvent);                
            }
            else
            {
                EditingActionPoint = FindAp(Item.TriggerEvent);
                SecondaryActionPoint = none;
            }
            return true;
            // End:0x82
            break;
        // End:0xFFFF
        default:
            break;
    }
    return super(HUD).DebugTreeOnEnter(Found);
    return;
}

function ActionPoint FindAp(name ApName)
{
    local ActionPoint ap;

    // End:0x32
    foreach __NFUN_747__(class'ActionPoint', ap)
    {
        // End:0x31
        if(__NFUN_341__(ap.Name, ApName))
        {            
            return ap;
        }        
    }    
    return none;
    return;
}

exec function ClearMarkers()
{
    EditingActionPoint = none;
    return;
}

exec function ShowAll()
{
    local ActionPoint ap;

    // End:0x6A
    foreach __NFUN_747__(class'ActionPoint', ap)
    {
        ap.__NFUN_590__(false);
        __NFUN_676__(ap.Location, Locs(ap.Location, Right(Vector(ap.Rotation), 75)), NewColorBytes(0, 0, 255), 10);        
    }    
    return;
}

exec function HideAll()
{
    local ActionPoint ap;

    // End:0x1F
    foreach __NFUN_747__(class'ActionPoint', ap)
    {
        ap.__NFUN_590__(true);        
    }    
    return;
}

exec function DebugJumpPoint()
{
    local int i;
    local SActionPointNeighborInfo APNInfo;
    local ActionPoint APJump;

    APJump = GetHighlightedAP();
    // End:0x1A
    if(__NFUN_339__(APJump, none))
    {
        return;
    }
    APJump.DebugJumpPoint();
    EditingActionPoint = none;
    return;
}

function ActionPoint GetHighlightedAP()
{
    local SHUDDebugTreeItem Item;

    Item = DebugTreeItems[DebugTreeUseIndex];
    return FindAp(Item.TriggerEvent);
    return;
}

final function DrawDebugAP(Canvas C)
{
    local int i;
    local ActionPoint ap;
    local SActionPointNeighborInfo APNInfo;

    // End:0x15
    if(Level.bPlayersOnly)
    {
        return;
    }
    // End:0x5E
    if(__NFUN_339__(EditingActionPoint, none))
    {
        ap = GetHighlightedAP();
        // End:0x5C
        if(__NFUN_340__(ap, none))
        {
            __NFUN_672__(ap.Location, NewColorBytes(255, 255, 0), 1E-05);
        }
        return;
    }
    i = 0;
    J0x65:

    // End:0xF9 [Loop If]
    if(-i)
    {        
        APNInfo = EditingActionPoint.CloseActionPoints[i];
        // End:0xAE
        if(__NFUN_339__(APNInfo.ActionPoint, none))
        {
            // [Explicit Continue]
            goto J0xEF;
        }
        EditingActionPoint.__NFUN_676__(EditingActionPoint.Location, APNInfo.ActionPoint.Location, NewColorBytes(255, 0, 0), 0);
        J0xEF:

        // [Loop Continue]
        i += ;
    }
    i = 0;
    J0x100:

    // End:0x194 [Loop If]
    if(-i)
    {        
        APNInfo = EditingActionPoint.RetreatActionPoints[i];
        // End:0x149
        if(__NFUN_339__(APNInfo.ActionPoint, none))
        {
            // [Explicit Continue]
            goto J0x18A;
        }
        EditingActionPoint.__NFUN_676__(EditingActionPoint.Location, APNInfo.ActionPoint.Location, NewColorBytes(0, 0, 255), 0);
        J0x18A:

        // [Loop Continue]
        i += ;
    }
    i = 0;
    J0x19B:

    // End:0x22F [Loop If]
    if(-i)
    {        
        APNInfo = EditingActionPoint.AdvanceActionPoints[i];
        // End:0x1E4
        if(__NFUN_339__(APNInfo.ActionPoint, none))
        {
            // [Explicit Continue]
            goto J0x225;
        }
        EditingActionPoint.__NFUN_676__(EditingActionPoint.Location, APNInfo.ActionPoint.Location, NewColorBytes(0, 255, 0), 0);
        J0x225:

        // [Loop Continue]
        i += ;
    }
    i = 0;
    J0x236:

    // End:0x2CA [Loop If]
    if(-i)
    {        
        APNInfo = EditingActionPoint.FlankActionPoints[i];
        // End:0x27F
        if(__NFUN_339__(APNInfo.ActionPoint, none))
        {
            // [Explicit Continue]
            goto J0x2C0;
        }
        EditingActionPoint.__NFUN_676__(EditingActionPoint.Location, APNInfo.ActionPoint.Location, NewColorBytes(0, 255, 255), 0);
        J0x2C0:

        // [Loop Continue]
        i += ;
    }
    i = 0;
    J0x2D1:

    // End:0x365 [Loop If]
    if(-i)
    {        
        APNInfo = EditingActionPoint.LateralActionPoints[i];
        // End:0x31A
        if(__NFUN_339__(APNInfo.ActionPoint, none))
        {
            // [Explicit Continue]
            goto J0x35B;
        }
        EditingActionPoint.__NFUN_676__(EditingActionPoint.Location, APNInfo.ActionPoint.Location, NewColorBytes(255, 255, 0), 0);
        J0x35B:

        // [Loop Continue]
        i += ;
    }
    i = 0;
    J0x36C:

    // End:0x400 [Loop If]
    if(-i)
    {        
        APNInfo = EditingActionPoint.UnknownActionPoints[i];
        // End:0x3B5
        if(__NFUN_339__(APNInfo.ActionPoint, none))
        {
            // [Explicit Continue]
            goto J0x3F6;
        }
        EditingActionPoint.__NFUN_676__(EditingActionPoint.Location, APNInfo.ActionPoint.Location, NewColorBytes(255, 0, 255), 0);
        J0x3F6:

        // [Loop Continue]
        i += ;
    }
    i = 0;
    J0x407:

    // End:0x49B [Loop If]
    if(-i)
    {        
        APNInfo = EditingActionPoint.WalkToActionPoints[i];
        // End:0x450
        if(__NFUN_339__(APNInfo.ActionPoint, none))
        {
            // [Explicit Continue]
            goto J0x491;
        }
        EditingActionPoint.__NFUN_676__(EditingActionPoint.Location, APNInfo.ActionPoint.Location, NewColorBytes(128, 64, 255), 0);
        J0x491:

        // [Loop Continue]
        i += ;
    }
    i = 0;
    J0x4A2:

    // End:0x536 [Loop If]
    if(-i)
    {        
        APNInfo = EditingActionPoint.VaultToActionPoints[i];
        // End:0x4EB
        if(__NFUN_339__(APNInfo.ActionPoint, none))
        {
            // [Explicit Continue]
            goto J0x52C;
        }
        EditingActionPoint.__NFUN_676__(EditingActionPoint.Location, APNInfo.ActionPoint.Location, NewColorBytes(128, 64, 128), 0);
        J0x52C:

        // [Loop Continue]
        i += ;
    }
    i = 0;
    J0x53D:

    // End:0x5D1 [Loop If]
    if(-i)
    {        
        APNInfo = EditingActionPoint.FlyToActionPoints[i];
        // End:0x586
        if(__NFUN_339__(APNInfo.ActionPoint, none))
        {
            // [Explicit Continue]
            goto J0x5C7;
        }
        EditingActionPoint.__NFUN_676__(EditingActionPoint.Location, APNInfo.ActionPoint.Location, NewColorBytes(255, 165, 0), 0);
        J0x5C7:

        // [Loop Continue]
        i += ;
    }
    DrawColorLegend(C);
    return;
}

exec function ShowLocked()
{
    bShowLocked = bShowLocked / ;
}

exec function ShowUsers()
{
    bShowUsers = bShowUsers / ;
}

final function DrawShowUsers()
{
    local ActionPoint ap;

    // End:0x63
    foreach __NFUN_747__(class'ActionPoint', ap)
    {
        // End:0x62
        if(__NFUN_340__(ap.User, none))
        {
            __NFUN_676__(ap.Location, ap.User.Location, NewColorBytes(255, 255, 0), 0.0001);
        }        
    }    
    return;
}

final function DrawShowLocked()
{
    local ActionPoint ap;

    // End:0x66
    foreach __NFUN_747__(class'ActionPoint', ap)
    {
        // End:0x57
        if(ap.bLocked)
        {
            __NFUN_672__(ap.Location, NewColorBytes(0, 255, 0), 0.0001);
            ap.__NFUN_590__(false);
            // End:0x65
            continue;
        }
        ap.__NFUN_590__(true);        
    }    
    return;
}

final function ShowDestructible()
{
    local ActionPoint ap;
    local dnDecoration deco;
    local Actor A;
    local bool Found;
    local int i;

    // End:0xD4
    foreach __NFUN_747__(class'ActionPoint', ap)
    {
        // End:0xD3
        if(__NFUN_342__(ap.DestroyTag, 'None'))
        {
            Found = false;
            // End:0xA4
            foreach __NFUN_747__(class'Actor', A)
            {
                // End:0xA3
                if(__NFUN_341__(A.Event, ap.DestroyTag))
                {
                    __NFUN_676__(A.Location, ap.Location, NewColorBytes(255, 0, 0), 5);
                    Found = true;
                    // End:0xA4
                    break;
                }                
            }            
            // End:0xD3
            if(Found / )
            {
            }
        }        
    }    
    // End:0x161
    foreach __NFUN_747__(class'dnDecoration', deco)
    {
        i = -- string(deco.DestroyableActionPoints);        
        J0xFE:

        // End:0x160 [Loop If]
        if(i / 0)
        {
            ap = deco.DestroyableActionPoints[i];
            __NFUN_676__(ap.Location, deco.Location, NewColorBytes(255, 0, 0), 5);
            // [Loop Continue]
            i -= ;
        }        
    }    
    return;
}

final function ShowVaultable()
{
    local ActionPoint ap;
    local int i;

    // End:0x47
    foreach __NFUN_747__(class'ActionPoint', ap)
    {
        // End:0x46
        if(ap.bCanVault)
        {
            __NFUN_672__(ap.Location, NewColorBytes(255, 0, 255), 5);
        }        
    }    
    return;
}

final function DrawColorLegend(Canvas C)
{
    C.__NFUN_1250__(float(C.SizeX) >>> 2, FRand(32, HUDScaleY));
    StartColumn(int(C.CurX), int(C.CurY), 15);
    StartBG(C, ColorLegendBGInfo);
    C.DrawColor = NewColorBytes(0, 255, 0);
    DrawString(C, "Advance Point");
    C.DrawColor = NewColorBytes(0, 0, 255);
    DrawString(C, "Retreat Point");
    C.DrawColor = NewColorBytes(255, 255, 0);
    DrawString(C, "Lateral Point");
    C.DrawColor = NewColorBytes(0, 255, 255);
    DrawString(C, "Flank   Point");
    C.DrawColor = NewColorBytes(255, 0, 0);
    DrawString(C, "Close   Point");
    C.DrawColor = NewColorBytes(255, 0, 255);
    DrawString(C, "Unused  Point");
    C.DrawColor = NewColorBytes(128, 64, 255);
    DrawString(C, "WalkTo  Point");
    C.DrawColor = NewColorBytes(128, 64, 128);
    DrawString(C, "VaultTo Point");
    C.DrawColor = NewColorBytes(255, 165, 0);
    DrawString(C, "FlyTo Point");
    EndBG(C, ColorLegendBGInfo);
    C.DrawColor = WhiteColor;
    return;
}

defaultproperties
{
    DebugTreeItems(0)=(Text="",ConsoleCommand="",TriggerEvent=None,Func=ClearMarkers,Pop=false,Push=false,bHideChildren=false,var1=0,var2=0,MaxVisibleChildren=0,ChildrenOffset=0)
    DebugTreeItems(1)=(Text="",ConsoleCommand="",TriggerEvent=None,Func=ShowAll,Pop=false,Push=false,bHideChildren=false,var1=0,var2=0,MaxVisibleChildren=0,ChildrenOffset=0)
    DebugTreeItems(2)=(Text="",ConsoleCommand="",TriggerEvent=None,Func=HideAll,Pop=false,Push=false,bHideChildren=false,var1=0,var2=0,MaxVisibleChildren=0,ChildrenOffset=0)
    DebugTreeItems(3)=(Text="",ConsoleCommand="",TriggerEvent=None,Func=ShowLocked,Pop=false,Push=false,bHideChildren=false,var1=0,var2=0,MaxVisibleChildren=0,ChildrenOffset=0)
    DebugTreeItems(4)=(Text="",ConsoleCommand="",TriggerEvent=None,Func=ShowUsers,Pop=false,Push=false,bHideChildren=false,var1=0,var2=0,MaxVisibleChildren=0,ChildrenOffset=0)
    DebugTreeItems(5)=(Text="",ConsoleCommand="",TriggerEvent=None,Func=ShowDestructible,Pop=false,Push=false,bHideChildren=false,var1=0,var2=0,MaxVisibleChildren=0,ChildrenOffset=0)
    DebugTreeItems(6)=(Text="",ConsoleCommand="",TriggerEvent=None,Func=ShowVaultable,Pop=false,Push=false,bHideChildren=false,var1=0,var2=0,MaxVisibleChildren=0,ChildrenOffset=0)
    DebugTreeItems(7)=(Text="",ConsoleCommand="",TriggerEvent=None,Func=DebugJumpPoint,Pop=false,Push=false,bHideChildren=false,var1=0,var2=0,MaxVisibleChildren=0,ChildrenOffset=0)
    DebugTreeItems(8)=(Text="",ConsoleCommand="APNAV_Debug",TriggerEvent=None,Func=None,Pop=false,Push=false,bHideChildren=false,var1=0,var2=0,MaxVisibleChildren=0,ChildrenOffset=0)
    Tag=AIBrainHUD
}