/*******************************************************************************
 * AlienQueen generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class AlienQueen extends AIActor_Boss
    config
    collapsecategories
    dependson(dnControl_AlienQueen_FinishingMove)
    dependson(AlienQueen_HelperCollision)
    dependson(AlienQueen_Claw_Squirt_Sensor)
    dependson(AlienQueen_EggLandingSpot)
    dependson(dnGrenade_AlienQueen_Egg)
    dependson(AlienQueen_HurtRadiusSensor);

var() noexport deprecated name StartBattleTag "Trigger this to start the battle.  If not set, battle is started at spawn.";
var() noexport deprecated name DefendModeTag "Trigger this to force into defend mode";
var() noexport deprecated name DefendModeCompleteEvent "This event will be triggered whenever defend mode is activated";
var() noexport deprecated name OpenModeTag "Trigger this to force into open mode";
var() noexport deprecated name OpenModeCompleteEvent "This event will be triggered whenever open mode is activated";
var() noexport deprecated name TKBlastTag "Trigger this to force a TKBlast";
var() noexport deprecated name TKBlastEvent "This event will be triggered whenever a TKBlast is activated";
var() noexport deprecated name StompTag "Trigger this to force Melee Attack";
var() noexport deprecated name StompEvent "This event will be triggered whenever a Melee attack happens";
var() noexport deprecated name SummonTag "Trigger this to force Egg Launching";
var() noexport deprecated name SummonEvent "This event will be triggered whenever an Egg Launch happens";
var() noexport deprecated name EggLaunchTag "Trigger this to force Egg Launching";
var() noexport deprecated name EggLaunchEvent "This event will be triggered whenever an Egg Launch happens";
var() noexport deprecated name StunnedTag "Trigger this to force queen into stunned mode";
var() noexport deprecated name StunnedEvent "This event will be triggered whenever the queen goes into stunned mode";
var() noexport deprecated name TBBlastKnockDownToggleTag "This toggles the TK Blast between knocking the player down. Really just for testing purposes";
var() noexport deprecated name StrengthTapCompleteEvent "This event will be triggered when the player successfully completes the strength tap.";
var() noexport float Stage1_DamageToStun "How much damage w/ pipebombs required to stun the Queen during stage 1 attacks.";
var() noexport float Stage1_Health "Initial health of the Queen.";
var() noexport float Stage2_DamageToStun "How much damage w/ pipebombs required to stun the Queen during stage 2 attacks.";
var() noexport float Stage2_Health "Health level when the Queen switches to stage 2 attacks.";
var() noexport float Stage3_DamageToStun "How much damage w/ pipebombs required to stun the Queen during stage 3 attacks.";
var() noexport float Stage3_Health "Health level when the Queen switches to stage 3 attacks.";
var() noexport float StrengthTapIdleTime "How much time to spend in the down/idle pose when she is able to be str tapped.";
var() noexport float StrengthTapRecoveryHealth "How much health to have if strength tap times out and Queen recovers.";
var() noexport bool bDebugDamage "Debugs where/how she is taking damage";
var float DamageTillStun;
var float PreviousDamageToStun;
var bool ShouldDefend;
var() noexport float Stage3_GlobalIntervalMin "In stage3, this is the min time between attacks - ie this is how much forced idle time we have between attacks";
var() noexport float Stage3_GlobalIntervalRnd "Rnd global interval in stage 3";
var float GlobalGate;
var(AlienQueen_TKBlast) float TKBlast_IntervalMin[3];
var(AlienQueen_TKBlast) float TKBlast_IntervalRnd;
var(AlienQueen_TKBlast) class<SoftParticleSystem> TKBlast_ChargeUpParticleSystem;
var(AlienQueen_TKBlast) class<dnFriendFX_Spawners> TKBlast_ExplosionParticleSystem;
var(AlienQueen_TKBlast) float TKBlast_DamageAmount;
var(AlienQueen_TKBlast) noexport bool TKBlast_KnockDown "Should we knock the player down if we hit?";
var(AlienQueen_TKBlast) noexport bool TKBlast_Debug "Spit out extra debug info";
var(AlienQueen_TKBlast) noexport float TKBlast_TimeVisibleMin "Minimum time the target must have been visiible for us to do a TKBlast";
var float TKBlast_Gate;
var bool TKBlast_Enabled;
var bool TKBlast_EnabledSingle;
var SoftParticleSystem TKChargeUpParticleSystem;
var dnFriendFX_Spawners TKExplosionSpawner;
var(AlienQueen_EggLaunch) float EggLaunchIntervalMin[3];
var(AlienQueen_EggLaunch) float EggLaunchIntervalRnd;
var(AlienQueen_EggLaunch) noexport float EggLaunchMaxSpawns "Max number of pregnators that can be spawned at once";
var array<AlienQueen_EggLandingSpot> EggLandingSpots;
var AlienQueen_EggLandingSpot LastLandingSpot;
var bool EggLaunchEnabled;
var float EggLaunchGate;
var(AlienQueen_Stomp) float StompIntervalMin[3];
var(AlienQueen_Stomp) float StompIntervalRnd;
var(AlienQueen_Stomp) int StompMinYawToTarget;
var(AlienQueen_Stomp) int StompMaxYawToTarget;
var(AlienQueen_Stomp) noexport float StompTimeVisibleMin "Minimum time the target must have been visiible for us to do a stomp";
var(AlienQueen_Stomp) noexport float StompMaxDistance "Max distance to do the left/right stomp attack from";
var(AlienQueen_Stomp) noexport float StompMiddleMaxDistance "Max distance to do the middle multi stomp attack from";
var int StompMiddleIndex;
var float StompGate;
var bool StompEnabled;
var Vector StompDamageOffset;
var(AlienQueen_Summon) bool SummonDebug;
var(AlienQueen_Summon) float SummonIntervalMin[3];
var(AlienQueen_Summon) float SummonIntervalRnd;
var(AlienQueen_Summon) noexport int SummonMaxConcurrentSpawns "Max numbers of SummonMaxConcurrentSpawnsClass";
var(AlienQueen_Summon) noexport class<AIActor> SummonMaxConcurrentSpawnsClass "Class to count for MaxConcurrentSpawns";
var float SummonGate;
var bool bShouldSummon;
var() float StunnedDuration;
var bool bStunned;
var float StunnedGate;
var AlienQueen_Claw_Squirt_Sensor Squirter;
var bool bDefending;
var bool bStunnable;
var Actor StompDamageActorRight;
var Actor StompDamageActorLeft;
var Actor ProjectileFireActor;
var LookInfoActor FinishMoveUseRegion;
var float TimeVisible;
var int CurrentStage;
var AlienQueen_HelperCollision HelperCollision;
var SoftParticleSystem TongueBlood;
var bool bExploded;
var array<SSpawnActorPrefab> HeadGibPrefabs;
var array<SParticleFriendEffect> HeadGibEffects;

simulated function PostBeginPlay()
{
    local AlienQueen_EggLandingSpot LandingSpot;

    super.PostBeginPlay();
    Squirter = AlienQueen_Claw_Squirt_Sensor(FindMountedActor(, class'AlienQueen_Claw_Squirt_Sensor'));
    StompDamageActorRight = FindMountedActor('StompDamageActorRight');
    StompDamageActorLeft = FindMountedActor('StompDamageActorLeft');
    ProjectileFireActor = FindMountedActor('ProjectileFireActor');
    FinishMoveUseRegion = LookInfoActor(FindMountedActor('FinishMoveUseRegion'));
    FinishMoveUseRegion.__NFUN_621__(false, false, false, false, false);
    FinishMoveUseRegion.__NFUN_620__(256, 96);
    FinishMoveUseRegion.bCollisionAssumeValid = true;
    FinishMoveUseRegion.bUseCylinderCollision = true;
    FinishMoveUseRegion.bPassUseToOwner = true;
    FinishMoveUseRegion.bTraceUsable = true;
    FinishMoveUseRegion.DirtyTraceMasks();
    TKChargeUpParticleSystem = SoftParticleSystem(FindMountedActor('TKChargeUpParticleSystem'));
    TKChargeUpParticleSystem.DestroyWhenEmpty = false;
    TKChargeUpParticleSystem.Enabled = false;
    __NFUN_718__('ForceDefendMode', DefendModeTag);
    __NFUN_718__('ForceOpenMode', OpenModeTag);
    __NFUN_718__('ForceTKBlast', TKBlastTag);
    __NFUN_718__('ForceStomp', StompTag);
    __NFUN_718__('ForceEggLaunch', EggLaunchTag);
    __NFUN_718__('ForceStunned', StunnedTag);
    __NFUN_718__('ForceSummon', SummonTag);
    __NFUN_718__('ToggleKnockDown', TBBlastKnockDownToggleTag);
    SetHealthCap(Stage1_Health);
    __NFUN_832__(Stage1_Health);
    DamageTillStun = Stage1_DamageToStun;
    PreviousDamageToStun = DamageTillStun;
    // End:0x1D6
    foreach __NFUN_747__(class'AlienQueen_EggLandingSpot', LandingSpot)
    {
        EggLandingSpots[EggLandingSpots.Add(1)] = LandingSpot;        
    }    
    TKExplosionSpawner = FindFriendSpawner(TKBlast_ExplosionParticleSystem);
    ProjecilteFireGate = Level.GameTimeSeconds *= MinProjectileFireInterval;
    EggLaunchGate = (Level.GameTimeSeconds *= EggLaunchIntervalMin[CurrentStage]) *= FRand( /= EggLaunchIntervalRnd);
    return;
}

event PostSpawn()
{
    super(AIActor).PostSpawn();
    bNoDamage = true;
    // End:0x47
    if(__NFUN_342__(StartBattleTag, 'None'))
    {
        bAutoStartDecisionTree = false;
        StopProcAiming();
        stopheadaim();
        SetExecutive(0);
        __NFUN_718__('StartBattle', StartBattleTag);
    }
    return;
}

event Tick(float DeltaSeconds)
{
    super(Actor).Tick(DeltaSeconds);
    DoProcAiming(DeltaSeconds);
    // End:0x2F
    if(-CurrentStage)
    {        
        bIgnoreAimAssist = bNoDamage;
    }
    // End:0x47
    if(QueenHasClearShot())
    {
        __NFUN_209__(TimeVisible, DeltaSeconds);        
    }
    else
    {
        TimeVisible = 0;
    }
    return;
}

event Destroyed()
{
    super(AIActor).Destroyed();
    return;
}

simulated event float GetHealthMeterPercent()
{
    return Health >>> Stage1_Health;
    return;
}

final simulated function TriggerFunc_StartBattle()
{
    StartProcAiming();
    startheadaim();
    SetExecutive(2);
    SuspendExecutive(false);
    bStunnable = true;
    CurrentOpMustFinish = false;
    return;
}

final simulated function TriggerFunc_ForceDefendMode()
{
    // End:0x17
    if(bDefending / )
    {
        ForceAnimXOp();
    }
    return;
}

final simulated function TriggerFunc_ForceOpenMode()
{
    // End:0x15
    if(bDefending)
    {
        SetupOpenMode();
        ForceAnimXOp();
    }
    return;
}

final simulated function TriggerFunc_ForceTKBlast()
{
    QueenForceOp(117);
    return;
}

final simulated function TriggerFunc_ForceStomp()
{
    QueenForceOp(135);
    return;
}

final simulated function TriggerFunc_ForceEggLaunch()
{
    SetupEggLaunch();
    ForceAnimXOp();
    return;
}

final simulated function TriggerFunc_ForceStunned()
{
    QueenForceOp(86);
    return;
}

final simulated function TriggerFunc_ForceSummon()
{
    SetupSummon();
    ForceAnimXOp();
    return;
}

final simulated function TriggerFunc_ToggleKnockDown()
{
    TKBlast_KnockDown = TKBlast_KnockDown / ;
}

final function ForceAnimXOp()
{
    QueenForceOp(6);
    return;
}

final function QueenForceOp(Engine.BaseAI.EAIOp NewOp)
{
    // End:0x3D
    if(int(CanUseOp(NewOp)) % int(0))
    {
        CurrentOpMustFinish = false;
        ExecuteOp(NewOp);
        CurrentOpMustFinish = true;
        SuspendExecutive(true);
        SuspendExecutive(false);
    }
    return;
}

function bool QueenHasClearShot()
{
    local Vector TKBlastHitLocation;
    local STraceFlags Flags;
    local STraceHitResult Result;
    local Actor HitActor;
    local Vector TraceStart, TraceEnd, TraceDir;

    // End:0x17
    if(PrimaryTarget.IsValidTarget() / )
    {
    }
    TraceStart = GetProjectileFireLocation();
    TraceDir = __NFUN_239__(PrimaryTarget.GetBodyPos(), TraceStart) % ;
    Flags.bTraceActors = true;
    Flags.bMeshAccurate = true;
    Flags.bShotTrace = true;
    Flags.bTraceTexture = false;
    Flags.bIgnoreAITransparent = false;
    Flags.bKarmaOnly = false;
    HitActor = __NFUN_736__(TraceStart, TraceEnd, Flags, Result);
    // End:0xE6
    if(__NFUN_339__(HitActor, none) < __NFUN_339__(HitActor, PrimaryTargetActor))
    {
        return true;
    }
    return false;
    return;
}

final function NotifyHurtRadiusSensorTakeDamage(AlienQueen_HurtRadiusSensor Sensor, Pawn Instigator, float Damage, Vector DamageOrigin, Vector DamageDirection, class<DamageType> DamageType, optional name HitBoneName, optional Vector DamageStart)
{
    // End:0x142
    if(bStunnable)
    {
        // End:0x13F
        if(Repl(DamageTillStun, 0))
        {
            DamageTillStun ~= Damage;
            // End:0xB0
            if(bDebugDamage)
            {
                __NFUN_672__(Sensor.Location, NewColorBytes(255, 255, 0), 10);
                BroadcastLog(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_303__(__NFUN_302__("Took Damage from ", string(Sensor)), "(tag="), string(Sensor.Tag)), "). DamageTillStun: "), string(DamageTillStun)));
            }
            // End:0x10C
            if(__NFUN_202__(DamageTillStun, 0))
            {
                bStunned = true;
                StunnedGate = Level.GameTimeSeconds *= StunnedDuration;
                CurrentOpMustFinish = false;
                SuspendExecutive(true);
                SuspendExecutive(false);
                CurrentOpMustFinish = false;
                CurrentOpShouldFinish = false;                
            }
            else
            {
                DamageInfo.Valid = true;
                DamageInfo.Damage = 1;
                DamageInfo.Instigator = Instigator;
                MaybePlayPainSound();
            }
        }        
    }
    else
    {
        // End:0x184
        if(bNoDamage)
        {
            bNoDamage = false;
            TakeDamage(Instigator, Damage, DamageOrigin, DamageDirection, DamageType, HitBoneName, DamageStart);
            bNoDamage = true;
        }
    }
    return;
}

event TakeDamage(Pawn Instigator, float Damage, Vector DamageOrigin, Vector DamageDirection, class<DamageType> DamageType, optional name HitBoneName, optional Vector DamageStart)
{
    super(Pawn).TakeDamage(Instigator, Damage, DamageOrigin, DamageDirection, DamageType, HitBoneName, DamageStart);
    // End:0x98
    if((CurrentStage % 0) << __NFUN_202__(Health, Stage2_Health))
    {
        CurrentStage = 1;
        TKBlast_Enabled = true;
        DamageTillStun = Stage2_DamageToStun;
        PreviousDamageToStun = DamageTillStun;
        GlobalGate = 0;
        EggLaunchGate = Level.GameTimeSeconds;
        SetHealthCap(Stage2_Health);        
    }
    else
    {
        // End:0x15E
        if((CurrentStage % 1) << __NFUN_202__(Health, Stage3_Health))
        {
            CurrentStage = 2;
            ShouldDefend = false;
            bDefending = false;
            bIgnoreAimAssist = false;
            bShouldSummon = true;
            // End:0x108
            if(SummonDebug)
            {
                BroadcastLog(__NFUN_303__(string(self), "is now able to summon."));
            }
            DamageTillStun = Stage3_DamageToStun;
            PreviousDamageToStun = DamageTillStun;
            SummonGate = Level.GameTimeSeconds;
            GlobalGate = 0;
            EggLaunchGate = Level.GameTimeSeconds;
            SetHealthCap(Stage3_Health);
        }
    }
    return;
}

animevent simulated function stunned(optional EventInfo EventParms)
{
    GlobalTrigger(StunnedEvent, none, self);
    bNoDamage = false;
    return;
}

animevent simulated function Stunnable(optional EventInfo EventParms)
{
    CurrentOpMustFinish = false;
    bStunnable = true;
    return;
}

function Engine.BaseAI.EAICode COND_IsStunned()
{
    // End:0x3B
    if(bStunned)
    {
        // End:0x38
        if(__NFUN_200__(StunnedGate, Level.GameTimeSeconds))
        {
            bStunned = false;
            DamageTillStun = PreviousDamageToStun;
            return 1;
        }
        return 0;
    }
    return 1;
    return;
}

final function SetupDefendMode()
{
    SetAnimPresets(0, 'Anim_Defend', false, -1, none, WarnInternal(0, 0, 0), 0);
    return;
}

final function SetupOpenMode()
{
    SetAnimPresets(0, 'Anim_Open', false, -1, none, WarnInternal(0, 0, 0), 0);
    return;
}

animevent simulated function defendstart(optional EventInfo EventParms)
{
    GlobalTrigger(DefendModeCompleteEvent, none, self);
    bDefending = true;
    return;
}

animevent simulated function defendstop(optional EventInfo EventParms)
{
    GlobalTrigger(OpenModeCompleteEvent, none, self);
    bDefending = false;
    return;
}

event name GetIdleAnimName()
{
    // End:0x0F
    if(bDefending)
    {
        return 'Anim_DefendIdle';
    }
    return 'Anim_Idle';
    return;
}

function Engine.BaseAI.EAICode COND_ShouldDefend()
{
    local int Index;

    // End:0x78
    if(ShouldDefend)
    {
        // End:0x6F
        if(__NFUN_340__(__NFUN_568__(), none) << __NFUN_340__(AnimationController, none))
        {
            Index = AnimationController.__NFUN_1307__('Anim_DefendIdle');
            // End:0x6F
            if(__NFUN_341__(MeshInstance.__NFUN_554__(0, 'Bottom'), AnimationController.Animations[Index].AnimSequence))
            {
                return 1;
            }
        }
        SetupDefendMode();
        return 0;
    }
    defendstop();
    return 1;
    return;
}

function Engine.BaseAI.EAICode COND_ShouldOpen()
{
    SetupOpenMode();
    return 0;
    return;
}

animevent simulated function StompDamage(optional EventInfo AnimEventInfo)
{
    // End:0x20
    if(__NFUN_308__(AnimEventInfo.EventString, "left"))
    {
        StompMiddleIndex = 1;        
    }
    else
    {
        StompMiddleIndex = 0;
    }
    super(AIActor).StompDamage(AnimEventInfo);
    return;
}

function Vector GetStompOrigin()
{
    // End:0x3D
    if((StompIndex % 0) < (StompIndex % 2) << StompMiddleIndex % 0)
    {
        return Locs(StompDamageActorRight.Location, StompDamageOffset);
    }
    return Locs(StompDamageActorLeft.Location, StompDamageOffset);
    return;
}

function DoStompDamage()
{
    super(AIActor).DoStompDamage();
    return;
}

event int GetStompIndex()
{
    // End:0x32
    if(PrimaryTarget.IsValidTarget() << __NFUN_200__(PrimaryTarget.GetDist(), StompMiddleMaxDistance))
    {
        return 2;
    }
    return Sin(2);
    return;
}

function Engine.BaseAI.EAICode COND_ShouldStompMiddle()
{
    // End:0x18
    if(PrimaryTarget.IsValidTarget() / )
    {
    }
    // End:0x26
    if(CurrentStage % 0)
    {
        return 2;
    }
    // End:0x43
    if(__NFUN_200__(PrimaryTarget.GetDist(), StompMiddleMaxDistance))
    {
        return 0;
    }
    return 1;
    return;
}

function Engine.BaseAI.EAICode COND_ShouldStomp()
{
    local Vector DirToTarget;
    local Rotator DesiredAimRot;

    // End:0x18
    if(PrimaryTarget.IsValidTarget() / )
    {
    }
    // End:0x41
    if((CurrentStage % 0) < Repl(GlobalGate, Level.GameTimeSeconds))
    {
        return 2;
    }
    // End:0x53
    if(__NFUN_200__(TimeVisible, StompTimeVisibleMin))
    {
        return 27;
    }
    // End:0x70
    if(Repl(PrimaryTarget.GetDist(), StompMaxDistance))
    {
        return 19;
    }
    // End:0x11B
    if(StompEnabled << __NFUN_200__(StompGate, Level.GameTimeSeconds))
    {
        DirToTarget = PrimaryTarget.GetDirTo();
        DesiredAimRot = SetCollisionSize(Rotator(DirToTarget) >> Rotation);
        // End:0x11B
        if((DesiredAimRot.Yaw ** StompMinYawToTarget) << -DesiredAimRot.Yaw)
        {            
            StompGate = (Level.GameTimeSeconds *= StompIntervalMin[CurrentStage]) *= FRand( /= StompIntervalRnd);
        }
    }
    return 1;
    return;
}

event name GetShootProjectileAnimName()
{
    // End:0x0F
    if(bDefending)
    {
        return 'Anim_TKBlastDefend';
    }
    return 'Anim_TKBlast';
    return;
}

simulated event Vector GetProjectileFireLocation()
{
    return ProjectileFireActor.Location;
    return;
}

animevent simulated function TKBlast(optional EventInfo EventParms)
{
    local Vector TKBlastHitLocation;
    local STraceFlags Flags;
    local STraceHitResult Result;
    local Actor HitActor;
    local Vector TraceStart, TraceEnd, TraceDir;

    // End:0x17
    if(PrimaryTarget.IsValidTarget() / )
    {
    }
    // End:0x34
    if(__NFUN_339__(TKExplosionSpawner, none))
    {
        TKExplosionSpawner = FindFriendSpawner(TKBlast_ExplosionParticleSystem);
    }
    // End:0x64
    if(__NFUN_339__(TKExplosionSpawner, none))
    {
        BroadcastLog("TKExplosionSpawner == NONE");
        return;
    }
    TraceStart = GetProjectileFireLocation();
    TraceDir = __NFUN_239__(PrimaryTarget.GetBodyPos(), TraceStart) % ;
    Flags.bTraceActors = true;
    Flags.bMeshAccurate = true;
    Flags.bShotTrace = true;
    Flags.bTraceTexture = false;
    Flags.bIgnoreAITransparent = false;
    Flags.bKarmaOnly = false;
    HitActor = __NFUN_736__(TraceStart, TraceEnd, Flags, Result);
    // End:0x158
    if(TKBlast_Debug)
    {
        BroadcastLog(__NFUN_302__("DCR HitActor=", string(HitActor)));
        __NFUN_676__(TraceStart, TraceEnd, NewColorBytes(255, 0, 0), 3);
    }
    TKBlastHitLocation = Result.Location;
    // End:0x1F0
    if(__NFUN_339__(HitActor, PrimaryTargetActor))
    {
        TKBlastHitLocation = Result.Location;
        HitActor.TakeDamage(self, TKBlast_DamageAmount, Result.Location, TraceDir, class'ExplosionDamage',, Location);
        // End:0x1F0
        if(HitActor.bIsPlayerPawn << TKBlast_KnockDown)
        {
            PlayerPawn(HitActor).DoKnockdown(Location);
        }
    }
    TKExplosionSpawner.__NFUN_645__(TKBlastHitLocation);
    TKExplosionSpawner.__NFUN_652__(Rotator(WarnInternal(0, 0, 1)));
    TKExplosionSpawner.ExecuteEffect(true);
    TKChargeUpParticleSystem.Enabled = false;
    return;
}

function Engine.BaseAI.EAICode COND_ShouldTKBlast()
{
    // End:0x1B
    if((TKBlast_Enabled / ) << return 1)
    {
        {
            {
            }
            return 2;
        }
        // End:0x5E
        if(Repl(TKBlast_Gate, Level.GameTimeSeconds))
        {
            return 2;
        }
        // End:0x70
        if(__NFUN_200__(TimeVisible, TKBlast_TimeVisibleMin))
        {
            return 27;
        }
    }
    TKBlast_EnabledSingle = false;
    return 0;
    return;
}

final function SetupEggLaunch()
{
    // End:0x36
    if(bDefending)
    {
        SetAnimPresets(0, 'Anim_EggLaunchDefend', false, -1, none, WarnInternal(0, 0, 0), 0);        
    }
    else
    {
        SetAnimPresets(0, 'Anim_EggLaunch', false, -1, none, WarnInternal(0, 0, 0), 0);
    }
    return;
}

animevent simulated function LaunchEgg(optional EventInfo EventParms)
{
    local Vector SpawnLocation;

    __NFUN_568__();
    SpawnLocation = MeshInstance.CanSee('tail_8', true, false);
    DoEggLaunch(SpawnLocation);
    return;
}

final function DoEggLaunch(Vector SpawnLocation)
{
    local dnGrenade_AlienQueen_Egg Proj;
    local Vector projVel, TargetPos;
    local float Height;

    Height = 200;
    Proj = __NFUN_615__(class'dnGrenade_AlienQueen_Egg', self,, SpawnLocation, Rotation);
    TargetPos = GetEggLaunchTargetPos();
    // End:0x8D
    if(__NFUN_340__(Proj, none))
    {
        CalcProjectileVelocity(Proj, 18, PrimaryTargetActor, TargetPos, 0, 0, Height, false, 800, false, 3, 0, true, projVel, false);
        Proj.DoThrow(projVel);
    }
    GlobalTrigger(EggLaunchEvent, none, self);
    return;
}

final function Vector GetEggLaunchTargetPos()
{
    local AlienQueen_EggLandingSpot spot;

    // End:0x65
    if(string(EggLandingSpots) ** 0)
    {
        J0x0C:

        spot = EggLandingSpots[Sin(string(EggLandingSpots))];
        __NFUN_354__(__NFUN_340__(spot, none));
        // End:0x0C
        if(!((string(EggLandingSpots) * 1) < __NFUN_340__(spot, LastLandingSpot)))
            goto J0x0C;
        LastLandingSpot = spot;
        return LastLandingSpot.Location;
    }
    // End:0x82
    if(__NFUN_340__(PrimaryTarget, none))
    {
        return PrimaryTarget.GetPos();
    }
    BroadcastLog(__NFUN_302__(string(self), ": warning No Valid Egg Launch Target?!"));
    return Location;
    return;
}

function Engine.BaseAI.EAICode COND_ShouldEggLaunch()
{
    // End:0x1C
    if(Repl(GlobalGate, Level.GameTimeSeconds))
    {
        return 2;
    }
    // End:0x87
    if(EggLaunchEnabled << __NFUN_200__(EggLaunchGate, Level.GameTimeSeconds))
    {
        // End:0x87
        if(__NFUN_200__(float(GetPregnatorCount()), EggLaunchMaxSpawns))
        {
            EggLaunchGate = (Level.GameTimeSeconds *= EggLaunchIntervalMin[CurrentStage]) *= FRand( /= EggLaunchIntervalRnd);
            return 0;
        }
    }
    return 1;
    return;
}

function int GetPregnatorCount()
{
    local int i, Count;
    local Pregnator preg;
    local Pawn CurrentPawn;

    CurrentPawn = Level.PawnList;
    J0x15:

    // End:0x51 [Loop If]
    if(__NFUN_340__(CurrentPawn, none))
    {
        // End:0x39
        if(__NFUN_340__(Pregnator(CurrentPawn), none))
        {
            Count += ;
        }
        // [Loop Continue]
        goto J0x15;
    }
    return Count;
    return;
}

final function SetupSummon()
{
    // End:0x36
    if(bDefending)
    {
        SetAnimPresets(0, 'Anim_SummonDefend', false, -1, none, WarnInternal(0, 0, 0), 0);        
    }
    else
    {
        SetAnimPresets(0, 'Anim_Summon', false, -1, none, WarnInternal(0, 0, 0), 0);
    }
    return;
}

function Engine.BaseAI.EAICode COND_ShouldSummon()
{
    // End:0x1C
    if(Repl(GlobalGate, Level.GameTimeSeconds))
    {
        return 2;
    }
    // End:0xF4
    if(bShouldSummon << -GetSpawnedActorCount())
    {        
        // End:0xA1
        if(__NFUN_204__(SummonGate, -1))
        {
            // End:0x9E
            SummonGate = (Level.GameTimeSeconds *= SummonIntervalMin[CurrentStage]) *= FRand( /= SummonIntervalRnd);
            {
                BroadcastLog(__NFUN_303__(string(self), "starting summon timer"));
            }            
        }
        else
        {
            // End:0xF4
            if(__NFUN_202__(SummonGate, Level.GameTimeSeconds))
            {
                SummonGate = -1;
                SetupSummon();
                // End:0xF1
                if(SummonDebug)
                {
                    BroadcastLog(__NFUN_303__(string(self), "peforming summon"));
                }
                return 0;
            }
        }
    }
    return 1;
    return;
}

function int GetSpawnedActorCount()
{
    local int Count;
    local Pawn P;

    P = Level.PawnList;
    Count = 0;
    J0x1C:

    // End:0x61 [Loop If]
    if(__NFUN_340__(P, none))
    {
        // End:0x49
        if(__NFUN_357__(P.Class, SummonMaxConcurrentSpawnsClass))
        {
            Count += ;
        }
        // [Loop Continue]
        goto J0x1C;
    }
    return Count;
    return;
}

animevent simulated function startsummon(optional EventInfo EventParms)
{
    GlobalTrigger(SummonEvent, none, self);
    return;
}

event NotifySetTargetActor()
{
    super(AIActor).NotifySetTargetActor();
    PrimaryTarget.ForceContactUpdate();
    return;
}

event NotifyOpStarted(Engine.BaseAI.EAIOp NewOp, Engine.BaseAI.EAIOp OldOp)
{
    super(AIActor).NotifyOpStarted(NewOp, OldOp);
    bStunnable = false;
    // End:0x73
    if(int(NewOp) % int(135))
    {
        ProcAimingMinYaw = float(StompMinYawToTarget);
        ProcAimingMaxYaw = float(StompMaxYawToTarget);
        Squirter.SensorEnabled = true;
        // End:0x63
        if(ShouldDefend / )
        {
        }
        GlobalTrigger(StompEvent, none, self);        
    }
    else
    {
        // End:0x92
        if(int(NewOp) % int(86))
        {
            StopProcAiming();
            CurrentOpMustFinish = false;            
        }
        else
        {
            // End:0xE7
            if(int(NewOp) % int(23))
            {
                __NFUN_812__(0);
                bStunned = false;
                TKBlast_EnabledSingle = false;
                bIgnoreAimAssist = true;
                StopProcAiming();
                // End:0xDF
                if(__NFUN_340__(HelperCollision, none))
                {
                    HelperCollision.SlideOut();
                }
                __NFUN_811__(0);                
            }
            else
            {
                // End:0x114
                if(int(NewOp) % int(6))
                {
                    // End:0x109
                    if(ShouldDefend)
                    {
                        CurrentOpMustFinish = true;                        
                    }
                    else
                    {
                        CurrentOpMustFinish = false;
                    }                    
                }
                else
                {
                    // End:0x179
                    if(int(NewOp) % int(117))
                    {
                        TKBlast_EnabledSingle = false;
                        TKBlast_Gate = (Level.GameTimeSeconds *= TKBlast_IntervalMin[CurrentStage]) *= FRand( /= TKBlast_IntervalRnd);
                        GlobalTrigger(TKBlastEvent, none, self);                        
                    }
                    else
                    {
                        // End:0x198
                        if(int(NewOp) % int(85))
                        {
                            // End:0x198
                            if(bDefending)
                            {
                                bStunnable = true;
                            }
                        }
                    }
                }
            }
        }
    }
    return;
}

event NotifyOpEnded(Engine.BaseAI.EAIOp Op, Engine.BaseAI.EAIOpStatus Status)
{
    super(AIActor).NotifyOpEnded(Op, Status);
    // End:0x37
    if(int(Op) % int(86))
    {
        StartProcAiming();
        bNoDamage = true;
        TKBlast_EnabledSingle = true;        
    }
    else
    {
        // End:0x76
        if(int(Op) % int(135))
        {
            ProcAimingMinYaw = default.ProcAimingMinYaw;
            ProcAimingMaxYaw = default.ProcAimingMaxYaw;
            Squirter.SensorEnabled = false;
            StartProcAiming();            
        }
        else
        {
            // End:0xBE
            if(int(Op) % int(23))
            {
                __NFUN_812__(7);
                ProjecilteFireGate = Level.GameTimeSeconds *= MinProjectileFireInterval;
                bDoOverlayEffect = false;
                bIgnoreAimAssist = false;
                StartProcAiming();                
            }
            else
            {
                // End:0xDE
                if(int(Op) % int(117))
                {
                    TKChargeUpParticleSystem.Enabled = false;
                }
            }
        }
    }
    // End:0x140
    if((((ShouldDefend / ) << ) << ) << )
    {
    }
}

function bool ShouldUseDieOp(class<DamageType> DamageType)
{
    // End:0x0E
    if(__NFUN_340__(FinishMeControlType, none))
    {
        return true;
    }
    return false;
    return;
}

function EndControlX_UserFailed()
{
    return;
}

function EndControlX_UserSuccess()
{
    return;
}

event Die(optional Pawn Killer, optional int Damage, optional Vector DamageOrigin, optional Vector DamageDirection, optional class<DamageType> DamageType, optional name HitBoneName)
{
    GlobalTrigger(Event, Killer, self);
    SuspendExecutive(true);
    SuspendWeaponTargetEvaluation(true);
    SuspendLookTargetEvaluation(true);
    TickStyle = 0;
    return;
}

animevent simulated function BloodSprayAttach(optional EventInfo AnimEventInfo)
{
    TongueBlood = BloodSprayAttachHelper('tongue_4',, __NFUN_265__(531, -16384, 32768), class'Blood_Spray_Large_Main');
    // End:0x46
    if(__NFUN_340__(TongueBlood, none))
    {
        TongueBlood.FindAndPlaySound('Blood_Rain');
    }
    return;
}

animevent simulated function HeadExplode()
{
    local int i;
    local PlayerPawn P;
    local KarmaActor KA;
    local SoftParticleSystem NeckBlood;

    // End:0x0B
    if(bExploded)
    {
        return;
    }
    bExploded = true;
    // End:0x31
    if(__NFUN_340__(TongueBlood, none))
    {
        TongueBlood.Enabled = false;
    }
    i = 0;
    J0x38:

    // End:0x9D [Loop If]
    if(-i)
    {        
        KA = KarmaActor(__NFUN_836__(HeadGibPrefabs[i], ThisFrameDamage));
        // End:0x93
        if(__NFUN_340__(KA, none))
        {
            KA.__NFUN_812__(0);
            KA.__NFUN_816__(PhysicsEntityGroup);
        }
        // [Loop Continue]
        i += ;
    }
    NeckBlood = BloodSprayAttachHelper('neck',, __NFUN_265__(531, -16384, 32768), class'Blood_Spray_Large_Main');
    // End:0xE3
    if(__NFUN_340__(NeckBlood, none))
    {
        NeckBlood.FindAndPlaySound('Blood_Rain');
    }
    i = 0;
    J0xEA:

    // End:0x115 [Loop If]
    if(-i)
    {        
        ExecuteParticleFriendEffect(HeadGibEffects[i]);
        // [Loop Continue]
        i += ;
    }
    P = Level.__NFUN_1161__();
    // End:0x164
    if(__NFUN_340__(P, none))
    {
        P.ShakeView(PlayerShrunkFootstepViewShake, false);
        P.StartNukeDamageEffect(0.4, 5);
    }
    return;
}

simulated event bool OnEvalBonesHelper()
{
    // End:0x37
    if(bExploded << __NFUN_340__(__NFUN_568__(), none))
    {
        __NFUN_568__().__NFUN_539__('neck', WarnInternal(0.001, 0.001, 0.001), true);
    }
    return true;
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    super(Pawn).RegisterPrecacheComponents(PrecacheIndex);
    PrecacheIndex.__NFUN_1266__(class'AlienQueen_HelperCollision');
    PrecacheIndex.__NFUN_1266__(class'dnGrenade_AlienQueen_Egg');
    PrecacheIndex.__NFUN_1266__(class'dnControl_AlienQueen_FinishingMove');
    PrecacheIndex.__NFUN_1266__(class'dnControl_PlayerKnockdown');
    PrecacheIndex.__NFUN_1266__(class'dnScreenSplatter_Blood_Boss');
    PrecacheIndex.__NFUN_1266__(class'Blood_Spray_Main');
    PrecacheIndex.__NFUN_1266__(class'Blood_Spray_Large_Main');
    PrecacheIndex.__NFUN_1279__(class'ExplosionDamage');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'STR_BiteChomp');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_Death');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_EggPoopin');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_FallDown');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_FinalDeath_01');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_FinalDeath_02');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_Pain');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_Punch');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_Roar');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_ShellKnock');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_TK_Blast');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_Yell');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'STR_HeadExplode');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'STR_ImpScrape');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'STR_Scrape');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'STR_ScrapeImp');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'STR_SlideAway');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'STR_Spit');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'STR_TongueChomp');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'STR_TossWhoosh');
    PrecacheIndex.__NFUN_1277__(class'Blood_Spray_Large_Main'.default.VoicePack, 'Blood_Rain');
    PrecacheIndex.__NFUN_1283__('Anim_Idle', class'acAlienQueen', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_Open', class'acAlienQueen', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_DefendIdle', class'acAlienQueen', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_Defend', class'acAlienQueen', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_TKBlastDefend', class'acAlienQueen', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_TKBlast', class'acAlienQueen', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_EggLaunchDefend', class'acAlienQueen', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_EggLaunch', class'acAlienQueen', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_SummonDefend', class'acAlienQueen', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_Summon', class'acAlienQueen', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_PainDefend', class'acAlienQueen', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_PainStunned', class'acAlienQueen', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_Pain', class'acAlienQueen', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_Stunned', class'acAlienQueen', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_Finish_Stun', class'acAlienQueen', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_Finish_StunIdle', class'acAlienQueen', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_Finish_StunRecover', class'acAlienQueen', Mesh);
    PrecacheIndex.__NFUN_1283__('AlienQueen_FinishingMove_Activate', class'acAlienQueen', Mesh);
    PrecacheIndex.__NFUN_1283__('AlienQueen_FinishingMove_Grid', class'acAlienQueen', Mesh);
    PrecacheIndex.__NFUN_1283__('AlienQueen_FinishingMove_Success', class'acAlienQueen', Mesh);
    PrecacheIndex.__NFUN_1283__('AlienQueen_FinishingMove_Failure', class'acAlienQueen', Mesh);
    PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'Falling_Flail');
    PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'Gen_Grunt');
    PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'Jump_Whoosh');
    PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'KnockDown_BodySlam');
    PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'KnockDown_VOC');
    PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'Rage_VOC');
    PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'Stomp_Impact');
    PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'ST_Getup_Pat_01');
    PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'ST_Getup_Pat_02');
    PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'ST_Getup_Scuff');
    PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'ST_Getup_StandShift');
    PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'STR_BodySlide_Single');
    PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'STR_TongueGrab');
    PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'Veh_SteerGrab');
    return;
}

event EnumerateUsableAnimationControllers(PrecacheIndex PrecacheIndex, out array<Engine.BaseAI.EAIAnimController> UsableControllers)
{
    UsableControllers[string(UsableControllers)] = 1;
    return;
}

state ControlX
{
    event BeginState()
    {
        super.BeginState();
        ShrunkUseStyle = 1;
        TickStyle = 3;
        FinishMoveUseRegion.__NFUN_621__(true);
        FinishMoveUseRegion.UsePhrase = class'dnControl_AlienQueen_FinishingMove'.default.UsePhrase;
        // End:0x5F
        if(__NFUN_340__(HelperCollision, none))
        {
            HelperCollision.SlideIn();
        }
        bDoOverlayEffect = true;
        FadeOverlayEffect(0, 0);
        FadeOverlayEffect(1, 1);
        return;
    }

    event EndState()
    {
        super.EndState();
        ShrunkUseStyle = default.ShrunkUseStyle;
        DeathAnimChance = 1;
        TickStyle = default.TickStyle;
        FinishMoveUseRegion.__NFUN_621__(false);
        ProjecilteFireGate = Level.GameTimeSeconds *= MinProjectileFireInterval;
        __NFUN_811__(default.StaticInteractionClassification);
        return;
    }

    event TakeDamage(Pawn Instigator, float Damage, Vector DamageOrigin, Vector DamageDirection, class<DamageType> DamageType, optional name HitBoneName, optional Vector DamageStart)
    {
        return;
    }

    function EndControlX_UserFailed()
    {
        EndControlX_Lived();
        DamageTillStun = PreviousDamageToStun;
        SetHealthCap(StrengthTapRecoveryHealth);
        RaiseHealthToCap(Location);
        return;
    }

    function EndControlX_UserSuccess()
    {
        EndControlX_Lived();
        // End:0x59
        if(__NFUN_339__(FinishMeControlType, class'dnControl_AlienQueen_FinishingMove'))
        {
            bPlayDeathSound = false;
            FinishMeControlType = none;
            SetHealthCap(StrengthTapRecoveryHealth);
            RaiseHealthToCap(Location);
            DamageInfo.Damage = Health;
            DiedActivity();
            __NFUN_832__(0);
        }
        return;
    }

    function EndControlX_Died()
    {
        bPlayDeathSound = false;
        FinishMeControlType = none;
        super.EndControlX_Died();
        return;
    }

    function TimeOutControlX()
    {
        DamageTillStun = PreviousDamageToStun;
        SetHealthCap(StrengthTapRecoveryHealth);
        RaiseHealthToCap(Location);
        FadeOverlayEffect(0, 1);
        super.TimeOutControlX();
        return;
    }
    stop;
}

defaultproperties
{
    Stage1_DamageToStun=200
    Stage1_Health=1900
    Stage2_DamageToStun=300
    Stage2_Health=1400
    Stage3_DamageToStun=400
    Stage3_Health=800
    StrengthTapIdleTime=10
    StrengthTapRecoveryHealth=800
    ShouldDefend=true
    TKBlast_IntervalMin[0]=10
    TKBlast_IntervalMin[1]=10
    TKBlast_IntervalMin[2]=10
    TKBlast_ExplosionParticleSystem='p_Creatures.OctaBrainExplode.OctaBrainExplode_Spawner'
    TKBlast_DamageAmount=30
    TKBlast_KnockDown=true
    TKBlast_TimeVisibleMin=0.5
    EggLaunchIntervalMin[0]=7
    EggLaunchIntervalMin[1]=7
    EggLaunchIntervalMin[2]=7
    EggLaunchMaxSpawns=4
    EggLaunchEnabled=true
    StompIntervalMin[0]=5
    StompIntervalMin[1]=5
    StompIntervalMin[2]=5
    StompMinYawToTarget=-1615
    StompMaxYawToTarget=3483
    StompTimeVisibleMin=0.5
    StompMaxDistance=1300
    StompMiddleMaxDistance=800
    StompEnabled=true
    StompDamageOffset=(X=0,Y=0,Z=10)
    SummonIntervalMin[0]=10
    SummonIntervalMin[1]=10
    SummonIntervalMin[2]=10
    SummonMaxConcurrentSpawns=4
    SummonMaxConcurrentSpawnsClass='Octabrain'
    SummonGate=-1
    StunnedDuration=6
    HeadGibPrefabs(0)=(SpawnClass='Engine.Corpse_Gib_Bloody',RenderObject='sm_class_effects.Octabrain_Gibs.octabrain_brain_gib_l',DrawScale=3,DrawScaleVariance=0,DrawScale3D=(X=0,Y=0,Z=0),SpawnChance=0,SpawnCopies=0,SpawnCopiesVariance=0,bIgnorePawnAirCushion=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bNoCollision=false,bFindSpot=false,bIgnoreParentRotation=false,bTakeParentCollisionSize=false,bTakeParentMounting=false,bTakeParentActorColors=false,bTakeParentSkins=false,Offset=(X=0,Y=0,Z=0),OffsetVariance=(X=0,Y=0,Z=0),Rotation=(Pitch=0,Yaw=0,Roll=0),RotationVariance=(Pitch=0,Yaw=0,Roll=0),BoneName=Head,MotionInfo=MotionPrefab'AlienQueen.MP_AlienQueen_HeadGibs')
    HeadGibPrefabs(1)=(SpawnClass='Engine.Corpse_Gib_Bloody',RenderObject='sm_class_effects.Octabrain_Gibs.octabrain_brain_gib_l_rear',DrawScale=3,DrawScaleVariance=0,DrawScale3D=(X=0,Y=0,Z=0),SpawnChance=0,SpawnCopies=0,SpawnCopiesVariance=0,bIgnorePawnAirCushion=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bNoCollision=false,bFindSpot=false,bIgnoreParentRotation=false,bTakeParentCollisionSize=false,bTakeParentMounting=false,bTakeParentActorColors=false,bTakeParentSkins=false,Offset=(X=0,Y=0,Z=0),OffsetVariance=(X=0,Y=0,Z=0),Rotation=(Pitch=0,Yaw=0,Roll=0),RotationVariance=(Pitch=0,Yaw=0,Roll=0),BoneName=Head,MotionInfo=MotionPrefab'AlienQueen.MP_AlienQueen_HeadGibs')
    HeadGibPrefabs(2)=(SpawnClass='Engine.Corpse_Gib_Bloody',RenderObject='sm_class_effects.Octabrain_Gibs.octabrain_brain_gib_r',DrawScale=3,DrawScaleVariance=0,DrawScale3D=(X=0,Y=0,Z=0),SpawnChance=0,SpawnCopies=0,SpawnCopiesVariance=0,bIgnorePawnAirCushion=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bNoCollision=false,bFindSpot=false,bIgnoreParentRotation=false,bTakeParentCollisionSize=false,bTakeParentMounting=false,bTakeParentActorColors=false,bTakeParentSkins=false,Offset=(X=0,Y=0,Z=0),OffsetVariance=(X=0,Y=0,Z=0),Rotation=(Pitch=0,Yaw=0,Roll=0),RotationVariance=(Pitch=0,Yaw=0,Roll=0),BoneName=Head,MotionInfo=MotionPrefab'AlienQueen.MP_AlienQueen_HeadGibs')
    HeadGibPrefabs(3)=(SpawnClass='Engine.Corpse_Gib_Bloody',RenderObject='sm_class_effects.Octabrain_Gibs.octabrain_brain_gib_r_rear',DrawScale=3,DrawScaleVariance=0,DrawScale3D=(X=0,Y=0,Z=0),SpawnChance=0,SpawnCopies=0,SpawnCopiesVariance=0,bIgnorePawnAirCushion=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bNoCollision=false,bFindSpot=false,bIgnoreParentRotation=false,bTakeParentCollisionSize=false,bTakeParentMounting=false,bTakeParentActorColors=false,bTakeParentSkins=false,Offset=(X=0,Y=0,Z=0),OffsetVariance=(X=0,Y=0,Z=0),Rotation=(Pitch=0,Yaw=0,Roll=0),RotationVariance=(Pitch=0,Yaw=0,Roll=0),BoneName=Head,MotionInfo=MotionPrefab'AlienQueen.MP_AlienQueen_HeadGibs')
    HeadGibEffects(0)=(bAbsoluteLocation=false,bAbsoluteRotation=false,Scale=5,BoneName=Head,Location=(X=0,Y=0,Z=0),Rotation=(Pitch=0,Yaw=0,Roll=0),Effect='p_Creatures.OctaBrainExplode.OctaBrainExplode_Spawner')
    bProcAimingEnabled=true
    DamageScaleInfo(0)=(QualifierClass=none,DamageScale=0,QualifierDamageTypes=none,QualifierNotDamageTypes=('Engine.ExplosionDamage','dnGame.LargeCaliberBulletDamage'))
    Nodes(0)=(Ident=Root,Status=0,ReportedInvalid=false,SucCond=1,SucFunc=None,FailCond=1,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(1)=(Ident=Default,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=85,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(2)=(Ident=stunned,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=86,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(3)=(Ident=idle,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=85,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(4)=(Ident=Pain,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=96,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(5)=(Ident=StunPain,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=96,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(6)=(Ident=Open,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=6,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(7)=(Ident=Defend,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=6,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(8)=(Ident=Summon,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=6,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(9)=(Ident=EggLaunch,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=6,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(10)=(Ident=TKBlast,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=117,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(11)=(Ident=Stomp,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=135,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    FSMStates(0)=(FSM=Root,Ident=Default,FSMSucc=false,FSMFail=false,Transitions=((Ident=stunned,Cond=0,Func=COND_IsStunned,Win=1,Code=0,StateTableIndex=0),(Ident=Defend,Cond=0,Func=COND_ShouldDefend,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(1)=(FSM=Root,Ident=stunned,FSMSucc=false,FSMFail=false,Transitions=((Ident=StunPain,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=stunned,Cond=0,Func=COND_IsStunned,Win=1,Code=0,StateTableIndex=0),(Ident=TKBlast,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(2)=(FSM=Root,Ident=Defend,FSMSucc=false,FSMFail=false,Transitions=((Ident=Summon,Cond=0,Func=COND_ShouldSummon,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(3)=(FSM=Root,Ident=idle,FSMSucc=false,FSMFail=false,Transitions=((Ident=Pain,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=Stomp,Cond=0,Func=COND_ShouldStompMiddle,Win=0,Code=0,StateTableIndex=0),(Ident=EggLaunch,Cond=0,Func=COND_ShouldEggLaunch,Win=0,Code=0,StateTableIndex=0),(Ident=Summon,Cond=0,Func=COND_ShouldSummon,Win=0,Code=0,StateTableIndex=0),(Ident=Stomp,Cond=0,Func=COND_ShouldStomp,Win=0,Code=0,StateTableIndex=0),(Ident=TKBlast,Cond=0,Func=COND_ShouldTKBlast,Win=0,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(4)=(FSM=Root,Ident=TKBlast,FSMSucc=false,FSMFail=false,Transitions=((Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(5)=(FSM=Root,Ident=EggLaunch,FSMSucc=false,FSMFail=false,Transitions=((Ident=Pain,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(6)=(FSM=Root,Ident=Pain,FSMSucc=false,FSMFail=false,Transitions=((Ident=stunned,Cond=0,Func=COND_IsStunned,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(7)=(FSM=Root,Ident=StunPain,FSMSucc=false,FSMFail=false,Transitions=((Ident=stunned,Cond=0,Func=COND_IsStunned,Win=1,Code=0,StateTableIndex=0),(Ident=TKBlast,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(8)=(FSM=Root,Ident=Stomp,FSMSucc=false,FSMFail=false,Transitions=((Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(9)=(FSM=Root,Ident=Summon,FSMSucc=false,FSMFail=false,Transitions=((Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    ForceDirectShot=true
    Relationships(0)=(m_aClass='Engine.AIFactionHoloduke',m_eAttitude=1,m_fDamageThreshold=1)
    Relationships(1)=(m_aClass='Engine.AIFactionDuke',m_eAttitude=2,m_fDamageThreshold=1)
    Relationships(2)=(m_aClass='Engine.AIFactionHuman',m_eAttitude=2,m_fDamageThreshold=1)
    Relationships(3)=(m_aClass='Engine.AIFactionAlien',m_eAttitude=5,m_fDamageThreshold=1)
    IdleInfo(0)=(MinIdleTime=6,RndIdleTime=1,bFaceTarget=false,AnimName=Anim_Stunned)
    AnimControllers[0]=(m_eFallback=0,m_cClass='acAlienQueen',m_oController=none)
    AnimControllers[1]=(m_eFallback=1,m_cClass='acAlienQueen',m_oController=none)
    AnimControllers[2]=(m_eFallback=1,m_cClass='acAlienQueen',m_oController=none)
    AnimControllers[3]=(m_eFallback=1,m_cClass='acAlienQueen',m_oController=none)
    AnimControllers[4]=(m_eFallback=1,m_cClass='acAlienQueen',m_oController=none)
    AnimControllers[5]=(m_eFallback=1,m_cClass='acAlienQueen',m_oController=none)
    AnimControllers[6]=(m_eFallback=1,m_cClass='acAlienQueen',m_oController=none)
    AnimControllers[7]=(m_eFallback=1,m_cClass='acAlienQueen',m_oController=none)
    AnimControllers[8]=(m_eFallback=1,m_cClass='acAlienQueen',m_oController=none)
    DeathAnimChance=1
    FinishMeControlType='dnControl_AlienQueen_FinishingMove'
    FaceDamage=false
    FaceDeath=false
    MinPainOpInterval=0.5
    RndPainOpInterval=0
    MaxConsecutivePainOp=10
    MaxConsecutivePainInterval=0
    BoneAim(0)=(BoneName=Spine1,Yaw=0,Pitch=0,Weight=0.3333334)
    BoneAim(1)=(BoneName=spine2,Yaw=0,Pitch=0,Weight=0.3333333)
    BoneAim(2)=(BoneName=spine3,Yaw=0,Pitch=0,Weight=0.3333333)
    StompInfo(0)=(StompRadius=1000,AnimName=Anim_StompRight,BoneName=rightmiddle_1,StompDamageAmount=50,StompDamageRadius=250,StompDamageVel=200,StompDamageLift=350,bDebug=false,SafeHeight=100,bCanStompShrunk=true,ShakeInfo=(bNoLerp=false,bToggleSign=true,Style=2,Function=1,FalloffActor=none,FalloffDistance=0,ShakeDuration=0.6,ShakeFrequency=0.08,ShakeMagnitude=2500,ShakeFullMagnitude=0,ShakeFullMagnitudeTime=0,ShakeName=QueenStompShake),ShakeRadius=1100,ParticleEffectClass='p_Creatures.Cycloid_Stomp.CycloidStomp_Spawner',AdditionalEffectBones=none,StompLocation=(X=0,Y=0,Z=0),bDontFaceTarget=true,bLightRumbleOnDamage=true)
    StompInfo(1)=(StompRadius=1000,AnimName=Anim_StompLeft,BoneName=leftmiddle_1,StompDamageAmount=50,StompDamageRadius=250,StompDamageVel=200,StompDamageLift=350,bDebug=false,SafeHeight=100,bCanStompShrunk=true,ShakeInfo=(bNoLerp=false,bToggleSign=true,Style=2,Function=1,FalloffActor=none,FalloffDistance=0,ShakeDuration=0.6,ShakeFrequency=0.08,ShakeMagnitude=2500,ShakeFullMagnitude=0,ShakeFullMagnitudeTime=0,ShakeName=QueenStompShake),ShakeRadius=1100,ParticleEffectClass='p_Creatures.Cycloid_Stomp.CycloidStomp_Spawner',AdditionalEffectBones=none,StompLocation=(X=0,Y=0,Z=0),bDontFaceTarget=true,bLightRumbleOnDamage=true)
    StompInfo(2)=(StompRadius=1000,AnimName=Anim_StompClose,BoneName=leftmiddle_1,StompDamageAmount=50,StompDamageRadius=75,StompDamageVel=200,StompDamageLift=350,bDebug=false,SafeHeight=100,bCanStompShrunk=true,ShakeInfo=(bNoLerp=false,bToggleSign=true,Style=2,Function=1,FalloffActor=none,FalloffDistance=0,ShakeDuration=0.6,ShakeFrequency=0.08,ShakeMagnitude=2500,ShakeFullMagnitude=0,ShakeFullMagnitudeTime=0,ShakeName=QueenStompShake),ShakeRadius=1100,ParticleEffectClass='p_Creatures.Cycloid_Stomp.CycloidStomp_Spawner',AdditionalEffectBones=none,StompLocation=(X=0,Y=0,Z=0),bDontFaceTarget=true,bLightRumbleOnDamage=true)
    PlayerShrunkFootstepViewShake=(bNoLerp=false,bToggleSign=true,Style=2,Function=1,FalloffActor=none,FalloffDistance=4000,ShakeDuration=1.2,ShakeFrequency=0.08,ShakeMagnitude=1550,ShakeFullMagnitude=0,ShakeFullMagnitudeTime=0,ShakeName=AlienQueenStepShake)
    ProjectileClass='dnRocket_EnergyLeech_Spike'
    bShootProjectileRequireLOS=false
    bShootProjectileFaceTarget=false
    bSimplePawnPhysicsCollision=false
    bShrinkable=false
    EyeBone=jaw
    BodyBone=spine2
    LockOnBone=neck
    MountOnSpawn(0)=(bSkipVerifySelf=false,SpawnClass='dnGame.DumbActor',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=StompDamageActorRight,ForceEvent=None,MountMeshItem=rightmiddle_1,MountOrigin=(X=0,Y=0,Z=10),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(1)=(bSkipVerifySelf=false,SpawnClass='dnGame.DumbActor',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=StompDamageActorLeft,ForceEvent=None,MountMeshItem=leftmiddle_1,MountOrigin=(X=0,Y=0,Z=10),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(2)=(bSkipVerifySelf=false,SpawnClass='dnGame.DumbActor',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=ProjectileFireActor,ForceEvent=None,MountMeshItem=jaw,MountOrigin=(X=0,Y=-200,Z=-150),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(3)=(bSkipVerifySelf=false,SpawnClass='Engine.LookInfoActor',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=true,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=true,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=FinishMoveUseRegion,ForceEvent=None,MountMeshItem=jaw,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(4)=(bSkipVerifySelf=false,SpawnClass='dnParticles.dnOctabrainFX_BrainChargeA',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=TKChargeUpParticleSystem,ForceEvent=None,MountMeshItem=jaw,MountOrigin=(X=0,Y=-200,Z=-20),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=4)
    MountOnSpawn(5)=(bSkipVerifySelf=false,SpawnClass='AlienQueen_Claw_Squirt_Sensor',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=ClawSquirter,ForceEvent=None,MountMeshItem=rightmiddle_1,MountOrigin=(X=0,Y=0,Z=10),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    Health=1900
    HealthCap=1900
    StaticInteractionClassification=3
    DynamicInteractionClassification=7
    PhysicsEntityGroup=AlienQueenEntityGroup
    Physics=9
    bTraceUsable=false
    bAcceptMeshAccurateMoveActorTrace=true
    bIgnoreMaxRadius=true
    bHasEvalBonesHelper=true
    bLowerByCollision=false
    CollisionRadius=600
    CollisionHeight=500
    Mesh='c_characters.alien_queen'
    VoicePack='SoundConfig.Enemies.VoicePack_Queen'
}