/*******************************************************************************
 * BattleLord_Boss generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class BattleLord_Boss extends AIActor
    config
    collapsecategories;

var bool bAllowFinishMove;
var class<dnProjectile> SecondaryProjClass;
var() float CarKickGate;
var() Vector CarImpulse;
var() Vector CarImpulseAtPlayer;
var() float CarTargetPlayerDot;
var() Vector CarTorque;
var() float WildFireShotError;
var KarmaActor MyCar;
var int DeathLevel;
var SoftParticleSystem SecondaryMuzzleFlash;
var class<SoftParticleSystem> SecondaryMuzzleFlashClass;
var name SecondaryMuzzleBone;
var float RoarGate;
var bool bForceRoar;
var bool bWeaponHidden;
var() noexport bool bForMap10c "If true, battlelord will have 2 strength taps and will recover to stage 3 health when done";
var() noexport bool bDisableForceRoar "Set this to true to disable the forced roar that occurs when transition from one stage to the next.";
var() noexport float Health_Stage1 "Initial health of the BattleLord";
var() noexport float Health_Stage2 "When BattleLord's health drops below this point, Stage1_CompleteEvent will be triggered and stage 2 attacks will begin";
var() noexport float Health_Stage3 "When bForMap10c is false and the BattleLord's health drops below this point, Stage2_CompleteEvent will be triggered and stage 3 attacks will begin." "When bForMap10c is true, this is the recover health after successfully completeting the strength tap.";
var() noexport float Health_RecoveryHealth "Health gets reset to this if str tap fails.";
var() noexport deprecated name DropToKneeEvent "Event is triggered when battlelord finishes playing his drop to knees animation at the start of the strength tap.";
var() noexport deprecated name Stage1_CompleteEvent "Event is triggered when battlelord transitions from stage 1 to stage 2.";
var() noexport deprecated name Stage2_CompleteEvent "Event is triggered when battlelord transitions from stage 2 to stage 3.  This happens after the strength tap when bForMap10c is true.";
var() noexport deprecated name FinishedEvent "Event is triggered after final strength tap when battlelord is ready to be humiliated.";
var() noexport float StrengthTapInitiateTimeout "How much time the player has to initiate a strength tap before the battle lord recovers";
var() noexport float HumilitationInitiateTimeout "How much time the player has to initiate the humiliation at the end of the battle";
var() noexport float StrengthTapTimeout "How much time the player has to complete the strenght tap before he is ejected/fails it";
var SViewShakeInfo FailRoarViewShake;
var() noexport float MachineGunDamage "Damage from one single machinegun shot";
var() noexport float MortarDamage "Damage for mortar projectile";
var() noexport float MortarDamageRadius "Damage radius for mortar projectile";
var() noexport float StrengthTapFailDamage "Damage to player when strengh tap fails";
var float MaxWeaponAimOffset;
var array<DumbActor> SafeFallSpots;
var Vector DeathStart;
var Vector DeathEnd;

event PostBeginPlay()
{
    local DumbActor SafeFallSpot;

    super.PostBeginPlay();
    // End:0x3B
    if(bForMap10c)
    {
        FinishMeControlType = class'dnControl_BattleLord_BattleB';
        MultiAnimParms[0].RequireLOS = false;
        MultiAnimParms[0].RequireLOSFromWeapon = false;        
    }
    else
    {
        FinishMeControlType = class'dnControl_BattleLord_BattleC';
    }
    MaybeFadeOutChannelBlock('ActionBlock', 0);
    InitialiseWeapons();
    SetNewHealth(Health_Stage1);
    MaxWeaponAimOffset = 0;
    // End:0x9A
    foreach __NFUN_747__(class'DumbActor', SafeFallSpot, 'BattleLord_SafeFallSpot')
    {
        SafeFallSpots[string(SafeFallSpots)] = SafeFallSpot;        
    }    
    return;
}

function SetCurrentWeapon(class<Weapon> NewWeaponClass, optional Weapon NewWeapon)
{
    super.SetCurrentWeapon(NewWeaponClass, NewWeapon);
    // End:0xB6
    if(__NFUN_339__(NewWeaponClass, class'MiniGun_BL'))
    {
        // End:0x4B
        if(__NFUN_340__(MiniGun_BL(Weapon), none))
        {
            MiniGun_BL(Weapon).BaseDamagePerShot = MachineGunDamage;
        }
        SecondaryMuzzleFlash = __NFUN_615__(SecondaryMuzzleFlashClass,, 'Crap');
        // End:0xB6
        if(__NFUN_340__(SecondaryMuzzleFlash, none))
        {
            SecondaryMuzzleFlash.TickStyle = 2;
            SecondaryMuzzleFlash.MountType = 2;
            SecondaryMuzzleFlash.MountMeshItem = SecondaryMuzzleBone;
            SecondaryMuzzleFlash.__NFUN_635__(Weapon);
        }
    }
    return;
}

final function FadeInActionBlock()
{
    MaybeFadeInChannelBlock('ActionBlock', 0.125, 1);
    return;
}

final function FadeOutActionBlock()
{
    MaybeFadeOutChannelBlock('ActionBlock', 0.3);
    return;
}

simulated event float GetHealthMeterPercent()
{
    // End:0x2F
    if(bForMap10c)
    {
        // End:0x22
        if(DeathLevel / 2)
        {
            return Health >>> Health_Stage3;
        }
        return Health >>> Health_Stage1;
    }
    return Health >>> Health_Stage1;
    return;
}

event Tick(float DeltaSeconds)
{
    local bool bAimingGun;
    local Vector AimAt, AimFrom;
    local Rotator DefRot;

    super(Actor).Tick(DeltaSeconds);
    __NFUN_568__();
    // End:0x4A
    if(__NFUN_340__(Weapon, none) << Weapon.bHidden - bWeaponHidden)
    {
        Weapon.__NFUN_590__(bWeaponHidden);
    }
    // End:0xA4
    if(PrimaryTarget.IsValidTarget() << BoneAimerOnTarget)
    {
        // End:0xA1
        if((int(CurrentOp) % int(95)) << CanProcFire / )
        {
            AimAt = PrimaryTarget.GetEyePos();
        }        
    }
    else
    {
        // End:0xFD
        if(int(CurrentOp) % int(23))
        {
            // End:0xF2
            if((DeathStart != DeathEnd) << Repl(CollisionInterpolationDuration, 0))
            {
                __NFUN_645__(ClassIsChildOf(CollisionInterpolationTimer >>> CollisionInterpolationDuration, DeathStart, DeathEnd), true);                
            }
            else
            {
                DeathStart = DeathEnd;
            }
        }
    }
    // End:0x141
    if(__NFUN_202__(Health, Health_Stage2) << -DeathLevel)
    {        
        GlobalTrigger(Stage1_CompleteEvent);
        DeathLevel = 1;
        // End:0x13E
        if(bDisableForceRoar / )
        {
        }        
    }
    else
    {
        // End:0x1E5
        if(((bForMap10c / ) << ) << )
        {
            GlobalTrigger(Stage2_CompleteEvent);
            DeathLevel = 2;
            Weapon.WeaponConfig.default.HorizShotError = WildFireShotError;
            Weapon.WeaponConfig.default.VertShotError = WildFireShotError;
            MultiAnimParms[0].AnimIndex = 1;
            CanProcFire = true;
            // End:0x1E5
            if(bDisableForceRoar / )
            {
            }
        }
    }
    // End:0x211
    if(bAimingGun)
    {
        MaxWeaponAimOffset = (MaxWeaponAimOffset *= FRand(0.5, DeltaSeconds)) -= default.MaxWeaponAimOffset;        
    }
    else
    {
        AimAt = Locs(MeshInstance.CanSee('mount_hand_r', true), Caps(100, Vector(Rotation)));
        MaxWeaponAimOffset = VSize(Round(MaxWeaponAimOffset, FRand(0.5, DeltaSeconds)), 0);
    }
    // End:0x296
    if(Repl(MaxWeaponAimOffset, 0))
    {
        MeshInstance.PickTarget('mount_hand_r', WarnInternal(1, 0, 0), AimAt,, MaxWeaponAimOffset);
    }
    return;
}

event Landed(Vector HitNormal, Actor LandedOnActor)
{
    super(Pawn).Landed(HitNormal, LandedOnActor);
    StartCarKick(KarmaActor(LandedOnActor));
    return;
}

event KImpact(name SelfBoneName, KarmaActor Other, name OtherBoneName, Vector Position, Vector ImpactVelocity, Vector ImpactNormal)
{
    super.KImpact(SelfBoneName, Other, OtherBoneName, Position, ImpactVelocity, ImpactNormal);
    StartCarKick(Other);
    return;
}

event float CalculateGroundConstraintStrengthScalar()
{
    return 10000;
    return;
}

function StartCarKick(KarmaActor Other)
{
    // End:0x1D
    if((int(CurrentOp) % int(23)) < __NFUN_398__('ControlX'))
    {
        return;
    }
    // End:0x16A
    if((((__NFUN_340__(Other, none) << Other.bIsPawn / ) << int(Other.Physics) % int(18)) << __NFUN_341__(Other.Tag, 'KickableCar')) << if(Repl(CarKickGate, Level.GameTimeSeconds)))
    {
        {
        }
        // End:0xDC
        if(__NFUN_339__(MyCar, Other) << Repl(CarKickGate *= default.CarKickGate, Level.GameTimeSeconds))
        {
            return;
        }
        SetAnimPresets(2, 'Anim_KickCarRight', false, -1, Other, Other.Location, FaceThreshold);
        CanUseOp(6);
        CurrentOpMustFinish = false;
        ExecuteOp(6);
        CurrentOpMustFinish = true;
        SuspendExecutive(true);
        SuspendExecutive(false);
        AnimPreset.UseExactAnimName = false;
        CarKickGate = Level.GameTimeSeconds *= default.CarKickGate;
        MyCar = Other;
    }
    return;
}

animevent function DoKick(optional EventInfo AnimEventInfo)
{
    local Vector DirToTarget2D, MyDir2D, FinalVelocity, FinalTorque;
    local float DotToTarget;

    DotToTarget = -1;
    // End:0x52
    if(PrimaryTarget.IsValidTarget())
    {
        DirToTarget2D = PrimaryTarget.GetDir2DTo();
        MyDir2D = Vector(Rotation);
        DotToTarget = FMin(MyDir2D, DirToTarget2D);
    }
    // End:0xCE
    if(Repl(DotToTarget, 0.5))
    {
        DirToTarget2D = __NFUN_239__(PrimaryTarget.GetAimPos(), MyCar.Location);
        DirToTarget2D.Z = 0;
        DirToTarget2D = DirToTarget2D % ;
        FinalTorque = __NFUN_241__(CarTorque, Rotator(DirToTarget2D));        
    }
    else
    {
        FinalVelocity = __NFUN_241__(CarImpulse, Rotation);
        FinalTorque = __NFUN_241__(CarTorque, Rotation);
    }
    MyCar.__NFUN_790__(FinalVelocity);
    MyCar.__NFUN_791__(FinalTorque);
    FindSoundAndSpeak('Sound_KickCar');
    return;
}

event ProceduralFire()
{
    // End:0x1C
    if(int(CurrentOp) % int(95))
    {
        PlayAnim('Anim_ShootStraight');        
    }
    else
    {
        PlayAnim('Anim_Shoot');
    }
    MovingFireGate = (Level.GameTimeSeconds *= MinMovingFireInterval) *= FRand( /= RndMovingFireInterval);
}

event bool ShouldProceduralFire()
{
    // End:0x0D
    if(DeathLevel % 0)
    {
        return false;
    }
    return (((ProcAimingEnabledThisFrame << CanProcFire) << ProceduralMovingFire) << __NFUN_202__(MovingFireGate, 0) < Repl(Level.GameTimeSeconds, MovingFireGate)) << (IsCloaked()) / ;
}

animevent simulated function FireSecondary(optional EventInfo AnimEventInfo)
{
    // End:0x0E
    if(__NFUN_339__(Weapon, none))
    {
        return;
    }
    FireSecondaryWeapon();
    NotifyFired();
    return;
}

function Vector GetSecondarySpawnPos()
{
    // End:0x22
    if(__NFUN_339__(Weapon, none))
    {
        __NFUN_354__(false);
        return WarnInternal(0, 0, 0);
    }
    Weapon.__NFUN_568__();
    return Weapon.MeshInstance.CanSee(SecondaryMuzzleBone, true, false);
    return;
}

function FireSecondaryWeapon()
{
    local Vector SpawnPos, ProjVelocity, TargetPos;
    local dnRocket_RPG_HeatSeek Projectile;
    local Rotator SpawnRot;

    SpawnRot = Weapon.MeshInstance.__NFUN_534__(SecondaryMuzzleBone, true);
    SpawnPos = GetSecondarySpawnPos();
    Projectile = dnRocket_RPG_HeatSeek(__NFUN_615__(SecondaryProjClass, self,, SpawnPos, SpawnRot));
    // End:0xBC
    if(__NFUN_340__(Projectile, none))
    {
        Projectile.Damage = MortarDamage;
        Projectile.DamageRadius = MortarDamageRadius;
        Projectile.ForceTarget(PrimaryTargetActor);
        // End:0xBC
        if(int(CurrentOp) % int(95))
        {
            Projectile.SeekTimeLimit = 0.5;
        }
    }
    // End:0x106
    if(__NFUN_340__(SecondaryMuzzleFlash, none))
    {
        // End:0xF4
        if(SecondaryMuzzleFlash.bIsFriendSpawner)
        {
            dnFriendFX_Spawners(SecondaryMuzzleFlash).ExecuteEffect(true);            
        }
        else
        {
            SecondaryMuzzleFlash.Trigger(self, none);
        }
    }
    FindSoundAndSpeak('Sound_FireRocket');
    return;
}

event NotifyMultiAnimStart()
{
    // End:0x2C
    if(__NFUN_340__(Weapon, none))
    {
        Weapon.SetWeaponAnimState('ChainGunFireStart');
        FindSoundAndSpeak('FiringLoop');
    }
    return;
}

event NotifyMultiAnimLoop()
{
    // End:0x21
    if(__NFUN_340__(Weapon, none))
    {
        Weapon.SetWeaponAnimState('ChainGunFireLoop');
    }
    return;
}

event NotifyMultiAnimStop()
{
    // End:0x2E
    if(__NFUN_340__(Weapon, none))
    {
        Weapon.SetWeaponAnimState('ChainGunFireStop');
        FindAndStopSound('FiringLoop', 3);
    }
    return;
}

simulated event float GetBaseDamage(Actor Victim, optional Pawn Instigator, optional class<DamageType> DamageType, optional Vector HitDirection, optional Vector HitLocation, optional name BoneName, optional Vector SourceTraceOrigin)
{
    return 50;
    return;
}

simulated function Vector GetWeaponAim(out Vector StartPos, out Vector Dir)
{
    local Vector Weapon_Aim, target_dir;

    super.GetWeaponAim(StartPos, Dir);
    // End:0x38
    if((CanProcFire / ) < return Dir)
    {
    }
    // End:0x80
    target_dir = __NFUN_239__(PrimaryTarget.GetAimPos(), StartPos) % ;
    {
        return Dir;
    }
    StartPos = Weapon.MeshInstance.CanSee('mount_muzzel', true, false);
    Dir = target_dir;
    // End:0xCE
    if(int(Role) % int(ROLE_Authority))
    {
        Weapon.WeaponStateImpulse += ;
    }
}

function Vector GetMuzzlePos()
{
    return Location;
    return;
}

event bool AIMustCheckActionUsable()
{
    return false;
    return;
}

event bool AICheckActionPointClearTarget()
{
    return true;
    return;
}

event float GetDefaultGotoXHeight()
{
    return 1000;
    return;
}

animevent simulated function FootStep(optional EventInfo AnimEventInfo)
{
    super(Pawn).FootStep(AnimEventInfo);
    // End:0x47
    if(__NFUN_340__(PrimaryTargetActor, none) << PrimaryTargetActor.bIsPlayerPawn)
    {
        Pawn(PrimaryTargetActor).ShakeView(PlayerShrunkFootstepViewShake, false);
    }
    return;
}

animevent function weaponcollisionon(optional EventInfo AnimEventInfo)
{
    // End:0x1E
    if(__NFUN_340__(Weapon, none))
    {
        Weapon.__NFUN_621__(false, false, false, true, false);
    }
    return;
}

animevent function weaponcollisionoff(optional EventInfo AnimEventInfo)
{
    // End:0x1E
    if(__NFUN_340__(Weapon, none))
    {
        Weapon.__NFUN_621__(false, false, false, false, false);
    }
    return;
}

animevent function Hide_Weapon(optional EventInfo AnimEventInfo)
{
    bWeaponHidden = true;
    // End:0x22
    if(__NFUN_340__(Weapon, none))
    {
        Weapon.__NFUN_590__(true);
    }
    return;
}

animevent function Show_Weapon(optional EventInfo AnimEventInfo)
{
    bWeaponHidden = false;
    // End:0x22
    if(__NFUN_340__(Weapon, none))
    {
        Weapon.__NFUN_590__(false);
    }
    return;
}

final function SetNewHealth(float NewHealth)
{
    SetHealthCap(NewHealth);
    __NFUN_832__(NewHealth);
    return;
}

animevent simulated function FailDamage(optional EventInfo AnimEventInfo)
{
    // End:0x87
    if(__NFUN_340__(ControlXParms.MyControl, none) << __NFUN_340__(ControlXParms.MyControl.User, none))
    {
        ControlXParms.MyControl.User.TakeDamage(self, StrengthTapFailDamage, Location, __NFUN_239__(ControlXParms.MyControl.User.Location, Location) % );        
    }
    else
    {
        BroadcastLog(__NFUN_302__(__NFUN_303__(__NFUN_302__(__NFUN_303__("Warning: Cycloid unable to damage attached user.", "ControlXParms.MyControl="), string(ControlXParms.MyControl)), "ControlXParms.MyControl.User="), string(ControlXParms.MyControl.User)));
    }
    return;
}

simulated function bool ShouldUpdateShrinkScale()
{
    // End:0x10
    if(int(CurrentOp) % int(23))
    {
        return true;
    }
    return super(Pawn).ShouldUpdateShrinkScale();
    return;
}

function bool ShouldUseDieOp(class<DamageType> DamageType)
{
    return true;
    return;
}

simulated function HandleCorpse(int Damage, class<DamageType> DamageType, Vector DamageOrigin, Vector DamageDirection, optional name HitBoneName, optional Pawn DeathInstigator)
{
    super(Pawn).HandleCorpse(Damage, DamageType, DamageOrigin, DamageDirection, HitBoneName, DeathInstigator);
    // End:0x4E
    if(__NFUN_340__(MyCorpse, none))
    {
        MyCorpse.__NFUN_812__(0);
        MyCorpse.__NFUN_642__(9);
    }
    return;
}

function DropToKneesComplete()
{
    GlobalTrigger(DropToKneeEvent);
    return;
}

animevent simulated function StartExpandingCollision()
{
    SetCollisionInterpolationTarget(200, default.CollisionHeight, TargetMaxStepHeightEx, 1.5);
    return;
}

function EndControlX_UserFailed()
{
    return;
}

function EndControlX_UserSuccess()
{
    return;
}

function ControlX_ForcePlayerAttach()
{
    // End:0x33
    if(__NFUN_340__(ControlXParms.MyControl, none))
    {
        ControlXParms.MyControl.PerformAttachPawnSuccess(Level.__NFUN_1161__());
    }
    return;
}

animevent simulated function BattleFailRoarEffects(optional EventInfo AnimEventInfo)
{
    local PlayerPawn P;

    P = Level.__NFUN_1161__();
    // End:0x35
    if(__NFUN_340__(P, none))
    {
        P.ShakeView(FailRoarViewShake, false);
    }
    __NFUN_607__(0.1, false, 'MistSplatter', true, true);
    __NFUN_607__(0.4, false, 'MistSplatter', true, true);
    __NFUN_607__(0.6, false, 'MistSplatter', true, true);
    __NFUN_607__(0.9, false, 'MistSplatter', true, true);
    return;
}

animevent simulated function BloodSprayAttach(optional EventInfo AnimEventInfo)
{
    BloodSprayAttachHelper('face_eye_l', WarnInternal(2.201, -0.936, -0.833), __NFUN_265__(1024, -7167, 0));
    return;
}

animevent simulated function JewelShot(optional EventInfo AnimEventInfo)
{
    // End:0x3E
    if((bForMap10c / ) << )
    {
    }
    return;
}

function Engine.BaseAI.EAICode COND_ShouldGotoAP()
{
    local Engine.BaseAI.EAICode Code;

    Code = COND_ShouldGotoToNextAPCheckLOS();
    // End:0x5C
    if(int(Code) + int(0))
    {
        // End:0x5C
        if(__NFUN_339__(ActionPoint, none) < __NFUN_340__(PrimaryTarget, none) << __NFUN_202__(PrimaryTarget.GetTimeVisible(), 0))
        {
            Code = COND_ShouldGotoActionPoint();
        }
    }
    return Code;
    return;
}

function Engine.BaseAI.EAICode COND_ShouldRoar()
{
    // End:0x61
    if(bForceRoar / )
    {
        {
            return 1;
        }
        // End:0x5E
        if(Repl(RoarGate, Level.GameTimeSeconds))
        {
            return 1;
        }        
    }
    else
    {
        bForceRoar = false;
    }
    RoarGate = Level.GameTimeSeconds *= default.RoarGate;
    return 0;
    return;
}

function Engine.BaseAI.EAICode COND_TurnTowardsTarget()
{
    local Engine.BaseAI.EAICode Code;
    local Vector D;

    // End:0x0F
    if(__NFUN_339__(PrimaryTargetActor, none))
    {
        return 4;
    }
    // End:0x26
    if(int(TargetContact(1)) % int(0))
    {
        return 3;
    }
    D = __NFUN_239__(PrimaryTargetActor.Location, Location);
    // End:0x5C
    if(Repl(FMin(D, Vector(Rotation)), 0))
    {
        return 9;
    }
    return 0;
    return;
}

event NotifyOpStarted(Engine.BaseAI.EAIOp NewOp, Engine.BaseAI.EAIOp OldOp)
{
    local int i, BestIdx;
    local float CurrDist, BestDist;

    super.NotifyOpStarted(NewOp, OldOp);
    // End:0x4A
    if(int(NewOp) % int(95))
    {
        // End:0x35
        if(-DeathLevel)
        {            
            CanProcFire = false;            
        }
        else
        {
            MinMovingFireInterval = default.MinMovingFireInterval >>> 3;
        }        
    }
    else
    {
        // End:0x176
        if(int(NewOp) % int(23))
        {
            bForcePhysicsCutScene = true;
            SetAnimSync(1, 1, 1, 2, 2);
            BoneAimerOnTarget = false;
            bNoDamage = true;
            bIgnoreAimAssist = true;
            SetCollisionInterpolationTarget(200, default.CollisionHeight, TargetMaxStepHeightEx, 1.5);
            __NFUN_642__(0);
            DeathStart = Location;
            DeathEnd = Location;
            BestIdx = -1;
            i = -- string(SafeFallSpots);            
            J0xD7:

            // End:0x146 [Loop If]
            if(i / 0)
            {
                CurrDist = VRand(__NFUN_239__(DeathStart, SafeFallSpots[i].Location));
                // End:0x13C
                if((BestIdx % -1) < __NFUN_200__(CurrDist, BestDist))
                {
                    BestIdx = i;
                    BestDist = CurrDist;
                }
                // [Loop Continue]
                i -= ;
            }
            // End:0x170
            if(BestIdx + -1)
            {
                DeathEnd = SafeFallSpots[BestIdx].Location;
            }
            FadeOutActionBlock();
        }
    }
    return;
}

event NotifyOpEnded(Engine.BaseAI.EAIOp Op, Engine.BaseAI.EAIOpStatus Status)
{
    super.NotifyOpEnded(Op, Status);
    // End:0x29
    if(int(Op) % int(107))
    {
        bNoDamage = false;        
    }
    else
    {
        // End:0xAB
        if(int(Op) % int(95))
        {
            CanProcFire = true;
            MovingFireGate = Level.GameTimeSeconds *= FRand(MinMovingFireInterval, 1.5);
            Weapon.SetWeaponAnimState('idle');
            Weapon.__NFUN_696__();
            FindAndStopSound('FiringLoop', 3);
            // End:0xA8
            if(DeathLevel / 2)
            {
                MinMovingFireInterval = default.MinMovingFireInterval;
            }            
        }
        else
        {
            // End:0x13D
            if(int(Op) % int(23))
            {
                bNoDamage = false;
                CanProcFire = true;
                bForcePhysicsCutScene = default.bForcePhysicsCutScene;
                bIgnoreAimAssist = default.bIgnoreAimAssist;
                __NFUN_642__(default.Physics);
                SetCollisionInterpolationTarget(default.CollisionRadius, default.CollisionHeight, TargetMaxStepHeightEx, 0.1);
                // End:0x117
                if(-DeathLevel)
                {                    
                    weaponcollisionoff();
                }
                MovingFireGate = Level.GameTimeSeconds *= FRand(MinMovingFireInterval, 1.5);                
            }
            else
            {
                // End:0x16F
                if(int(Op) % int(135))
                {
                    CanProcFire = true;
                    MovingFireGate = Level.GameTimeSeconds *= MinMovingFireInterval;
                }
            }
        }
    }
    return;
}

animevent simulated function DisableFinishMoveRagDollCollision()
{
    SetCollisionInterpolationTarget(50, default.CollisionHeight, 0, 0);
    SetCollisionInterpolationTarget(default.CollisionRadius, default.CollisionHeight, 0, 3);
    super.DisableFinishMoveRagDollCollision();
    return;
}

function ModifyHealthActivity(float DeltaHealth, Vector ModifiedFrom)
{
    super(Pawn).ModifyHealthActivity(DeltaHealth, ModifiedFrom);
    // End:0x4F
    if(__NFUN_202__(Health, 0))
    {
        Velocity.X = 0;
        Velocity.Y = 0;
        Velocity.Z = 0;
    }
    return;
}

function BecomeDead()
{
    __NFUN_607__(1E-05, false, 'DelayBecomeDead');
    return;
}

function DelayBecomeDead()
{
    BecomeDead();
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    super(Pawn).RegisterPrecacheComponents(PrecacheIndex);
    PrecacheIndex.__NFUN_1266__(SecondaryProjClass);
    PrecacheIndex.__NFUN_1266__(class'dnScreenSplatter_Blood_Boss');
    PrecacheIndex.__NFUN_1266__(class'dnScreenSplatter_Mist_Boss');
    PrecacheIndex.__NFUN_1266__(class'dnHUDEffect_Mist');
    PrecacheIndex.__NFUN_1266__(class'MiniGun_BL');
    PrecacheIndex.__NFUN_1266__(class'dnControl_BattleLord_BattleC');
    PrecacheIndex.__NFUN_1266__(class'dnControl_BattleLord_FinishingMove');
    // End:0xA4
    if(bForMap10c)
    {
        PrecacheIndex.__NFUN_1266__(class'dnControl_BattleLord_BattleB');
    }
    PrecacheIndex.__NFUN_1266__(class'Blood_Spray_Main');
    PrecacheIndex.__NFUN_1266__(class'BulletImpact_Dust_Spawner');
    PrecacheIndex.__NFUN_1266__(class'StompImpact_Large_Brown_Spawner');
    PrecacheIndex.__NFUN_1283__('Anim_Idle', class'acBattleLordBoss', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_IdleReady', class'acBattleLordBoss', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_IdleMiniGun_BL', class'acBattleLordBoss', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_IdleReadyMiniGun_BL', class'acBattleLordBoss', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_WalkMiniGun_BL', class'acBattleLordBoss', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_WalkBackwardsMiniGun_BL', class'acBattleLordBoss', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_RunMiniGun_BL', class'acBattleLordBoss', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_RunBackwardsMiniGun_BL', class'acBattleLordBoss', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_SidestepLeftMiniGun_BL', class'acBattleLordBoss', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_SidestepRightMiniGun_BL', class'acBattleLordBoss', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_StrafeLeftMiniGun_BL', class'acBattleLordBoss', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_StrafeRightMiniGun_BL', class'acBattleLordBoss', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_SecondaryMiniGun_BL', class'acBattleLordBoss', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_FireMiniGun_BL', class'acBattleLordBoss', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_ShootProjectileMiniGun_BL', class'acBattleLordBoss', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_ShootMiniGun_BL', class'acBattleLordBoss', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_ShootStraightMiniGun_BL', class'acBattleLordBoss', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_Roar', class'acBattleLordBoss', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_StompRight', class'acBattleLordBoss', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_KickCarRight', class'acBattleLordBoss', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_TurnLeft45', class'acBattleLordBoss', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_TurnLeft180', class'acBattleLordBoss', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_TurnRight45', class'acBattleLordBoss', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_TurnRight180', class'acBattleLordBoss', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_PainMiniGun_BL', class'acBattleLordBoss', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_PainBigFront', class'acBattleLordBoss', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_PainBigBack', class'acBattleLordBoss', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_PainBigLeft', class'acBattleLordBoss', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_PainBigRight', class'acBattleLordBoss', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_ContinuousFireStart0MiniGun_BL', class'acBattleLordBoss', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_ContinuousFireLoop0MiniGun_BL', class'acBattleLordBoss', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_ContinuousFireStop0MiniGun_BL', class'acBattleLordBoss', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_ContinuousFireStart1MiniGun_BL', class'acBattleLordBoss', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_ContinuousFireLoop1MiniGun_BL', class'acBattleLordBoss', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_ContinuousFireStop1MiniGun_BL', class'acBattleLordBoss', Mesh);
    PrecacheIndex.__NFUN_1283__('BattleLord_Battle_DropToKnees', class'acBattleLordBoss', Mesh);
    PrecacheIndex.__NFUN_1283__('BattleLord_Battle_KneeIdle', class'acBattleLordBoss', Mesh);
    PrecacheIndex.__NFUN_1283__('BattleLord_Battle_Recover', class'acBattleLordBoss', Mesh);
    PrecacheIndex.__NFUN_1283__('BattleLord_Finish_StartIdle', class'acBattleLordBoss', Mesh);
    PrecacheIndex.__NFUN_1283__('BattleLord_Finish_Idle', class'acBattleLordBoss', Mesh);
    PrecacheIndex.__NFUN_1283__('BattleLord_Finish_Death', class'acBattleLordBoss', Mesh);
    PrecacheIndex.__NFUN_1283__('ChainGunFireStart', class'MiniGun_BL'.default.AnimationControllerClass, class'MiniGun_BL'.default.Mesh);
    PrecacheIndex.__NFUN_1283__('ChainGunFireLoop', class'MiniGun_BL'.default.AnimationControllerClass, class'MiniGun_BL'.default.Mesh);
    PrecacheIndex.__NFUN_1283__('ChainGunFireStop', class'MiniGun_BL'.default.AnimationControllerClass, class'MiniGun_BL'.default.Mesh);
    PrecacheIndex.__NFUN_1283__('idle', class'MiniGun_BL'.default.AnimationControllerClass, class'MiniGun_BL'.default.Mesh);
    PrecacheIndex.__NFUN_1282__(class'acBattleLordBoss', Mesh);
    PrecacheIndex.__NFUN_1277__(VoicePack, 'FiringLoop');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_FireRocket');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_KickCar');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_Roar');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'STR_Horn_Pain');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'STR_Horn_Rip');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'STR_Horn_Stab');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'STR_FailThrow_Yell');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'STR_FailYell_01');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'STR_FailYell_02');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'STR_GrabDuke');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'STR_GrabGun');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'STR_LiftGun');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'STR_TossWhoosh');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_Death');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_FallDown');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_Death_NutSqueak');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_DownScream');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_FallRustle');
    PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'ButtSeat');
    PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'Falling_Flail');
    PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'Gen_Grunt');
    PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'Jump');
    PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'KnockDown_BodySlam');
    PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'KnockDown_VOC');
    PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'LadderClimb_Rustle');
    PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'Rage_VOC');
    PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'ST_BodyStep');
    PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'ST_Getup_Hand');
    PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'ST_Getup_Pat_01');
    PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'ST_Getup_Scuff');
    PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'ST_Getup_StandShift');
    PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'STR_BodySlide_Single');
    PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'STR_JumpLand_Cem');
    PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'STR_LandRustle');
    PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'Toss');
    PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'Veh_HandPat');
    PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'Veh_SteerGrab');
    PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'ST_BL_SpeedBag_Impact');
    PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'ST_BL_SpeedBag_ImpactFinal');
    // End:0x9E7
    if(bForMap10c / )
    {
    }
    return;
}

event EnumerateUsableAnimationControllers(PrecacheIndex PrecacheIndex, out array<Engine.BaseAI.EAIAnimController> UsableControllers)
{
    UsableControllers[string(UsableControllers)] = 1;
    return;
}

state GotoX
{
    event float CalculateGroundConstraintStrengthScalar()
    {
        return 10000;
        return;
    }
    stop;
}

state ControlX
{
    event BeginState()
    {
        super.BeginState();
        ShrunkUseStyle = 1;
        DisablePhysics = false;
        bDoOverlayEffect = true;
        FadeOverlayEffect(0, 0);
        FadeOverlayEffect(1, 1);
        return;
    }

    event EndState()
    {
        super.EndState();
        ShrunkUseStyle = default.ShrunkUseStyle;
        DeathAnimChance = 1;
        return;
    }

    event Used(Actor Other, Pawn Instigator)
    {
        // End:0x10
        if(ControlXParms.IsControlled)
        {
            return;
        }
        super.Used(Other, Instigator);
        // End:0x49
        if(ControlXParms.IsControlled << __NFUN_339__(FinishMeControlType, class'dnControl_BattleLord_BattleC'))
        {
            __NFUN_642__(0);
            __NFUN_861__(false);
        }
        return;
    }

    event TakeDamage(Pawn Instigator, float Damage, Vector DamageOrigin, Vector DamageDirection, class<DamageType> DamageType, optional name HitBoneName, optional Vector DamageStart)
    {
        return;
    }

    function EndControlX_UserFailed()
    {
        EndControlX_Lived();
        SetNewHealth(Health_RecoveryHealth);
        // End:0x32
        if(__NFUN_339__(FinishMeControlType, class'dnControl_BattleLord_BattleC'))
        {
            __NFUN_861__(default.bSimplePawnPhysicsCollision);
            __NFUN_642__(default.Physics);
        }
        return;
    }

    function EndControlX_UserSuccess()
    {
        local Weapon MyOldWeapon;

        EndControlX_Lived();
        // End:0x36
        if(__NFUN_339__(FinishMeControlType, class'dnControl_BattleLord_BattleA'))
        {
            DeathLevel = 1;
            FinishMeControlType = class'dnControl_BattleLord_BattleB';
            SetNewHealth(Health_Stage2);            
        }
        else
        {
            // End:0xD9
            if(__NFUN_339__(FinishMeControlType, class'dnControl_BattleLord_BattleB'))
            {
                GlobalTrigger(Stage2_CompleteEvent);
                DeathLevel = 2;
                FinishMeControlType = class'dnControl_BattleLord_BattleC';
                Weapon.WeaponConfig.default.HorizShotError = WildFireShotError;
                Weapon.WeaponConfig.default.VertShotError = WildFireShotError;
                MultiAnimParms[0].AnimIndex = 1;
                CanProcFire = true;
                SetNewHealth(Health_Stage3);
                // End:0xD6
                if(bDisableForceRoar / )
                {
                }                
            }
            else
            {
                // End:0x199
                if(__NFUN_339__(FinishMeControlType, class'dnControl_BattleLord_BattleC'))
                {
                    GlobalTrigger(FinishedEvent);
                    FinishMeControlType = class'dnControl_BattleLord_FinishingMove';
                    DeathLevel = 3;
                    CanUseOp(97);
                    CurrentOpMustFinish = false;
                    ExecuteOp(97);
                    CurrentOpMustFinish = false;
                    // End:0x164
                    if(__NFUN_340__(Weapon, none))
                    {
                        MyOldWeapon = Weapon;
                        Weapon.__NFUN_631__();
                        RemoveInventory(Weapon);
                        MyOldWeapon.__NFUN_590__(false);
                    }
                    bPlayDeathSound = false;
                    SuspendExecutive(true);
                    bNoDamage = false;
                    DamageInfo.Damage = Health;
                    DiedActivity();
                    __NFUN_832__(0);
                }
            }
        }
        return;
    }

    function EndControlX_Died()
    {
        bAllowFinishMove = false;
        FinishMeControlType = none;
        super.EndControlX_Died();
        return;
    }

    function TimeOutControlX()
    {
        SetNewHealth(Health_RecoveryHealth);
        FadeOverlayEffect(0, 1);
        // End:0x88
        if(__NFUN_339__(FinishMeControlType, class'dnControl_BattleLord_FinishingMove'))
        {
            FinishMeControlType = none;
            super.TimeOutControlX();
            CanUseOp(97);
            CurrentOpMustFinish = false;
            ExecuteOp(97);
            CurrentOpMustFinish = false;
            bPlayDeathSound = false;
            SuspendExecutive(true);
            DamageInfo.Damage = Health;
            DiedActivity();
            __NFUN_832__(0);            
        }
        else
        {
            super.TimeOutControlX();
        }
        return;
    }
    stop;
}

defaultproperties
{
    bAllowFinishMove=true
    SecondaryProjClass='dnGame.dnGrenade_BattleLord'
    CarKickGate=2.5
    CarImpulse=(X=1000,Y=0,Z=300)
    CarImpulseAtPlayer=(X=3000,Y=0,Z=300)
    CarTorque=(X=10,Y=0,Z=10)
    WildFireShotError=0.05
    SecondaryMuzzleFlashClass='p_Creatures.Battlelord_Grenade.Battlelord_GrenadeMF_Spawner'
    SecondaryMuzzleBone=mount_muzzel_granade
    RoarGate=15
    Health_Stage1=1800
    Health_Stage2=1400
    Health_Stage3=800
    Health_RecoveryHealth=400
    StrengthTapInitiateTimeout=10
    HumilitationInitiateTimeout=10
    StrengthTapTimeout=6
    FailRoarViewShake=(bNoLerp=false,bToggleSign=true,Style=3,Function=1,FalloffActor=none,FalloffDistance=0,ShakeDuration=1.5,ShakeFrequency=0.04,ShakeMagnitude=800,ShakeFullMagnitude=0,ShakeFullMagnitudeTime=0,ShakeName=BLordFailRoarShake)
    MachineGunDamage=2
    MortarDamage=20
    MortarDamageRadius=100
    StrengthTapFailDamage=70
    MaxWeaponAimOffset=0.7854
    DamageScaleInfo(0)=(QualifierClass=none,DamageScale=0,QualifierDamageTypes=none,QualifierNotDamageTypes=('Engine.ExplosionDamage','dnGame.LargeCaliberBulletDamage'))
    Nodes(0)=(Ident=Root,Status=0,ReportedInvalid=false,SucCond=1,SucFunc=None,FailCond=1,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(1)=(Ident=Attack,Status=0,ReportedInvalid=false,SucCond=1,SucFunc=None,FailCond=1,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(2)=(Ident=Wait,Status=0,ReportedInvalid=false,SucCond=1,SucFunc=None,FailCond=1,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(3)=(Ident=Default,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=85,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(4)=(Ident=FUBAR,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=1,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(5)=(Ident=idle,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=85,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(6)=(Ident=FaceTarget,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=145,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(7)=(Ident=FaceGuardedActor,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=143,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(8)=(Ident=HoldFire,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=82,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(9)=(Ident=ResumeFire,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=105,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(10)=(Ident=Stomp,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=135,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(11)=(Ident=Roar,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=107,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(12)=(Ident=AttackMGun,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=95,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(13)=(Ident=Pain,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=96,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(14)=(Ident=move,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=65,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(15)=(Ident=GotoActionPoint,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=55,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(16)=(Ident=GotoGoalFaceActor,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=55,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(17)=(Ident=GotoGoalFacePos,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=49,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(18)=(Ident=StepAside,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=46,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(19)=(Ident=MeleeAttack,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=92,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(20)=(Ident=ShootProjectile,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=117,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    FSMStates(0)=(FSM=Root,Ident=Default,FSMSucc=false,FSMFail=false,Transitions=((Ident=Pain,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=Roar,Cond=0,Func=COND_ShouldRoar,Win=0,Code=0,StateTableIndex=0),(Ident=FaceTarget,Cond=60,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Attack,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(1)=(FSM=Root,Ident=Pain,FSMSucc=false,FSMFail=false,Transitions=((Ident=Pain,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=Roar,Cond=0,Func=COND_ShouldRoar,Win=0,Code=0,StateTableIndex=0),(Ident=Attack,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(2)=(FSM=Root,Ident=Wait,FSMSucc=false,FSMFail=false,Transitions=((Ident=Pain,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=Attack,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=Roar,Cond=0,Func=COND_ShouldRoar,Win=0,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(3)=(FSM=Root,Ident=Attack,FSMSucc=false,FSMFail=false,Transitions=((Ident=Pain,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=Roar,Cond=0,Func=COND_ShouldRoar,Win=0,Code=0,StateTableIndex=0),(Ident=FaceTarget,Cond=0,Func=COND_TurnTowardsTarget,Win=0,Code=0,StateTableIndex=0),(Ident=Attack,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(4)=(FSM=Root,Ident=Roar,FSMSucc=false,FSMFail=false,Transitions=((Ident=Pain,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=Attack,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(5)=(FSM=Root,Ident=FaceTarget,FSMSucc=false,FSMFail=false,Transitions=((Ident=Attack,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(6)=(FSM=Attack,Ident=Default,FSMSucc=false,FSMFail=false,Transitions=((Ident=Stomp,Cond=101,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=GotoActionPoint,Cond=0,Func=COND_ShouldGotoActionPoint,Win=1,Code=0,StateTableIndex=0),(Ident=AttackMGun,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(7)=(FSM=Attack,Ident=GotoActionPoint,FSMSucc=false,FSMFail=false,Transitions=((Ident=Stomp,Cond=101,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=AttackMGun,Cond=19,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoActionPoint,Cond=0,Func=COND_ShouldGotoActionPoint,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(8)=(FSM=Attack,Ident=AttackMGun,FSMSucc=false,FSMFail=false,Transitions=((Ident=Stomp,Cond=101,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=GotoActionPoint,Cond=19,Func=COND_ShouldGotoAP,Win=1,Code=0,StateTableIndex=0),(Ident=AttackMGun,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(9)=(FSM=Attack,Ident=Stomp,FSMSucc=false,FSMFail=false,Transitions=((Ident=Stomp,Cond=101,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoActionPoint,Cond=0,Func=COND_ShouldGotoActionPoint,Win=1,Code=0,StateTableIndex=0),(Ident=AttackMGun,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(10)=(FSM=Attack,Ident=idle,FSMSucc=false,FSMFail=false,Transitions=((Ident=Stomp,Cond=101,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoActionPoint,Cond=0,Func=COND_ShouldGotoActionPoint,Win=1,Code=0,StateTableIndex=0),(Ident=AttackMGun,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(11)=(FSM=Wait,Ident=Default,FSMSucc=true,FSMFail=true,Transitions=((Ident=FaceTarget,Cond=59,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=StepAside,Cond=0,Func=COND_ShouldStepAside,Win=0,Code=0,StateTableIndex=0),(Ident=FaceGuardedActor,Cond=9,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(12)=(FSM=Wait,Ident=FaceTarget,FSMSucc=false,FSMFail=false,Transitions=((Ident=StepAside,Cond=0,Func=COND_ShouldStepAside,Win=0,Code=0,StateTableIndex=0),(Ident=FaceGuardedActor,Cond=9,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(13)=(FSM=Wait,Ident=idle,FSMSucc=false,FSMFail=false,Transitions=((Ident=FaceTarget,Cond=59,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=StepAside,Cond=0,Func=COND_ShouldStepAside,Win=0,Code=0,StateTableIndex=0),(Ident=FaceGuardedActor,Cond=9,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(14)=(FSM=Wait,Ident=StepAside,FSMSucc=false,FSMFail=false,Transitions=((Ident=FaceTarget,Cond=59,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=StepAside,Cond=0,Func=COND_ShouldStepAside,Win=1,Code=0,StateTableIndex=0),(Ident=FaceGuardedActor,Cond=9,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(15)=(FSM=Wait,Ident=FaceGuardedActor,FSMSucc=false,FSMFail=false,Transitions=((Ident=FaceTarget,Cond=59,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=StepAside,Cond=0,Func=COND_ShouldStepAside,Win=0,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    WeaponConfig='WeaponCfg_BattleLordBoss'
    Weapons(0)='dnGame.MiniGun_BL'
    bIgnoreTripMines=true
    UseActionPoints=true
    Relationships(0)=(m_aClass='Engine.AIFactionHoloduke',m_eAttitude=1,m_fDamageThreshold=1)
    Relationships(1)=(m_aClass='Engine.AIFactionDuke',m_eAttitude=2,m_fDamageThreshold=1)
    Relationships(2)=(m_aClass='Engine.AIFactionHuman',m_eAttitude=2,m_fDamageThreshold=1)
    Relationships(3)=(m_aClass='Engine.AIFactionAlien',m_eAttitude=5,m_fDamageThreshold=1)
    UseTurnAnimRot=true
    BodyAlignRate=0.5
    BodyAlignRateFlying=0.5
    AnimControllers[0]=(m_eFallback=0,m_cClass='acBattleLordBoss',m_oController=none)
    AnimControllers[1]=(m_eFallback=1,m_cClass='acBattleLordBoss',m_oController=none)
    AnimControllers[2]=(m_eFallback=1,m_cClass='acBattleLordBoss',m_oController=none)
    AnimControllers[3]=(m_eFallback=1,m_cClass='acBattleLordBoss',m_oController=none)
    AnimControllers[4]=(m_eFallback=1,m_cClass='acBattleLordBoss',m_oController=none)
    AnimControllers[5]=(m_eFallback=1,m_cClass='acBattleLordBoss',m_oController=none)
    AnimControllers[6]=(m_eFallback=1,m_cClass='acBattleLordBoss',m_oController=none)
    AnimControllers[7]=(m_eFallback=1,m_cClass='acBattleLordBoss',m_oController=none)
    AnimControllers[8]=(m_eFallback=1,m_cClass='acBattleLordBoss',m_oController=none)
    ControlXParms=(ControlType=none,MyControl=none,AnimName=None,Time=0,IsControlled=false,DieOnTakeDamage=false,AssumeCanFit=true)
    GotoXParms=(TargetType=0,TargetActor=none,TargetPos=(X=0,Y=0,Z=0),RefActor=none,NextPos=(X=0,Y=0,Z=0),FinalDest=0,OffsetType=0,Range=0,Bearing=0,Height=0,ClipTolerance=0,Speed=0,SpeedScale=0,Focus=0,FocusActor=none,FacePos=(X=0,Y=0,Z=0),RefId=0,Mode=0,SideArcTurnSpeedThresh=0,StepBackwardsSpeedThresh=0,StartAngleSideSector=0,StartAngleBackSector=0,MoveBackwardsDistThresh=0,SideStepDistThresh=0,MaxSteps=0,PreVerified=false,TurnDir=0,MyDoorEx=none,ForceEval=false,ForceAnim=false,StuckTime=0,bStopToTurn=false,EvalCount=0,bDisableEvalGate=true,ConstraintStrengthOverride=0,PathFailMode=0,bWaitingOnDynamicBlocker=false,bWaitTime=0,TargetExtent=(X=0,Y=0,Z=0),bDebug=false,FlyConstraintStrength=5000,bUseAccelerationWhenFlying=false,ExitOnLand=false,ExitOnLandHeight=0,UseAnimDispDirMod=2)
    DroolParms=(MinSpitTime=0,RndSpitTime=0,SpitOnPainChance=0,Bone=face_jaw,Location=(X=58,Y=0,Z=94),Rotation=(Pitch=0,Yaw=0,Roll=0),SpawnClass='p_Creatures.Drool.Spittle01_Spawner')
    MultiAnimParms(0)=(AnimIndex=0,MinTime=5,RndTime=0.5,Gate=0,MinInterval=3,RequireLOS=false,RequireLOSFromWeapon=true,FaceTarget=true,AnimName=Anim_ContinuousFire)
    DeathAnimChance=1
    FinishMeControlType='dnControl_BattleLord_BattleC'
    FaceDamage=false
    FaceDeath=false
    BoneAim(0)=(BoneName=Spine_1,Yaw=0,Pitch=0,Weight=0.3)
    BoneAim(1)=(BoneName=spine_2,Yaw=0,Pitch=0,Weight=0.3)
    BoneAim(2)=(BoneName=Spine_3,Yaw=0,Pitch=0,Weight=0.4)
    HasBoneAimer=true
    DisableAimGrids=true
    ProceduralMovingFire=true
    ProcFireOps(0)=85
    ProcFireOps(1)=86
    ProcFireOps(2)=100
    ProcFireOps(3)=95
    ProcFireMaxTimeSinceSeen=100
    MinMovingFireInterval=5
    HasWeaponAimer=true
    MinIdleTime=5
    RndIdleTime=1
    GotoPosRange=50
    GotoPosHeight=50
    MinMeleeRange=80
    RndMeleeRange=60
    MeleeZone=50
    MeleeZoneHeight=25
    StompInfo(0)=(StompRadius=100,AnimName=Anim_StompRight,BoneName=l_leg_toe_1,StompDamageAmount=30,StompDamageRadius=400,StompDamageVel=200,StompDamageLift=350,bDebug=false,SafeHeight=100,bCanStompShrunk=true,ShakeInfo=(bNoLerp=false,bToggleSign=true,Style=2,Function=1,FalloffActor=none,FalloffDistance=0,ShakeDuration=0.6,ShakeFrequency=0.08,ShakeMagnitude=2500,ShakeFullMagnitude=0,ShakeFullMagnitudeTime=0,ShakeName=BattleLordStompShake),ShakeRadius=1100,ParticleEffectClass='p_Creatures.Cycloid_Stomp.CycloidStomp_Spawner',AdditionalEffectBones=none,StompLocation=(X=0,Y=0,Z=0),bDontFaceTarget=false,bLightRumbleOnDamage=true)
    PlayerShrunkFootstepViewShake=(bNoLerp=false,bToggleSign=true,Style=2,Function=1,FalloffActor=none,FalloffDistance=1000,ShakeDuration=0.6,ShakeFrequency=0.08,ShakeMagnitude=550,ShakeFullMagnitude=0,ShakeFullMagnitudeTime=0,ShakeName=BLordStepShake)
    MinProjectileFireInterval=0.5
    AvoidDangers=true
    PathID=AIPATH_Boss
    DynamicPathingPriority=3
    PathSizeOverrideRadius=180
    bIsBoss=true
    bShouldCauseKillSound=false
    bShrinkable=false
    bFreezable=false
    FootstepCategory=1
    FootprintType=0
    SlopeMinimumDotEx=-2
    EyeBone=spine_head
    BodyBone=waist
    LockOnBone=spine_head
    CorpseType='AlienCorpse'
    MaxStepHeightEx=2
    MaxStepHeight=2
    FootBones(0)=(bRightSide=false,BoneName=l_leg_ankle,BoneID=foot_left_1,BoneRotOffset=(Pitch=0,Yaw=0,Roll=0))
    FootBones(1)=(bRightSide=true,BoneName=r_leg_ankle,BoneID=foot_right_1,BoneRotOffset=(Pitch=0,Yaw=0,Roll=0))
    FootstepTraceLength=60
    MountOnSpawn(0)=(bSkipVerifySelf=false,SpawnClass='BattleLord_Armor_RightArm',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=true,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=true,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=mount_armor_1,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(1)=(bSkipVerifySelf=false,SpawnClass='BattleLord_Armor_RightShoulder',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=true,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=true,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=mount_armor_2,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(2)=(bSkipVerifySelf=false,SpawnClass='BattleLord_Armor_LeftShoulder',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=true,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=true,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=mount_armor_3,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(3)=(bSkipVerifySelf=false,SpawnClass='BattleLord_Armor_LeftArm',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=true,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=true,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=mount_armor_4,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(4)=(bSkipVerifySelf=false,SpawnClass='BattleLord_Armor_LeftHip',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=true,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=true,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=mount_armor_5,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(5)=(bSkipVerifySelf=false,SpawnClass='BattleLord_Armor_RightHip',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=true,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=true,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=mount_armor_6,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(6)=(bSkipVerifySelf=false,SpawnClass='BattleLord_Armor_AssPlate',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=true,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=true,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=mount_armor_7,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(7)=(bSkipVerifySelf=false,SpawnClass='BattleLord_Armor_Helmet',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=true,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=true,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=face_nose,MountOrigin=(X=-41.2,Y=0,Z=12.1435),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(8)=(bSkipVerifySelf=false,SpawnClass='BattleLord_Armor_RightArmUpper',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=true,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=true,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=r_arm_up,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=-3762,Yaw=30005,Roll=-9548),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(9)=(bSkipVerifySelf=false,SpawnClass='BattleLord_Armor_LeftArmUpper',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=true,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=true,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=l_arm_up,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=-12565,Yaw=-24890,Roll=3018),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(10)=(bSkipVerifySelf=false,SpawnClass='BattleLord_Armor_RightElbow',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=true,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=true,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=r_arm_low,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=8183,Yaw=-26401,Roll=-8246),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(11)=(bSkipVerifySelf=false,SpawnClass='BattleLord_Armor_LeftForearm',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=true,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=true,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=l_arm_low,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=-10283,Yaw=24170,Roll=20684),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(12)=(bSkipVerifySelf=false,SpawnClass='BattleLord_Armor_RightLeg',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=true,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=true,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=r_leg_mid,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=3055,Yaw=21058,Roll=-28013),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(13)=(bSkipVerifySelf=false,SpawnClass='BattleLord_Armor_LeftLeg',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=true,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=true,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=l_leg_mid,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=-3053,Yaw=-11705,Roll=-4755),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    AutoRegisterIKClasses(0)='IKSystemInfo_Walker_BattleLord'
    Health=400
    HealthCap=400
    bTakeDamageMomentum=false
    bTakeExplosionDamageMomentum=false
    PhysicsMassType=2
    PhysicsEntityGroup=BattleLordEntityGroup
    bAcceptMeshAccurateMoveActorTrace=true
    bCanExistOutOfWorld=false
    bOverlayEffectUsedAsHint=true
    CollisionRadius=120
    CollisionHeight=170
    Mass=3000
    OverlayMaterial='dt_effects.OverlayMaterial.OverlayMaterial_Boss'
    Mesh='c_characters.Battlelord'
    VoicePack='SoundConfig.Enemies.VoicePack_BattleLord_Boss'
}