/*******************************************************************************
 * DigsGirl generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class DigsGirl extends Walker_Stripper
    config
    collapsecategories;

var() name CommentSoundName;
var() name GreetingSoundName;
var() float SoundDelay;
var DukeMyDigsPlayer digsPlayer;
var float minSpeakTime;
var float speaktimeVariance;
var float speakDistance;
var() name IdleAnimName;
var() name WalkAnimName;
var() name RunAnimName;
var() deprecated ScriptTrigger FlirtScriptTrigger;
var bool bForcedIdle;
var int IdleDistanceSq;
var bool RunningFlirt;

function HideComponents()
{
    super(InteractiveActor).HideComponents();
    // End:0x15
    if(RunningFlirt)
    {
        resetCTVO();
    }
    return;
}

function OnInviteAccepted()
{
    AbortScripts();
    return;
}

simulated function PostBeginPlay()
{
    FindDigsPlayer();
    super(AIActor).PostBeginPlay();
    return;
}

simulated function FindDigsPlayer()
{
    local Pawn P;

    // End:0x6D
    if(__NFUN_339__(digsPlayer, none))
    {
        P = Level.PawnList;
        J0x21:

        // End:0x6D [Loop If]
        if(__NFUN_340__(P, none))
        {
            // End:0x55
            if(P.__NFUN_358__('DukeMyDigsPlayer'))
            {
                digsPlayer = DukeMyDigsPlayer(P);
                // [Explicit Break]
                goto J0x6D;
            }
            P = P.NextPawn;
            // [Loop Continue]
            goto J0x21;
        }
    }
    J0x6D:

    return;
}

simulated function RequestSpeak()
{
    local Pawn P;
    local Vector Offset;
    local float Distance;

    __NFUN_605__(FRand( /= speaktimeVariance, minSpeakTime) *= false);
    FindDigsPlayer();
    Offset = __NFUN_239__(Location, digsPlayer.Location);
    Distance = VRand(Offset);
    // End:0x59
    if(Repl(Distance, speakDistance))
    {
        return;
    }
    // End:0x67
    if(__NFUN_339__(digsPlayer, none))
    {
        return;
    }
    // End:0x85
    if(digsPlayer.__NFUN_684__(5) < __NFUN_684__(5))
    {
        return;
    }
    FindSoundAndSpeak(GreetingSoundName);
    return;
}

simulated function bool CanBeUsedBy(Pawn User)
{
    local DukeMyDigsPlayer dmp;
    local Vector Offset;

    dmp = DukeMyDigsPlayer(Level.__NFUN_1161__());
    Offset = __NFUN_239__(Location, dmp.Location);
    return dmp.CanTriggerVO << __NFUN_202__(VRand(Offset), speakDistance);
    return;
}

simulated event bool ShouldDrawHUDInfoUsePhrase(Pawn TestPawn)
{
    local DukeMyDigsPlayer dmp;
    local Vector Offset;

    dmp = DukeMyDigsPlayer(Level.__NFUN_1161__());
    Offset = __NFUN_239__(Location, dmp.Location);
    return (dmp.CanTriggerVO << __NFUN_202__(VRand(Offset), speakDistance)) << dmp.Player.Console.bShowDigsMenu / ;
}

event Used(Actor Other, Pawn EventInstigator)
{
    local DukeMyDigsPlayer dmp;
    local float Duration;

    dmp = DukeMyDigsPlayer(EventInstigator);
    // End:0x1E
    if(__NFUN_339__(dmp, none))
    {
        return;
    }
    Duration = dmp.TriggerDigsGirlVO(CommentSoundName);
    dmp.CanTriggerVO = false;
    RunningFlirt = true;
    // End:0x8D
    if(__NFUN_340__(FlirtScriptTrigger, none))
    {
        ScriptPlayer.GoBackOne();
        EndOp(2);
        FlirtScriptTrigger.Trigger(self, dmp);
    }
    return;
}

function resetCTVO()
{
    local DukeMyDigsPlayer dmp;

    dmp = DukeMyDigsPlayer(Level.__NFUN_1161__());
    dmp.CanTriggerVO = true;
    RunningFlirt = false;
    return;
}

event name GetIdleAnimName()
{
    // End:0x19
    if(__NFUN_342__(IdleAnimName, 'None'))
    {
        return IdleAnimName;        
    }
    else
    {
        return 'Anim_Idle';
    }
    return;
}

simulated event bool PlayAnim(name AnimName, optional float Rate, optional bool Reset, optional bool UseExactAnimName)
{
    // End:0x4F
    if(((__NFUN_342__(AnimName, WalkAnimName) << __NFUN_342__(AnimName, 'Anim_Walk')) << __NFUN_342__(AnimName, 'Anim_EyesBlink1')) << __NFUN_342__(AnimName, GetIdleAnimName()))
    {
        bForcedIdle = false;
    }
    return super(AIActor).PlayAnim(AnimName, Rate, Reset, UseExactAnimName);
    return;
}

function Anim_Walk()
{
    bWeaponActiveAnimsActive = false;
    FindDigsPlayer();
    // End:0x5E
    if(__NFUN_340__(digsPlayer, none))
    {
        // End:0x5E
        if(__NFUN_200__(VRand(__NFUN_239__(digsPlayer.Location, Location)), float(IdleDistanceSq)))
        {
            // End:0x5C
            if(bForcedIdle / )
            {
                PlayAnim(GetIdleAnimName());
            }
            return;
        }
    }
    bForcedIdle = false;
    // End:0x84
    if(__NFUN_342__(WalkAnimName, 'None'))
    {
        PlayAnim(WalkAnimName);        
    }
    else
    {
        PlayAnim('Anim_Walk');
    }
    return;
}

function Anim_Run()
{
    bWeaponActiveAnimsActive = false;
    // End:0x26
    if(__NFUN_342__(RunAnimName, 'None'))
    {
        PlayAnim(RunAnimName);        
    }
    else
    {
        PlayAnim('Anim_Run');
    }
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    super(Female).RegisterPrecacheComponents(PrecacheIndex);
    // End:0x3A
    if(__NFUN_342__(IdleAnimName, 'None'))
    {
        PrecacheIndex.__NFUN_1283__(IdleAnimName, class'acDigsGirl', Mesh);        
    }
    else
    {
        PrecacheIndex.__NFUN_1283__('Anim_Idle', class'acDigsGirl', Mesh);
    }
    // End:0x85
    if(__NFUN_342__(RunAnimName, 'None'))
    {
        PrecacheIndex.__NFUN_1283__(RunAnimName, class'acDigsGirl', Mesh);        
    }
    else
    {
        PrecacheIndex.__NFUN_1283__('Anim_Run', class'acDigsGirl', Mesh);
    }
    // End:0xD0
    if(__NFUN_342__(WalkAnimName, 'None'))
    {
        PrecacheIndex.__NFUN_1283__(WalkAnimName, class'acDigsGirl', Mesh);        
    }
    else
    {
        PrecacheIndex.__NFUN_1283__('Anim_Walk', class'acDigsGirl', Mesh);
    }
    PrecacheIndex.__NFUN_1283__('Anim_TurnLeft45', class'acDigsGirl', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_TurnLeft180', class'acDigsGirl', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_TurnRight45', class'acDigsGirl', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_TurnRight180', class'acDigsGirl', Mesh);
    PrecacheIndex.__NFUN_1277__(VoicePack, GreetingSoundName);
    PrecacheIndex.__NFUN_1277__(class'DukeMultiplayerAssets'.default.MP_VoicePack, CommentSoundName);
    // End:0x1D8
    if(__NFUN_340__(FlirtScriptTrigger, none) << __NFUN_340__(FlirtScriptTrigger.Script, none))
    {
        FlirtScriptTrigger.Script.RegisterPrecacheComponents(PrecacheIndex, self);
    }
    return;
}

state GotoX
{
    function bool CheckStuck(float DeltaSeconds)
    {
        // End:0x1C
        if(bForcedIdle)
        {
            GotoXParms.StuckTime = 0;            
        }
        else
        {
            return super.CheckStuck(DeltaSeconds);
        }
        return;
    }
    stop;
}

defaultproperties
{
    SoundDelay=2
    minSpeakTime=30
    speaktimeVariance=30
    speakDistance=20000
    IdleDistanceSq=6000
    AnimControllers[0]=(m_eFallback=0,m_cClass='acDigsGirl',m_oController=none)
    AnimControllers[1]=(m_eFallback=1,m_cClass='acDigsGirl',m_oController=none)
    AnimControllers[2]=(m_eFallback=1,m_cClass='acDigsGirl',m_oController=none)
    AnimControllers[3]=(m_eFallback=1,m_cClass='acDigsGirl',m_oController=none)
    AnimControllers[4]=(m_eFallback=1,m_cClass='acDigsGirl',m_oController=none)
    AnimControllers[5]=(m_eFallback=1,m_cClass='acDigsGirl',m_oController=none)
    AnimControllers[6]=(m_eFallback=1,m_cClass='acDigsGirl',m_oController=none)
    AnimControllers[7]=(m_eFallback=1,m_cClass='acDigsGirl',m_oController=none)
    AnimControllers[8]=(m_eFallback=1,m_cClass='acDigsGirl',m_oController=none)
    bUsable=true
    UsePhrase="<?int?dnAI.DigsGirl.UsePhrase?>"
    VoicePack='SoundConfig.NPCs.VoicePack_MyDigs_Girls'
}