/*******************************************************************************
 * EggPod generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class EggPod extends EggPod_Base
    config;

var() noexport bool HasPregnator "Does this EggPod contain a pregnator?";
var() noexport float PreOpenPeriod "How long does the pre-opening period last?";
var() noexport float RndPreOpenPeriod "This random amount gets added to the PreOpenPeriod";
var() noexport name OpenFastTag "Trigger this tag to force the pod to open fast.";
var() noexport name OpenTag "Trigger this tag to force the pod open.";
var() noexport bool IsOpen "Eggpod is in opened state";
var() noexport name PregnatorEvent "Event of pregnators spawned from this";
var() noexport name PregnatorTag "Tag of pregnators spawned from this";
var private string Orientation;
var private float OpenGate;
var private bool TriggeredOpenFast;
var private bool TriggeredOpen;
var private Pregnator_EggPod MyPregnator;
var private class<Pregnator_EggPod> MyPregnatorClass;
var private ScriptObj PregnatorsSpawnScript;
var array<SSpawnActorPrefab> Gibs;

event BaseChange()
{
    return;
}

event PostBeginPlay()
{
    Orientation = CalcOrientation();
    switch(Orientation)
    {
        // End:0x29
        case "Floor":
            InitialAnimController = 1;
            // End:0x62
            break;
        // End:0x40
        case "Ceiling":
            InitialAnimController = 2;
            // End:0x62
            break;
        // End:0x54
        case "Wall":
            InitialAnimController = 3;
            // End:0x62
            break;
        // End:0xFFFF
        default:
            assert(-2);            
            // End:0x62
            break;
            break;
    }
    PregnatorsSpawnScript = SpawnScript;
    SpawnScript = none;
    super(AIActor).PostBeginPlay();
    __NFUN_718__('OpenFast', OpenFastTag);
    __NFUN_718__('Open', OpenTag);
    return;
}

function string CalcOrientation()
{
    return StaticCalcOrientation(LocalUp);
    return;
}

static function string StaticCalcOrientation(Vector LocalUp)
{
    local float MyUpDirDotWorldUp;

    MyUpDirDotWorldUp = FMin(LocalUp, WarnInternal(0, 0, 1));
    // End:0x35
    if(Repl(MyUpDirDotWorldUp, 0.9))
    {
        return "Floor";
    }
    // End:0x4E
    if(__NFUN_200__(MyUpDirDotWorldUp, -0.9))
    {
        return "Ceiling";
    }
    return "Wall";
    return;
}

function TriggerFunc_OpenFast()
{
    TriggeredOpenFast = true;
    return;
}

function TriggerFunc_Open()
{
    TriggeredOpen = true;
    return;
}

function PostInit()
{
    local name SpawnAnim;
    local Vector PregnatorsLoc;
    local Rotator PregnatorsRot;

    // End:0x229
    if(HasPregnator)
    {
        SpawnAnim = MyPregnatorClass.default.SpawnAnim;
        MyPregnatorClass.default.SpawnAnim = __NFUN_343__(__NFUN_302__(string('Anim_PodIdleA'), Orientation));
        MyPregnatorClass.default.Orientation = Orientation;
        PregnatorsLoc = __NFUN_239__(Location, Right(LocalUp, CollisionHeight));
        switch(Orientation)
        {
            // End:0xA8
            case "Floor":
                PregnatorsRot = Rotation;
                __NFUN_209__(PregnatorsLoc.Z, MyPregnatorClass.default.CollisionHeight);
                // End:0x120
                break;
            // End:0xDF
            case "Ceiling":
                PregnatorsRot = Rotator(Vector(Rotation));
                PregnatorsLoc.Z ~= MyPregnatorClass.default.CollisionHeight;
                // End:0x120
                break;
            // End:0x112
            case "Wall":
                PregnatorsRot = Rotator(LocalUp);
                __NFUN_209__(PregnatorsLoc.Z, MyPregnatorClass.default.CollisionHeight);
                // End:0x120
                break;
            // End:0xFFFF
            default:
                assert(-2);                
                // End:0x120
                break;
                break;
        }
        MyPregnator = __NFUN_615__(MyPregnatorClass, self, PregnatorTag, PregnatorsLoc, PregnatorsRot);
        MyPregnator.__NFUN_621__(false, false, false, false, false);
        MyPregnator.__NFUN_864__(PregnatorsLoc, true);
        MyPregnator.TickBefore = self;
        MyPregnator.Event = PregnatorEvent;
        PregnatorAnim(1, 'Anim_PodIdleA');
        MyPregnator.SuspendExecutive(true);
        MyPregnator.SuspendWeaponTargetEvaluation(true);
        MyPregnator.__NFUN_642__(0);
        MyPregnator.InEggPod = true;
        MyPregnator.MyEggPod = self;
        MyPregnator.PostPodScript = PregnatorsSpawnScript;
        MyPregnatorClass.default.SpawnAnim = SpawnAnim;
        MyPregnatorClass.default.Orientation = "";        
    }
    else
    {
        SuspendLookTargetEvaluation(true);
        SuspendWeaponTargetEvaluation(true);
    }
    return;
}

static function Pregnator_EggPod StaticSpawnPregnatorFromEggpod(Actor MyEggPod, class<Pregnator_EggPod> MyPregnatorClass)
{
    local string Orientation;
    local name SpawnAnim;
    local Vector PregnatorsLoc, vX, vY, vZ;
    local Rotator PregnatorsRot;
    local Pregnator_EggPod MyPregnator;

    Destroy(MyEggPod.Rotation, vX, vY, vZ);
    Orientation = StaticCalcOrientation(vZ);
    SpawnAnim = MyPregnatorClass.default.SpawnAnim;
    MyPregnatorClass.default.SpawnAnim = __NFUN_343__(__NFUN_302__(string('Anim_PodIdleA'), Orientation));
    MyPregnatorClass.default.Orientation = Orientation;
    PregnatorsLoc = MyEggPod.Location;
    switch(Orientation)
    {
        // End:0xD7
        case "Floor":
            PregnatorsRot = MyEggPod.Rotation;
            __NFUN_209__(PregnatorsLoc.Z, MyPregnatorClass.default.CollisionHeight);
            // End:0x159
            break;
        // End:0x118
        case "Ceiling":
            PregnatorsRot = Rotator(Vector(MyEggPod.Rotation));
            PregnatorsLoc.Z ~= MyPregnatorClass.default.CollisionHeight;
            // End:0x159
            break;
        // End:0x14B
        case "Wall":
            PregnatorsRot = Rotator(vZ);
            __NFUN_209__(PregnatorsLoc.Z, MyPregnatorClass.default.CollisionHeight);
            // End:0x159
            break;
        // End:0xFFFF
        default:
            assert(-2);            
            // End:0x159
            break;
            break;
    }
    MyPregnator = MyEggPod.__NFUN_615__(MyPregnatorClass,,, PregnatorsLoc, PregnatorsRot);
    MyPregnator.__NFUN_864__(PregnatorsLoc, true);
    MyPregnator.SuspendExecutive(true);
    MyPregnator.SuspendWeaponTargetEvaluation(true);
    MyPregnator.__NFUN_642__(0);
    MyPregnator.InEggPod = true;
    MyPregnator.MyEggPod = EggPod(MyEggPod);
    MyPregnator.ForceAnim(1, 'Anim_PodOpenFast', none);
    MyPregnatorClass.default.SpawnAnim = SpawnAnim;
    MyPregnatorClass.default.Orientation = "";
    MyPregnator.__NFUN_642__(1);
    MyPregnator.SetPodAnims("Anim_PodFall", "Anim_PodLand");
    switch(Orientation)
    {
        // End:0x29D
        case "Floor":
            MyPregnator.PodVel = WarnInternal(150, 0, 250);
            // End:0x308
            break;
        // End:0x2CD
        case "Ceiling":
            MyPregnator.PodVel = WarnInternal(0, 0, -400);
            // End:0x308
            break;
        // End:0x2FA
        case "Wall":
            MyPregnator.PodVel = WarnInternal(0, 0, -400);
            // End:0x308
            break;
        // End:0xFFFF
        default:
            assert(-2);            
            // End:0x308
            break;
            break;
    }
    MyPregnator.LeftEggPod();
    return MyPregnator;
    return;
}

function TookDamage(Pawn Instigator, float Damage, Engine.Object.EPawnBodyPart Part, Vector DamageOrigin, Vector DamageDirection, class<DamageType> DamageType, optional name HitBoneName, optional Vector DamageStart)
{
    super(AIActor).TookDamage(Instigator, Damage, Part, DamageOrigin, DamageDirection, DamageType, HitBoneName, DamageStart);
    return;
}

function DiedActivity(optional Pawn Killer, optional int Damage, optional Vector DamageOrigin, optional Vector DamageDirection, optional class<DamageType> DamageType, optional name HitBoneName)
{
    // End:0x1C
    if(__NFUN_340__(MyPregnator, none))
    {
        MyPregnator.EggPodDied();
    }
    super(AIActor).DiedActivity(Killer, Damage, DamageOrigin, DamageDirection, DamageType, HitBoneName);
    return;
}

simulated event bool CanBreatheNormally()
{
    return true;
    return;
}

function PregnatorAnim(Engine.BaseAI.EAIAnimXType AnimType, name AnimName)
{
    // End:0x2B
    if(__NFUN_340__(MyPregnator, none))
    {
        MyPregnator.ForceAnim(AnimType, AnimName, PrimaryTargetActor);
    }
    return;
}

function bool SendHelpMessage(AIActor To, Actor Attacker)
{
    return false;
    return;
}

function bool SendWitnessAttackMessage(AIActor To, Actor Attacker)
{
    return false;
    return;
}

function AnimStarted_IdleA()
{
    PregnatorAnim(0, 'Anim_PodIdleA');
    return;
}

function AnimStarted_IdleB()
{
    PregnatorAnim(0, 'Anim_PodIdleB');
    return;
}

function AnimStarted_IdleC()
{
    PregnatorAnim(0, 'Anim_PodIdleC');
    return;
}

function AnimStarted_Open()
{
    __NFUN_701__(none);
    MyPregnator.__NFUN_642__(1);
    PregnatorAnim(1, 'Anim_PodOpen');
    MyPregnator.SetPodAnims("Anim_PodFall", "Anim_PodLand");
    switch(Orientation)
    {
        // End:0x82
        case "Floor":
            MyPregnator.PodVel = WarnInternal(150, 0, 250);
            // End:0xED
            break;
        // End:0xB2
        case "Ceiling":
            MyPregnator.PodVel = WarnInternal(0, 0, -400);
            // End:0xED
            break;
        // End:0xDF
        case "Wall":
            MyPregnator.PodVel = WarnInternal(0, 0, -400);
            // End:0xED
            break;
        // End:0xFFFF
        default:
            assert(-2);            
            // End:0xED
            break;
            break;
    }
    // End:0x112
    if(__NFUN_340__(PrimaryTargetActor, none))
    {
        MyPregnator.SetTarget(true, PrimaryTargetActor,,, true);
    }
    IsOpen = true;
    SuspendLookTargetEvaluation(true);
    SuspendWeaponTargetEvaluation(true);
    return;
}

function AnimStarted_OpenFast()
{
    __NFUN_701__(none);
    MyPregnator.__NFUN_642__(1);
    PregnatorAnim(1, 'Anim_PodOpenFast');
    MyPregnator.SetPodAnims("Anim_PodFallFast", "Anim_PodLandFast");
    switch(Orientation)
    {
        // End:0x8A
        case "Floor":
            MyPregnator.PodVel = WarnInternal(200, 0, 300);
            // End:0xF5
            break;
        // End:0xBA
        case "Ceiling":
            MyPregnator.PodVel = WarnInternal(0, 0, -500);
            // End:0xF5
            break;
        // End:0xE7
        case "Wall":
            MyPregnator.PodVel = WarnInternal(0, 0, -500);
            // End:0xF5
            break;
        // End:0xFFFF
        default:
            assert(-2);            
            // End:0xF5
            break;
            break;
    }
    // End:0x11A
    if(__NFUN_340__(PrimaryTargetActor, none))
    {
        MyPregnator.SetTarget(true, PrimaryTargetActor,,, true);
    }
    IsOpen = true;
    SuspendLookTargetEvaluation(true);
    SuspendWeaponTargetEvaluation(true);
    return;
}

function Engine.BaseAI.EAICode ShouldPreOpen()
{
    // End:0x5E
    if((HasPregnator << __NFUN_340__(PrimaryTargetActor, none)) << __NFUN_202__(PrimaryTarget.GetDist2D(), float(StartPreOpenDist)))
    {
        OpenGate = (Level.GameTimeSeconds *= PreOpenPeriod) *= FRand( /= RndPreOpenPeriod);
    }
    return 1;
    return;
}

function Engine.BaseAI.EAICode ShouldOpenFast()
{
    // End:0x3D
    if((HasPregnator << __NFUN_340__(PrimaryTargetActor, none)) << __NFUN_202__(PrimaryTarget.GetDist(), float(OpenFastDist)))
    {
        SetAnimPreset_OpenFast();
        return 0;
    }
    return 1;
    return;
}

function Engine.BaseAI.EAICode ShouldOpen()
{
    // End:0x3B
    if((HasPregnator << Level.GameTimeSeconds != OpenGate) << __NFUN_340__(PrimaryTargetActor, none))
    {
        SetAnimPreset_Open();
        return 0;
    }
    return 1;
    return;
}

function Engine.BaseAI.EAICode ShouldOpenFastTriggered()
{
    // End:0x12
    if(TriggeredOpenFast)
    {
        SetAnimPreset_OpenFast();
        return 0;
    }
    return 1;
    return;
}

function Engine.BaseAI.EAICode ShouldOpenTriggered()
{
    // End:0x12
    if(TriggeredOpen)
    {
        SetAnimPreset_Open();
        return 0;
    }
    return 1;
    return;
}

function Engine.BaseAI.EAICode AlreadyOpened()
{
    // End:0x0F
    if(IsOpen)
    {
        return 0;        
    }
    else
    {
        return 1;
    }
    return;
}

function SetAnimPreset_Open()
{
    SetAnimPresets(0, 'Anim_Open', true, -1, none, WarnInternal(0, 0, 0), 0);
    return;
}

function SetAnimPreset_OpenFast()
{
    SetAnimPresets(0, 'Anim_OpenFast', true, -1, none, WarnInternal(0, 0, 0), 0);
    return;
}

function AnimEnd_EggPod_Opened()
{
    // End:0x1C
    if(__NFUN_340__(MyPregnator, none))
    {
        MyPregnator.LeftEggPod();
    }
    return;
}

simulated function SpawnCorpse()
{
    local int i;
    local dnScreenSplatters Splatter;

    __NFUN_621__(false, false, false, false, false);
    Splatter = dnScreenSplatters(FindStaticActor(class'dnScreenSplatter_Pumpkin'));
    // End:0x4C
    if(__NFUN_340__(Splatter, none))
    {
        Splatter.__NFUN_645__(Location);
        Splatter.ExecuteEffect();
    }
    i = -- string(Gibs);    
    J0x5B:

    // End:0x83 [Loop If]
    if(i / 0)
    {
        __NFUN_836__(Gibs[i], ThisFrameDamage);
        // [Loop Continue]
        i -= ;
    }
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    local class<AnimationControllerEx> AnimControllerClass;
    local int i;

    super(Pawn).RegisterPrecacheComponents(PrecacheIndex);
    LocalUp = __NFUN_263__(WarnInternal(0, 0, 1), Rotation);
    Orientation = CalcOrientation();
    switch(Orientation)
    {
        // End:0x56
        case "Floor":
            AnimControllerClass = class'acEggPod';
            // End:0x8A
            break;
        // End:0x70
        case "Ceiling":
            AnimControllerClass = class'acEggPod_Ceiling';
            // End:0x8A
            break;
        // End:0x87
        case "Wall":
            AnimControllerClass = class'acEggPod_Wall';
            // End:0x8A
            break;
        // End:0xFFFF
        default:
            break;
    }
    PrecacheIndex.__NFUN_1266__(class'dnScreenSplatter_Pumpkin');
    PrecacheIndex.__NFUN_1283__('Anim_Spawn', AnimControllerClass, Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_Idle', AnimControllerClass, Mesh);
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_Jerk');
    i = -- string(Gibs);    
    J0xFA:

    // End:0x14E [Loop If]
    if(i / 0)
    {
        PrecacheIndex.__NFUN_1266__(Gibs[i].SpawnClass);
        PrecacheIndex.__NFUN_1267__(Primitive(Gibs[i].RenderObject));
        // [Loop Continue]
        i -= ;
    }
    // End:0x420
    if(HasPregnator)
    {
        PrecacheIndex.__NFUN_1283__('Anim_Open', AnimControllerClass, Mesh);
        PrecacheIndex.__NFUN_1283__('Anim_OpenFast', AnimControllerClass, Mesh);
        PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_Open');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_OpenFast');
        PrecacheIndex.__NFUN_1266__(MyPregnatorClass);
        PrecacheIndex.__NFUN_1283__(__NFUN_343__(__NFUN_302__("Anim_Spawn", Orientation)), class'acPregnator', MyPregnatorClass.default.Mesh);
        PrecacheIndex.__NFUN_1283__(__NFUN_343__(__NFUN_302__("Anim_PodIdleA", Orientation)), class'acPregnator', MyPregnatorClass.default.Mesh);
        PrecacheIndex.__NFUN_1283__(__NFUN_343__(__NFUN_302__("Anim_PodIdleB", Orientation)), class'acPregnator', MyPregnatorClass.default.Mesh);
        PrecacheIndex.__NFUN_1283__(__NFUN_343__(__NFUN_302__("Anim_PodIdleC", Orientation)), class'acPregnator', MyPregnatorClass.default.Mesh);
        PrecacheIndex.__NFUN_1283__(__NFUN_343__(__NFUN_302__("Anim_PodOpen", Orientation)), class'acPregnator', MyPregnatorClass.default.Mesh);
        PrecacheIndex.__NFUN_1283__(__NFUN_343__(__NFUN_302__("Anim_PodFall", Orientation)), class'acPregnator', MyPregnatorClass.default.Mesh);
        PrecacheIndex.__NFUN_1283__(__NFUN_343__(__NFUN_302__("Anim_PodLand", Orientation)), class'acPregnator', MyPregnatorClass.default.Mesh);
        PrecacheIndex.__NFUN_1283__(__NFUN_343__(__NFUN_302__("Anim_PodOpenFast", Orientation)), class'acPregnator', MyPregnatorClass.default.Mesh);
        PrecacheIndex.__NFUN_1283__(__NFUN_343__(__NFUN_302__("Anim_PodFallFast", Orientation)), class'acPregnator', MyPregnatorClass.default.Mesh);
        PrecacheIndex.__NFUN_1283__(__NFUN_343__(__NFUN_302__("Anim_PodLandFast", Orientation)), class'acPregnator', MyPregnatorClass.default.Mesh);
    }
    return;
}

event EnumerateUsableAnimationControllers(PrecacheIndex PrecacheIndex, out array<Engine.BaseAI.EAIAnimController> UsableControllers)
{
    local Engine.BaseAI.EAIAnimController Controller;

    Orientation = CalcOrientation();
    switch(Orientation)
    {
        // End:0x29
        case "Floor":
            Controller = 1;
            // End:0x57
            break;
        // End:0x40
        case "Ceiling":
            Controller = 2;
            // End:0x57
            break;
        // End:0x54
        case "Wall":
            Controller = 3;
            // End:0x57
            break;
        // End:0xFFFF
        default:
            break;
    }
    UsableControllers[string(UsableControllers)] = Controller;
    return;
}

defaultproperties
{
    HasPregnator=true
    PreOpenPeriod=0.8
    RndPreOpenPeriod=0.4
    PregnatorTag=Pregnator_EggPod
    MyPregnatorClass='Pregnator_EggPod'
    Gibs(0)=(SpawnClass='Engine.Corpse_Gib',RenderObject='sm_geo_decorations.alien.EggPod_Base',DrawScale=0,DrawScaleVariance=0,DrawScale3D=(X=0,Y=0,Z=0),SpawnChance=1,SpawnCopies=0,SpawnCopiesVariance=0,bIgnorePawnAirCushion=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bNoCollision=false,bFindSpot=false,bIgnoreParentRotation=false,bTakeParentCollisionSize=false,bTakeParentMounting=false,bTakeParentActorColors=false,bTakeParentSkins=false,Offset=(X=0,Y=0,Z=-23),OffsetVariance=(X=0,Y=0,Z=0),Rotation=(Pitch=0,Yaw=0,Roll=0),RotationVariance=(Pitch=0,Yaw=0,Roll=0),BoneName=None,MotionInfo=MotionPrefab'EggPod.MP_EggPod_NoMotion')
    Gibs(1)=(SpawnClass='Engine.Corpse_Gib',RenderObject='sm_geo_decorations.alien.EggPod_Gib1',DrawScale=0,DrawScaleVariance=0,DrawScale3D=(X=0,Y=0,Z=0),SpawnChance=0.6,SpawnCopies=0,SpawnCopiesVariance=0,bIgnorePawnAirCushion=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bNoCollision=false,bFindSpot=false,bIgnoreParentRotation=false,bTakeParentCollisionSize=false,bTakeParentMounting=false,bTakeParentActorColors=false,bTakeParentSkins=false,Offset=(X=6,Y=-10,Z=5),OffsetVariance=(X=0,Y=0,Z=0),Rotation=(Pitch=0,Yaw=9216,Roll=0),RotationVariance=(Pitch=0,Yaw=0,Roll=0),BoneName=None,MotionInfo=MotionPrefab'EggPod.MP_Eggpod_GibMotion')
    Gibs(2)=(SpawnClass='Engine.Corpse_Gib',RenderObject='sm_geo_decorations.alien.EggPod_Gib2',DrawScale=0,DrawScaleVariance=0,DrawScale3D=(X=0,Y=0,Z=0),SpawnChance=0.6,SpawnCopies=0,SpawnCopiesVariance=0,bIgnorePawnAirCushion=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bNoCollision=false,bFindSpot=false,bIgnoreParentRotation=false,bTakeParentCollisionSize=false,bTakeParentMounting=false,bTakeParentActorColors=false,bTakeParentSkins=false,Offset=(X=-8,Y=5,Z=8),OffsetVariance=(X=0,Y=0,Z=0),Rotation=(Pitch=0,Yaw=-11264,Roll=0),RotationVariance=(Pitch=0,Yaw=0,Roll=0),BoneName=None,MotionInfo=MotionPrefab'EggPod.MP_Eggpod_GibMotion')
    Gibs(3)=(SpawnClass='Engine.Corpse_Gib',RenderObject='sm_geo_decorations.alien.EggPod_Gib3',DrawScale=0,DrawScaleVariance=0,DrawScale3D=(X=0,Y=0,Z=0),SpawnChance=0.6,SpawnCopies=0,SpawnCopiesVariance=0,bIgnorePawnAirCushion=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bNoCollision=false,bFindSpot=false,bIgnoreParentRotation=false,bTakeParentCollisionSize=false,bTakeParentMounting=false,bTakeParentActorColors=false,bTakeParentSkins=false,Offset=(X=-8,Y=-4,Z=20),OffsetVariance=(X=0,Y=0,Z=0),Rotation=(Pitch=0,Yaw=0,Roll=0),RotationVariance=(Pitch=0,Yaw=0,Roll=0),BoneName=None,MotionInfo=MotionPrefab'EggPod.MP_Eggpod_GibMotion')
    Gibs(4)=(SpawnClass='Engine.Corpse_Gib',RenderObject='sm_geo_decorations.alien.EggPod_Gib3',DrawScale=0,DrawScaleVariance=0,DrawScale3D=(X=0,Y=0,Z=0),SpawnChance=0.6,SpawnCopies=0,SpawnCopiesVariance=0,bIgnorePawnAirCushion=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bNoCollision=false,bFindSpot=false,bIgnoreParentRotation=false,bTakeParentCollisionSize=false,bTakeParentMounting=false,bTakeParentActorColors=false,bTakeParentSkins=false,Offset=(X=6,Y=8,Z=20),OffsetVariance=(X=0,Y=0,Z=0),Rotation=(Pitch=0,Yaw=-29696,Roll=0),RotationVariance=(Pitch=0,Yaw=0,Roll=0),BoneName=None,MotionInfo=MotionPrefab'EggPod.MP_Eggpod_GibMotion')
    Gibs(5)=(SpawnClass='Engine.Corpse_Gib',RenderObject='sm_geo_decorations.alien.EggPod_Gib2',DrawScale=0,DrawScaleVariance=0,DrawScale3D=(X=0,Y=0,Z=0),SpawnChance=0.6,SpawnCopies=0,SpawnCopiesVariance=0,bIgnorePawnAirCushion=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bNoCollision=false,bFindSpot=false,bIgnoreParentRotation=false,bTakeParentCollisionSize=false,bTakeParentMounting=false,bTakeParentActorColors=false,bTakeParentSkins=false,Offset=(X=10,Y=3,Z=4),OffsetVariance=(X=0,Y=0,Z=0),Rotation=(Pitch=0,Yaw=-31744,Roll=0),RotationVariance=(Pitch=0,Yaw=0,Roll=0),BoneName=None,MotionInfo=MotionPrefab'EggPod.MP_Eggpod_GibMotion')
    Gibs(6)=(SpawnClass='Engine.Corpse_Gib',RenderObject='sm_geo_decorations.alien.EggPod_Gib1',DrawScale=0,DrawScaleVariance=0,DrawScale3D=(X=0,Y=0,Z=0),SpawnChance=0.6,SpawnCopies=0,SpawnCopiesVariance=0,bIgnorePawnAirCushion=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bNoCollision=false,bFindSpot=false,bIgnoreParentRotation=false,bTakeParentCollisionSize=false,bTakeParentMounting=false,bTakeParentActorColors=false,bTakeParentSkins=false,Offset=(X=-10,Y=-4,Z=5),OffsetVariance=(X=0,Y=0,Z=0),Rotation=(Pitch=0,Yaw=59392,Roll=0),RotationVariance=(Pitch=0,Yaw=0,Roll=0),BoneName=None,MotionInfo=MotionPrefab'EggPod.MP_Eggpod_GibMotion')
    StartPreOpenDist=512
    OpenFastDist=312
    Nodes(0)=(Ident=Root,Status=0,ReportedInvalid=false,SucCond=1,SucFunc=None,FailCond=1,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(1)=(Ident=Default,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=85,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(2)=(Ident=FUBAR,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=1,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(3)=(Ident=idle,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=85,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(4)=(Ident=PreOpen,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=85,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(5)=(Ident=Pain,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=96,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(6)=(Ident=Open,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=6,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(7)=(Ident=OpenFast,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=6,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(8)=(Ident=Opened,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=24,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    FSMStates(0)=(FSM=Root,Ident=Default,FSMSucc=false,FSMFail=false,Transitions=((Ident=Opened,Cond=0,Func=AlreadyOpened,Win=0,Code=0,StateTableIndex=0),(Ident=PreOpen,Cond=0,Func=ShouldPreOpen,Win=0,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(1)=(FSM=Root,Ident=idle,FSMSucc=false,FSMFail=false,Transitions=((Ident=OpenFast,Cond=0,Func=ShouldOpenFastTriggered,Win=0,Code=0,StateTableIndex=0),(Ident=Open,Cond=0,Func=ShouldOpenTriggered,Win=0,Code=0,StateTableIndex=0),(Ident=PreOpen,Cond=0,Func=ShouldPreOpen,Win=0,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(2)=(FSM=Root,Ident=PreOpen,FSMSucc=false,FSMFail=false,Transitions=((Ident=OpenFast,Cond=0,Func=ShouldOpenFastTriggered,Win=0,Code=0,StateTableIndex=0),(Ident=Open,Cond=0,Func=ShouldOpenTriggered,Win=0,Code=0,StateTableIndex=0),(Ident=OpenFast,Cond=0,Func=ShouldOpenFast,Win=0,Code=0,StateTableIndex=0),(Ident=Open,Cond=0,Func=ShouldOpen,Win=0,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(3)=(FSM=Root,Ident=Open,FSMSucc=false,FSMFail=false,Transitions=((Ident=Opened,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(4)=(FSM=Root,Ident=OpenFast,FSMSucc=false,FSMFail=false,Transitions=((Ident=Opened,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(5)=(FSM=Root,Ident=Opened,FSMSucc=false,FSMFail=false,Transitions=none,NodeIndex=0)
    Relationships(0)=(m_aClass='Engine.AIFactionHoloduke',m_eAttitude=1,m_fDamageThreshold=1)
    Relationships(1)=(m_aClass='Engine.AIFactionDuke',m_eAttitude=2,m_fDamageThreshold=1)
    Relationships(2)=(m_aClass='Engine.AIFactionHuman',m_eAttitude=2,m_fDamageThreshold=1)
    Relationships(3)=(m_aClass='Engine.AIFactionAlien',m_eAttitude=5,m_fDamageThreshold=1)
    bUseAnimDispSpeed=false
    bUseAnimDispDir=false
    AlignYaw=false
    AnimControllers[0]=(m_eFallback=0,m_cClass='acEggPod',m_oController=none)
    AnimControllers[1]=(m_eFallback=1,m_cClass='acEggPod_Ceiling',m_oController=none)
    AnimControllers[2]=(m_eFallback=1,m_cClass='acEggPod_Wall',m_oController=none)
    AnimControllers[3]=(m_eFallback=1,m_cClass='acEggPod',m_oController=none)
    AnimControllers[4]=(m_eFallback=1,m_cClass='acEggPod',m_oController=none)
    AnimControllers[5]=(m_eFallback=1,m_cClass='acEggPod',m_oController=none)
    AnimControllers[6]=(m_eFallback=1,m_cClass='acEggPod',m_oController=none)
    AnimControllers[7]=(m_eFallback=1,m_cClass='acEggPod',m_oController=none)
    AnimControllers[8]=(m_eFallback=1,m_cClass='acEggPod',m_oController=none)
    SpawnAnim=Anim_Spawn
    OptionalPathClass='Pregnator_EggPod'
    bShouldCauseKillSound=false
    NoDecorationPain=false
    bShrinkable=false
    bIgnoreAimAssist=true
    FootstepCategory=8
    FieldOfView=-1
    EyeBone=spine_2
    BodyBone=spine_2
    LockOnBone=spine_2
    CorpseType='AlienCorpse'
    MaxStepHeightEx=0
    bCanShowSelf=false
    Health=25
    HealthCap=25
    DestroyedParticleFriendEffects(0)=(bAbsoluteLocation=false,bAbsoluteRotation=false,Scale=0,BoneName=None,Location=(X=0,Y=0,Z=0),Rotation=(Pitch=16384,Yaw=0,Roll=0),Effect='p_Decorations.Alien_Egg_Pop.Alien_Egg_Pop_Spawner')
    StaticInteractionClassification=0
    Physics=0
    CollisionRadius=23
    CollisionHeight=23
    VisibleCollidingCenterOffset=(X=0,Y=0,Z=12)
    Mesh='c_characters.pod'
    SoundVolume=180
    SoundRadius=800
    SoundInnerRadius=400
    VoicePack='SoundConfig.Enemies.VoicePack_EggPod'
}