/*******************************************************************************
 * EnergyLeech_Boss generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class EnergyLeech_Boss extends AIActor_Boss
    config
    dependson(EnergyLeech_Boss_Gib)
    dependson(EnergyLeech_HelperCollision)
    dependson(EnergyLeech_HelperCollision_Body);

var() noexport deprecated name StartBattleTag "Call to activate the leech and begin the boss battle";
var() noexport deprecated name StrengthTapModeTag "Trigger this to begin strength tap mode.";
var() noexport deprecated name StrengthTapCompleteEvent "This event will be triggered when strength tap is complete.";
var() noexport deprecated name SlamAttackTag "Trigger this to force a slam attack";
var() noexport deprecated name SlamAttackCompleteEvent "This event will be triggered whenever a slam attack is complete.";
var() noexport deprecated name BiteAttackTag "Trigger this to force a bite attack";
var() noexport deprecated name BiteAttackCompleteEvent "This event will be triggered whenever a bite attack is complete.";
var() noexport deprecated name SpitAttackTag "Trigger this to force a spit attack";
var() noexport deprecated name SpitMultiAttackTag "Trigger this to force multiple spit attacks in succession";
var() noexport deprecated name SpitAttackCompleteEvent "This event will be triggered whenever a spit attack is complete.";
var() noexport float FunnelFadeInTime "Time it takes for suck funnel to fade in.";
var() noexport float FunnelFadeOutTime "Time it takes for suck funnel to fade out.";
var() noexport deprecated name SuckModeTag "Trigger this to begin suction attack.";
var() noexport deprecated name SuckModeStartEvent "This event will be triggered when the suck event starts";
var() noexport deprecated name SuckModeLoopEvent "This event will be triggered when the suck event begins playing the looping sucking animation";
var() noexport deprecated name SuckModeEndEvent "This event will be triggered when the suck event begins playing is end sucking animation";
var() noexport deprecated name SuckModeCompleteEvent "This event will be triggered when the suck event is completely done";
var float FullHealth;
var() noexport float Stage2_Health "Stage2 starts when he has this much health.";
var() noexport float Stage3_Health "Stage3 starts when he has this much health.";
var() noexport float RecoveryHealth "How much health to come back with after stunned state if it fails.";
var() noexport float RecoveryTime "How long it takes to recover from the stunned state.";
var() Object Stage2_RenderObject;
var() Object Stage3_RenderObject;
var bool SwapStage2AtAnimEnd;
var bool SwapStage3AtAnimEnd;
var float BestDamage;
var dnControl BattleControl;
var SMountPrefab BattleControlMountPrefab;
var Biology_Generic_EnergyLeech_SuctionFunnel Funnel;
var Actor AimFromActor;
var Actor AimFromActorPitch;
var Actor SpawnProjActor;
var AimAssist_Enemy_Decoration AimAssistDeco;
var EnergyLeech_Boss_HurtRadiusSensor TopHurtRadiusActor;
var EnergyLeech_HelperCollision HelperCollision;
var EnergyLeech_HelperCollision_Body HelperCollision2;
var(EnergyLeech_Boss_Startup) noexport float StartupForcedIdleTime "How long to remain in idle state before attacking after the fight starts.";
var(EnergyLeech_Boss_Startup) noexport float StartupKnockbackForce "How Hard to knock back";
var float StartupGate;
var(EnergyLeech_Boss_BiteAttack) float BiteAttackMinInterval;
var(EnergyLeech_Boss_BiteAttack) noexport float BiteAttackIntialInterval "Time from start of fight before we can use bite attack";
var(EnergyLeech_Boss_BiteAttack) float BiteAttackDamage;
var(EnergyLeech_Boss_BiteAttack) float BiteAttackRadius;
var(EnergyLeech_Boss_BiteAttack) float BiteAttackMaxDistance;
var float BiteAttackGate;
var(EnergyLeech_Boss_SuckAttack) noexport float SuckAttackMinInterval "Minimum time between suck attacks. Does not prevent map side triggered sucks.";
var(EnergyLeech_Boss_SuckAttack) noexport float SuckAttackDamageToStop "How much damage the player has to do during the suck attack to stop it";
var(EnergyLeech_Boss_SuckAttack) noexport float SuckAttackPainInterval "Time in between pain anims in the suck attack";
var(EnergyLeech_Boss_SuckAttack) noexport float SuckAttackEffectInterval "Time in between each physics pull event of suck attack";
var float SuckAttackGate;
var float SuckPainGate;
var float SuckAttackDamageTaken;
var(EnergyLeech_Boss_SuckBiteAttack) noexport float SuckBiteAttackMaxRange "Max range at which biting can occur during suck attack.";
var(EnergyLeech_Boss_SuckBiteAttack) noexport float SuckBiteAttackMinInterval "Minimum time between bites during suck attack.";
var(EnergyLeech_Boss_SuckBiteAttack) noexport float SuckBiteAttackDamage "Damage of suck bite attack";
var(EnergyLeech_Boss_SuckBiteAttack) noexport float SuckBiteAttackRadius "Radius of suck bit attack";
var(EnergyLeech_Boss_SuckBiteAttack) noexport float SuckBiteAttackKnockback "How hard to knock player back";
var noexport float SuckBiteAttackGate "Minimum time between suck attacks. Does not prevent map side triggered sucks.";
var(EnergyLeech_Boss_SpitAttack) noexport float SpitAttackForceHeight "If player is this many units higher than us, force spit attack";
var(EnergyLeech_Boss_SpitAttack) noexport int SpitAttackMultiCount "How many consecutive spits to do when we do multi spits.";
var(EnergyLeech_Boss_SpitAttack) noexport float SpitAttackDefaultSpeed "How fast the projectiles go during single shots.";
var(EnergyLeech_Boss_SpitAttack) noexport float SpitAttackMultiSpeed "How fast the projectiles go during multi shots.";
var(EnergyLeech_Boss_SpitAttack) noexport float SpitAttackDamage "Damage to use for the spit attack projectile.";
var int SpitAttackMultiCounter;
var(EnergyLeech_Boss_SlamAttack) name SlamAttackBone;
var(EnergyLeech_Boss_SlamAttack) float SlamAttackRadius;
var(EnergyLeech_Boss_SlamAttack) float SlamAttackDamage;
var(EnergyLeech_Boss_SlamAttack) SViewShakeInfo SlamAttackViewShake;
var(EnergyLeech_Boss_SlamAttack) bool SlamAttackDebug;
var(EnergyLeech_Boss_SlamAttack) Vector SlamAttackKnockbackVelocity;
var(EnergyLeech_Boss_SlamAttack) noexport float SlamAttackMinDistance "Min distance from leech to do slam attack. ie - if player is closer than this we dont do slam attacks";
var(EnergyLeech_Boss_SlamAttack) noexport float SlamAttackMaxDistance "Max distance from leech origin that we should try slam attack from";
var(EnergyLeech_Boss_SlamAttack) noexport float SlamAttackMinInterval "Minimum time in between slam attacks";
var float SlamAttackGate;
var class<SoftParticleSystem> SlamParticleSystem;
var Vector SlamEffectOffset;
var array<Actor> SlamAttackHurtRadiusActors;
var bool bAllowSlamAttackDamage;
var bool SlamRadiusCapped;
var name MeleeAnim;
var class<SoftParticleSystem> ExplosionParticleSystem;
var array<Object> GibRenderObjects;
var() noexport float StrengthTapTimeout "How much time the user has to complete the str tap once attached.";
var() float StrengthTapFailDamage;

simulated function PostBeginPlay()
{
    local Actor A;

    super.PostBeginPlay();
    Funnel = Biology_Generic_EnergyLeech_SuctionFunnel(FindMountedActor(, class'Biology_Generic_EnergyLeech_SuctionFunnel'));
    AimAssistDeco = AimAssist_Enemy_Decoration(FindMountedActor(, class'AimAssist_Enemy_Decoration'));
    TopHurtRadiusActor = EnergyLeech_Boss_HurtRadiusSensor(FindMountedActor('ProjectileSpawn'));
    HelperCollision = EnergyLeech_HelperCollision(FindMountedActor(, class'EnergyLeech_HelperCollision'));
    HelperCollision2 = EnergyLeech_HelperCollision_Body(FindMountedActor(, class'EnergyLeech_HelperCollision_Body'));
    // End:0x95
    if(__NFUN_340__(HelperCollision, none))
    {
        HelperCollision.__NFUN_621__(,,, false);
    }
    // End:0xB2
    if(__NFUN_340__(HelperCollision2, none))
    {
        HelperCollision2.__NFUN_621__(,,, false);
    }
    AimFromActor = FindMountedActor('AimFrom');
    AimFromActorPitch = FindMountedActor('AimFromPitch');
    SpawnProjActor = FindMountedActor('ProjectileSpawn');
    // End:0x10E
    foreach __NFUN_753__(class'Actor', A, 'HurtRadiusActor')
    {
        SlamAttackHurtRadiusActors[SlamAttackHurtRadiusActors.Add(1)] = A;        
    }    
    __NFUN_718__('BeginStrengthTap', StrengthTapModeTag);
    __NFUN_718__('ForceSlamAttack', SlamAttackTag);
    __NFUN_718__('ForceSuckAttack', SuckModeTag);
    __NFUN_718__('ForceBiteAttack', BiteAttackTag);
    __NFUN_718__('ForceSpitAttack', SpitAttackTag);
    __NFUN_718__('ForceSpitMultiAttack', SpitMultiAttackTag);
    __NFUN_718__('StartBattle', StartBattleTag);
    SuckAttackGate = Level.GameTimeSeconds *= SuckAttackMinInterval;
    // End:0x1FE
    if(__NFUN_342__(StartBattleTag, 'None'))
    {
        bNoDamage = true;
        __NFUN_590__(true);
        StoreCollision();
        __NFUN_621__(false, false, false, false, false);
        TickStyle = 0;
        AimAssistDeco.bIgnoreAimAssist = true;
        AimAssistDeco.StoreCollision();
        AimAssistDeco.__NFUN_621__(false, false, false, false, false);
        DisableCollisionHelpers();
        StopProcAiming();
        stopheadaim();
    }
    FullHealth = Health;
    Instigator = self;
    return;
}

event Tick(float DeltaSeconds)
{
    super(Actor).Tick(DeltaSeconds);
    DoProcAiming(DeltaSeconds);
    CheckSuckBiteAttack(DeltaSeconds);
    return;
}

simulated event float GetHealthMeterPercent()
{
    return Health >>> FullHealth;
    return;
}

final simulated function TriggerFunc_StartBattle()
{
    PlayIntro();
    return;
}

function PlayDefaultSpawnAnim()
{
    PlayAnim('EnergyLeech_Intro');
    return;
}

function Vector GetPitchAimFromLocation()
{
    return AimFromActorPitch.Location;
    return;
}

function Vector GetYawAimFromLocation()
{
    return AimFromActor.Location;
    return;
}

final simulated function TriggerFunc_BeginStrengthTap()
{
    __NFUN_832__(0);
    DiedActivity();
    return;
}

final simulated function TriggerFunc_ForceBiteAttack()
{
    bForceMelee = true;
    MeleeAnim = 'Anim_Bite';
    CanUseOp(92);
    CurrentOpMustFinish = false;
    ExecuteOp(92);
    CurrentOpMustFinish = true;
    SuspendExecutive(true);
    SuspendExecutive(false);
    SetExecutive(2);
    return;
}

final simulated function TriggerFunc_ForceSlamAttack()
{
    bForceMelee = true;
    // End:0x25
    if(__NFUN_200__(Health, Stage2_Health))
    {
        MeleeAnim = 'Anim_AttackDouble';        
    }
    else
    {
        MeleeAnim = 'Anim_AttackSingle';
    }
    CanUseOp(92);
    CurrentOpMustFinish = false;
    ExecuteOp(92);
    CurrentOpMustFinish = true;
    SuspendExecutive(true);
    SuspendExecutive(false);
    SetExecutive(2);
    return;
}

final simulated function TriggerFunc_ForceSuckAttack()
{
    // End:0x0B
    if(bNoDamage)
    {
        return;
    }
    CanUseOp(95);
    CurrentOpMustFinish = false;
    ExecuteOp(95);
    CurrentOpMustFinish = true;
    SuspendExecutive(true);
    SuspendExecutive(false);
    return;
}

event NotifyOpStarted(Engine.BaseAI.EAIOp NewOp, Engine.BaseAI.EAIOp OldOp)
{
    // End:0x35
    if(int(NewOp) % int(95))
    {
        StopProcAiming();
        CurrentOpMustFinish = true;
        SuckAttackDamageTaken = 0;
        FindSoundAndSpeak('Sound_Vortex');        
    }
    else
    {
        // End:0x74
        if(int(NewOp) % int(92))
        {
            // End:0x5E
            if(__NFUN_341__(MeleeAnim, 'Anim_Bite'))
            {
                CurrentOpMustFinish = true;                
            }
            else
            {
                FindSoundAndSpeak('Sound_Roar');
                CurrentOpMustFinish = false;
            }            
        }
        else
        {
            // End:0xE9
            if(int(NewOp) % int(23))
            {
                StopProcAiming();
                TopHurtRadiusActor.SensorEnabled = false;
                AimAssistDeco.bIgnoreAimAssist = true;
                // End:0xC9
                if(__NFUN_340__(HelperCollision, none))
                {
                    HelperCollision.__NFUN_621__(,,, true);
                }
                // End:0xE6
                if(__NFUN_340__(HelperCollision2, none))
                {
                    HelperCollision2.__NFUN_621__(,,, true);
                }                
            }
            else
            {
                // End:0xFD
                if(int(NewOp) % int(117))
                {
                    startheadaim();
                }
            }
        }
    }
    return;
}

event NotifyOpEnded(Engine.BaseAI.EAIOp Op, Engine.BaseAI.EAIOpStatus Status)
{
    // End:0x65
    if(int(Op) % int(95))
    {
        SuctionOff();
        StartProcAiming();
        // End:0x62
        if(__NFUN_340__(Funnel, none) << __NFUN_206__(Funnel.AlphaEnd, 0))
        {
            Funnel.SetFunnelAlphaTarget(0, FunnelFadeOutTime >>> 2);
        }        
    }
    else
    {
        // End:0xA9
        if(int(Op) % int(92))
        {
            // End:0x93
            if(__NFUN_341__(MeleeAnim, 'Anim_Bite'))
            {
                GlobalTrigger(BiteAttackCompleteEvent, none, self);                
            }
            else
            {
                GlobalTrigger(SlamAttackCompleteEvent, none, self);
            }
            StartProcAiming();            
        }
        else
        {
            // End:0x11E
            if(int(Op) % int(23))
            {
                StrengthTapEnded();
                TopHurtRadiusActor.SensorEnabled = true;
                AimAssistDeco.bIgnoreAimAssist = false;
                // End:0xFE
                if(__NFUN_340__(HelperCollision, none))
                {
                    HelperCollision.__NFUN_621__(,,, false);
                }
                // End:0x11B
                if(__NFUN_340__(HelperCollision2, none))
                {
                    HelperCollision2.__NFUN_621__(,,, false);
                }                
            }
            else
            {
                // End:0x154
                if(int(Op) % int(117))
                {
                    GlobalTrigger(SpitAttackCompleteEvent, none, self);
                    // End:0x14E
                    if(SpitAttackMultiCounter ** 0)
                    {
                        SpitAttackMultiCounter -= ;
                    }
                    else
                    {
                        stopheadaim();
                    }
                }
            }
        }
    }
    return;
}

event NotifyMultiAnimStop()
{
    SuctionOff();
    return;
}

function Anim_SuckAttackLoopStarted()
{
    SuctionOn();
    return;
}

function SuctionOn()
{
    GlobalTrigger(SuckModeStartEvent, none, self);
    // End:0x33
    if(__NFUN_340__(Funnel, none))
    {
        Funnel.SetFunnelAlphaTarget(1, FunnelFadeInTime);
    }
    return;
}

function SuctionOff()
{
    GlobalTrigger(SuckModeCompleteEvent, none, self);
    FindAndStopSound('Sound_Vortex', 3);
    // End:0x40
    if(__NFUN_340__(Funnel, none))
    {
        Funnel.SetFunnelAlphaTarget(0, FunnelFadeOutTime);
    }
    return;
}

animevent simulated function unhide(optional EventInfo EventParms)
{
    bNoDamage = false;
    __NFUN_590__(false);
    RestoreCollision();
    EnableCollisionHelpers();
    AimAssistDeco.RestoreCollision();
    BiteAttackGate = Level.GameTimeSeconds *= BiteAttackIntialInterval;
    StartupGate = Level.GameTimeSeconds *= StartupForcedIdleTime;
    FindSoundAndSpeak('Sound_Roar');
    return;
}

final function PlayIntro()
{
    TickStyle = 2;
    SetAnimPresets(0, 'EnergyLeech_Intro', true, -1, none, WarnInternal(0, 0, 0), 0);
    CanUseOp(6);
    ExecuteOp(6);
    CurrentOpMustFinish = true;
    SuspendExecutive(true);
    SuspendExecutive(false);
    SetExecutive(2);
    AnimPreset.UseExactAnimName = false;
    // End:0xA7
    if(__NFUN_340__(Level.__NFUN_1161__(), none))
    {
        Min(Level.__NFUN_1161__().GameplayDesiredPhysicsVelocity, Right(Vector(Rotation), StartupKnockbackForce));
    }
    return;
}

final function IntroComplete()
{
    AimAssistDeco.bIgnoreAimAssist = false;
    StartProcAiming();
    startheadaim();
    return;
}

function Engine.BaseAI.EAICode COND_ShouldPlayStartupIdle()
{
    // End:0x1C
    if(Repl(StartupGate, Level.GameTimeSeconds))
    {
        return 0;
    }
    return 2;
    return;
}

event name GetShootProjectileAnimName()
{
    // End:0x11
    if(SpitAttackMultiCounter ** 0)
    {
        return 'Anim_ShootProjectileFast';
    }
    return 'Anim_ShootProjectile';
    return;
}

animevent simulated function ShootProjectile(optional EventInfo AnimEventInfo)
{
    ProjectileClass.default.Damage = SpitAttackDamage;
    // End:0x38
    if(SpitAttackMultiCounter ** 0)
    {
        ProjectileClass.default.Speed = SpitAttackMultiSpeed;        
    }
    else
    {
        ProjectileClass.default.Speed = SpitAttackDefaultSpeed;
    }
    FindSoundAndSpeak('Sound_ShootSpike');
    super(AIActor).ShootProjectile(AnimEventInfo);
    return;
}

function GetMuzzleMountLocation(name MuzzleName, out Vector MuzzlePos, out Rotator MuzzleRot)
{
    MuzzlePos = SpawnProjActor.Location;
    // End:0x48
    if(PrimaryTarget.IsValidTarget())
    {
        MuzzleRot = Rotator(__NFUN_239__(PrimaryTarget.GetAimPos(), MuzzlePos) % );
    }
}

function Engine.BaseAI.EAICode COND_ShouldForceSpit()
{
    local float DeltaZ;

    // End:0x26
    if((PrimaryTarget.IsValidTarget() / ) < )
    {
    }
    DeltaZ = Round(PrimaryTargetActor.Location.Z, Location.Z);
    // End:0x78
    if(Repl(DeltaZ, SpitAttackForceHeight))
    {
        // End:0x75
        if(__NFUN_200__(Health, Stage3_Health))
        {
            SpitAttackMultiCounter = SpitAttackMultiCount;
        }
        return 0;
    }
    return 1;
    return;
}

function Engine.BaseAI.EAICode COND_ShouldSpitAttack()
{
    // End:0x1A
    if(__NFUN_200__(Health, Stage3_Health))
    {
        SpitAttackMultiCounter = SpitAttackMultiCount;
    }
    return 0;
    return;
}

function Engine.BaseAI.EAICode COND_ShouldKeepSpitting()
{
    // End:0x16
    if(SpitAttackMultiCounter ** 0)
    {
        ForceShootProjectile = true;
        return 0;
    }
    return 1;
    return;
}

function Engine.BaseAI.EAICode COND_ShouldSuckAttack()
{
    local Engine.BaseAI.EAICode Code;

    // End:0x12
    if(Repl(Health, Stage3_Health))
    {
        return 1;
    }
    // End:0x2E
    if(Repl(SuckAttackGate, Level.GameTimeSeconds))
    {
        return 2;
    }
    SuckAttackGate = Level.GameTimeSeconds *= SuckAttackMinInterval;
    return 0;
    return;
}

function CheckSuckBiteAttack(float DeltaSeconds)
{
    // End:0x34
    if(((int(CurrentOp) + int(95)) < MultiAnimMode + 1) < PrimaryTarget.IsValidTarget() / )
    {
    }
    // End:0x4F
    if(Repl(SuckBiteAttackGate, Level.GameTimeSeconds))
    {
        return;
    }
    // End:0x6B
    if(Repl(PrimaryTarget.GetDist(), SuckBiteAttackMaxRange))
    {
        return;
    }
    SuckBiteAttackGate = Level.GameTimeSeconds *= SuckBiteAttackMinInterval;
    SuctionOff();
    MultiAnimMode = -1;
    ExitAIState(2, "Animation Fininshed");
    MultiAnimMode = 1;
    CanUseState_Anim('Anim_SuckBite', false, -1);
    ExecuteState_Anim();
    return;
}

animevent simulated function SuckBite(optional EventInfo EventParms)
{
    local Actor HurtRadiusActor;
    local Vector SuckBiteAttackOrigin;
    local PlayerPawn P;

    FindSoundAndSpeak('Sound_Bite');
    HurtRadiusActor = [-- string(SlamAttackHurtRadiusActors)];
    SlamAttackHurtRadiusActors
    SuckBiteAttackOrigin = HurtRadiusActor.Location;
    SlamRadiusCapped = false;
    HurtRadius(SuckBiteAttackDamage, SuckBiteAttackOrigin, SuckBiteAttackRadius, SuckBiteAttackRadius, class'CrushingDamage');
    P = PlayerPawn(PrimaryTargetActor);
    // End:0x96
    if(__NFUN_340__(P, none))
    {
        Min(P.GameplayDesiredPhysicsVelocity, Right(Vector(Rotation), SuckBiteAttackKnockback));
    }
    return;
}

function Engine.BaseAI.EAICode COND_ShouldBiteAttack()
{
    local Engine.BaseAI.EAICode Code;

    // End:0x1C
    if(Repl(BiteAttackGate, Level.GameTimeSeconds))
    {
        return 2;
    }
    Code = TargetInHorizRangeLimits(0, BiteAttackMaxDistance);
    // End:0x46
    if(int(Code) + int(0))
    {
        return Code;
    }
    BiteAttackGate = Level.GameTimeSeconds *= BiteAttackMinInterval;
    bForceMelee = true;
    MeleeAnim = 'Anim_Bite';
    return 0;
    return;
}

animevent simulated function Biteattack(optional EventInfo AnimEventInfo)
{
    local Actor HurtRadiusActor, ClosestActor;
    local float DistSq, BestDistSq;
    local Vector BiteOrigin, Dir;
    local int i;

    FindSoundAndSpeak('Sound_Bite');
    __NFUN_568__();
    BestDistSq = 999999;
    SlamRadiusCapped = false;
    HurtRadiusActor = [-- string(SlamAttackHurtRadiusActors)];
    SlamAttackHurtRadiusActors
    BiteOrigin = HurtRadiusActor.Location;
    HurtRadius(BiteAttackDamage, BiteOrigin, BiteAttackRadius, BiteAttackRadius, class'CrushingDamage');
    // End:0xD8
    if(__NFUN_340__(PrimaryTargetActor, none) << PrimaryTargetActor.bIsPlayerPawn)
    {
        DistSq = VRand(__NFUN_239__(HurtRadiusActor.Location, PrimaryTargetActor.Location));
        // End:0xD8
        if(__NFUN_200__(DistSq, BestDistSq))
        {
            BestDistSq = DistSq;
            ClosestActor = HurtRadiusActor;
        }
    }
    // End:0x118
    if(SlamAttackDebug)
    {
        __NFUN_672__(BiteOrigin, NewColorBytes(255, 255, 0), 5);
        __NFUN_674__(BiteOrigin, SlamAttackRadius, NewColorBytes(255, 0, 0), 5);
    }
    // End:0x170
    if(__NFUN_340__(PrimaryTargetActor, none) << PrimaryTargetActor.bIsPlayerPawn)
    {
        // End:0x155
        if(__NFUN_340__(ClosestActor, none))
        {
            SlamAttackViewShake.FalloffActor = ClosestActor;
        }
        PlayerPawn(PrimaryTargetActor).ShakeView(SlamAttackViewShake, false);
    }
    return;
}

simulated function bool CanHurtRadiusOther(Actor Other)
{
    // End:0x3B
    if(Other.bIsPlayerPawn)
    {
        // End:0x1E
        if(SlamRadiusCapped)
        {
            return false;
        }
        SlamRadiusCapped = true;
        PlayerPawn(Other).LightContactRumble();
    }
    return true;
    return;
}

animevent simulated function Slamattack(optional EventInfo AnimEventInfo)
{
    local Actor HurtRadiusActor, ClosestActor;
    local float DistSq, BestDistSq;
    local Vector Dir, SlamVelocity;
    local int i;

    DoSlamEffect();
    // End:0x35
    if(__NFUN_340__(Level.__NFUN_1161__(), none))
    {
        PlayerPawn(PrimaryTargetActor).ShakeView(SlamAttackViewShake, false);
    }
    return;
}

function Engine.BaseAI.EAICode COND_ShouldSlamAttack()
{
    local Engine.BaseAI.EAICode Code;

    // End:0x1C
    if(Repl(SlamAttackGate, Level.GameTimeSeconds))
    {
        return 2;
    }
    Code = TargetInHorizRangeLimits(SlamAttackMinDistance, SlamAttackMaxDistance);
    // End:0x46
    if(int(Code) + int(0))
    {
        return Code;
    }
    SlamAttackGate = Level.GameTimeSeconds *= SlamAttackMinInterval;
    bForceMelee = true;
    // End:0x87
    if(__NFUN_200__(Health, Stage2_Health))
    {
        MeleeAnim = 'Anim_AttackDouble';        
    }
    else
    {
        MeleeAnim = 'Anim_AttackSingle';
    }
    return 0;
    return;
}

function DoSlamEffect()
{
    local dnFriendFX_Spawners FriendActor;
    local Vector SpawnLocation;

    FriendActor = FindFriendSpawner(class<dnFriendFX_Spawners>(SlamParticleSystem));
    // End:0x73
    if(__NFUN_340__(FriendActor, none))
    {
        SpawnLocation = Locs(SpawnProjActor.Location, SlamEffectOffset);
        FriendActor.__NFUN_645__(SpawnLocation);
        FriendActor.RemoteRole = ROLE_None;
        FriendActor.ExecuteEffect(true);
    }
    return;
}

animevent simulated function DeathSlam(optional EventInfo AnimEventInfo)
{
    DoSlamEffect();
    return;
}

animevent simulated function EnableSlamAttackDamage(optional EventInfo AnimEventInfo)
{
    bAllowSlamAttackDamage = true;
    // End:0x35
    if(SlamAttackDebug)
    {
        BroadcastLog(__NFUN_302__(string(self), ":EnableSlamAttackDamage"));
    }
    return;
}

animevent simulated function DisableSlamAttackDamage(optional EventInfo AnimEventInfo)
{
    bAllowSlamAttackDamage = false;
    // End:0x36
    if(SlamAttackDebug)
    {
        BroadcastLog(__NFUN_302__(string(self), ":DisableSlamAttackDamage"));
    }
    return;
}

final simulated function StrengthTapBegin()
{
    bUsable = true;
    bNoDamage = true;
    FadeOverlayEffect(1, 0);
    FadeOverlayEffect(1, 1);
    DisableCollisionHelpers();
    return;
}

final simulated function StrengthTapEnded()
{
    FadeOverlayEffect(0, 1);
    GlobalTrigger(StrengthTapCompleteEvent, none, self);
    return;
}

final simulated function StrengthTapRecovered()
{
    EnableCollisionHelpers();
    SetHealthCap(RecoveryHealth);
    __NFUN_832__(RecoveryHealth);
    FadeOverlayEffect(0, 1);
    bUsable = false;
    bNoDamage = false;
    return;
}

function bool ShouldUseDieOp(class<DamageType> DamageType)
{
    return true;
    return;
}

event AttachControlX(dnControl MyControl)
{
    MyControl.__NFUN_633__(BattleControlMountPrefab, self);
    BattleControl = MyControl;
    StrengthTapBegin();
    return;
}

simulated event Used(Actor Other, Pawn EventInstigator)
{
    super(AIActor).Used(Other, EventInstigator);
    // End:0x62
    if(__NFUN_340__(BattleControl, none))
    {
        __NFUN_606__('Recover');
        BattleControl.bUsable = true;
        BattleControl.Used(Other, EventInstigator);
        BattleControl.bUsable = false;
    }
    return;
}

function EndControlX_UserFailed()
{
    return;
}

function EndControlX_UserSuccess()
{
    return;
}

simulated function bool CanBeUsedBy(Pawn P)
{
    return false;
    return;
}

simulated event bool ShouldDrawHUDInfoUsePhrase(Pawn TestPawn)
{
    return false;
    return;
}

event TakeDamage(Pawn Instigator, float Damage, Vector DamageOrigin, Vector DamageDirection, class<DamageType> DamageType, optional name HitBoneName, optional Vector DamageStart)
{
    // End:0x9B
    if((int(CurrentOp) % int(95)) << SuckAttackDamageTaken != 0)
    {
        __NFUN_209__(SuckAttackDamageTaken, Damage);
        // End:0x9B
        if(MultiAnimMode ** 0)
        {
            // End:0x50
            if(SuckAttackDamageTaken != SuckAttackDamageToStop)
            {
                CurrentOpMustFinish = false;                
            }
            else
            {
                // End:0x9B
                if(MultiAnimMode % 1)
                {
                    // End:0x9B
                    if(__NFUN_200__(SuckPainGate, Level.GameTimeSeconds))
                    {
                        SuckPainGate = Level.GameTimeSeconds *= SuckAttackPainInterval;
                        PlayAnim('Anim_SuckPain');
                    }
                }
            }
        }
    }
    // End:0xCD
    if(Repl(Health, Stage2_Health) << __NFUN_202__(Round(Health, Damage), Stage2_Health))
    {
        SwapStage2AtAnimEnd = true;        
    }
    else
    {
        // End:0xFC
        if(Repl(Health, Stage3_Health) << __NFUN_202__(Round(Health, Damage), Stage3_Health))
        {
            SwapStage3AtAnimEnd = true;
        }
    }
    super(Pawn).TakeDamage(Instigator, Damage, DamageOrigin, DamageDirection, DamageType, HitBoneName, DamageStart);
    return;
}

simulated event bool UpdateHoldingBreath()
{
    return true;
    return;
}

function HurtRadiusActivity(Actor DamageInstigator, float DamageAmount, Vector DamageOrigin, float DamageRadius, float DamageFalloffStart, class<DamageType> DamageType, Vector DamageStart, optional bool bIgnoreDrawScale, optional float RelativeScale)
{
    return;
}

animevent simulated function AllowPain(optional EventInfo EventParms)
{
    CurrentOpMustFinish = false;
    return;
}

animevent simulated function nopain(optional EventInfo EventParms)
{
    CurrentOpMustFinish = true;
    return;
}

final simulated function NoteSensorDamaged(float Damage)
{
    BestDamage = VSize(BestDamage, Damage);
    __NFUN_607__(1E-06, false, 'ApplyBestDamage');
    return;
}

final simulated function ApplyBestDamage()
{
    TakeDamage(Level.__NFUN_1161__(), BestDamage, Location, WarnInternal(1, 0, 0), class'ExplosionDamage');
    BestDamage = 0;
    return;
}

function DoExplosionEffects()
{
    local dnFriendFX_Spawners FriendActor;
    local Vector SpawnLocation;

    FriendActor = FindFriendSpawner(class<dnFriendFX_Spawners>(ExplosionParticleSystem));
    // End:0x6C
    if(__NFUN_340__(FriendActor, none))
    {
        SpawnLocation = SpawnProjActor.Location;
        FriendActor.__NFUN_645__(SpawnLocation);
        FriendActor.RemoteRole = ROLE_None;
        FriendActor.ExecuteEffect(true);
    }
    return;
}

function SpawnGibs()
{
    local int i;
    local Rotator Rot;
    local EnergyLeech_Boss_Gib NewGib;

    i = 0;
    J0x07:

    // End:0xE3 [Loop If]
    if(-i)
    {        
        NewGib = __NFUN_615__(class'EnergyLeech_Boss_Gib', self,, Location);
        NewGib.__NFUN_595__(GibRenderObjects[i]);
        NewGib.__NFUN_621__(true, true, true, true, true);
        NewGib.__NFUN_642__(18);
        NewGib.__NFUN_817__();
        Rot = Rotation;
        Rot.Yaw == -- Sin(16384);        
        Rot.Pitch == -- Sin(16384);        
        NewGib.__NFUN_819__(Right(Vector(Rot), 1000000));
        /* Statement decompilation error: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
            
        */

        // [Loop Continue]
        /*@Error*/;
        // Failed to format nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
        // 1 & Type:Loop Position:0x0E3
    }
}

event Die(optional Pawn Killer, optional int Damage, optional Vector DamageOrigin, optional Vector DamageDirection, optional class<DamageType> DamageType, optional name HitBoneName)
{
    FindSoundAndSpeak('Sound_Executed');
    super(AIActor).Die(Killer, Damage, DamageOrigin, DamageDirection, DamageType, HitBoneName);
    return;
}

function AIActor_AnimEnd(int nChannel, name AnimName, int nRefId)
{
    // End:0x11
    if(nChannel % 0)
    {
        CheckDamageStateMeshSwap();
    }
    super(AIActor).AIActor_AnimEnd(nChannel, AnimName, nRefId);
    return;
}

function CheckDamageStateMeshSwap()
{
    // End:0x22
    if(SwapStage2AtAnimEnd)
    {
        __NFUN_595__(Stage2_RenderObject);
        SwapStage2AtAnimEnd = false;
        Anim_Idle();
        __NFUN_842__();
    }
    // End:0x44
    if(SwapStage3AtAnimEnd)
    {
        __NFUN_595__(Stage3_RenderObject);
        SwapStage3AtAnimEnd = false;
        Anim_Idle();
        __NFUN_842__();
    }
    return;
}

event name GetMeleeAttackAnimName()
{
    // End:0x14
    if(int(CurrentOp) % int(95))
    {
        return 'Anim_SuckBite';
    }
    return MeleeAnim;
    return;
}

function EnableCollisionHelpers()
{
    local EnergyLeech_Boss_HurtRadiusSensor Sensor;

    // End:0x23
    foreach __NFUN_753__(class'EnergyLeech_Boss_HurtRadiusSensor', Sensor)
    {
        Sensor.SensorEnabled = true;        
    }    
    return;
}

function DisableCollisionHelpers()
{
    local EnergyLeech_Boss_HurtRadiusSensor Sensor;

    // End:0x23
    foreach __NFUN_753__(class'EnergyLeech_Boss_HurtRadiusSensor', Sensor)
    {
        Sensor.SensorEnabled = false;        
    }    
    return;
}

function SensedPlayer(EnergyLeech_Boss_HurtRadiusSensor Sensor, PlayerPawn P)
{
    // End:0x71
    if(bAllowSlamAttackDamage)
    {
        bAllowSlamAttackDamage = false;
        P.TakeDamage(self, SlamAttackDamage, Sensor.Location, __NFUN_239__(P.Location, Sensor.Location) % , 'None', Sensor.Location);
    }
    return;
}

animevent simulated function FailDamage(optional EventInfo AnimEventInfo)
{
    // End:0x87
    if(__NFUN_340__(ControlXParms.MyControl, none) << __NFUN_340__(ControlXParms.MyControl.User, none))
    {
        ControlXParms.MyControl.User.TakeDamage(self, StrengthTapFailDamage, Location, __NFUN_239__(ControlXParms.MyControl.User.Location, Location) % );        
    }
    else
    {
        BroadcastLog(__NFUN_302__(__NFUN_303__(__NFUN_302__(__NFUN_303__("Warning: Leech Boss unable to damage attached user.", "ControlXParms.MyControl="), string(ControlXParms.MyControl)), "ControlXParms.MyControl.User="), string(ControlXParms.MyControl.User)));
    }
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    local int i;

    super(Pawn).RegisterPrecacheComponents(PrecacheIndex);
    PrecacheIndex.__NFUN_1266__(ExplosionParticleSystem);
    PrecacheIndex.__NFUN_1266__(class'EnergyLeech_Boss_Gib');
    PrecacheIndex.__NFUN_1266__(class'EnergyLeech_Boss_Gib_Tail');
    PrecacheIndex.__NFUN_1266__(SlamParticleSystem);
    PrecacheIndex.__NFUN_1266__(class'dnControl_EnergyLeech_Boss_BattleFinish');
    PrecacheIndex.__NFUN_1283__('Anim_Idle', class'acEnergyLeechBoss', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_AttackSingle', class'acEnergyLeechBoss', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_AttackDouble', class'acEnergyLeechBoss', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_Bite', class'acEnergyLeechBoss', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_SuckBite', class'acEnergyLeechBoss', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_SuckPain', class'acEnergyLeechBoss', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_ShootProjectile', class'acEnergyLeechBoss', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_ShootProjectileFast', class'acEnergyLeechBoss', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_SuctionStart0', class'acEnergyLeechBoss', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_SuctionLoop0', class'acEnergyLeechBoss', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_SuctionStop0', class'acEnergyLeechBoss', Mesh);
    PrecacheIndex.__NFUN_1283__('EnergyLeech_Pain_Center', class'acEnergyLeechBoss', Mesh);
    PrecacheIndex.__NFUN_1283__('EnergyLeech_Pain_Left', class'acEnergyLeechBoss', Mesh);
    PrecacheIndex.__NFUN_1283__('EnergyLeech_Pain_Right', class'acEnergyLeechBoss', Mesh);
    PrecacheIndex.__NFUN_1283__('EnergyLeech_Intro', class'acEnergyLeechBoss', Mesh);
    PrecacheIndex.__NFUN_1283__('EnergyLeech_Wounded_Loop_Begin', class'acEnergyLeechBoss', Mesh);
    PrecacheIndex.__NFUN_1283__('EnergyLeech_Wounded_Loop', class'acEnergyLeechBoss', Mesh);
    PrecacheIndex.__NFUN_1283__('EnergyLeech_Wounded_Loop_End', class'acEnergyLeechBoss', Mesh);
    PrecacheIndex.__NFUN_1279__(class'CrushingDamage');
    PrecacheIndex.__NFUN_1279__(class'ExplosionDamage');
    PrecacheIndex.__NFUN_1267__(Primitive(Stage2_RenderObject));
    PrecacheIndex.__NFUN_1267__(Primitive(Stage3_RenderObject));
    i = -- string(GibRenderObjects);    
    J0x2BE:

    // End:0x2F0 [Loop If]
    if(i / 0)
    {
        PrecacheIndex.__NFUN_1267__(Primitive(GibRenderObjects[i]));
        // [Loop Continue]
        i -= ;
    }
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_Bite');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_Executed');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_FallDown');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_HoleRip_Short');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_Roar');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_ShootSpike');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_SlamImpact');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_TrueDeath');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_UnderWaterMove');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_Vortex');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_WBomb_CntDwn');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_Whoosh');
    PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'EquipRuffle');
    PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'Gen_Grunt');
    PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'STR_FistLeech');
    PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'STR_LeechHankyPanky');
    PrecacheIndex.__NFUN_1282__(class'acEnergyLeechBoss', Mesh);
    return;
}

event EnumerateUsableAnimationControllers(PrecacheIndex PrecacheIndex, out array<Engine.BaseAI.EAIAnimController> UsableControllers)
{
    UsableControllers[string(UsableControllers)] = 1;
    return;
}

state ControlX
{
    simulated function bool CanBeUsedBy(Pawn User)
    {
        return true;
        return;
    }

    simulated event Used(Actor Other, Pawn EventInstigator)
    {
        super.Used(Other, EventInstigator);
        // End:0x5A
        if(__NFUN_340__(BattleControl, none))
        {
            BattleControl.bUsable = true;
            BattleControl.Used(Other, EventInstigator);
            BattleControl.bUsable = false;
        }
        return;
    }

    function EndControlX_Died()
    {
        StrengthTapEnded();
        super.EndControlX_Died();
        return;
    }

    function EndControlX_Lived()
    {
        StrengthTapRecovered();
        super.EndControlX_Lived();
        return;
    }

    function TimeOutControlX()
    {
        StrengthTapRecovered();
        super.TimeOutControlX();
        return;
    }

    function EndControlX_UserFailed()
    {
        EndControlX_Lived();
        return;
    }
    stop;
}

state AnimX
{
    function AIActor_AnimEnd(int nChannel, name AnimName, int nRefId)
    {
        // End:0x11
        if(nChannel % 0)
        {
            CheckDamageStateMeshSwap();
        }
        super.AIActor_AnimEnd(nChannel, AnimName, nRefId);
        return;
    }
    stop;
}

defaultproperties
{
    FunnelFadeInTime=0.6
    FunnelFadeOutTime=0.6
    Stage2_Health=1000
    Stage3_Health=500
    RecoveryHealth=400
    RecoveryTime=15
    Stage2_RenderObject='c_characters.energyleech_damaged'
    Stage3_RenderObject='c_characters.energyleech_damaged_2'
    BattleControlMountPrefab=(bDontActuallyMount=true,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=883.054,Y=-26.563,Z=-276.568),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=32768,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0)
    StartupForcedIdleTime=15
    StartupKnockbackForce=50000
    BiteAttackMinInterval=2.5
    BiteAttackIntialInterval=15
    BiteAttackDamage=50
    BiteAttackRadius=600
    BiteAttackMaxDistance=700
    SuckAttackMinInterval=40
    SuckAttackDamageToStop=150
    SuckAttackPainInterval=0.5
    SuckBiteAttackMaxRange=275
    SuckBiteAttackMinInterval=5
    SuckBiteAttackDamage=40
    SuckBiteAttackRadius=600
    SuckBiteAttackKnockback=10000
    SpitAttackForceHeight=100
    SpitAttackMultiCount=3
    SpitAttackDefaultSpeed=1000
    SpitAttackMultiSpeed=1400
    SpitAttackDamage=50
    SlamAttackBone=head_04
    SlamAttackRadius=200
    SlamAttackDamage=90
    SlamAttackViewShake=(bNoLerp=false,bToggleSign=true,Style=2,Function=1,FalloffActor=none,FalloffDistance=1000,ShakeDuration=0.6,ShakeFrequency=0.08,ShakeMagnitude=550,ShakeFullMagnitude=0,ShakeFullMagnitudeTime=0,ShakeName=EnergyLeech_Boss_SlamShake)
    SlamAttackKnockbackVelocity=(X=2000,Y=0,Z=35)
    SlamAttackMinDistance=500
    SlamAttackMaxDistance=1500
    SlamAttackMinInterval=6
    SlamParticleSystem='p_Creatures.EnergyLeech.LeechSlam_Spawner'
    SlamEffectOffset=(X=0,Y=0,Z=-15)
    MeleeAnim=Anim_AttackSingle
    ExplosionParticleSystem='p_Creatures.EnergyLeech.LeechExplode_Spawner'
    GibRenderObjects(0)='sm_class_decorations.EnergyLeech.Leech_Gib_1'
    GibRenderObjects(1)='sm_class_decorations.EnergyLeech.Leech_Gib_2'
    GibRenderObjects(2)='sm_class_decorations.EnergyLeech.Leech_Gib_3'
    GibRenderObjects(3)='sm_class_decorations.EnergyLeech.Leech_Gib_4'
    StrengthTapTimeout=10
    StrengthTapFailDamage=70
    bProcAimingEnabled=true
    ProcAimingVelocityPitchRampTime=2
    ProcAimingVelocityYawRampTime=2
    DamageScaleInfo(0)=(QualifierClass=none,DamageScale=0,QualifierDamageTypes=none,QualifierNotDamageTypes=('Engine.ExplosionDamage','dnGame.LargeCaliberBulletDamage'))
    Nodes(0)=(Ident=Root,Status=0,ReportedInvalid=false,SucCond=1,SucFunc=None,FailCond=1,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(1)=(Ident=Default,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=85,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(2)=(Ident=Pain,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=96,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(3)=(Ident=idle,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=85,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(4)=(Ident=StartupIdle,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=85,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(5)=(Ident=MeleeAttack,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=92,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(6)=(Ident=Spit,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=117,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(7)=(Ident=SuckAttack,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=95,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    FSMStates(0)=(FSM=Root,Ident=Default,FSMSucc=false,FSMFail=false,Transitions=((Ident=Pain,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=StartupIdle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(1)=(FSM=Root,Ident=StartupIdle,FSMSucc=false,FSMFail=false,Transitions=((Ident=Pain,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=StartupIdle,Cond=0,Func=COND_ShouldPlayStartupIdle,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(2)=(FSM=Root,Ident=idle,FSMSucc=false,FSMFail=false,Transitions=((Ident=Pain,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=Spit,Cond=0,Func=COND_ShouldForceSpit,Win=0,Code=0,StateTableIndex=0),(Ident=MeleeAttack,Cond=0,Func=COND_ShouldBiteAttack,Win=0,Code=0,StateTableIndex=0),(Ident=SuckAttack,Cond=0,Func=COND_ShouldSuckAttack,Win=0,Code=0,StateTableIndex=0),(Ident=MeleeAttack,Cond=0,Func=COND_ShouldSlamAttack,Win=0,Code=0,StateTableIndex=0),(Ident=Spit,Cond=0,Func=COND_ShouldSpitAttack,Win=0,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(3)=(FSM=Root,Ident=Pain,FSMSucc=false,FSMFail=false,Transitions=((Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(4)=(FSM=Root,Ident=MeleeAttack,FSMSucc=false,FSMFail=false,Transitions=((Ident=Pain,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(5)=(FSM=Root,Ident=Spit,FSMSucc=false,FSMFail=false,Transitions=((Ident=Spit,Cond=0,Func=COND_ShouldKeepSpitting,Win=1,Code=0,StateTableIndex=0),(Ident=Pain,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(6)=(FSM=Root,Ident=SuckAttack,FSMSucc=false,FSMFail=false,Transitions=((Ident=Pain,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    ForceDirectShot=true
    Relationships(0)=(m_aClass='Engine.AIFactionHoloduke',m_eAttitude=1,m_fDamageThreshold=1)
    Relationships(1)=(m_aClass='Engine.AIFactionDuke',m_eAttitude=2,m_fDamageThreshold=1)
    Relationships(2)=(m_aClass='Engine.AIFactionHuman',m_eAttitude=2,m_fDamageThreshold=1)
    Relationships(3)=(m_aClass='Engine.AIFactionAlien',m_eAttitude=5,m_fDamageThreshold=1)
    AnimControllers[0]=(m_eFallback=0,m_cClass='acEnergyLeechBoss',m_oController=none)
    AnimControllers[1]=(m_eFallback=1,m_cClass='acEnergyLeechBoss',m_oController=none)
    AnimControllers[2]=(m_eFallback=1,m_cClass='acEnergyLeechBoss',m_oController=none)
    AnimControllers[3]=(m_eFallback=1,m_cClass='acEnergyLeechBoss',m_oController=none)
    AnimControllers[4]=(m_eFallback=1,m_cClass='acEnergyLeechBoss',m_oController=none)
    AnimControllers[5]=(m_eFallback=1,m_cClass='acEnergyLeechBoss',m_oController=none)
    AnimControllers[6]=(m_eFallback=1,m_cClass='acEnergyLeechBoss',m_oController=none)
    AnimControllers[7]=(m_eFallback=1,m_cClass='acEnergyLeechBoss',m_oController=none)
    AnimControllers[8]=(m_eFallback=1,m_cClass='acEnergyLeechBoss',m_oController=none)
    ControlXParms=(ControlType=none,MyControl=none,AnimName=None,Time=0,IsControlled=false,DieOnTakeDamage=false,AssumeCanFit=false)
    MultiAnimParms(0)=(AnimIndex=0,MinTime=4,RndTime=1,Gate=0,MinInterval=3,RequireLOS=false,RequireLOSFromWeapon=false,FaceTarget=false,AnimName=Anim_Suction)
    DeathAnimChance=1
    FinishMeControlType='dnControl_EnergyLeech_Boss_BattleFinish'
    FaceDamage=false
    FaceDeath=false
    BoneAim(0)=(BoneName=body_09,Yaw=0,Pitch=0,Weight=0.2)
    BoneAim(1)=(BoneName=body_10,Yaw=0,Pitch=0,Weight=0.2)
    BoneAim(2)=(BoneName=body_11,Yaw=0,Pitch=0,Weight=0.2)
    BoneAim(3)=(BoneName=body_12,Yaw=0,Pitch=0,Weight=0.2)
    BoneAim(4)=(BoneName=body_13,Yaw=0,Pitch=0,Weight=0.2)
    MuzzleBoneAim(0)=(BoneName=body_18,Yaw=0,Pitch=0,Weight=0.5)
    MuzzleBoneAim(1)=(BoneName=body_19,Yaw=0,Pitch=0,Weight=0.5)
    ProjectileClass='dnRocket_EnergyLeech_Spike'
    ProjectileMuzzleName=head_04
    MinProjectileFireInterval=3
    bShootProjectileRequireLOS=false
    bShootProjectileFaceTarget=false
    bSimplePawnPhysicsCollision=false
    bShrinkable=false
    bIgnoreAimAssist=true
    MountOnSpawn(0)=(bSkipVerifySelf=false,SpawnClass='dnDecorations.Biology_Generic_EnergyLeech_SuctionFunnel',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=head_03,MountOrigin=(X=-10.21991,Y=-3.205588,Z=21.095),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=14690,Yaw=-28372,Roll=-88),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(1)=(bSkipVerifySelf=false,SpawnClass='EnergyLeech_AimAssistHelper',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=HurtRadiusActor,ForceEvent=None,MountMeshItem=head_04,MountOrigin=(X=9.974415,Y=-54.62811,Z=-39.84818),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=6981,Yaw=18632,Roll=-17715),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(2)=(bSkipVerifySelf=false,SpawnClass='EnergyLeech_Boss_HurtRadiusSensor',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=ProjectileSpawn,ForceEvent=None,MountMeshItem=head_04,MountOrigin=(X=9.974415,Y=-54.62811,Z=-39.84818),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=6981,Yaw=18632,Roll=-17715),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(3)=(bSkipVerifySelf=false,SpawnClass='EnergyLeech_Boss_HurtRadiusSensor',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=head_03,MountOrigin=(X=-3.060027,Y=1.774709,Z=14.47402),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=-16331,Yaw=3825,Roll=683),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(4)=(bSkipVerifySelf=false,SpawnClass='EnergyLeech_Boss_HurtRadiusSensor',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=head_02,MountOrigin=(X=0.175897,Y=3.62816,Z=-17.50162),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=-16040,Yaw=5624,Roll=-862),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(5)=(bSkipVerifySelf=false,SpawnClass='EnergyLeech_Boss_HurtRadiusSensor',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=AimFromPitch,ForceEvent=None,MountMeshItem=body_21,MountOrigin=(X=-3.465533,Y=1.870617,Z=-10.85532),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=-15398,Yaw=-5073,Roll=9032),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(6)=(bSkipVerifySelf=false,SpawnClass='EnergyLeech_Boss_HurtRadiusSensor',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=HurtRadiusActor,ForceEvent=None,MountMeshItem=body_20,MountOrigin=(X=-1.465144,Y=4.813263,Z=-42.62412),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=-15701,Yaw=-634,Roll=-877),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(7)=(bSkipVerifySelf=false,SpawnClass='EnergyLeech_Boss_HurtRadiusSensor',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=body_18,MountOrigin=(X=0.375577,Y=-4.905683,Z=44.00605),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=-15973,Yaw=-31453,Roll=-7183),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(8)=(bSkipVerifySelf=false,SpawnClass='EnergyLeech_Boss_HurtRadiusSensor',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=HurtRadiusActor,ForceEvent=None,MountMeshItem=body_17,MountOrigin=(X=-2.83905,Y=-5.177812,Z=7.312108),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=-16197,Yaw=-32246,Roll=75),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(9)=(bSkipVerifySelf=false,SpawnClass='EnergyLeech_Boss_HurtRadiusSensor',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=body_16,MountOrigin=(X=0.750648,Y=-4.736022,Z=-21.48862),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=-16355,Yaw=26743,Roll=6623),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(10)=(bSkipVerifySelf=false,SpawnClass='EnergyLeech_Boss_HurtRadiusSensor',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=HurtRadiusActor,ForceEvent=None,MountMeshItem=body_14,MountOrigin=(X=-0.610513,Y=-4.374979,Z=32.31284),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=-16187,Yaw=32005,Roll=1360),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(11)=(bSkipVerifySelf=false,SpawnClass='EnergyLeech_Boss_HurtRadiusSensor',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=AimFrom,ForceEvent=None,MountMeshItem=body_13,MountOrigin=(X=-2.872735,Y=-4.176378,Z=1.247012),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=-16235,Yaw=1988,Roll=31374),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(12)=(bSkipVerifySelf=false,SpawnClass='EnergyLeech_Boss_HurtRadiusSensor',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=HurtRadiusActor,ForceEvent=None,MountMeshItem=body_11,MountOrigin=(X=-6.788514,Y=-4.24447,Z=42.78042),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=-16333,Yaw=-537,Roll=-31634),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(13)=(bSkipVerifySelf=false,SpawnClass='EnergyLeech_Boss_HurtRadiusSensor',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=body_10,MountOrigin=(X=-10.51002,Y=-4.547437,Z=1.370623),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=-16369,Yaw=-10020,Roll=-22152),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(14)=(bSkipVerifySelf=false,SpawnClass='EnergyLeech_Boss_HurtRadiusSensor',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=body_09,MountOrigin=(X=-10.79572,Y=-4.755492,Z=-27.08159),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=-16352,Yaw=-25248,Roll=-6924),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(15)=(bSkipVerifySelf=false,SpawnClass='EnergyLeech_Boss_HurtRadiusSensor',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=body_07,MountOrigin=(X=-8.349388,Y=-4.78173,Z=52.83313),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=-16338,Yaw=-27737,Roll=-4433),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(16)=(bSkipVerifySelf=false,SpawnClass='EnergyLeech_Boss_HurtRadiusSensor',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=body_06,MountOrigin=(X=-8.712676,Y=-4.932783,Z=29.65706),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=-16358,Yaw=-27318,Roll=-4852),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(17)=(bSkipVerifySelf=false,SpawnClass='EnergyLeech_Boss_HurtRadiusSensor',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=body_05,MountOrigin=(X=-7.79061,Y=-4.903911,Z=-2.40699),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=-16379,Yaw=-12372,Roll=-19797),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(18)=(bSkipVerifySelf=false,SpawnClass='EnergyLeech_Boss_HurtRadiusSensor',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=body_04,MountOrigin=(X=-2.650191,Y=-4.539551,Z=-20.24162),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=-16371,Yaw=3654,Roll=29711),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(19)=(bSkipVerifySelf=false,SpawnClass='EnergyLeech_Boss_HurtRadiusSensor',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=body_02,MountOrigin=(X=-5.426925,Y=-4.577291,Z=33.00739),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=-16368,Yaw=299,Roll=-32468),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(20)=(bSkipVerifySelf=false,SpawnClass='EnergyLeech_Boss_HurtRadiusSensor',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=Root,MountOrigin=(X=-9.297739,Y=-4.76287,Z=13.41055),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=-16378,Yaw=-8197,Roll=-23972),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(21)=(bSkipVerifySelf=false,SpawnClass='EnergyLeech_HelperCollision',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=head_03,MountOrigin=(X=-0.317286,Y=-1.613425,Z=-6.769903),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=93,Yaw=20877,Roll=-15798),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(22)=(bSkipVerifySelf=false,SpawnClass='EnergyLeech_HelperCollision_Body',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=body_16,MountOrigin=(X=-2.156,Y=1.513,Z=9.035),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=67,Yaw=-15802,Roll=-16131),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    Health=1400
    HealthCap=1400
    SpawnOnDestroyed(0)=(SpawnClass='p_Creatures.EnergyLeech.EnergyLeech_Death',RenderObject=none,DrawScale=0,DrawScaleVariance=0,DrawScale3D=(X=0,Y=0,Z=0),SpawnChance=0,SpawnCopies=0,SpawnCopiesVariance=0,bIgnorePawnAirCushion=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bNoCollision=false,bFindSpot=false,bIgnoreParentRotation=true,bTakeParentCollisionSize=false,bTakeParentMounting=false,bTakeParentActorColors=false,bTakeParentSkins=false,Offset=(X=0,Y=0,Z=0),OffsetVariance=(X=0,Y=0,Z=0),Rotation=(Pitch=0,Yaw=0,Roll=0),RotationVariance=(Pitch=0,Yaw=0,Roll=0),BoneName=head_03,MotionInfo='Engine.RenderActor.MP_NoMotion')
    SpawnOnDestroyed(1)=(SpawnClass='p_Creatures.EnergyLeech.EnergyLeech_Death',RenderObject=none,DrawScale=0,DrawScaleVariance=0,DrawScale3D=(X=0,Y=0,Z=0),SpawnChance=0,SpawnCopies=0,SpawnCopiesVariance=0,bIgnorePawnAirCushion=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bNoCollision=false,bFindSpot=false,bIgnoreParentRotation=true,bTakeParentCollisionSize=false,bTakeParentMounting=false,bTakeParentActorColors=false,bTakeParentSkins=false,Offset=(X=0,Y=0,Z=0),OffsetVariance=(X=0,Y=0,Z=0),Rotation=(Pitch=0,Yaw=0,Roll=0),RotationVariance=(Pitch=0,Yaw=0,Roll=0),BoneName=body_21,MotionInfo='Engine.RenderActor.MP_NoMotion')
    SpawnOnDestroyed(2)=(SpawnClass='p_Creatures.EnergyLeech.EnergyLeech_Death',RenderObject=none,DrawScale=0,DrawScaleVariance=0,DrawScale3D=(X=0,Y=0,Z=0),SpawnChance=0,SpawnCopies=0,SpawnCopiesVariance=0,bIgnorePawnAirCushion=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bNoCollision=false,bFindSpot=false,bIgnoreParentRotation=true,bTakeParentCollisionSize=false,bTakeParentMounting=false,bTakeParentActorColors=false,bTakeParentSkins=false,Offset=(X=0,Y=0,Z=0),OffsetVariance=(X=0,Y=0,Z=0),Rotation=(Pitch=0,Yaw=0,Roll=0),RotationVariance=(Pitch=0,Yaw=0,Roll=0),BoneName=body_17,MotionInfo='Engine.RenderActor.MP_NoMotion')
    SpawnOnDestroyed(3)=(SpawnClass='p_Creatures.EnergyLeech.EnergyLeech_Death',RenderObject=none,DrawScale=0,DrawScaleVariance=0,DrawScale3D=(X=0,Y=0,Z=0),SpawnChance=0,SpawnCopies=0,SpawnCopiesVariance=0,bIgnorePawnAirCushion=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bNoCollision=false,bFindSpot=false,bIgnoreParentRotation=true,bTakeParentCollisionSize=false,bTakeParentMounting=false,bTakeParentActorColors=false,bTakeParentSkins=false,Offset=(X=0,Y=0,Z=0),OffsetVariance=(X=0,Y=0,Z=0),Rotation=(Pitch=0,Yaw=0,Roll=0),RotationVariance=(Pitch=0,Yaw=0,Roll=0),BoneName=body_11,MotionInfo='Engine.RenderActor.MP_NoMotion')
    SpawnOnDestroyed(4)=(SpawnClass='p_Creatures.EnergyLeech.EnergyLeech_Death',RenderObject=none,DrawScale=0,DrawScaleVariance=0,DrawScale3D=(X=0,Y=0,Z=0),SpawnChance=0,SpawnCopies=0,SpawnCopiesVariance=0,bIgnorePawnAirCushion=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bNoCollision=false,bFindSpot=false,bIgnoreParentRotation=true,bTakeParentCollisionSize=false,bTakeParentMounting=false,bTakeParentActorColors=false,bTakeParentSkins=false,Offset=(X=0,Y=0,Z=0),OffsetVariance=(X=0,Y=0,Z=0),Rotation=(Pitch=0,Yaw=0,Roll=0),RotationVariance=(Pitch=0,Yaw=0,Roll=0),BoneName=body_07,MotionInfo='Engine.RenderActor.MP_NoMotion')
    SpawnOnDestroyed(5)=(SpawnClass='p_Creatures.EnergyLeech.EnergyLeech_Death',RenderObject=none,DrawScale=0,DrawScaleVariance=0,DrawScale3D=(X=0,Y=0,Z=0),SpawnChance=0,SpawnCopies=0,SpawnCopiesVariance=0,bIgnorePawnAirCushion=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bNoCollision=false,bFindSpot=false,bIgnoreParentRotation=true,bTakeParentCollisionSize=false,bTakeParentMounting=false,bTakeParentActorColors=false,bTakeParentSkins=false,Offset=(X=0,Y=0,Z=0),OffsetVariance=(X=0,Y=0,Z=0),Rotation=(Pitch=0,Yaw=0,Roll=0),RotationVariance=(Pitch=0,Yaw=0,Roll=0),BoneName=body_03,MotionInfo='Engine.RenderActor.MP_NoMotion')
    SpawnOnDestroyed(6)=(SpawnClass='EnergyLeech_Boss_Gib_Tail',RenderObject=none,DrawScale=0,DrawScaleVariance=0,DrawScale3D=(X=0,Y=0,Z=0),SpawnChance=0,SpawnCopies=0,SpawnCopiesVariance=0,bIgnorePawnAirCushion=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bNoCollision=false,bFindSpot=false,bIgnoreParentRotation=false,bTakeParentCollisionSize=false,bTakeParentMounting=false,bTakeParentActorColors=false,bTakeParentSkins=false,Offset=(X=10.77572,Y=82.64026,Z=-44.04717),OffsetVariance=(X=0,Y=0,Z=0),Rotation=(Pitch=-444,Yaw=-1723,Roll=-30266),RotationVariance=(Pitch=0,Yaw=0,Roll=0),BoneName=body_21,MotionInfo=MotionPrefab'EnergyLeech_Boss.MP_LeechGibs')
    SpawnOnDestroyed(7)=(SpawnClass='EnergyLeech_Boss_Gib_Tail',RenderObject=none,DrawScale=0,DrawScaleVariance=0,DrawScale3D=(X=0,Y=0,Z=0),SpawnChance=0,SpawnCopies=0,SpawnCopiesVariance=0,bIgnorePawnAirCushion=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bNoCollision=false,bFindSpot=false,bIgnoreParentRotation=false,bTakeParentCollisionSize=false,bTakeParentMounting=false,bTakeParentActorColors=false,bTakeParentSkins=false,Offset=(X=-6.882501,Y=-19.47215,Z=10.16275),OffsetVariance=(X=0,Y=0,Z=0),Rotation=(Pitch=-711,Yaw=26270,Roll=-29812),RotationVariance=(Pitch=0,Yaw=0,Roll=0),BoneName=body_16,MotionInfo=MotionPrefab'EnergyLeech_Boss.MP_LeechGibs')
    SpawnOnDestroyed(8)=(SpawnClass='EnergyLeech_Boss_Gib_Tail',RenderObject=none,DrawScale=0,DrawScaleVariance=0,DrawScale3D=(X=0,Y=0,Z=0),SpawnChance=0,SpawnCopies=0,SpawnCopiesVariance=0,bIgnorePawnAirCushion=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bNoCollision=false,bFindSpot=false,bIgnoreParentRotation=false,bTakeParentCollisionSize=false,bTakeParentMounting=false,bTakeParentActorColors=false,bTakeParentSkins=false,Offset=(X=-9.284945,Y=-28.26541,Z=-36.74464),OffsetVariance=(X=0,Y=0,Z=0),Rotation=(Pitch=-128,Yaw=-19724,Roll=30098),RotationVariance=(Pitch=0,Yaw=0,Roll=0),BoneName=body_12,MotionInfo=MotionPrefab'EnergyLeech_Boss.MP_LeechGibs')
    SpawnOnDestroyed(9)=(SpawnClass='EnergyLeech_Boss_Gib_Tail',RenderObject=none,DrawScale=0,DrawScaleVariance=0,DrawScale3D=(X=0,Y=0,Z=0),SpawnChance=0,SpawnCopies=0,SpawnCopiesVariance=0,bIgnorePawnAirCushion=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bNoCollision=false,bFindSpot=false,bIgnoreParentRotation=false,bTakeParentCollisionSize=false,bTakeParentMounting=false,bTakeParentActorColors=false,bTakeParentSkins=false,Offset=(X=-117.8219,Y=-16.94262,Z=21.70838),OffsetVariance=(X=0,Y=0,Z=0),Rotation=(Pitch=-837,Yaw=18021,Roll=30952),RotationVariance=(Pitch=0,Yaw=0,Roll=0),BoneName=body_03,MotionInfo=MotionPrefab'EnergyLeech_Boss.MP_LeechGibs')
    DestroyedParticleFriendEffects(0)=(bAbsoluteLocation=false,bAbsoluteRotation=true,Scale=1.5,BoneName=head_02,Location=(X=0,Y=0,Z=0),Rotation=(Pitch=0,Yaw=0,Roll=0),Effect='p_Weapons.PipeBomb_Explosion_Underwater.PipeBomb_Explosion_Underwater_Spawner')
    DestroyedParticleFriendEffects(1)=(bAbsoluteLocation=false,bAbsoluteRotation=true,Scale=1.5,BoneName=head_02,Location=(X=0,Y=0,Z=0),Rotation=(Pitch=0,Yaw=0,Roll=0),Effect='p_Weapons.DepthCharge.DepthCharge_Spawner')
    DestroyedParticleFriendEffects(2)=(bAbsoluteLocation=false,bAbsoluteRotation=true,Scale=1.5,BoneName=body_19,Location=(X=0,Y=0,Z=0),Rotation=(Pitch=0,Yaw=0,Roll=0),Effect='p_Weapons.PipeBomb_Explosion_Underwater.PipeBomb_Explosion_Underwater_Spawner')
    DestroyedParticleFriendEffects(3)=(bAbsoluteLocation=false,bAbsoluteRotation=true,Scale=1.5,BoneName=body_19,Location=(X=0,Y=0,Z=0),Rotation=(Pitch=0,Yaw=0,Roll=0),Effect='p_Weapons.DepthCharge.DepthCharge_Spawner')
    DestroyedParticleFriendEffects(4)=(bAbsoluteLocation=false,bAbsoluteRotation=true,Scale=1.5,BoneName=body_14,Location=(X=0,Y=0,Z=0),Rotation=(Pitch=0,Yaw=0,Roll=0),Effect='p_Weapons.PipeBomb_Explosion_Underwater.PipeBomb_Explosion_Underwater_Spawner')
    DestroyedParticleFriendEffects(5)=(bAbsoluteLocation=false,bAbsoluteRotation=true,Scale=1.5,BoneName=body_14,Location=(X=0,Y=0,Z=0),Rotation=(Pitch=0,Yaw=0,Roll=0),Effect='p_Weapons.DepthCharge.DepthCharge_Spawner')
    DestroyedParticleFriendEffects(6)=(bAbsoluteLocation=false,bAbsoluteRotation=true,Scale=1.5,BoneName=body_09,Location=(X=0,Y=0,Z=0),Rotation=(Pitch=0,Yaw=0,Roll=0),Effect='p_Weapons.PipeBomb_Explosion_Underwater.PipeBomb_Explosion_Underwater_Spawner')
    DestroyedParticleFriendEffects(7)=(bAbsoluteLocation=false,bAbsoluteRotation=true,Scale=1.5,BoneName=body_09,Location=(X=0,Y=0,Z=0),Rotation=(Pitch=0,Yaw=0,Roll=0),Effect='p_Weapons.DepthCharge.DepthCharge_Spawner')
    DestroyedParticleFriendEffects(8)=(bAbsoluteLocation=false,bAbsoluteRotation=true,Scale=1.5,BoneName=body_05,Location=(X=0,Y=0,Z=0),Rotation=(Pitch=0,Yaw=0,Roll=0),Effect='p_Weapons.PipeBomb_Explosion_Underwater.PipeBomb_Explosion_Underwater_Spawner')
    DestroyedParticleFriendEffects(9)=(bAbsoluteLocation=false,bAbsoluteRotation=true,Scale=1.5,BoneName=body_05,Location=(X=0,Y=0,Z=0),Rotation=(Pitch=0,Yaw=0,Roll=0),Effect='p_Weapons.DepthCharge.DepthCharge_Spawner')
    StaticInteractionClassification=8
    PhysicsEntityGroup=EnergyLeechPhysicsEntityGroup
    Physics=9
    bAcceptMeshAccurateMoveActorTrace=true
    CollisionRadius=0
    CollisionHeight=0
    Mass=2000
    Mesh='c_characters.EnergyLeech'
    VoicePack='SoundConfig.Enemies.VoicePack_Leech'
}