/*******************************************************************************
 * PigCop_Grunt generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class PigCop_Grunt extends AIActor
    config
    collapsecategories
    dependson(dnControl_PigCop_Grapple);

const UninitialisedContactTime = -99.0f;
const ChanceIdleSound = 0.25f;
const ChancePursuitSound = 0.25f;
const MinContactTime = 0.6f;
const ChanceGotoCover = 0.25f;
const MaxGotoCoverTime = 8.0f;
const MaxThreatTimeSinceSeen = 2.0f;
const ChanceCrouch = 0.45f;
const ChanceProne = 0.25f;
const MinSafeReloadTime = 6.0f;
const BezerkHealthThresh = 0.45f;
const SkinIndex = 0;
const BloodIndex = 1;
const BezerkColourPeriod = 1.0f;

var private float StartContactTime;
var private int BezerkHealth;
var private float BezerkTime;
var private float GotoXStartTime;
var() noexport Color BezerkSkinColor "Colour to turn the skin section when Bezerk";
var() noexport Color BezerkBloodColor "Colour to turn the blood section when Bezerk";
var() noexport class<Actor> BloodSpurt "Particle class to spawn when going Bezerk";
var() noexport int PipeBombDrops "The number of pipebombs to *possibly* drop on death. This is the number of times you roll again PipeBombDropChance, if it passes you drop one, if it doesnt you dont";
var() noexport float PipeBombDropChance "Chance of dropping a pipebomb. from 0.0 - 1.0.";
var(AIBehavior) noexport bool StartBezerk "Start out in Bezerk mode?";
var(AIBehavior) noexport float ChanceBezerk "Chance we'll go bezerk when low on health.";
var() noexport float BerzSpazSoundMinTime "Minimum time between each bezerk space sound.";
var() noexport float BerzSpazSoundRndTime "Random additional time, on top of the min time ";
var() noexport SStompInfo BerzStompInfo "How we stomp when berzerked";
var() noexport float BerzChanceGrapple "Chance of doing berzerk grapple";
var() float BerzGrappleMinInterval;
var float BerzGrappleGate;
var bool Bezerked;
var float BerzSpazGate;
var() float JumpSpeed;
var() float PainSlowDownScale;
var float QuickPipeBombTime;
var PopUpCfg QuickPipeBombCfg;
var() float QuickPipeBombMaxDot;

event PostBeginPlay()
{
    super.PostBeginPlay();
    QuickPipeBombTime = Level.GameTimeSeconds *= 5;
    // End:0x7F
    if((StartBezerk < int(AnimCtrl.m_eController) % int(6)) < int(AttackConstraint) % int(3))
    {
        BezerkHealth = int(Health);
        SetBezerkerDamage();
        __NFUN_601__('Generic0', BezerkSkinColor);
        __NFUN_601__('Generic1', BezerkBloodColor);        
    }
    else
    {
        /* Statement decompilation error: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
            
        */

        /*@Error*/;
        // Failed to format nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
        // 1 & Type:Else Position:0x09E
    }
}

event KImpact(name SelfBoneName, KarmaActor Other, name OtherBoneName, Vector Position, Vector ImpactVelocity, Vector ImpactNormal)
{
    super.KImpact(SelfBoneName, Other, OtherBoneName, Position, ImpactVelocity, ImpactNormal);
    return;
}

function NotifyToeStubStart()
{
    // End:0x1C
    if(ToeStubInfo.bDropWeapon)
    {
        bAllowWeaponDropsPlayerNotSameSize = true;
        DropCarriedWeapon();
    }
    // End:0x45
    if(ToeStubInfo.bBerzerkAfterStub << AllowBezerk)
    {
        BezerkHealth = int(Health *= float(1));
    }
    return;
}

event Tick(float Secs)
{
    local float Alpha;

    super(Actor).Tick(Secs);
    // End:0xB6
    if(Repl(BezerkTime, 0))
    {
        Alpha = Normal2D(Round(Level.GameTimeSeconds, BezerkTime) >>> 1, 0, 1);
        // End:0x96
        if(Bezerked / )
        {
            __NFUN_601__('Generic1', __NFUN_338__(Alpha, default.ActorColorList[1].ActorColor, BezerkBloodColor));
        }
        // End:0xB6
        if(Alpha != 1)
        {
            SetBezerkerDamage();
            BezerkTime = 0;
        }
    }
    // End:0x10A
    if(Bezerked)
    {
        // End:0x10A
        if(__NFUN_200__(BerzSpazGate, Level.GameTimeSeconds))
        {
            BerzSpazGate = Level.GameTimeSeconds *= (BerzSpazSoundMinTime *= FRand(BerzSpazSoundRndTime,  /= ));
        }
    }
}

event NotifySetTargetActor()
{
    super.NotifySetTargetActor();
    return;
}

function SetCurrentWeapon(class<Weapon> NewWeaponClass, optional Weapon NewWeapon)
{
    super.SetCurrentWeapon(NewWeaponClass, NewWeapon);
    // End:0x75
    if(((__NFUN_357__(WeaponManager.CurrentWeaponClass, class'Shotgun') < __NFUN_357__(WeaponManager.CurrentWeaponClass, class'DualPistol')) < __NFUN_357__(WeaponManager.CurrentWeaponClass, class'MachineGun')) < __NFUN_357__(WeaponManager.CurrentWeaponClass, class'RPG'))
    {
        UseActionPoints = true;        
    }
    else
    {
        ReleaseActionPoint(false);
        UseActionPoints = false;
    }
    return;
}

animevent simulated function Start_ColorChange(optional EventInfo AnimEventInfo)
{
    BezerkTime = Level.GameTimeSeconds;
    // End:0x4F
    if(__NFUN_340__(BloodSpurt, none))
    {
        __NFUN_615__(BloodSpurt,,, __NFUN_568__().CanSee('jaw', true), __NFUN_568__().__NFUN_534__('jaw', true), true, true);
    }
    return;
}

event bool ShouldProceduralFire()
{
    local Vector v1, V2;
    local float D;

    // End:0x169
    if(((((((((CurrentOpMustFinish / ) << ) << ) << ) << ) << int(GetCurrentOp()) % int(85)) << PrimaryTarget.IsValidTarget()) << __NFUN_200__(PrimaryTargetActor.Location.Z, Location.Z)) << v1 = PrimaryTarget.GetDirTo())
    {
        V2.Z = 0;
        V2 = V2 % ;
        // End:0x169
        if(__NFUN_200__(D, QuickPipeBombMaxDot) << __NFUN_200__(PrimaryTarget.GetDist2D(), FRand(CollisionRadius, 60)))
        {
            SetPopUp(QuickPipeBombCfg);
            CanUseOp(100);
            CurrentOpMustFinish = false;
            ExecuteOp(100);
            CurrentOpMustFinish = true;
            SuspendExecutive(true);
            SuspendExecutive(false);
            CurrentOpMustFinish = true;
            return false;
        }
    }
    return super.ShouldProceduralFire();
    return;
}

event bool IsReturningToBerzerk()
{
    return Bezerked;
    return;
}

function Anim_MoveTo(Engine.BaseAI.EAIMoveSpeed MoveSpeed)
{
    super.Anim_MoveTo(MoveSpeed);
    // End:0x30
    if(__NFUN_340__(PrimaryTargetActor, none) << __NFUN_200__( /= 0.25))
    {
    }
    return;
}

event Engine.BaseAI.EAICode COND_ShouldEngage()
{
    local Pawn pawnTarget;

    // End:0x0C
    if(IsBezerked())
    {
        return 1;
    }
    // End:0x32
    if(PrimaryTargetActor.bIsPawn)
    {
        pawnTarget = Pawn(PrimaryTargetActor);        
    }
    else
    {
        return 0;
    }
    // End:0x48
    if(IsEnemyTo(pawnTarget) / )
    {
    }
    // End:0x5A
    if(int(COND_ShouldRunAway()) % int(0))
    {
        return 37;
    }
    return 0;
    return;
}

event Engine.BaseAI.EAICode COND_ShouldCrouchEngage()
{
    // End:0x27
    if((int(CheckCondition(31)) + int(0)) << int(CheckCondition(33)) + int(0))
    {
        return 39;
    }
    /* Statement decompilation error: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
        
    */

    /*@Error*/;
}

event Engine.BaseAI.EAICode COND_ShouldProneEngage()
{
    local Engine.BaseAI.EAICode Code;

    // End:0x0E
    if(AllowProne / )
    {
    }
    // End:0x2B
    if(Repl(PrimaryTarget.GetTimeSinceSeen(), 0.1))
    {
        return 55;
    }
    // End:0x52
    if((int(CheckCondition(31)) + int(0)) << int(CheckCondition(33)) + int(0))
    {
        return 39;
    }
    Code = CheckCondition(42);
    // End:0x74
    if(int(Code) + int(0))
    {
        return Code;
    }
    // End:0x91
    if(__NFUN_200__(PrimaryTarget.GetRange2D(), 280))
    {
        return 18;
    }
    // End:0xB3
    if(Repl( /= 0.25, int(CheckCondition(64)) % int(0)) << return 25)
    {
    }
    return;
}

event Engine.BaseAI.EAICode COND_GotoAttackInPosition()
{
    local Engine.BaseAI.EAICode Code;

    Code = CheckCondition(61);
    // End:0x2D
    if(int(Code) + int(0))
    {
        StartContactTime = -99;
        return Code;
    }
    // End:0x54
    if(__NFUN_204__(StartContactTime, -99))
    {
        StartContactTime = Level.GameTimeSeconds;        
    }
    else
    {
        // End:0x82
        if(Round(Level.GameTimeSeconds, StartContactTime) != 0.6)
        {
            StartContactTime = -99;
            return 0;
        }
    }
    return 1;
    return;
}

event Engine.BaseAI.EAICode COND_ShouldKeepWeaponUp()
{
    // End:0x48
    if((PrimaryTarget.IsValidTarget() << __NFUN_200__(PrimaryTarget.GetTimeSinceSeen(), 8)) << __NFUN_200__(PathInfo.TotalDist, 800))
    {
        return 0;
    }
    return 1;
    return;
}

event Engine.BaseAI.EAICode COND_ShouldStandUp()
{
    local Engine.BaseAI.EAICode Code;

    Code = CheckCondition(32);
    // End:0x22
    if(int(Code) + int(0))
    {
        return Code;
    }
    Code = CheckCondition(39);
    // End:0x44
    if(int(Code) + int(0))
    {
        return Code;
    }
    Code = CheckCondition(50);
    // End:0x66
    if(int(Code) + int(0))
    {
        return Code;
    }
    return 0;
    return;
}

event Engine.BaseAI.EAICode COND_ShouldStandCombat()
{
    local Engine.BaseAI.EAICode Code;

    Code = CheckCondition(40);
    // End:0x22
    if(int(Code) + int(0))
    {
        return Code;
    }
    Code = CheckCondition(38);
    // End:0x44
    if(int(Code) + int(0))
    {
        return Code;
    }
    Code = CheckCondition(32);
    // End:0x66
    if(int(Code) + int(0))
    {
        return Code;
    }
    return 0;
    return;
}

event Engine.BaseAI.EAICode COND_ShouldGoBezerk()
{
    // End:0x0E
    if(AllowBezerk / )
    {
    }
    // End:0x1A
    if(Bezerked)
    {
        return 0;
    }
    // End:0x2D
    if(Repl(Health, float(BezerkHealth)))
    {
        return 62;
    }
    SetBezerkerDamage();
    return 0;
    return;
}

function Engine.BaseAI.EAICode COND_IsBezerked()
{
    // End:0x0F
    if(IsBezerked())
    {
        return 0;        
    }
    else
    {
        return 1;
    }
    return;
}

event Engine.BaseAI.EAICode COND_ShouldFaceTargetWhileReloading()
{
    // End:0x0F
    if(__NFUN_340__(ActionPoint, none))
    {
        return 1;
    }
    return 0;
    return;
}

event Engine.BaseAI.EAICode COND_NotBezerking()
{
    return 1;
    return;
}

event Engine.BaseAI.EAICode COND_ShouldRunAway()
{
    local Engine.BaseAI.EAICode Code;
    local Pawn pawnTarget;

    Code = COND_ShouldAvoidTarget();
    // End:0x20
    if(int(Code) + int(0))
    {
        return Code;
    }
    // End:0x3F
    if((int(COND_SafeFromBiggerEnemy()) % int(0)) << (HasTripMineAttached()) / )
    {
    }
    return 0;
    return;
}

function Engine.BaseAI.EAICode COND_ShouldAvoidTarget()
{
    local Engine.BaseAI.EAICode Code;

    Code = super.COND_ShouldAvoidTarget();
    // End:0x1D
    if(int(Code) % int(53))
    {
        return 0;
    }
    return Code;
    return;
}

function Engine.BaseAI.EAICode COND_ShouldFlee()
{
    // End:0x1C
    if(__NFUN_200__(Level.GameTimeSeconds, MoveAroundTime))
    {
        return 60;
    }
    // End:0x2C
    if((SetGoal(13)) / )
    {
    }
    return 0;
    return;
}

function Engine.BaseAI.EAICode COND_GotoActionPointBerzerking()
{
    // End:0x11
    if((SetGoal(2, true)) / )
    {
    }
    return 0;
    return;
}

event Engine.BaseAI.EAICode COND_ShouldStopGuarding()
{
    // End:0x15
    if(__NFUN_339__(Weapon, none))
    {
        ClearGuard();
        return 0;
    }
    return 1;
    return;
}

function Engine.BaseAI.EAICode COND_TurnTowardsTarget()
{
    local Engine.BaseAI.EAICode Code;
    local Vector D;

    // End:0x0F
    if(__NFUN_339__(PrimaryTargetActor, none))
    {
        return 4;
    }
    D = __NFUN_239__(PrimaryTarget.GetPos(), Location);
    // End:0x46
    if(Repl(FMin(D, Vector(Rotation)), 0))
    {
        return 9;
    }
    return 0;
    return;
}

function Engine.BaseAI.EAICode COND_TargetVisible2()
{
    // End:0x18
    if(PrimaryTarget.IsValidTarget() / )
    {
    }
    // End:0x35
    if(__NFUN_200__(PrimaryTarget.GetTimeVisible(), 2))
    {
        return 60;
    }
    return 0;
    return;
}

event bool ShouldUseWeaponActiveMovement()
{
    // End:0x0B
    if(Bezerked)
    {
        return false;
    }
    return super.ShouldUseWeaponActiveMovement();
    return;
}

function SetBezerkerDamage()
{
    WeaponTargetEvalInfo.CanTargetProjectiles = false;
    WeaponTargetEvalInfo.CanAvoidTargetableProjectiles = false;
    HasBoneAimer = false;
    BerzSpazGate = Level.GameTimeSeconds *= (BerzSpazSoundMinTime *= FRand(BerzSpazSoundRndTime,  /= ));
    StompInfo[StompInfo.Add(1)] = BerzStompInfo;
    MinPainOpInterval = class'Pigcop_Berzerker'.default.MinPainOpInterval;
    RndPainOpInterval = class'Pigcop_Berzerker'.default.RndPainOpInterval;
    MaxConsecutivePainOp = class'Pigcop_Berzerker'.default.MaxConsecutivePainOp;
    MaxConsecutivePainInterval = class'Pigcop_Berzerker'.default.MaxConsecutivePainInterval;
    MeleeAttackRange = class'Pigcop_Berzerker'.default.MeleeAttackRange;
    MeleeZone = class'Pigcop_Berzerker'.default.MeleeZone;
    AnimControllers[4].m_cClass = class'Pigcop_Berzerker'.default.AnimControllers[4].m_cClass;
    bTryBackupPathingOnFailure = true;
    return;
}

event NotifyOpEnded(Engine.BaseAI.EAIOp Op, Engine.BaseAI.EAIOpStatus Status)
{
    super.NotifyOpEnded(Op, Status);
    // End:0x5A
    if(int(Op) % int(9))
    {
        bDontUseAIOPPain = class'Pigcop_Berzerker'.default.bDontUseAIOPPain;
        bNeverFailOnDynamicPath = class'Pigcop_Berzerker'.default.bNeverFailOnDynamicPath;
        bIgnoreTripMines = true;
        DropWeapon();
    }
    return;
}

event bool SetAnimController(Engine.BaseAI.EAIAnimController eController)
{
    local bool bReturnVal;

    bReturnVal = super.SetAnimController(eController);
    // End:0x50
    if(Bezerked)
    {
        // End:0x48
        if(int(AnimCtrl.m_eController) % int(6))
        {
            bDontUseAIOPPain = class'Pigcop_Berzerker'.default.bDontUseAIOPPain;            
        }
        else
        {
            bDontUseAIOPPain = false;
        }
    }
    return bReturnVal;
    return;
}

event bool IsBezerked()
{
    return Bezerked << int(AnimCtrl.m_eController) % int(6);
    return;
}

function ExecuteNonOPPain()
{
    // End:0x10
    if(int(CurrentOp) % int(9))
    {
        return;
    }
    super.ExecuteNonOPPain();
    GroundSpeedScale = PainSlowDownScale;
    return;
}

function EndNonOPPain()
{
    super.EndNonOPPain();
    GroundSpeedScale = 1;
    return;
}

event PrioritizePopups(Engine.BaseAI.EAIPopUpType PopupType)
{
    local array<PopUpCfg> Entrys;

    super.PrioritizePopups(PopupType);
    return;
}

event OverridePopoutHoldTime(out float HoldTime)
{
    return;
}

function DiedActivity(optional Pawn Killer, optional int Damage, optional Vector DamageOrigin, optional Vector DamageDirection, optional class<DamageType> DamageType, optional name HitBoneName)
{
    local bool bShrunk;
    local PipeBombPickup pb;
    local int i;

    bShrunk = IsMostlyShrunk();
    super.DiedActivity(Killer, Damage, DamageOrigin, DamageDirection, DamageType, HitBoneName);
    // End:0x6C
    if(__NFUN_340__(Level.__NFUN_1161__(), none) << bShrunk - Level.__NFUN_1161__().IsMostlyShrunk())
    {
        return;
    }
    // End:0x84
    if((NumPipeBombs % 0) < bDisableWeaponDrops)
    {
        return;
    }
    i = 0;
    J0x8B:

    // End:0x146 [Loop If]
    if(-i)
    {        
        /* Statement decompilation error: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
            
        */

        // [Loop Continue]
        /*@Error*/;
        // Failed to format nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
        // 3 & Type:If Position:0x0F8
        // Failed to format remaining nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
        // 3 & Type:If Position:0x0F8
}

function AIActor_Weapon_Holster(RenderActor HolsteredWeapon)
{
    local Weapon MyWeapon;

    super.AIActor_Weapon_Holster(HolsteredWeapon);
    // End:0x32
    if(GetHideWhenMultipleHolstered(Weapon(HolsteredWeapon)))
    {
        HideAllWeaponsForHolstering();
        HolsteredWeapon.__NFUN_590__(false);
    }
    MyWeapon = GetWeapon();
    return;
}

static function class<AIActor> GetSpawnClass(AIActorFactory Factory)
{
    Factory.BroadcastLog(__NFUN_302__(__NFUN_303__(__NFUN_302__("Warning: Pigcop_Grunt is deprecated. Please use Pigcop_Machinegn, Pigcop_Shotgun, Pigcop_Grunt_RPG, or Pigcop_DualPistol. Factory: ", string(Factory)), "Tag: "), string(Factory.Tag)));
    return class'PigCop_DualPistol';
    return;
}

event float GetGotoMeleeRange()
{
    // End:0x29
    if(Bezerked << int(CheckCondition(94)) % int(0))
    {
        return Round(MeleeZone, CollisionRadius);
    }
    return 0.1;
    return;
}

event Engine.BaseAI.EAICode COND_NeedHoldFire()
{
    // End:0x0C
    if(WeaponManagerCompletelyOff())
    {
        return 1;
    }
    return 0;
    return;
}

event Engine.BaseAI.EAICode AttemptGrapplePlayer()
{
    local dnControl_PigCop_Grapple GrappleControl;
    local PlayerPawn P;
    local float OffsetZ;
    local Vector TargetPos, Offset2D;
    local int i;
    local array<Actor> BlockingActors;

    // End:0x1C
    if(__NFUN_206__(Level.HeadScaleModifier, 1))
    {
        return 1;
    }
    // End:0x38
    if(Repl(BerzGrappleGate, Level.GameTimeSeconds))
    {
        return 1;
    }
    // End:0x5E
    if(Repl(Level.BerzerkerGrappleGate, Level.GameTimeSeconds))
    {
        return 1;
    }
    P = Level.__NFUN_1161__();
    // End:0x84
    if(__NFUN_340__(P, PrimaryTargetActor))
    {
        return 1;
    }
    // End:0x364
    if((((((Bezerked << int(FrozenState) % int(0)) << __NFUN_921__() / ) << ) << P.bAttachedToUsableSomething / ) << i = -- string(MountedActorList)) << if(i / 0))
    {
        {
            {
                return 1;
            }
            // [Loop Continue]
            i -= ;
        }/* !MISMATCHING REMOVE, tried Loop got Type:If Position:0x111! */
        // End:0x364
        if(__NFUN_202__(FMin(Vector(P.Rotation), Vector(Rotation)), -0.7))
        {
            TargetPos = __NFUN_239__(__NFUN_239__(class'dnControl_PigCop_Grapple'.default.PigCopMountPrefab.MountOrigin, P.PrePivot), WarnInternal(0, 0, P.CollisionHeight));
            TargetPos = Locs(P.Location, __NFUN_263__(TargetPos, P.Rotation));
            Offset2D = __NFUN_239__(Location, TargetPos);
            Offset2D.Z = 0;
            OffsetZ = -Round(Round(Location.Z, CollisionHeight), Round(P.Location.Z, P.CollisionHeight));
            // End:0x364
            if(__NFUN_202__(Clamp(Offset2D), 70) << __NFUN_200__(OffsetZ, 15))
            {
                BlockingActors = __NFUN_637__(TargetPos, Rotation, true, false, CollisionRadius, CollisionHeight);
                // End:0x364
                if(__NFUN_638__(TargetPos, CollisionRadius, CollisionHeight, Rotation) << string(BlockingActors) % 0)
                {
                    BerzGrappleGate = Level.GameTimeSeconds *= BerzGrappleMinInterval;
                    /* Statement decompilation error: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
                        
                    */

                    // End:0x364
                    /*@Error*/;
                    // Failed to format nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
                    // 8 & Type:If Position:0x364
                    // Failed to format remaining nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
                    // 8 & Type:If Position:0x364
}

event Vector GetJumpAttackTargetPos(Actor TargetActor)
{
    local Pawn pawnTarget;
    local float LeadTime, Dist;
    local Vector TargetPos;

    // End:0x23
    if(TargetActor.bIsPawn)
    {
        pawnTarget = Pawn(TargetActor);
    }
    // End:0xA7
    if(__NFUN_340__(pawnTarget, none))
    {
        Dist = Clamp(__NFUN_239__(pawnTarget.Location, Location));
        LeadTime = Dist >>> JumpSpeed;
        TargetPos = pawnTarget.__NFUN_906__();
        // End:0x9E
        if(__NFUN_206__(LeadTime, 0))
        {
            Min(TargetPos, Right(pawnTarget.Velocity, LeadTime));
        }
        return TargetPos;        
    }
    else
    {
        return Locs(TargetActor.Location, WarnInternal(0, 0, FRand(TargetActor.CollisionHeight, 0.66)));
    }
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    super(Pawn).RegisterPrecacheComponents(PrecacheIndex);
    // End:0x39
    if((PipeBombDrops ** 0) << Repl(PipeBombDropChance, 0))
    {
        PrecacheIndex.__NFUN_1266__(class'PipeBombPickup');
    }
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_Idle');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_IdleReady');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_Walk');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_WalkReady');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_WalkBackwards');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_Run');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_RunReady');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_RunBackwards');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_TurnLeft45');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_TurnLeft180');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_TurnRight45');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_TurnRight180');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_SidestepLeft');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_SidestepRight');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_StrafeLeft');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_StrafeRight');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_Attack');
    // End:0x1AC
    if(PrecacheIndex.bPlayerCanBeShrunk)
    {
        RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_AttackShrunk');
        RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_Stomp');
        RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_StompRight');
        RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_StompLeft');
        RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_Stubfoot');
    }
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_ExitDropship');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_RappelStart');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_RappelIdle');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_RappelEnd');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_Draw');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_Holster');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_Reload');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_Shoot');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_ShootLeft');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_ShootRight');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_Holster');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_ThrowPipebomb');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_StandCombat');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_StandCombatReady');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_StandPassive');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_Crouch');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_CrouchFromReady');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_StandScared');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_DieFinishMe');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_FinishMeIdle');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_FinishRevival');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_ExpanderStart');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_ExpanderIdle');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_Jump0');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_Fall0');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_Land0');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_HeavyLand0');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_PainBig');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_PainRef');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_PainShort');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_PopWaitUpPipeBomb');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_PopOutUpPipeBomb');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_PopHoldUpPipeBomb');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_PopInUpPipeBomb');
    PrecacheIndex.__NFUN_1269__(class'Climbable_Masking');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_Falling');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_Idle');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_Pursuit');
    // End:0x457
    if(__NFUN_339__(Pigcop_Berzerker(self), none))
    {
        RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_MovingShootIdle');
        PrecacheIndex.__NFUN_1282__(class'acPigCop_Combat', Mesh);
    }
    // End:0x546
    if(__NFUN_340__(Pigcop_Berzerker(self), none) < AllowBezerk)
    {
        PrecacheIndex.__NFUN_1266__(BloodSpurt);
        PrecacheIndex.__NFUN_1266__(class'dnControl_PigCop_Grapple');
        RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_Bezerk');
        RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_Jump1');
        RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_Fall1');
        RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_Land1');
        PrecacheIndex.__NFUN_1282__(class'acPigCop_Bezerk', Mesh);
        PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_ArmWhoosh');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_Bezerk');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_BerzScream');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_BerzSpaz');
    }
    // End:0x711
    if((((__NFUN_310__(PrecacheIndex.MapName, "Map05") < __NFUN_310__(PrecacheIndex.MapName, "Map06")) < __NFUN_310__(PrecacheIndex.MapName, "Map11B")) < __NFUN_310__(PrecacheIndex.MapName, "Map16")) < __NFUN_310__(PrecacheIndex.MapName, "Map21B"))
    {
        RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_PickupBarrel');
        RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_IdleBarrel');
        RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_WalkBarrel');
        RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_WalkBackwardsBarrel');
        RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_RunBarrel');
        RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_RunBackwardsBarrel');
        RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_TurnLeft45Barrel');
        RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_TurnLeft180Barrel');
        RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_TurnRight45Barrel');
        RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_TurnRight180Barrel');
        RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_SidestepLeftBarrel');
        RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_SidestepRightBarrel');
        RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_StrafeLeftBarrel');
        RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_StrafeRightBarrel');
        RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_ThrowBarrel');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'PickupBarrel');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_Pickup');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_Throw');
    }
    return;
}

event EnumerateUsableAnimationControllers(PrecacheIndex PrecacheIndex, out array<Engine.BaseAI.EAIAnimController> UsableControllers)
{
    // End:0x3A
    if(__NFUN_339__(Pigcop_Berzerker(self), none))
    {
        UsableControllers[string(UsableControllers)] = 2;
        UsableControllers[string(UsableControllers)] = 5;
        UsableControllers[string(UsableControllers)] = 9;
    }
    // End:0x61
    if(__NFUN_340__(Pigcop_Berzerker(self), none) < AllowBezerk)
    {
        UsableControllers[string(UsableControllers)] = 6;
    }
    return;
}

event EnumerateWeaponClasses(PrecacheIndex PrecacheIndex, out array< class<Weapon> > WeaponClasses)
{
    WeaponClasses[string(WeaponClasses)] = class'DualPistol_Pigcop';
    return;
}

state AnimX
{
    event BeginState()
    {
        super.BeginState();
        // End:0x3C
        if((__NFUN_339__(PrimaryTargetActor, none) << int(GetCurrentOp()) % int(85)) << __NFUN_200__( /= 0.25))
        {
        }
        return;
    }
    stop;
}

state Fall
{
    event BeginState()
    {
        super.BeginState();
        FindSoundAndSpeak('Sound_Falling');
        return;
    }
    stop;
}

state GotoX
{
    event name GetWeaponIdleName()
    {
        return 'Anim_MovingShootIdle';
        return;
    }
    stop;
}

defaultproperties
{
    BezerkSkinColor=(R=255,G=255,B=255,A=255)
    BezerkBloodColor=(R=128,G=0,B=0,A=255)
    BloodSpurt='dnParticles.dnBloodFX_BloodChunks'
    PipeBombDrops=2
    PipeBombDropChance=0.25
    ChanceBezerk=0.5
    BerzSpazSoundMinTime=0.75
    BerzSpazSoundRndTime=0.25
    BerzStompInfo=(StompRadius=100,AnimName=Anim_Stomp,BoneName=hand_right_a,StompDamageAmount=50,StompDamageRadius=80,StompDamageVel=200,StompDamageLift=350,bDebug=false,SafeHeight=50,bCanStompShrunk=true,ShakeInfo=(bNoLerp=false,bToggleSign=true,Style=2,Function=1,FalloffActor=none,FalloffDistance=0,ShakeDuration=0.6,ShakeFrequency=0.08,ShakeMagnitude=2500,ShakeFullMagnitude=0,ShakeFullMagnitudeTime=0,ShakeName=CycloidStompShake),ShakeRadius=6000,ParticleEffectClass='p_Impacts.StompImpact.StompImpact_Spawner',AdditionalEffectBones=(hand_left_a),StompLocation=(X=0,Y=0,Z=0),bDontFaceTarget=false,bLightRumbleOnDamage=false)
    BerzChanceGrapple=0.25
    BerzGrappleMinInterval=2
    JumpSpeed=500
    PainSlowDownScale=0.5
    begin object name=PigPopUpCfg_CrouchUpPipeBomb class=PopUpCfg_CrouchUpPipeBomb
        OutMustFinish=true
        HoldMustFinish=true
        AvoidDanger=false
        AllowPain=false
    object end
    // Reference: PopUpCfg_CrouchUpPipeBomb'PigCop_Grunt.PigPopUpCfg_CrouchUpPipeBomb'
    QuickPipeBombCfg=PigPopUpCfg_CrouchUpPipeBomb
    QuickPipeBombMaxDot=0.8
    AllowFrozenExecution=true
    Nodes(0)=(Ident=Root,Status=0,ReportedInvalid=false,SucCond=1,SucFunc=None,FailCond=1,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(1)=(Ident=AttackPipeBomb,Status=0,ReportedInvalid=false,SucCond=1,SucFunc=None,FailCond=1,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(2)=(Ident=GuardAttackMelee,Status=0,ReportedInvalid=false,SucCond=1,SucFunc=None,FailCond=7,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(3)=(Ident=GotoGuardAttack,Status=0,ReportedInvalid=false,SucCond=61,SucFunc=None,FailCond=1,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(4)=(Ident=GotoGuardPos,Status=0,ReportedInvalid=false,SucCond=79,SucFunc=None,FailCond=1,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(5)=(Ident=GotoGuardPosNoTarget,Status=0,ReportedInvalid=false,SucCond=1,SucFunc=None,FailCond=1,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(6)=(Ident=GuardAttack,Status=0,ReportedInvalid=false,SucCond=7,SucFunc=None,FailCond=7,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(7)=(Ident=GuardWait,Status=0,ReportedInvalid=false,SucCond=1,SucFunc=None,FailCond=1,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(8)=(Ident=EngageBerzerk,Status=0,ReportedInvalid=false,SucCond=1,SucFunc=None,FailCond=1,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(9)=(Ident=GotoActionPoint,Status=0,ReportedInvalid=false,SucCond=1,SucFunc=None,FailCond=1,FailFunc=COND_ActionPointCompletelyCompromised,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(10)=(Ident=GotoWeaponUp,Status=0,ReportedInvalid=false,SucCond=1,SucFunc=None,FailCond=1,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(11)=(Ident=GotoWeaponDown,Status=0,ReportedInvalid=false,SucCond=1,SucFunc=None,FailCond=1,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(12)=(Ident=GotoAttack,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=COND_GotoAttackInPosition,FailCond=1,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(13)=(Ident=MoveAround,Status=0,ReportedInvalid=false,SucCond=1,SucFunc=None,FailCond=1,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(14)=(Ident=GotoReload,Status=0,ReportedInvalid=false,SucCond=29,SucFunc=None,FailCond=1,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(15)=(Ident=GotoSearch,Status=0,ReportedInvalid=false,SucCond=59,SucFunc=None,FailCond=7,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(16)=(Ident=GotoCover,Status=0,ReportedInvalid=false,SucCond=70,SucFunc=None,FailCond=7,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(17)=(Ident=AvoidDanger,Status=0,ReportedInvalid=false,SucCond=1,SucFunc=None,FailCond=1,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(18)=(Ident=DrawWeapon,Status=0,ReportedInvalid=false,SucCond=1,SucFunc=None,FailCond=1,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(19)=(Ident=ReloadWeapon,Status=0,ReportedInvalid=false,SucCond=1,SucFunc=None,FailCond=1,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(20)=(Ident=StandCombat,Status=0,ReportedInvalid=false,SucCond=1,SucFunc=None,FailCond=1,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(21)=(Ident=CrouchDown,Status=0,ReportedInvalid=false,SucCond=1,SucFunc=None,FailCond=1,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(22)=(Ident=Prone,Status=0,ReportedInvalid=false,SucCond=1,SucFunc=None,FailCond=1,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(23)=(Ident=Wait,Status=0,ReportedInvalid=false,SucCond=1,SucFunc=None,FailCond=1,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(24)=(Ident=GotoSafeReload,Status=0,ReportedInvalid=false,SucCond=1,SucFunc=None,FailCond=1,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(25)=(Ident=Engage,Status=0,ReportedInvalid=false,SucCond=7,SucFunc=None,FailCond=7,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(26)=(Ident=AttackActionPoint,Status=0,ReportedInvalid=false,SucCond=1,SucFunc=None,FailCond=1,FailFunc=COND_ActionPointCompletelyCompromised,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(27)=(Ident=UseActionPoint,Status=0,ReportedInvalid=false,SucCond=1,SucFunc=None,FailCond=1,FailFunc=COND_ActionPointCompletelyCompromised,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(28)=(Ident=UseActionPointVault,Status=0,ReportedInvalid=false,SucCond=1,SucFunc=None,FailCond=1,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(29)=(Ident=UseX,Status=0,ReportedInvalid=false,SucCond=1,SucFunc=None,FailCond=1,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(30)=(Ident=Guard,Status=0,ReportedInvalid=false,SucCond=76,SucFunc=None,FailCond=1,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(31)=(Ident=AttackWeaponOld,Status=0,ReportedInvalid=false,SucCond=1,SucFunc=None,FailCond=1,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(32)=(Ident=AttackShrunk,Status=0,ReportedInvalid=false,SucCond=1,SucFunc=None,FailCond=95,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(33)=(Ident=AttackShrunkTargetLost,Status=0,ReportedInvalid=false,SucCond=1,SucFunc=None,FailCond=95,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(34)=(Ident=AttackShrunkFailed,Status=0,ReportedInvalid=false,SucCond=1,SucFunc=None,FailCond=95,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(35)=(Ident=AttackShrunkBezerk,Status=0,ReportedInvalid=false,SucCond=1,SucFunc=None,FailCond=95,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(36)=(Ident=AvoidTarget,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=COND_ShouldNotAvoidTarget,FailCond=1,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(37)=(Ident=Default,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=85,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(38)=(Ident=FUBAR,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=1,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(39)=(Ident=Pain,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=96,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(40)=(Ident=idle,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=85,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(41)=(Ident=FaceTarget,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=145,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(42)=(Ident=FaceGuardedActor,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=143,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(43)=(Ident=AlignWithGuardedActor,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=5,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(44)=(Ident=GotoCoverGoal,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=47,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(45)=(Ident=GotoReloadGoal,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=52,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(46)=(Ident=GotoReloadGoalFast,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=52,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(47)=(Ident=GotoAttackGoal,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=47,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(48)=(Ident=GotoGoalFaceActor,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=52,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(49)=(Ident=GotoGoalFacePos,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=47,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(50)=(Ident=GotoGoalFacePosOneStep,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=48,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(51)=(Ident=GotoGoalFocusReciprocalPos,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=50,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(52)=(Ident=GotoMoveAroundGoal,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=52,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(53)=(Ident=MoveAroundBerzerk,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=150,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(54)=(Ident=GotoMelee,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=61,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(55)=(Ident=GotoMeleeBezerk,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=63,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(56)=(Ident=GotoNearTarget,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=41,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(57)=(Ident=GotoJumpAttackRangeFocusActor,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=56,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(58)=(Ident=GotoStomp,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=42,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(59)=(Ident=Stomp,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=135,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(60)=(Ident=StrafeMelee,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=124,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(61)=(Ident=GotoSearchGoal,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=72,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(62)=(Ident=StepAside,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=46,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(63)=(Ident=MeleeAttack,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=92,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(64)=(Ident=GotoMeleeSlow,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=65,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(65)=(Ident=SelectWeapon,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=114,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(66)=(Ident=HoldFire,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=82,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(67)=(Ident=HaltFireMelee,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=79,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(68)=(Ident=ResumeFire,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=105,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(69)=(Ident=Reload,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=104,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(70)=(Ident=FiringIdle,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=85,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(71)=(Ident=ThrowPipeBomb,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=139,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(72)=(Ident=PopUp,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=100,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(73)=(Ident=Crouch,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=20,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(74)=(Ident=StandUpCombat,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=119,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(75)=(Ident=GoProne,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=101,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(76)=(Ident=Cower,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=85,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(77)=(Ident=StartFleeing,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=121,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(78)=(Ident=StandScared,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=121,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(79)=(Ident=Berzerk,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=9,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(80)=(Ident=CircleStrafeLeft,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=110,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(81)=(Ident=CircleStrafeRight,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=112,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(82)=(Ident=GotoStomp,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=42,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(83)=(Ident=Stomp,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=135,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(84)=(Ident=GotoPreset,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=67,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(85)=(Ident=TurnToPreset,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=144,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(86)=(Ident=UsePreset,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=146,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(87)=(Ident=JumpAttack,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=89,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    FSMStates(0)=(FSM=Root,Ident=Default,FSMSucc=false,FSMFail=false,Transitions=((Ident=Pain,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=EngageBerzerk,Cond=0,Func=COND_IsBezerked,Win=0,Code=0,StateTableIndex=0),(Ident=AvoidTarget,Cond=0,Func=COND_ShouldRunAway,Win=0,Code=0,StateTableIndex=0),(Ident=Berzerk,Cond=0,Func=COND_ShouldGoBezerk,Win=0,Code=0,StateTableIndex=0),(Ident=AvoidDanger,Cond=0,Func=COND_ShouldAvoidDanger,Win=0,Code=0,StateTableIndex=0),(Ident=Guard,Cond=75,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=UseX,Cond=0,Func=COND_ShouldUseX,Win=1,Code=0,StateTableIndex=0),(Ident=Engage,Cond=2,Func=COND_ShouldEngage,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(1)=(FSM=Root,Ident=Pain,FSMSucc=false,FSMFail=false,Transitions=((Ident=AvoidTarget,Cond=0,Func=COND_ShouldRunAway,Win=0,Code=0,StateTableIndex=0),(Ident=EngageBerzerk,Cond=0,Func=COND_IsBezerked,Win=1,Code=0,StateTableIndex=0),(Ident=Berzerk,Cond=0,Func=COND_ShouldGoBezerk,Win=1,Code=0,StateTableIndex=0),(Ident=AvoidDanger,Cond=0,Func=COND_ShouldAvoidDanger,Win=1,Code=0,StateTableIndex=0),(Ident=Guard,Cond=75,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=AttackShrunk,Cond=94,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Engage,Cond=2,Func=COND_ShouldEngage,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(2)=(FSM=Root,Ident=idle,FSMSucc=false,FSMFail=false,Transitions=((Ident=Pain,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=AvoidTarget,Cond=0,Func=COND_ShouldRunAway,Win=0,Code=0,StateTableIndex=0),(Ident=EngageBerzerk,Cond=0,Func=COND_IsBezerked,Win=1,Code=0,StateTableIndex=0),(Ident=Berzerk,Cond=0,Func=COND_ShouldGoBezerk,Win=0,Code=0,StateTableIndex=0),(Ident=AvoidDanger,Cond=0,Func=COND_ShouldAvoidDanger,Win=0,Code=0,StateTableIndex=0),(Ident=Guard,Cond=75,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=Engage,Cond=2,Func=COND_ShouldEngage,Win=0,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(3)=(FSM=Root,Ident=Engage,FSMSucc=false,FSMFail=false,Transitions=((Ident=Pain,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=AvoidTarget,Cond=0,Func=COND_ShouldRunAway,Win=0,Code=0,StateTableIndex=0),(Ident=AttackShrunk,Cond=94,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=Berzerk,Cond=0,Func=COND_ShouldGoBezerk,Win=0,Code=0,StateTableIndex=0),(Ident=AvoidDanger,Cond=0,Func=COND_ShouldAvoidDanger,Win=0,Code=0,StateTableIndex=0),(Ident=Guard,Cond=75,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=UseX,Cond=0,Func=COND_ShouldUseX,Win=0,Code=0,StateTableIndex=0),(Ident=Engage,Cond=2,Func=COND_ShouldEngage,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(4)=(FSM=Root,Ident=EngageBerzerk,FSMSucc=false,FSMFail=false,Transitions=((Ident=Pain,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=AvoidTarget,Cond=0,Func=COND_ShouldRunAway,Win=0,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(5)=(FSM=Root,Ident=Guard,FSMSucc=false,FSMFail=false,Transitions=((Ident=Pain,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=Default,Cond=0,Func=COND_ShouldStopGuarding,Win=0,Code=0,StateTableIndex=0),(Ident=AvoidTarget,Cond=0,Func=COND_ShouldRunAway,Win=0,Code=0,StateTableIndex=0),(Ident=AttackShrunk,Cond=94,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=Berzerk,Cond=0,Func=COND_ShouldGoBezerk,Win=0,Code=0,StateTableIndex=0),(Ident=AvoidDanger,Cond=0,Func=COND_ShouldAvoidDanger,Win=0,Code=0,StateTableIndex=0),(Ident=UseX,Cond=0,Func=COND_ShouldUseX,Win=0,Code=0,StateTableIndex=0),(Ident=Engage,Cond=2,Func=COND_ShouldEngage,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(6)=(FSM=Root,Ident=AvoidDanger,FSMSucc=false,FSMFail=false,Transitions=((Ident=Berzerk,Cond=0,Func=COND_ShouldGoBezerk,Win=0,Code=0,StateTableIndex=0),(Ident=AvoidTarget,Cond=0,Func=COND_ShouldRunAway,Win=0,Code=0,StateTableIndex=0),(Ident=AvoidDanger,Cond=0,Func=COND_ShouldAvoidDanger,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(7)=(FSM=Root,Ident=AvoidTarget,FSMSucc=false,FSMFail=false,Transitions=((Ident=Pain,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=AvoidTarget,Cond=0,Func=COND_ShouldRunAway,Win=1,Code=0,StateTableIndex=0),(Ident=Berzerk,Cond=0,Func=COND_ShouldGoBezerk,Win=1,Code=0,StateTableIndex=0),(Ident=AvoidDanger,Cond=0,Func=COND_ShouldAvoidDanger,Win=1,Code=0,StateTableIndex=0),(Ident=Guard,Cond=75,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Engage,Cond=0,Func=COND_ShouldEngage,Win=0,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(8)=(FSM=Root,Ident=AttackShrunk,FSMSucc=false,FSMFail=true,Transitions=((Ident=Engage,Cond=95,Func=COND_ShouldEngage,Win=0,Code=0,StateTableIndex=0),(Ident=AttackShrunk,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(9)=(FSM=Root,Ident=UseX,FSMSucc=false,FSMFail=false,Transitions=((Ident=Pain,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=AvoidTarget,Cond=0,Func=COND_ShouldRunAway,Win=0,Code=0,StateTableIndex=0),(Ident=AttackShrunk,Cond=94,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=Berzerk,Cond=0,Func=COND_ShouldGoBezerk,Win=0,Code=0,StateTableIndex=0),(Ident=AvoidDanger,Cond=0,Func=COND_ShouldAvoidDanger,Win=0,Code=0,StateTableIndex=0),(Ident=Guard,Cond=75,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=Engage,Cond=2,Func=COND_ShouldEngage,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(10)=(FSM=Root,Ident=Berzerk,FSMSucc=false,FSMFail=false,Transitions=((Ident=EngageBerzerk,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(11)=(FSM=AttackPipeBomb,Ident=Default,FSMSucc=true,FSMFail=true,Transitions=((Ident=StandCombat,Cond=32,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=FaceTarget,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=HoldFire,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=ThrowPipeBomb,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(12)=(FSM=AttackPipeBomb,Ident=StandCombat,FSMSucc=false,FSMFail=false,Transitions=((Ident=FaceTarget,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=HoldFire,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=ThrowPipeBomb,Cond=0,Func=COND_ShouldAttackPipeBomb,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(13)=(FSM=AttackPipeBomb,Ident=FaceTarget,FSMSucc=false,FSMFail=false,Transitions=((Ident=HoldFire,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=ThrowPipeBomb,Cond=0,Func=COND_ShouldAttackPipeBomb,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(14)=(FSM=AttackPipeBomb,Ident=HoldFire,FSMSucc=false,FSMFail=false,Transitions=((Ident=FaceTarget,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=HoldFire,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=ThrowPipeBomb,Cond=0,Func=COND_ShouldAttackPipeBomb,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(15)=(FSM=AttackPipeBomb,Ident=ThrowPipeBomb,FSMSucc=true,FSMFail=true,Transitions=none,NodeIndex=0)
    FSMStates(16)=(FSM=GuardAttackMelee,Ident=Default,FSMSucc=true,FSMFail=true,Transitions=((Ident=StandCombat,Cond=32,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=FaceTarget,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=HoldFire,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=MeleeAttack,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(17)=(FSM=GuardAttackMelee,Ident=StandCombat,FSMSucc=false,FSMFail=false,Transitions=((Ident=FaceTarget,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=HoldFire,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=MeleeAttack,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(18)=(FSM=GuardAttackMelee,Ident=FaceTarget,FSMSucc=false,FSMFail=false,Transitions=((Ident=HoldFire,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=MeleeAttack,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(19)=(FSM=GuardAttackMelee,Ident=HoldFire,FSMSucc=false,FSMFail=false,Transitions=((Ident=MeleeAttack,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(20)=(FSM=GuardAttackMelee,Ident=MeleeAttack,FSMSucc=true,FSMFail=true,Transitions=((Ident=MeleeAttack,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(21)=(FSM=GotoGuardAttack,Ident=Default,FSMSucc=true,FSMFail=true,Transitions=((Ident=StandCombat,Cond=32,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=HoldFire,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoAttackGoal,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(22)=(FSM=GotoGuardAttack,Ident=StandCombat,FSMSucc=false,FSMFail=false,Transitions=((Ident=HoldFire,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoAttackGoal,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(23)=(FSM=GotoGuardAttack,Ident=HoldFire,FSMSucc=false,FSMFail=false,Transitions=((Ident=GotoAttackGoal,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(24)=(FSM=GotoGuardAttack,Ident=GotoAttackGoal,FSMSucc=true,FSMFail=true,Transitions=none,NodeIndex=0)
    FSMStates(25)=(FSM=GotoGuardPos,Ident=Default,FSMSucc=true,FSMFail=true,Transitions=((Ident=StandCombat,Cond=32,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=HoldFire,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoGuardPosNoTarget,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(26)=(FSM=GotoGuardPos,Ident=StandCombat,FSMSucc=false,FSMFail=false,Transitions=((Ident=HoldFire,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoGuardPosNoTarget,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(27)=(FSM=GotoGuardPos,Ident=HoldFire,FSMSucc=false,FSMFail=false,Transitions=((Ident=GotoGuardPosNoTarget,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(28)=(FSM=GotoGuardPos,Ident=GotoGuardPosNoTarget,FSMSucc=true,FSMFail=true,Transitions=none,NodeIndex=0)
    FSMStates(29)=(FSM=GotoGuardPosNoTarget,Ident=Default,FSMSucc=true,FSMFail=true,Transitions=((Ident=GotoGoalFacePos,Cond=15,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoGoalFocusReciprocalPos,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(30)=(FSM=GotoGuardPosNoTarget,Ident=GotoGoalFacePos,FSMSucc=true,FSMFail=true,Transitions=none,NodeIndex=0)
    FSMStates(31)=(FSM=GotoGuardPosNoTarget,Ident=GotoGoalFocusReciprocalPos,FSMSucc=true,FSMFail=true,Transitions=none,NodeIndex=0)
    FSMStates(32)=(FSM=GuardAttack,Ident=Default,FSMSucc=true,FSMFail=true,Transitions=((Ident=StandCombat,Cond=33,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=MoveAround,Cond=0,Func=COND_ShouldMoveSide,Win=1,Code=0,StateTableIndex=0),(Ident=CrouchDown,Cond=0,Func=COND_ShouldCrouchEngage,Win=1,Code=0,StateTableIndex=0),(Ident=ResumeFire,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=COND_BeginWaitState,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(33)=(FSM=GuardAttack,Ident=StandCombat,FSMSucc=false,FSMFail=false,Transitions=((Ident=MoveAround,Cond=0,Func=COND_ShouldMoveSide,Win=1,Code=0,StateTableIndex=0),(Ident=CrouchDown,Cond=0,Func=COND_ShouldCrouchEngage,Win=1,Code=0,StateTableIndex=0),(Ident=ResumeFire,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=COND_BeginWaitState,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(34)=(FSM=GuardAttack,Ident=ResumeFire,FSMSucc=false,FSMFail=false,Transitions=((Ident=MoveAround,Cond=0,Func=COND_ShouldMoveSide,Win=1,Code=0,StateTableIndex=0),(Ident=CrouchDown,Cond=0,Func=COND_ShouldCrouchEngage,Win=1,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=COND_BeginWaitState,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(35)=(FSM=GuardAttack,Ident=CrouchDown,FSMSucc=false,FSMFail=false,Transitions=((Ident=MoveAround,Cond=0,Func=COND_ShouldMoveSide,Win=1,Code=0,StateTableIndex=0),(Ident=ResumeFire,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=COND_BeginWaitState,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(36)=(FSM=GuardAttack,Ident=Prone,FSMSucc=false,FSMFail=false,Transitions=((Ident=ResumeFire,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=COND_BeginWaitState,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(37)=(FSM=GuardAttack,Ident=Wait,FSMSucc=false,FSMFail=false,Transitions=((Ident=MoveAround,Cond=0,Func=COND_ShouldMoveSide,Win=0,Code=0,StateTableIndex=0),(Ident=StandCombat,Cond=0,Func=COND_ShouldStandUp,Win=0,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=COND_BeginWaitState,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(38)=(FSM=GuardAttack,Ident=MoveAround,FSMSucc=false,FSMFail=false,Transitions=((Ident=CrouchDown,Cond=0,Func=COND_ShouldCrouchEngage,Win=1,Code=0,StateTableIndex=0),(Ident=ResumeFire,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=COND_BeginWaitState,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(39)=(FSM=GuardWait,Ident=Default,FSMSucc=true,FSMFail=true,Transitions=((Ident=StandCombat,Cond=32,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=HoldFire,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=COND_BeginWaitState,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(40)=(FSM=GuardWait,Ident=StandCombat,FSMSucc=false,FSMFail=false,Transitions=((Ident=HoldFire,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=COND_BeginWaitState,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(41)=(FSM=GuardWait,Ident=HoldFire,FSMSucc=false,FSMFail=false,Transitions=((Ident=Wait,Cond=0,Func=COND_BeginWaitState,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(42)=(FSM=GuardWait,Ident=Wait,FSMSucc=false,FSMFail=false,Transitions=((Ident=Wait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(43)=(FSM=EngageBerzerk,Ident=Default,FSMSucc=false,FSMFail=false,Transitions=((Ident=MeleeAttack,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=FaceTarget,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=AttackShrunkBezerk,Cond=94,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=JumpAttack,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoMeleeBezerk,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoNearTarget,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=MoveAroundBerzerk,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(44)=(FSM=EngageBerzerk,Ident=FaceTarget,FSMSucc=false,FSMFail=false,Transitions=((Ident=AttackShrunkBezerk,Cond=94,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=JumpAttack,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=MoveAroundBerzerk,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(45)=(FSM=EngageBerzerk,Ident=GotoMeleeBezerk,FSMSucc=false,FSMFail=false,Transitions=((Ident=AttackShrunkBezerk,Cond=94,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=JumpAttack,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=Default,Cond=0,Func=AttemptGrapplePlayer,Win=0,Code=0,StateTableIndex=0),(Ident=MeleeAttack,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=GotoNearTarget,Cond=0,Func=None,Win=3,Code=0,StateTableIndex=0),(Ident=GotoMeleeBezerk,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(46)=(FSM=EngageBerzerk,Ident=AttackShrunkBezerk,FSMSucc=false,FSMFail=false,Transitions=((Ident=AttackShrunkBezerk,Cond=94,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=JumpAttack,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoMeleeBezerk,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(47)=(FSM=EngageBerzerk,Ident=idle,FSMSucc=false,FSMFail=false,Transitions=((Ident=FaceTarget,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(48)=(FSM=EngageBerzerk,Ident=MoveAroundBerzerk,FSMSucc=false,FSMFail=false,Transitions=((Ident=FaceTarget,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=JumpAttack,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=GotoNearTarget,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(49)=(FSM=EngageBerzerk,Ident=GotoNearTarget,FSMSucc=false,FSMFail=false,Transitions=((Ident=MeleeAttack,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=JumpAttack,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=Default,Cond=0,Func=AttemptGrapplePlayer,Win=0,Code=0,StateTableIndex=0),(Ident=GotoMeleeBezerk,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=MoveAroundBerzerk,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(50)=(FSM=EngageBerzerk,Ident=MeleeAttack,FSMSucc=true,FSMFail=true,Transitions=none,NodeIndex=0)
    FSMStates(51)=(FSM=EngageBerzerk,Ident=JumpAttack,FSMSucc=true,FSMFail=true,Transitions=none,NodeIndex=0)
    FSMStates(52)=(FSM=GotoActionPoint,Ident=Default,FSMSucc=true,FSMFail=true,Transitions=((Ident=StandCombat,Cond=32,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoWeaponUp,Cond=0,Func=COND_ShouldKeepWeaponUp,Win=1,Code=0,StateTableIndex=0),(Ident=GotoWeaponDown,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(53)=(FSM=GotoActionPoint,Ident=StandCombat,FSMSucc=false,FSMFail=false,Transitions=((Ident=GotoWeaponUp,Cond=0,Func=COND_ShouldKeepWeaponUp,Win=1,Code=0,StateTableIndex=0),(Ident=GotoWeaponDown,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(54)=(FSM=GotoActionPoint,Ident=GotoWeaponUp,FSMSucc=true,FSMFail=true,Transitions=((Ident=GotoWeaponDown,Cond=9,Func=None,Win=0,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(55)=(FSM=GotoActionPoint,Ident=GotoWeaponDown,FSMSucc=true,FSMFail=true,Transitions=none,NodeIndex=0)
    FSMStates(56)=(FSM=GotoWeaponUp,Ident=Default,FSMSucc=true,FSMFail=true,Transitions=((Ident=ResumeFire,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoGoalFaceActor,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(57)=(FSM=GotoWeaponUp,Ident=ResumeFire,FSMSucc=false,FSMFail=false,Transitions=((Ident=GotoGoalFaceActor,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(58)=(FSM=GotoWeaponUp,Ident=GotoGoalFaceActor,FSMSucc=true,FSMFail=true,Transitions=none,NodeIndex=0)
    FSMStates(59)=(FSM=GotoWeaponDown,Ident=Default,FSMSucc=true,FSMFail=true,Transitions=((Ident=HoldFire,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoGoalFacePos,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(60)=(FSM=GotoWeaponDown,Ident=HoldFire,FSMSucc=false,FSMFail=false,Transitions=((Ident=GotoGoalFacePos,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(61)=(FSM=GotoWeaponDown,Ident=GotoGoalFacePos,FSMSucc=true,FSMFail=true,Transitions=none,NodeIndex=0)
    FSMStates(62)=(FSM=GotoAttack,Ident=Default,FSMSucc=true,FSMFail=true,Transitions=((Ident=StandCombat,Cond=32,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=HoldFire,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoAttackGoal,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(63)=(FSM=GotoAttack,Ident=StandCombat,FSMSucc=false,FSMFail=false,Transitions=((Ident=HoldFire,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoAttackGoal,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(64)=(FSM=GotoAttack,Ident=HoldFire,FSMSucc=false,FSMFail=false,Transitions=((Ident=GotoAttackGoal,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(65)=(FSM=GotoAttack,Ident=GotoAttackGoal,FSMSucc=true,FSMFail=true,Transitions=none,NodeIndex=0)
    FSMStates(66)=(FSM=MoveAround,Ident=Default,FSMSucc=true,FSMFail=true,Transitions=((Ident=StandCombat,Cond=32,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=ResumeFire,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoMoveAroundGoal,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(67)=(FSM=MoveAround,Ident=StandCombat,FSMSucc=false,FSMFail=false,Transitions=((Ident=ResumeFire,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoMoveAroundGoal,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(68)=(FSM=MoveAround,Ident=ResumeFire,FSMSucc=false,FSMFail=false,Transitions=((Ident=GotoMoveAroundGoal,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(69)=(FSM=MoveAround,Ident=GotoMoveAroundGoal,FSMSucc=true,FSMFail=true,Transitions=none,NodeIndex=0)
    FSMStates(70)=(FSM=GotoReload,Ident=Default,FSMSucc=true,FSMFail=true,Transitions=((Ident=StandCombat,Cond=32,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=HoldFire,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=GotoReloadGoal,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=ReloadWeapon,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(71)=(FSM=GotoReload,Ident=StandCombat,FSMSucc=false,FSMFail=false,Transitions=((Ident=HoldFire,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoReloadGoal,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=ReloadWeapon,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(72)=(FSM=GotoReload,Ident=HoldFire,FSMSucc=false,FSMFail=false,Transitions=((Ident=GotoReloadGoal,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=ReloadWeapon,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(73)=(FSM=GotoReload,Ident=GotoReloadGoal,FSMSucc=false,FSMFail=false,Transitions=((Ident=ReloadWeapon,Cond=70,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=GotoReloadGoalFast,Cond=30,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=ReloadWeapon,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(74)=(FSM=GotoReload,Ident=GotoReloadGoalFast,FSMSucc=false,FSMFail=false,Transitions=((Ident=ReloadWeapon,Cond=70,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=ReloadWeapon,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(75)=(FSM=GotoReload,Ident=ReloadWeapon,FSMSucc=true,FSMFail=true,Transitions=none,NodeIndex=0)
    FSMStates(76)=(FSM=GotoSearch,Ident=Default,FSMSucc=true,FSMFail=true,Transitions=((Ident=ReloadWeapon,Cond=28,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=StandCombat,Cond=32,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=HoldFire,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoSearchGoal,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(77)=(FSM=GotoSearch,Ident=ReloadWeapon,FSMSucc=false,FSMFail=false,Transitions=((Ident=StandCombat,Cond=32,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=HoldFire,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoSearchGoal,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(78)=(FSM=GotoSearch,Ident=StandCombat,FSMSucc=false,FSMFail=false,Transitions=((Ident=HoldFire,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoSearchGoal,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(79)=(FSM=GotoSearch,Ident=HoldFire,FSMSucc=false,FSMFail=false,Transitions=((Ident=GotoSearchGoal,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(80)=(FSM=GotoSearch,Ident=GotoSearchGoal,FSMSucc=true,FSMFail=true,Transitions=none,NodeIndex=0)
    FSMStates(81)=(FSM=GotoCover,Ident=Default,FSMSucc=true,FSMFail=true,Transitions=((Ident=Pain,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=StandCombat,Cond=32,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=HoldFire,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=GotoCoverGoal,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(82)=(FSM=GotoCover,Ident=StandCombat,FSMSucc=false,FSMFail=false,Transitions=((Ident=Pain,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=HoldFire,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoCoverGoal,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(83)=(FSM=GotoCover,Ident=HoldFire,FSMSucc=false,FSMFail=false,Transitions=((Ident=Pain,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoCoverGoal,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(84)=(FSM=GotoCover,Ident=Pain,FSMSucc=false,FSMFail=false,Transitions=((Ident=Pain,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=StandCombat,Cond=32,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoCoverGoal,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(85)=(FSM=GotoCover,Ident=GotoCoverGoal,FSMSucc=true,FSMFail=true,Transitions=((Ident=Pain,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(86)=(FSM=AvoidDanger,Ident=Default,FSMSucc=true,FSMFail=true,Transitions=((Ident=HoldFire,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=StandScared,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=GotoGoalFacePosOneStep,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(87)=(FSM=AvoidDanger,Ident=HoldFire,FSMSucc=false,FSMFail=false,Transitions=((Ident=StandScared,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=GotoGoalFacePosOneStep,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(88)=(FSM=AvoidDanger,Ident=StandScared,FSMSucc=false,FSMFail=false,Transitions=((Ident=GotoGoalFacePosOneStep,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(89)=(FSM=AvoidDanger,Ident=GotoGoalFacePosOneStep,FSMSucc=true,FSMFail=true,Transitions=none,NodeIndex=0)
    FSMStates(90)=(FSM=DrawWeapon,Ident=Default,FSMSucc=false,FSMFail=false,Transitions=((Ident=FaceTarget,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=StandCombat,Cond=32,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=SelectWeapon,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(91)=(FSM=DrawWeapon,Ident=FaceTarget,FSMSucc=false,FSMFail=false,Transitions=((Ident=FaceTarget,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=StandCombat,Cond=32,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=SelectWeapon,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(92)=(FSM=DrawWeapon,Ident=StandCombat,FSMSucc=false,FSMFail=false,Transitions=((Ident=SelectWeapon,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(93)=(FSM=DrawWeapon,Ident=SelectWeapon,FSMSucc=true,FSMFail=true,Transitions=none,NodeIndex=0)
    FSMStates(94)=(FSM=ReloadWeapon,Ident=Default,FSMSucc=false,FSMFail=false,Transitions=((Ident=FaceTarget,Cond=0,Func=COND_ShouldFaceTargetWhileReloading,Win=1,Code=0,StateTableIndex=0),(Ident=Reload,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(95)=(FSM=ReloadWeapon,Ident=FaceTarget,FSMSucc=false,FSMFail=false,Transitions=((Ident=FaceTarget,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Reload,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(96)=(FSM=ReloadWeapon,Ident=Reload,FSMSucc=true,FSMFail=true,Transitions=none,NodeIndex=0)
    FSMStates(97)=(FSM=StandCombat,Ident=Default,FSMSucc=false,FSMFail=false,Transitions=((Ident=HoldFire,Cond=39,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=StandUpCombat,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(98)=(FSM=StandCombat,Ident=HoldFire,FSMSucc=false,FSMFail=false,Transitions=((Ident=StandUpCombat,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(99)=(FSM=StandCombat,Ident=StandUpCombat,FSMSucc=true,FSMFail=true,Transitions=none,NodeIndex=0)
    FSMStates(100)=(FSM=CrouchDown,Ident=Default,FSMSucc=false,FSMFail=false,Transitions=((Ident=FaceTarget,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Crouch,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(101)=(FSM=CrouchDown,Ident=FaceTarget,FSMSucc=false,FSMFail=false,Transitions=((Ident=FaceTarget,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Crouch,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(102)=(FSM=CrouchDown,Ident=Crouch,FSMSucc=true,FSMFail=true,Transitions=none,NodeIndex=0)
    FSMStates(103)=(FSM=Prone,Ident=Default,FSMSucc=false,FSMFail=false,Transitions=((Ident=FaceTarget,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GoProne,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(104)=(FSM=Prone,Ident=FaceTarget,FSMSucc=false,FSMFail=false,Transitions=((Ident=FaceTarget,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GoProne,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(105)=(FSM=Prone,Ident=GoProne,FSMSucc=true,FSMFail=true,Transitions=none,NodeIndex=0)
    FSMStates(106)=(FSM=Wait,Ident=Default,FSMSucc=true,FSMFail=true,Transitions=((Ident=FaceTarget,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=StepAside,Cond=0,Func=COND_ShouldStepAside,Win=0,Code=0,StateTableIndex=0),(Ident=FaceGuardedActor,Cond=7,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(107)=(FSM=Wait,Ident=FaceTarget,FSMSucc=false,FSMFail=false,Transitions=((Ident=StepAside,Cond=0,Func=COND_ShouldStepAside,Win=0,Code=0,StateTableIndex=0),(Ident=FaceGuardedActor,Cond=7,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(108)=(FSM=Wait,Ident=idle,FSMSucc=false,FSMFail=false,Transitions=((Ident=FaceTarget,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=StepAside,Cond=0,Func=COND_ShouldStepAside,Win=0,Code=0,StateTableIndex=0),(Ident=FaceGuardedActor,Cond=7,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(109)=(FSM=Wait,Ident=StepAside,FSMSucc=false,FSMFail=false,Transitions=((Ident=FaceTarget,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=StepAside,Cond=0,Func=COND_ShouldStepAside,Win=1,Code=0,StateTableIndex=0),(Ident=FaceGuardedActor,Cond=7,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(110)=(FSM=Wait,Ident=FaceGuardedActor,FSMSucc=false,FSMFail=false,Transitions=((Ident=FaceTarget,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=StepAside,Cond=0,Func=COND_ShouldStepAside,Win=0,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(111)=(FSM=GotoSafeReload,Ident=Default,FSMSucc=false,FSMFail=false,Transitions=((Ident=GotoReloadGoalFast,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Crouch,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=HoldFire,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=ReloadWeapon,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=ResumeFire,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=StandCombat,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(112)=(FSM=GotoSafeReload,Ident=GotoReloadGoalFast,FSMSucc=false,FSMFail=false,Transitions=((Ident=Crouch,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=HoldFire,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=ReloadWeapon,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=ResumeFire,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=StandCombat,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(113)=(FSM=GotoSafeReload,Ident=Crouch,FSMSucc=false,FSMFail=false,Transitions=((Ident=HoldFire,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=ReloadWeapon,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=ResumeFire,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=StandCombat,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(114)=(FSM=GotoSafeReload,Ident=HoldFire,FSMSucc=false,FSMFail=false,Transitions=((Ident=ReloadWeapon,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=ResumeFire,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=StandCombat,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(115)=(FSM=GotoSafeReload,Ident=ReloadWeapon,FSMSucc=false,FSMFail=false,Transitions=((Ident=ResumeFire,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=StandCombat,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(116)=(FSM=GotoSafeReload,Ident=ResumeFire,FSMSucc=false,FSMFail=false,Transitions=((Ident=StandCombat,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(117)=(FSM=GotoSafeReload,Ident=StandCombat,FSMSucc=true,FSMFail=true,Transitions=none,NodeIndex=0)
    FSMStates(118)=(FSM=Engage,Ident=Default,FSMSucc=true,FSMFail=true,Transitions=((Ident=StandCombat,Cond=0,Func=COND_ShouldStandCombat,Win=1,Code=0,StateTableIndex=0),(Ident=DrawWeapon,Cond=83,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoNearTarget,Cond=8,Func=COND_ShouldSeek,Win=1,Code=0,StateTableIndex=0),(Ident=GotoMelee,Cond=0,Func=COND_ShouldMelee,Win=1,Code=0,StateTableIndex=0),(Ident=FaceTarget,Cond=0,Func=COND_TurnTowardsTarget,Win=1,Code=0,StateTableIndex=0),(Ident=AttackActionPoint,Cond=0,Func=COND_ShouldGotoActionPoint,Win=1,Code=0,StateTableIndex=0),(Ident=ResumeFire,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(119)=(FSM=Engage,Ident=StandCombat,FSMSucc=false,FSMFail=false,Transitions=((Ident=DrawWeapon,Cond=83,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoMelee,Cond=0,Func=COND_ShouldMelee,Win=1,Code=0,StateTableIndex=0),(Ident=ResumeFire,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(120)=(FSM=Engage,Ident=DrawWeapon,FSMSucc=false,FSMFail=false,Transitions=((Ident=ResumeFire,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(121)=(FSM=Engage,Ident=AttackActionPoint,FSMSucc=false,FSMFail=false,Transitions=((Ident=MoveAround,Cond=0,Func=COND_ActionPointCompletelyCompromised,Win=0,Code=0,StateTableIndex=0),(Ident=MoveAround,Cond=0,Func=COND_ReleaseActionPoint,Win=3,Code=0,StateTableIndex=0),(Ident=GotoMelee,Cond=0,Func=COND_ShouldMelee,Win=0,Code=0,StateTableIndex=0),(Ident=GotoNearTarget,Cond=8,Func=COND_ShouldSeek,Win=0,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(122)=(FSM=Engage,Ident=GotoNearTarget,FSMSucc=false,FSMFail=false,Transitions=((Ident=FaceTarget,Cond=8,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=ResumeFire,Cond=0,Func=COND_TargetVisible2,Win=0,Code=0,StateTableIndex=0),(Ident=ResumeFire,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoMelee,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(123)=(FSM=Engage,Ident=FaceTarget,FSMSucc=false,FSMFail=false,Transitions=((Ident=ResumeFire,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoMelee,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(124)=(FSM=Engage,Ident=ResumeFire,FSMSucc=false,FSMFail=false,Transitions=((Ident=FiringIdle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(125)=(FSM=Engage,Ident=MeleeAttack,FSMSucc=true,FSMFail=false,Transitions=none,NodeIndex=0)
    FSMStates(126)=(FSM=Engage,Ident=GotoMelee,FSMSucc=false,FSMFail=false,Transitions=((Ident=MeleeAttack,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=ResumeFire,Cond=13,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=ResumeFire,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoMelee,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(127)=(FSM=Engage,Ident=MoveAround,FSMSucc=false,FSMFail=false,Transitions=((Ident=MeleeAttack,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=AttackActionPoint,Cond=0,Func=COND_ShouldGotoActionPoint,Win=1,Code=0,StateTableIndex=0),(Ident=GotoSafeReload,Cond=0,Func=COND_ShouldGotoSafeReload,Win=0,Code=0,StateTableIndex=0),(Ident=ReloadWeapon,Cond=28,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=FiringIdle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(128)=(FSM=Engage,Ident=ReloadWeapon,FSMSucc=false,FSMFail=false,Transitions=((Ident=ResumeFire,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(129)=(FSM=Engage,Ident=GotoSafeReload,FSMSucc=false,FSMFail=false,Transitions=((Ident=ResumeFire,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(130)=(FSM=Engage,Ident=Wait,FSMSucc=false,FSMFail=false,Transitions=((Ident=MeleeAttack,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=GotoSafeReload,Cond=0,Func=COND_ShouldGotoSafeReload,Win=0,Code=0,StateTableIndex=0),(Ident=ReloadWeapon,Cond=28,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=GotoNearTarget,Cond=8,Func=COND_ShouldSeek,Win=1,Code=0,StateTableIndex=0),(Ident=GotoMelee,Cond=0,Func=COND_ShouldMelee,Win=0,Code=0,StateTableIndex=0),(Ident=FaceTarget,Cond=0,Func=COND_TurnTowardsTarget,Win=0,Code=0,StateTableIndex=0),(Ident=AttackActionPoint,Cond=0,Func=COND_ShouldGotoActionPoint,Win=0,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(131)=(FSM=Engage,Ident=FiringIdle,FSMSucc=false,FSMFail=false,Transitions=((Ident=MeleeAttack,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=GotoSafeReload,Cond=0,Func=COND_ShouldGotoSafeReload,Win=0,Code=0,StateTableIndex=0),(Ident=ReloadWeapon,Cond=28,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=GotoNearTarget,Cond=8,Func=COND_ShouldSeek,Win=1,Code=0,StateTableIndex=0),(Ident=GotoMelee,Cond=0,Func=COND_ShouldMelee,Win=0,Code=0,StateTableIndex=0),(Ident=FaceTarget,Cond=0,Func=COND_TurnTowardsTarget,Win=0,Code=0,StateTableIndex=0),(Ident=AttackActionPoint,Cond=0,Func=COND_ShouldGotoActionPoint,Win=0,Code=0,StateTableIndex=0),(Ident=FiringIdle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(132)=(FSM=AttackActionPoint,Ident=Default,FSMSucc=false,FSMFail=false,Transitions=((Ident=ResumeFire,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=StandUpCombat,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoGoalFaceActor,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=UseActionPoint,Cond=0,Func=COND_ShouldUseActionPoint,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(133)=(FSM=AttackActionPoint,Ident=ResumeFire,FSMSucc=false,FSMFail=false,Transitions=((Ident=StandUpCombat,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoGoalFaceActor,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=UseActionPoint,Cond=0,Func=COND_ShouldUseActionPoint,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(134)=(FSM=AttackActionPoint,Ident=StandUpCombat,FSMSucc=false,FSMFail=false,Transitions=((Ident=ResumeFire,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoGoalFaceActor,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=UseActionPoint,Cond=0,Func=COND_ShouldUseActionPoint,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(135)=(FSM=AttackActionPoint,Ident=GotoGoalFaceActor,FSMSucc=false,FSMFail=true,Transitions=((Ident=UseActionPoint,Cond=0,Func=COND_ShouldUseActionPoint,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=COND_ReleaseActionPoint,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(136)=(FSM=AttackActionPoint,Ident=UseActionPoint,FSMSucc=false,FSMFail=false,Transitions=((Ident=UseActionPointVault,Cond=0,Func=COND_ShouldVaultAP,Win=1,Code=0,StateTableIndex=0),(Ident=ResumeFire,Cond=0,Func=COND_ShouldAdvanceAP,Win=1,Code=0,StateTableIndex=0),(Ident=ResumeFire,Cond=0,Func=COND_ShouldFlankAP,Win=1,Code=0,StateTableIndex=0),(Ident=ResumeFire,Cond=0,Func=COND_ShouldLateralAP,Win=1,Code=0,StateTableIndex=0),(Ident=ResumeFire,Cond=0,Func=COND_ShouldRetreatAP,Win=1,Code=0,StateTableIndex=0),(Ident=UseActionPoint,Cond=0,Func=COND_ShouldUseActionPoint,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(137)=(FSM=AttackActionPoint,Ident=UseActionPointVault,FSMSucc=false,FSMFail=true,Transitions=((Ident=ResumeFire,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=StandUpCombat,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoGoalFaceActor,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=COND_ReleaseActionPoint,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(138)=(FSM=AttackActionPoint,Ident=idle,FSMSucc=false,FSMFail=false,Transitions=((Ident=UseActionPoint,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(139)=(FSM=UseActionPoint,Ident=Default,FSMSucc=true,FSMFail=true,Transitions=((Ident=Crouch,Cond=28,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Reload,Cond=28,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=PopUp,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(140)=(FSM=UseActionPoint,Ident=Crouch,FSMSucc=false,FSMFail=false,Transitions=((Ident=Reload,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=PopUp,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(141)=(FSM=UseActionPoint,Ident=Reload,FSMSucc=false,FSMFail=false,Transitions=((Ident=PopUp,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(142)=(FSM=UseActionPoint,Ident=PopUp,FSMSucc=true,FSMFail=true,Transitions=none,NodeIndex=0)
    FSMStates(143)=(FSM=UseActionPointVault,Ident=Default,FSMSucc=true,FSMFail=true,Transitions=((Ident=PopUp,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(144)=(FSM=UseActionPointVault,Ident=PopUp,FSMSucc=true,FSMFail=true,Transitions=none,NodeIndex=0)
    FSMStates(145)=(FSM=UseX,Ident=Default,FSMSucc=true,FSMFail=true,Transitions=((Ident=GotoPreset,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=TurnToPreset,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=UsePreset,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(146)=(FSM=UseX,Ident=GotoPreset,FSMSucc=false,FSMFail=true,Transitions=((Ident=TurnToPreset,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=UsePreset,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(147)=(FSM=UseX,Ident=TurnToPreset,FSMSucc=false,FSMFail=false,Transitions=((Ident=UsePreset,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(148)=(FSM=UseX,Ident=UsePreset,FSMSucc=true,FSMFail=true,Transitions=none,NodeIndex=0)
    FSMStates(149)=(FSM=UseX,Ident=idle,FSMSucc=true,FSMFail=true,Transitions=none,NodeIndex=0)
    FSMStates(150)=(FSM=Guard,Ident=Default,FSMSucc=true,FSMFail=true,Transitions=((Ident=GuardAttackMelee,Cond=0,Func=COND_ShouldGuardAttackMelee,Win=0,Code=0,StateTableIndex=0),(Ident=DrawWeapon,Cond=83,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=AttackActionPoint,Cond=0,Func=COND_ShouldGotoActionPoint,Win=1,Code=0,StateTableIndex=0),(Ident=UseActionPoint,Cond=0,Func=COND_ShouldUseActionPoint,Win=1,Code=0,StateTableIndex=0),(Ident=ReloadWeapon,Cond=28,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=StandCombat,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoGuardAttack,Cond=0,Func=COND_ShouldGotoGuardAttack,Win=1,Code=0,StateTableIndex=0),(Ident=GotoGuardPos,Cond=0,Func=COND_ShouldGotoGuardPos,Win=1,Code=0,StateTableIndex=0),(Ident=GuardAttack,Cond=2,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GuardWait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(151)=(FSM=Guard,Ident=StandCombat,FSMSucc=false,FSMFail=false,Transitions=((Ident=GuardAttackMelee,Cond=0,Func=COND_ShouldGuardAttackMelee,Win=1,Code=0,StateTableIndex=0),(Ident=DrawWeapon,Cond=83,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=AttackActionPoint,Cond=0,Func=COND_ShouldGotoActionPoint,Win=1,Code=0,StateTableIndex=0),(Ident=UseActionPoint,Cond=0,Func=COND_ShouldUseActionPoint,Win=1,Code=0,StateTableIndex=0),(Ident=GotoGuardAttack,Cond=0,Func=COND_ShouldGotoGuardAttack,Win=1,Code=0,StateTableIndex=0),(Ident=GotoGuardPos,Cond=0,Func=COND_ShouldGotoGuardPos,Win=1,Code=0,StateTableIndex=0),(Ident=GuardAttack,Cond=2,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GuardWait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(152)=(FSM=Guard,Ident=GuardAttackMelee,FSMSucc=false,FSMFail=false,Transitions=((Ident=GuardAttackMelee,Cond=0,Func=COND_ShouldGuardAttackMelee,Win=1,Code=0,StateTableIndex=0),(Ident=DrawWeapon,Cond=83,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=AttackActionPoint,Cond=0,Func=COND_ShouldGotoActionPoint,Win=1,Code=0,StateTableIndex=0),(Ident=UseActionPoint,Cond=0,Func=COND_ShouldUseActionPoint,Win=1,Code=0,StateTableIndex=0),(Ident=GotoGuardAttack,Cond=0,Func=COND_ShouldGotoGuardAttack,Win=1,Code=0,StateTableIndex=0),(Ident=GotoGuardPos,Cond=0,Func=COND_ShouldGotoGuardPos,Win=1,Code=0,StateTableIndex=0),(Ident=GuardAttack,Cond=2,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GuardWait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(153)=(FSM=Guard,Ident=DrawWeapon,FSMSucc=false,FSMFail=false,Transitions=((Ident=GuardAttackMelee,Cond=0,Func=COND_ShouldGuardAttackMelee,Win=1,Code=0,StateTableIndex=0),(Ident=AttackActionPoint,Cond=0,Func=COND_ShouldGotoActionPoint,Win=1,Code=0,StateTableIndex=0),(Ident=UseActionPoint,Cond=0,Func=COND_ShouldUseActionPoint,Win=1,Code=0,StateTableIndex=0),(Ident=ReloadWeapon,Cond=28,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoGuardAttack,Cond=0,Func=COND_ShouldGotoGuardAttack,Win=1,Code=0,StateTableIndex=0),(Ident=GotoGuardPos,Cond=0,Func=COND_ShouldGotoGuardPos,Win=1,Code=0,StateTableIndex=0),(Ident=GuardAttack,Cond=2,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GuardWait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(154)=(FSM=Guard,Ident=ReloadWeapon,FSMSucc=false,FSMFail=false,Transitions=((Ident=GuardAttackMelee,Cond=0,Func=COND_ShouldGuardAttackMelee,Win=0,Code=0,StateTableIndex=0),(Ident=AttackActionPoint,Cond=0,Func=COND_ShouldGotoActionPoint,Win=1,Code=0,StateTableIndex=0),(Ident=UseActionPoint,Cond=0,Func=COND_ShouldUseActionPoint,Win=1,Code=0,StateTableIndex=0),(Ident=GotoGuardAttack,Cond=0,Func=COND_ShouldGotoGuardAttack,Win=1,Code=0,StateTableIndex=0),(Ident=GotoGuardPos,Cond=0,Func=COND_ShouldGotoGuardPos,Win=1,Code=0,StateTableIndex=0),(Ident=GuardAttack,Cond=2,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GuardWait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(155)=(FSM=Guard,Ident=GotoGuardAttack,FSMSucc=false,FSMFail=false,Transitions=((Ident=GuardAttackMelee,Cond=0,Func=COND_ShouldGuardAttackMelee,Win=0,Code=0,StateTableIndex=0),(Ident=AttackActionPoint,Cond=0,Func=COND_ShouldGotoActionPoint,Win=0,Code=0,StateTableIndex=0),(Ident=ReloadWeapon,Cond=28,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=GotoGuardPos,Cond=0,Func=COND_ShouldGotoGuardPos,Win=1,Code=0,StateTableIndex=0),(Ident=GuardAttack,Cond=2,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GuardWait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(156)=(FSM=Guard,Ident=GotoGuardPos,FSMSucc=false,FSMFail=false,Transitions=((Ident=GuardAttackMelee,Cond=0,Func=COND_ShouldGuardAttackMelee,Win=0,Code=0,StateTableIndex=0),(Ident=AttackActionPoint,Cond=0,Func=COND_ShouldGotoActionPoint,Win=0,Code=0,StateTableIndex=0),(Ident=ReloadWeapon,Cond=28,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=GotoGuardAttack,Cond=0,Func=COND_ShouldGotoGuardAttack,Win=0,Code=0,StateTableIndex=0),(Ident=GuardAttack,Cond=2,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GuardWait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(157)=(FSM=Guard,Ident=GuardAttack,FSMSucc=false,FSMFail=false,Transitions=((Ident=GuardAttackMelee,Cond=0,Func=COND_ShouldGuardAttackMelee,Win=0,Code=0,StateTableIndex=0),(Ident=AttackActionPoint,Cond=0,Func=COND_ShouldGotoActionPoint,Win=0,Code=0,StateTableIndex=0),(Ident=ReloadWeapon,Cond=28,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=GotoGuardAttack,Cond=0,Func=COND_ShouldGotoGuardAttack,Win=0,Code=0,StateTableIndex=0),(Ident=GotoGuardPos,Cond=0,Func=COND_ShouldGotoGuardPos,Win=0,Code=0,StateTableIndex=0),(Ident=GuardAttack,Cond=2,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GuardWait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(158)=(FSM=Guard,Ident=GuardWait,FSMSucc=false,FSMFail=false,Transitions=((Ident=GuardAttackMelee,Cond=0,Func=COND_ShouldGuardAttackMelee,Win=0,Code=0,StateTableIndex=0),(Ident=AttackActionPoint,Cond=0,Func=COND_ShouldGotoActionPoint,Win=0,Code=0,StateTableIndex=0),(Ident=GuardAttack,Cond=2,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=GotoGuardPos,Cond=0,Func=COND_ShouldGotoGuardPos,Win=0,Code=0,StateTableIndex=0),(Ident=GuardWait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(159)=(FSM=Guard,Ident=AlignWithGuardedActor,FSMSucc=false,FSMFail=false,Transitions=((Ident=GuardAttackMelee,Cond=0,Func=COND_ShouldGuardAttackMelee,Win=0,Code=0,StateTableIndex=0),(Ident=AttackActionPoint,Cond=0,Func=COND_ShouldGotoActionPoint,Win=1,Code=0,StateTableIndex=0),(Ident=ReloadWeapon,Cond=28,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoGuardAttack,Cond=0,Func=COND_ShouldGotoGuardAttack,Win=1,Code=0,StateTableIndex=0),(Ident=GuardAttack,Cond=2,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GuardWait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(160)=(FSM=Guard,Ident=GotoActionPoint,FSMSucc=false,FSMFail=false,Transitions=((Ident=GuardAttackMelee,Cond=0,Func=COND_ShouldGuardAttackMelee,Win=0,Code=0,StateTableIndex=0),(Ident=GotoGuardAttack,Cond=0,Func=COND_ShouldGotoGuardAttack,Win=3,Code=0,StateTableIndex=0),(Ident=UseActionPoint,Cond=0,Func=COND_ShouldUseActionPoint,Win=1,Code=0,StateTableIndex=0),(Ident=GotoActionPoint,Cond=0,Func=COND_ShouldGotoActionPoint,Win=1,Code=0,StateTableIndex=0),(Ident=GotoGuardAttack,Cond=0,Func=COND_ShouldGotoGuardAttack,Win=1,Code=0,StateTableIndex=0),(Ident=GotoGuardPos,Cond=0,Func=COND_ShouldGotoGuardPos,Win=1,Code=0,StateTableIndex=0),(Ident=AlignWithGuardedActor,Cond=0,Func=COND_ShouldAlignWithGuardedActor,Win=1,Code=0,StateTableIndex=0),(Ident=GuardAttack,Cond=2,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GuardWait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(161)=(FSM=Guard,Ident=UseActionPoint,FSMSucc=false,FSMFail=false,Transitions=((Ident=GuardAttackMelee,Cond=0,Func=COND_ShouldGuardAttackMelee,Win=1,Code=0,StateTableIndex=0),(Ident=GotoGuardAttack,Cond=0,Func=COND_ShouldGotoGuardAttack,Win=3,Code=0,StateTableIndex=0),(Ident=GotoActionPoint,Cond=0,Func=COND_ShouldGotoActionPoint,Win=1,Code=0,StateTableIndex=0),(Ident=UseActionPoint,Cond=0,Func=COND_ShouldUseActionPoint,Win=2,Code=0,StateTableIndex=0),(Ident=GotoGuardAttack,Cond=0,Func=COND_ShouldGotoGuardAttack,Win=1,Code=0,StateTableIndex=0),(Ident=GotoGuardPos,Cond=0,Func=COND_ShouldGotoGuardPos,Win=1,Code=0,StateTableIndex=0),(Ident=AlignWithGuardedActor,Cond=0,Func=COND_ShouldAlignWithGuardedActor,Win=1,Code=0,StateTableIndex=0),(Ident=GuardAttack,Cond=2,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GuardWait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(162)=(FSM=Guard,Ident=AttackActionPoint,FSMSucc=false,FSMFail=false,Transitions=((Ident=GuardAttack,Cond=0,Func=COND_ActionPointCompletelyCompromised,Win=0,Code=0,StateTableIndex=0),(Ident=GuardAttack,Cond=0,Func=COND_ReleaseActionPoint,Win=3,Code=0,StateTableIndex=0),(Ident=GuardAttackMelee,Cond=0,Func=COND_ShouldMelee,Win=0,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(163)=(FSM=AttackWeaponOld,Ident=Default,FSMSucc=true,FSMFail=true,Transitions=((Ident=StandCombat,Cond=0,Func=COND_ShouldStandCombat,Win=0,Code=0,StateTableIndex=0),(Ident=UseActionPoint,Cond=0,Func=COND_ShouldUseActionPoint,Win=1,Code=0,StateTableIndex=0),(Ident=GotoActionPoint,Cond=0,Func=COND_ShouldGotoActionPoint,Win=1,Code=0,StateTableIndex=0),(Ident=GotoReload,Cond=0,Func=COND_ShouldGotoReload,Win=1,Code=0,StateTableIndex=0),(Ident=MoveAround,Cond=0,Func=COND_ShouldMoveSide,Win=1,Code=0,StateTableIndex=0),(Ident=ReloadWeapon,Cond=28,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoAttack,Cond=0,Func=COND_ShouldGotoAttack,Win=1,Code=0,StateTableIndex=0),(Ident=CrouchDown,Cond=0,Func=COND_ShouldCrouchEngage,Win=1,Code=0,StateTableIndex=0),(Ident=Prone,Cond=0,Func=COND_ShouldProneEngage,Win=1,Code=0,StateTableIndex=0),(Ident=ResumeFire,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=COND_BeginWaitState,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(164)=(FSM=AttackWeaponOld,Ident=StandCombat,FSMSucc=false,FSMFail=false,Transitions=((Ident=UseActionPoint,Cond=0,Func=COND_ShouldUseActionPoint,Win=1,Code=0,StateTableIndex=0),(Ident=GotoActionPoint,Cond=0,Func=COND_ShouldGotoActionPoint,Win=1,Code=0,StateTableIndex=0),(Ident=GotoReload,Cond=0,Func=COND_ShouldGotoReload,Win=1,Code=0,StateTableIndex=0),(Ident=MoveAround,Cond=0,Func=COND_ShouldMoveSide,Win=1,Code=0,StateTableIndex=0),(Ident=ReloadWeapon,Cond=28,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoAttack,Cond=0,Func=COND_ShouldGotoAttack,Win=1,Code=0,StateTableIndex=0),(Ident=CrouchDown,Cond=0,Func=COND_ShouldCrouchEngage,Win=1,Code=0,StateTableIndex=0),(Ident=Prone,Cond=0,Func=COND_ShouldProneEngage,Win=1,Code=0,StateTableIndex=0),(Ident=ResumeFire,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=COND_BeginWaitState,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(165)=(FSM=AttackWeaponOld,Ident=GotoReload,FSMSucc=false,FSMFail=false,Transitions=((Ident=GotoActionPoint,Cond=0,Func=COND_ShouldGotoActionPoint,Win=0,Code=0,StateTableIndex=0),(Ident=MoveAround,Cond=0,Func=COND_ShouldMoveSide,Win=1,Code=0,StateTableIndex=0),(Ident=GotoAttack,Cond=0,Func=COND_ShouldGotoAttack,Win=1,Code=0,StateTableIndex=0),(Ident=CrouchDown,Cond=0,Func=COND_ShouldCrouchEngage,Win=1,Code=0,StateTableIndex=0),(Ident=Prone,Cond=0,Func=COND_ShouldProneEngage,Win=1,Code=0,StateTableIndex=0),(Ident=ResumeFire,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=COND_BeginWaitState,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(166)=(FSM=AttackWeaponOld,Ident=ReloadWeapon,FSMSucc=false,FSMFail=false,Transitions=((Ident=GotoActionPoint,Cond=0,Func=COND_ShouldGotoActionPoint,Win=1,Code=0,StateTableIndex=0),(Ident=UseActionPoint,Cond=0,Func=COND_ShouldUseActionPoint,Win=1,Code=0,StateTableIndex=0),(Ident=GotoActionPoint,Cond=0,Func=COND_ShouldGotoActionPoint,Win=1,Code=0,StateTableIndex=0),(Ident=MoveAround,Cond=0,Func=COND_ShouldMoveSide,Win=1,Code=0,StateTableIndex=0),(Ident=GotoAttack,Cond=0,Func=COND_ShouldGotoAttack,Win=1,Code=0,StateTableIndex=0),(Ident=CrouchDown,Cond=0,Func=COND_ShouldCrouchEngage,Win=1,Code=0,StateTableIndex=0),(Ident=Prone,Cond=0,Func=COND_ShouldProneEngage,Win=1,Code=0,StateTableIndex=0),(Ident=ResumeFire,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=COND_BeginWaitState,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(167)=(FSM=AttackWeaponOld,Ident=ResumeFire,FSMSucc=false,FSMFail=false,Transitions=((Ident=GotoActionPoint,Cond=0,Func=COND_ShouldGotoActionPoint,Win=1,Code=0,StateTableIndex=0),(Ident=UseActionPoint,Cond=0,Func=COND_ShouldUseActionPoint,Win=1,Code=0,StateTableIndex=0),(Ident=GotoReload,Cond=0,Func=COND_ShouldGotoReload,Win=1,Code=0,StateTableIndex=0),(Ident=MoveAround,Cond=0,Func=COND_ShouldMoveSide,Win=1,Code=0,StateTableIndex=0),(Ident=ReloadWeapon,Cond=28,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoAttack,Cond=0,Func=COND_ShouldGotoAttack,Win=1,Code=0,StateTableIndex=0),(Ident=CrouchDown,Cond=0,Func=COND_ShouldCrouchEngage,Win=1,Code=0,StateTableIndex=0),(Ident=Prone,Cond=0,Func=COND_ShouldProneEngage,Win=1,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=COND_BeginWaitState,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(168)=(FSM=AttackWeaponOld,Ident=GotoAttack,FSMSucc=false,FSMFail=false,Transitions=((Ident=GotoActionPoint,Cond=0,Func=COND_ShouldGotoActionPoint,Win=0,Code=0,StateTableIndex=0),(Ident=GotoReload,Cond=0,Func=COND_ShouldGotoReload,Win=0,Code=0,StateTableIndex=0),(Ident=MoveAround,Cond=0,Func=COND_ShouldMoveSide,Win=1,Code=0,StateTableIndex=0),(Ident=ReloadWeapon,Cond=28,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=CrouchDown,Cond=0,Func=COND_ShouldCrouchEngage,Win=1,Code=0,StateTableIndex=0),(Ident=Prone,Cond=0,Func=COND_ShouldProneEngage,Win=1,Code=0,StateTableIndex=0),(Ident=ResumeFire,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=COND_BeginWaitState,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(169)=(FSM=AttackWeaponOld,Ident=MoveAround,FSMSucc=false,FSMFail=false,Transitions=((Ident=GotoActionPoint,Cond=0,Func=COND_ShouldGotoActionPoint,Win=1,Code=0,StateTableIndex=0),(Ident=GotoReload,Cond=0,Func=COND_ShouldGotoReload,Win=0,Code=0,StateTableIndex=0),(Ident=ReloadWeapon,Cond=28,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoAttack,Cond=0,Func=COND_ShouldGotoAttack,Win=1,Code=0,StateTableIndex=0),(Ident=CrouchDown,Cond=0,Func=COND_ShouldCrouchEngage,Win=1,Code=0,StateTableIndex=0),(Ident=Prone,Cond=0,Func=COND_ShouldProneEngage,Win=1,Code=0,StateTableIndex=0),(Ident=ResumeFire,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=COND_BeginWaitState,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(170)=(FSM=AttackWeaponOld,Ident=CrouchDown,FSMSucc=false,FSMFail=false,Transitions=((Ident=GotoActionPoint,Cond=0,Func=COND_ShouldGotoActionPoint,Win=1,Code=0,StateTableIndex=0),(Ident=GotoReload,Cond=0,Func=COND_ShouldGotoReload,Win=0,Code=0,StateTableIndex=0),(Ident=MoveAround,Cond=0,Func=COND_ShouldMoveSide,Win=1,Code=0,StateTableIndex=0),(Ident=ReloadWeapon,Cond=28,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoAttack,Cond=0,Func=COND_ShouldGotoAttack,Win=1,Code=0,StateTableIndex=0),(Ident=ResumeFire,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=COND_BeginWaitState,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(171)=(FSM=AttackWeaponOld,Ident=Prone,FSMSucc=false,FSMFail=false,Transitions=((Ident=ReloadWeapon,Cond=28,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoAttack,Cond=0,Func=COND_ShouldGotoAttack,Win=1,Code=0,StateTableIndex=0),(Ident=ResumeFire,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=COND_BeginWaitState,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(172)=(FSM=AttackWeaponOld,Ident=Wait,FSMSucc=false,FSMFail=false,Transitions=((Ident=GotoActionPoint,Cond=0,Func=COND_ShouldGotoActionPoint,Win=0,Code=0,StateTableIndex=0),(Ident=GotoReload,Cond=0,Func=COND_ShouldGotoReload,Win=0,Code=0,StateTableIndex=0),(Ident=MoveAround,Cond=0,Func=COND_ShouldMoveSide,Win=0,Code=0,StateTableIndex=0),(Ident=ReloadWeapon,Cond=28,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=GotoAttack,Cond=0,Func=COND_ShouldGotoAttack,Win=0,Code=0,StateTableIndex=0),(Ident=GotoSearch,Cond=0,Func=COND_ShouldGotoSearch,Win=0,Code=0,StateTableIndex=0),(Ident=MoveAround,Cond=0,Func=COND_ShouldMoveAround,Win=0,Code=0,StateTableIndex=0),(Ident=StandCombat,Cond=0,Func=COND_ShouldStandUp,Win=0,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=COND_BeginWaitState,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(173)=(FSM=AttackWeaponOld,Ident=GotoSearch,FSMSucc=false,FSMFail=false,Transitions=((Ident=GotoActionPoint,Cond=0,Func=COND_ShouldGotoActionPoint,Win=0,Code=0,StateTableIndex=0),(Ident=GotoReload,Cond=0,Func=COND_ShouldGotoReload,Win=0,Code=0,StateTableIndex=0),(Ident=MoveAround,Cond=0,Func=COND_ShouldMoveSide,Win=0,Code=0,StateTableIndex=0),(Ident=ReloadWeapon,Cond=28,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoAttack,Cond=0,Func=COND_ShouldGotoAttack,Win=0,Code=0,StateTableIndex=0),(Ident=CrouchDown,Cond=0,Func=COND_ShouldCrouchEngage,Win=1,Code=0,StateTableIndex=0),(Ident=Prone,Cond=0,Func=COND_ShouldProneEngage,Win=1,Code=0,StateTableIndex=0),(Ident=ResumeFire,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=COND_BeginWaitState,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(174)=(FSM=AttackWeaponOld,Ident=GotoActionPoint,FSMSucc=false,FSMFail=false,Transitions=((Ident=UseActionPoint,Cond=0,Func=COND_ShouldUseActionPoint,Win=1,Code=0,StateTableIndex=0),(Ident=GotoActionPoint,Cond=0,Func=COND_ShouldGotoActionPoint,Win=1,Code=0,StateTableIndex=0),(Ident=MoveAround,Cond=0,Func=COND_ShouldMoveSide,Win=1,Code=0,StateTableIndex=0),(Ident=ReloadWeapon,Cond=28,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=CrouchDown,Cond=0,Func=COND_ShouldCrouchEngage,Win=1,Code=0,StateTableIndex=0),(Ident=ResumeFire,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=COND_BeginWaitState,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(175)=(FSM=AttackWeaponOld,Ident=UseActionPoint,FSMSucc=false,FSMFail=false,Transitions=((Ident=GotoActionPoint,Cond=0,Func=COND_ShouldGotoActionPoint,Win=1,Code=0,StateTableIndex=0),(Ident=UseActionPoint,Cond=0,Func=COND_ShouldUseActionPoint,Win=2,Code=0,StateTableIndex=0),(Ident=GotoAttack,Cond=0,Func=COND_ShouldGotoAttack,Win=1,Code=0,StateTableIndex=0),(Ident=GotoReload,Cond=0,Func=COND_ShouldGotoReload,Win=1,Code=0,StateTableIndex=0),(Ident=MoveAround,Cond=0,Func=COND_ShouldMoveSide,Win=1,Code=0,StateTableIndex=0),(Ident=ReloadWeapon,Cond=28,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=CrouchDown,Cond=0,Func=COND_ShouldCrouchEngage,Win=1,Code=0,StateTableIndex=0),(Ident=ResumeFire,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=COND_BeginWaitState,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(176)=(FSM=AttackShrunk,Ident=Default,FSMSucc=true,FSMFail=true,Transitions=((Ident=Stomp,Cond=101,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=StandCombat,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=ResumeFire,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoMeleeSlow,Cond=0,Func=COND_ShouldGotoStomp,Win=1,Code=0,StateTableIndex=0),(Ident=AttackShrunkTargetLost,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(177)=(FSM=AttackShrunk,Ident=StandCombat,FSMSucc=false,FSMFail=false,Transitions=((Ident=Stomp,Cond=101,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=ResumeFire,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoMeleeSlow,Cond=0,Func=COND_ShouldGotoStomp,Win=1,Code=0,StateTableIndex=0),(Ident=AttackShrunkTargetLost,Cond=0,Func=COND_ShouldGotoStompLostTarget,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(178)=(FSM=AttackShrunk,Ident=ResumeFire,FSMSucc=false,FSMFail=false,Transitions=((Ident=Stomp,Cond=101,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoMeleeSlow,Cond=0,Func=COND_ShouldGotoStomp,Win=1,Code=0,StateTableIndex=0),(Ident=AttackShrunkTargetLost,Cond=0,Func=COND_ShouldGotoStompLostTarget,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(179)=(FSM=AttackShrunk,Ident=GotoMeleeSlow,FSMSucc=false,FSMFail=false,Transitions=((Ident=idle,Cond=0,Func=COND_ShouldAbortGotoStomp,Win=0,Code=0,StateTableIndex=0),(Ident=idle,Cond=96,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=Stomp,Cond=101,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=AttackShrunkTargetLost,Cond=0,Func=COND_ShouldGotoStompLostTarget,Win=3,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(180)=(FSM=AttackShrunk,Ident=AttackShrunkTargetLost,FSMSucc=false,FSMFail=false,Transitions=((Ident=idle,Cond=96,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=StandCombat,Cond=101,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=Stomp,Cond=101,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=GotoMeleeSlow,Cond=0,Func=COND_ShouldGotoStomp,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(181)=(FSM=AttackShrunk,Ident=Stomp,FSMSucc=false,FSMFail=false,Transitions=((Ident=Stomp,Cond=101,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=ResumeFire,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoMeleeSlow,Cond=0,Func=COND_ShouldGotoStomp,Win=1,Code=0,StateTableIndex=0),(Ident=AttackShrunkTargetLost,Cond=0,Func=COND_ShouldGotoStompLostTarget,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(182)=(FSM=AttackShrunk,Ident=idle,FSMSucc=false,FSMFail=false,Transitions=((Ident=FaceTarget,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=idle,Cond=96,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Stomp,Cond=101,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=StandCombat,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=ResumeFire,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoMeleeSlow,Cond=0,Func=COND_ShouldGotoStomp,Win=1,Code=0,StateTableIndex=0),(Ident=AttackShrunkTargetLost,Cond=0,Func=COND_ShouldGotoStompLostTarget,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(183)=(FSM=AttackShrunk,Ident=FaceTarget,FSMSucc=false,FSMFail=false,Transitions=((Ident=idle,Cond=96,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Stomp,Cond=101,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=StandCombat,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=ResumeFire,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoMeleeSlow,Cond=0,Func=COND_ShouldGotoStomp,Win=1,Code=0,StateTableIndex=0),(Ident=AttackShrunkTargetLost,Cond=0,Func=COND_ShouldGotoStompLostTarget,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(184)=(FSM=AttackShrunkTargetLost,Ident=Default,FSMSucc=true,FSMFail=true,Transitions=((Ident=GotoStomp,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=FaceTarget,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=ResumeFire,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Crouch,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=StandCombat,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=AttackShrunkFailed,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(185)=(FSM=AttackShrunkTargetLost,Ident=GotoStomp,FSMSucc=false,FSMFail=false,Transitions=((Ident=AttackShrunkFailed,Cond=0,Func=None,Win=3,Code=0,StateTableIndex=0),(Ident=FaceTarget,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=ResumeFire,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Crouch,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=StandCombat,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Stomp,Cond=101,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=AttackShrunkFailed,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(186)=(FSM=AttackShrunkTargetLost,Ident=FaceTarget,FSMSucc=false,FSMFail=false,Transitions=((Ident=ResumeFire,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Crouch,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=StandCombat,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Stomp,Cond=101,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=AttackShrunkFailed,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(187)=(FSM=AttackShrunkTargetLost,Ident=ResumeFire,FSMSucc=false,FSMFail=false,Transitions=((Ident=Crouch,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(188)=(FSM=AttackShrunkTargetLost,Ident=Crouch,FSMSucc=false,FSMFail=false,Transitions=((Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=StandCombat,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Stomp,Cond=101,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=AttackShrunkFailed,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(189)=(FSM=AttackShrunkTargetLost,Ident=idle,FSMSucc=false,FSMFail=false,Transitions=((Ident=StandCombat,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(190)=(FSM=AttackShrunkTargetLost,Ident=StandCombat,FSMSucc=false,FSMFail=false,Transitions=((Ident=Stomp,Cond=101,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=AttackShrunkFailed,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(191)=(FSM=AttackShrunkTargetLost,Ident=Stomp,FSMSucc=true,FSMFail=true,Transitions=((Ident=GotoStomp,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=AttackShrunkFailed,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(192)=(FSM=AttackShrunkTargetLost,Ident=AttackShrunkFailed,FSMSucc=false,FSMFail=false,Transitions=((Ident=GotoStomp,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=AttackShrunkFailed,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(193)=(FSM=AttackShrunkFailed,Ident=Default,FSMSucc=true,FSMFail=true,Transitions=((Ident=StandCombat,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoMoveAroundGoal,Cond=0,Func=COND_ShouldMoveAround,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(194)=(FSM=AttackShrunkFailed,Ident=StandCombat,FSMSucc=false,FSMFail=false,Transitions=((Ident=GotoMoveAroundGoal,Cond=0,Func=COND_ShouldMoveAround,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(195)=(FSM=AttackShrunkFailed,Ident=GotoMoveAroundGoal,FSMSucc=false,FSMFail=false,Transitions=((Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(196)=(FSM=AttackShrunkFailed,Ident=idle,FSMSucc=false,FSMFail=false,Transitions=((Ident=GotoMoveAroundGoal,Cond=0,Func=COND_ShouldMoveAround,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(197)=(FSM=AttackShrunkBezerk,Ident=Default,FSMSucc=true,FSMFail=true,Transitions=((Ident=Stomp,Cond=101,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoMeleeSlow,Cond=0,Func=COND_ShouldGotoStomp,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(198)=(FSM=AttackShrunkBezerk,Ident=GotoMeleeSlow,FSMSucc=false,FSMFail=false,Transitions=((Ident=idle,Cond=0,Func=COND_ShouldAbortGotoStomp,Win=0,Code=0,StateTableIndex=0),(Ident=idle,Cond=96,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=Stomp,Cond=20,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=GotoMeleeSlow,Cond=0,Func=COND_ShouldGotoStomp,Win=2,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(199)=(FSM=AttackShrunkBezerk,Ident=Stomp,FSMSucc=false,FSMFail=false,Transitions=((Ident=Stomp,Cond=101,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoMeleeSlow,Cond=0,Func=COND_ShouldGotoStomp,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(200)=(FSM=AttackShrunkBezerk,Ident=idle,FSMSucc=false,FSMFail=false,Transitions=((Ident=FaceTarget,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=idle,Cond=96,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Stomp,Cond=101,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoMeleeSlow,Cond=0,Func=COND_ShouldGotoStomp,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(201)=(FSM=AttackShrunkBezerk,Ident=FaceTarget,FSMSucc=false,FSMFail=false,Transitions=((Ident=idle,Cond=96,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Stomp,Cond=101,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoMeleeSlow,Cond=0,Func=COND_ShouldGotoStomp,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(202)=(FSM=AvoidTarget,Ident=Default,FSMSucc=false,FSMFail=false,Transitions=((Ident=HoldFire,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=StartFleeing,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Cower,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(203)=(FSM=AvoidTarget,Ident=HoldFire,FSMSucc=false,FSMFail=false,Transitions=((Ident=StartFleeing,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoGoalFacePos,Cond=0,Func=COND_ShouldGotoAvoidGoal,Win=1,Code=0,StateTableIndex=0),(Ident=Cower,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(204)=(FSM=AvoidTarget,Ident=StartFleeing,FSMSucc=false,FSMFail=false,Transitions=((Ident=GotoGoalFacePos,Cond=0,Func=COND_ShouldGotoAvoidGoal,Win=1,Code=0,StateTableIndex=0),(Ident=Cower,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(205)=(FSM=AvoidTarget,Ident=GotoGoalFacePos,FSMSucc=false,FSMFail=false,Transitions=((Ident=GotoGoalFacePos,Cond=0,Func=COND_ShouldGotoAvoidGoal,Win=1,Code=0,StateTableIndex=0),(Ident=Cower,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(206)=(FSM=AvoidTarget,Ident=Cower,FSMSucc=false,FSMFail=false,Transitions=((Ident=GotoGoalFacePos,Cond=0,Func=COND_ShouldFlee,Win=1,Code=0,StateTableIndex=0),(Ident=Cower,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    HasLookTargetEvaluator=true
    LookTargetEvalInfo=(MyOwner=none,EvalInterval=0.5,Suspended=false,bSuspendedWithNoTarget=false,Evaluator=2,ForceUpdate=false,MustBePawn=true,MustBeSighted=false,MustBeReachable=false,CanTargetProjectiles=false,CanAvoidTargetableProjectiles=false,LastTarget=none,LastTargetEndTime=0)
    HeadTrackRate=160
    HasWeaponManager=true
    WeaponConfig='WeaponCfg_PigCopGrunt'
    Weapons(0)='dnGame.DualPistol_Pigcop'
    PistolClass='dnGame.Pistol_Pigcop'
    NumPipeBombs=-1
    PipeBombClass='dnGame.dnPipeBombProjectile_Timed_AI'
    Popups(0)=(Entrys=(PopUpCfg_Left'PigCop_Grunt.PigPopUpCfg_Left',PopUpCfg_LeftPipeBomb'PigCop_Grunt.PigPopUpCfg_LeftPipeBomb'),PrimaryChoices=2,IdealAngle=-30)
    Popups(1)=(Entrys=(PopUpCfg_Right'PigCop_Grunt.PigPopUpCfg_Right',PopUpCfg_RightPipeBomb'PigCop_Grunt.PigPopUpCfg_RightPipeBomb'),PrimaryChoices=2,IdealAngle=30)
    Popups(2)=(Entrys=(PopUpCfg_CrouchUp'PigCop_Grunt.PigPopUpCfg_CrouchUp',PopUpCfg_CrouchUpPipeBomb'PigCop_Grunt.PigPopUpCfg_CrouchUpPipeBomb'),PrimaryChoices=2,IdealAngle=0)
    Popups(3)=(Entrys=(PopUpCfg_CrouchLeft'PigCop_Grunt.PigPopUpCfg_CrouchLeft',PopUpCfg_CrouchLeftPipeBomb'PigCop_Grunt.PigPopUpCfg_CrouchLeftPipeBomb'),PrimaryChoices=2,IdealAngle=-30)
    Popups(4)=(Entrys=(PopUpCfg_CrouchRight'PigCop_Grunt.PigPopUpCfg_CrouchRight',PopUpCfg_CrouchRightPipeBomb'PigCop_Grunt.PigPopUpCfg_CrouchRightPipeBomb'),PrimaryChoices=2,IdealAngle=30)
    Popups(5)=(Entrys=none,PrimaryChoices=0,IdealAngle=0)
    Popups(6)=(Entrys=none,PrimaryChoices=0,IdealAngle=0)
    Popups(7)=(Entrys=none,PrimaryChoices=0,IdealAngle=0)
    Popups(8)=(Entrys=none,PrimaryChoices=0,IdealAngle=0)
    Popups(9)=(Entrys=none,PrimaryChoices=0,IdealAngle=0)
    Popups(10)=(Entrys=none,PrimaryChoices=0,IdealAngle=0)
    Popups(11)=(Entrys=none,PrimaryChoices=0,IdealAngle=0)
    Popups(12)=(Entrys=none,PrimaryChoices=0,IdealAngle=0)
    Popups(13)=(Entrys=none,PrimaryChoices=0,IdealAngle=0)
    Popups(14)=(Entrys=(PopUpCfg_StandFire'PigCop_Grunt.PigPopUpCfg_StandFire'),PrimaryChoices=0,IdealAngle=0)
    Popups(15)=(Entrys=(PopUpCfg_CrouchFire'PigCop_Grunt.PigPopUpCfg_CrouchFire'),PrimaryChoices=0,IdealAngle=0)
    Popups(16)=(Entrys=(PopUpCfg_ProneFire'PigCop_Grunt.PigPopUpCfg_ProneFire'),PrimaryChoices=0,IdealAngle=0)
    Popups(17)=(Entrys=(PopUpCfg_Vault'PigCop_Grunt.PigPopUpCfg_Vault'),PrimaryChoices=0,IdealAngle=0)
    UseActionPoints=true
    ChanceStayAtActionPoint=0.3
    CanAnimHurl=true
    Relationships(0)=(m_aClass='Engine.AIFactionHoloduke',m_eAttitude=1,m_fDamageThreshold=1)
    Relationships(1)=(m_aClass='Engine.AIFactionDuke',m_eAttitude=2,m_fDamageThreshold=1)
    Relationships(2)=(m_aClass='Engine.AIFactionHuman',m_eAttitude=2,m_fDamageThreshold=1)
    Relationships(3)=(m_aClass='Engine.AIFactionAlien',m_eAttitude=5,m_fDamageThreshold=1)
    BodyAlignRate=3.8
    BodyAlignScale=0.8
    bUseWeaponMovementAnims=true
    bUseWeaponReadyIdle=true
    AimAtEye=true
    InitialAnimController=5
    AnimControllers[0]=(m_eFallback=0,m_cClass='acPigCop',m_oController=none)
    AnimControllers[1]=(m_eFallback=1,m_cClass='acPigCop_Crouch',m_oController=none)
    AnimControllers[2]=(m_eFallback=1,m_cClass='acPigCop_Prone',m_oController=none)
    AnimControllers[3]=(m_eFallback=1,m_cClass='acGeneric',m_oController=none)
    AnimControllers[4]=(m_eFallback=1,m_cClass='acPigCop_Combat',m_oController=none)
    AnimControllers[5]=(m_eFallback=1,m_cClass='acPigCop_Bezerk',m_oController=none)
    AnimControllers[6]=(m_eFallback=1,m_cClass='acPigCop',m_oController=none)
    AnimControllers[7]=(m_eFallback=1,m_cClass='acPigCop',m_oController=none)
    AnimControllers[8]=(m_eFallback=1,m_cClass='acPigCop_Scared',m_oController=none)
    JumpParms=(Mode=0,JumpVel=(X=0,Y=0,Z=0),HeavyLandingThresh=0,AppliedJumpVel=false,StartZ=0,RefId=0,AnimSet=0,FrameVelocity=(X=0,Y=0,Z=0),bDisableIK=true,bRestoreIKPreLand=true,ExitTime=0,JumpType=0,FaceTarget=false,FocusActor=none,AutoPitch=false,PitchRate=0,PitchRateLand=0,MaxPitch=0,MaxVelocity=0,bDebug=false,bTakeOffNoLand=false,TakeOffIdleTime=0,FlyingGravityScale=0,TargetPos=(X=0,Y=0,Z=0),bCheckTargetPos=false,bUseAccelaration=false,AccelerationScale=0,Fudge=(X=0,Y=0,Z=0),bSnapToTargetDuringLand=false,bRequireCompleteSnap=false,bSnapActive=false,bLandAnimComplete=false,StopLinearDamping=0,bAllowProcFireDuringFall=false)
    JumpAttackParms=(TargetActor=none,Mode=0,Type=0,AttackOnTakeoff=false,Attacked=false,AttackSuccess=false,AppliedJumpVel=false,RefId=0,FrameVelocity=(X=0,Y=0,Z=0),bCanJumpAttackShrunkTarget=false,ShrunkTargetHeightScale=1,ShrunkTargetDistanceScale=1,MinInterval=45,GroundFinderGate=0,GroundFinderInterval=0.5,PresetFrameVelocity=(X=0,Y=0,Z=0),DefaultPresetFrameVelocity=(X=700,Y=0,Z=350),JumpAttackType=2,ParabolaJumpHeight=120,ParabolaMinJumpHeight=5,ParabolaMaxJumpHeight=50,GroundFinderLockout=0.25,bInstantJump=false,bUsePresetVelocity=false,bCheckClearShot=true,bCheckHasPath=false,bCheckClearPath=false,bDontApplyDirectDamage=true,bDisabled=false)
    DroolParms=(MinSpitTime=10,RndSpitTime=5,SpitOnPainChance=1,Bone=None,Location=(X=0,Y=0,Z=0),Rotation=(Pitch=0,Yaw=0,Roll=0),SpawnClass=none)
    ShrunkParms=(bRunFromBiggerEnemies=true,MinSafeDistanceFromBigEnemy=150)
    DeathAnimChance=0.2
    FaceDamage=false
    FaceDeath=false
    MinPainOpInterval=0.2
    RndPainOpInterval=0
    MaxConsecutivePainOp=5
    BoneAim(0)=(BoneName=spine_base,Yaw=0,Pitch=0,Weight=0.3)
    BoneAim(1)=(BoneName=spine_lower,Yaw=0,Pitch=0,Weight=0.3)
    BoneAim(2)=(BoneName=spine_mid,Yaw=0,Pitch=0,Weight=0.4)
    MuzzleBoneAim(0)=(BoneName=hand_right_a,Yaw=0,Pitch=0,Weight=1)
    HasBoneAimer=true
    DisableAimGrids=true
    HasWeaponAimer=true
    AllowBezerk=true
    AllowProne=true
    MinIdleTime=0.25
    RndIdleTime=0
    MinMoveAroundDist=250
    RndMoveAroundDist=0
    RndMeleeRange=30
    MinMeleeStrafeRange=30
    RndMeleeStrafeRange=0
    MinMeleeStrafeCycles=1
    RndMeleeStrafeCycles=1
    MeleeAttackArc=1
    MeleeFaceTarget=true
    ClawDamageAmount=30
    StompInfo(0)=(StompRadius=30,AnimName=Anim_StompLeft,BoneName=ball_left_a,StompDamageAmount=50,StompDamageRadius=40,StompDamageVel=200,StompDamageLift=350,bDebug=false,SafeHeight=20,bCanStompShrunk=false,ShakeInfo=(bNoLerp=false,bToggleSign=true,Style=2,Function=1,FalloffActor=none,FalloffDistance=0,ShakeDuration=0.6,ShakeFrequency=0.08,ShakeMagnitude=2500,ShakeFullMagnitude=0,ShakeFullMagnitudeTime=0,ShakeName=PigCopStompShake),ShakeRadius=600,ParticleEffectClass='p_Impacts.StompImpact.StompImpact_Spawner',AdditionalEffectBones=none,StompLocation=(X=0,Y=0,Z=0),bDontFaceTarget=false,bLightRumbleOnDamage=false)
    StompInfo(1)=(StompRadius=30,AnimName=Anim_StompRight,BoneName=ball_right_a,StompDamageAmount=50,StompDamageRadius=40,StompDamageVel=200,StompDamageLift=350,bDebug=false,SafeHeight=20,bCanStompShrunk=false,ShakeInfo=(bNoLerp=false,bToggleSign=true,Style=2,Function=1,FalloffActor=none,FalloffDistance=0,ShakeDuration=0.6,ShakeFrequency=0.08,ShakeMagnitude=2500,ShakeFullMagnitude=0,ShakeFullMagnitudeTime=0,ShakeName=PigCopStompShake),ShakeRadius=600,ParticleEffectClass='p_Impacts.StompImpact.StompImpact_Spawner',AdditionalEffectBones=none,StompLocation=(X=0,Y=0,Z=0),bDontFaceTarget=false,bLightRumbleOnDamage=false)
    ToeStubInfo=(bDebug=false,bEnabled=true,AnimName=Anim_Stubfoot,bBerzerkAfterStub=false,bDropWeapon=false,MinImpactVelocity=75,MinToeStubInterval=7,ToeStubGate=0)
    bPlayerShrunkSpecialFootstep=true
    MinJumpAttackRange=300
    MaxJumpAttackRange=500
    MaxJumpAttackHeight=300
    JumpAttackOnTakeOff=true
    CanJump=true
    AvoidDangers=true
    RndMoveAroundTime=0
    PathID=AIPATH_Medium
    ChanceSayFireInTheHole=1
    ChanceSayTakeCover=0.9
    ChanceSayLowHealth=0.75
    ChanceSayConfirmKill=1
    ChanceSayReloading=0.45
    ChanceSayManDown=0.75
    ChanceSayFriendlyFire=1
    ChanceSayEnemySpotted=1
    bAutoOpenDoors=true
    DynamicPathingPriority=4
    bHolsterWeapons=true
    Team=1
    ConfirmKillDialog=5
    FootstepCategory=5
    FootprintType=0
    FieldOfView=-0.6
    PawnRotationRate=(Pitch=32768,Yaw=80000,Roll=0)
    EyeBone=forehead
    BodyBone=spine_mid
    LockOnBone=spine_mid
    CustomKillSoundName=GotKillPigCop
    CorpseType='PigCopCorpse'
    ExpandingBoneName=neck
    GroundSpeed=280
    FootBones(0)=(bRightSide=false,BoneName=ball_left_a,BoneID=foot_left_1,BoneRotOffset=(Pitch=0,Yaw=0,Roll=0))
    FootBones(1)=(bRightSide=true,BoneName=ball_right_a,BoneID=foot_right_1,BoneRotOffset=(Pitch=0,Yaw=0,Roll=0))
    ExitWoundInfo(0)=(DamageType=none,MinimumDamage=1,RandomChance=1,ExitWoundDecalClass='dnGame.dnExitWound_Human')
    bCanExistOutOfWorld=false
    bLowerAsPrePivot=false
    CollisionRadius=30
    CollisionHeight=44
    AccelRate=1200
    Mesh='c_characters.PigCopA'
    ActorColorList(0)=(ActorColor=(R=159,G=135,B=117,A=255),ActorColor_LightEx=none,ActorColor_LightExScale=(X=0,Y=0,Z=0),id=Generic0)
    ActorColorList(1)=(ActorColor=(R=255,G=255,B=255,A=255),ActorColor_LightEx=none,ActorColor_LightExScale=(X=0,Y=0,Z=0),id=Generic1)
    VoicePack='SoundConfig.Enemies.VoicePack_PigCop_Grunt'
}