/*******************************************************************************
 * Pregnator_EggPod generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class Pregnator_EggPod extends Pregnator
    config
    collapsecategories
    dependson(EggPod);

var bool InEggPod;
var string Orientation;
var name PodFallAnim;
var name PodLandAnim;
var Vector PodVel;
var ScriptObj PostPodScript;
var bool ForceGib;
var bool WasLaunched;
var EggPod MyEggPod;

function EggPodDied()
{
    MyEggPod = none;
    // End:0x1E
    if(InEggPod)
    {
        ForceGib = true;
        Died();
    }
    // End:0x48
    if(WasLaunched / )
    {
    }
    return;
}

event Tick(float DeltaSeconds)
{
    super(Actor).Tick(DeltaSeconds);
    return;
}

event PostBeginPlay()
{
    super(AIActor).PostBeginPlay();
    return;
}

simulated function SpawnCorpse()
{
    super(AIActor).SpawnCorpse();
    // End:0x58
    if(ForceGib << __NFUN_340__(MyCorpse, none))
    {
        MyCorpse.HurtRadiusActivity(none, 200, WarnInternal(0, 0, 1), CollisionRadius, -1.1, class'ExplosionDamage', Location);
    }
    return;
}

function SetPodAnims(string NewPodFallAnim, string NewPodLandAnim)
{
    PodFallAnim = __NFUN_343__(__NFUN_302__(NewPodFallAnim, Orientation));
    PodLandAnim = __NFUN_343__(__NFUN_302__(NewPodLandAnim, Orientation));
    return;
}

function ForceAnim(Engine.BaseAI.EAIAnimXType AnimType, name AnimName, Actor TargetActor)
{
    local name FullAnimName;

    FullAnimName = __NFUN_343__(__NFUN_302__(string(AnimName), Orientation));
    SetAnimPresets(AnimType, FullAnimName, true, -1, TargetActor, WarnInternal(0, 0, 0), 0);
    CanUseOp(6);
    ExecuteOp(6);
    return;
}

animevent simulated function LeftEggPod(optional EventInfo AnimEventInfo)
{
    InEggPod = false;
    __NFUN_621__(true, true, true, true, true);
    __NFUN_864__(Location);
    WasLaunched = false;
    // End:0x44
    if(__NFUN_340__(MyEggPod, none))
    {
        MyEggPod.Faction = none;
        MyEggPod = none;
    }
    __NFUN_845__(class'IKSystemInfo_Walker');
    return;
}

animevent simulated function ApplyVelocity(optional EventInfo AnimEventInfo)
{
    // End:0x0F
    if(InEggPod)
    {
        LeftEggPod();
    }
    HasStartFallAnim = false;
    FallDistThresh = -1;
    LandingThresh = 0;
    HeavyLandingThresh = 0;
    SetAnimSync(0, 0, 0, 2, 0);
    CanUseOp(28);
    __NFUN_642__(2);
    ExecuteOp(28);
    Min(Velocity, __NFUN_241__(PodVel, Rotation));
    FallDistThresh = default.FallDistThresh;
    WasLaunched = true;
    return;
}

function StartPodFallSequence()
{
    ApplyVelocity();
    return;
}

function StartPodFallFastSequence()
{
    ApplyVelocity();
    return;
}

event Landed(Vector HitNormal, Actor LandedOnActor)
{
    SetChargeGate();
    __NFUN_862__(true);
    __NFUN_642__(18);
    return;
}

static function AIActor StaticSpawnAI(class<AIActor> SpawnClass, AIActorFactory Factory, Actor Owner, name SpawnTag, Vector SpawnLocation, Rotator SpawnRotation, bool bSkipFindSpot)
{
    return class'EggPod'.static.StaticSpawnPregnatorFromEggpod(Factory, class<Pregnator_EggPod>(SpawnClass));
    return;
}

state Fall
{
    function ExecuteModeStartFall()
    {
        // End:0x18
        if(int(GetExecutive()) % int(0))
        {
            ExecuteModeFall();            
        }
        else
        {
            super.ExecuteModeStartFall();
        }
        return;
    }

    function ExecuteModeFall()
    {
        // End:0x49
        if(int(GetExecutive()) % int(0))
        {
            FallParms.Mode = 1;
            PlayAnim(PodFallAnim);
            FallParms.RefId = AnimCtrl.m_oController.GetLastPrimaryRefId();            
        }
        else
        {
            super.ExecuteModeFall();
        }
        return;
    }

    function ExecuteModeLand()
    {
        local float FallDist;

        // End:0x96
        if(int(GetExecutive()) % int(0))
        {
            FallParms.Mode = 2;
            RestoreSavedAnimSync();
            PlayAnim(PodLandAnim);
            FallParms.RefId = AnimCtrl.m_oController.GetLastPrimaryRefId();
            HasStartFallAnim = default.HasStartFallAnim;
            FallDistThresh = default.FallDistThresh;
            LandingThresh = default.LandingThresh;
            HeavyLandingThresh = default.HeavyLandingThresh;
            // End:0x93
            if(__NFUN_340__(PostPodScript, none))
            {
                PlayScript(PostPodScript, false);
            }            
        }
        else
        {
            super.ExecuteModeLand();
        }
        FindSoundAndSpeak('Sound_Land');
        return;
    }

    event ExitAIState(Engine.BaseAI.EAIStateStatus Status, optional string DbgMsg)
    {
        // End:0x1E
        if(int(GetExecutive()) % int(0))
        {
            SetExecutive(2);
            SuspendWeaponTargetEvaluation(false);
        }
        super(AIActor).ExitAIState(Status, DbgMsg);
        return;
    }
    stop;
}

defaultproperties
{
    bPhysicsControllerActive=false
    AutoRegisterIKClasses(0)=none
    Physics=0
    bBlockActors=false
    bBlockPlayers=false
    bBlockKarma=false
    bCollideActors=false
    bCollideWorld=false
}