/*******************************************************************************
 * Rat generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class Rat extends AIActor
    config
    collapsecategories;

var() float ChanceSqueekSFX;
var bool BeingMicrowaved;
var bool bPlayLandAnim;
var float MyAvoidRange;
var int MaxConsecutiveMoveAround;

animevent simulated function BiteDamage(optional EventInfo AnimEventInfo)
{
    // End:0x26
    if(ApplyDamage(class'RatMeleeDamage', int(BiteDamageAmount), BiteDamageVel, 4))
    {
        FindSoundAndSpeak('Sound_Attack_Bite');
    }
    return;
}

animevent simulated function ClawDamage(optional EventInfo AnimEventInfo)
{
    // End:0x26
    if(ApplyDamage(class'RatMeleeDamage', int(ClawDamageAmount), ClawDamageVel, 4))
    {
        FindSoundAndSpeak('Sound_Attack_Claw');
    }
    return;
}

simulated function bool ThrowAttack(Pawn Target, Vector throw_vel)
{
    // End:0x0E
    if(__NFUN_339__(Target, none))
    {
        return false;
    }
    // End:0x3A
    if(Target.bIsPlayerPawn << Target.bFullyShrunk / )
    {
    }
    return super.ThrowAttack(Target, throw_vel);
    return;
}

function Grabbed(Pawn Grabber)
{
    CurrentOpMustFinish = false;
    ExecuteOp(97);
    SuspendExecutive(true);
    __NFUN_709__();
    // End:0x36
    if(__NFUN_340__(AnimationController, none))
    {
        AnimationController.ResetServer();
    }
    super(InteractiveActor).Grabbed(Grabber);
    return;
}

simulated function GrabComplete()
{
    PlayAnim('Anim_Carried');
    super(InteractiveActor).GrabComplete();
    return;
}

function GrabUsed(Pawn Grabber)
{
    super(InteractiveActor).GrabUsed(Grabber);
    bGrabUsable = false;
    GrabInfo.CarrierAnimName = 'CarryRat_Use';
    return;
}

simulated function HandleDecoAnimEvent(EventInfo EventParms)
{
    super(InteractiveActor).HandleDecoAnimEvent(EventParms);
    // End:0x31
    if(__NFUN_310__(EventParms.EventString, "crush"))
    {
        Died(,,,, class'CrushingDamage');
    }
    return;
}

function UnGrabbed(Pawn Grabber, bool Thrown)
{
    super(InteractiveActor).UnGrabbed(Grabber, Thrown);
    BeingThrown = Thrown;
    // End:0x58
    if(BeingThrown)
    {
        bEnablePhysicsRotation = true;
        __NFUN_862__(false);
        bUseCylinderCollision = true;
        SetCollisionInterpolationTarget(2, 2, 0, 0);        
    }
    else
    {
        SuspendExecutive(false);
        PlayAnim('Anim_Fall1');
        bPlayLandAnim = true;
    }
    return;
}

function ThrowLanded()
{
    super(InteractiveActor).ThrowLanded();
    Died(,,,, class'FallingDamage');
    return;
}

event Landed(Vector HitNormal, Actor LandedOnActor)
{
    // End:0x25
    if((int(GetExecutive()) % int(2)) << bPlayLandAnim)
    {
        PlayAnim('Anim_Land1');
    }
    bPlayLandAnim = false;
    return;
}

function FinishedLand()
{
    SuspendExecutive(false);
    return;
}

simulated function StartFreezing(float FreezeDuration)
{
    super(Pawn).StartFreezing(FreezeDuration);
    bGrabbable = false;
    return;
}

simulated function BecomeUnfrozen()
{
    super.BecomeUnfrozen();
    bGrabbable = true;
    return;
}

function bool CanMicrowave()
{
    return super(InteractiveActor).CanMicrowave();
    return;
}

function PlacedInMicrowave(InteractiveActor MicrowaveActor)
{
    SuspendExecutive(true);
    PlayAnim('Anim_IdleMicrowave');
    super(InteractiveActor).PlacedInMicrowave(MicrowaveActor);
    return;
}

function float StartMicrowaving(InteractiveActor MicrowaveActor)
{
    PlayAnim('Anim_Microwave');
    BeingMicrowaved = true;
    return super(InteractiveActor).StartMicrowaving(MicrowaveActor);
    return;
}

function StopMicrowaving()
{
    BeingMicrowaved = false;
    ExecuteOp(85);
    super(InteractiveActor).StopMicrowaving();
    return;
}

function CompleteMicrowaving()
{
    // End:0x26
    if(__NFUN_340__(MicrowaveInfo.MicrowaveActor, none))
    {
        MicrowaveInfo.MicrowaveActor.ClearNukingActor();
    }
    super(InteractiveActor).CompleteMicrowaving();
    Died(,,,, class'MicrowaveDamage');
    return;
}

function InterruptMicrowaving()
{
    // End:0x26
    if(__NFUN_340__(MicrowaveInfo.MicrowaveActor, none))
    {
        MicrowaveInfo.MicrowaveActor.ClearNukingActor();
    }
    super(InteractiveActor).InterruptMicrowaving();
    Died(,,,, class'MicrowaveDamage');
    return;
}

function Anim_MoveTo(Engine.BaseAI.EAIMoveSpeed MoveSpeed)
{
    super.Anim_MoveTo(MoveSpeed);
    /* Statement decompilation error: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
        
    */

    // End:0x36
    /*@Error*/;
    // Failed to format nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
    // 2 & Type:If Position:0x036
    // Failed to format remaining nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
    // 2 & Type:If Position:0x036
}

event Engine.BaseAI.EAICode Cond_ValidShrunkenTarget()
{
    // End:0x5C
    if(__NFUN_340__(PrimaryTargetActor, none) << (PrimaryTargetActor.bIsPawn / ) < )
    {
    }
    return;
}

event Engine.BaseAI.EAICode Cond_ValidShrunkenTarget3()
{
    // End:0x2E
    if((int(Cond_ValidShrunkenTarget()) % int(0)) << __NFUN_200__(PrimaryTarget.GetTimeSinceContact(), 3))
    {
        return 0;
    }
    return 1;
    return;
}

event Engine.BaseAI.EAICode Cond_NoValidShrunkenTarget()
{
    // End:0x12
    if(int(Cond_ValidShrunkenTarget()) % int(0))
    {
        return 1;
    }
    return 0;
    return;
}

event Engine.BaseAI.EAICode Cond_ShouldAvoid()
{
    // End:0x6F
    if(((PrimaryTarget.IsValidTarget() << int(Cond_ValidShrunkenTarget()) + int(0)) << __NFUN_200__(PrimaryTarget.GetTimeSinceContact(), 0.5)) << __NFUN_200__(VRand(__NFUN_239__(Location, PrimaryTarget.GetPos())), FRand(MyAvoidRange, MyAvoidRange)))
    {
        return 0;
    }
    return 1;
    return;
}

event Engine.BaseAI.EAICode Cond_ShouldNotAvoid()
{
    // End:0x12
    if(int(Cond_ShouldAvoid()) + int(0))
    {
        return 0;
    }
    return 1;
    return;
}

function bool ShouldApplyMeleeDamageToActor(Actor HitActor)
{
    // End:0x1C
    if(__NFUN_339__(HitActor.Class, class'Rat'))
    {
        return false;
    }
    return true;
    return;
}

event Engine.BaseAI.EAICode COND_ShouldBackOff()
{
    return 1;
    return;
}

event Engine.BaseAI.EAICode COND_ShouldRetreatToAP()
{
    return 1;
    return;
}

event bool ShouldAlwaysBeDynamicallyPathedAround()
{
    return false;
    return;
}

event Engine.BaseAI.EAICode COND_ShouldFollowUpMelee()
{

    /* Statement decompilation error: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
        
    */
    /*@Error*/;
}

function Engine.BaseAI.EAICode COND_ShouldDodge()
{
    // End:0x1C
    if(__NFUN_200__(DodgeGate, Level.GameTimeSeconds))
    {
        return 0;
    }
    return 1;
    return;
}

function DoExtraMeleeEffects(Actor DamagedActor, float DamageAmount, Vector DamageLocation, Vector Direction, Class DamageClass)
{
    local Vector Variance, Dir;
    local int i;

    // End:0x8A
    if(__NFUN_340__(Corpse(DamagedActor), none))
    {
        Direction = Vector(DamagedActor.Rotation);
        Variance = WarnInternal(1, 1, 1);
        i = 0;
        J0x45:

        // End:0x8A [Loop If]
        if(-i)
        {            
            Dir = Sleep(Direction, Variance);
            TraceFireMaterialHit(class'RatMeleeDamageNoSound', self, DamageLocation, Direction, class'Flesh_Human', false);
            // [Loop Continue]
            i += ;
        }
    }
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    super(Pawn).RegisterPrecacheComponents(PrecacheIndex);
    PrecacheIndex.__NFUN_1283__('Anim_Idle', class'acRat', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_AggressiveIdle', class'acRat', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_Walk', class'acRat', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_WalkBackwards', class'acRat', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_Run', class'acRat', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_RunBackwards', class'acRat', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_SidestepLeft', class'acRat', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_SidestepRight', class'acRat', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_StrafeLeft', class'acRat', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_StrafeRight', class'acRat', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_DodgeLeft', class'acRat', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_DodgeRight', class'acRat', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_TurnLeft45', class'acRat', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_TurnLeft180', class'acRat', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_TurnRight45', class'acRat', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_TurnRight180', class'acRat', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_Pain', class'acRat', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_Attack', class'acRat', Mesh);
    // End:0x232
    if(PrecacheIndex.bPlayerCanBeShrunk)
    {
        PrecacheIndex.__NFUN_1283__('Anim_AttackShrunk', class'acRat', Mesh);
    }
    PrecacheIndex.__NFUN_1283__('Anim_Roar', class'acRat', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_Microwave', class'acRat', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_IdleMicrowave', class'acRat', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_Carried', class'acRat', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_Cower', class'acRat', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_Fall1', class'acRat', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_Land1', class'acRat', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_JumpAttack', class'acRat', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_JumpAttack0', class'acRat', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_JumpAttack1', class'acRat', Mesh);
    PrecacheIndex.__NFUN_1281__('CarryRat_Use');
    PrecacheIndex.__NFUN_1279__(class'CrushingDamage');
    PrecacheIndex.__NFUN_1279__(class'MicrowaveDamage');
    PrecacheIndex.__NFUN_1279__(class'RatMeleeDamage');
    PrecacheIndex.__NFUN_1279__(class'RatMeleeDamageNoSound');
    PrecacheIndex.__NFUN_1280__(class'Flesh_Human');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_Attack');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_Attack_Bite');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_Attack_Claw');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_Chase');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_Cower');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_FootStep');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_Idle');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_Hiss');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_Surprise');
    PrecacheIndex.__NFUN_1266__(class'dnScreenSplatter_Blood');
    PrecacheIndex.__NFUN_1279__(class'ShrunkSmashDamage');
    PrecacheIndex.__NFUN_1277__(class'DukePlayer'.default.VoicePack, 'Stomp_Squish');
    PrecacheIndex.__NFUN_1277__(class'DukePlayer'.default.VoicePack, 'StompLines');
    return;
}

event EnumerateUsableAnimationControllers(PrecacheIndex PrecacheIndex, out array<Engine.BaseAI.EAIAnimController> UsableControllers)
{
    UsableControllers[string(UsableControllers)] = 1;
    return;
}

defaultproperties
{
    ChanceSqueekSFX=0.25
    MyAvoidRange=360
    MaxConsecutiveMoveAround=3
    RandomActorColor(0)=(R=39,G=36,B=33,A=0)
    RandomActorColor(1)=(R=138,G=113,B=96,A=0)
    RandomActorColor(2)=(R=177,G=179,B=184,A=0)
    RandomActorColor(3)=(R=81,G=82,B=94,A=0)
    RandomActorColor(4)=(R=123,G=79,B=51,A=0)
    RandomActorColorGroupID=Rat
    Nodes(0)=(Ident=Root,Status=0,ReportedInvalid=false,SucCond=1,SucFunc=None,FailCond=1,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(1)=(Ident=Guard,Status=0,ReportedInvalid=false,SucCond=76,SucFunc=None,FailCond=1,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(2)=(Ident=GotoGuardPos,Status=0,ReportedInvalid=false,SucCond=79,SucFunc=None,FailCond=1,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(3)=(Ident=Aggressive,Status=0,ReportedInvalid=false,SucCond=1,SucFunc=None,FailCond=0,FailFunc=Cond_NoValidShrunkenTarget,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(4)=(Ident=AttackWait,Status=0,ReportedInvalid=false,SucCond=1,SucFunc=None,FailCond=1,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(5)=(Ident=Melee,Status=0,ReportedInvalid=false,SucCond=1,SucFunc=None,FailCond=1,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(6)=(Ident=Passive,Status=0,ReportedInvalid=false,SucCond=1,SucFunc=None,FailCond=1,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(7)=(Ident=Avoid,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=Cond_ShouldNotAvoid,FailCond=1,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(8)=(Ident=Attack,Status=0,ReportedInvalid=false,SucCond=7,SucFunc=None,FailCond=1,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(9)=(Ident=RetreatToHole,Status=0,ReportedInvalid=false,SucCond=1,SucFunc=None,FailCond=1,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(10)=(Ident=Dodge,Status=0,ReportedInvalid=false,SucCond=1,SucFunc=None,FailCond=1,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(11)=(Ident=Default,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=85,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(12)=(Ident=FUBAR,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=1,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(13)=(Ident=Pain,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=96,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(14)=(Ident=idle,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=85,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(15)=(Ident=AttackIdle,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=2,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(16)=(Ident=FaceTarget,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=145,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(17)=(Ident=FaceGuardedActor,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=143,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(18)=(Ident=GotoMelee,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=61,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(19)=(Ident=GotoGuardAttack,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=61,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(20)=(Ident=GotoWander,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=78,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(21)=(Ident=GotoAvoid,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=47,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(22)=(Ident=GotoGoalFacePos,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=47,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(23)=(Ident=StepAside,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=46,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(24)=(Ident=StrafeMelee,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=123,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(25)=(Ident=Cower,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=19,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(26)=(Ident=Search,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=71,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(27)=(Ident=MeleeAttack,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=92,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(28)=(Ident=Roar,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=107,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(29)=(Ident=FreeMoveFlank,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=40,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(30)=(Ident=DodgeLeft,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=25,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(31)=(Ident=DodgeRight,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=26,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(32)=(Ident=Teleport,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=138,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(33)=(Ident=JumpAttack,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=89,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    FSMStates(0)=(FSM=Root,Ident=Default,FSMSucc=false,FSMFail=false,Transitions=((Ident=Guard,Cond=75,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=Aggressive,Cond=0,Func=Cond_ValidShrunkenTarget,Win=0,Code=0,StateTableIndex=0),(Ident=Passive,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(1)=(FSM=Root,Ident=Aggressive,FSMSucc=false,FSMFail=false,Transitions=((Ident=Guard,Cond=75,Func=COND_ReleaseActionPoint,Win=0,Code=0,StateTableIndex=0),(Ident=Passive,Cond=0,Func=COND_ReleaseActionPoint,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(2)=(FSM=Root,Ident=Passive,FSMSucc=false,FSMFail=false,Transitions=((Ident=Guard,Cond=75,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=Aggressive,Cond=0,Func=Cond_ValidShrunkenTarget,Win=0,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(3)=(FSM=Root,Ident=Guard,FSMSucc=false,FSMFail=false,Transitions=((Ident=Aggressive,Cond=0,Func=Cond_ValidShrunkenTarget,Win=1,Code=0,StateTableIndex=0),(Ident=Passive,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(4)=(FSM=Guard,Ident=Default,FSMSucc=true,FSMFail=true,Transitions=((Ident=Pain,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=Melee,Cond=0,Func=COND_ShouldGuardAttackMelee,Win=0,Code=0,StateTableIndex=0),(Ident=GotoGuardAttack,Cond=85,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoGuardPos,Cond=0,Func=COND_ShouldGotoGuardPos,Win=1,Code=0,StateTableIndex=0),(Ident=AttackWait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(5)=(FSM=Guard,Ident=Pain,FSMSucc=false,FSMFail=false,Transitions=((Ident=Pain,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=Pain,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=Melee,Cond=0,Func=COND_ShouldGuardAttackMelee,Win=0,Code=0,StateTableIndex=0),(Ident=GotoGuardAttack,Cond=85,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoGuardPos,Cond=0,Func=COND_ShouldGotoGuardPos,Win=1,Code=0,StateTableIndex=0),(Ident=AttackWait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(6)=(FSM=Guard,Ident=GotoGuardPos,FSMSucc=false,FSMFail=false,Transitions=((Ident=Pain,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=Melee,Cond=0,Func=COND_ShouldGuardAttackMelee,Win=0,Code=0,StateTableIndex=0),(Ident=GotoGuardAttack,Cond=85,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=AttackWait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(7)=(FSM=Guard,Ident=GotoGuardAttack,FSMSucc=false,FSMFail=false,Transitions=((Ident=Melee,Cond=0,Func=COND_ShouldGuardAttackMelee,Win=0,Code=0,StateTableIndex=0),(Ident=GotoGuardPos,Cond=0,Func=COND_ShouldGotoGuardPos,Win=1,Code=0,StateTableIndex=0),(Ident=AttackWait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(8)=(FSM=Guard,Ident=Melee,FSMSucc=false,FSMFail=false,Transitions=((Ident=Pain,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=Melee,Cond=0,Func=COND_ShouldGuardAttackMelee,Win=1,Code=0,StateTableIndex=0),(Ident=GotoGuardAttack,Cond=85,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoGuardPos,Cond=0,Func=COND_ShouldGotoGuardPos,Win=0,Code=0,StateTableIndex=0),(Ident=AttackWait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(9)=(FSM=Guard,Ident=AttackWait,FSMSucc=false,FSMFail=false,Transitions=((Ident=Pain,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=Melee,Cond=0,Func=COND_ShouldGuardAttackMelee,Win=0,Code=0,StateTableIndex=0),(Ident=GotoGuardAttack,Cond=85,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=GotoGuardPos,Cond=0,Func=COND_ShouldGotoGuardPos,Win=0,Code=0,StateTableIndex=0),(Ident=AttackWait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(10)=(FSM=GotoGuardPos,Ident=Default,FSMSucc=true,FSMFail=true,Transitions=((Ident=GotoGoalFacePos,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(11)=(FSM=GotoGuardPos,Ident=GotoGoalFacePos,FSMSucc=true,FSMFail=true,Transitions=none,NodeIndex=0)
    FSMStates(12)=(FSM=Aggressive,Ident=Default,FSMSucc=false,FSMFail=false,Transitions=((Ident=Pain,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=Attack,Cond=0,Func=Cond_ValidShrunkenTarget3,Win=1,Code=0,StateTableIndex=0),(Ident=Search,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(13)=(FSM=Aggressive,Ident=Pain,FSMSucc=false,FSMFail=false,Transitions=((Ident=Pain,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=Attack,Cond=0,Func=Cond_ValidShrunkenTarget3,Win=1,Code=0,StateTableIndex=0),(Ident=Search,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(14)=(FSM=Aggressive,Ident=Search,FSMSucc=false,FSMFail=false,Transitions=((Ident=Pain,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=Attack,Cond=0,Func=Cond_ValidShrunkenTarget,Win=0,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(15)=(FSM=Aggressive,Ident=Attack,FSMSucc=false,FSMFail=false,Transitions=((Ident=Pain,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=Attack,Cond=0,Func=Cond_ValidShrunkenTarget,Win=1,Code=0,StateTableIndex=0),(Ident=Search,Cond=0,Func=COND_ReleaseActionPoint,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(16)=(FSM=AttackWait,Ident=Default,FSMSucc=true,FSMFail=true,Transitions=((Ident=FaceTarget,Cond=59,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=StepAside,Cond=0,Func=COND_ShouldStepAside,Win=0,Code=0,StateTableIndex=0),(Ident=FaceGuardedActor,Cond=9,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=AttackIdle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(17)=(FSM=AttackWait,Ident=FaceTarget,FSMSucc=false,FSMFail=false,Transitions=((Ident=StepAside,Cond=0,Func=COND_ShouldStepAside,Win=0,Code=0,StateTableIndex=0),(Ident=FaceGuardedActor,Cond=9,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=AttackIdle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(18)=(FSM=AttackWait,Ident=AttackIdle,FSMSucc=false,FSMFail=false,Transitions=((Ident=FaceTarget,Cond=59,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=StepAside,Cond=0,Func=COND_ShouldStepAside,Win=0,Code=0,StateTableIndex=0),(Ident=FaceGuardedActor,Cond=9,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=AttackIdle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(19)=(FSM=AttackWait,Ident=StepAside,FSMSucc=false,FSMFail=false,Transitions=((Ident=FaceTarget,Cond=59,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=StepAside,Cond=0,Func=COND_ShouldStepAside,Win=1,Code=0,StateTableIndex=0),(Ident=FaceGuardedActor,Cond=9,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=AttackIdle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(20)=(FSM=AttackWait,Ident=FaceGuardedActor,FSMSucc=false,FSMFail=false,Transitions=((Ident=FaceTarget,Cond=59,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=StepAside,Cond=0,Func=COND_ShouldStepAside,Win=0,Code=0,StateTableIndex=0),(Ident=AttackIdle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(21)=(FSM=AttackWait,Ident=idle,FSMSucc=false,FSMFail=false,Transitions=((Ident=FaceTarget,Cond=59,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=StepAside,Cond=0,Func=COND_ShouldStepAside,Win=0,Code=0,StateTableIndex=0),(Ident=FaceGuardedActor,Cond=9,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=AttackIdle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(22)=(FSM=Melee,Ident=Default,FSMSucc=true,FSMFail=true,Transitions=((Ident=FaceTarget,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=MeleeAttack,Cond=19,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Roar,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(23)=(FSM=Melee,Ident=FaceTarget,FSMSucc=false,FSMFail=false,Transitions=((Ident=MeleeAttack,Cond=19,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Roar,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(24)=(FSM=Melee,Ident=MeleeAttack,FSMSucc=true,FSMFail=true,Transitions=none,NodeIndex=0)
    FSMStates(25)=(FSM=Melee,Ident=Roar,FSMSucc=true,FSMFail=true,Transitions=none,NodeIndex=0)
    FSMStates(26)=(FSM=Passive,Ident=Default,FSMSucc=false,FSMFail=false,Transitions=((Ident=Pain,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=Avoid,Cond=0,Func=Cond_ShouldAvoid,Win=1,Code=0,StateTableIndex=0),(Ident=GotoWander,Cond=16,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(27)=(FSM=Passive,Ident=Pain,FSMSucc=false,FSMFail=false,Transitions=((Ident=Pain,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=Avoid,Cond=0,Func=Cond_ShouldAvoid,Win=1,Code=0,StateTableIndex=0),(Ident=GotoWander,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(28)=(FSM=Passive,Ident=Avoid,FSMSucc=false,FSMFail=false,Transitions=((Ident=Pain,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=Avoid,Cond=0,Func=Cond_ShouldAvoid,Win=1,Code=0,StateTableIndex=0),(Ident=GotoWander,Cond=19,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(29)=(FSM=Passive,Ident=GotoWander,FSMSucc=false,FSMFail=false,Transitions=((Ident=Pain,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=Avoid,Cond=0,Func=Cond_ShouldAvoid,Win=0,Code=0,StateTableIndex=0),(Ident=GotoWander,Cond=18,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(30)=(FSM=Passive,Ident=idle,FSMSucc=false,FSMFail=false,Transitions=((Ident=Pain,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=Avoid,Cond=0,Func=Cond_ShouldAvoid,Win=0,Code=0,StateTableIndex=0),(Ident=GotoWander,Cond=16,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(31)=(FSM=Avoid,Ident=Default,FSMSucc=false,FSMFail=false,Transitions=((Ident=GotoAvoid,Cond=58,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=FaceTarget,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=Cower,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(32)=(FSM=Avoid,Ident=GotoAvoid,FSMSucc=false,FSMFail=false,Transitions=((Ident=GotoAvoid,Cond=58,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=FaceTarget,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Cower,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(33)=(FSM=Avoid,Ident=Cower,FSMSucc=false,FSMFail=false,Transitions=((Ident=GotoAvoid,Cond=58,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=FaceTarget,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=Cower,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(34)=(FSM=Avoid,Ident=FaceTarget,FSMSucc=false,FSMFail=false,Transitions=((Ident=GotoAvoid,Cond=58,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=Cower,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(35)=(FSM=Attack,Ident=Default,FSMSucc=false,FSMFail=false,Transitions=((Ident=Dodge,Cond=97,Func=COND_ShouldDodge,Win=0,Code=0,StateTableIndex=0),(Ident=Melee,Cond=22,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=StrafeMelee,Cond=15,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoMelee,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Melee,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(36)=(FSM=Attack,Ident=Melee,FSMSucc=false,FSMFail=false,Transitions=((Ident=Dodge,Cond=97,Func=COND_ShouldDodge,Win=0,Code=0,StateTableIndex=0),(Ident=FreeMoveFlank,Cond=18,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Melee,Cond=22,Func=COND_ShouldFollowUpMelee,Win=1,Code=0,StateTableIndex=0),(Ident=GotoGoalFacePos,Cond=0,Func=COND_ShouldBackOff,Win=1,Code=0,StateTableIndex=0),(Ident=RetreatToHole,Cond=0,Func=COND_ShouldRetreatToAP,Win=1,Code=0,StateTableIndex=0),(Ident=FreeMoveFlank,Cond=13,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Melee,Cond=22,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=StrafeMelee,Cond=15,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoMelee,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(37)=(FSM=Attack,Ident=StrafeMelee,FSMSucc=false,FSMFail=false,Transitions=((Ident=Dodge,Cond=97,Func=COND_ShouldDodge,Win=0,Code=0,StateTableIndex=0),(Ident=Melee,Cond=22,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoMelee,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(38)=(FSM=Attack,Ident=GotoMelee,FSMSucc=false,FSMFail=false,Transitions=((Ident=JumpAttack,Cond=12,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=Dodge,Cond=97,Func=COND_ShouldDodge,Win=0,Code=0,StateTableIndex=0),(Ident=Melee,Cond=22,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=StrafeMelee,Cond=15,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoMelee,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(39)=(FSM=Attack,Ident=FreeMoveFlank,FSMSucc=false,FSMFail=false,Transitions=((Ident=Melee,Cond=22,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoMelee,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(40)=(FSM=Attack,Ident=Dodge,FSMSucc=false,FSMFail=false,Transitions=((Ident=Melee,Cond=22,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoMelee,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Melee,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(41)=(FSM=Attack,Ident=GotoGoalFacePos,FSMSucc=false,FSMFail=false,Transitions=((Ident=Melee,Cond=22,Func=COND_ReleaseActionPoint,Win=1,Code=0,StateTableIndex=0),(Ident=GotoGoalFacePos,Cond=0,Func=COND_ShouldBackOff,Win=1,Code=0,StateTableIndex=0),(Ident=GotoMelee,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Melee,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(42)=(FSM=Attack,Ident=RetreatToHole,FSMSucc=true,FSMFail=true,Transitions=none,NodeIndex=0)
    FSMStates(43)=(FSM=Attack,Ident=JumpAttack,FSMSucc=true,FSMFail=true,Transitions=none,NodeIndex=0)
    FSMStates(44)=(FSM=RetreatToHole,Ident=Default,FSMSucc=false,FSMFail=false,Transitions=((Ident=GotoGoalFacePos,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Teleport,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(45)=(FSM=RetreatToHole,Ident=GotoGoalFacePos,FSMSucc=false,FSMFail=true,Transitions=((Ident=Teleport,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(46)=(FSM=RetreatToHole,Ident=Teleport,FSMSucc=true,FSMFail=true,Transitions=none,NodeIndex=0)
    FSMStates(47)=(FSM=Dodge,Ident=Default,FSMSucc=false,FSMFail=false,Transitions=((Ident=FaceTarget,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=DodgeLeft,Cond=15,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=DodgeRight,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(48)=(FSM=Dodge,Ident=FaceTarget,FSMSucc=false,FSMFail=false,Transitions=((Ident=DodgeLeft,Cond=15,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=DodgeRight,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(49)=(FSM=Dodge,Ident=DodgeLeft,FSMSucc=true,FSMFail=true,Transitions=none,NodeIndex=0)
    FSMStates(50)=(FSM=Dodge,Ident=DodgeRight,FSMSucc=true,FSMFail=true,Transitions=none,NodeIndex=0)
    SquadChannel=(ChannelName=None,MaxDistance=2000)
    WeaponTargetEvalInfo=(MyOwner=none,EvalInterval=0.3,Suspended=false,bSuspendedWithNoTarget=false,Evaluator=3,ForceUpdate=false,MustBePawn=true,MustBeSighted=false,MustBeReachable=true,CanTargetProjectiles=false,CanAvoidTargetableProjectiles=false,LastTarget=none,LastTargetEndTime=0)
    Relationships(0)=(m_aClass='Engine.AIFactionHoloduke',m_eAttitude=1,m_fDamageThreshold=1)
    Relationships(1)=(m_aClass='Engine.AIFactionDuke',m_eAttitude=1,m_fDamageThreshold=1)
    Relationships(2)=(m_aClass='Engine.AIFactionHuman',m_eAttitude=1,m_fDamageThreshold=1)
    Relationships(3)=(m_aClass='Engine.AIFactionAlien',m_eAttitude=1,m_fDamageThreshold=1)
    Relationships(4)=(m_aClass='Engine.AIFactionRat',m_eAttitude=6,m_fDamageThreshold=1)
    BodyAlignRate=4.28
    BodyAlignRateFlying=4.28
    bTryBackupPathingOnFailure=true
    AnimControllers[0]=(m_eFallback=0,m_cClass='acRat',m_oController=none)
    AnimControllers[1]=(m_eFallback=1,m_cClass='acRat',m_oController=none)
    AnimControllers[2]=(m_eFallback=1,m_cClass='acRat',m_oController=none)
    AnimControllers[3]=(m_eFallback=1,m_cClass='acRat',m_oController=none)
    AnimControllers[4]=(m_eFallback=1,m_cClass='acRat',m_oController=none)
    AnimControllers[5]=(m_eFallback=1,m_cClass='acRat',m_oController=none)
    AnimControllers[6]=(m_eFallback=1,m_cClass='acRat',m_oController=none)
    AnimControllers[7]=(m_eFallback=1,m_cClass='acRat',m_oController=none)
    AnimControllers[8]=(m_eFallback=1,m_cClass='acRat',m_oController=none)
    JumpAttackParms=(TargetActor=none,Mode=0,Type=0,AttackOnTakeoff=false,Attacked=false,AttackSuccess=false,AppliedJumpVel=false,RefId=0,FrameVelocity=(X=0,Y=0,Z=0),bCanJumpAttackShrunkTarget=true,ShrunkTargetHeightScale=1,ShrunkTargetDistanceScale=1,MinInterval=0,GroundFinderGate=0,GroundFinderInterval=0.5,PresetFrameVelocity=(X=0,Y=0,Z=0),DefaultPresetFrameVelocity=(X=0,Y=0,Z=0),JumpAttackType=1,ParabolaJumpHeight=0,ParabolaMinJumpHeight=0,ParabolaMaxJumpHeight=0,GroundFinderLockout=0.25,bInstantJump=false,bUsePresetVelocity=false,bCheckClearShot=false,bCheckHasPath=true,bCheckClearPath=false,bDontApplyDirectDamage=false,bDisabled=false)
    DeathAnimChance=-1
    MinIdleTime=0.1
    RndIdleTime=0.1
    ShouldTurnThreshold=5
    FaceThreshold=0
    SideArcTurnSpeedThresh=10
    StartAngleSideSector=90
    StartAngleBackSector=90
    MoveBackwardsDistThresh=3
    SideStepDistThresh=10000
    RndMeleeRange=3
    RndMeleeHeight=0.2
    MeleeZone=5
    MeleeZoneHeight=5
    MinMeleeStrafeRange=5
    RndMeleeStrafeRange=10
    MinMeleeStrafeCycles=1
    RndMeleeStrafeCycles=1
    MeleeAttackRange=25
    MeleeAttackArc=1
    MeleeFaceTarget=true
    BiteDamageAmount=5
    ClawDamageAmount=5
    MinJumpAttackRange=20
    MaxJumpAttackRange=50
    MaxJumpAttackHeight=20
    CanOpenDoors=false
    PathID=AIPATH_Small
    DynamicPathingPriority=3
    bAllowSpecialKillSounds=false
    bShouldCauseStompKillSound=false
    bInstaGib=true
    bShrinkable=false
    Stompable=true
    Faction='Engine.AIFactionRat'
    FieldOfView=-1
    EyeBone=Head
    BodyBone=spine_lower
    LockOnBone=spine_lower
    KillSoundRandomChance=0.1
    CustomKillSoundName=GotKillRat
    CustomKillSoundChance=1
    CorpseType='RatCorpse'
    ExpandingBoneName=Head
    bDontModifyHeadSize=true
    MaxStepHeightEx=2.08
    MaxStepHeight=2
    bGrabUsable=true
    bGrabbable=true
    ThrowPhysics=18
    UsePhrase="<?int?dnAI.Rat.UsePhrase?>"
    GrabUsePhrase="<?int?dnAI.Rat.GrabUsePhrase?>"
    GrabInfo=(bCanDuckWhileHeld=true,MountItemOverride=mount_handright,MountOrigin=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),GrabAnimName=a_carried_pose,CarrierAnimName=CarryRat,CarrierMountPose=CarryPoseRat,GrabSoundName=None,ThrowSoundName=None,GrabSoundInfo=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),ThrowSoundInfo=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none))
    MicrowaveInfo=(TimeToMicrowave=5,MicrowaveActor=none,LastMicrowaveTime=0)
    Health=1
    HealthCap=1
    PhysicsEntityGroup=DefaultRatPhysicsGroup
    bAITransparent=true
    bCanExistOutOfWorld=false
    bLowerByCollision=false
    bStepUpAble=true
    CollisionRadius=10
    CollisionHeight=3.5
    Mass=10
    DrawScale=0.7
    Mesh='c_characters.Rat'
    ActorColorList(0)=(ActorColor=(R=0,G=0,B=0,A=0),ActorColor_LightEx=none,ActorColor_LightExScale=(X=0,Y=0,Z=0),id=Rat)
    TransientSoundVolume=0.65
    TransientSoundRadius=800
    TransientSoundInnerRadius=400
    VoicePack='SoundConfig.Enemies.VoicePack_Rat'
}