/*******************************************************************************
 * ScriptMethod_GuardPos generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class ScriptMethod_GuardPos extends ScriptMethod
    native
    exportstructs
    hidecategories(Object);

cpptext
{
// Stripped
}

var() noexport float InnerRange "Range to get within when returning to the guard position.";
var() noexport float OuterRange "Maximum Range allowed from the guard position. (<=0.0 means use InnerRange)";
var() noexport float AbortRange "If non-zero, abort the guard if the target is closer than this.";
var() noexport bool AbortMustBeVisible "If AbortRange is set, this flag determines whether the target must also be visible in order for us to abort.";
var() noexport bool AllowAvoidDanger "Are we allowed to avoid danger (grenades etc)?";
var() noexport bool AllowDodge "Are we allowed to dodge to the sides when being aimed at?";
var() noexport bool bDontScaleRangeWithDrawScale "If true we won't change inner/outer range based on our drawscale. If false it will: If you set inner range to 100 but then shrink him to drawscale 0.5 the inner range will actually be 50.";
var() noexport bool bStaticGuard "Super hack: if true we ignore gravity and don't move. This locks the actor in a guard state where he wont leave his position for anything. This was made for a map specific case so only use if you absolutely have to.";

event string GetMethodString()
{
    return __NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__("GuardPos (", string(InnerRange)), ", "), string(OuterRange)), ", "), string(AbortRange)), ", "), string(AbortMustBeVisible)), ", "), string(AllowAvoidDanger)), ", "), string(AllowDodge)), ")");
    return;
}

defaultproperties
{
    InnerRange=20
    OuterRange=60
    AllowAvoidDanger=true
    AllowDodge=true
}