/*******************************************************************************
 * cycloid generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class cycloid extends AIActor
    config
    collapsecategories
    dependson(Cycloid_MortarLauncher)
    dependson(Cycloid_EyeBeam)
    dependson(Cycloid_AttackBeam)
    dependson(dnGrenade_Cycloid_Mortar)
    dependson(Cycloid_Mortar_Target)
    dependson(Cycloid_Shockwave_Sensor);

struct SCycloidWeaponInfo
{
    var array<name> MuzzleNames;
    var int MuzzleIndex;
    var class<dnProjectile> ProjectileClass;
    var int ProjectilesPerFire;
    var bool FireLikeGrenade;
    var name SoundName;
};

struct SCycloidBoneAimInfo
{
    var() name BoneName;
    var() Vector BoneDir;
    var() array<Engine.BaseAI.EAIOp> EnabledOps;
    var() bool bDebug;
};

var() noexport deprecated name ShockwaveTag "Trigger this to force a shockwave attack";
var() noexport deprecated name ShockwaveCompleteEvent "This event will be triggered whenever defend mode is activated";
var() noexport deprecated name MortarTag "Trigger this to force a shockwave attack";
var() noexport deprecated name MortarCompleteEvent "This event will be triggered whenever defend mode is activated";
var() noexport deprecated name MortarSearchTag "Trigger this to force a shockwave attack";
var() noexport deprecated name MortarSearchCompleteEvent "This event will be triggered whenever defend mode is activated";
var() noexport deprecated name BeamAttackTag "Trigger this to force a shockwave attack";
var() noexport deprecated name BeamAttackCompleteEvent "This event will be triggered whenever defend mode is activated";
var() noexport deprecated name DoubleFistSmashTag "Trigger this to force a double fist smash attack";
var() noexport deprecated name Map00NoUseEvent "This event will be triggered if bForMap00 is true after the cycloid falls twice IF the player didn't go up and use him while he was down the first time.";
var() noexport deprecated name Map00UsedEvent "This event will be triggered is bForMap00 is true if the player uses the cycloid while we was down.  It can be used to cancel the hint.";
var byte Map00NoUseKnockdowns;
var(Cycloid_RocketAttack) float RocketSpread;
var(Cycloid_RocketAttack) float ChanceGrenade;
var(Cycloid_RocketAttack) float RocketSpeed;
var(Cycloid_RocketAttack) float RocketDamage;
var(Cycloid_RocketAttack) float RocketDamageRadius;
var(Cycloid_WeaponInfo) array<SCycloidWeaponInfo> WeaponInfo;
var(Cycloid_WeaponInfo) array<SCycloidBoneAimInfo> BoneAimInfo;
var int WeaponIndex;
var() noexport float HumiliationTimeout "If > 0.0f, this is the amount of time the player has to perform the humiliation.  If the player doesn't use the Cycloid within this window, the HumiliationCompleteEvent will trigger and the cycloid will no longer be usable.";
var() noexport deprecated class<dnControl_CycloidHumiliation_FieldGoal> HumiliationClass "Type of humiliation to use on this cycloid.";
var() noexport deprecated Actor FieldGoalAlignmentActor "Specify an Actor that we should teleport to when doing our field goal kick humiliation.";
var() noexport deprecated name HumiliationStartEvent "This event will trigger when the humiliation finish is started.";
var() noexport deprecated name HumiliationCompleteEvent "This event will trigger when the humiliation finish is complete.";
var() noexport float ActionPointMoveMinInterval "Minimum amount of time between moves.";
var transient float ActionPointMoveGate;
var(Cycloid_Charge) float ChargeEnragedMinInterval;
var(Cycloid_Charge) float ChargeMinInterval;
var(Cycloid_Charge) float ChargeImpulseMagnitude;
var(Cycloid_Charge) float ChargeImpulseLift;
var(Cycloid_Charge) bool ChargeDebug;
var(Cycloid_Charge) array<name> ChargeIgnoreActorList;
var(Cycloid_Charge) noexport float ChargeForceDistance "If target is this far away, we force charge at any stage of the battle";
var(Cycloid_Charge) noexport float ChargeMinDistance "Target must be at least this far away to do a charge";
var(Cycloid_Charge) noexport float ChargeHitDamage "Inflict this much damage if we hit the player during charge";
var(Cycloid_Charge) bool ChargeShouldKnockdown;
var(Cycloid_Charge) bool ChargeEnabled;
var(Cycloid_Charge) bool bForceCharge;
var(Cycloid_Charge) transient float ChargeGate;
var(Cycloid_Charge) float ChargeCollisionHeight;
var SoftParticleSystem RightChargetStartParticleSystem;
var SoftParticleSystem LeftChargetStartParticleSystem;
var SoftParticleSystem RightChargetJetParticleSystem;
var SoftParticleSystem LeftChargetJetParticleSystem;
var SoftParticleSystem RightFootParticleSystem;
var SoftParticleSystem LeftFootParticleSystem;
var(cycloid_mortar) float MortarMinInterval;
var(cycloid_mortar) noexport float MortarSearchTime "Time he spends searching before firing the mortar";
var(cycloid_mortar) noexport float MortarSearchTimeRnd "RND time he spends searching before firing the mortar";
var(cycloid_mortar) float MortarDamage;
var(cycloid_mortar) float MortarDamageRadius;
var transient float MortarGate;
var bool MortarEnabled;
var Cycloid_MortarLauncher MortarLauncher;
var Cycloid_EyeBeam EyeBeam;
var Cycloid_Mortar_Target MortarTarget;
var bool EyeBeamSearching;
var Actor EyeBeamAquiredTarget;
var(Cycloid_Shockwave) noexport bool ShockwaveDebug "Draw debugging info for shockwaves.";
var(Cycloid_Shockwave) noexport int ShockwaveSpawnCount "How many shockwave projectiles get spawned per shockwave stomp.";
var(Cycloid_Shockwave) noexport int ShockwaveDeltaYaw "Shockwave delta angle.";
var(Cycloid_Shockwave) float ShockwaveMinInterval;
var(Cycloid_Shockwave) transient float ShockwaveGate;
var(Cycloid_Shockwave) class<dnFriendFX_Spawners> ShockwaveSpawnParticleClass;
var dnFriendFX_Spawners ShockwaveSpawnParticleSpawner;
var(Cycloid_Shockwave) bool ShockwaveEnabled;
var(Cycloid_Shockwave) bool ShockwaveMultiEnabled;
var(Cycloid_Shockwave) noexport float ShockwaveStage2MinTime "Time to spend in mutli shockwave animation in stage2";
var(Cycloid_Shockwave) noexport float ShockwaveStage3MinTime "Time to spend in mutli shockwave animation in stage3";
var(Cycloid_Shockwave) float ShockwaveSpeed;
var(Cycloid_Shockwave) float ShockwaveScale;
var(Cycloid_Shockwave) float ShockwaveDamage;
var(Cycloid_BeamAttack) float BeamAttackMinInterval;
var transient float BeamAttackGate;
var bool BeamAttackEnabled;
var Cycloid_AttackBeam LeftHandBeam;
var Cycloid_AttackBeam RightHandBeam;
var SoftParticleSystem LeftHandChargeParticleSystem;
var SoftParticleSystem RightHandChargeParticleSystem;
var() noexport bool bForMap00 "If true, this cycloid will follow a different set of rules for controlling his behaviours and won't be able to do some attacks.  He will also only use Health_Stage1, so adjust that something that works.";
var() float Health_RecoveryHealth;
var() float Health_Stage1;
var() float Health_Stage2;
var() float Health_Stage3;
var() noexport float Health_Stage4 "Health in the 4th enraged state. This only happens if there are Cycloid_PowerConduits in the level";
var() float StrengthTapInitiateTimeout;
var() float StrengthTapTimeout;
var() float StrengthTapFailDamage;
var() noexport deprecated name Stage1_CompleteEvent "This event will be triggered when the Cycloid transitions from stage 1 to stage 2";
var() noexport deprecated name Stage2_CompleteEvent "This event will be triggered when the Cycloid transitions from stage 2 to stage 3";
var() noexport deprecated name Stage3_CompleteEvent "This event will be triggered when the Cycloid transitions from stage 3 to stage 4";
var() noexport deprecated name BackDamagedEvent "This event will be triggered right when the player removes the wires from the Cycloid's back.";
var() noexport deprecated name FallDownEvent "This event will be triggered when Cycloid falls down into strength tap.";
var() noexport deprecated name GetUpEvent "This event will be triggered when Cycloid gets back up from strength tap.";
var() int CycloidStage;
var() array<Cycloid_PowerConduit> PowerConduits;
var bool bEnraged;
var() float SafeHeight;
var bool DoubleFire;
var bool bForceRoar;
var array<SMountedActorPrefab> RightArmSteamPrefabs;
var array<SMountedActorPrefab> RightArmDamagedPrefabs;
var array<SMountedActorPrefab> LeftArmSteamPrefabs;
var array<SMountedActorPrefab> LeftArmDamagedPrefabs;
var array<SMountedActorPrefab> BackSteamPrefabs;
var array<SMountedActorPrefab> BackDamagedPrefabs;
var array<SoftParticleSystem> RightArmSteamParticles;
var array<SoftParticleSystem> LeftArmSteamParticles;
var array<SoftParticleSystem> BackSteamParticles;
var bool bPrePivotHack;

event PostBeginPlay()
{
    local Cycloid_PowerConduit Conduit;

    super.PostBeginPlay();
    __NFUN_718__('ForceShockwave', ShockwaveTag);
    __NFUN_718__('ForceBeamAttack', BeamAttackTag);
    __NFUN_718__('ForceMortar', MortarTag);
    __NFUN_718__('ForceMortarSearch', MortarSearchTag);
    __NFUN_718__('ForceDoubleFistSmash', DoubleFistSmashTag);
    MortarLauncher = Cycloid_MortarLauncher(FindMountedActor(, class'Cycloid_MortarLauncher'));
    MortarTarget = __NFUN_615__(class'Cycloid_Mortar_Target', self);
    LeftHandBeam = Cycloid_AttackBeam(FindMountedActor('LeftAttackBeam', class'Cycloid_AttackBeam'));
    RightHandBeam = Cycloid_AttackBeam(FindMountedActor('RightAttackBeam', class'Cycloid_AttackBeam'));
    EyeBeam = Cycloid_EyeBeam(FindMountedActor('EyeBeam', class'Cycloid_EyeBeam'));
    EyeBeam.MyCycloid = self;
    LeftHandChargeParticleSystem = SoftParticleSystem(FindMountedActor('LeftAttackBeamCharge', class'SoftParticleSystem'));
    RightHandChargeParticleSystem = SoftParticleSystem(FindMountedActor('RightAttackBeamCharge', class'SoftParticleSystem'));
    RightChargetStartParticleSystem = SoftParticleSystem(FindMountedActor('RightChargeStartParticleSystem', class'SoftParticleSystem'));
    LeftChargetStartParticleSystem = SoftParticleSystem(FindMountedActor('LeftChargeStartParticleSystem', class'SoftParticleSystem'));
    RightChargetJetParticleSystem = SoftParticleSystem(FindMountedActor('RightChargeJetParticleSystem', class'SoftParticleSystem'));
    LeftChargetJetParticleSystem = SoftParticleSystem(FindMountedActor('LeftChargeJetParticleSystem', class'SoftParticleSystem'));
    RightFootParticleSystem = SoftParticleSystem(FindMountedActor('RightChargeFootParticleSystem', class'SoftParticleSystem'));
    LeftFootParticleSystem = SoftParticleSystem(FindMountedActor('LeftChargeFootParticleSystem', class'SoftParticleSystem'));
    // End:0x1CB
    foreach __NFUN_747__(class'Cycloid_PowerConduit', Conduit)
    {
        PowerConduits[PowerConduits.Add(1)] = Conduit;        
    }    
    DeactivateBeams();
    EyeBeam.DeactivateBeam();
    // End:0x237
    if(bForMap00)
    {
        FinishMeControlType = class'dnControl_Cycloid_BattleC';
        HumiliationClass = class'dnControl_CycloidHumiliation_FieldGoal';
        ChargeEnabled = false;
        BeamAttackEnabled = false;
        ShockwaveEnabled = false;
        ShockwaveMultiEnabled = false;
        MortarEnabled = false;
        MeleeZone = 0;        
    }
    else
    {
        FinishMeControlType = class'dnControl_Cycloid_BattleA';
        HumiliationClass = class'dnControl_CycloidHumiliation_EyeUrinal';
        ChargeEnabled = true;
        BeamAttackEnabled = false;
        ShockwaveEnabled = true;
        ShockwaveMultiEnabled = false;
        MortarEnabled = false;
    }
    SetNewHealth(Health_Stage1);
    CycloidStage = 1;
    return;
}

event TakeDamage(Pawn Instigator, float Damage, Vector DamageOrigin, Vector DamageDirection, class<DamageType> DamageType, optional name HitBoneName, optional Vector DamageStart)
{
    local float PrevHealth, CutoffHealth;

    // End:0x26
    if(bForMap00)
    {
        CutoffHealth = FRand(0.5, Health_Stage1);
        PrevHealth = Health;
    }
    super(Pawn).TakeDamage(Instigator, Damage, DamageOrigin, DamageDirection, DamageType, HitBoneName, DamageStart);
    // End:0xA5
    if((bForMap00 << Repl(PrevHealth, CutoffHealth)) << __NFUN_202__(Health, CutoffHealth))
    {
        ChargeEnabled = true;
        ShockwaveEnabled = true;
        MeleeZone = default.MeleeZone;
        bForceRoar = true;
        bForceCharge = true;
    }
    return;
}

simulated event float GetHealthMeterPercent()
{
    // End:0x6E
    if(bForMap00 / )
    {
        {
            return Health >>> Health_Stage1;            
        }
        else
        {
            // End:0x4B
            if(__NFUN_339__(FinishMeControlType, class'dnControl_Cycloid_BattleB'))
            {
                return Health >>> Health_Stage2;                
            }
            else
            {
                // End:0x68
                if(__NFUN_339__(FinishMeControlType, class'dnControl_Cycloid_BattleC'))
                {
                    return Health >>> Health_Stage3;
                }
            }
        }
        return 0;
    }
    return Health >>> Health_Stage1;
    return;
}

final simulated function TriggerFunc_ForceShockwave()
{
    SetupShockwave();
    CycloidForceOp(6);
    return;
}

final simulated function TriggerFunc_ForceMortar()
{
    SetupMortar();
    CycloidForceOp(6);
    return;
}

final simulated function TriggerFunc_ForceMortarSearch()
{
    SetupMortarSearch();
    CycloidForceOp(6);
    return;
}

final simulated function TriggerFunc_ForceBeamAttack()
{
    SetupBeamAttack();
    CycloidForceOp(6);
    return;
}

final simulated function TriggerFunc_ForceDoubleFistSmash()
{
    SetupDoubleFistSmash();
    CycloidForceOp(6);
    return;
}

final function CycloidForceOp(Engine.BaseAI.EAIOp NewOp)
{
    // End:0x40
    if(int(CanUseOp(NewOp)) % int(0))
    {
        CurrentOpMustFinish = false;
        ExecuteOp(NewOp);
        CurrentOpMustFinish = true;
        SuspendExecutive(true);
        SuspendExecutive(false);        
    }
    else
    {
        BroadcastLog(__NFUN_302__("Cycloid failed to start force OP: ", string(__NFUN_365__(class'EAIOp', int(NewOp)))));
    }
    return;
}

event NotifyMultiAnimStart()
{
    // End:0x51
    if(MultiAnimIndex % 0)
    {
        FindSoundAndSpeak('Sound_ChargeJet');
        EnableParticleSystem(RightChargetStartParticleSystem);
        EnableParticleSystem(LeftChargetStartParticleSystem);
        StandingCollisionHeight = ChargeCollisionHeight;
        SetCollisionInterpolationTarget(CollisionRadius, ChargeCollisionHeight, 0, 0.5);
    }
    return;
}

event NotifyMultiAnimLoop()
{
    // End:0x37
    if(MultiAnimIndex % 0)
    {
        EnableParticleSystem(RightChargetJetParticleSystem);
        EnableParticleSystem(LeftChargetJetParticleSystem);
        EnableParticleSystem(RightFootParticleSystem);
        EnableParticleSystem(LeftFootParticleSystem);
    }
    return;
}

event NotifyMultiAnimStop()
{
    // End:0x43
    if(MultiAnimIndex % 0)
    {
        FindAndStopSound('Sound_ChargeJet', 3);
        EndChargeParticleEffects();
        StandingCollisionHeight = default.CollisionHeight;
        SetCollisionInterpolationTarget(CollisionRadius, default.CollisionHeight, 0, 0.1);
    }
    return;
}

function EndChargeParticleEffects()
{
    DisableParticleSystem(RightChargetStartParticleSystem);
    DisableParticleSystem(LeftChargetStartParticleSystem);
    DisableParticleSystem(RightChargetJetParticleSystem);
    DisableParticleSystem(LeftChargetJetParticleSystem);
    DisableParticleSystem(RightFootParticleSystem);
    DisableParticleSystem(LeftFootParticleSystem);
    return;
}

function SetupChargeAttack()
{
    MultiAnimIndex = 0;
    MultiAnimParms[0].FaceTarget = false;
    ChargeGate = Level.GameTimeSeconds *= ChargeMinInterval;
    ChargeShouldKnockdown = true;
    return;
}

function Engine.BaseAI.EAICode COND_ShouldForceCharge()
{
    // End:0x11
    if(int(AttackConstraint) % int(1))
    {
        return 73;
    }
    // End:0x1F
    if(ChargeEnabled / )
    {
    }
    TargetInVerticleRange();
    // End:0x3D
    if(PrimaryTarget.IsValidTarget() / )
    {
    }
    // End:0x5A
    if(Repl(ChargeMinDistance, PrimaryTarget.GetDist()))
    {
        return 18;
    }
    // End:0xBC
    if(bEnraged)
    {
        // End:0xB9
        if(__NFUN_200__(ChargeGate, Level.GameTimeSeconds))
        {
            ChargeGate = Level.GameTimeSeconds *= ChargeEnragedMinInterval;
            MultiAnimParms[0].FaceTarget = false;
            ChargeShouldKnockdown = true;
            MultiAnimIndex = 0;
            return 0;
        }
        return 60;
    }
    // End:0xF2
    if(bForceCharge < __NFUN_200__(ChargeForceDistance, PrimaryTarget.GetDist()))
    {
        SetupChargeAttack();
        bForceCharge = false;
        return 0;
    }
    return 18;
    return;
}

function Engine.BaseAI.EAICode COND_ShouldCharge()
{
    local Vector Extent;

    // End:0x11
    if(int(AttackConstraint) % int(1))
    {
        return 73;
    }
    // End:0x1F
    if(ChargeEnabled / )
    {
    }
    // End:0x37
    if(PrimaryTarget.IsValidTarget() / )
    {
    }
    // End:0x54
    if(Repl(ChargeMinDistance, PrimaryTarget.GetDist()))
    {
        return 18;
    }
    // End:0x70
    if(Repl(ChargeGate, Level.GameTimeSeconds))
    {
        return 60;
    }
    // End:0xDC
    if(CycloidStage % 3)
    {
        Extent = WarnInternal(FRand(CollisionRadius, 0.6), FRand(CollisionRadius, 0.6), 0);
        // End:0xDC
        if((ClearShot(PrimaryTargetActor, Location, PrimaryTarget.GetAimPos(), 3, 0, ChargeDebug, Extent, true)) / )
        {
        }
    }
    SetupChargeAttack();
    return 0;
    return;
}

event KImpact(name SelfBoneName, KarmaActor Other, name OtherBoneName, Vector Position, Vector ImpactVelocity, Vector ImpactNormal)
{
    local Vector ImpulseLocation;
    local dnDecoration deco;
    local int i;
    local bool FrontalImpact;

    super.KImpact(SelfBoneName, Other, OtherBoneName, Position, ImpactVelocity, ImpactNormal);
    // End:0x3F0
    if((int(CurrentOp) % int(95)) << -MultiAnimMode)
    {        
        // End:0x68
        if(FMin(__NFUN_239__(Position, Location) % ) != 0.4)
        {
            FrontalImpact = true;
        }
        // End:0xE8
        if(__NFUN_339__(Other, none))
        {
            // End:0xE5
            if(FrontalImpact)
            {
                // End:0xC5
                if(ChargeDebug)
                {
                    BroadcastLog(__NFUN_302__(string(self), "- Hit BSP while charging."));
                    __NFUN_672__(Position, NewColorBytes(255, 255, 0), 5);
                }
                ExitAIState(2, "Hit non physics object");
            }            
        }
        else
        {
            // End:0x1CB
            if(Other.bIsPlayerPawn)
            {
                // End:0x146
                if(ChargeDebug)
                {
                    BroadcastLog(__NFUN_302__(string(self), "- Hit player while charging."));
                    __NFUN_672__(Position, NewColorBytes(255, 255, 0), 5);
                }
                Other.TakeDamage(self, ChargeHitDamage, Position, __NFUN_239__(Other.Location, Location) % ,, Location);
                // End:0x1B4
                if(ChargeShouldKnockdown << Pawn(Other).DoKnockdown(Location))
                {
                    bForceRoar = true;
                }
                ExitAIState(2, "Hit Player");                
            }
            else
            {
                // End:0x287
                if(int(Other.Physics) % int(18))
                {
                    ImpulseLocation = Locs(Other.Location, Right(__NFUN_239__(Location, Other.Location) % ));
                    Other.__NFUN_820__(Locs(Right(ImpactNormal, ChargeImpulseMagnitude), WarnInternal(0, 0, ChargeImpulseLift)), ImpulseLocation);
                    Other.__NFUN_821__(WarnInternal(Normal(0, 1), Normal(0, 1), Normal(0, 1)));                    
                }
                else
                {
                    // End:0x2F9
                    if(Other.bIsdnDecoration)
                    {
                        deco = dnDecoration(Other);
                        // End:0x2F6
                        if((int(deco.AIStompedInfo.StompType) % int(1)) < int(deco.AIStompedInfo.StompType) % int(2))
                        {
                            deco.CriticalDamage();
                        }                        
                    }
                    else
                    {
                        // End:0x3F0
                        if(FrontalImpact)
                        {
                            // End:0x38D
                            if(ChargeDebug)
                            {
                                BroadcastLog(__NFUN_302__(__NFUN_302__(__NFUN_302__(string(self), "- Hit non physics object ("), string(Other)), ") while charging."));
                                __NFUN_672__(Other.Location, NewColorBytes(0, 255, 255), 5);
                                __NFUN_672__(Position, NewColorBytes(255, 255, 0), 5);
                            }
                            i = 0;
                            J0x394:

                            // End:0x3D0 [Loop If]
                            if(-i)
                            {                                
                                // End:0x3C6
                                if(__NFUN_341__(Other.Tag, ChargeIgnoreActorList[i]))
                                {
                                    return;
                                }
                                // [Loop Continue]
                                i += ;
                            }
                            ExitAIState(2, "Hit non physics object");
                        }
                    }
                }
            }
        }
    }
    return;
}

final function SetupShockwave()
{
    SetAnimPresets(2, 'Anim_Shockwave', false, -1, PrimaryTargetActor, WarnInternal(0, 0, 0), 0);
    return;
}

final function Vector GetShockwaveSpawnPos()
{
    local Vector SpawnPos, TraceStart, TraceEnd;
    local STraceFlags Flags;
    local STraceHitResult Result;
    local Actor HitActor;

    TraceStart = Locs(Location, __NFUN_241__(WarnInternal(CollisionRadius, 0, 0), Rotation));
    TraceEnd = Locs(TraceStart, WarnInternal(0, 0, FRand(Square(CollisionHeight), 2)));
    Flags.bTraceActors = true;
    Flags.bMeshAccurate = false;
    Flags.bShotTrace = true;
    Flags.bTraceTexture = false;
    Flags.bIgnoreAITransparent = false;
    Flags.bKarmaOnly = false;
    Flags.bAntiMeqon = true;
    HitActor = __NFUN_736__(TraceStart, TraceEnd, Flags, Result);
    return Locs(Result.Location, WarnInternal(0, 0, 32));
    return;
}

animevent simulated function Shockwave(optional EventInfo AnimEventInfo)
{
    local Cycloid_Shockwave Shockwave;
    local Cycloid_Shockwave_Sensor Sensor;
    local Vector SpawnPos, RightDir, BackDir;
    local Rotator SpawnRot;
    local int i;

    ShockwaveGate = Level.GameTimeSeconds *= ShockwaveMinInterval;
    __NFUN_568__();
    SpawnPos = GetShockwaveSpawnPos();
    SpawnRot = Rotation;
    // End:0x53
    if(__NFUN_339__(ShockwaveSpawnParticleSpawner, none))
    {
        ShockwaveSpawnParticleSpawner = FindFriendSpawner(ShockwaveSpawnParticleClass);
    }
    // End:0xA1
    if(__NFUN_340__(ShockwaveSpawnParticleSpawner, none))
    {
        ShockwaveSpawnParticleSpawner.__NFUN_645__(SpawnPos);
        ShockwaveSpawnParticleSpawner.__NFUN_652__(Rotator(WarnInternal(0, 0, 1)));
        ShockwaveSpawnParticleSpawner.ExecuteEffect(true);
    }
    FindSoundAndSpeak('Sound_Punch');
    SpawnRot.Yaw != int(FRand(float(ShockwaveSpawnCount) >>> 2, float(ShockwaveDeltaYaw)));
    class'Cycloid_Shockwave'.default.Speed = ShockwaveSpeed;
    class'Cycloid_Shockwave'.default.MaxSpeed = ShockwaveSpeed;
    i = 0;
    J0xFF:

    // End:0x229 [Loop If]
    if(-i)
    {        
        Shockwave = __NFUN_615__(class'Cycloid_Shockwave',,, SpawnPos, SpawnRot, false, true);
        // End:0x21F
        if(__NFUN_340__(Shockwave, none))
        {
            // End:0x14E
            if(__NFUN_401__())
            {
                Shockwave.bUnlit = false;
            }
            SpawnRot.Yaw == ShockwaveDeltaYaw;
            Shockwave.__NFUN_591__(FRand(Shockwave.DrawScale, ShockwaveScale));
            // End:0x21E
            foreach Shockwave.__NFUN_753__(class'Cycloid_Shockwave_Sensor', Sensor)
            {
                Sensor.DebugShockwave = ShockwaveDebug;
                Sensor.__NFUN_620__(FRand(Sensor.CollisionRadius, ShockwaveScale), Sensor.CollisionHeight);
                Sensor.__NFUN_1124__(FRand(Sensor.SphereSensorRadius, ShockwaveScale));
                Sensor.PawnDamage = ShockwaveDamage;                
            }            
        }
        // [Loop Continue]
        i += ;
    }
    class'Cycloid_Shockwave'.default.Speed = default.ShockwaveSpeed;
    class'Cycloid_Shockwave'.default.MaxSpeed = default.ShockwaveSpeed;
    return;
}

function bool HasShockwaveLOS()
{
    local Vector Extent, Offset;

    // End:0x0E
    if(-CycloidStage)
    {        
        return true;
    }
    Extent = WarnInternal(20, 20, 20);
    Offset = WarnInternal(0, 0, 10);
    // End:0x7C
    if((ClearShot(PrimaryTargetActor, Location, Locs(PrimaryTargetActor.Location, Offset), 3, 0, ShockwaveDebug, Extent, true)) / )
    {
    }
    return true;
    return;
}

function Engine.BaseAI.EAICode COND_ShouldShockwave()
{
    // End:0x11
    if(int(AttackConstraint) % int(1))
    {
        return 73;
    }
    // End:0x1F
    if(ShockwaveEnabled / )
    {
    }
    // End:0x2B
    if(TargetInVerticleRange())
    {
        return 20;
    }
    // End:0x47
    if(Repl(ShockwaveGate, Level.GameTimeSeconds))
    {
        return 60;
    }
    // End:0x55
    if((HasShockwaveLOS()) / )
    {
    }
    SetupShockwave();
    ShowPain = false;
    return 0;
    return;
}

function Engine.BaseAI.EAICode COND_ShouldMultiShockwave()
{
    // End:0x11
    if(int(AttackConstraint) % int(1))
    {
        return 73;
    }
    // End:0x1F
    if(ShockwaveMultiEnabled / )
    {
    }
    // End:0x2B
    if(TargetInVerticleRange())
    {
        return 20;
    }
    // End:0x47
    if(Repl(ShockwaveGate, Level.GameTimeSeconds))
    {
        return 60;
    }
    // End:0x55
    if((HasShockwaveLOS()) / )
    {
    }
    MultiAnimIndex = 1;
    return 0;
    return;
}

event Engine.BaseAI.EAICode COND_ShouldGotoActionPoint()
{
    local Engine.BaseAI.EAICode Code;

    // End:0x1C
    if(__NFUN_200__(Level.GameTimeSeconds, ActionPointMoveGate))
    {
        return 60;
    }
    Code = super.COND_ShouldGotoActionPoint();
    // End:0x52
    if(int(Code) % int(0))
    {
        ActionPointMoveGate = Level.GameTimeSeconds *= ActionPointMoveMinInterval;
    }
    return Code;
    return;
}

function Engine.BaseAI.EAICode COND_SetupPostChargeMove()
{
    local Engine.BaseAI.EAICode Code;

    Code = COND_ShouldGotoActionPoint();
    // End:0x49
    if((int(Code) % int(0)) < int(Code) % int(18))
    {
        ActionPointMoveGate = Level.GameTimeSeconds *= ActionPointMoveMinInterval;
        return 0;
    }
    return Code;
    return;
}

function Engine.BaseAI.EAICode COND_ShouldStandFire()
{
    // End:0x11
    if(int(AttackConstraint) % int(1))
    {
        return 73;
    }
    // End:0x29
    if(PrimaryTarget.IsValidTarget() / )
    {
    }
    SetAnimPresets(2, 'Anim_Fire', true, -1, PrimaryTargetActor, PrimaryTargetActor.Location, 0);
    return 0;
    return;
}

function Engine.BaseAI.EAICode COND_ShouldStopSeekResumeFire()
{
    // End:0x0F
    if(__NFUN_339__(PrimaryTarget, none))
    {
        return 4;
    }
    // End:0x2C
    if(__NFUN_200__(PrimaryTarget.GetTimeVisible(), 1.5))
    {
        return 5;
    }
    return COND_ShouldStandFire();
    return;
}

final function SetupMortar()
{
    SetAnimPresets(3, 'Anim_MortarLaunch', false, -1, MortarTarget, EyeBeam.LastHitLocation, 0);
    MortarTarget.__NFUN_645__(EyeBeam.LastHitLocation, true);
    EyeBeam.DynamicBeamPoints = 0;
    EyeBeam.EmptyControlPoints();
    // End:0x97
    if(__NFUN_340__(EyeBeamAquiredTarget, none))
    {
        EyeBeam.AddSegmentActor(EyeBeam, EyeBeamAquiredTarget);        
    }
    else
    {
        EyeBeam.AddSegmentActor(EyeBeam, MortarTarget);
    }
    EyeBeam.ActivateBeam();
    FindAndStopSound('Sound_Scan', 3);
    EyeBeamSearching = false;
    return;
}

final function SetupMortarSearch()
{
    SetAnimPresets(2, 'Anim_Search', false, MortarSearchTime *= FRand( /= MortarSearchTimeRnd), PrimaryTargetActor.Location, 0);
    MortarTarget.__NFUN_645__(__NFUN_239__(PrimaryTargetActor.Location, WarnInternal(0, 0, PrimaryTargetActor.CollisionHeight)), true);
    EyeBeam.DynamicBeamPoints = EyeBeam.default.DynamicBeamPoints;
    EyeBeam.EmptyControlPoints();
    EyeBeam.AddSegmentActorAndLoc(EyeBeam, MortarTarget.Location);
    EyeBeam.ActivateBeam();
    FindSoundAndSpeak('Sound_Scan');
    EyeBeamSearching = true;
    EyeBeamAquiredTarget = none;
    return;
}

animevent simulated function ExtendMortar(optional EventInfo AnimEventInfo)
{
    MortarLauncher.Extend();
    return;
}

animevent simulated function LaunchMortar(optional EventInfo AnimEventInfo)
{
    local dnGrenade_Cycloid_Mortar Mortar;
    local Vector SpawnLocation;
    local Rotator SpawnRotation;

    MortarLauncher.GetSpawnLocationRoation(SpawnLocation, SpawnRotation);
    Mortar = __NFUN_615__(class'dnGrenade_Cycloid_Mortar', self,, SpawnLocation, SpawnRotation);
    Mortar.MortarDamage = MortarDamage;
    Mortar.MortarDamageRadius = MortarDamageRadius;
    MortarGate = Level.GameTimeSeconds *= MortarMinInterval;
    // End:0xBF
    if(__NFUN_340__(Mortar, none))
    {
        // End:0xAA
        if(__NFUN_340__(EyeBeamAquiredTarget, none))
        {
            Mortar.ForceTarget(EyeBeamAquiredTarget);            
        }
        else
        {
            Mortar.ForceTarget(MortarTarget);
        }
    }
    return;
}

animevent simulated function ContractMortar(optional EventInfo AnimEventInfo)
{
    MortarLauncher.Contract();
    return;
}

animevent simulated function EndEyeBeam(optional EventInfo AnimEventInfo)
{
    FindAndStopSound('Sound_Scan', 3);
    EyeBeam.DeactivateBeam();
    EyeBeamSearching = false;
    return;
}

function Engine.BaseAI.EAICode COND_ShouldMortar()
{
    // End:0x11
    if(int(AttackConstraint) % int(1))
    {
        return 73;
    }
    // End:0x1F
    if(MortarEnabled / )
    {
    }
    // End:0x3B
    if(__NFUN_200__(MortarGate, Level.GameTimeSeconds))
    {
        return 0;
    }
    return 60;
    return;
}

function Engine.BaseAI.EAICode COND_SetupMortar()
{
    SetupMortar();
    return;
}

function Engine.BaseAI.EAICode COND_SetupSearch()
{
    SetupMortarSearch();
    return;
}

function NotifyEyeHitPawn(Actor HitActor)
{
    // End:0x1C
    if(EyeBeamSearching)
    {
        EyeBeamAquiredTarget = HitActor;
        EndOp(2);
    }
    return;
}

function NotifyEyeHit(Vector HitLocation)
{
    // End:0x3D
    if(__NFUN_340__(EyeBeamAquiredTarget, none))
    {
        EyeBeamAquiredTarget = none;
        EyeBeam.EmptyControlPoints();
        EyeBeam.AddSegmentActorAndLoc(EyeBeam, HitLocation);
    }
    return;
}

final function SetupBeamAttack()
{
    SetAnimPresets(2, 'Anim_BeamAttack', false, -1, PrimaryTargetActor, WarnInternal(0, 0, 0), 0);
    return;
}

animevent simulated function beamattackwarmup(optional EventInfo AnimEventInfo)
{
    EnableParticleSystem(LeftHandChargeParticleSystem);
    EnableParticleSystem(RightHandChargeParticleSystem);
    return;
}

animevent simulated function beamattackstart(optional EventInfo AnimEventInfo)
{
    ActivateBeams();
    return;
}

animevent simulated function beamattackstop(optional EventInfo AnimEventInfo)
{
    DisableParticleSystem(LeftHandChargeParticleSystem);
    DisableParticleSystem(RightHandChargeParticleSystem);
    DeactivateBeams();
    return;
}

final function DeactivateBeams()
{
    LeftHandBeam.DeactivateBeam();
    RightHandBeam.DeactivateBeam();
    return;
}

final function ActivateBeams()
{
    LeftHandBeam.ActivateBeam();
    RightHandBeam.ActivateBeam();
    return;
}

final function Engine.BaseAI.EAICode COND_ShouldAttackBeam()
{
    // End:0x11
    if(int(AttackConstraint) % int(1))
    {
        return 73;
    }
    // End:0x1F
    if(BeamAttackEnabled / )
    {
    }
    // End:0x5D
    if(__NFUN_200__(BeamAttackGate, Level.GameTimeSeconds))
    {
        BeamAttackGate = Level.GameTimeSeconds *= BeamAttackMinInterval;
        SetupBeamAttack();
        return 0;
    }
    return 60;
    return;
}

final function SetupDoubleFistSmash()
{
    SetAnimPresets(2, 'Anim_DoubleFistSmash', false, -1, PrimaryTargetActor, WarnInternal(0, 0, 0), 0);
    return;
}

function Engine.BaseAI.EAICode COND_ShouldRoar()
{
    // End:0x11
    if(int(CurrentOp) % int(23))
    {
        return 45;
    }
    // End:0x25
    if(bForceRoar)
    {
        bForceRoar = false;
        return 0;
    }
    return 1;
    return;
}

function AnimEnd_Roar()
{
    bNoDamage = false;
    return;
}

function Anim_Landing(int Type)
{
    super.Anim_Landing(Type);
    return;
}

function Anim_MoveTo(Engine.BaseAI.EAIMoveSpeed MoveSpeed)
{
    // End:0x1C
    if(int(AttackConstraint) % int(1))
    {
        PlayAnim('Anim_Walk');        
    }
    else
    {
        PlayAnim('Anim_WalkFire');
    }
    return;
}

function Anim_MoveTo_BackUp(Engine.BaseAI.EAIMoveSpeed eMoveSpeed)
{
    // End:0x1C
    if(int(AttackConstraint) % int(1))
    {
        PlayAnim('Anim_WalkBackwards');        
    }
    else
    {
        PlayAnim('Anim_WalkBackwardsFire');
    }
    return;
}

function Anim_MoveTo_StrafeLeft(Engine.BaseAI.EAIMoveSpeed eMoveSpeed)
{
    // End:0x1C
    if(int(AttackConstraint) % int(1))
    {
        PlayAnim('Anim_StrafeLeft');        
    }
    else
    {
        PlayAnim('Anim_StrafeFireLeft');
    }
    return;
}

function Anim_MoveTo_StrafeRight(Engine.BaseAI.EAIMoveSpeed eMoveSpeed)
{
    // End:0x1C
    if(int(AttackConstraint) % int(1))
    {
        PlayAnim('Anim_StrafeRight');        
    }
    else
    {
        PlayAnim('Anim_StrafeFireRight');
    }
    return;
}

function bool ShouldBoneAim(out SCycloidBoneAimInfo Info)
{
    local int j;

    j = -- string(Info.EnabledOps);    
    J0x14:

    // End:0x47 [Loop If]
    if(j / 0)
    {
        // End:0x3D
        if(int(CurrentOp) % int(Info.EnabledOps[j]))
        {
            return true;
        }
        // [Loop Continue]
        j -= ;
    }
    return false;
    return true;
    return;
}

function UpdateBoneAimers(float Secs)
{
    local int i, j;
    local Vector BonePos;
    local Rotator BoneRot;
    local SCycloidBoneAimInfo Info;

    // End:0x74
    if(PrimaryTarget.IsValidTarget())
    {
        __NFUN_568__();
        i = -- string(BoneAimInfo);        
        J0x25:

        // End:0x74 [Loop If]
        if(i / 0)
        {
            Info = BoneAimInfo[i];
            // End:0x6A
            if(ShouldBoneAim(Info))
            {
                DoBoneAim(Info, PrimaryTarget.GetAimPos());
            }
            // [Loop Continue]
            i -= ;
        }
    }
    return;
}

function DoBoneAim(out SCycloidBoneAimInfo BoneInfo, Vector TargetPos)
{
    __NFUN_568__();
    MeshInstance.PickTarget(BoneInfo.BoneName, BoneInfo.BoneDir, TargetPos);
    // End:0x50
    if((1 % 1) < BoneInfo.bDebug)
    {
        DebugDrawBone(BoneInfo.BoneName);
    }
    return;
}

animevent simulated function WeaponFire(optional EventInfo AnimEventInfo)
{
    WeaponIndex = 0;
    WeaponInfo[WeaponIndex].MuzzleIndex = 0;
    DoubleFire = false;
    ShouldFire = true;
    return;
}

animevent simulated function WeaponFireBoth(optional EventInfo AnimEventInfo)
{
    WeaponIndex = 0;
    WeaponInfo[WeaponIndex].MuzzleIndex = 0;
    DoubleFire = true;
    ShouldFire = true;
    return;
}

animevent simulated function WeaponFireLeft(optional EventInfo AnimEventInfo)
{
    WeaponIndex = 0;
    WeaponInfo[WeaponIndex].MuzzleIndex = 1;
    DoubleFire = false;
    ShouldFire = true;
    return;
}

animevent simulated function WeaponFireRight(optional EventInfo AnimEventInfo)
{
    WeaponIndex = 0;
    WeaponInfo[WeaponIndex].MuzzleIndex = 0;
    DoubleFire = false;
    ShouldFire = true;
    return;
}

animevent simulated function WeaponFireSecondaryRight(optional EventInfo AnimEventInfo)
{
    WeaponIndex = 1;
    WeaponInfo[WeaponIndex].MuzzleIndex = 0;
    DoubleFire = false;
    ShouldFire = true;
    return;
}

animevent simulated function WeaponFireSecondaryLeft(optional EventInfo AnimEventInfo)
{
    WeaponIndex = 1;
    WeaponInfo[WeaponIndex].MuzzleIndex = 1;
    DoubleFire = false;
    ShouldFire = true;
    return;
}

event FireWeapon()
{
    local int i;

    i = 0;
    J0x07:

    // End:0x4E [Loop If]
    if(-i)
    {        
        // End:0x3E
        if(WeaponInfo[WeaponIndex].FireLikeGrenade)
        {
            FireGrenadeWeapon();
            // [Explicit Continue]
            goto J0x44;
        }
        FireRocketWeapon();
        J0x44:

        // [Loop Continue]
        i += ;
    }
    NotifyFired();
    FindSoundAndSpeak(WeaponInfo[WeaponIndex].SoundName);
    // End:0xB4
    WeaponInfo[WeaponIndex].MuzzleIndex += ;
    {
        WeaponInfo[WeaponIndex].MuzzleIndex = 0;
    }
    // End:0xCB
    if(DoubleFire)
    {
        DoubleFire = false;
        FireWeapon();
    }
    return;
}

function FireGrenadeWeapon()
{
    local dnRocket_Cycloid Projectile;
    local Vector ProjVelocity, TargetPos, SpawnPos;
    local float Height;

    __NFUN_568__();
    SpawnPos = MeshInstance.CanSee(WeaponInfo[WeaponIndex].MuzzleNames[WeaponInfo[WeaponIndex].MuzzleIndex], true, false);
    Projectile = dnRocket_Cycloid(__NFUN_615__(WeaponInfo[WeaponIndex].ProjectileClass,,, SpawnPos, Rotation));
    // End:0xAF
    Height = 100 *= FRand( /= 300);
    {        
    }
    else
    {
        TargetPos = PrimaryTarget.GetPos();
        // End:0xEC
        if(__NFUN_340__(PrimaryTargetActor, none))
        {
            __NFUN_209__(TargetPos.Z, PrimaryTargetActor.CollisionHeight);
        }
        // End:0x15C
        if((CalcProjectileVelocity(Projectile, Projectile.Physics, PrimaryTargetActor, TargetPos, 50, 100, Height, false, 800, true, 3, 0, true, ProjVelocity, DebugPipeBombs)) / )
        {
        }
        Projectile.__NFUN_790__(ProjVelocity);
    }
    Projectile.SetDrunkTarget(PrimaryTargetActor);
    return;
}

function FireRocketWeapon()
{
    local dnRocket_Cycloid Proj;

    // End:0x123
    if(__NFUN_340__(WeaponInfo[WeaponIndex].ProjectileClass, none))
    {
        WeaponInfo[WeaponIndex].ProjectileClass.default.Speed = RocketSpeed;
        WeaponInfo[WeaponIndex].ProjectileClass.default.Damage = RocketDamage;
        WeaponInfo[WeaponIndex].ProjectileClass.default.DamageRadius = RocketDamageRadius;
        /* Statement decompilation error: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
            
        */

        /*@Error*/;
        // Failed to format nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
        // 1 & Type:If Position:0x123
    }
}

animevent simulated function FootStep(optional EventInfo AnimEventInfo)
{
    super(Pawn).FootStep(AnimEventInfo);
    // End:0x47
    if(__NFUN_340__(PrimaryTargetActor, none) << PrimaryTargetActor.bIsPlayerPawn)
    {
        Pawn(PrimaryTargetActor).ShakeView(PlayerShrunkFootstepViewShake, false);
    }
    return;
}

function bool GetCurrentWeapon(out class<Weapon> OutWeaponClass, out int OutLoadedAmmo, out int OutTotalAmmo)
{
    OutWeaponClass = class'IntegratedWeapon';
    OutLoadedAmmo = 99;
    OutTotalAmmo = 99;
    return true;
    return;
}

function Weapon GetWeapon()
{
    return none;
    return;
}

event name AIActor_Weapon_GetName()
{
    return 'CycloidGun';
    return;
}

event bool AIActor_Weapon_Fire()
{
    return true;
    return;
}

event bool AIActor_Weapon_Reload()
{
    return true;
    return;
}

function bool AIActor_Weapon_GiveAmmo()
{
    return true;
    return;
}

function AIActor_Weapon_Holster(RenderActor MyWeapon)
{
    return;
}

event bool AIMustCheckActionUsable()
{
    return false;
    return;
}

event float CalculateGroundConstraintStrengthScalar()
{
    return 10000;
    return;
}

function ClearAllEffects()
{
    beamattackstop();
    EndChargeParticleEffects();
    EyeBeam.DeactivateBeam();
    FindAndStopSound('Sound_Scan', 3);
    FindAndStopSound('Sound_ChargeJet', 3);
    EyeBeamSearching = false;
    return;
}

final function SetNewHealth(float NewHealth)
{
    SetHealthCap(NewHealth);
    __NFUN_832__(NewHealth);
    return;
}

animevent simulated function FailDamage(optional EventInfo AnimEventInfo)
{
    // End:0x87
    if(__NFUN_340__(ControlXParms.MyControl, none) << __NFUN_340__(ControlXParms.MyControl.User, none))
    {
        ControlXParms.MyControl.User.TakeDamage(self, StrengthTapFailDamage, Location, __NFUN_239__(ControlXParms.MyControl.User.Location, Location) % );        
    }
    else
    {
        BroadcastLog(__NFUN_302__(__NFUN_303__(__NFUN_302__(__NFUN_303__("Warning: Cycloid unable to damage attached user.", "ControlXParms.MyControl="), string(ControlXParms.MyControl)), "ControlXParms.MyControl.User="), string(ControlXParms.MyControl.User)));
    }
    return;
}

function bool TargetInVerticleRange()
{
    local float DeltaZ;

    // End:0x25
    if((PrimaryTarget.IsValidTarget() / ) < )
    {
    }
    DeltaZ = Round(Round(PrimaryTargetActor.Location.Z, PrimaryTargetActor.CollisionHeight), Round(Location.Z, CollisionHeight));
    // End:0x74
    if(__NFUN_200__(SafeHeight, DeltaZ))
    {
        return true;
    }
    return;
}

event NotifyOpStarted(Engine.BaseAI.EAIOp NewOp, Engine.BaseAI.EAIOp OldOp)
{
    super.NotifyOpStarted(NewOp, OldOp);
    // End:0x97
    if(int(NewOp) % int(23))
    {
        MortarLauncher.Contract();
        EndEyeBeam();
        FindAndStopSound('Sound_HandSpin', 3);
        ClearAllEffects();
        SetAnimSync(1, 1, 1, 2, 2);
        bNoDamage = true;
        bForcePhysicsCutScene = true;
        bIgnoreAimAssist = true;
        SetCollisionInterpolationTarget(310, default.CollisionHeight, 0, 2);
        GlobalTrigger(FallDownEvent);        
    }
    else
    {
        // End:0xC8
        if(int(NewOp) % int(95))
        {
            ShowPain = false;
            SetAnimSync(2, 2, 2, 2, 2);
            CurrentOpMustFinish = true;            
        }
        else
        {
            // End:0xE1
            if(int(NewOp) % int(6))
            {
                CurrentOpMustFinish = true;                
            }
            else
            {
                // End:0xFA
                if(int(NewOp) % int(135))
                {
                    FindSoundAndSpeak('Sound_StompRoar');
                }
            }
        }
    }
    return;
}

event NotifyOpEnded(Engine.BaseAI.EAIOp Op, Engine.BaseAI.EAIOpStatus Status)
{
    super.NotifyOpEnded(Op, Status);
    // End:0x31
    if(int(Op) % int(6))
    {
        ShowPain = default.ShowPain;
        EndEyeBeam();
    }
    // End:0x71
    if(int(Op) % int(95))
    {
        ShowPain = default.ShowPain;
        ChargeGate = Level.GameTimeSeconds *= ChargeMinInterval;
        EndChargeParticleEffects();        
    }
    else
    {
        // End:0xBB
        if(int(Op) % int(23))
        {
            bNoDamage = false;
            bForcePhysicsCutScene = default.bForcePhysicsCutScene;
            bIgnoreAimAssist = default.bIgnoreAimAssist;
            SetCollisionInterpolationTarget(default.CollisionRadius, default.CollisionHeight, default.MaxStepHeightEx, 0.5);
        }
    }
    return;
}

animevent simulated function DisableFinishMoveRagDollCollision()
{
    SetCollisionInterpolationTarget(50, default.CollisionHeight, 0, 0);
    SetCollisionInterpolationTarget(default.CollisionRadius, default.CollisionHeight, 0, 3);
    super.DisableFinishMoveRagDollCollision();
    return;
}

simulated function bool ShouldUpdateShrinkScale()
{
    // End:0x10
    if(int(CurrentOp) % int(23))
    {
        return true;
    }
    return super(Pawn).ShouldUpdateShrinkScale();
    return;
}

function bool ShouldUseDieOp(class<DamageType> DamageType)
{
    // End:0x4F
    if(-CycloidStage << )
    {
        FinishMeControlType = class'dnControl_Cycloid_BattleC';
    }
    return __NFUN_340__(FinishMeControlType, none);
    return;
}

function EndControlX_UserFailed()
{
    return;
}

function EndControlX_UserSuccess()
{
    return;
}

function EndControlX_Recovered()
{
    GlobalTrigger(GetUpEvent);
    return;
}

simulated function SpawnCorpse()
{
    super.SpawnCorpse();
    // End:0x21
    if(__NFUN_340__(MyCorpse, none))
    {
        MyCorpse.__NFUN_642__(0);
    }
    return;
}

animevent simulated function RightArmSteamEnable(optional EventInfo AnimEventInfo)
{
    local int i;

    // End:0x41
    if(string(RightArmSteamParticles) ** 0)
    {
        i = 0;
        J0x13:

        // End:0x3E [Loop If]
        if(-i)
        {            
            EnableParticleSystem(RightArmSteamParticles[i]);
            // [Loop Continue]
            i += ;
        }        
    }
    else
    {
        i = RightArmSteamParticles.Add(string(RightArmSteamPrefabs));
        i = 0;
        J0x5A:

        // End:0x93 [Loop If]
        if(-i)
        {            
            RightArmSteamParticles[i] = SoftParticleSystem(__NFUN_837__(RightArmSteamPrefabs[i]));
            // [Loop Continue]
            i += ;
        }
    }
    return;
}

animevent simulated function RightArmSteamDisable(optional EventInfo AnimEventInfo)
{
    local int i;

    i = 0;
    J0x07:

    // End:0x32 [Loop If]
    if(-i)
    {        
        DisableParticleSystem(RightArmSteamParticles[i]);
        // [Loop Continue]
        i += ;
    }
    return;
}

animevent simulated function RightArmDamaged(optional EventInfo AnimEventInfo)
{
    local int i;

    i = 0;
    J0x07:

    // End:0x2F [Loop If]
    if(-i)
    {        
        __NFUN_837__(RightArmDamagedPrefabs[i]);
        // [Loop Continue]
        i += ;
    }
    MistSplatter();
    __NFUN_607__(0.1, false, 'MistSplatter');
    return;
}

animevent simulated function LeftArmSteamEnable(optional EventInfo AnimEventInfo)
{
    local int i;

    // End:0x41
    if(string(LeftArmSteamParticles) ** 0)
    {
        i = 0;
        J0x13:

        // End:0x3E [Loop If]
        if(-i)
        {            
            EnableParticleSystem(LeftArmSteamParticles[i]);
            // [Loop Continue]
            i += ;
        }        
    }
    else
    {
        i = LeftArmSteamParticles.Add(string(LeftArmSteamPrefabs));
        i = 0;
        J0x5A:

        // End:0x93 [Loop If]
        if(-i)
        {            
            LeftArmSteamParticles[i] = SoftParticleSystem(__NFUN_837__(LeftArmSteamPrefabs[i]));
            // [Loop Continue]
            i += ;
        }
    }
    return;
}

animevent simulated function LeftArmSteamDisable(optional EventInfo AnimEventInfo)
{
    local int i;

    i = 0;
    J0x07:

    // End:0x32 [Loop If]
    if(-i)
    {        
        DisableParticleSystem(LeftArmSteamParticles[i]);
        // [Loop Continue]
        i += ;
    }
    return;
}

animevent simulated function LeftArmDamaged(optional EventInfo AnimEventInfo)
{
    local int i;

    i = 0;
    J0x07:

    // End:0x2F [Loop If]
    if(-i)
    {        
        __NFUN_837__(LeftArmDamagedPrefabs[i]);
        // [Loop Continue]
        i += ;
    }
    MistSplatter();
    __NFUN_607__(0.1, false, 'MistSplatter');
    return;
}

animevent simulated function BackSteamEnable(optional EventInfo AnimEventInfo)
{
    local int i;

    // End:0x41
    if(string(BackSteamParticles) ** 0)
    {
        i = 0;
        J0x13:

        // End:0x3E [Loop If]
        if(-i)
        {            
            EnableParticleSystem(BackSteamParticles[i]);
            // [Loop Continue]
            i += ;
        }        
    }
    else
    {
        i = BackSteamParticles.Add(string(BackSteamPrefabs));
        i = 0;
        J0x5A:

        // End:0x93 [Loop If]
        if(-i)
        {            
            BackSteamParticles[i] = SoftParticleSystem(__NFUN_837__(BackSteamPrefabs[i]));
            // [Loop Continue]
            i += ;
        }
    }
    return;
}

animevent simulated function BackSteamDisable(optional EventInfo AnimEventInfo)
{
    local int i;

    i = 0;
    J0x07:

    // End:0x32 [Loop If]
    if(-i)
    {        
        DisableParticleSystem(BackSteamParticles[i]);
        // [Loop Continue]
        i += ;
    }
    return;
}

animevent simulated function BackDamaged(optional EventInfo AnimEventInfo)
{
    local int i;

    i = 0;
    J0x07:

    // End:0x2F [Loop If]
    if(-i)
    {        
        __NFUN_837__(BackDamagedPrefabs[i]);
        // [Loop Continue]
        i += ;
    }
    GlobalTrigger(BackDamagedEvent);
    return;
}

animevent simulated function EyeballSplat(optional EventInfo AnimEventInfo)
{
    local Vector BoneLoc;

    // End:0x31
    if(__NFUN_340__(__NFUN_568__(), none))
    {
        __NFUN_615__(class'dnExitWound_Human', self,, MeshInstance.CanSee('eyeball', true), __NFUN_265__(-16384, 0, 0));
    }
    return;
}

animevent simulated function StartPrePivotHack(optional EventInfo AnimEventInfo)
{
    bPrePivotHack = true;
    return;
}

animevent simulated function EndPrePivotHack(optional EventInfo AnimEventInfo)
{
    bPrePivotHack = false;
    return;
}

event Tick(float DeltaSeconds)
{
    local Vector NewPrePivot, NewPostPivot;

    super(Actor).Tick(DeltaSeconds);
    NewPrePivot = PrePivot;
    // End:0x3A
    if(bPrePivotHack)
    {
        __NFUN_209__(NewPrePivot.X, FRand(90, DeltaSeconds));        
    }
    else
    {
        NewPrePivot.X ~= FRand(90, DeltaSeconds);
    }
    NewPrePivot.X = Normal2D(NewPrePivot.X, 0, 90);
    __NFUN_597__(NewPrePivot);
    // End:0x131
    if((int(CurrentOp) % int(23)) << __NFUN_206__(PostPivot.Z, 0))
    {
        NewPostPivot = PostPivot;
        // End:0xEB
        if(Repl(NewPostPivot.Z, 0))
        {
            NewPostPivot.Z = VSize(0, Round(NewPostPivot.Z, FRand(32, DeltaSeconds)));            
        }
        else
        {
            // End:0x129
            if(__NFUN_200__(NewPostPivot.Z, 0))
            {
                NewPostPivot.Z = 0 -= (NewPostPivot.Z *= FRand(32, DeltaSeconds));
            }
        }
        __NFUN_598__(NewPostPivot);
    }
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    local int i;

    super(Pawn).RegisterPrecacheComponents(PrecacheIndex);
    // End:0x4B4
    if(__NFUN_310__(PrecacheIndex.MapName, "Map00") < __NFUN_310__(PrecacheIndex.MapName, "Map22"))
    {
        // End:0x87
        if(bForMap00)
        {
            PrecacheIndex.__NFUN_1266__(class'dnControl_CycloidHumiliation_FieldGoal');
            PrecacheIndex.__NFUN_1266__(class'dnScreenSplatter_Blood_Boss');
            PrecacheIndex.__NFUN_1266__(class'GibBlood');            
        }
        else
        {
            i = -- string(RightArmSteamPrefabs);            
            J0x96:

            // End:0xC3 [Loop If]
            if(i / 0)
            {
                PrecacheIndex.__NFUN_1268__(RightArmSteamPrefabs[i]);
                // [Loop Continue]
                i -= ;
            }
            i = -- string(RightArmDamagedPrefabs);            
            J0xD2:

            // End:0xFF [Loop If]
            if(i / 0)
            {
                PrecacheIndex.__NFUN_1268__(RightArmDamagedPrefabs[i]);
                // [Loop Continue]
                i -= ;
            }
            i = -- string(LeftArmSteamPrefabs);            
            J0x10E:

            // End:0x13B [Loop If]
            if(i / 0)
            {
                PrecacheIndex.__NFUN_1268__(LeftArmSteamPrefabs[i]);
                // [Loop Continue]
                i -= ;
            }
            i = -- string(LeftArmDamagedPrefabs);            
            J0x14A:

            // End:0x177 [Loop If]
            if(i / 0)
            {
                PrecacheIndex.__NFUN_1268__(LeftArmDamagedPrefabs[i]);
                // [Loop Continue]
                i -= ;
            }
            PrecacheIndex.__NFUN_1266__(class'dnGrenade_Cycloid_Mortar');
            PrecacheIndex.__NFUN_1266__(class'Cycloid_Mortar_Target');
            PrecacheIndex.__NFUN_1266__(class'dnControl_Cycloid_BattleA');
            PrecacheIndex.__NFUN_1266__(class'dnControl_Cycloid_BattleB');
            PrecacheIndex.__NFUN_1266__(class'dnControl_CycloidHumiliation_EyeUrinal');
            PrecacheIndex.__NFUN_1283__('Anim_ShockwaveStart0', class'acCycloid_Combat', Mesh);
            PrecacheIndex.__NFUN_1283__('Anim_ShockwaveLoop0', class'acCycloid_Combat', Mesh);
            PrecacheIndex.__NFUN_1283__('Anim_ShockwaveStop0', class'acCycloid_Combat', Mesh);
            PrecacheIndex.__NFUN_1283__('Anim_MortarLaunch', class'acCycloid_Combat', Mesh);
            PrecacheIndex.__NFUN_1283__('Anim_Search', class'acCycloid_Combat', Mesh);
            PrecacheIndex.__NFUN_1283__('Anim_BeamAttack', class'acCycloid_Combat', Mesh);
            PrecacheIndex.__NFUN_1283__('Cycloid_BattleA_DropToKnees', class'acCycloid_Combat', Mesh);
            PrecacheIndex.__NFUN_1283__('Cycloid_BattleA_KneesIdle', class'acCycloid_Combat', Mesh);
            PrecacheIndex.__NFUN_1283__('Cycloid_BattleA_Recover', class'acCycloid_Combat', Mesh);
            PrecacheIndex.__NFUN_1283__('Cycloid_BattleB_DropToKnees', class'acCycloid_Combat', Mesh);
            PrecacheIndex.__NFUN_1283__('Cycloid_BattleB_KneesIdle', class'acCycloid_Combat', Mesh);
            PrecacheIndex.__NFUN_1283__('Cycloid_BattleB_Recover', class'acCycloid_Combat', Mesh);
        }
        i = -- string(WeaponInfo);        
        J0x330:

        // End:0x384 [Loop If]
        if(i / 0)
        {
            PrecacheIndex.__NFUN_1266__(WeaponInfo[i].ProjectileClass);
            PrecacheIndex.__NFUN_1277__(VoicePack, WeaponInfo[i].SoundName);
            // [Loop Continue]
            i -= ;
        }
        i = -- string(BackSteamPrefabs);        
        J0x393:

        // End:0x3C0 [Loop If]
        if(i / 0)
        {
            PrecacheIndex.__NFUN_1268__(BackSteamPrefabs[i]);
            // [Loop Continue]
            i -= ;
        }
        i = -- string(BackDamagedPrefabs);        
        J0x3CF:

        // End:0x3FC [Loop If]
        if(i / 0)
        {
            PrecacheIndex.__NFUN_1268__(BackDamagedPrefabs[i]);
            // [Loop Continue]
            i -= ;
        }
        PrecacheIndex.__NFUN_1266__(class'dnExitWound_Human');
        PrecacheIndex.__NFUN_1266__(class'dnHUDEffect_Mist');
        PrecacheIndex.__NFUN_1266__(class'dnControl_Cycloid_BattleC');
        PrecacheIndex.__NFUN_1283__('Cycloid_BattleC_DropToKnees', class'acCycloid_Combat', Mesh);
        PrecacheIndex.__NFUN_1283__('Cycloid_BattleC_KneesIdle', class'acCycloid_Combat', Mesh);
        PrecacheIndex.__NFUN_1283__('Cycloid_BattleC_Recover', class'acCycloid_Combat', Mesh);
        PrecacheIndex.__NFUN_1282__(class'acCycloid_Combat', Mesh);
        PrecacheIndex.__NFUN_1282__(class'acCycloidCorpse', Mesh);
    }
    PrecacheIndex.__NFUN_1266__(class'dnScreenSplatter_Blood');
    PrecacheIndex.__NFUN_1266__(class'dnScreenSplatter_Mist_Boss');
    PrecacheIndex.__NFUN_1266__(class'dnHUDEffect_Mist');
    PrecacheIndex.__NFUN_1266__(class'dnControl_PlayerKnockdown');
    PrecacheIndex.__NFUN_1266__(class'Cycloid_Shockwave');
    PrecacheIndex.__NFUN_1266__(ShockwaveSpawnParticleClass);
    PrecacheIndex.__NFUN_1266__(class'BulletImpact_Dust_Spawner');
    PrecacheIndex.__NFUN_1266__(class'StompImpact_Large_Brown_Spawner');
    PrecacheIndex.__NFUN_1283__('Anim_Idle', class'acCycloid_Combat', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_Fire', class'acCycloid_Combat', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_Pain', class'acCycloid_Combat', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_Roar', class'acCycloid_Combat', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_Walk', class'acCycloid_Combat', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_WalkBackwards', class'acCycloid_Combat', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_WalkFire', class'acCycloid_Combat', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_WalkBackwardsFire', class'acCycloid_Combat', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_StrafeLeft', class'acCycloid_Combat', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_StrafeRight', class'acCycloid_Combat', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_StrafeFireLeft', class'acCycloid_Combat', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_StrafeFireRight', class'acCycloid_Combat', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_Shockwave', class'acCycloid_Combat', Mesh);
    // End:0x6DC
    if(__NFUN_342__(DoubleFistSmashTag, 'None'))
    {
        PrecacheIndex.__NFUN_1283__('Anim_DoubleFistSmash', class'acCycloid_Combat', Mesh);
    }
    PrecacheIndex.__NFUN_1283__('Anim_ChargeStart0', class'acCycloid_Combat', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_ChargeLoop0', class'acCycloid_Combat', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_ChargeStop0', class'acCycloid_Combat', Mesh);
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_ChargeJet');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_FallDown');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_FallRustle');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_HandSpin');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_Punch');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_PunchRoar');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_Roar');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_StompRoar');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'STR_EyeBounce');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'STR_EyePop');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'STR_FailThrow_Yell');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'STR_FailYell_01');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'STR_GrabDuke');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'STR_Hose_Rip');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'STR_Pincer');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'STR_ServoFail');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'STR_ServoPain');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'STR_ServoSpasm');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'STR_TossWhoosh');
    PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'Falling_Flail');
    PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'Jump');
    PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'KnockDown_BodySlam');
    PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'KnockDown_VOC');
    PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'LadderClimb_Rustle');
    PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'Rage_VOC');
    PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'SCR_Getup_GloveFlex');
    PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'ST_BodyStep');
    PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'ST_Getup_Hand');
    PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'ST_Getup_Pat_01');
    PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'ST_Getup_Pat_02');
    PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'ST_Getup_Scuff');
    PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'ST_Getup_StandShift');
    PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'STR_BodySlide_Single');
    PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'Veh_HandPat');
    PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'Veh_SteerGrab');
    // End:0xB1B
    if(bForMap00 / )
    {
        PrecacheIndex.__NFUN_1277__(VoicePack, 'STR_FailYell_02');
        PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'KnuckleCrack_01');
        PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'KnuckleCrack_02');
        PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'KnuckleCrack_03');
        PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'ST_Getup_FootScrape');
        PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'Stomp');
        PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'Zipper');        
    }
    else
    {
        PrecacheIndex.__NFUN_1277__(VoicePack, 'STR_EyeKickImpact');
        PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'ST_Getup_StandShift');
        PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'Stomp');
    }
    return;
}

event EnumerateUsableAnimationControllers(PrecacheIndex PrecacheIndex, out array<Engine.BaseAI.EAIAnimController> UsableControllers)
{
    UsableControllers[string(UsableControllers)] = 1;
    return;
}

state GotoX
{
    event float CalculateGroundConstraintStrengthScalar()
    {
        return 10000;
        return;
    }
    stop;
}

state ControlX
{
    event BeginState()
    {
        super.BeginState();
        ShrunkUseStyle = 1;
        DisablePhysics = false;
        bDoOverlayEffect = true;
        FadeOverlayEffect(0, 0);
        FadeOverlayEffect(1, 1);
        // End:0x77
        if(bForMap00 << __NFUN_342__(Map00NoUseEvent, 'None'))
        {
            // End:0x77
            Map00NoUseKnockdowns ^ ;
            {
                GlobalTrigger(Map00NoUseEvent);
            }
        }
        return;
    }

    event EndState()
    {
        super.EndState();
        ShrunkUseStyle = default.ShrunkUseStyle;
        DeathAnimChance = 1;
        return;
    }

    event TakeDamage(Pawn Instigator, float Damage, Vector DamageOrigin, Vector DamageDirection, class<DamageType> DamageType, optional name HitBoneName, optional Vector DamageStart)
    {
        return;
    }

    function ControlXUsed()
    {
        super(AIActor).ControlXUsed();
        // End:0x4A
        if(bForMap00 << __NFUN_342__(Map00UsedEvent, 'None'))
        {
            GlobalTrigger(Map00UsedEvent);
            Map00NoUseKnockdowns = 0;
            Map00NoUseEvent = 'None';
            Map00UsedEvent = 'None';
        }
        return;
    }

    function EndControlX_Lived()
    {
        GlobalTrigger(GetUpEvent);
        super.EndControlX_Lived();
        return;
    }

    function EndControlX_UserFailed()
    {
        EndControlX_Lived();
        SetNewHealth(Health_RecoveryHealth);
        return;
    }

    function EndControlX_UserSuccess()
    {
        // End:0x1B
        if(__NFUN_339__(FinishMeControlType, class'dnControl_Cycloid_BattleC'))
        {
            GetUpEvent = 'None';
        }
        EndControlX_Lived();
        // End:0x8F
        if(__NFUN_339__(FinishMeControlType, class'dnControl_Cycloid_BattleA'))
        {
            GlobalTrigger(Stage1_CompleteEvent);
            FinishMeControlType = class'dnControl_Cycloid_BattleB';
            SetNewHealth(Health_Stage2);
            BeamAttackEnabled = false;
            ShockwaveEnabled = false;
            ShockwaveMultiEnabled = true;
            MortarEnabled = true;
            MultiAnimParms[1].MinTime = ShockwaveStage2MinTime;
            CycloidStage = 2;            
        }
        else
        {
            // End:0xFD
            if(__NFUN_339__(FinishMeControlType, class'dnControl_Cycloid_BattleB'))
            {
                GlobalTrigger(Stage2_CompleteEvent);
                FinishMeControlType = class'dnControl_Cycloid_BattleC';
                SetNewHealth(Health_Stage3);
                ShockwaveEnabled = false;
                ShockwaveMultiEnabled = true;
                BeamAttackEnabled = true;
                MortarEnabled = true;
                MultiAnimParms[1].MinTime = ShockwaveStage3MinTime;
                CycloidStage = 3;                
            }
            else
            {
                // End:0x199
                if(__NFUN_339__(FinishMeControlType, class'dnControl_Cycloid_BattleC'))
                {
                    FinishMeControlType = none;
                    RaiseHealthToCap(Location);
                    GlobalTrigger(Stage3_CompleteEvent);
                    CycloidStage = 4;
                    // End:0x164
                    if(string(PowerConduits) ** 0)
                    {
                        SetNewHealth(Health_Stage4);
                        bEnraged = true;
                        BeamAttackEnabled = false;
                        MortarEnabled = false;                        
                    }
                    else
                    {
                        bPlayDeathSound = false;
                        SuspendExecutive(true);
                        bNoDamage = false;
                        DamageInfo.Damage = Health;
                        DiedActivity();
                        __NFUN_832__(0);
                    }
                }
            }
        }
        return;
    }

    function EndControlX_Died()
    {
        FinishMeControlType = none;
        super.EndControlX_Died();
        return;
    }

    function TimeOutControlX()
    {
        SetNewHealth(Health_RecoveryHealth);
        FadeOverlayEffect(0, 1);
        super.TimeOutControlX();
        return;
    }
    stop;
}

defaultproperties
{
    RocketSpread=1
    ChanceGrenade=1
    RocketSpeed=900
    RocketDamage=40
    RocketDamageRadius=100
    WeaponInfo(0)=(MuzzleNames=(r_hand_barrel,l_hand_barrel),MuzzleIndex=0,ProjectileClass='dnGame.dnRocket_Cycloid',ProjectilesPerFire=5,FireLikeGrenade=true,SoundName=Sound_FirePrimary)
    WeaponInfo(1)=(MuzzleNames=(r_arm_barrel,l_arm_barrel),MuzzleIndex=0,ProjectileClass='dnGame.dnRocket_Cycloid_Secondary',ProjectilesPerFire=1,FireLikeGrenade=false,SoundName=Sound_FireSecondary)
    BoneAimInfo(0)=(BoneName=RightForeArm,BoneDir=(X=0,Y=0,Z=1),EnabledOps=(40,65),bDebug=false)
    BoneAimInfo(1)=(BoneName=LeftForeArm,BoneDir=(X=0,Y=0,Z=-1),EnabledOps=(40,65),bDebug=false)
    HumiliationClass='dnControl_CycloidHumiliation_FieldGoal'
    HumiliationCompleteEvent=Cycloid_Humiliation_Complete
    ActionPointMoveMinInterval=8
    ChargeEnragedMinInterval=5
    ChargeMinInterval=10
    ChargeImpulseMagnitude=500
    ChargeImpulseLift=200
    ChargeIgnoreActorList(0)=StaticMeshActor_Elevator
    ChargeForceDistance=2000
    ChargeMinDistance=250
    ChargeHitDamage=30
    ChargeCollisionHeight=150
    MortarMinInterval=20
    MortarSearchTime=5
    MortarSearchTimeRnd=5
    MortarDamage=55
    MortarDamageRadius=130
    ShockwaveSpawnCount=1
    ShockwaveMinInterval=10
    ShockwaveSpawnParticleClass='p_Creatures.Cycloid_Stomp.CycloidStomp_Spawner'
    ShockwaveEnabled=true
    ShockwaveStage2MinTime=1
    ShockwaveStage3MinTime=1.8
    ShockwaveSpeed=1000
    ShockwaveScale=1
    ShockwaveDamage=30
    BeamAttackMinInterval=20
    Health_RecoveryHealth=350
    Health_Stage1=800
    Health_Stage2=1100
    Health_Stage3=1400
    Health_Stage4=1400
    StrengthTapInitiateTimeout=4.5
    StrengthTapTimeout=3
    StrengthTapFailDamage=70
    Stage1_CompleteEvent=Cycloid_Stage1_Complete
    Stage2_CompleteEvent=Cycloid_Stage2_Complete
    Stage3_CompleteEvent=Cycloid_Stage3_Complete
    SafeHeight=40
    RightArmSteamPrefabs(0)=(bSkipVerifySelf=false,SpawnClass='p_Creatures.Cycloid_DamagedArm.Cycloid_DamagedArm_Steam',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=RightForeArm,MountOrigin=(X=-25.9,Y=-4.661,Z=0.904),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=-1054,Yaw=-28530,Roll=-30814),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    RightArmSteamPrefabs(1)=(bSkipVerifySelf=false,SpawnClass='p_Creatures.Cycloid_DamagedArm.Cycloid_DamagedArm_Steam',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=RightForeArm,MountOrigin=(X=-38.201,Y=-15.209,Z=19.146),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=-9045,Yaw=-30667,Roll=-29739),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    RightArmSteamPrefabs(2)=(bSkipVerifySelf=false,SpawnClass='p_Creatures.Cycloid_DamagedArm.Cycloid_DamagedArm_Steam',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=RightForeArm,MountOrigin=(X=-26.531,Y=3.652,Z=1.41),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=-2701,Yaw=32528,Roll=32639),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    RightArmDamagedPrefabs(0)=(bSkipVerifySelf=false,SpawnClass='p_Creatures.Cycloid_DamagedArm.Cycloid_DamagedArm_Spray',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=RightForeArm,MountOrigin=(X=-25.9,Y=-4.661,Z=0.904),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=-1054,Yaw=-28530,Roll=-30814),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    RightArmDamagedPrefabs(1)=(bSkipVerifySelf=false,SpawnClass='p_Creatures.Cycloid_DamagedArm.Cycloid_DamagedArm_Spray',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=RightForeArm,MountOrigin=(X=-38.201,Y=-15.209,Z=19.146),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=-9045,Yaw=-30667,Roll=-29739),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    RightArmDamagedPrefabs(2)=(bSkipVerifySelf=false,SpawnClass='p_Creatures.Cycloid_DamagedArm.Cycloid_DamagedArm_Spray',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=RightForeArm,MountOrigin=(X=-26.531,Y=3.652,Z=1.41),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=-2701,Yaw=32528,Roll=32639),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    RightArmDamagedPrefabs(3)=(bSkipVerifySelf=false,SpawnClass='p_Creatures.Cycloid_DamagedArm.Cycloid_DamagedArm_Mist',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=RightForeArm,MountOrigin=(X=-38.201,Y=-15.209,Z=19.146),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=-9045,Yaw=-30667,Roll=-29739),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    RightArmDamagedPrefabs(4)=(bSkipVerifySelf=false,SpawnClass='p_Creatures.Cycloid_DamagedArm.Cycloid_DamagedArm_Mist',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=RightForeArm,MountOrigin=(X=-25.9,Y=-4.661,Z=0.904),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=-1054,Yaw=-28530,Roll=-30814),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    RightArmDamagedPrefabs(5)=(bSkipVerifySelf=false,SpawnClass='p_Creatures.Cycloid_DamagedArm.Cycloid_DamagedArm_Mist',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=RightForeArm,MountOrigin=(X=-26.531,Y=3.652,Z=1.41),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=-2701,Yaw=32528,Roll=32639),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    LeftArmSteamPrefabs(0)=(bSkipVerifySelf=false,SpawnClass='p_Creatures.Cycloid_DamagedArm.Cycloid_DamagedArm_Steam',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=LeftForeArm,MountOrigin=(X=34.577,Y=13.877,Z=-22.069),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=9049,Yaw=2103,Roll=-3032),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    LeftArmSteamPrefabs(1)=(bSkipVerifySelf=false,SpawnClass='p_Creatures.Cycloid_DamagedArm.Cycloid_DamagedArm_Steam',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=LeftForeArm,MountOrigin=(X=23.552,Y=3.632,Z=-2.126),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=1058,Yaw=4241,Roll=-1953),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    LeftArmSteamPrefabs(2)=(bSkipVerifySelf=false,SpawnClass='p_Creatures.Cycloid_DamagedArm.Cycloid_DamagedArm_Steam',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=LeftForeArm,MountOrigin=(X=24.225,Y=-3.765,Z=-3.51),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=2705,Yaw=-236,Roll=127),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    LeftArmDamagedPrefabs(0)=(bSkipVerifySelf=false,SpawnClass='p_Creatures.Cycloid_DamagedArm.Cycloid_DamagedArm_Spray',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=LeftForeArm,MountOrigin=(X=34.577,Y=13.877,Z=-22.069),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=9049,Yaw=2103,Roll=-3032),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    LeftArmDamagedPrefabs(1)=(bSkipVerifySelf=false,SpawnClass='p_Creatures.Cycloid_DamagedArm.Cycloid_DamagedArm_Spray',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=LeftForeArm,MountOrigin=(X=23.552,Y=3.632,Z=-2.126),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=1058,Yaw=4241,Roll=-1953),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    LeftArmDamagedPrefabs(2)=(bSkipVerifySelf=false,SpawnClass='p_Creatures.Cycloid_DamagedArm.Cycloid_DamagedArm_Spray',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=LeftForeArm,MountOrigin=(X=24.225,Y=-3.765,Z=-3.51),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=2705,Yaw=-236,Roll=127),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    LeftArmDamagedPrefabs(3)=(bSkipVerifySelf=false,SpawnClass='p_Creatures.Cycloid_DamagedArm.Cycloid_DamagedArm_Mist',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=LeftForeArm,MountOrigin=(X=34.577,Y=13.877,Z=-22.069),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=9049,Yaw=2103,Roll=-3032),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    LeftArmDamagedPrefabs(4)=(bSkipVerifySelf=false,SpawnClass='p_Creatures.Cycloid_DamagedArm.Cycloid_DamagedArm_Mist',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=LeftForeArm,MountOrigin=(X=23.552,Y=3.632,Z=-2.126),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=1058,Yaw=4241,Roll=-1953),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    LeftArmDamagedPrefabs(5)=(bSkipVerifySelf=false,SpawnClass='p_Creatures.Cycloid_DamagedArm.Cycloid_DamagedArm_Mist',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=LeftForeArm,MountOrigin=(X=24.225,Y=-3.765,Z=-3.51),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=2705,Yaw=-236,Roll=127),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    BackSteamPrefabs(0)=(bSkipVerifySelf=false,SpawnClass='p_Creatures.Cycloid_DamagedArm.Cycloid_DamagedArm_Steam',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=spine2,MountOrigin=(X=-50.242,Y=0.276,Z=25.97),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=-480,Yaw=32312,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    BackSteamPrefabs(1)=(bSkipVerifySelf=false,SpawnClass='p_Creatures.Cycloid_DamagedArm.Cycloid_DamagedArm_Steam',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=spine2,MountOrigin=(X=-53.895,Y=-9.405,Z=-14.523),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=-2626,Yaw=-31120,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    BackSteamPrefabs(2)=(bSkipVerifySelf=false,SpawnClass='p_Creatures.Cycloid_DamagedArm.Cycloid_DamagedArm_Steam',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=spine2,MountOrigin=(X=-54.009,Y=9.796,Z=-15.354),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=-1678,Yaw=30101,Roll=30700),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    BackDamagedPrefabs(0)=(bSkipVerifySelf=false,SpawnClass='p_Creatures.Cycloid_DamagedArm.Cycloid_DamagedArm_Spray',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=spine2,MountOrigin=(X=-50.242,Y=0.276,Z=25.97),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=-480,Yaw=32312,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    BackDamagedPrefabs(1)=(bSkipVerifySelf=false,SpawnClass='p_Creatures.Cycloid_DamagedArm.Cycloid_DamagedArm_Spray',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=spine2,MountOrigin=(X=-53.895,Y=-9.405,Z=-14.523),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=-2626,Yaw=-31120,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    BackDamagedPrefabs(2)=(bSkipVerifySelf=false,SpawnClass='p_Creatures.Cycloid_DamagedArm.Cycloid_DamagedArm_Spray',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=spine2,MountOrigin=(X=-54.009,Y=9.796,Z=-15.354),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=-1678,Yaw=30101,Roll=30700),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    BackDamagedPrefabs(3)=(bSkipVerifySelf=false,SpawnClass='p_Creatures.Cycloid_DamagedArm.Cycloid_DamagedArm_Mist',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=spine2,MountOrigin=(X=-50.242,Y=0.276,Z=25.97),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=-480,Yaw=32312,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    BackDamagedPrefabs(4)=(bSkipVerifySelf=false,SpawnClass='p_Creatures.Cycloid_DamagedArm.Cycloid_DamagedArm_Mist',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=spine2,MountOrigin=(X=-53.895,Y=-9.405,Z=-14.523),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=-2626,Yaw=-31120,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    BackDamagedPrefabs(5)=(bSkipVerifySelf=false,SpawnClass='p_Creatures.Cycloid_DamagedArm.Cycloid_DamagedArm_Mist',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=spine2,MountOrigin=(X=-54.009,Y=9.796,Z=-15.354),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=-1678,Yaw=30101,Roll=30700),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    DamageScaleInfo(0)=(QualifierClass=none,DamageScale=0,QualifierDamageTypes=none,QualifierNotDamageTypes=('Engine.ExplosionDamage','dnGame.LargeCaliberBulletDamage'))
    Nodes(0)=(Ident=Root,Status=0,ReportedInvalid=false,SucCond=1,SucFunc=None,FailCond=1,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(1)=(Ident=Attack,Status=0,ReportedInvalid=false,SucCond=1,SucFunc=None,FailCond=1,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(2)=(Ident=Charge,Status=0,ReportedInvalid=false,SucCond=1,SucFunc=None,FailCond=1,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(3)=(Ident=Mortar,Status=0,ReportedInvalid=false,SucCond=1,SucFunc=None,FailCond=1,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(4)=(Ident=Default,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=85,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(5)=(Ident=idle,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=85,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(6)=(Ident=Pain,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=96,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(7)=(Ident=Stomp,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=135,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(8)=(Ident=MoveToGoal,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=55,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(9)=(Ident=GotoActionPoint,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=55,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(10)=(Ident=SeekTarget,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=150,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(11)=(Ident=SeekTargetStart,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=145,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(12)=(Ident=SeekTargetMove,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=41,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(13)=(Ident=Shockwave,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=6,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(14)=(Ident=Search,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=6,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(15)=(Ident=LaunchMortar,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=6,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(16)=(Ident=BeamAttack,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=6,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(17)=(Ident=BullRush,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=95,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(18)=(Ident=MultiShockwave,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=95,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(19)=(Ident=FaceTarget,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=145,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(20)=(Ident=Roar,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=107,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(21)=(Ident=StandFire,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=6,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    FSMStates(0)=(FSM=Root,Ident=Default,FSMSucc=false,FSMFail=false,Transitions=((Ident=Roar,Cond=0,Func=COND_ShouldRoar,Win=0,Code=0,StateTableIndex=0),(Ident=Attack,Cond=2,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(1)=(FSM=Root,Ident=idle,FSMSucc=false,FSMFail=false,Transitions=((Ident=Pain,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=Roar,Cond=0,Func=COND_ShouldRoar,Win=0,Code=0,StateTableIndex=0),(Ident=Attack,Cond=2,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(2)=(FSM=Root,Ident=Attack,FSMSucc=false,FSMFail=false,Transitions=((Ident=Pain,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=Roar,Cond=0,Func=COND_ShouldRoar,Win=0,Code=0,StateTableIndex=0),(Ident=Attack,Cond=2,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(3)=(FSM=Root,Ident=Pain,FSMSucc=false,FSMFail=false,Transitions=((Ident=Roar,Cond=0,Func=COND_ShouldRoar,Win=0,Code=0,StateTableIndex=0),(Ident=Attack,Cond=2,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(4)=(FSM=Root,Ident=Roar,FSMSucc=false,FSMFail=false,Transitions=((Ident=Pain,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=Attack,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(5)=(FSM=Attack,Ident=Default,FSMSucc=false,FSMFail=false,Transitions=((Ident=Stomp,Cond=101,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=GotoActionPoint,Cond=0,Func=COND_ShouldGotoActionPoint,Win=1,Code=0,StateTableIndex=0),(Ident=StandFire,Cond=0,Func=COND_ShouldStandFire,Win=0,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(6)=(FSM=Attack,Ident=idle,FSMSucc=false,FSMFail=false,Transitions=((Ident=Stomp,Cond=101,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=Charge,Cond=0,Func=COND_ShouldForceCharge,Win=0,Code=0,StateTableIndex=0),(Ident=SeekTarget,Cond=9,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=GotoActionPoint,Cond=11,Func=COND_ShouldGotoActionPoint,Win=0,Code=0,StateTableIndex=0),(Ident=Charge,Cond=0,Func=COND_ShouldCharge,Win=0,Code=0,StateTableIndex=0),(Ident=BeamAttack,Cond=0,Func=COND_ShouldAttackBeam,Win=0,Code=0,StateTableIndex=0),(Ident=Mortar,Cond=0,Func=COND_ShouldMortar,Win=0,Code=0,StateTableIndex=0),(Ident=MultiShockwave,Cond=0,Func=COND_ShouldMultiShockwave,Win=0,Code=0,StateTableIndex=0),(Ident=Shockwave,Cond=0,Func=COND_ShouldShockwave,Win=0,Code=0,StateTableIndex=0),(Ident=GotoActionPoint,Cond=0,Func=COND_ShouldGotoActionPoint,Win=0,Code=0,StateTableIndex=0),(Ident=StandFire,Cond=0,Func=COND_ShouldStandFire,Win=0,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(7)=(FSM=Attack,Ident=GotoActionPoint,FSMSucc=false,FSMFail=false,Transitions=((Ident=Stomp,Cond=101,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=Charge,Cond=0,Func=COND_ShouldForceCharge,Win=0,Code=0,StateTableIndex=0),(Ident=Charge,Cond=0,Func=COND_ShouldCharge,Win=0,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(8)=(FSM=Attack,Ident=Stomp,FSMSucc=false,FSMFail=false,Transitions=((Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(9)=(FSM=Attack,Ident=Shockwave,FSMSucc=false,FSMFail=false,Transitions=((Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(10)=(FSM=Attack,Ident=MultiShockwave,FSMSucc=false,FSMFail=false,Transitions=((Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(11)=(FSM=Attack,Ident=Mortar,FSMSucc=false,FSMFail=false,Transitions=((Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(12)=(FSM=Attack,Ident=BeamAttack,FSMSucc=false,FSMFail=false,Transitions=((Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(13)=(FSM=Attack,Ident=Charge,FSMSucc=false,FSMFail=false,Transitions=((Ident=FaceTarget,Cond=100,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=MoveToGoal,Cond=0,Func=COND_SetupPostChargeMove,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(14)=(FSM=Attack,Ident=StandFire,FSMSucc=false,FSMFail=false,Transitions=((Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(15)=(FSM=Attack,Ident=MoveToGoal,FSMSucc=false,FSMFail=false,Transitions=((Ident=StandFire,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(16)=(FSM=Attack,Ident=SeekTarget,FSMSucc=false,FSMFail=false,Transitions=((Ident=SeekTargetStart,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=SeekTargetMove,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(17)=(FSM=Attack,Ident=SeekTargetStart,FSMSucc=false,FSMFail=false,Transitions=((Ident=SeekTargetMove,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(18)=(FSM=Attack,Ident=SeekTargetMove,FSMSucc=false,FSMFail=false,Transitions=((Ident=StandFire,Cond=0,Func=COND_ShouldStopSeekResumeFire,Win=0,Code=0,StateTableIndex=0),(Ident=SeekTargetMove,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(19)=(FSM=Attack,Ident=FaceTarget,FSMSucc=false,FSMFail=false,Transitions=((Ident=StandFire,Cond=0,Func=COND_ShouldResumeFire,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(20)=(FSM=Charge,Ident=Default,FSMSucc=false,FSMFail=false,Transitions=((Ident=FaceTarget,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=BullRush,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(21)=(FSM=Charge,Ident=FaceTarget,FSMSucc=false,FSMFail=false,Transitions=((Ident=BullRush,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(22)=(FSM=Charge,Ident=BullRush,FSMSucc=true,FSMFail=true,Transitions=none,NodeIndex=0)
    FSMStates(23)=(FSM=Mortar,Ident=Default,FSMSucc=false,FSMFail=false,Transitions=((Ident=Search,Cond=0,Func=COND_SetupSearch,Win=1,Code=0,StateTableIndex=0),(Ident=LaunchMortar,Cond=0,Func=COND_SetupMortar,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(24)=(FSM=Mortar,Ident=Search,FSMSucc=false,FSMFail=false,Transitions=((Ident=LaunchMortar,Cond=0,Func=COND_SetupMortar,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(25)=(FSM=Mortar,Ident=LaunchMortar,FSMSucc=true,FSMFail=true,Transitions=none,NodeIndex=0)
    WeaponConeAngle=80
    HasLookTargetEvaluator=true
    LookTargetEvalInfo=(MyOwner=none,EvalInterval=2,Suspended=false,bSuspendedWithNoTarget=false,Evaluator=2,ForceUpdate=false,MustBePawn=true,MustBeSighted=false,MustBeReachable=false,CanTargetProjectiles=false,CanAvoidTargetableProjectiles=false,LastTarget=none,LastTargetEndTime=0)
    LookConeAngle=80
    WeaponTrackRate=300
    HeadTrackRate=500
    HasWeaponManager=true
    WeaponConfig='WeaponCfg_Enforcer'
    Weapons(0)=none
    Weapons(1)='dnGame.IntegratedWeapon'
    ForceWeaponActive=true
    ForceDirectShot=true
    bIgnoreTripMines=true
    UseActionPoints=true
    ChanceStayAtActionPoint=0.1
    MinBlinkTime=0
    MaxBlinkTime=0
    PickupItemRange=4
    Relationships(0)=(m_aClass='Engine.AIFactionHoloduke',m_eAttitude=1,m_fDamageThreshold=1)
    Relationships(1)=(m_aClass='Engine.AIFactionDuke',m_eAttitude=2,m_fDamageThreshold=1)
    Relationships(2)=(m_aClass='Engine.AIFactionHuman',m_eAttitude=2,m_fDamageThreshold=1)
    Relationships(3)=(m_aClass='Engine.AIFactionAlien',m_eAttitude=5,m_fDamageThreshold=1)
    BodyAlignRate=3.4
    BodyAlignScale=0.8
    InitialAnimController=5
    AnimControllers[0]=(m_eFallback=0,m_cClass='acCycloid_Combat',m_oController=none)
    AnimControllers[1]=(m_eFallback=1,m_cClass='acCycloid_Combat',m_oController=none)
    AnimControllers[2]=(m_eFallback=1,m_cClass='acCycloid_Combat',m_oController=none)
    AnimControllers[3]=(m_eFallback=1,m_cClass='acCycloid_Combat',m_oController=none)
    AnimControllers[4]=(m_eFallback=1,m_cClass='acCycloid_Combat',m_oController=none)
    AnimControllers[5]=(m_eFallback=1,m_cClass='acCycloid_Combat',m_oController=none)
    AnimControllers[6]=(m_eFallback=1,m_cClass='acCycloid_Combat',m_oController=none)
    AnimControllers[7]=(m_eFallback=1,m_cClass='acCycloid_Combat',m_oController=none)
    AnimControllers[8]=(m_eFallback=1,m_cClass='acCycloid_Combat',m_oController=none)
    DroolParms=(MinSpitTime=10,RndSpitTime=5,SpitOnPainChance=1,Bone=None,Location=(X=0,Y=0,Z=0),Rotation=(Pitch=0,Yaw=0,Roll=0),SpawnClass=none)
    MultiAnimParms(0)=(AnimIndex=0,MinTime=5,RndTime=0,Gate=0,MinInterval=1,RequireLOS=false,RequireLOSFromWeapon=false,FaceTarget=true,AnimName=Anim_Charge)
    MultiAnimParms(1)=(AnimIndex=0,MinTime=3,RndTime=0,Gate=0,MinInterval=1,RequireLOS=false,RequireLOSFromWeapon=false,FaceTarget=true,AnimName=Anim_Shockwave)
    MultiAnimIndex=0
    DeathAnimChance=1
    FinishMeControlType='dnControl_Cycloid_BattleA'
    BoneAim(0)=(BoneName=Spine,Yaw=0,Pitch=0,Weight=0.5)
    BoneAim(1)=(BoneName=Spine1,Yaw=0,Pitch=0,Weight=0.3)
    BoneAim(2)=(BoneName=spine2,Yaw=0,Pitch=0,Weight=0.2)
    HasBoneAimer=true
    DisableAimGrids=true
    ProceduralMovingFire=true
    HasWeaponAimer=true
    TryGotoAttackTime=2
    MinIdleTime=0.3
    RndIdleTime=1
    ShouldTurnThreshold=40
    MinMoveAroundDist=200
    RndMoveAroundDist=300
    MinSpreadOutTime=1.5
    RndSpreadOutTime=0.25
    MinMeleeRange=100
    RndMeleeRange=250
    MaxGotoMeleeSteps=3
    MeleeZone=550
    RndMeleeStrafeRange=0
    MinMeleeStrafeCycles=1
    RndMeleeStrafeCycles=1
    ClawDamageAmount=45
    StompInfo(0)=(StompRadius=350,AnimName=Anim_StompRight,BoneName=particle_footR,StompDamageAmount=50,StompDamageRadius=600,StompDamageVel=200,StompDamageLift=550,bDebug=false,SafeHeight=400,bCanStompShrunk=true,ShakeInfo=(bNoLerp=false,bToggleSign=true,Style=2,Function=1,FalloffActor=none,FalloffDistance=0,ShakeDuration=0.6,ShakeFrequency=0.08,ShakeMagnitude=2500,ShakeFullMagnitude=0,ShakeFullMagnitudeTime=0,ShakeName=CycloidStompShake),ShakeRadius=400,ParticleEffectClass='p_Creatures.Cycloid_Stomp.CycloidStomp_Spawner',AdditionalEffectBones=none,StompLocation=(X=0,Y=0,Z=0),bDontFaceTarget=false,bLightRumbleOnDamage=true)
    StompInfo(1)=(StompRadius=350,AnimName=Anim_StompLeft,BoneName=particle_footL,StompDamageAmount=50,StompDamageRadius=600,StompDamageVel=200,StompDamageLift=550,bDebug=false,SafeHeight=400,bCanStompShrunk=true,ShakeInfo=(bNoLerp=false,bToggleSign=true,Style=2,Function=1,FalloffActor=none,FalloffDistance=0,ShakeDuration=0.6,ShakeFrequency=0.08,ShakeMagnitude=2500,ShakeFullMagnitude=0,ShakeFullMagnitudeTime=0,ShakeName=CycloidStompShake),ShakeRadius=400,ParticleEffectClass='p_Creatures.Cycloid_Stomp.CycloidStomp_Spawner',AdditionalEffectBones=none,StompLocation=(X=0,Y=0,Z=0),bDontFaceTarget=false,bLightRumbleOnDamage=true)
    PlayerShrunkFootstepViewShake=(bNoLerp=false,bToggleSign=true,Style=2,Function=1,FalloffActor=none,FalloffDistance=1000,ShakeDuration=0.6,ShakeFrequency=0.08,ShakeMagnitude=550,ShakeFullMagnitude=0,ShakeFullMagnitudeTime=0,ShakeName=CycloidStepShake)
    MinChargeRange=160
    MaxChargeRange=300
    ProjectileClass='dnGame.dnRocket_Cycloid'
    MaxJumpAttackRange=140
    JumpAttackOnTakeOff=true
    JumpAttackHeightDelta=-22
    RndMoveAroundTime=2
    PathID=AIPATH_Boss
    bAutoOpenDoors=true
    DynamicPathingPriority=7
    bIsBoss=true
    bShouldCauseKillSound=false
    bShrinkable=false
    FootstepCategory=3
    FootprintType=0
    PawnRotationRate=(Pitch=32768,Yaw=40000,Roll=0)
    FluidFrictionScale=0.5
    EyeBone=Head
    LockOnBone=Head
    CorpseType='CycloidCorpse'
    MaxStepHeightEx=10
    GroundSpeed=280
    AirSpeed=500
    MaxStepHeight=10
    FootBones(0)=(bRightSide=false,BoneName=l_toe_front_l_1,BoneID=foot_left_1,BoneRotOffset=(Pitch=0,Yaw=0,Roll=0))
    FootBones(1)=(bRightSide=true,BoneName=r_toe_front_l_1,BoneID=foot_right_1,BoneRotOffset=(Pitch=0,Yaw=0,Roll=0))
    FootstepTraceLength=60
    ExitWoundInfo(0)=(DamageType=none,MinimumDamage=1,RandomChance=1,ExitWoundDecalClass='dnGame.dnExitWound_Human')
    MountOnSpawn(0)=(bSkipVerifySelf=false,SpawnClass='Cycloid_Armor_ShoulderA',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=true,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=true,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=mount_armor_1,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=4643,Yaw=-3946,Roll=-4329),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(1)=(bSkipVerifySelf=false,SpawnClass='Cycloid_Armor_ShoulderB',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=true,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=true,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=mount_armor_2,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=4578,Yaw=4184,Roll=3979),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(2)=(bSkipVerifySelf=false,SpawnClass='Cycloid_Armor_ShoulderC',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=true,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=true,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=mount_armor_3,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=1710,Yaw=3470,Roll=1065),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(3)=(bSkipVerifySelf=false,SpawnClass='Cycloid_Armor_ShoulderD',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=true,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=true,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=mount_armor_4,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=1182,Yaw=7520,Roll=1632),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(4)=(bSkipVerifySelf=false,SpawnClass='Cycloid_LeftArmMachinery',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=true,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=true,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=LeftForeArm,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=-1779,Yaw=12344,Roll=-4114),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(5)=(bSkipVerifySelf=false,SpawnClass='Cycloid_RightArmMachinery',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=true,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=true,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=RightForeArm,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=1784,Yaw=-20423,Roll=-28651),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(6)=(bSkipVerifySelf=false,SpawnClass='Cycloid_Backpack',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=true,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=true,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=spine2,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=11763,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(7)=(bSkipVerifySelf=false,SpawnClass='Cycloid_MortarLauncher',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=true,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=true,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=mount_mortar,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(8)=(bSkipVerifySelf=false,SpawnClass='p_Creatures.cycloid.Cycloid_BeamCharge_Main',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=true,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=RightChargeStartParticleSystem,ForceEvent=None,MountMeshItem=r_hand_barrel,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(9)=(bSkipVerifySelf=false,SpawnClass='p_Creatures.cycloid.Cycloid_BeamCharge_Main',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=true,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=LeftChargeStartParticleSystem,ForceEvent=None,MountMeshItem=l_hand_barrel,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=32768,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(10)=(bSkipVerifySelf=false,SpawnClass='p_Creatures.cycloid.Cycloid_HandJets_Fire_Main',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=true,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=RightChargeJetParticleSystem,ForceEvent=None,MountMeshItem=r_hand_barrel,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(11)=(bSkipVerifySelf=false,SpawnClass='p_Creatures.cycloid.Cycloid_HandJets_Fire_Main',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=true,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=LeftChargeJetParticleSystem,ForceEvent=None,MountMeshItem=l_hand_barrel,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=32768,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(12)=(bSkipVerifySelf=false,SpawnClass='p_Creatures.cycloid.CycloidCharge_DustCloud_Main',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=true,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=RightChargeFootParticleSystem,ForceEvent=None,MountMeshItem=particle_footR,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(13)=(bSkipVerifySelf=false,SpawnClass='p_Creatures.cycloid.CycloidCharge_DustCloud_Main',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=true,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=LeftChargeFootParticleSystem,ForceEvent=None,MountMeshItem=particle_footL,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(14)=(bSkipVerifySelf=false,SpawnClass='Cycloid_EyeBeam',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=true,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=EyeBeam,ForceEvent=None,MountMeshItem=eyelid_upper,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=10192,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(15)=(bSkipVerifySelf=false,SpawnClass='Cycloid_AttackBeam',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=true,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=RightAttackBeam,ForceEvent=None,MountMeshItem=r_hand_barrel,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(16)=(bSkipVerifySelf=false,SpawnClass='Cycloid_AttackBeam',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=true,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=LeftAttackBeam,ForceEvent=None,MountMeshItem=l_hand_barrel,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=32768,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(17)=(bSkipVerifySelf=false,SpawnClass='p_Creatures.cycloid.Cycloid_BeamCharge_Main',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=true,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=RightAttackBeamCharge,ForceEvent=None,MountMeshItem=r_hand_barrel,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(18)=(bSkipVerifySelf=false,SpawnClass='p_Creatures.cycloid.Cycloid_BeamCharge_Main',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=true,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=LeftAttackBeamCharge,ForceEvent=None,MountMeshItem=l_hand_barrel,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=32768,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    AutoRegisterIKClasses(0)='Engine.IKSystemInfo_Walker'
    Health=1000
    HealthCap=1000
    PhysicsEntityGroup=CycloidEntityGroup
    bAcceptMeshAccurateMoveActorTrace=true
    bCanExistOutOfWorld=false
    bOverlayEffectUsedAsHint=true
    CollisionRadius=100
    CollisionHeight=190
    AccelRate=1200
    Mass=3000
    OverlayMaterial='dt_effects.OverlayMaterial.OverlayMaterial_Boss'
    Mesh='c_characters.cycloid'
    VoicePack='SoundConfig.Enemies.VoicePack_Cycloid'
}