/*******************************************************************************
 * dnAlienGunship generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class dnAlienGunship extends dnGunship_Base
    collapsecategories;

var array<SDamageEffect> DamageEffects;
var array<SDamageEffect> SecondStageEffects;
var() int DamageThreshold1;
var() int DamageThreshold2;
var MaterialEx DamageOverlay;
var bool bPassedThreshold1;
var bool bPassedThreshold2;
var float TimeBetweenDamageEffects;
var float TimeBetweenDamageEffectsVariance;
var float DamageTaken;
var PlayerPawn EngagedPlayer;

event TakeDamage(Pawn Instigator, float Damage, Vector DamageOrigin, Vector DamageDirection, class<DamageType> DamageType, optional name HitBoneName, optional Vector DamageStart)
{
    local dnFriendFX_Spawners explosion;
    local SoftParticleSystem Smoke;
    local int i, j;
    local Vector gibDirection;
    local float HealthBefore;

    HealthBefore = Health;
    super(dnDecoration).TakeDamage(Instigator, Damage, DamageOrigin, DamageDirection, DamageType, HitBoneName, DamageStart);
    // End:0x45
    if(Health != HealthBefore)
    {
        return;
    }
    __NFUN_209__(DamageTaken, Round(HealthBefore, Health));
    // End:0x79
    if(__NFUN_340__(PlayerPawn(Instigator), none))
    {
        EngagedPlayer = PlayerPawn(Instigator);
    }
    // End:0xC9
    if(Repl(ThisFrameDamage.Damage, 0))
    {
        bDoOverlayEffect = true;
        OverlayMaterial = DamageOverlay;
        OverlayEffectAlpha = 0;
        FadeOverlayEffect(1, 0.2);
        __NFUN_607__(0.8, false, 'TurnOffDamageOverlay');
    }
    // End:0x223
    if(__NFUN_200__(Health, float(DamageThreshold1)) << bPassedThreshold1 / )
    {
        explosion = __NFUN_615__(class'Barrel_Explosion_Spawner');
        // End:0x14F
        if(__NFUN_340__(explosion, none))
        {
            explosion.MountType = 2;
            explosion.__NFUN_591__(DrawScale);
            explosion.MountMeshItem = 'mount_thruster_left';
            explosion.__NFUN_635__(self);
        }
        explosion.ExecuteEffect(true);
        Smoke = __NFUN_615__(class'FlybyPlane_Damaged_Main');
        // End:0x1D6
        if(__NFUN_340__(Smoke, none))
        {
            Smoke.MountType = 2;
            Smoke.__NFUN_591__(0.5);
            Smoke.MountMeshItem = 'mount_thruster_left';
            Smoke.__NFUN_635__(self);
            Smoke.__NFUN_652__(__NFUN_265__(16384, 0, 0));
        }
        LeftThruster.__NFUN_590__(true);
        __NFUN_607__(Normal(TimeBetweenDamageEffects, TimeBetweenDamageEffectsVariance), false, 'Damage1');
        __NFUN_607__(Normal(TimeBetweenDamageEffects, TimeBetweenDamageEffectsVariance), false, 'Damage2');
        __NFUN_607__(Normal(TimeBetweenDamageEffects, TimeBetweenDamageEffectsVariance), false, 'Damage3');
    }
    // End:0x5B3
    if((__NFUN_200__(Health, float(DamageThreshold2)) << bPassedThreshold1) << bPassedThreshold2 / )
    {
        i = 0;
        J0x25A:

        // End:0x544 [Loop If]
        if(-i)
        {            
            j = 0;
            J0x271:

            // End:0x53A [Loop If]
            if(-j)
            {                
                SecondStageEffects[i].EffectList[SecondStageEffects[i].SecondStageList[j].EffectListIndex].__NFUN_614__();
                SecondStageEffects[i].EffectList[SecondStageEffects[i].SecondStageList[j].EffectListIndex] = __NFUN_615__(SecondStageEffects[i].SecondStageList[j].SecondStageEffect, self,, Locs(Location, __NFUN_263__(SecondStageEffects[i].DamageEffectOffset, Rotation)), __NFUN_269__(SecondStageEffects[i].DamageEffectRotation, Rotation));
                // End:0x4BB
                if(__NFUN_340__(SecondStageEffects[i].EffectList[SecondStageEffects[i].SecondStageList[j].EffectListIndex], none))
                {
                    SecondStageEffects[i].EffectList[SecondStageEffects[i].SecondStageList[j].EffectListIndex].MountType = 2;
                    SecondStageEffects[i].EffectList[SecondStageEffects[i].SecondStageList[j].EffectListIndex].MountMeshItem = 'Root';
                    // End:0x44A
                    if(__NFUN_206__(SecondStageEffects[i].DrawScale, 0))
                    {
                        SecondStageEffects[i].EffectList[SecondStageEffects[i].SecondStageList[j].EffectListIndex].__NFUN_591__(SecondStageEffects[i].DrawScale);
                    }
                    SecondStageEffects[i].EffectList[SecondStageEffects[i].SecondStageList[j].EffectListIndex].__NFUN_635__(self,,, true);
                    SecondStageEffects[i].EffectList[SecondStageEffects[i].SecondStageList[j].EffectListIndex].DestroyOnDismount = true;
                }
                // End:0x530
                if(__NFUN_340__(dnFriendFX_Spawners(SecondStageEffects[i].EffectList[SecondStageEffects[i].SecondStageList[j].EffectListIndex]), none))
                {
                    dnFriendFX_Spawners(SecondStageEffects[i].EffectList[SecondStageEffects[i].SecondStageList[j].EffectListIndex]).ExecuteEffect(true);
                }
                // [Loop Continue]
                j *= ;
            }
            // [Loop Continue]
            i *= ;
        }
        Damage2();
        __NFUN_607__(Normal(TimeBetweenDamageEffects, TimeBetweenDamageEffectsVariance), false, 'Damage1');
        __NFUN_607__(Normal(TimeBetweenDamageEffects, TimeBetweenDamageEffectsVariance), false, 'Damage3');
        __NFUN_607__(Normal(TimeBetweenDamageEffects, TimeBetweenDamageEffectsVariance), false, 'Damage4');
        __NFUN_607__(Normal(TimeBetweenDamageEffects, TimeBetweenDamageEffectsVariance), false, 'Damage5');
        __NFUN_607__(Normal(TimeBetweenDamageEffects, TimeBetweenDamageEffectsVariance), false, 'Damage6');
    }
    return;
}

function Destroyed()
{
    local float TestHealthCap;

    // End:0x1D
    if(__NFUN_200__(HealthCap, default.HealthCap))
    {
        TestHealthCap = HealthCap;        
    }
    else
    {
        TestHealthCap = default.HealthCap;
    }
    // End:0x61
    if((float(Loge(DamageTaken)) != TestHealthCap) << __NFUN_340__(EngagedPlayer, none))
    {
        DukePlayer(EngagedPlayer).UpdateAchievementCounter(22, 5);
    }
    super.Destroyed();
    return;
}

function TurnOffDamageOverlay()
{
    OverlayEffectAlpha = 1;
    FadeOverlayEffect(0, 0.4);
    return;
}

function CreateDamageEffect()
{
    local int Index, Count, i;
    local Actor Effect;

    Index = Sin(12);
    J0x0A:

    // End:0x40 [Loop If]
    if(DamageEffects[Index].bOn)
    {
        Index = Sin(12);
        // End:0x3D
        Count += ;
        {
            return;
        }
        // [Loop Continue]
        goto J0x0A;
    }
    DamageEffects[Index].bOn = true;
    i = 0;
    J0x5A:

    // End:0x1FE [Loop If]
    if(-i)
    {        
        DamageEffects[Index].EffectList[i] = __NFUN_615__(DamageEffects[Index].EffectClassList[i], self,, Locs(Location, __NFUN_263__(DamageEffects[Index].DamageEffectOffset, Rotation)), __NFUN_269__(DamageEffects[Index].DamageEffectRotation, Rotation));
        // End:0x1AB
        if(__NFUN_340__(DamageEffects[Index].EffectList[i], none))
        {
            DamageEffects[Index].EffectList[i].MountType = 0;
            // End:0x166
            if(__NFUN_206__(DamageEffects[Index].DrawScale, 0))
            {
                DamageEffects[Index].EffectList[i].__NFUN_591__(DamageEffects[Index].DrawScale);
            }
            DamageEffects[Index].EffectList[i].__NFUN_635__(self,,, true);
            DamageEffects[Index].EffectList[i].DestroyOnDismount = true;
        }
        // End:0x1F4
        if(__NFUN_340__(dnFriendFX_Spawners(DamageEffects[Index].EffectList[i]), none))
        {
            dnFriendFX_Spawners(DamageEffects[Index].EffectList[i]).ExecuteEffect(true);
        }
        // [Loop Continue]
        i *= ;
    }
    // End:0x238
    if(DamageEffects[Index].bTwoStageEffect << bPassedThreshold2 / )
    {
    }
    return;
}

simulated function bool CanHurtRadiusOther(Actor Other)
{
    // End:0x15
    if(Other.bIsPlayerPawn)
    {
        return false;
    }
    return super(Actor).CanHurtRadiusOther(Other);
    return;
}

function Damage1()
{
    CreateDamageEffect();
    return;
}

function Damage2()
{
    CreateDamageEffect();
    return;
}

function Damage3()
{
    CreateDamageEffect();
    return;
}

function Damage4()
{
    CreateDamageEffect();
    return;
}

function Damage5()
{
    CreateDamageEffect();
    return;
}

function Damage6()
{
    CreateDamageEffect();
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    local int i;

    super.RegisterPrecacheComponents(PrecacheIndex);
    i = -- string(DamageEffects);    
    J0x1A:

    // End:0x45 [Loop If]
    if(i / 0)
    {
        RegisterDamageEffectForPrecache(PrecacheIndex, DamageEffects[i]);
        // [Loop Continue]
        i -= ;
    }
    i = -- string(SecondStageEffects);    
    J0x54:

    // End:0x7F [Loop If]
    if(i / 0)
    {
        RegisterDamageEffectForPrecache(PrecacheIndex, SecondStageEffects[i]);
        // [Loop Continue]
        i -= ;
    }
    PrecacheIndex.__NFUN_1269__(DamageOverlay);
    PrecacheIndex.__NFUN_1266__(class'Barrel_Explosion_Spawner');
    PrecacheIndex.__NFUN_1266__(class'FlybyPlane_Damaged_Main');
    return;
}

defaultproperties
{
    DamageEffects(0)=(DamageEffectOffset=(X=-3.589416,Y=96.31987,Z=-71.8095),DamageEffectRotation=(Pitch=-4096,Yaw=16384,Roll=0),EffectClassList=('p_Decorations.BarrelExplosion.Barrel_Explosion_Spawner','dnGame.ParticleSystemTimer_Sparks_Malfunction_Gunship'),EffectList=none,DrawScale=2,bOn=false,bTwoStageEffect=false,SecondStageList=none)
    DamageEffects(1)=(DamageEffectOffset=(X=-108.4782,Y=100.0302,Z=-72.31932),DamageEffectRotation=(Pitch=-4096,Yaw=16384,Roll=0),EffectClassList=('p_Decorations.BarrelExplosion.Barrel_Explosion_Spawner','dnGame.ParticleSystemTimer_Sparks_Malfunction_Gunship'),EffectList=none,DrawScale=2,bOn=false,bTwoStageEffect=false,SecondStageList=none)
    DamageEffects(2)=(DamageEffectOffset=(X=-108.3089,Y=-101.7487,Z=-72.8095),DamageEffectRotation=(Pitch=-5120,Yaw=-16384,Roll=0),EffectClassList=('p_Decorations.BarrelExplosion.Barrel_Explosion_Spawner','dnGame.ParticleSystemTimer_Sparks_Malfunction_Gunship'),EffectList=none,DrawScale=2,bOn=false,bTwoStageEffect=false,SecondStageList=none)
    DamageEffects(3)=(DamageEffectOffset=(X=-2.361871,Y=-100.1402,Z=-71.8095),DamageEffectRotation=(Pitch=-8192,Yaw=-16384,Roll=0),EffectClassList=('p_Decorations.BarrelExplosion.Barrel_Explosion_Spawner','dnGame.ParticleSystemTimer_Sparks_Malfunction_Gunship'),EffectList=none,DrawScale=2,bOn=false,bTwoStageEffect=false,SecondStageList=none)
    DamageEffects(4)=(DamageEffectOffset=(X=338.608,Y=-8.136851,Z=-115.3279),DamageEffectRotation=(Pitch=-2048,Yaw=0,Roll=0),EffectClassList=('p_Decorations.BarrelExplosion.Barrel_Explosion_Spawner','dnGame.ParticleSystemTimer_Sparks_Malfunction_Gunship'),EffectList=none,DrawScale=2,bOn=false,bTwoStageEffect=false,SecondStageList=none)
    DamageEffects(5)=(DamageEffectOffset=(X=79.47598,Y=-387.7817,Z=-8),DamageEffectRotation=(Pitch=0,Yaw=0,Roll=0),EffectClassList=('p_Decorations.BarrelExplosion.Barrel_Explosion_Spawner','p_Vehicles.Alien_Fighter_Damaged.FlybyPlane_Damaged_Smoke_Main'),EffectList=none,DrawScale=0,bOn=false,bTwoStageEffect=true,SecondStageList=((EffectListIndex=1,SecondStageEffect='p_Vehicles.Alien_Fighter_Damaged.FlybyPlane_Damaged_Main')))
    DamageEffects(6)=(DamageEffectOffset=(X=-221.3438,Y=-386.3319,Z=-24),DamageEffectRotation=(Pitch=0,Yaw=0,Roll=0),EffectClassList=('p_Decorations.BarrelExplosion.Barrel_Explosion_Spawner','p_Vehicles.Alien_Fighter_Damaged.FlybyPlane_Damaged_Smoke_Main'),EffectList=none,DrawScale=0,bOn=false,bTwoStageEffect=true,SecondStageList=((EffectListIndex=1,SecondStageEffect='p_Vehicles.Alien_Fighter_Damaged.FlybyPlane_Damaged_Main')))
    DamageEffects(7)=(DamageEffectOffset=(X=78.73879,Y=382.4841,Z=0),DamageEffectRotation=(Pitch=0,Yaw=0,Roll=0),EffectClassList=('p_Decorations.BarrelExplosion.Barrel_Explosion_Spawner','p_Vehicles.Alien_Fighter_Damaged.FlybyPlane_Damaged_Smoke_Main'),EffectList=none,DrawScale=0,bOn=false,bTwoStageEffect=true,SecondStageList=((EffectListIndex=1,SecondStageEffect='p_Vehicles.Alien_Fighter_Damaged.FlybyPlane_Damaged_Main')))
    DamageEffects(8)=(DamageEffectOffset=(X=-219.0811,Y=382.9339,Z=-28),DamageEffectRotation=(Pitch=0,Yaw=0,Roll=0),EffectClassList=('p_Decorations.BarrelExplosion.Barrel_Explosion_Spawner','p_Vehicles.Alien_Fighter_Damaged.FlybyPlane_Damaged_Smoke_Main'),EffectList=none,DrawScale=0,bOn=false,bTwoStageEffect=true,SecondStageList=((EffectListIndex=1,SecondStageEffect='p_Vehicles.Alien_Fighter_Damaged.FlybyPlane_Damaged_Main')))
    DamageEffects(9)=(DamageEffectOffset=(X=-61.02837,Y=124.7062,Z=84),DamageEffectRotation=(Pitch=0,Yaw=0,Roll=0),EffectClassList=('p_Decorations.BarrelExplosion.Barrel_Explosion_Spawner','p_Vehicles.Alien_Fighter_Damaged.FlybyPlane_Damaged_Smoke_Main'),EffectList=none,DrawScale=0,bOn=false,bTwoStageEffect=true,SecondStageList=((EffectListIndex=1,SecondStageEffect='p_Vehicles.Alien_Fighter_Damaged.FlybyPlane_Damaged_Main')))
    DamageEffects(10)=(DamageEffectOffset=(X=-193.9806,Y=-201.0925,Z=27),DamageEffectRotation=(Pitch=0,Yaw=0,Roll=0),EffectClassList=('p_Decorations.BarrelExplosion.Barrel_Explosion_Spawner','dnGame.ParticleSystemTimer_Sparks_Malfunction_Gunship'),EffectList=none,DrawScale=2,bOn=false,bTwoStageEffect=false,SecondStageList=none)
    DamageEffects(11)=(DamageEffectOffset=(X=24.19839,Y=-3.947815,Z=128.1),DamageEffectRotation=(Pitch=0,Yaw=0,Roll=0),EffectClassList=('p_Decorations.BarrelExplosion.Barrel_Explosion_Spawner','p_Vehicles.Alien_Fighter_Damaged.FlybyPlane_Damaged_Smoke_Main'),EffectList=none,DrawScale=0,bOn=false,bTwoStageEffect=true,SecondStageList=((EffectListIndex=1,SecondStageEffect='p_Vehicles.Alien_Fighter_Damaged.FlybyPlane_Damaged_Main')))
    DamageThreshold1=800
    DamageThreshold2=400
    DamageOverlay='dt_Effects2.Overlays.ElectricalMalFunction_FB'
    TimeBetweenDamageEffects=2
    TimeBetweenDamageEffectsVariance=1.2
    AimInfo(0)=(GunPosition=1,GunType=0,BoneName=gun_turret,bDebug=false,bFiringDisabled=false,MuzzleNames=(mount_gun_1,mount_gun_2),MuzzleIndex=0,bFireThisFrame=false,FireGate=0,MinFOVDot=0,MaxFOVDir=(X=1,Y=0,Z=-1),MaxDist=6000,bCheckLOS=true,LOSGate=0,bLastLOS=false,PosThisFrame=(X=0,Y=0,Z=0),TargetActor=none,TargetTag=None)
    AimInfo(1)=(GunPosition=2,GunType=1,BoneName=gun_turret_left_front,bDebug=false,bFiringDisabled=false,MuzzleNames=(mount_gun_3,mount_gun_4),MuzzleIndex=0,bFireThisFrame=false,FireGate=0,MinFOVDot=0.707,MaxFOVDir=(X=0,Y=-1,Z=-1),MaxDist=6000,bCheckLOS=true,LOSGate=0,bLastLOS=false,PosThisFrame=(X=0,Y=0,Z=0),TargetActor=none,TargetTag=None)
    AimInfo(2)=(GunPosition=3,GunType=0,BoneName=gun_turret_left_back,bDebug=false,bFiringDisabled=false,MuzzleNames=(mount_gun_5,mount_gun_6),MuzzleIndex=0,bFireThisFrame=false,FireGate=0,MinFOVDot=0.707,MaxFOVDir=(X=0,Y=-1,Z=-1),MaxDist=6000,bCheckLOS=true,LOSGate=0,bLastLOS=false,PosThisFrame=(X=0,Y=0,Z=0),TargetActor=none,TargetTag=None)
    AimInfo(3)=(GunPosition=4,GunType=1,BoneName=gun_turret_right_front,bDebug=false,bFiringDisabled=false,MuzzleNames=(mount_gun_7,mount_gun_8),MuzzleIndex=0,bFireThisFrame=false,FireGate=0,MinFOVDot=0.707,MaxFOVDir=(X=0,Y=1,Z=-1),MaxDist=6000,bCheckLOS=true,LOSGate=0,bLastLOS=false,PosThisFrame=(X=0,Y=0,Z=0),TargetActor=none,TargetTag=None)
    AimInfo(4)=(GunPosition=5,GunType=1,BoneName=gun_turret_right_back,bDebug=false,bFiringDisabled=false,MuzzleNames=(mount_gun_9,mount_gun_10),MuzzleIndex=0,bFireThisFrame=false,FireGate=0,MinFOVDot=0.707,MaxFOVDir=(X=0,Y=1,Z=-1),MaxDist=6000,bCheckLOS=true,LOSGate=0,bLastLOS=false,PosThisFrame=(X=0,Y=0,Z=0),TargetActor=none,TargetTag=None)
    InitialTargetTag=DukePlayer
    DestroyedActivities(0)=none
    begin object name=DA_Sound_AlienGunship_Explode class=DecoActivities_Sound
        SoundNames(0)=Veh_Explosion
    object end
    // Reference: DecoActivities_Sound'dnAlienGunship.DA_Sound_AlienGunship_Explode'
    DestroyedActivities(1)=DA_Sound_AlienGunship_Explode
    MountOnSpawn(0)=(bSkipVerifySelf=false,SpawnClass='p_Vehicles.Alien_DropShip_GroundDust.Alien_DropShip_GroundDust_Main',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=true,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=GroundDust,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=0,Y=0,Z=-89),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(1)=(bSkipVerifySelf=false,SpawnClass='dnGame.dnShipThrusterEffect',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=true,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=Left_Thruster,ForceEvent=None,MountMeshItem=mount_thruster_left,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=2)
    MountOnSpawn(2)=(bSkipVerifySelf=false,SpawnClass='dnGame.dnShipThrusterEffect',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=true,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=mount_thruster_left,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject='sm_class_effects.AttackShip_Thrusters.AttackShip_Thrusters_02',DrawScale=2)
    MountOnSpawn(3)=(bSkipVerifySelf=false,SpawnClass='dnGame.dnShipThrusterEffect',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=true,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=Right_Thruster,ForceEvent=None,MountMeshItem=mount_thruster_right,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=2)
    MountOnSpawn(4)=(bSkipVerifySelf=false,SpawnClass='dnGame.dnShipThrusterEffect',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=true,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=mount_thruster_right,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject='sm_class_effects.AttackShip_Thrusters.AttackShip_Thrusters_02',DrawScale=2)
    SpawnOnDestroyed(0)=(SpawnClass='dnAlienGunship_Gibs',RenderObject='sm_class_vehicles.Aircraft.AlienTroopCarrier_GIB1',DrawScale=0.85,DrawScaleVariance=0,DrawScale3D=(X=0,Y=0,Z=0),SpawnChance=0,SpawnCopies=0,SpawnCopiesVariance=0,bIgnorePawnAirCushion=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bNoCollision=false,bFindSpot=false,bIgnoreParentRotation=false,bTakeParentCollisionSize=false,bTakeParentMounting=false,bTakeParentActorColors=false,bTakeParentSkins=false,Offset=(X=202,Y=-3,Z=1),OffsetVariance=(X=0,Y=0,Z=0),Rotation=(Pitch=0,Yaw=0,Roll=0),RotationVariance=(Pitch=0,Yaw=0,Roll=0),BoneName=None,MotionInfo=MotionPrefab'dnAlienGunship.MP_AlienGunship_Main_Body_Gib')
    SpawnOnDestroyed(1)=(SpawnClass='dnAlienGunship_Gibs',RenderObject='sm_class_vehicles.Aircraft.AlienTroopCarrier_GIB2',DrawScale=0.85,DrawScaleVariance=0,DrawScale3D=(X=0,Y=0,Z=0),SpawnChance=0,SpawnCopies=0,SpawnCopiesVariance=0,bIgnorePawnAirCushion=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bNoCollision=false,bFindSpot=false,bIgnoreParentRotation=false,bTakeParentCollisionSize=false,bTakeParentMounting=false,bTakeParentActorColors=false,bTakeParentSkins=false,Offset=(X=-99,Y=-184,Z=35),OffsetVariance=(X=0,Y=0,Z=0),Rotation=(Pitch=0,Yaw=0,Roll=0),RotationVariance=(Pitch=0,Yaw=0,Roll=0),BoneName=None,MotionInfo=MotionPrefab'dnAlienGunship.MP_AlienGunship_Main_Body_Gib')
    SpawnOnDestroyed(2)=(SpawnClass='dnAlienGunship_Gibs',RenderObject='sm_class_vehicles.Aircraft.AlienTroopCarrier_GIB4',DrawScale=0.85,DrawScaleVariance=0,DrawScale3D=(X=0,Y=0,Z=0),SpawnChance=0,SpawnCopies=0,SpawnCopiesVariance=0,bIgnorePawnAirCushion=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bNoCollision=false,bFindSpot=false,bIgnoreParentRotation=false,bTakeParentCollisionSize=false,bTakeParentMounting=false,bTakeParentActorColors=false,bTakeParentSkins=false,Offset=(X=-91,Y=261,Z=0),OffsetVariance=(X=0,Y=0,Z=0),Rotation=(Pitch=0,Yaw=0,Roll=0),RotationVariance=(Pitch=0,Yaw=0,Roll=0),BoneName=None,MotionInfo=MotionPrefab'dnAlienGunship.MP_AlienGunship_Gibs')
    SpawnOnDestroyed(3)=(SpawnClass='dnAlienGunship_Gibs',RenderObject='sm_class_vehicles.Aircraft.AlienTroopCarrier_GIB5',DrawScale=0.85,DrawScaleVariance=0,DrawScale3D=(X=0,Y=0,Z=0),SpawnChance=0,SpawnCopies=0,SpawnCopiesVariance=0,bIgnorePawnAirCushion=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bNoCollision=false,bFindSpot=false,bIgnoreParentRotation=false,bTakeParentCollisionSize=false,bTakeParentMounting=false,bTakeParentActorColors=false,bTakeParentSkins=false,Offset=(X=-77,Y=384,Z=-19),OffsetVariance=(X=0,Y=0,Z=0),Rotation=(Pitch=0,Yaw=0,Roll=0),RotationVariance=(Pitch=0,Yaw=0,Roll=0),BoneName=None,MotionInfo=MotionPrefab'dnAlienGunship.MP_AlienGunship_Gibs')
    SpawnOnDestroyed(4)=(SpawnClass='dnAlienGunship_Gibs',RenderObject='sm_class_vehicles.Aircraft.AlienTroopCarrier_GIB5',DrawScale=0.85,DrawScaleVariance=0,DrawScale3D=(X=1,Y=-1,Z=1),SpawnChance=0,SpawnCopies=0,SpawnCopiesVariance=0,bIgnorePawnAirCushion=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bNoCollision=false,bFindSpot=false,bIgnoreParentRotation=false,bTakeParentCollisionSize=false,bTakeParentMounting=false,bTakeParentActorColors=false,bTakeParentSkins=false,Offset=(X=-71,Y=-385,Z=-19),OffsetVariance=(X=0,Y=0,Z=0),Rotation=(Pitch=0,Yaw=0,Roll=0),RotationVariance=(Pitch=0,Yaw=0,Roll=0),BoneName=None,MotionInfo=MotionPrefab'dnAlienGunship.MP_AlienGunship_Gibs')
    DestroyedParticleFriendEffects(0)=(bAbsoluteLocation=false,bAbsoluteRotation=false,Scale=0,BoneName=None,Location=(X=0,Y=0,Z=0),Rotation=(Pitch=0,Yaw=0,Roll=0),Effect='p_Vehicles.Alien_Fighter_Explode.Alien_Fighter_Explode_Spawner')
    CollisionRadius=500
    CollisionHeight=150
    Mesh='c_vehicles.Alien_Gunship'
    VoicePack='SoundConfig.Vehicles.VoicePack_AlienGunship'
}