/*******************************************************************************
 * dnControl_PigCop_Grapple generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class dnControl_PigCop_Grapple extends dnControl_TapPowered
    collapsecategories;

var() deprecated PigCop_Grunt PIGCOP;
var float DamageRate;
var float Damage;
var float FailTimer;
var name GridAnim;
var SMountPrefab PigCopMountPrefab;
var name LoopSoundName;

simulated event Actor GetIKActor(name LimbID)
{
    return PIGCOP;
    return;
}

simulated event bool UsableSomething_AIShouldIgnoreUser()
{
    return true;
    return;
}

final function TakeControlOfPigCop()
{
    // End:0x0E
    if(__NFUN_339__(PIGCOP, none))
    {
        return;
    }
    PIGCOP.SuspendExecutive(true);
    PIGCOP.SuspendLookTargetEvaluation(true);
    PIGCOP.SuspendWeaponTargetEvaluation(true);
    PIGCOP.TickStyle = 3;
    PIGCOP.bDontModifyHeadSize = true;
    PIGCOP.__NFUN_642__(9);
    PIGCOP.StoreCollision();
    PIGCOP.__NFUN_621__(false, false, false, false, false);
    PIGCOP.SetAnimSync(2, 2, 2, 2, 2);
    PIGCOP.EndNonOPPain();
    return;
}

final function MountPigCop()
{
    local SDesiredLocation DesiredLocation;

    // End:0x0E
    if(__NFUN_339__(PIGCOP, none))
    {
        return;
    }
    PIGCOP.__NFUN_635__(self,,, true);
    DesiredLocation.Target = PigCopMountPrefab.MountOrigin;
    DesiredLocation.TimeTotal = InterpolationInTime;
    PIGCOP.bUseNormalPhysicsRotation = true;
    PIGCOP.__NFUN_650__(DesiredLocation);
    PIGCOP.__NFUN_663__(PigCopMountPrefab.MountAngles,, DesiredLocation.TimeTotal,,,,,,, true);
    return;
}

final function ReleaseControlOfPigCop()
{
    // End:0x0E
    if(__NFUN_339__(PIGCOP, none))
    {
        return;
    }
    PIGCOP.DestroyOnDismount = false;
    PIGCOP.__NFUN_631__();
    PIGCOP.TickStyle = PIGCOP.default.TickStyle;
    PIGCOP.RestoreCollision();
    PIGCOP.__NFUN_642__(PIGCOP.default.Physics);
    PIGCOP.bUseNormalPhysicsRotation = PIGCOP.default.bUseNormalPhysicsRotation;
    PIGCOP.SuspendExecutive(false);
    PIGCOP.SuspendLookTargetEvaluation(false);
    PIGCOP.SuspendWeaponTargetEvaluation(false);
    PIGCOP.SetExecutive(2);
    PIGCOP = none;
    return;
}

simulated function AttachPawnSuccess(Pawn Attachee, optional bool bForced)
{
    TakeControlOfPigCop();
    __NFUN_645__(__NFUN_239__(Attachee.Location, WarnInternal(0, 0, Attachee.CollisionHeight)));
    __NFUN_652__(Attachee.Rotation);
    // End:0x60
    if(__NFUN_340__(InternalControlRemapper, none))
    {
        InternalControlRemapper.__NFUN_630__();
    }
    super(dnControl).AttachPawnSuccess(Attachee, bForced);
    // End:0x8F
    if(__NFUN_340__(User, none))
    {
        User.bNoDamage = true;
    }
    MountPigCop();
    return;
}

simulated function DetachPawnSuccess(bool bForced)
{
    super(dnControl).DetachPawnSuccess(bForced);
    // End:0x2A
    if(__NFUN_340__(User, none))
    {
        User.bNoDamage = false;
    }
    return;
}

simulated function PlayUserAnim()
{
    super(dnControl).PlayUserAnim();
    // End:0x71
    if((__NFUN_342__(States[CurrentStateIndex].UserAnimName, 'None') << __NFUN_340__(PIGCOP, none)) << __NFUN_340__(PIGCOP.AnimationController, none))
    {
        PIGCOP.AnimationController.SetAnimState(States[CurrentStateIndex].UserAnimName);
    }
    return;
}

final simulated function DamagePlayer()
{
    local float DamageAmount;

    // End:0xCD
    if(__NFUN_340__(User, none))
    {
        DamageAmount = Damage;
        // End:0x53
        if(Repl(DamageAmount, User.Health))
        {
            DamageAmount = VSize(0, Round(User.Health, 1));
        }
        User.bNoDamage = false;
        User.TakeDamage(PIGCOP, DamageAmount, User.Location, Caps(float(-1), Vector(User.Rotation)), class'MeleeDamage',, PIGCOP.Location);
        User.bNoDamage = true;
    }
    return;
}

final simulated function FailTimerFunc()
{
    // End:0x26
    if(PlayerPawn(User).bGodMode / )
    {
    }
    return;
}

function CheckEarlyDetach()
{
    // End:0x52
    if((__NFUN_339__(PIGCOP, none) < PIGCOP.__NFUN_921__()) < User.__NFUN_921__())
    {
        // End:0x42
        if(__NFUN_340__(PIGCOP, none))
        {
            ReleaseControlOfPigCop();
        }
        User.ForceDetachCompleteFromUsableSomething();
    }
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    super.RegisterPrecacheComponents(PrecacheIndex);
    PrecacheIndex.__NFUN_1277__(class'DukePlayer'.default.VoicePack, 'MeleeDeathImpacts');
    PrecacheIndex.__NFUN_1277__(class'PigCop_Grunt'.default.VoicePack, 'Sound_Executed');
    PrecacheIndex.__NFUN_1279__(class'MeleeDamage');
    PrecacheIndex.__NFUN_1279__(class'CrushingDamage');
    PrecacheIndex.__NFUN_1277__(VoicePack, LoopSoundName);
    PrecacheIndex.__NFUN_1281__(GridAnim);
    PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'Rage_VOC');
    PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'STR_BerzPig_NeckBreak');
    return;
}

state() AttachUserAnim
{
    event Tick(float DeltaSeconds)
    {
        super(dnControl).Tick(DeltaSeconds);
        CheckEarlyDetach();
        return;
    }
    stop;
}

state() idle
{
    event BeginState()
    {
        super(Object).BeginState();
        __NFUN_607__(DamageRate, true, 'DamagePlayer');
        __NFUN_607__(FailTimer, true, 'FailTimerFunc');
        FindAndPlaySound(LoopSoundName);
        return;
    }

    event EndState()
    {
        super(Object).EndState();
        __NFUN_608__('DamagePlayer');
        __NFUN_608__('FailTimerFunc');
        FindAndStopSound(LoopSoundName);
        return;
    }

    function FullyLifted()
    {
        super(dnControl_TapPowered).FullyLifted();
        ControlEvent(, 'Success');
        return;
    }

    function UpdateUserLift()
    {
        super(dnControl_TapPowered).UpdateUserLift();
        User.AnimationController.SetAnimGridState(GridAnim, UserLiftVal);
        // End:0x72
        if(__NFUN_340__(PIGCOP, none) << __NFUN_340__(PIGCOP.AnimationController, none))
        {
            PIGCOP.AnimationController.SetAnimGridState(GridAnim, UserLiftVal);
        }
        CheckEarlyDetach();
        return;
    }
    stop;
}

state() Success
{
    function AnimCallback_UserAnimEnd()
    {
        super(dnControl).AnimCallback_UserAnimEnd();
        DetachPawnSuccess(false);
        return;
    }

    simulated function InteractUser(Pawn User)
    {
        super(InteractiveActor).InteractUser(User);
        // End:0x90
        if(__NFUN_340__(PIGCOP, none))
        {
            PIGCOP.DeathAnimChance = 0;
            PIGCOP.FindSoundAndSpeak('Sound_Executed');
            PIGCOP.Died(User, int(PIGCOP.Health), PIGCOP.Location, WarnInternal(0, 0, 0), class'MeleeDamage', 'Root');
        }
        return;
    }
    stop;
}

state() Fail
{
    function AnimCallback_UserAnimEnd()
    {
        User.bNoDamage = false;
        super(dnControl).AnimCallback_UserAnimEnd();
        User.FindAndPlaySound('MeleeDeathImpacts', 1);
        User.Died(PIGCOP, int(User.Health), User.Location, __NFUN_233__(Vector(Rotation)), class'CrushingDamage', 'Root');
        // End:0x87
        if(__NFUN_340__(PIGCOP, none))
        {
            ReleaseControlOfPigCop();
        }
        return;
    }
    stop;
}

defaultproperties
{
    DamageRate=1
    Damage=20
    FailTimer=5
    GridAnim=PigCop_Grapple_Grid
    PigCopMountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=88.467,Y=0,Z=45),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=32768,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0)
    LoopSoundName=STR_Motion_Generic
    bForceDrop=false
    StartTapInterval=0.5
    EndTapInterval=0.3
    RateOfGain=0.05
    RateOfLoss=0.2
    TapUsePhrase="<?int?dnAI.dnControl_PigCop_Grapple.TapUsePhrase?>"
    States(0)=(StateName=Useable,OutEvents=none,Transitions=((ControlEvent=3,CustomName=None,NewState=AttachUserLERP)),UserAnimName=None,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(1)=(StateName=AttachUserLERP,OutEvents=none,Transitions=((ControlEvent=5,CustomName=None,NewState=AttachUserAnim)),UserAnimName=None,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(2)=(StateName=AttachUserAnim,OutEvents=none,Transitions=((ControlEvent=7,CustomName=None,NewState=idle)),UserAnimName=PigCop_Grapple_Activate,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(3)=(StateName=idle,OutEvents=none,Transitions=((ControlEvent=0,CustomName=Success,NewState=Success),(ControlEvent=0,CustomName=Fail,NewState=Fail)),UserAnimName=None,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(4)=(StateName=DetachUser,OutEvents=none,Transitions=((ControlEvent=8,CustomName=None,NewState=DetachUserLERP)),UserAnimName=None,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(5)=(StateName=DetachUserLERP,OutEvents=none,Transitions=((ControlEvent=6,CustomName=None,NewState=Useable)),UserAnimName=None,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(6)=(StateName=FadeToRest,OutEvents=none,Transitions=((ControlEvent=0,CustomName=ProceedWithDetach,NewState=DetachUser)),UserAnimName=None,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(7)=(StateName=Success,OutEvents=none,Transitions=((ControlEvent=4,CustomName=None,NewState=DetachUser)),UserAnimName=PigCop_Grapple_Success,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(8)=(StateName=Fail,OutEvents=none,Transitions=((ControlEvent=4,CustomName=None,NewState=DetachUser)),UserAnimName=PigCop_Grapple_Fail,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    PassedDamageScale=1
    PassedPhysicsDamageScale=1
    ForceAttachStateName=AttachUserLERP
    PawnLostStateName=complete
    AIHoldFire=true
    bUseHomePose=false
    InterpolationInTime=0.3
    InterpolationOutTime=0.3
    bDetachOnDamage=false
    HeadAimMinOffset=(Pitch=0,Yaw=0,Roll=0)
    HeadAimMaxOffset=(Pitch=0,Yaw=0,Roll=0)
    bInternalUseDetach=false
    bLookWhenHidden=true
    bForceUsePhrase=true
    bTraceUsable=false
    bHidden=true
    bCollideActors=false
    bCollideWorld=false
    CollisionRadius=1
    CollisionHeight=1
    SoundVolume=255
    VoicePack='SoundConfig.Players.VoicePack_Duke'
}