/*******************************************************************************
 * dnControl_PregnatorFaceHump generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class dnControl_PregnatorFaceHump extends dnControl_TapPowered
    collapsecategories;

var Pregnator Pregnator;
var float DamageRate;
var float Damage;
var float GruntRate;
var float GruntRateVariance;
var SMountPrefab PregnatorMountPrefab;
var name GridAnim;

simulated event Actor GetIKActor(name LimbID)
{
    return Pregnator;
    return;
}

simulated event bool UsableSomething_AIShouldIgnoreUser()
{
    return true;
    return;
}

final function TakeControlOfPregnator()
{
    // End:0x0E
    if(__NFUN_339__(Pregnator, none))
    {
        return;
    }
    Pregnator.SuspendExecutive(true);
    Pregnator.SuspendLookTargetEvaluation(true);
    Pregnator.SuspendWeaponTargetEvaluation(true);
    Pregnator.TickStyle = 3;
    Pregnator.__NFUN_642__(9);
    Pregnator.StoreCollision();
    Pregnator.__NFUN_621__(false, false, false, false, false);
    Pregnator.__NFUN_635__(User,,, true);
    return;
}

final function MountPregnatorToUser()
{
    local SDesiredLocation DesiredLocation;

    // End:0x0E
    if(__NFUN_339__(Pregnator, none))
    {
        return;
    }
    Pregnator.__NFUN_635__(self,,, true);
    DesiredLocation.Target = PregnatorMountPrefab.MountOrigin;
    DesiredLocation.TimeTotal = FRand(0.25, Clamp(__NFUN_239__(PregnatorMountPrefab.MountOrigin, Pregnator.MountOrigin))) >>> 80;
    Pregnator.bUseNormalPhysicsRotation = true;
    Pregnator.__NFUN_650__(DesiredLocation);
    Pregnator.__NFUN_663__(PregnatorMountPrefab.MountAngles,, DesiredLocation.TimeTotal,,,,,,, true);
    return;
}

final function ReleaseControlOfPregnator()
{
    // End:0x0E
    if(__NFUN_339__(Pregnator, none))
    {
        return;
    }
    Pregnator.DestroyOnDismount = false;
    Pregnator.__NFUN_631__();
    Pregnator.bUseNormalPhysicsRotation = Pregnator.default.bUseNormalPhysicsRotation;
    Pregnator.TickStyle = Pregnator.default.TickStyle;
    Pregnator.RestoreCollision();
    Pregnator.__NFUN_642__(Pregnator.default.Physics);
    Pregnator.SuspendExecutive(false);
    Pregnator.SuspendLookTargetEvaluation(false);
    Pregnator.SuspendWeaponTargetEvaluation(false);
    Pregnator.SetExecutive(2);
    Pregnator = none;
    return;
}

simulated function AttachPawnSuccess(Pawn Attachee, optional bool bForced)
{
    __NFUN_645__(__NFUN_239__(Attachee.Location, WarnInternal(0, 0, Attachee.CollisionHeight)));
    __NFUN_652__(Attachee.Rotation);
    Attachee.HandQuickAction_AnimEnd();
    // End:0x6A
    if(__NFUN_340__(InternalControlRemapper, none))
    {
        InternalControlRemapper.__NFUN_630__();
    }
    TakeControlOfPregnator();
    super(dnControl).AttachPawnSuccess(Attachee, bForced);
    MountPregnatorToUser();
    // End:0xB6
    if(__NFUN_340__(User, none))
    {
        User.FindAndPlaySound('BodyMotion_Medium');
        __NFUN_607__(3.4, false, 'Rustle');
    }
    __NFUN_605__(Normal(GruntRate, GruntRateVariance), true, 'Grunt');
    __NFUN_605__(Normal(GruntRate, GruntRateVariance), true, 'PregnatorIdle');
    __NFUN_607__(DamageRate, true, 'DamagePlayer');
    return;
}

function Grunt()
{
    // End:0x21
    if(__NFUN_340__(User, none))
    {
        User.FindSoundAndSpeak('Gen_Grunt');
    }
    __NFUN_607__(Normal(GruntRate, GruntRateVariance), false, 'Grunt');
    return;
}

function Rustle()
{
    // End:0x21
    if(__NFUN_340__(User, none))
    {
        User.FindAndPlaySound('BodyMotion_Short');
    }
    __NFUN_607__(Normal(GruntRate, GruntRateVariance), false, 'Rustle');
    return;
}

function PregnatorIdle()
{
    // End:0x21
    if(__NFUN_340__(Pregnator, none))
    {
        Pregnator.FindAndPlaySound('Sound_Idle');
    }
    __NFUN_607__(Normal(GruntRate, GruntRateVariance), false, 'PregnatorIdle');
    return;
}

simulated function PlayUserAnim()
{
    super(dnControl).PlayUserAnim();
    // End:0x71
    if((__NFUN_342__(States[CurrentStateIndex].UserAnimName, 'None') << __NFUN_340__(Pregnator, none)) << __NFUN_340__(Pregnator.AnimationController, none))
    {
        Pregnator.AnimationController.SetAnimState(States[CurrentStateIndex].UserAnimName);
    }
    return;
}

function CheckEarlyDetach()
{
    // End:0x52
    if((__NFUN_339__(Pregnator, none) < Pregnator.__NFUN_921__()) < User.__NFUN_921__())
    {
        // End:0x42
        if(__NFUN_340__(Pregnator, none))
        {
            ReleaseControlOfPregnator();
        }
        User.ForceDetachCompleteFromUsableSomething();
    }
    return;
}

final simulated function DamagePlayer()
{
    // End:0x91
    if(__NFUN_340__(User, none))
    {
        User.TakeDamage(Pregnator, Damage, User.Location, Caps(float(-1), Vector(User.Rotation)), class'MeleeDamage',, Pregnator.Location);
        // End:0x91
        if(__NFUN_339__(User, none) < User.IsDead())
        {
            ReleaseControlOfPregnator();
            __NFUN_608__('DamagePlayer');
        }
    }
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    local int i;

    super.RegisterPrecacheComponents(PrecacheIndex);
    PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'BodyMotion_Short');
    PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'BodyMotion_Medium');
    PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'Gen_Grunt');
    PrecacheIndex.__NFUN_1277__(class'VoicePack_Pregnator', 'Sound_Idle');
    PrecacheIndex.__NFUN_1277__(class'VoicePack_Pregnator', 'Sound_Executed');
    PrecacheIndex.__NFUN_1279__(class'MeleeDamage');
    PrecacheIndex.__NFUN_1281__(GridAnim);
    return;
}

state() AttachUserAnim
{
    event Tick(float DeltaSeconds)
    {
        super(dnControl).Tick(DeltaSeconds);
        CheckEarlyDetach();
        return;
    }
    stop;
}

state() idle
{
    function FullyLifted()
    {
        super(dnControl_TapPowered).FullyLifted();
        __NFUN_608__('DamagePlayer');
        __NFUN_608__('Grunt');
        __NFUN_608__('Rustle');
        // End:0x54
        if(__NFUN_340__(User, none))
        {
            User.FindAndStopSound('BodyMotion_Medium');
            User.FindAndStopSound('BodyMotion_Short');
        }
        ControlEvent(, 'Finish');
        return;
    }

    function UpdateUserLift()
    {
        super(dnControl_TapPowered).UpdateUserLift();
        User.AnimationController.SetAnimGridState(GridAnim, UserLiftVal);
        // End:0x72
        if(__NFUN_340__(Pregnator, none) << __NFUN_340__(Pregnator.AnimationController, none))
        {
            Pregnator.AnimationController.SetAnimGridState(GridAnim, UserLiftVal);
        }
        CheckEarlyDetach();
        return;
    }
    stop;
}

state Finish
{
    simulated function InteractUser(Pawn User)
    {
        super(InteractiveActor).InteractUser(User);
        // End:0x62
        if(__NFUN_340__(Pregnator, none))
        {
            Pregnator.FindSoundAndSpeak('Sound_Executed');
            Pregnator.Died(User, 100, Pregnator.Location, Vector(Rotation), class'MeleeDamage', 'Root');
        }
        DetachPawnSuccess(false);
        return;
    }
    stop;
}

defaultproperties
{
    DamageRate=1
    Damage=20
    GruntRate=1
    GruntRateVariance=0.5
    PregnatorMountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=52.201,Y=0,Z=60.391),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=32768,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0)
    GridAnim=Pregnator_FaceHump_Grid
    bForceDrop=false
    StartTapInterval=0.75
    EndTapInterval=0.5
    RateOfGain=0.1
    RateOfLoss=0.2
    TapUsePhrase="<?int?dnAI.dnControl_PregnatorFaceHump.TapUsePhrase?>"
    States(0)=(StateName=Useable,OutEvents=none,Transitions=((ControlEvent=3,CustomName=None,NewState=AttachUserLERP)),UserAnimName=None,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(1)=(StateName=AttachUserLERP,OutEvents=none,Transitions=((ControlEvent=5,CustomName=None,NewState=AttachUserAnim)),UserAnimName=None,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(2)=(StateName=AttachUserAnim,OutEvents=none,Transitions=((ControlEvent=7,CustomName=None,NewState=idle)),UserAnimName=Pregnator_FaceHump_Activate,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(3)=(StateName=idle,OutEvents=none,Transitions=((ControlEvent=0,CustomName=Finish,NewState=Finish)),UserAnimName=None,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(4)=(StateName=DetachUser,OutEvents=none,Transitions=((ControlEvent=8,CustomName=None,NewState=DetachUserLERP)),UserAnimName=None,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(5)=(StateName=DetachUserLERP,OutEvents=none,Transitions=((ControlEvent=6,CustomName=None,NewState=Useable)),UserAnimName=None,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(6)=(StateName=FadeToRest,OutEvents=none,Transitions=((ControlEvent=0,CustomName=ProceedWithDetach,NewState=DetachUser)),UserAnimName=None,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(7)=(StateName=Finish,OutEvents=none,Transitions=((ControlEvent=4,CustomName=None,NewState=DetachUser)),UserAnimName=Pregnator_FaceHump_Finish,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    PassedDamageScale=1
    PassedPhysicsDamageScale=1
    ForceAttachStateName=AttachUserLERP
    PawnLostStateName=complete
    AIHoldFire=true
    bUseHomePose=false
    InterpolationInTime=0.15
    InterpolationOutTime=0.3
    bDetachOnDamage=false
    HeadAimMinOffset=(Pitch=0,Yaw=0,Roll=0)
    HeadAimMaxOffset=(Pitch=0,Yaw=0,Roll=0)
    bInternalUseDetach=false
    bLookWhenHidden=true
    bForceUsePhrase=true
    bTraceUsable=false
    bHidden=true
    bCollideActors=false
    bCollideWorld=false
    CollisionRadius=1
    CollisionHeight=1
}