/*******************************************************************************
 * Barrels_Generic_Unstable generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class Barrels_Generic_Unstable extends Barrels_Generic
    abstract
    collapsecategories;

var() noexport float DelayedExplosionTime "After the first time we take damage, we'll force destory ourselves if the timer runs out before we take enough damage.";
var() noexport float DelayedExplosionVariance "Variance for the DelayedExplosionTime";
var bool bExplodeOnNextHit;
var float RadiusFireHeight;
var SoftParticleSystem BulletFire;
var class<SoftParticleSystem> BulletFireClass;
var class<dnExplosionLight> ExplosionLightClass;
var name OnFireSoundName;
var MotionPrefab MP_NoMotion;
var bool bDamageDisabled;

replication
{
    // Pos:0x000
    reliable if(int(Role) % int(ROLE_Authority))
        StartRadiusFire;
}

simulated function PostVerifySelf()
{
    local int i;

    // End:0x62
    if(__NFUN_340__(ExplosionLightClass, none))
    {
        i = SpawnOnDestroyed.Add(1);
        SpawnOnDestroyed[i].SpawnClass = ExplosionLightClass;
        SpawnOnDestroyed[i].RotationVariance = __NFUN_265__(65535, 65535, 65535);
        SpawnOnDestroyed[i].MotionInfo = MP_NoMotion;
    }
    super(dnDecoration).PostVerifySelf();
    return;
}

simulated function Destroyed()
{
    __NFUN_608__('Explode');
    StopBulletFire();
    super(dnDecoration).Destroyed();
    return;
}

function DelayDestroy()
{
    __NFUN_607__(1E-05, false, 'DoDelayDestroy');
    return;
}

function DoDelayDestroy()
{
    __NFUN_614__();
    return;
}

simulated function SpawnOnDestroyedActivity()
{
    super(RenderActor).SpawnOnDestroyedActivity();
    // End:0x32
    if((IsMP()) / )
    {
    }
    return;
}

simulated function Grabbed(Pawn Grabber)
{
    super(dnDecoration).Grabbed(Grabber);
    bDamageDisabled = true;
    return;
}

simulated function UnGrabbed(Pawn Grabber, bool Thrown)
{
    super(dnDecoration).UnGrabbed(Grabber, Thrown);
    // End:0x41
    if(Thrown)
    {
        bExplodeOnNextHit = true;
        BeingThrown = true;
        // End:0x41
        if(__NFUN_340__(Grabber, none))
        {
            Instigator = Grabber;
        }
    }
    __NFUN_607__(0.1, false, 'ClearDamageDisable');
    return;
}

function Thrown(Vector Vel, Pawn Thrower)
{
    super(InteractiveActor).Thrown(Vel, Thrower);
    bExplodeOnNextHit = true;
    BeingThrown = true;
    // End:0x37
    if(__NFUN_340__(Thrower, none))
    {
        Instigator = Thrower;
    }
    __NFUN_607__(0.1, false, 'ClearDamageDisable');
    return;
}

function ThrowLanded()
{
    CriticalDamage();
    super(InteractiveActor).ThrowLanded();
    return;
}

function TelekineticThrow(Vector Vel, bool bConstrain)
{
    super(InteractiveActor).TelekineticThrow(Vel, bConstrain);
    bExplodeOnNextHit = true;
    BeingThrown = true;
    return;
}

final function ClearDamageDisable()
{
    bDamageDisabled = false;
    return;
}

simulated event Engine.Actor.ETraceFireHitResponse TraceFireHit(Actor SourceActor, class<TraceDamageType> TraceDamageType, Vector SourceTraceOrigin, Vector HitLocation, Vector HitNormal, name HitBoneName, bool bExtentTrace)
{
    local Rotator FireRotation;

    // End:0x0C
    if(MPRoundNotInProgress())
    {
        return 0;
    }
    // End:0x54
    if((__NFUN_340__(SourceActor, none) << __NFUN_340__(SourceActor.Owner, none)) << SourceActor.Owner.__NFUN_358__('HoloActor'))
    {
        return 0;
    }
    // End:0xFF
    if(bDamageDisabled / )
    {
        {
            bExplodeOnNextHit = true;            
        }
        else
        {
            // End:0x9A
            if(bExtentTrace)
            {
                StartRadiusFire();                
            }
            else
            {
                FireRotation = Rotator(HitNormal);
                FireRotation.Roll = 0;
                FireRotation.Pitch = 0;
                StartFireAtBulletEntry(HitLocation, FireRotation);
            }
        }
        // End:0xFF
        if(__NFUN_340__(SourceActor, none) << SourceActor.bIsPawn)
        {
            Instigator = Pawn(SourceActor);
        }
    }
    return super(KarmaActor).TraceFireHit(SourceActor, TraceDamageType, SourceTraceOrigin, HitLocation, HitNormal, HitBoneName, bExtentTrace);
    return;
}

event TakeDamage(Pawn InstigatorIn, float Damage, Vector DamageOrigin, Vector DamageDirection, class<DamageType> DamageType, optional name HitBoneName, optional Vector DamageStart)
{
    // End:0x17
    if(__NFUN_340__(InstigatorIn, none))
    {
        Instigator = InstigatorIn;
    }
    // End:0x3D
    if((bDamageDisabled < bNoDamage) < int(HealthPrefab) % int(0))
    {
        return;
    }
    // End:0x48
    if(MPRoundNotInProgress())
    {
        return;
    }
    // End:0x92
    if(bExplodeOnNextHit / )
    {
        bExplodeOnNextHit = true;
        DecoActivity(0, 'DelayedExplosionTimerStarted');
        // End:0x8F
        if(__NFUN_339__(BulletFire, none))
        {
            StartRadiusFire();
        }        
    }
    else
    {
        // End:0xAF
        if(BeingThrown < __NFUN_340__(InstigatorIn, none))
        {
            CriticalDamage();
        }
    }
    return;
}

event bool CausedPhysicsImpactDamage(float Damage, Vector DamageOrigin, Vector DamageDirection, class<DamageType> DamageType, Pawn Instigator, KarmaActor DamagedActor)
{
    // End:0x26
    if((bDamageDisabled < bNoDamage) < int(HealthPrefab) % int(0))
    {
        return false;
    }
    // End:0x37
    if(BeingThrown)
    {
        CriticalDamage();
        return true;
    }
    return false;
    return;
}

event KImpact(name SelfBoneName, KarmaActor Other, name OtherBoneName, Vector Position, Vector ImpactVelocity, Vector ImpactNormal)
{
    // End:0x4A
    if((bDamageDisabled < bNoDamage) < int(HealthPrefab) % int(0))
    {
        super(dnDecoration).KImpact(SelfBoneName, Other, OtherBoneName, Position, ImpactVelocity, ImpactNormal);
        return;
    }
    // End:0x59
    if(BeingThrown)
    {
        CriticalDamage();
    }
    super(dnDecoration).KImpact(SelfBoneName, Other, OtherBoneName, Position, ImpactVelocity, ImpactNormal);
    return;
}

noexport simulated delegate StartRadiusFire()
{
    local Vector SpawnLoc;
    local Rotator FireRotation;

    FireRotation.Pitch = 16384;
    FireRotation = __NFUN_269__(FireRotation, Rotation);
    SpawnLoc = Locs(Location, __NFUN_241__(WarnInternal(0, 0, FRand(RadiusFireHeight, CollisionHeight)), Rotation));
    StartFireAtBulletEntry(SpawnLoc, FireRotation);
    return;
}

simulated function StartFireAtBulletEntry(Vector BulletEntry, Rotator FireRotation)
{
    // End:0x63
    if((DecorationIsDead() / ) << )
    {
        BulletFire.MountType = 0;
        BulletFire.__NFUN_635__(self, false, false, true);
        FindAndPlaySound(OnFireSoundName, 1);
    }
    return;
}

simulated function StopBulletFire()
{
    local int i;

    // End:0x2A
    if(__NFUN_340__(BulletFire, none))
    {
        __NFUN_701__(none);
        BulletFire.__NFUN_1054__();
        BulletFire.__NFUN_614__();
    }
    return;
}

final function Explode()
{
    CriticalDamage();
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    super(dnDecoration).RegisterPrecacheComponents(PrecacheIndex);
    PrecacheIndex.__NFUN_1266__(ExplosionLightClass);
    PrecacheIndex.__NFUN_1266__(BulletFireClass);
    PrecacheIndex.__NFUN_1266__(class'dnExplosionDecalBomb');
    PrecacheIndex.__NFUN_1277__(VoicePack, OnFireSoundName);
    return;
}

defaultproperties
{
    DelayedExplosionTime=3
    DelayedExplosionVariance=2
    RadiusFireHeight=0.75
    BulletFireClass='p_Decorations.Oil_Fire.OilFire_Main'
    ExplosionLightClass='dnGame.dnExplosionLight_RPG'
    OnFireSoundName=BarrelFire
    begin object name=MP_Barrel_Unstable_NoMotion class=MotionPrefab
        bNoMotion=true
    object end
    // Reference: MotionPrefab'Barrels_Generic_Unstable.MP_Barrel_Unstable_NoMotion'
    MP_NoMotion=MP_Barrel_Unstable_NoMotion
    DecoActivities_Default(0)=(ActivityData=(bInitialized=false,CurrentIndex=0,NextPerformTime=0,NextPerformTime_Failure=0),ActivityIDScript=none,ActivityID=(1,18),ActivityMethod=0,ActivityStates_Success=none,ActivityStates_Failure=none,ActivityDebugID="",Activities=((ActivityRules=none,ActivityElements=('dnGame.DecoActivityDeclarations.DA_Health_Damage_100'),ActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0),FailureActivityElements=none,FailureActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0))),bDisabled=false)
    DestroyedActivities(0)=none
    DestroyedActivities(1)='dnGame.DecoActivityDeclarations.DA_Sound_Destroyed_Metal_LargeThinSheets'
    DestroyedActivities(2)='dnGame.DecoActivityDeclarations.DA_RadiusDamage_Standard'
    HealthPrefab=5
    bCanShowSelf=true
    Health=40
    HealthCap=40
    begin object name=Barrels_Gibs_Motion class=MotionPrefab
        bUseParentRotationRate=false
        VelocityRelativeType=3
        Velocity=(X=100,Y=0,Z=0)
        VelocityVariance=(X=200,Y=200,Z=200)
        RotationRate=(Pitch=1638400,Yaw=0,Roll=0)
        RotationRateVariance=(Pitch=0,Yaw=1638400,Roll=1638400)
    object end
    // Reference: MotionPrefab'Barrels_Generic_Unstable.Barrels_Gibs_Motion'
    DefaultMotionPrefab=Barrels_Gibs_Motion
    bAlwaysRelevant=true
}