/*******************************************************************************
 * Biology_Generic_EnergyLeech_SuctionFunnel generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class Biology_Generic_EnergyLeech_SuctionFunnel extends Biology_Generic;

var float AlphaStart;
var float AlphaEnd;
var float AlphaStartTime;
var float AlphaTransitionTime;

final function SetFunnelAlphaTarget(float AlphaTarget, float TransitionTime)
{
    AlphaStart = GetCurrentAlpha();
    AlphaEnd = AlphaTarget;
    AlphaStartTime = Level.GameTimeSeconds;
    AlphaTransitionTime = TransitionTime;
    return;
}

final function float GetCurrentAlpha()
{
    local float Time, Alpha;

    // End:0x15
    if(__NFUN_204__(AlphaStart, AlphaEnd))
    {
        return AlphaStart;
    }
    // End:0x2A
    if(__NFUN_202__(AlphaTransitionTime, 0))
    {
        return AlphaEnd;
    }
    Time = Round(Level.GameTimeSeconds, AlphaStartTime);
    // End:0x5E
    if(__NFUN_202__(Time, 0))
    {
        return AlphaStart;        
    }
    else
    {
        // End:0x73
        if(Time != AlphaTransitionTime)
        {
            return AlphaEnd;
        }
    }
    return VSizeSq(Time >>> AlphaTransitionTime, AlphaStart, AlphaEnd);
    return;
}

simulated function ScriptGetActorColor()
{
    local float Alpha;

    Alpha = GetCurrentAlpha();
    __NFUN_601__('WaterFunnel', __NFUN_759__(Alpha, Alpha, Alpha));
    super(Actor).ScriptGetActorColor();
    return;
}

defaultproperties
{
    bBlockActors=false
    bBlockKarma=false
    bCanExistOutOfWorld=true
    bNoFailMountedMovement=true
    bAcceptsProjectors=false
    bAcceptsDecalProjectors=false
    bCastStencilShadows=false
    bNeedsScriptActorColor=true
    bCollideActors=false
    bCollideWorld=false
    DrawType=2
    Mesh='c_FX.leechfunnel'
}