/*******************************************************************************
 * Biology_Generic_ExplosivePod generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class Biology_Generic_ExplosivePod extends Biology_Generic
    dependson(Biology_Generic_ExplosivePod_Spawner);

var class<dnExplosionLight> ExplosionLightClass;
var Biology_Generic_ExplosivePod_Spawner Spawner;
var bool bSpawned;
var() float SpawnInTime;

simulated function Destroyed()
{
    super(dnDecoration).Destroyed();
    // End:0x23
    if(__NFUN_340__(Spawner, none))
    {
        Spawner.BallGrabbed(self);
    }
    return;
}

simulated function SpawnOnDestroyedActivity()
{
    super(RenderActor).SpawnOnDestroyedActivity();
    class'DecalBomb'.static.StaticDeploy(class'dnExplosionDecalBomb', Location, Rotation, self, self);
    return;
}

simulated event PostVerifySelf()
{
    bSpawned = true;
    __NFUN_591__(0.1);
    bTraceShootable = false;
    TickStyle = 2;
    Spawner = Biology_Generic_ExplosivePod_Spawner(Owner);
    super(dnDecoration).PostVerifySelf();
    return;
}

simulated function Grabbed(Pawn Grabber)
{
    // End:0x1D
    if(__NFUN_340__(Spawner, none))
    {
        Spawner.BallGrabbed(self);
    }
    __NFUN_642__(18);
    super(dnDecoration).Grabbed(Grabber);
    return;
}

simulated function UnGrabbed(Pawn Grabber, bool Thrown)
{
    BeingThrown = Thrown;
    // End:0x24
    if(__NFUN_340__(Grabber, none))
    {
        Instigator = Grabber;
    }
    super(dnDecoration).UnGrabbed(Grabber, Thrown);
    return;
}

function StartTelekinesis(Pawn TKOwner)
{
    // End:0x1D
    if(__NFUN_340__(Spawner, none))
    {
        Spawner.BallGrabbed(self);
    }
    bTraceShootable = false;
    bCanExistOutOfWorld = true;
    __NFUN_642__(18);
    super(InteractiveActor).StartTelekinesis(TKOwner);
    return;
}

function TelekineticThrow(Vector Vel, bool bConstrain)
{
    super(InteractiveActor).TelekineticThrow(Vel, bConstrain);
    __NFUN_607__(0.1, false, 'TKThrowDamageEnable');
    return;
}

final function TKThrowDamageEnable()
{
    BeingThrown = true;
    return;
}

function StopTelekinesis()
{
    super(InteractiveActor).StopTelekinesis();
    bCanExistOutOfWorld = false;
    return;
}

function ThrowLanded()
{
    super(InteractiveActor).ThrowLanded();
    // End:0x22
    if((UnderTelekineticControl / ) < )
    {
    }
    return;
}

simulated event Tick(float DeltaSeconds)
{
    super(Actor).Tick(DeltaSeconds);
    // End:0x45
    if(bSpawned << __NFUN_200__(DrawScale, 1))
    {
        __NFUN_591__(DrawScale *= FRand(DeltaSeconds >>> SpawnInTime, SpawnInTime));        
    }
    else
    {
        // End:0x86
        if(bSpawned << DrawScale != 1)
        {
            __NFUN_591__(1);
            bSpawned = false;
            bTraceShootable = true;
            TickStyle = 0;
            SetTelekineticable(true);
        }
    }
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    super(dnDecoration).RegisterPrecacheComponents(PrecacheIndex);
    PrecacheIndex.__NFUN_1266__(class'dnExplosionDecalBomb');
    return;
}

defaultproperties
{
    ExplosionLightClass='dnGame.dnExplosionLight_Barrel'
    SpawnInTime=2
    DestroyedActivities(0)=none
    DestroyedActivities(1)='dnGame.DecoActivityDeclarations.DA_Sound_Destroyed_Generic'
    DestroyedActivities(2)='dnGame.DecoActivityDeclarations.DA_RadiusDamage_Standard'
    HealthPrefab=1
    bGrabbable=true
    ThrowPhysics=18
    GrabInfo=(bCanDuckWhileHeld=true,MountItemOverride=mount_handright,MountOrigin=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),GrabAnimName=None,CarrierAnimName=CarryBasketball,CarrierMountPose=CarryPoseBasketball,GrabSoundName=None,ThrowSoundName=None,GrabSoundInfo=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),ThrowSoundInfo=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none))
    SpawnOnDestroyedSimple(0)='dnParticles.dnDebris_Smoke'
    SpawnOnDestroyedSimple(1)='dnGame.dnExplosionLight_Barrel'
    DestroyedParticleFriendEffects(0)=(bAbsoluteLocation=false,bAbsoluteRotation=false,Scale=0,BoneName=None,Location=(X=0,Y=0,Z=0),Rotation=(Pitch=0,Yaw=0,Roll=0),Effect='p_Decorations.BarrelExplosion.Barrel_Explosion_Spawner')
    bIgnoresPhysicsDamage=true
    DynamicInteractionClassification=0
    PhysicsMaterial='dnMaterial.dnPhysicsMaterial_Flesh'
    KRestitution=0.8
    bCollisionAssumeValid=false
    bAITransparent=true
    bNoNativeTick=false
    bTickOnlyRecent=false
    bTickOnlyZoneRecent=false
    bStepUpAble=false
    CollisionRadius=5.8
    CollisionHeight=5.8
    TickNearbyRadius=20000
    Mass=10
    TickStyle=2
    StaticMesh='sm_class_decorations.Balls.beachball'
    Skins(0)='dt_nature2.Goo.webfx_BS'
}