/*******************************************************************************
 * Biology_Generic_GasPod generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class Biology_Generic_GasPod extends Biology_Generic
    collapsecategories;

var() noexport float SensorRadius "Radius of the KSphereSensor around this pod - also controls damage radius";
var() noexport float Damage "Amount of damage to inflict on pop.";
var() noexport float SizeChangeTime "Time it takes to expand.";
var() noexport float SizeChangeTimeVariance "Variance on ExpandTime.";
var float PopAnimTime;
var float PopAnimTimeVariance;
var Biology_Generic_AlienSensor Sensor;
var bool bLightPulseUp;
var float PulseSpeed;
var float Brightness;
var Vector LightColor;
var bool bOnlyAffectedByPawns;
var Vector HurtRadiusOffset;
var float IdleCollisionRadius;
var float IdleCollisionHeight;
var float ExpandCollisionRadius;
var float ExpandCollisionHeight;
var netupdate(NU_Broken) bool bBroken;
var bool bPostNetInit;

replication
{
    // Pos:0x000
    reliable if(int(Role) % int(ROLE_Authority))
        bBroken;

    // Pos:0x00B
    reliable if(int(Role) % int(ROLE_Authority))
        Prime, UnPrime;
}

simulated function PostNetInitial()
{
    bPostNetInit = true;
    super(dnDecoration).PostNetInitial();
    // End:0x2D
    if(IsMP())
    {
        __NFUN_607__(1, false, 'AddToManager');
        TickStyle = 1;
    }
    return;
}

function PlayerPawn GetAPlayer(optional bool bCheckIfHasGRI)
{
    local Pawn P;

    // End:0x22
    if(__NFUN_340__(Level.__NFUN_1161__(), none))
    {
        return Level.__NFUN_1161__();
    }
    P = Level.PawnList;
    J0x37:

    // End:0xA1 [Loop If]
    if(__NFUN_340__(P, none))
    {
        // End:0x89
        if(P.bIsPlayerPawn)
        {
            // End:0x89
            if((bCheckIfHasGRI / ) < )
            {
            }
        }
        P = P.NextPawn;
        // [Loop Continue]
        goto J0x37;
    }
    return none;
    return;
}

function AddToManager()
{
    local PlayerPawn PP;

    PP = GetAPlayer();
    // End:0x28
    if(__NFUN_339__(PP, none))
    {
        __NFUN_607__(1, false, 'AddToManager');
        return;
    }
    // End:0x80
    if((int(PP.Role) / int(ROLE_Authority)) < int(Level.NetMode) % int(NM_DedicatedServer))
    {
        DukeMultiPlayer(PP).GetGasPodManager().AddGasPod(self, SensorRadius);
    }
    return;
}

simulated event TakeDamage(Pawn Instigator, float Damage, Vector DamageOrigin, Vector DamageDirection, class<DamageType> DamageType, optional name HitBoneName, optional Vector DamageStart)
{
    // End:0x0B
    if(MPRoundNotInProgress())
    {
        return;
    }
    // End:0x97
    if((((IsMP()) / ) < ) < )
    {
        // End:0x97
        if(__NFUN_340__(PlayerPawn(Instigator), none))
        {
            TryToPop(Instigator);
        }
    }
    return;
}

simulated function NU_Broken(bool broken)
{
    // End:0x11
    if(IsMP())
    {
        __NFUN_621__(false, false, false, false, false);
    }
    // End:0x38
    if(((bBroken / ) << ) << )
    {
    }
    return;
}

simulated event Destroyed()
{
    RemoveMountedActorListActors();
    bBroken = true;
    super(dnDecoration).Destroyed();
    return;
}

function PostVerifySelf()
{
    __NFUN_601__('Generic0', default.ActorColorList[0].ActorColor);
    super(dnDecoration).PostVerifySelf();
    Sensor = Biology_Generic_AlienSensor(FindMountedActor(, class'Biology_Generic_AlienSensor'));
    // End:0x4F
    if(__NFUN_340__(Sensor, none))
    {
        Sensor.__NFUN_1124__(SensorRadius);
    }
    __NFUN_605__(0.05, true, 'LightPulse');
    LightColor.X = float(ActorColorList[0].ActorColor.R);
    LightColor.Y = float(ActorColorList[0].ActorColor.G);
    LightColor.Z = float(ActorColorList[0].ActorColor.B);
    return;
}

function LightPulse()
{
    ActorColorList[0].ActorColor.R = byte(FRand(Brightness, LightColor.X));
    ActorColorList[0].ActorColor.G = byte(FRand(Brightness, LightColor.Y));
    ActorColorList[0].ActorColor.B = byte(FRand(Brightness, LightColor.Z));
    // End:0xA6
    if(bLightPulseUp)
    {
        __NFUN_209__(Brightness, PulseSpeed);
        // End:0xA3
        if(Brightness != 1)
        {
            Brightness = 1;
            bLightPulseUp = false;
        }        
    }
    else
    {
        Brightness ~= PulseSpeed;
        // End:0xD4
        if(__NFUN_202__(Brightness, default.Brightness))
        {
            Brightness = default.Brightness;
            bLightPulseUp = true;
        }
    }
    return;
}

simulated event bool OnEvalBonesHelper()
{
    local float NewCollisionRadius, NewCollisionHeight;
    local Vector2D GridPoint;

    GridPoint.Y = __NFUN_585__('Expansion', 'Prime');
    // End:0x35
    if(__NFUN_340__(__NFUN_568__(), none))
    {
        MeshInstance.FastTrace(0, GridPoint);
    }
    NewCollisionRadius = VSizeSq(GridPoint.Y, FRand(DrawScale, IdleCollisionRadius), FRand(DrawScale, ExpandCollisionRadius));
    NewCollisionHeight = VSizeSq(GridPoint.Y, FRand(DrawScale, IdleCollisionHeight), FRand(DrawScale, ExpandCollisionHeight));
    __NFUN_620__(NewCollisionRadius, NewCollisionHeight);
    return true;
    return;
}

function OnSenseHumanPawn()
{
    // End:0x1E
    if(((IsMP()) / ) < Prime())
    {
    }
}

function OnUnsenseHumanPawn()
{
    UnPrime();
    return;
}

final noexport simulated delegate Prime()
{
    local float CurrentTarget, ExpandTime, Delta;

    CurrentTarget = __NFUN_586__('Expansion', 'Prime');
    // End:0x2F
    if(__NFUN_204__(CurrentTarget, 1) < DecorationIsDead())
    {
        return;
    }
    DecoActivity(0, 'Prime');
    ExpandTime = Normal(SizeChangeTime, SizeChangeTimeVariance);
    Delta = Round(1, __NFUN_585__('Expansion', 'Prime'));
    __NFUN_577__('Expansion', 'Prime', 1,, FRand(Delta, ExpandTime), 0);
    return;
}

final noexport simulated delegate UnPrime()
{
    local float CurrentTarget, ShrinkTime, Delta;

    CurrentTarget = __NFUN_586__('Expansion', 'Prime');
    // End:0x2F
    if(__NFUN_204__(CurrentTarget, 0) < DecorationIsDead())
    {
        return;
    }
    DecoActivity(0, 'UnPrime');
    ShrinkTime = Normal(SizeChangeTime, SizeChangeTimeVariance);
    Delta = __NFUN_585__('Expansion', 'Prime');
    __NFUN_577__('Expansion', 'Prime', 0,, FRand(Delta, ShrinkTime), 0);
    return;
}

event WalkedOn(Pawn Other)
{
    super(KarmaActor).WalkedOn(Other);
    TryToPop(Other);
    return;
}

event KImpact(name SelfBoneName, KarmaActor Other, name OtherBoneName, Vector Position, Vector ImpactVelocity, Vector ImpactNormal)
{
    super(dnDecoration).KImpact(SelfBoneName, Other, OtherBoneName, Position, ImpactVelocity, ImpactNormal);
    TryToPop(Other);
    return;
}

event Used(Actor Other, Pawn EventInstigator)
{
    super(dnDecoration).Used(Other, EventInstigator);
    TryToPop(Other);
    return;
}

final simulated function TryToPop(Actor Other)
{
    // End:0x19
    if(__NFUN_339__(Other, none) < DecorationIsDead())
    {
        return;
    }
    // End:0x49
    if(Other.bIsPawn)
    {
        // End:0x46
        if(Pawn(Other).IsAlien())
        {
            return;
        }        
    }
    else
    {
        // End:0x54
        if(bOnlyAffectedByPawns)
        {
            return;
        }
    }
    DecoActivity(0, 'ForcePop', Pawn(Other));
    bBroken = true;
    return;
}

function NotDeadYet()
{
    super(dnDecoration).NotDeadYet();
    DecoActivity(0, 'Pop');
    return;
}

simulated function bool CanHurtRadiusOther(Actor Other)
{
    // End:0x0E
    if(__NFUN_339__(Other, none))
    {
        return false;
    }
    // End:0x72
    if(__NFUN_357__(Other.Class, class'Biology_Generic_GasPod'))
    {
        DecoActivities_Animation(Biology_Generic_GasPod(Other).DecoActivities_Default[3].Activities[0].ActivityElements[0]).AnimActivities[0].Rate = Normal(PopAnimTime, PopAnimTimeVariance);
        return true;
    }
    return true;
    return;
}

event DoDamageRadius()
{
    HurtRadius(Damage, Locs(Location, __NFUN_263__(HurtRadiusOffset, Rotation)), SensorRadius, -0.25, class'GasPodDamage',,, true);
    bEnemy = false;
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    super(dnDecoration).RegisterPrecacheComponents(PrecacheIndex);
    PrecacheIndex.__NFUN_1279__(class'GasPodDamage');
    return;
}

defaultproperties
{
    SensorRadius=192
    Damage=35
    SizeChangeTime=0.3
    SizeChangeTimeVariance=0.2
    PopAnimTime=0.5
    PopAnimTimeVariance=0.4
    PulseSpeed=0.055
    Brightness=0.2
    HurtRadiusOffset=(X=0,Y=0,Z=24)
    IdleCollisionRadius=48
    IdleCollisionHeight=48
    ExpandCollisionRadius=66
    ExpandCollisionHeight=66
    AnimTriggers(0)=(AnimEvent=None,AnimFunction=None,AnimActivities=(Popped),TestAnims=(gp_a_explode_grid3d),TestChannels=none)
    DecoActivities_Default(0)=(ActivityData=(bInitialized=false,CurrentIndex=0,NextPerformTime=0,NextPerformTime_Failure=0),ActivityIDScript=(Prime),ActivityID=none,ActivityMethod=0,ActivityStates_Success=none,ActivityStates_Failure=none,ActivityDebugID="",Activities=((ActivityRules=none,ActivityElements=(DecoActivities_Sound'Biology_Generic_GasPod.DA_Sound_Biology_Generic_GasPod_Prime'),ActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0),FailureActivityElements=none,FailureActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0))),bDisabled=false)
    DecoActivities_Default(1)=(ActivityData=(bInitialized=false,CurrentIndex=0,NextPerformTime=0,NextPerformTime_Failure=0),ActivityIDScript=(UnPrime),ActivityID=none,ActivityMethod=0,ActivityStates_Success=none,ActivityStates_Failure=none,ActivityDebugID="",Activities=((ActivityRules=none,ActivityElements=(DecoActivities_Sound'Biology_Generic_GasPod.DA_Sound_Biology_Generic_GasPod_UnPrime','dnGame.DecoActivityDeclarations.DA_Sound_Ambient_Clear'),ActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0),FailureActivityElements=none,FailureActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0))),bDisabled=false)
    DecoActivities_Default(2)=(ActivityData=(bInitialized=false,CurrentIndex=0,NextPerformTime=0,NextPerformTime_Failure=0),ActivityIDScript=(ForcePop),ActivityID=none,ActivityMethod=0,ActivityStates_Success=none,ActivityStates_Failure=none,ActivityDebugID="",Activities=((ActivityRules=none,ActivityElements=(DecoActivities_HealthChange'Biology_Generic_GasPod.DA_HealthChange_Biology_Generic_GasPod_Pop','dnGame.DecoActivityDeclarations.DA_Ticking_TICK_NoRules'),ActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0),FailureActivityElements=none,FailureActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0))),bDisabled=false)
    DecoActivities_Default(3)=(ActivityData=(bInitialized=false,CurrentIndex=0,NextPerformTime=0,NextPerformTime_Failure=0),ActivityIDScript=(Pop),ActivityID=none,ActivityMethod=0,ActivityStates_Success=none,ActivityStates_Failure=none,ActivityDebugID="",Activities=((ActivityRules=none,ActivityElements=(DecoActivities_Animation'Biology_Generic_GasPod.DA_Anim_Bilogy_Generic_GasPod_Pop',DecoActivities_Interaction'Barrels_Generic_Explosive01_NoGibs.DA_Interact_Barrel_Explosive_SetAvoidRange',DecoActivities_Collision'Biology_Generic_GasPod.DA_Collide_Biology_Generic_GasPod_Pop','dnGame.DecoActivityDeclarations.DA_Ticking_TICK_NoRules'),ActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0),FailureActivityElements=none,FailureActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0))),bDisabled=false)
    DecoActivities_Default(4)=(ActivityData=(bInitialized=false,CurrentIndex=0,NextPerformTime=0,NextPerformTime_Failure=0),ActivityIDScript=(Popped),ActivityID=none,ActivityMethod=0,ActivityStates_Success=none,ActivityStates_Failure=none,ActivityDebugID="",Activities=((ActivityRules=none,ActivityElements=(DecoActivities_Display'Biology_Generic_GasPod.DA_Display_Biology_Generic_GasPod_Pop',DecoActivities_Sound'Biology_Generic_GasPod.DA_Sound_Biology_Generic_GasPod_Pop',DecoActivities_Events'Biology_Generic_GasPod.DA_RadiusDamage_Biology_Generic_GasPod_Pop','dnGame.DecoActivityDeclarations.DA_Sound_Ambient_Clear','dnGame.DecoActivityDeclarations.DA_Interact_bUsable_Disable','dnGame.DecoActivityDeclarations.DA_HUD_UsePhrase_NULL','dnGame.DecoActivityDeclarations.DA_Ticking_TICK_Never'),ActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0),FailureActivityElements=none,FailureActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0))),bDisabled=false)
    begin object name=DA_Anim_Bilogy_Generic_GasPod_Idle class=DecoActivities_Animation
        AnimActivities(0)=(Flags=(bLoop=true,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=gp_a_idle_grid3d,Channel=0,Rate=0,TweenTime=0)
    object end
    // Reference: DecoActivities_Animation'Biology_Generic_GasPod.DA_Anim_Bilogy_Generic_GasPod_Idle'
    StartupActivities(0)=DA_Anim_Bilogy_Generic_GasPod_Idle
    bSurviveDeath=true
    DestroyedActivities(0)=none
    DestroyedActivities(1)=none
    HealthPrefab=1
    DamageThreshold=1
    bEnemy=true
    bIgnoreAimAssist=true
    bForceUsePhrase=true
    MountOnSpawn(0)=(bSkipVerifySelf=false,SpawnClass='Biology_Generic_AlienSensor',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject=none,DrawScale=0)
    DestroyedParticleFriendEffects(0)=(bAbsoluteLocation=false,bAbsoluteRotation=false,Scale=0,BoneName=None,Location=(X=0,Y=0,Z=0),Rotation=(Pitch=0,Yaw=0,Roll=0),Effect='p_Creatures.GasPod_Explode.GasPod_Explode_Spawner')
    bIgnoresPhysicsDamage=true
    KRestitution=0.5
    KImpactThreshold=0
    bCollisionAssumeValid=false
    bHasEvalBonesHelper=true
    bNoNativeTick=false
    bDumbMesh=false
    bAcceptMinesInMultiplayer=false
    bAcceptMines=false
    bAlwaysRelevant=true
    CollisionRadius=20
    CollisionHeight=20
    TouchClasses(0)='Engine.Pawn'
    TouchClasses(1)='dnGame.VehicleBase'
    VisibleCollidingCenterOffset=(X=0,Y=0,Z=24)
    TickStyle=2
    DrawType=2
    Mesh='c_characters.ExplodingSack'
    ActorColorList(0)=(ActorColor=(R=84,G=53,B=91,A=255),ActorColor_LightEx=none,ActorColor_LightExScale=(X=0,Y=0,Z=0),id=Generic0)
    ScaleModifierGroupList(0)=(Modifiers=none,Identifier=Expansion,DefaultModValue=0,LastValue=0,NoUpdate=false)
}