/*******************************************************************************
 * Biology_Generic_ShrinkPod generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class Biology_Generic_ShrinkPod extends Biology_Generic
    collapsecategories;

var() noexport float ShrinkTime "Time to shrink player. If less than 0, then shrink forever";
var() noexport float ParticleTimer "How often to emit particle effect";
var() noexport float ParticleCoolDown "Cooldown in seconds before reimmitting particles";
var netupdate(NU_CoolingDown) bool CoolingDown;
var SoftParticleSystem ParticleSystem;
var SoftParticleSystem ParticleBurstSystem;
var() class<SoftParticleSystem> ParticleSystemClass;
var() class<SoftParticleSystem> ParticleBurstSystemClass;

replication
{
    // Pos:0x000
    reliable if(int(Role) % int(ROLE_Authority))
        CoolingDown;
}

simulated function NU_CoolingDown(bool in_CoolingDown)
{
    // End:0x12
    if(in_CoolingDown)
    {
        TurnParticlesOff();        
    }
    else
    {
        TurnParticlesOn();
    }
    return;
}

simulated event PostVerifySelf()
{
    SpawnMountedParticleSystems();
    super(dnDecoration).PostVerifySelf();
    return;
}

simulated event PostBeginPlay()
{
    super(dnDecoration).PostBeginPlay();
    ParticleBurstSystem = SoftParticleSystem(FindMountedActor('BurstPodFX'));
    ParticleSystem = SoftParticleSystem(FindMountedActor('MainPodFX'));
    return;
}

simulated function SpawnMountedParticleSystems()
{
    local int Index, i;

    // End:0xCB
    if(__NFUN_340__(ParticleSystemClass, none))
    {
        Index = MountOnSpawn.Add(1);
        MountOnSpawn[Index].SpawnClass = ParticleSystemClass;
        MountOnSpawn[Index].MountPrefab.bSurviveDismount = true;
        MountOnSpawn[Index].MountPrefab.MountOrigin.X = 1;
        MountOnSpawn[Index].MountPrefab.MountOrigin.Y = 0;
        MountOnSpawn[Index].MountPrefab.MountOrigin.Z = 7;
        MountOnSpawn[Index].MountPrefab.ForceTag = __NFUN_343__("MainPodFX");
    }
    // End:0x197
    if(__NFUN_340__(ParticleBurstSystemClass, none))
    {
        Index = MountOnSpawn.Add(1);
        MountOnSpawn[Index].SpawnClass = ParticleBurstSystemClass;
        MountOnSpawn[Index].MountPrefab.bSurviveDismount = true;
        MountOnSpawn[Index].MountPrefab.MountOrigin.X = 1;
        MountOnSpawn[Index].MountPrefab.MountOrigin.Y = 0;
        MountOnSpawn[Index].MountPrefab.MountOrigin.Z = 7;
        MountOnSpawn[Index].MountPrefab.ForceTag = __NFUN_343__("BurstPodFX");
    }
    // End:0x1E1
    if(int(Level.NetMode) % int(NM_Client))
    {
        i = -- string(MountOnSpawn);        
        J0x1BE:

        // End:0x1E1 [Loop If]
        if(i / 0)
        {
            __NFUN_837__(MountOnSpawn[i]);
            // [Loop Continue]
            i -= ;
        }
    }
    return;
}

event Touch(Actor Other)
{
    super(dnDecoration).Touch(Other);
    PodAction(Other);
    return;
}

event Bump(Actor Other)
{
    super(dnDecoration).Bump(Other);
    PodAction(Other);
    return;
}

function PodAction(Actor Other)
{
    local Pawn P;

    // End:0xF4
    if(Other.bIsPawn << CoolingDown / )
    {
        // End:0xF4
        if(((IsMP()) / ) < )
        {
            {
                ParticleBurstSystem.Trigger(none, none);
                CoolingDown = true;
                ParticleSystem.Enabled = false;
                // End:0xD9
                if(IsMP())
                {
                    ParticleCoolDown = 0;
                }
                __NFUN_607__(ParticleCoolDown, false, 'TurnParticlesOn');
                DecoActivity(0, 'Play_Idle_Active');
            }
        }
    }
    return;
}

simulated function TurnParticlesOn()
{
    local int i;

    ParticleSystem.Enabled = true;
    CoolingDown = false;
    DecoActivity(0, 'Play_Idle');
    // End:0x74
    if(IsMP())
    {
        J0x30:

        // End:0x74 [Loop If]
        if(-i)
        {            
            // End:0x6A
            if(Touching[i].bIsPlayerPawn)
            {
                PodAction(Touching[i]);
            }
            // [Loop Continue]
            i += ;
        }
    }
    return;
}

simulated function TurnParticlesOff()
{
    ParticleBurstSystem.Trigger(none, none);
    ParticleSystem.Enabled = false;
    CoolingDown = true;
    DecoActivity(0, 'Play_Idle_Active');
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    super(dnDecoration).RegisterPrecacheComponents(PrecacheIndex);
    PrecacheIndex.__NFUN_1266__(ParticleSystemClass);
    PrecacheIndex.__NFUN_1266__(ParticleBurstSystemClass);
    PrecacheIndex.__NFUN_1269__(class'Pawn'.default.ShrinkingMaterial);
    PrecacheIndex.__NFUN_1276__(class'Pawn'.default.ShrinkSound);
    PrecacheIndex.__NFUN_1276__(class'Pawn'.default.ExpandSound);
    PrecacheIndex.__NFUN_1266__(class'dnScreenSplatter_Blood');
    PrecacheIndex.__NFUN_1279__(class'ShrunkSmashDamage');
    PrecacheIndex.__NFUN_1277__(class'DukePlayer'.default.VoicePack, 'Stomp_Squish');
    PrecacheIndex.__NFUN_1277__(class'DukePlayer'.default.VoicePack, 'StompLines');
    return;
}

defaultproperties
{
    ShrinkTime=-1
    ParticleTimer=0.25
    ParticleCoolDown=1
    ParticleSystemClass='p_Decorations.ShrinkPod.ShrinkPod_Main'
    ParticleBurstSystemClass='p_Decorations.podfx.ShrinkPodBurstFX'
    DecoActivities_Default(0)=(ActivityData=(bInitialized=false,CurrentIndex=0,NextPerformTime=0,NextPerformTime_Failure=0),ActivityIDScript=(Play_Idle_Active),ActivityID=none,ActivityMethod=0,ActivityStates_Success=none,ActivityStates_Failure=none,ActivityDebugID="",Activities=((ActivityRules=none,ActivityElements=(DecoActivities_Animation'Biology_Generic_ShrinkPod.DA_Anim_ShrinkPod_IdleActive'),ActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0),FailureActivityElements=none,FailureActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0))),bDisabled=false)
    DecoActivities_Default(1)=(ActivityData=(bInitialized=false,CurrentIndex=0,NextPerformTime=0,NextPerformTime_Failure=0),ActivityIDScript=(Play_Idle),ActivityID=none,ActivityMethod=0,ActivityStates_Success=none,ActivityStates_Failure=none,ActivityDebugID="",Activities=((ActivityRules=none,ActivityElements=(DecoActivities_Animation'Biology_Generic_ShrinkPod.DA_Anim_ShrinkPod_Idle'),ActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0),FailureActivityElements=none,FailureActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0))),bDisabled=false)
    begin object name=DA_Anim_ShrinkPod_Idle class=DecoActivities_Animation
        AnimActivities(0)=(Flags=(bLoop=true,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=a_idle,Channel=0,Rate=0,TweenTime=0.2)
    object end
    // Reference: DecoActivities_Animation'Biology_Generic_ShrinkPod.DA_Anim_ShrinkPod_Idle'
    StartupActivities(0)=DA_Anim_ShrinkPod_Idle
    begin object name=DA_Sound_ShrinkPod_Ambience class=DecoActivities_Sound
        SoundNames(0)=ShrinkPod_Amb
    object end
    // Reference: DecoActivities_Sound'Biology_Generic_ShrinkPod.DA_Sound_ShrinkPod_Ambience'
    StartupActivities(1)=DA_Sound_ShrinkPod_Ambience
    bAcceptMeshAccurateMoveActorTrace=true
    CollisionRadius=17
    CollisionHeight=5
    TouchClasses(0)='Engine.PlayerPawn'
    DrawType=2
    PrePivot=(X=0,Y=0,Z=-1.7)
    Mesh='c_characters.ShrinkPad'
    ActorColorList(0)=(ActorColor=(R=255,G=255,B=255,A=255),ActorColor_LightEx=none,ActorColor_LightExScale=(X=0,Y=0,Z=0),id=Generic0)
}