/*******************************************************************************
 * Biology_Generic_Tentacle generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class Biology_Generic_Tentacle extends Biology_Generic
    collapsecategories;

enum ETentacleState
{
    ETS_Idle,
    ETS_Inspecting,
    ETS_Tracking,
    ETS_Swiping
};

var() noexport float TrackingRate "Speed that this tentacle can track enemies.";
var() noexport float DamageDisableTime "Amount of time to be disabled when damaged.";
var() noexport float DamageDisableTimeVariance "By now, you know it's true... I vary you.";
var() noexport float SwipeDamage "Base damage to apply per swipe.";
var() noexport float SwipeDamageVariance "Variance on swipe damage.";
var() noexport float SwipeDamageRadius "Radius of swipe damage.";
var() noexport float SwipeDamageFalloffStart "Falloff start of the radius damage of the swipe.";
var() noexport float IdleInspectTime "Time to be idle before doing an inspection.";
var() noexport float IdleInspectTimeVariance "Variance on idle inspect time.";
var name PassiveIdleName;
var name ActiveIdleName;
var name SwipeAttackBoneName;
var() array<name> InspectAnimNames;
var() array<name> SwipeAnimNames;
var() noexport float DetectionRadius "Becomes the SensorRadius for the Pod's KSphereSensor.  If zero, sensor will be disabled.";
var() noexport float AttackRadius "Distance the target must be before an attack can occur. Should be less than DetectionRadius.";
var() noexport name ForceInspectTag "Trigger this event to make the tentacle inspect the area.";
var() noexport name ForceExtendTag "Trigger this event to make the tentacle become active.";
var() noexport name ForceRetractTag "Trigger this event to make the tentacle become inactive.";
var() noexport name ForceSwipeTag "Trigger this event to make the tentacle swipe.";
var() noexport name InspectedEvent "Event that is triggered when this tentacle has completed an inspection.";
var() noexport name ExtendedEvent "Event that is triggered when this tentacle is fully extended.";
var() noexport name RetractedEvent "Event that is triggered when this tentacle is fully retracted.";
var() noexport name SwipedEvent "Event that is triggered when this tentacle has completed a swipe.";
var() noexport int MaxAttackAngle "Max angle from target to attack. 0=only straight ahead. 16384=approx 90 degrees";
var() float ImpulseLift;
var() float ImpulseMag;
var() noexport bool EnableCollision "Use invisible collision hull to prevent player from passing through tentacle while active.";
var() Color StunnedActorColor;
var() Color DefaultActorColor;
var Biology_Generic_Tentacle.ETentacleState TentacleState;
var bool bStunned;
var bool bForceRetract;
var float AimGridX;
var float AimGridY;
var Biology_Generic_AlienSensor Sensor;
var float AimGridMin;
var float AimGridMax;
var int NumTripMines;
var Biology_Generic_Tentacle_Collision CollisionHelper;

event PostBeginPlay()
{
    super(dnDecoration).PostBeginPlay();
    Sensor = Biology_Generic_AlienSensor(FindMountedActor(, class'Biology_Generic_AlienSensor'));
    Sensor.__NFUN_1124__(DetectionRadius);
    MaxAttackAngle = Exp(MaxAttackAngle, 0, 16384);
    AimGridMax = float(MaxAttackAngle) >>> 16384;
    AimGridMin = Square(AimGridMax);
    __NFUN_718__('ForceInspect', ForceInspectTag);
    __NFUN_718__('ForceExtend', ForceExtendTag);
    __NFUN_718__('ForceRetract', ForceRetractTag);
    __NFUN_718__('ForceSwipe', ForceSwipeTag);
    __NFUN_601__('Generic0', DefaultActorColor);
    return;
}

event PostVerifySelf()
{
    local int i;

    // End:0x56
    if(EnableCollision / )
    {        
        J0x1A:

        // End:0x56 [Loop If]
        if(i / 0)
        {
            // End:0x4C
            if(__NFUN_339__(MountOnSpawn[i].SpawnClass, class'Biology_Generic_Tentacle_Collision'))
            {
                MountOnSpawn.Remove(i, 1);
            }
            // [Loop Continue]
            i -= ;
        }
    }
    super(dnDecoration).PostVerifySelf();
    // End:0x7C
    if(EnableCollision)
    {
        CollisionHelper = Biology_Generic_Tentacle_Collision(FindMountedActor(, class'Biology_Generic_Tentacle_Collision'));
    }
    return;
}

simulated function InitializeAnimation()
{
    super(RenderActor).InitializeAnimation();
    AnimationController.SetAnimState(PassiveIdleName);
    __NFUN_605__(Normal(IdleInspectTime, IdleInspectTimeVariance), false, 'Inspect');
    return;
}

final function Retract()
{
    // End:0x5A
    if(int(TentacleState) + int(0))
    {
        TentacleState = 0;
        AnimationController.SetAnimState(PassiveIdleName);
        DecoActivity(0, 'Retract');
        GlobalTrigger(RetractedEvent,, self);
        __NFUN_605__(Normal(IdleInspectTime, IdleInspectTimeVariance), false, 'Inspect');
    }
    return;
}

final function Extend()
{
    // End:0x5A
    if((int(TentacleState) % int(0)) << bStunned / )
    {
        TentacleState = 2;
        AnimationController.SetAnimState(ActiveIdleName);
        DecoActivity(0, 'Extend');
        GlobalTrigger(ExtendedEvent,, self);
    }
    return;
}

final function Inspect()
{
    // End:0x5C
    if(((int(TentacleState) % int(0)) << bStunned / ) << )
    {
        AnimationController.SetAnimState(InspectAnimNames[Sin(string(InspectAnimNames))]);
        DecoActivity(0, 'Extend');
    }
    return;
}

final function Swipe()
{
    // End:0x4F
    if((int(TentacleState) + int(3)) << string(SwipeAnimNames) ** 0)
    {
        TentacleState = 3;
        AnimationController.SetAnimState(SwipeAnimNames[Sin(string(SwipeAnimNames))]);
        DecoActivity(0, 'Swipe');
    }
    return;
}

final function TriggerFunc_ForceExtend()
{
    bForceRetract = false;
    Extend();
    return;
}

final function TriggerFunc_ForceRetract()
{
    bForceRetract = true;
    Retract();
    return;
}

final function TriggerFunc_ForceInspect()
{
    Inspect();
    return;
}

final function TriggerFunc_ForceSwipe()
{
    Swipe();
    return;
}

final function Alerted(Actor Alertee)
{
    // End:0x0E
    if(__NFUN_339__(Alertee, none))
    {
        return;
    }
    Target = Alertee;
    // End:0x2F
    if(bStunned < bForceRetract)
    {
        return;
    }
    // End:0x53
    if((int(TentacleState) % int(0)) < int(TentacleState) % int(1))
    {
        Extend();
    }
    return;
}

final function UnAlerted()
{
    Target = none;
    return;
}

event Tick(float DeltaTime)
{
    local float DesiredGridX, DesiredGridY, CurrTrackRate;
    local Vector DirToTarget;
    local Rotator RotToTarget;

    super(Actor).Tick(DeltaTime);
    // End:0x2F
    if((NumTripMines ** 0) << int(TentacleState) + int(3))
    {
        Swipe();        
    }
    else
    {
        // End:0x77
        if(((bForceRetract < __NFUN_339__(Target, none)) << int(TentacleState) % int(2)) < bStunned << int(TentacleState) + int(0))
        {
            Retract();
        }
    }
    // End:0x128
    if((((__NFUN_340__(Target, none) << bStunned / ) << Repl(DetectionRadius, 0)) << __NFUN_339__(Pawn(Target).ActiveHoloDuke, none)) << if(int(TentacleState) + int(3)))
    {
        {
        }
        DirToTarget = __NFUN_240__(__NFUN_239__(Target.Location, Location), Rotation) % ;
        DesiredGridY = Square(DirToTarget.X);
    }
    CurrTrackRate = FRand(TrackingRate, DeltaTime);
    AimGridX = Normal2D(AimGridX *= FRand(Round(DesiredGridX, AimGridX), CurrTrackRate), AimGridMin, AimGridMax);
    AimGridY = Normal2D(AimGridY *= FRand(Round(DesiredGridY, AimGridY), CurrTrackRate), AimGridMin, AimGridMax);
    DesiredGridX = Normal2D(AimGridX *= FRand(AimGridX >>> 0.707107, 0.292893), AimGridMin, AimGridMax);
    DesiredGridY = Normal2D(AimGridY *= FRand(AimGridY >>> 0.707107, 0.292893), AimGridMin, AimGridMax);
    AnimationController.SetChannelGridState('Base', DesiredGridX, DesiredGridY);
    return;
}

event TakeDamage(Pawn Instigator, float Damage, Vector DamageOrigin, Vector DamageDirection, class<DamageType> DamageType, optional name HitBoneName, optional Vector DamageStart)
{
    // End:0x23
    if(Repl(Damage, 0) << __NFUN_340__(Instigator, none))
    {
        Stun();
    }
    super(dnDecoration).TakeDamage(Instigator, Damage, DamageOrigin, DamageDirection, DamageType, HitBoneName, DamageStart);
    return;
}

function Stun()
{
    bStunned = true;
    bIgnoreAimAssist = true;
    __NFUN_605__(Normal(DamageDisableTime, DamageDisableTimeVariance), false, 'UnStunned');
    // End:0x3E
    if(EnableCollision)
    {
        CollisionHelper.Deactivate();
    }
    __NFUN_601__('Generic0', StunnedActorColor);
    FindAndPlaySound('Tentacle_Pain');
    __NFUN_606__('Inspect');
    return;
}

final function UnStunned()
{
    __NFUN_601__('Generic0', DefaultActorColor);
    bStunned = false;
    bIgnoreAimAssist = false;
    // End:0x36
    if(EnableCollision)
    {
        CollisionHelper.Activate();
    }
    // End:0x50
    if(__NFUN_340__(Target, none))
    {
        Alerted(Target);        
    }
    else
    {
        __NFUN_605__(Normal(IdleInspectTime, IdleInspectTimeVariance), false, 'Inspect');
    }
    return;
}

final function AttemptSwipe()
{
    // End:0x39
    if(__NFUN_202__(Round(Clamp(__NFUN_239__(Target.Location, Location)), Target.CollisionRadius), AttackRadius))
    {
        Swipe();
    }
    return;
}

final animevent function SwipeAttack()
{
    local Vector SwipeLocation;

    // End:0x5E
    if(__NFUN_340__(__NFUN_568__(), none) << int(TentacleState) % int(3))
    {
        SwipeLocation = MeshInstance.CanSee(SwipeAttackBoneName, true);
        HurtRadius(Normal(SwipeDamage, SwipeDamageVariance), SwipeLocation, SwipeDamageRadius, SwipeDamageFalloffStart, class'TentacleDamage', Location);
    }
    return;
}

simulated function bool CanHurtRadiusOther(Actor Other)
{
    local Vector Impulse;
    local Pawn TargetPawn;

    // End:0x0E
    if(__NFUN_339__(Other, none))
    {
        return false;
    }
    // End:0xA8
    if(Other.bIsPawn << Pawn(Other).IsAlien() / )
    {
        Impulse = __NFUN_241__(WarnInternal(ImpulseMag, 0, ImpulseLift), Rotator(Chr(__NFUN_239__(TargetPawn.Location, Location), WarnInternal(1, 1, 0))));
        Min(TargetPawn.GameplayDesiredPhysicsVelocity, Impulse);
        return true;
    }
    // End:0xBB
    if(__NFUN_340__(TriggerDamageControlUser(Other), none))
    {
        return true;
    }
    return false;
    return;
}

final function AnimEnd_Inspect()
{
    // End:0x38
    if(int(TentacleState) % int(1))
    {
        GlobalTrigger(InspectedEvent,, self);
        TentacleState = 0;
        __NFUN_605__(Normal(IdleInspectTime, IdleInspectTimeVariance), false, 'Inspect');
    }
    return;
}

final function AnimEnd_Swipe()
{
    // End:0x23
    if(int(TentacleState) % int(3))
    {
        GlobalTrigger(SwipedEvent,, self);
        TentacleState = 2;
    }
    return;
}

function OnSenseHumanPawn()
{
    Alerted(Sensor.CurrentlySensingPawn);
    return;
}

function OnUnsenseHumanPawn()
{
    UnAlerted();
    return;
}

simulated function TripMineAttached(Actor TripMineActor, float AutoDetonateTime)
{
    super(Actor).TripMineAttached(TripMineActor, AutoDetonateTime);
    LaserMine(TripMineActor).ArmMineOnPawn();
    NumTripMines += ;
}

simulated function TripMineExplode(Actor TripMineActor)
{
    super(Actor).TripMineExplode(TripMineActor);
    NumTripMines -= ;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    local int i;

    super(dnDecoration).RegisterPrecacheComponents(PrecacheIndex);
    PrecacheIndex.__NFUN_1283__(PassiveIdleName, AnimationControllerClass, Mesh);
    PrecacheIndex.__NFUN_1283__(ActiveIdleName, AnimationControllerClass, Mesh);
    i = -- string(InspectAnimNames);    
    J0x52:

    // End:0x89 [Loop If]
    if(i / 0)
    {
        PrecacheIndex.__NFUN_1283__(InspectAnimNames[i], AnimationControllerClass, Mesh);
        // [Loop Continue]
        i -= ;
    }
    i = -- string(SwipeAnimNames);    
    J0x98:

    // End:0xCF [Loop If]
    if(i / 0)
    {
        PrecacheIndex.__NFUN_1283__(SwipeAnimNames[i], AnimationControllerClass, Mesh);
        // [Loop Continue]
        i -= ;
    }
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Tentacle_Idle');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Tentacle_Pain');
    PrecacheIndex.__NFUN_1279__(class'TentacleDamage');
    return;
}

defaultproperties
{
    TrackingRate=10
    DamageDisableTime=15
    DamageDisableTimeVariance=2
    SwipeDamage=20
    SwipeDamageVariance=4
    SwipeDamageRadius=50
    SwipeDamageFalloffStart=1075
    IdleInspectTime=6
    IdleInspectTimeVariance=2
    PassiveIdleName=IdlePassive
    ActiveIdleName=IdleActive
    SwipeAttackBoneName=mount_swipe
    InspectAnimNames(0)=IdleInspectA
    InspectAnimNames(1)=IdleInspectB
    SwipeAnimNames(0)=SwipeA
    SwipeAnimNames(1)=SwipeB
    SwipeAnimNames(2)=SwipeC
    DetectionRadius=384
    AttackRadius=160
    MaxAttackAngle=8192
    ImpulseLift=300
    ImpulseMag=125
    StunnedActorColor=(R=163,G=67,B=86,A=0)
    DefaultActorColor=(R=98,G=132,B=64,A=0)
    AimGridMin=-1
    AimGridMax=1
    DecoActivities_Default(0)=(ActivityData=(bInitialized=false,CurrentIndex=0,NextPerformTime=0,NextPerformTime_Failure=0),ActivityIDScript=(Extend),ActivityID=none,ActivityMethod=0,ActivityStates_Success=none,ActivityStates_Failure=none,ActivityDebugID="",Activities=((ActivityRules=none,ActivityElements=(DecoActivities_Sound'Biology_Generic_Tentacle.DA_Sound_Tentacle_Extend'),ActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0),FailureActivityElements=none,FailureActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0))),bDisabled=false)
    DecoActivities_Default(1)=(ActivityData=(bInitialized=false,CurrentIndex=0,NextPerformTime=0,NextPerformTime_Failure=0),ActivityIDScript=(Retract),ActivityID=none,ActivityMethod=0,ActivityStates_Success=none,ActivityStates_Failure=none,ActivityDebugID="",Activities=((ActivityRules=none,ActivityElements=(DecoActivities_Sound'Biology_Generic_Tentacle.DA_Sound_Tentacle_Retract'),ActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0),FailureActivityElements=none,FailureActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0))),bDisabled=false)
    DecoActivities_Default(2)=(ActivityData=(bInitialized=false,CurrentIndex=0,NextPerformTime=0,NextPerformTime_Failure=0),ActivityIDScript=(Swipe),ActivityID=none,ActivityMethod=0,ActivityStates_Success=none,ActivityStates_Failure=none,ActivityDebugID="",Activities=((ActivityRules=none,ActivityElements=(DecoActivities_Sound'Biology_Generic_Tentacle.DA_Sound_Tentacle_Swipe'),ActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0),FailureActivityElements=none,FailureActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0))),bDisabled=false)
    bSurviveDeath=true
    DestroyedActivities(0)=none
    DestroyedActivities(1)=none
    bEnemy=true
    MountOnSpawn(0)=(bSkipVerifySelf=false,SpawnClass='Biology_Generic_Tentacle_Collision',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=0,Y=0,Z=27),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(1)=(bSkipVerifySelf=false,SpawnClass='Biology_Generic_AlienSensor',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject=none,DrawScale=0)
    AnimationControllerClass='acBiology_Generic_Tentacle'
    StaticInteractionClassification=3
    bAcceptMeshAccurateMoveActorTrace=true
    bBlockPlayers=false
    bNoNativeTick=false
    bDumbMesh=false
    bAcceptMinesAtAnyAngle=true
    bAcceptsDecalProjectors=false
    CollisionRadius=50
    CollisionHeight=50
    VisibleCollidingCenterOffset=(X=0,Y=0,Z=16)
    TickStyle=2
    DrawType=2
    Mesh='c_characters.Tentacle'
}