/*******************************************************************************
 * Containers_CoffeeMachine_Pot generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class Containers_CoffeeMachine_Pot extends Containers_Generic
    collapsecategories
    dependson(Electronics_Generic_CoffeeMachine);

enum ECoffeePotState
{
    COFFEE_Empty,
    COFFEE_Filling,
    COFFEE_Full
};

var() noexport Containers_CoffeeMachine_Pot.ECoffeePotState CoffeeState "State the pot starts out in.";
var Electronics_Generic_CoffeeMachine CoffeeMachine;

event PostVerifySelf()
{
    switch(CoffeeState)
    {
        // End:0x0D
        case 1:
        // End:0x1B
        case 2:
            FullPot();
            // End:0x2C
            break;
        // End:0x29
        case 0:
            EmptyPot();
            // End:0x2C
            break;
        // End:0xFFFF
        default:
            break;
    }
    super(dnDecoration).PostVerifySelf();
    return;
}

final function SetMachine(Electronics_Generic_CoffeeMachine NewMachine)
{
    CoffeeMachine = NewMachine;
    // End:0x27
    if(__NFUN_340__(CoffeeMachine, none))
    {
        DecoActivity(0, 'PotOnMachine');        
    }
    else
    {
        DecoActivity(0, 'PotOffMachine');
    }
    return;
}

final function EmptyPot()
{
    CoffeeState = 0;
    DecoActivity(0, 'EmptyPot');
    return;
}

final function FillPot()
{
    CoffeeState = 1;
    DecoActivity(0, 'FillPot');
    PushPendingActivity(,, 'FullPot');
    return;
}

final function FullPot()
{
    CoffeeState = 2;
    DecoActivity(0, 'ExecuteFullPot');
    // End:0x31
    if(__NFUN_340__(CoffeeMachine, none))
    {
        CoffeeMachine.PotNowFull();
    }
    return;
}

final function bool CurrentlyFilling()
{
    return int(CoffeeState) % int(1);
    return;
}

final function bool NeedRefill()
{
    switch(CoffeeState)
    {
        // End:0x0F
        case 0:
            return true;
        // End:0x14
        case 1:
        // End:0x1B
        case 2:
            return false;
        // End:0xFFFF
        default:
            return;
            break;
    }
}

function Destroyed()
{
    super(dnDecoration).Destroyed();
    // End:0x22
    if(__NFUN_340__(CoffeeMachine, none))
    {
        CoffeeMachine.PotGoneMIA();
    }
    return;
}

defaultproperties
{
    DecoActivities_Default(0)=(ActivityData=(bInitialized=false,CurrentIndex=0,NextPerformTime=0,NextPerformTime_Failure=0),ActivityIDScript=(EmptyPot),ActivityID=none,ActivityMethod=0,ActivityStates_Success=none,ActivityStates_Failure=none,ActivityDebugID="",Activities=((ActivityRules=none,ActivityElements=(DecoActivities_Animation'Containers_CoffeeMachine_Pot.DA_Anim_Containers_CoffeeMachine_Pot_Empty'),ActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0),FailureActivityElements=none,FailureActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0))),bDisabled=false)
    DecoActivities_Default(1)=(ActivityData=(bInitialized=false,CurrentIndex=0,NextPerformTime=0,NextPerformTime_Failure=0),ActivityIDScript=(FillPot),ActivityID=none,ActivityMethod=0,ActivityStates_Success=none,ActivityStates_Failure=none,ActivityDebugID="",Activities=((ActivityRules=none,ActivityElements=(DecoActivities_Animation'Containers_CoffeeMachine_Pot.DA_Anim_Containers_CoffeeMachine_Pot_Filling'),ActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0),FailureActivityElements=none,FailureActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0))),bDisabled=false)
    DecoActivities_Default(2)=(ActivityData=(bInitialized=false,CurrentIndex=0,NextPerformTime=0,NextPerformTime_Failure=0),ActivityIDScript=(FullPot),ActivityID=none,ActivityMethod=0,ActivityStates_Success=none,ActivityStates_Failure=none,ActivityDebugID="",Activities=((ActivityRules=none,ActivityElements=(DecoActivities_Events'Containers_CoffeeMachine_Pot.DA_Events_Containers_CoffeeMachine_Pot_Full'),ActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0),FailureActivityElements=none,FailureActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0))),bDisabled=false)
    DecoActivities_Default(3)=(ActivityData=(bInitialized=false,CurrentIndex=0,NextPerformTime=0,NextPerformTime_Failure=0),ActivityIDScript=(ExecuteFullPot),ActivityID=none,ActivityMethod=0,ActivityStates_Success=none,ActivityStates_Failure=none,ActivityDebugID="",Activities=((ActivityRules=none,ActivityElements=(DecoActivities_Animation'Containers_CoffeeMachine_Pot.DA_Anim_Containers_CoffeeMachine_Pot_Full'),ActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0),FailureActivityElements=none,FailureActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0))),bDisabled=false)
    DestroyedActivities(0)=none
    DestroyedActivities(1)='dnGame.DecoActivityDeclarations.DA_Sound_Destroyed_Glass_Small'
    HealthPrefab=1
    SpawnOnDestroyedSimple(0)='dnParticles.dnDebris_Glass1'
    SpawnOnDestroyedSimple(1)='dnParticles.dnDebris_Glass1'
    SpawnOnDestroyedSimple(2)='dnParticles.dnDebris_Smoke_Small1'
    SpawnOnDestroyedSimple(3)='dnParticles.dnDebris_WaterSplash'
    bTickOnlyWhenPhysicsAwake=true
    PhysicsMaterial='dnMaterial.dnPhysicsMaterial_Glass'
    PhysicsMassType=1
    KImpactThreshold=0.1
    Density=1.5
    Physics=18
    CollisionRadius=6.2
    CollisionHeight=6.33
    Mass=100
    StaticMesh='sm_class_decorations.coffeepot.coffeepot'
}