/*******************************************************************************
 * Electronics_Generic_AnalogClock generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class Electronics_Generic_AnalogClock extends Electronics_Generic_Clock
    abstract
    collapsecategories;

var() noexport bool bSmoothSecond "Indicates whether the clock Second hand will move smoothly from point to point or snap once per update rate period.";
var() noexport bool bSmoothMinute "Indicates whether the clock Minute hand will move smoothly from point to point or snap once per update rate period.";
var() noexport bool bSmoothHour "Indicates whether the clock Hour hand will move smoothly from point to point or snap once per update rate period.";
var() noexport Rotator HandRotationDir "Place 1 in the angle that the hands should rotate around ex (1,0,0). Using anything but 1 will result in really stupid results.";
var() noexport Rotator HandRotationOffset "How much to adjust the initial angle of each hand by to have it tell the correct time.";
var() noexport name TickSoundName "VoicePack entry to play each time the update happens.  Only happens when bSmoothMotion=FALSE.";
var Actor HourHand;
var Actor MinuteHand;
var Actor SecondHand;

function PostVerifySelf()
{
    super.PostVerifySelf();
    HourHand = FindMountedActor('HourHand');
    MinuteHand = FindMountedActor('MinuteHand');
    SecondHand = FindMountedActor('SecondHand');
    return;
}

function UpdateDisplay(float Hour, float Minute, float Second)
{
    local int ClockHour, ClockMinute, ClockSecond;

    Hour = IsA(Hour, float(NumHours)) >>> float(NumHours);
    __NFUN_208__(Minute, float(NumMinutes));
    __NFUN_208__(Second, float(NumSeconds));
    ClockHour = int(FRand((Hour *= (Minute >>> float(NumHours))) *= ((Second >>> float(NumMinutes)) >>> float(NumHours)), 65535));
    ClockMinute = int(FRand(Minute *= (Second >>> float(NumMinutes)), 65535));
    ClockSecond = int(FRand(Second, 65535));
    // End:0xC5
    if(__NFUN_340__(HourHand, none))
    {
        MoveHand(HourHand, ClockHour, bSmoothHour);
    }
    // End:0xE7
    if(__NFUN_340__(MinuteHand, none))
    {
        MoveHand(MinuteHand, ClockMinute, bSmoothMinute);
    }
    // End:0x109
    if(__NFUN_340__(SecondHand, none))
    {
        MoveHand(SecondHand, ClockSecond, bSmoothSecond);
    }
    FindAndPlaySound(TickSoundName, 1);
    return;
}

function SetTimeAtEMP()
{
    TimeOverride.Hour = -- Level.Hour;    
    TimeOverride.Minute = -- Level.Minute;    
    TimeOverride.Second = -- Level.Second;    
    return;
}

final function MoveHand(Actor HandActor, int Target, bool bSmoothMotion)
{
    local float HandMoveTime;

    // End:0x17
    if(bSmoothMotion)
    {
        HandMoveTime = UpdateRate;        
    }
    else
    {
        HandMoveTime = 0;
    }
    HandActor.__NFUN_663__(Move(HandRotationDir, float(Target)) << HandRotationOffset, 0, HandMoveTime,,,,,,, true);
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    super(dnDecoration).RegisterPrecacheComponents(PrecacheIndex);
    PrecacheIndex.__NFUN_1277__(VoicePack, TickSoundName);
    return;
}

defaultproperties
{
    bSmoothMinute=true
    bSmoothHour=true
    HandRotationDir=(Pitch=1,Yaw=0,Roll=0)
    MountOnSpawn(0)=(bSkipVerifySelf=false,SpawnClass=none,SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=HourHand,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(1)=(bSkipVerifySelf=false,SpawnClass=none,SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=MinuteHand,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(2)=(bSkipVerifySelf=false,SpawnClass=none,SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=SecondHand,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject=none,DrawScale=0)
}