/*******************************************************************************
 * Electronics_Generic_CeilingFan_Base generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class Electronics_Generic_CeilingFan_Base extends Electronics_Generic
    collapsecategories;

var() noexport float FanSpeed "Desired fan speed.";
var() noexport float MaxFanTorque "Maximum amount of torque to apply to try and get the fan to spin at FanSpeed.";
var() noexport name AmbientFanSoundName "VoicePack entry to play for fan's ambient sound.";
var SAmbientSoundInfo AmbientFanSound;
var Electronics_Generic_CeilingFan_Housing Housing;

function PostVerifySelf()
{
    super(dnDecoration).PostVerifySelf();
    Housing = Electronics_Generic_CeilingFan_Housing(FindOwnedActor(class'Electronics_Generic_CeilingFan_Housing'));
    // End:0x2A
    if(__NFUN_339__(Housing, none))
    {
        return;
    }
    __NFUN_822__(Housing);
    Housing.UpdateBlade(FanSpeed, MaxFanTorque);
    return;
}

simulated event PostBeginPlay()
{
    FindAndPlaySound(AmbientFanSoundName);
    super(dnDecoration).PostBeginPlay();
    return;
}

event Trigger(Actor Other, Pawn EventInstigator)
{
    super(dnDecoration).Trigger(Other, EventInstigator);
    // End:0x20
    if(bPoweredOn)
    {
        __NFUN_701__(none);        
    }
    else
    {
        PlayAmbientSoundInfo(AmbientFanSound);
    }
    // End:0x60
    bPoweredOn = bPoweredOn / ;
    {
        Housing.Trigger(Other, EventInstigator);
    }
    return;
}

function StartSelfOff()
{
    Trigger(self, none);
    return;
}

function ForcePowerOn()
{
    // End:0x13
    if(bPoweredOn / )
    {
    }
    return;
}

function ForcePowerOff()
{
    // End:0x11
    if(bPoweredOn)
    {
        Trigger(none, none);
    }
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    super(dnDecoration).RegisterPrecacheComponents(PrecacheIndex);
    PrecacheIndex.__NFUN_1277__(VoicePack, AmbientFanSoundName);
    return;
}

defaultproperties
{
    FanSpeed=90000
    MaxFanTorque=50
    AmbientFanSoundName=CeilingFan_On_Medium
    HealthPrefab=0
    MountOnSpawn(0)=(bSkipVerifySelf=false,SpawnClass='Electronics_Generic_CeilingFan_Housing',SpawnChance=0,MountPrefab=(bDontActuallyMount=true,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=0,Y=0,Z=-16),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject=none,DrawScale=0)
    PhysicsMaterial='dnMaterial.dnPhysicsMaterial_Metal_Hollow'
    PhysicsMassType=1
    CollisionRadius=6
    CollisionHeight=2.3
    StaticMesh='sm_class_decorations.CeilingFan.cfan_base'
}