/*******************************************************************************
 * Electronics_Generic_Computer_Monitor generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class Electronics_Generic_Computer_Monitor extends Electronics_Generic_Computer
    abstract
    collapsecategories
    dependson(DecoGlass_Monitor_FlatScreen);

enum EMonitorState
{
    MONITOR_On,
    MONITOR_Off,
    MONITOR_Disabled
};

var() noexport MaterialEx TexPowerOff "Texture to use for when the computer is currently off.";
var() noexport array<MaterialEx> ScreenTextures "List of textures to flip between.";
var int CurrentImage;
var Electronics_Generic_Computer_Monitor.EMonitorState MonitorState;
var Electronics_Generic_Computer_CPU CPU;
var DecoGlass_Monitor_FlatScreen GlassActor;
var MaterialEx CurrentScreen;
var bool bInitiallyUsable;
var bool bCanSwitch;

function PostVerifySelf()
{
    super(dnDecoration).PostVerifySelf();
    bInitiallyUsable = bUsable;
    GlassActor = DecoGlass_Monitor_FlatScreen(FindMountedActor('Glass'));
    // End:0x5D
    if(__NFUN_340__(GlassActor, none))
    {
        GlassActor.MonitorActor = self;
        GlassActor.bUsable = bInitiallyUsable;
    }
    return;
}

event PostBeginPlay()
{
    TriggerFunc_PowerOn();
    super(dnDecoration).PostBeginPlay();
    return;
}

final function SetCPU(Electronics_Generic_Computer_CPU NewCPU)
{
    CPU = NewCPU;
    return;
}

event Used(Actor Other, Pawn EventInstigator)
{
    super(dnDecoration).Used(Other, EventInstigator);
    switch(MonitorState)
    {
        // End:0x26
        case 0:
            TriggerFunc_PowerOff();
            // End:0x3F
            break;
        // End:0x34
        case 1:
            TriggerFunc_PowerOn();
            // End:0x3F
            break;
        // End:0x3C
        case 2:
            // End:0x3F
            break;
        // End:0xFFFF
        default:
            break;
    }
    return;
}

function ForcePowerOn()
{
    super(Electronics_Generic).ForcePowerOn();
    MonitorState = 0;
    SetUsePhrase(UsePhrase);
    RefreshScreen();
    bUsable = bInitiallyUsable;
    return;
}

function ForcePowerOff()
{
    super(Electronics_Generic).ForcePowerOff();
    MonitorState = 1;
    SetScreen(TexPowerOff);
    SetUsePhrase(UsePhrase);
    return;
}

function PowerDisabled()
{
    bDrawUsePhrase = false;
    MonitorState = 2;
    DecoActivity(0, 'PowerDisabled');
    SetScreen(TexPowerOff);
    // End:0x44
    if(__NFUN_340__(GlassActor, none))
    {
        GlassActor.Disabled();
    }
    return;
}

final function BLITScreen(MaterialEx NewDisplay)
{
    CurrentScreen = NewDisplay;
    // End:0x1F
    if(int(MonitorState) % int(0))
    {
        RefreshScreen();
    }
    return;
}

function RefreshScreen()
{
    // End:0x17
    if(__NFUN_339__(CurrentScreen, none))
    {
        CurrentScreen = TexPowerOff;
    }
    SetScreen(CurrentScreen);
    return;
}

function SetScreen(MaterialEx screen)
{
    // End:0x1F
    if(__NFUN_340__(GlassActor, none))
    {
        GlassActor.__NFUN_741__(0, screen);
    }
    return;
}

function SwitchScreens()
{
    // End:0x18
    if((bCanSwitch / ) < )
    {
    }
    // End:0x36
    CurrentImage *= ;
    {
        CurrentImage = 0;
    }
    SetScreen(ScreenTextures[CurrentImage]);
    Level.__NFUN_1161__().FindSoundAndSpeak('PornComment');
    // End:0x9C
    if(__NFUN_340__(DukePlayer(Level.__NFUN_1161__()), none))
    {
        DukePlayer(Level.__NFUN_1161__()).GivePermanentEgoCapAward(25);
    }
    bCanSwitch = false;
    __NFUN_607__(3.5, false, 'CanSwitch');
    return;
}

function CanSwitch()
{
    bCanSwitch = true;
    return;
}

function SetUsePhrase(string newPhrase)
{
    // End:0x21
    if(__NFUN_340__(GlassActor, none))
    {
        GlassActor.UsePhrase = newPhrase;
    }
    return;
}

final function GlassDamaged()
{
    CriticalDamage();
    return;
}

function Destroyed()
{
    bDrawUsePhrase = true;
    // End:0x24
    if(__NFUN_340__(GlassActor, none))
    {
        GlassActor.CrackSelf();
    }
    // End:0x40
    if(__NFUN_340__(CPU, none))
    {
        CPU.Display_Destroyed();
    }
    super(dnDecoration).Destroyed();
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    local int i;

    super(dnDecoration).RegisterPrecacheComponents(PrecacheIndex);
    PrecacheIndex.__NFUN_1269__(TexPowerOff);
    i = -- string(ScreenTextures);    
    J0x2C:

    // End:0x59 [Loop If]
    if(i / 0)
    {
        PrecacheIndex.__NFUN_1269__(ScreenTextures[i]);
        // [Loop Continue]
        i -= ;
    }
    PrecacheIndex.__NFUN_1277__(class'DukePlayer'.default.VoicePack, 'PornComment');
    return;
}

defaultproperties
{
    TexPowerOff='dt_editor.Surface.blackRC'
    ScreenTextures(0)='dt_signs.ScreenSaver.Screensaver1_bs'
    ScreenTextures(1)='dt_signs.ScreenSaver.Screensaver2_bs'
    ScreenTextures(2)='dt_signs.ScreenSaver.Screensaver3_bs'
    bCanSwitch=true
    DecoActivities_Default(0)=(ActivityData=(bInitialized=false,CurrentIndex=0,NextPerformTime=0,NextPerformTime_Failure=0),ActivityIDScript=none,ActivityID=(3),ActivityMethod=0,ActivityStates_Success=none,ActivityStates_Failure=none,ActivityDebugID="",Activities=((ActivityRules=none,ActivityElements=('dnGame.DecoActivityDeclarations.DA_Sound_SmallSwitch_Standard'),ActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0),FailureActivityElements=none,FailureActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0))),bDisabled=false)
    DecoActivities_Default(1)=(ActivityData=(bInitialized=false,CurrentIndex=0,NextPerformTime=0,NextPerformTime_Failure=0),ActivityIDScript=none,ActivityID=(33),ActivityMethod=0,ActivityStates_Success=none,ActivityStates_Failure=none,ActivityDebugID="",Activities=((ActivityRules=none,ActivityElements=(DecoActivities_Sound'Electronics_Generic_Computer_Monitor.DA_Sound_ElctrGen_Cmptr_Monitor_PowerOn','dnGame.DecoActivityDeclarations.DA_Interact_bUsable_Enable','dnGame.DecoActivityDeclarations.DA_HUD_bDrawUsePhrase_Enable','dnGame.DecoActivityDeclarations.DA_HUD_bForceUsePhrase_Enable'),ActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0),FailureActivityElements=none,FailureActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0))),bDisabled=false)
    DecoActivities_Default(2)=(ActivityData=(bInitialized=false,CurrentIndex=0,NextPerformTime=0,NextPerformTime_Failure=0),ActivityIDScript=none,ActivityID=(34),ActivityMethod=0,ActivityStates_Success=none,ActivityStates_Failure=none,ActivityDebugID="",Activities=((ActivityRules=none,ActivityElements=(DecoActivities_Sound'Electronics_Generic_Computer_Monitor.DA_Sound_ElctrGen_Cmptr_Monitor_PowerOff','dnGame.DecoActivityDeclarations.DA_HUD_bDrawUsePhrase_Enable','dnGame.DecoActivityDeclarations.DA_HUD_bForceUsePhrase_Enable'),ActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0),FailureActivityElements=none,FailureActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0))),bDisabled=false)
    DecoActivities_Default(3)=(ActivityData=(bInitialized=false,CurrentIndex=0,NextPerformTime=0,NextPerformTime_Failure=0),ActivityIDScript=(PowerDisabled),ActivityID=none,ActivityMethod=0,ActivityStates_Success=none,ActivityStates_Failure=none,ActivityDebugID="",Activities=((ActivityRules=none,ActivityElements=('dnGame.DecoActivityDeclarations.DA_HUD_bDrawUsePhrase_Disable','dnGame.DecoActivityDeclarations.DA_Interact_bUsable_Disable','dnGame.DecoActivityDeclarations.DA_HUD_bForceUsePhrase_Disable',DecoActivities_Sound'Electronics_Generic_Computer_Monitor.DA_Sound_ElctrGen_Cmptr_Monitor_PowerOff'),ActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0),FailureActivityElements=none,FailureActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0))),bDisabled=false)
    DestroyedActivities(0)=none
    DestroyedActivities(1)=DecoActivities_Sound'Electronics_Generic.DA_Sound_Destroyed_Electronic'
    DestroyedActivities(2)='dnGame.DecoActivityDeclarations.DA_Interact_bUsable_Disable'
    DestroyedActivities(3)='dnGame.DecoActivityDeclarations.DA_HUD_bForceUsePhrase_Disable'
    DestroyedActivities(4)='dnGame.DecoActivityDeclarations.DA_HUD_bDrawUsePhrase_Enable'
    begin object name=DA_Sound_ElctrGen_Cmptr_Monitor_PowerOff class=DecoActivities_Sound
        SoundNames(0)=ComputerMonitor_PowerOff
    object end
    // Reference: DecoActivities_Sound'Electronics_Generic_Computer_Monitor.DA_Sound_ElctrGen_Cmptr_Monitor_PowerOff'
    DestroyedActivities(5)=DA_Sound_ElctrGen_Cmptr_Monitor_PowerOff
    DestroyedActivities(6)='dnGame.DecoActivityDeclarations.DA_Physics_PHYS_Karma_Set'
    bForceUsePhrase=true
    SpawnOnDestroyedSimple(0)='p_Decorations.Monitor_Explosion.Monitor_Explosion_Spawner'
    bTickOnlyWhenPhysicsAwake=true
    Mass=25
}