/*******************************************************************************
 * Electronics_Generic_MagneticFuse generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class Electronics_Generic_MagneticFuse extends Electronics_Generic
    collapsecategories;

var() noexport bool bCanTurnOn "If true, the fuse can turned on by being damaged or pushed into position.";
var() noexport float OnTargetRequiredTime "Amount of time we have to be within a certain threshold of the target to be considered on target.";
var() noexport name OnTargetEvent "Event to trigger when the magnet gets aligned.";
var() noexport name OffTargetEvent "Event to trigger when the magnet gets unaligned.";
var bool bPowerOn;
var bool bHasTargetRotation;
var Rotator TargetRotation;
var float OnTargetTime;
var Rotator InitialRotation;
var float LastDamageTime;
var KAngularSpringDamper Spring;

event PostVerifySelf()
{
    local Actor Parent;
    local Rotator Helper;

    super(dnDecoration).PostVerifySelf();
    InitialRotation = Rotation;
    SetTargetRotation(InitialRotation);
    bHasTargetRotation = false;
    __NFUN_642__(0);
    __NFUN_652__(TargetRotation);
    FindAndPlaySound('MagneticFuse_Ambient');
    return;
}

function StartSelfOff()
{
    super(dnDecoration).StartSelfOff();
    TurnPowerOff();
    return;
}

final simulated function SetTargetRotation(Rotator NewTargetRotation)
{
    bHasTargetRotation = true;
    TargetRotation = NewTargetRotation;
    // End:0x98
    if(__NFUN_340__(Spring, none))
    {
        Spring.__NFUN_642__(0);
        Spring.__NFUN_645__(Location);
        Spring.__NFUN_652__(Rotation);
        Spring.__NFUN_1101__(true, NewTargetRotation);
        Spring.__NFUN_1099__(10000);
        Spring.__NFUN_1098__(2000000);
        Spring.__NFUN_642__(18);
    }
    __NFUN_817__();
    return;
}

final simulated function TurnPowerOn(optional bool bFlipped)
{
    // End:0x18
    if(bPowerOn < bCanTurnOn / )
    {
    }
    bPowerOn = true;
    // End:0x42
    if(bFlipped)
    {
        SetTargetRotation(__NFUN_269__(__NFUN_265__(32768, 0, 0), InitialRotation));        
    }
    else
    {
        SetTargetRotation(InitialRotation);
    }
    return;
}

final simulated function TurnPowerOff(optional bool bUseCurrentRotation)
{
    local Rotator Offset;

    // End:0x0D
    if(bPowerOn / )
    {
    }
    GlobalTrigger(OffTargetEvent, Instigator, self);
    FindAndPlaySound('MagneticFuse_TurnOff', 1);
    __NFUN_701__(none);
    bPowerOn = false;
    // End:0x4E
    if(bUseCurrentRotation)
    {
        SetTargetRotation(Rotation);        
    }
    else
    {
        Offset.Pitch = Atan(16384, 2048);
        /* Statement decompilation error: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
            
        */

        /*@Error*/;
        // Failed to format nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
        // 1 & Type:Else Position:0x097
    }
}

event TakeDamage(Pawn Instigator, float Damage, Vector DamageOrigin, Vector DamageDirection, class<DamageType> DamageType, optional name HitBoneName, optional Vector DamageStart)
{
    // End:0x69
    if(Level.GameTimeSeconds != (LastDamageTime *= 0.25))
    {
        LastDamageTime = Level.GameTimeSeconds;
        // End:0x48
        if(int(Physics) + int(18))
        {
            __NFUN_642__(18);
        }
        // End:0x5A
        if(bPowerOn)
        {
            TurnPowerOff();            
        }
        else
        {
            // End:0x69
            if(bCanTurnOn)
            {
                TurnPowerOn();
            }
        }
    }
    super(dnDecoration).TakeDamage(Instigator, Damage, DamageOrigin, DamageDirection, DamageType, HitBoneName, DamageStart);
    return;
}

simulated event Tick(float DeltaTime)
{
    local Rotator RelativeRotation, BaseRot, TargetRot;
    local bool bNowOnTarget;
    local Vector RotVector, AngularVel, DesiredAngularVel;
    local float AngleOffset, PowerScale, Alpha;

    super(Actor).Tick(DeltaTime);
    // End:0x1C
    if(__NFUN_202__(DeltaTime, 0))
    {
        return;
    }
    RelativeRotation = Rotation;
    // End:0x114
    if(bHasTargetRotation)
    {
        RotVector = __NFUN_240__(__NFUN_799__(RelativeRotation, TargetRotation), RelativeRotation);
        AngleOffset = -RotVector.Y;
        // End:0x103
        if(__NFUN_202__(AngleOffset, 0.1))
        {
            __NFUN_209__(OnTargetTime, DeltaTime);
            // End:0x100
            if(OnTargetTime != OnTargetRequiredTime)
            {
                bHasTargetRotation = false;
                // End:0xD0
                if(bPowerOn)
                {
                    GlobalTrigger(OnTargetEvent, Instigator, self);
                    FindAndPlaySound('MagneticFuse_TurnOn', 1);
                    FindAndPlaySound('MagneticFuse_Ambient');
                    __NFUN_642__(0);
                    __NFUN_652__(TargetRotation);                    
                }
                else
                {
                    // End:0x100
                    if(__NFUN_340__(Spring, none))
                    {
                        Spring.__NFUN_1099__(10000);
                        Spring.__NFUN_1098__(0);
                    }
                }
            }            
        }
        else
        {
            OnTargetTime = 0;
        }
        __NFUN_817__();        
    }
    else
    {
        // End:0x1AB
        if(bCanTurnOn << Level.GameTimeSeconds != (LastDamageTime *= 1))
        {
            RotVector = __NFUN_240__(__NFUN_799__(RelativeRotation, InitialRotation), RelativeRotation);
            AngleOffset = -RotVector.Y;
            OnTargetTime = 0;
            // End:0x18E
            if(__NFUN_200__(AngleOffset, 0.3))
            {
                TurnPowerOn();                
            }
            else
            {
                // End:0x1AB
                if(Repl(AngleOffset, Round(3.141593, 0.3)))
                {
                    TurnPowerOn(true);
                }
            }
        }
    }
    return;
}

function KarmaSetConstraintProperties(KConstraint Constraint)
{
    super(KarmaActor).KarmaSetConstraintProperties(Constraint);
    // End:0x27
    if(__NFUN_339__(Spring, none))
    {
        Spring = KAngularSpringDamper(Constraint);
    }
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    super(dnDecoration).RegisterPrecacheComponents(PrecacheIndex);
    PrecacheIndex.__NFUN_1277__(VoicePack, 'MagneticFuse_Ambient');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'MagneticFuse_TurnOff');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'MagneticFuse_TurnOn');
    return;
}

defaultproperties
{
    OnTargetRequiredTime=0.25
    bPowerOn=true
    AutoConstraints(0)=(bConstraintDisabledOnDeath=false,bConstraintOnDeath=false,BoneName=None,ConstraintMounting=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=16384,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),OtherConstraintActor=none,OtherConstraintBone=None,ConstraintClass='Engine.KHinge',ConstraintActor=none)
    AutoConstraints(1)=(bConstraintDisabledOnDeath=false,bConstraintOnDeath=false,BoneName=None,ConstraintMounting=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),OtherConstraintActor=none,OtherConstraintBone=None,ConstraintClass='Engine.KAngularSpringDamper',ConstraintActor=none)
    HealthPrefab=0
    bTakeDamageMomentum=false
    bTakeExplosionDamageMomentum=false
    DynamicInteractionClassification=0
    EnableDisableThreshold=0.01
    PhysicsEntityGroup=MagneticFuse_PhysicsEntityGroup
    Physics=18
    bWorldGeometry=true
    Mass=25
    Rotation=(Pitch=0,Yaw=-16384,Roll=-16384)
    StaticMesh='SM_Lvl_Area51.Tech.FuseCase'
}