/*******************************************************************************
 * Electronics_Generic_PowerCable generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class Electronics_Generic_PowerCable extends Electronics_Generic
    abstract
    collapsecategories;

var() noexport float SparkFrequency "How frequently the cable will surge will electricity when powered on.";
var() noexport float SparkFrequencyVariance "How much to vary the frequency by.";
var() noexport int SparkDamage "How much damage a spark jump is supposed to do.";
var() noexport float SparkRadius "How far a spark is able to reach when it does damage. Remember this is from the location of the spark, which could be anywhere the ragdoll can reach.";
var bool bPowered;
var bool bCanJump;
var SoftParticleSystem SparkEffect;

event PostBeginPlay()
{
    SupplyPower();
    super(dnDecoration).PostBeginPlay();
    return;
}

function PostVerifySelf()
{
    super(dnDecoration).PostVerifySelf();
    SparkEffect = SoftParticleSystem(FindMountedActor('SparkEffect'));
    // End:0x53
    if(__NFUN_340__(SparkEffect, none))
    {
        SparkEffect.DamageAmount = float(SparkDamage);
        SparkEffect.DamageRadius = SparkRadius;
    }
    return;
}

function StartSelfOff()
{
    CutPower();
    return;
}

function Destroyed()
{
    super(dnDecoration).Destroyed();
    bCanJump = true;
    // End:0x1D
    if(bPowered)
    {
        SparkJump();
    }
    return;
}

final function SparkJump()
{
    // End:0x0E
    if(__NFUN_339__(SparkEffect, none))
    {
        return;
    }
    SparkEffect.Trigger(self, none);
    DecoActivity(0, 'SparkJump');
    // End:0x51
    if(Repl(SparkFrequency, 0))
    {
        __NFUN_605__(Normal(SparkFrequency, SparkFrequencyVariance), false, 'SparkJump');
    }
    return;
}

event Trigger(Actor Other, Pawn EventInstigator)
{
    super(dnDecoration).Trigger(Other, EventInstigator);
    // End:0x22
    if(bPowered)
    {
        CutPower();        
    }
    else
    {
        SupplyPower();
    }
    return;
}

final function SupplyPower()
{
    bPowered = true;
    DecoActivity(0, 'SupplyPower');
    // End:0x24
    if(bCanJump)
    {
        SparkJump();
    }
    return;
}

final function CutPower()
{
    bPowered = false;
    DecoActivity(0, 'CutPower');
    __NFUN_606__('SparkJump');
    return;
}

defaultproperties
{
    SparkFrequency=4
    SparkFrequencyVariance=4
    SparkDamage=15
    SparkRadius=80
    bPowered=true
    DecoActivities_Default(0)=(ActivityData=(bInitialized=false,CurrentIndex=0,NextPerformTime=0,NextPerformTime_Failure=0),ActivityIDScript=(SparkJump),ActivityID=none,ActivityMethod=0,ActivityStates_Success=none,ActivityStates_Failure=none,ActivityDebugID="",Activities=((ActivityRules=none,ActivityElements=(DecoActivities_KarmaImpulse'Electronics_Generic_PowerCable.DA_KImpulse_Electronics_Generic_PowerCable_SparkJump'),ActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0),FailureActivityElements=none,FailureActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0))),bDisabled=false)
    AutoConstraints(0)=(bConstraintDisabledOnDeath=false,bConstraintOnDeath=false,BoneName=Root,ConstraintMounting=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),OtherConstraintActor=none,OtherConstraintBone=None,ConstraintClass=none,ConstraintActor=none)
    AutoConstraints(1)=(bConstraintDisabledOnDeath=true,bConstraintOnDeath=false,BoneName=tube_attach,ConstraintMounting=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),OtherConstraintActor=none,OtherConstraintBone=None,ConstraintClass=none,ConstraintActor=none)
    bSurviveDeath=true
    DamageThreshold=1
    MountOnSpawn(0)=(bSkipVerifySelf=false,SpawnClass='dnParticles.dnSparkFX_LooseCable_Spawner',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=SparkEffect,ForceEvent=None,MountMeshItem=tube_attach,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    bTickOnlyWhenPhysicsAwake=true
    Physics=18
    bBlockPlayers=false
    CollisionRadius=1
    CollisionHeight=1
    TickStyle=2
    DrawType=2
}