/*******************************************************************************
 * Industrial_Generic_Propanetank generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class Industrial_Generic_Propanetank extends Industrial_Generic
    collapsecategories;

var() noexport float DelayedExplosionTime "After the first time we take damage, we'll force destory ourselves if the timer runs out before we take enough damage.";
var() noexport float DelayedExplosionVariance "Variance for the DelayedExplosionTime";
var array<SoftParticleSystem> BulletFires;
var class<SoftParticleSystem> BulletFireClass;
var int NumHits;
var float damageAbsorbed;

final function Explode()
{
    CriticalDamage();
    return;
}

simulated function Destroyed()
{
    __NFUN_608__('Explode');
    StopBulletFire();
    super(dnDecoration).Destroyed();
    RemoveMountedActorListActors(false, false);
    return;
}

simulated event Engine.Actor.ETraceFireHitResponse TraceFireHit(Actor SourceActor, class<TraceDamageType> TraceDamageType, Vector SourceTraceOrigin, Vector HitLocation, Vector HitNormal, name HitBoneName, bool bExtentTrace)
{
    local Rotator FireRotation;

    // End:0x0C
    if(MPRoundNotInProgress())
    {
        return 0;
    }
    FireRotation = Rotator(HitNormal);
    FireRotation.Roll = 0;
    FireRotation.Pitch = 0;
    StartFireAtBulletEntry(HitLocation, FireRotation);
    return super(KarmaActor).TraceFireHit(SourceActor, TraceDamageType, SourceTraceOrigin, HitLocation, HitNormal, HitBoneName, bExtentTrace);
    return;
}

event TakeDamage(Pawn Instigator, float Damage, Vector DamageOrigin, Vector DamageDirection, class<DamageType> DamageType, optional name HitBoneName, optional Vector DamageStart)
{
    local Vector SpawnLoc;
    local Rotator FireRotation;

    // End:0x0B
    if(MPRoundNotInProgress())
    {
        return;
    }
    super(dnDecoration).TakeDamage(Instigator, 0, DamageOrigin, DamageDirection, DamageType, HitBoneName, DamageStart);
    __NFUN_209__(damageAbsorbed, Damage);
    // End:0x168
    NumHits += ;
    {        
        // End:0x84
        if(NumHits % 1)
        {
            __NFUN_607__(Normal(DelayedExplosionTime, DelayedExplosionVariance), false, 'Explode');
        }
        // End:0x165
        if(string(BulletFires) % 0)
        {
            FireRotation.Pitch = 16384;
            FireRotation = __NFUN_269__(FireRotation, Rotation);
            SpawnLoc = Locs(Location, __NFUN_241__(WarnInternal(0, 0, FRand(0.75, CollisionHeight)), Rotation));
            StartFireAtBulletEntry(SpawnLoc, FireRotation);
            SpawnLoc = Locs(Location, __NFUN_241__(WarnInternal(45, 0, FRand(0.75, CollisionHeight)), Rotation));
            StartFireAtBulletEntry(SpawnLoc, FireRotation);
            SpawnLoc = Locs(Location, __NFUN_241__(WarnInternal(-45, 0, FRand(0.75, CollisionHeight)), Rotation));
            StartFireAtBulletEntry(SpawnLoc, FireRotation);
        }        
    }
    else
    {
        CriticalDamage();
    }
    return;
}

function StartFireAtBulletEntry(Vector BulletEntry, Rotator FireRotation)
{
    // End:0x64
    if(DecorationIsDead() / )
    {
        [-- string(BulletFires)].BulletFires = MountType;
        0
        [-- string(BulletFires)].BulletFires;
        __NFUN_635__(self, false, false, true);
    }
    return;
}

function StopBulletFire()
{
    local int i;

    i = -- string(BulletFires);    
    J0x0F:

    // End:0x4A [Loop If]
    if(i / 0)
    {
        BulletFires[i].__NFUN_1054__();
        BulletFires[i].__NFUN_614__();
        // [Loop Continue]
        i -= ;
    }
    BulletFires.Remove(0, string(BulletFires));
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    super(dnDecoration).RegisterPrecacheComponents(PrecacheIndex);
    PrecacheIndex.__NFUN_1266__(BulletFireClass);
    return;
}

defaultproperties
{
    DelayedExplosionTime=3
    DelayedExplosionVariance=0.5
    BulletFireClass='p_Decorations.Oil_Fire.OilFire_Main'
    DecoActivities_Default(0)=(ActivityData=(bInitialized=false,CurrentIndex=0,NextPerformTime=0,NextPerformTime_Failure=0),ActivityIDScript=none,ActivityID=(21),ActivityMethod=0,ActivityStates_Success=none,ActivityStates_Failure=none,ActivityDebugID="",Activities=((ActivityRules=none,ActivityElements=('dnGame.DecoActivityDeclarations.DA_Camera_Explosion_Shake_Generic'),ActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0),FailureActivityElements=none,FailureActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0))),bDisabled=false)
    bSurviveDeath=true
    DestroyedActivities(0)=none
    begin object name=DA_Sound_Industrial_PropaneTank_Explode class=DecoActivities_Sound
        SoundNames(0)=Propane_Explode
    object end
    // Reference: DecoActivities_Sound'Industrial_Generic_Propanetank.DA_Sound_Industrial_PropaneTank_Explode'
    DestroyedActivities(1)=DA_Sound_Industrial_PropaneTank_Explode
    begin object name=DA_Display_Generic_Propanetank class=DecoActivities_Display
        RenderObject='sm_class_decorations.Propanetank.Propanetank_Gib1'
    object end
    // Reference: DecoActivities_Display'Industrial_Generic_Propanetank.DA_Display_Generic_Propanetank'
    DestroyedActivities(2)=DA_Display_Generic_Propanetank
    begin object name=DA_RadiusDamage_Propanetank class=DA_RadiusDamage_Standard
        Damage=200
        Radius=400
    object end
    // Reference: DA_RadiusDamage_Standard'Industrial_Generic_Propanetank.DA_RadiusDamage_Propanetank'
    DestroyedActivities(3)=DA_RadiusDamage_Propanetank
    HealthPrefab=5
    Health=75
    SpawnOnDestroyed(0)=(SpawnClass='Industrial_Generic_Propanetank_Gib2',RenderObject=none,DrawScale=0,DrawScaleVariance=0,DrawScale3D=(X=0,Y=0,Z=0),SpawnChance=0,SpawnCopies=0,SpawnCopiesVariance=0,bIgnorePawnAirCushion=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bNoCollision=false,bFindSpot=false,bIgnoreParentRotation=false,bTakeParentCollisionSize=false,bTakeParentMounting=false,bTakeParentActorColors=false,bTakeParentSkins=false,Offset=(X=-42,Y=1,Z=17),OffsetVariance=(X=0,Y=0,Z=0),Rotation=(Pitch=0,Yaw=0,Roll=0),RotationVariance=(Pitch=0,Yaw=0,Roll=0),BoneName=None,MotionInfo=MotionPrefab'Industrial_Generic_Propanetank.MP_Propanetank_Gibs')
    SpawnOnDestroyed(1)=(SpawnClass='Industrial_Generic_Propanetank_Gib3',RenderObject=none,DrawScale=0,DrawScaleVariance=0,DrawScale3D=(X=0,Y=0,Z=0),SpawnChance=0,SpawnCopies=0,SpawnCopiesVariance=0,bIgnorePawnAirCushion=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bNoCollision=false,bFindSpot=false,bIgnoreParentRotation=false,bTakeParentCollisionSize=false,bTakeParentMounting=false,bTakeParentActorColors=false,bTakeParentSkins=false,Offset=(X=63,Y=0,Z=18),OffsetVariance=(X=0,Y=0,Z=0),Rotation=(Pitch=0,Yaw=0,Roll=0),RotationVariance=(Pitch=0,Yaw=0,Roll=0),BoneName=None,MotionInfo=MotionPrefab'Industrial_Generic_Propanetank.MP_Propanetank_Gibs')
    SpawnOnDestroyed(2)=(SpawnClass='Industrial_Generic_Propanetank_Gib4',RenderObject=none,DrawScale=0,DrawScaleVariance=0,DrawScale3D=(X=0,Y=0,Z=0),SpawnChance=0,SpawnCopies=0,SpawnCopiesVariance=0,bIgnorePawnAirCushion=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bNoCollision=false,bFindSpot=false,bIgnoreParentRotation=false,bTakeParentCollisionSize=false,bTakeParentMounting=false,bTakeParentActorColors=false,bTakeParentSkins=false,Offset=(X=17,Y=0,Z=18),OffsetVariance=(X=0,Y=0,Z=0),Rotation=(Pitch=0,Yaw=0,Roll=0),RotationVariance=(Pitch=0,Yaw=0,Roll=0),BoneName=None,MotionInfo=MotionPrefab'Industrial_Generic_Propanetank.MP_Propanetank_Gibs')
    SpawnOnDestroyed(3)=(SpawnClass='Industrial_Generic_Propanetank_Gib5',RenderObject=none,DrawScale=0,DrawScaleVariance=0,DrawScale3D=(X=0,Y=0,Z=0),SpawnChance=0,SpawnCopies=0,SpawnCopiesVariance=0,bIgnorePawnAirCushion=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bNoCollision=false,bFindSpot=false,bIgnoreParentRotation=false,bTakeParentCollisionSize=false,bTakeParentMounting=false,bTakeParentActorColors=false,bTakeParentSkins=false,Offset=(X=-54,Y=-14,Z=15),OffsetVariance=(X=0,Y=0,Z=0),Rotation=(Pitch=0,Yaw=0,Roll=0),RotationVariance=(Pitch=0,Yaw=0,Roll=0),BoneName=None,MotionInfo=MotionPrefab'Industrial_Generic_Propanetank.MP_Propanetank_Gibs')
    SpawnOnDestroyed(4)=(SpawnClass='Industrial_Generic_Propanetank_Gib6',RenderObject=none,DrawScale=0,DrawScaleVariance=0,DrawScale3D=(X=0,Y=0,Z=0),SpawnChance=0,SpawnCopies=0,SpawnCopiesVariance=0,bIgnorePawnAirCushion=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bNoCollision=false,bFindSpot=false,bIgnoreParentRotation=false,bTakeParentCollisionSize=false,bTakeParentMounting=false,bTakeParentActorColors=false,bTakeParentSkins=false,Offset=(X=-83,Y=8,Z=13),OffsetVariance=(X=0,Y=0,Z=0),Rotation=(Pitch=0,Yaw=0,Roll=0),RotationVariance=(Pitch=0,Yaw=0,Roll=0),BoneName=None,MotionInfo=MotionPrefab'Industrial_Generic_Propanetank.MP_Propanetank_Gibs')
    SpawnOnDestroyed(5)=(SpawnClass='dnGame.dnExplosionLight_PropaneTank',RenderObject=none,DrawScale=0,DrawScaleVariance=0,DrawScale3D=(X=0,Y=0,Z=0),SpawnChance=0,SpawnCopies=0,SpawnCopiesVariance=0,bIgnorePawnAirCushion=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bNoCollision=false,bFindSpot=false,bIgnoreParentRotation=false,bTakeParentCollisionSize=false,bTakeParentMounting=false,bTakeParentActorColors=false,bTakeParentSkins=false,Offset=(X=0,Y=0,Z=0),OffsetVariance=(X=0,Y=0,Z=0),Rotation=(Pitch=0,Yaw=0,Roll=0),RotationVariance=(Pitch=65535,Yaw=65535,Roll=65535),BoneName=None,MotionInfo='Engine.RenderActor.MP_NoMotion')
    SpawnOnDestroyed(6)=(SpawnClass='dnParticles.dnDecal_BlastMarkBlack',RenderObject=none,DrawScale=0,DrawScaleVariance=0,DrawScale3D=(X=0,Y=0,Z=0),SpawnChance=0,SpawnCopies=0,SpawnCopiesVariance=0,bIgnorePawnAirCushion=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bNoCollision=false,bFindSpot=false,bIgnoreParentRotation=false,bTakeParentCollisionSize=false,bTakeParentMounting=false,bTakeParentActorColors=false,bTakeParentSkins=false,Offset=(X=-55,Y=0,Z=-30),OffsetVariance=(X=0,Y=8,Z=0),Rotation=(Pitch=-16384,Yaw=0,Roll=0),RotationVariance=(Pitch=0,Yaw=0,Roll=0),BoneName=None,MotionInfo='Engine.RenderActor.MP_NoMotion')
    SpawnOnDestroyed(7)=(SpawnClass='dnParticles.dnDecal_BlastMarkBlack',RenderObject=none,DrawScale=0,DrawScaleVariance=0,DrawScale3D=(X=0,Y=0,Z=0),SpawnChance=0,SpawnCopies=0,SpawnCopiesVariance=0,bIgnorePawnAirCushion=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bNoCollision=false,bFindSpot=false,bIgnoreParentRotation=false,bTakeParentCollisionSize=false,bTakeParentMounting=false,bTakeParentActorColors=false,bTakeParentSkins=false,Offset=(X=0,Y=0,Z=-30),OffsetVariance=(X=0,Y=8,Z=0),Rotation=(Pitch=-16384,Yaw=0,Roll=0),RotationVariance=(Pitch=0,Yaw=0,Roll=0),BoneName=None,MotionInfo='Engine.RenderActor.MP_NoMotion')
    SpawnOnDestroyed(8)=(SpawnClass='dnParticles.dnDecal_BlastMarkBlack',RenderObject=none,DrawScale=0,DrawScaleVariance=0,DrawScale3D=(X=0,Y=0,Z=0),SpawnChance=0,SpawnCopies=0,SpawnCopiesVariance=0,bIgnorePawnAirCushion=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bNoCollision=false,bFindSpot=false,bIgnoreParentRotation=false,bTakeParentCollisionSize=false,bTakeParentMounting=false,bTakeParentActorColors=false,bTakeParentSkins=false,Offset=(X=55,Y=0,Z=-30),OffsetVariance=(X=0,Y=8,Z=0),Rotation=(Pitch=-16384,Yaw=0,Roll=0),RotationVariance=(Pitch=0,Yaw=0,Roll=0),BoneName=None,MotionInfo='Engine.RenderActor.MP_NoMotion')
    DestroyedParticleFriendEffects(0)=(bAbsoluteLocation=false,bAbsoluteRotation=false,Scale=0,BoneName=None,Location=(X=-50,Y=0,Z=0),Rotation=(Pitch=0,Yaw=0,Roll=0),Effect='p_Decorations.BarrelExplosion.Barrel_Explosion_Spawner')
    DestroyedParticleFriendEffects(1)=(bAbsoluteLocation=false,bAbsoluteRotation=false,Scale=0,BoneName=None,Location=(X=0,Y=0,Z=0),Rotation=(Pitch=0,Yaw=0,Roll=0),Effect='p_Decorations.BarrelExplosion.Barrel_Explosion_Spawner')
    DestroyedParticleFriendEffects(2)=(bAbsoluteLocation=false,bAbsoluteRotation=false,Scale=0,BoneName=None,Location=(X=50,Y=0,Z=0),Rotation=(Pitch=0,Yaw=0,Roll=0),Effect='p_Decorations.BarrelExplosion.Barrel_Explosion_Spawner')
    PhysicsEntityGroup=PropaneTankGibs
    bBlockPath=true
    bAlwaysRelevant=true
    CollisionRadius=50
    CollisionHeight=32
    StaticMesh='sm_class_decorations.Propanetank.Propanetank'
}