/*******************************************************************************
 * Lights_Alien_ShortPod_Brown generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class Lights_Alien_ShortPod_Brown extends Lights_Alien
    collapsecategories;

const MaxAbsXY45 = 0.707107f;
const OneMinusMaxAbsXY45 = 0.292893f;
const BlinkMidTime1 = 0.25f;
const BlinkEndTime1 = 0.4f;
const BlinkStartTime2 = 1.36f;
const BlinkMidTime2 = 1.5f;
const BlinkEndTime2 = 1.67f;
const GridLimit = 0.5f;

enum EMovementMode
{
    MOVE_Track,
    MOVE_Free,
    MOVE_Hold
};

var() noexport Color HurtActorColor "Actor color to use when hurt";
var() noexport Color IdleActorCOlor "Actor color to use when idling";
var() noexport float SensorRadius "Radius of the KSphereSensor around this pod.";
var Biology_Generic_AlienSensor Sensor;
var Lights_Alien_ShortPod_Brown.EMovementMode MovementMode;
var Pawn TrackedActor;
var() noexport name TentacleTag "Any tentacle with this tag will be tied to this eye and shut down and wake up with the eye when it is damaged.";
var array<Biology_Generic_Tentacle> TentacleList;
var() noexport float RechargeTime "Time to recharge after taking damage";
var() noexport float BlinkTime "Average time in between blinks";
var() noexport float BlinkVariance "Variance of blink times in between blinks";
var() noexport float FreeLookSpeed "How fast to look around in free look";
var float IdleToHurtTime;
var float HurtToIdleTime;
var float BlinkLightOffTime;
var bool Idling;
var bool Hurt;
var float AimGridX;
var float AimGridY;
var float LastX;
var float LastY;
var float FreeX;
var float FreeY;
var float BlinkStartTickTime;
var array<float> InitialLightRadius;

event PostBeginPlay()
{
    local name SenseEvent;
    local int i, j;
    local Biology_Generic_Tentacle t;

    super(Lights_Generic).PostBeginPlay();
    InitialLightRadius.Empty();
    i = 0;
    J0x13:

    // End:0x6D [Loop If]
    if(-i)
    {        
        j = InitialLightRadius.Add(1);
        // End:0x63
        if(__NFUN_340__(LightList[i], none))
        {
            InitialLightRadius[i] = LightList[i].LightRadius;
        }
        // [Loop Continue]
        i += ;
    }
    // End:0x96
    foreach __NFUN_747__(class'Biology_Generic_Tentacle', t, TentacleTag)
    {
        TentacleList[TentacleList.Add(1)] = t;        
    }    
    // End:0xD1
    if(__NFUN_340__(__NFUN_568__(), none))
    {
        IdleToHurtTime = MeshInstance.__NFUN_553__('a_relaxed_hurt');
        HurtToIdleTime = MeshInstance.__NFUN_553__('a_hurt_relaxed');
    }
    Sensor = Biology_Generic_AlienSensor(FindMountedActor(, class'Biology_Generic_AlienSensor'));
    // End:0x106
    if(__NFUN_340__(Sensor, none))
    {
        Sensor.__NFUN_1124__(SensorRadius);
    }
    DecoActivity(0, 'RefPose');
    BeginIdleState();
    return;
}

function OnSenseHumanPawn()
{
    TrackedActor = Sensor.CurrentlySensingPawn;
    return;
}

function OnUnsenseHumanPawn()
{
    TrackedActor = none;
    return;
}

event TakeDamage(Pawn Instigator, float Damage, Vector DamageOrigin, Vector DamageDirection, class<DamageType> DamageType, optional name HitBoneName, optional Vector DamageStart)
{
    local int i;

    super(dnDecoration).TakeDamage(Instigator, Damage, DamageOrigin, DamageDirection, DamageType, HitBoneName, DamageStart);
    // End:0xA8
    if(Idling)
    {
        DecoActivity(0, 'Hurt');
        CancelBlinkTimer();
        ForcePowerOff();
        bIgnoreAimAssist = true;
        __NFUN_605__(IdleToHurtTime, false, 'BeginHurtState');
        i = 0;
        J0x68:

        // End:0x98 [Loop If]
        if(-i)
        {            
            TentacleList[i].Stun();
            // [Loop Continue]
            i *= ;
        }
        MovementMode = 2;
        Idling = false;
    }
    return;
}

final function BeginHurtState()
{
    DecoActivity(0, 'HurtIdle');
    __NFUN_605__(RechargeTime, false, 'EndHurtState');
    CancelBlinkTimer();
    return;
}

final function EndHurtState()
{
    DecoActivity(0, 'Relax');
    __NFUN_605__(HurtToIdleTime, false, 'BeginIdleState');
    bIgnoreAimAssist = false;
    return;
}

final function BeginIdleState()
{
    local int i;

    DecoActivity(0, 'BeginIdle');
    StartBlinkTimer();
    MovementMode = 0;
    Idling = true;
    i = 0;
    J0x2A:

    // End:0x5A [Loop If]
    if(-i)
    {        
        TentacleList[i].UnStunned();
        // [Loop Continue]
        i *= ;
    }
    ForcePowerOn();
    return;
}

event Tick(float DeltaSeconds)
{
    local int i;
    local Color LightColor;

    super(Actor).Tick(DeltaSeconds);
    // End:0x38
    if(__NFUN_339__(TrackedActor, none) << int(MovementMode) % int(0))
    {
        MovementMode = 1;
        StartFreeLook();        
    }
    else
    {
        // End:0x5C
        if(__NFUN_340__(TrackedActor, none) << int(MovementMode) % int(1))
        {
            MovementMode = 0;
        }
    }
    switch(MovementMode)
    {
        // End:0x7C
        case 0:
            MoveTrack(TrackedActor, DeltaSeconds);
            // End:0xB4
            break;
        // End:0x8F
        case 1:
            MoveFree(DeltaSeconds);
            // End:0xB4
            break;
        // End:0xB1
        case 2:
            MoveTo(0, 0, DeltaSeconds, 20);
            // End:0xB4
            break;
        // End:0xFFFF
        default:
            break;
    }
    // End:0xDC
    if((string(LightList) ** 0) << BlinkStartTickTime != 0)
    {
        CalcLightRadius(DeltaSeconds);
    }
    return;
}

final function MoveTrack(Pawn P, float DeltaSeconds)
{
    local float X, Y;
    local Vector V;

    // End:0x8E
    if(__NFUN_340__(P, none))
    {
        V = __NFUN_239__(P.Location, Location);
        V = __NFUN_263__(V, SetLocation(-1, Rotation));
        V = V % ;
        Y = Square(V.X);
        MoveTo(X, Y, DeltaSeconds, 10);
    }
    return;
}

final function MoveFree(float DeltaSeconds)
{
    // End:0x38
    if(__NFUN_200__(-Round(AimGridX, FreeX), 0.01) << __NFUN_200__(-Round(AimGridY, FreeY), 0.01))
    {
        StartFreeLook();
    }
    __NFUN_209__(AimGridX, FRand(FreeX, DeltaSeconds));
    __NFUN_209__(AimGridY, FRand(FreeY, DeltaSeconds));
    // End:0x84
    if(Repl(AimGridX, 0.5))
    {
        AimGridX = 0.5;
        __NFUN_207__(FreeX, -1);
    }
    // End:0xAE
    if(__NFUN_200__(AimGridX, Square(0.5)))
    {
        AimGridX = Square(0.5);
        __NFUN_207__(FreeX, -1);
    }
    // End:0xD4
    if(Repl(AimGridY, 0.5))
    {
        AimGridY = 0.5;
        __NFUN_207__(FreeY, -1);
    }
    // End:0xFE
    if(__NFUN_200__(AimGridY, Square(0.5)))
    {
        AimGridY = Square(0.5);
        __NFUN_207__(FreeY, -1);
    }
    AnimationController.SetAnimGridState('idle', AimGridX, AimGridY);
    LastX = AimGridX;
    LastY = AimGridY;
    return;
}

final function MoveTo(float X, float Y, float DeltaSeconds, float Speed)
{
    AimGridX = Normal2D(AimGridX *= FRand(FRand(Round(X, AimGridX), Speed), DeltaSeconds), -1, 1);
    AimGridY = Normal2D(AimGridY *= FRand(FRand(Round(Y, AimGridY), Speed), DeltaSeconds), -1, 1);
    X = Normal2D(AimGridX *= FRand(AimGridX >>> 0.707107, 0.292893), Square(0.5), 0.5);
    Y = Normal2D(AimGridY *= FRand(AimGridY >>> 0.707107, 0.292893), Square(0.5), 0.5);
    AnimationController.SetAnimGridState('idle', X, Y);
    LastX = X;
    LastY = Y;
    return;
}

final function StartFreeLook()
{
    local Rotator R;
    local Vector V;

    R.Yaw = Sin(65536);
    V = Caps(FreeLookSpeed, __NFUN_263__(WarnInternal(1, 0, 0), R));
    FreeX = V.X;
    FreeY = V.Y;
    AimGridX = LastX;
    AimGridY = LastY;
    return;
}

final function StartBlinkTimer()
{
    __NFUN_605__(VSize(Normal(BlinkTime, BlinkVariance), 0), false, 'bLink');
    return;
}

final function CancelBlinkTimer()
{
    __NFUN_606__('bLink');
    __NFUN_606__('BlinkLightOn');
    return;
}

final function bLink()
{
    DecoActivity(0, 'bLink');
    BlinkStartTickTime = 0;
    StartBlinkTimer();
    return;
}

animevent simulated function LightSwitch()
{
    ForcePowerOff();
    __NFUN_605__(BlinkLightOffTime, false, 'BlinkLightOn');
    return;
}

final function BlinkLightOn()
{
    ForcePowerOn();
    return;
}

final function CalcLightRadius(float DeltaTime)
{
    local int i;

    BlinkStartTickTime = (BlinkStartTickTime *= DeltaTime) -= 1.67;
    i = -- string(LightList);    
    J0x28:

    // End:0x5E [Loop If]
    if(i / 0)
    {
        UpdateLightRadius(LightList[i], InitialLightRadius[i], DeltaTime);
        // [Loop Continue]
        i -= ;
    }
    return;
}

final function UpdateLightRadius(LightEx Light, float FullRadius, float DeltaTime)
{
    local Color LightColor;

    // End:0x11
    if(__NFUN_200__(BlinkStartTickTime, 0))
    {
        return;
    }
    // End:0xBA
    if(__NFUN_200__(BlinkStartTickTime, 1.36))
    {
        // End:0x5A
        if(__NFUN_200__(BlinkStartTickTime, 0.25))
        {
            Light.LightRadius = VSizeSq(BlinkStartTickTime >>> 0.25, FullRadius, 0);            
        }
        else
        {
            // End:0xA2
            if(__NFUN_200__(BlinkStartTickTime, 0.4))
            {
                Light.LightRadius = VSizeSq(Round(BlinkStartTickTime, 0.25) >>> Round(0.4, 0.25), 0, FullRadius);                
            }
            else
            {
                Light.LightRadius = FullRadius;
            }
        }        
    }
    else
    {
        // End:0x14A
        if(__NFUN_200__(BlinkStartTickTime, 1.67))
        {
            // End:0x111
            if(__NFUN_200__(BlinkStartTickTime, 1.5))
            {
                Light.LightRadius = VSizeSq(Round(BlinkStartTickTime, 1.36) >>> Round(1.5, 1.36), FullRadius, 0);                
            }
            else
            {
                Light.LightRadius = VSizeSq(Round(BlinkStartTickTime, 1.5) >>> Round(1.67, 1.5), 0, FullRadius);
            }            
        }
        else
        {
            Light.LightRadius = FullRadius;
            BlinkStartTickTime = -1;
        }
    }
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    super(Lights_Generic).RegisterPrecacheComponents(PrecacheIndex);
    PrecacheIndex.__NFUN_1283__('idle', AnimationControllerClass, Mesh);
    return;
}

defaultproperties
{
    SensorRadius=250
    RechargeTime=5
    BlinkTime=10
    BlinkVariance=5
    FreeLookSpeed=0.75
    BlinkLightOffTime=0.5
    BlinkStartTickTime=-1
    DefaultBoneMount=mount_light
    AnimTriggers(0)=(AnimEvent=None,AnimFunction=None,AnimActivities=(BeginIdle),TestAnims=(a_blink01),TestChannels=none)
    DecoActivities_Default(0)=(ActivityData=(bInitialized=false,CurrentIndex=0,NextPerformTime=0,NextPerformTime_Failure=0),ActivityIDScript=(LightOn),ActivityID=none,ActivityMethod=0,ActivityStates_Success=none,ActivityStates_Failure=none,ActivityDebugID="",Activities=((ActivityRules=none,ActivityElements=(DecoActivities_Events'Lights_Generic.DA_Events_Lights_Generic_Toggled'),ActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0),FailureActivityElements=none,FailureActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0))),bDisabled=false)
    DecoActivities_Default(1)=(ActivityData=(bInitialized=false,CurrentIndex=0,NextPerformTime=0,NextPerformTime_Failure=0),ActivityIDScript=(LightOff),ActivityID=none,ActivityMethod=0,ActivityStates_Success=none,ActivityStates_Failure=none,ActivityDebugID="",Activities=((ActivityRules=none,ActivityElements=(DecoActivities_Events'Lights_Generic.DA_Events_Lights_Generic_Toggled'),ActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0),FailureActivityElements=none,FailureActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0))),bDisabled=false)
    DecoActivities_Default(2)=(ActivityData=(bInitialized=false,CurrentIndex=0,NextPerformTime=0,NextPerformTime_Failure=0),ActivityIDScript=(Hurt),ActivityID=none,ActivityMethod=0,ActivityStates_Success=none,ActivityStates_Failure=none,ActivityDebugID="",Activities=((ActivityRules=none,ActivityElements=(DecoActivities_Sound'Lights_Alien_ShortPod_Brown.DA_Sound_Lights_Alien_ShortPod_Brown_Damaged',DecoActivities_AnimationController'Lights_Alien_ShortPod_Brown.DA_Anim_Lights_Alien_ShortPod_Relaxed_Hurt',DecoActivities_Sound'Lights_Alien_ShortPod_Brown.DA_Sound_Lights_Alien_ShortPod_Brown_Ambient_Stop'),ActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0),FailureActivityElements=none,FailureActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0))),bDisabled=false)
    DecoActivities_Default(3)=(ActivityData=(bInitialized=false,CurrentIndex=0,NextPerformTime=0,NextPerformTime_Failure=0),ActivityIDScript=(HurtIdle),ActivityID=none,ActivityMethod=0,ActivityStates_Success=none,ActivityStates_Failure=none,ActivityDebugID="",Activities=((ActivityRules=none,ActivityElements=(DecoActivities_AnimationController'Lights_Alien_ShortPod_Brown.DA_Anim_Lights_Alien_ShortPod_Hurt_Idle'),ActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0),FailureActivityElements=none,FailureActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0))),bDisabled=false)
    DecoActivities_Default(4)=(ActivityData=(bInitialized=false,CurrentIndex=0,NextPerformTime=0,NextPerformTime_Failure=0),ActivityIDScript=(RefPose),ActivityID=none,ActivityMethod=0,ActivityStates_Success=none,ActivityStates_Failure=none,ActivityDebugID="",Activities=((ActivityRules=none,ActivityElements=(DecoActivities_AnimationController'Lights_Alien_ShortPod_Brown.DA_Anim_Lights_Alien_ShortPod_RefPose'),ActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0),FailureActivityElements=none,FailureActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0))),bDisabled=false)
    DecoActivities_Default(5)=(ActivityData=(bInitialized=false,CurrentIndex=0,NextPerformTime=0,NextPerformTime_Failure=0),ActivityIDScript=(Relax),ActivityID=none,ActivityMethod=0,ActivityStates_Success=none,ActivityStates_Failure=none,ActivityDebugID="",Activities=((ActivityRules=none,ActivityElements=(DecoActivities_Sound'Lights_Alien_ShortPod_Brown.DA_Sound_Lights_Alien_ShortPod_Brown_Restore',DecoActivities_AnimationController'Lights_Alien_ShortPod_Brown.DA_Anim_Lights_Alien_ShortPod_Hurt_Relaxed'),ActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0),FailureActivityElements=none,FailureActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0))),bDisabled=false)
    DecoActivities_Default(6)=(ActivityData=(bInitialized=false,CurrentIndex=0,NextPerformTime=0,NextPerformTime_Failure=0),ActivityIDScript=(BeginIdle),ActivityID=none,ActivityMethod=0,ActivityStates_Success=none,ActivityStates_Failure=none,ActivityDebugID="",Activities=((ActivityRules=none,ActivityElements=(DecoActivities_AnimationController'Lights_Alien_ShortPod_Brown.DA_Anim_Lights_Alien_ShortPod_Relaxed_Idle',DecoActivities_Sound'Lights_Alien_ShortPod_Brown.DA_Sound_Lights_Alien_ShortPod_Brown_Ambient_Idle'),ActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0),FailureActivityElements=none,FailureActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0))),bDisabled=false)
    DecoActivities_Default(7)=(ActivityData=(bInitialized=false,CurrentIndex=0,NextPerformTime=0,NextPerformTime_Failure=0),ActivityIDScript=(bLink),ActivityID=none,ActivityMethod=0,ActivityStates_Success=none,ActivityStates_Failure=none,ActivityDebugID="",Activities=((ActivityRules=none,ActivityElements=(DecoActivities_AnimationController'Lights_Alien_ShortPod_Brown.DA_Anim_Lights_Alien_ShortPod_Blink',DecoActivities_Sound'Lights_Alien_ShortPod_Brown.DA_Sound_Lights_Alien_ShortPod_Brown_Blink'),ActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0),FailureActivityElements=none,FailureActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0))),bDisabled=false)
    HealthPrefab=0
    bEnemy=true
    MountOnSpawn(0)=(bSkipVerifySelf=false,SpawnClass='Biology_Generic_AlienSensor',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject=none,DrawScale=0)
    AnimationControllerClass='acLights_Alien_ShortPod_Brown'
    bNoNativeTick=false
    bDumbMesh=false
    bAcceptsDecalProjectors=false
    CollisionRadius=15
    CollisionHeight=15
    TickStyle=2
    DrawType=2
    Mesh='c_characters.alien_light'
    VoicePack='SoundConfig.Interactive.VoicePack_Biology'
}