/*******************************************************************************
 * Nature_Generic_Boulder_Destructible generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class Nature_Generic_Boulder_Destructible extends Nature_Generic_Boulder
    collapsecategories;

var SoftParticleSystem Dust;

function PostVerifySelf()
{
    super(dnDecoration).PostVerifySelf();
    Dust = SoftParticleSystem(FindMountedActor('Dust'));
    // End:0x3B
    if(__NFUN_340__(Dust, none))
    {
        Dust.__NFUN_1063__();
        UpdateDust();
    }
    return;
}

event Tick(float DeltaTime)
{
    super(Actor).Tick(DeltaTime);
    // End:0x1D
    if(__NFUN_340__(Dust, none))
    {
        UpdateDust();
    }
    return;
}

simulated function UpdateDust()
{
    local float Alpha;

    Alpha = Clamp(Velocity) >>> 1500;
    // End:0x38
    if(__NFUN_200__(Alpha, 0.1))
    {
        Dust.Enabled = false;        
    }
    else
    {
        Dust.Enabled = true;
    }
    Dust.AlphaStart = Clamp(Velocity) >>> 1500;
    Dust.AlphaMid = Clamp(Velocity) >>> 1500;
    return;
}

defaultproperties
{
    begin object name=Boulder_Desert_Skins class=DecoActivities_Display
        Skins(0)=(Index=0,NewMaterialEx='smt_skins17.BoulderSet.RockSmall_bs')
    object end
    // Reference: DecoActivities_Display'Nature_Generic_Boulder_Destructible.Boulder_Desert_Skins'
    StartupActivities(0)=Boulder_Desert_Skins
    DestroyedActivities(0)=none
    begin object name=DA_Sound_Boulder_Destroy class=DecoActivities_Sound
        SoundNames(0)=Boulder_Exp
    object end
    // Reference: DecoActivities_Sound'Nature_Generic_Boulder_Destructible.DA_Sound_Boulder_Destroy'
    DestroyedActivities(1)=DA_Sound_Boulder_Destroy
    begin object name=DA_RadiusDamage_Boulder_Destroyed class=DecoActivities_RadiusDamage
        Damage=100
        Radius=180
        DamageFalloffStart=180
        DamageType='dnGame.BoulderDamage'
    object end
    // Reference: DecoActivities_RadiusDamage'Nature_Generic_Boulder_Destructible.DA_RadiusDamage_Boulder_Destroyed'
    DestroyedActivities(2)=DA_RadiusDamage_Boulder_Destroyed
    HealthPrefab=5
    DamageThreshold=2500
    DamageTypesAcceptedOnly(0)='Engine.VehiclePhysicsImpactDamage'
    MountOnSpawn(0)=(bSkipVerifySelf=false,SpawnClass='p_Vehicles.MonsterTruck_Driving.MonsterTruck_Driving_Main',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=Dust,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject=none,DrawScale=2)
    Health=2500
    HealthCap=2500
    SpawnOnDestroyed(0)=(SpawnClass='Nature_Generic_Boulder_Destructible_Gib_C',RenderObject=none,DrawScale=0,DrawScaleVariance=0,DrawScale3D=(X=0,Y=0,Z=0),SpawnChance=0,SpawnCopies=0,SpawnCopiesVariance=0,bIgnorePawnAirCushion=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bNoCollision=false,bFindSpot=false,bIgnoreParentRotation=false,bTakeParentCollisionSize=false,bTakeParentMounting=false,bTakeParentActorColors=false,bTakeParentSkins=false,Offset=(X=0,Y=0,Z=0),OffsetVariance=(X=0,Y=40,Z=0),Rotation=(Pitch=0,Yaw=0,Roll=0),RotationVariance=(Pitch=0,Yaw=0,Roll=0),BoneName=None,MotionInfo=none)
    SpawnOnDestroyed(1)=(SpawnClass='Nature_Generic_Boulder_Destructible_Gib_D',RenderObject=none,DrawScale=0,DrawScaleVariance=0,DrawScale3D=(X=0,Y=0,Z=0),SpawnChance=0,SpawnCopies=0,SpawnCopiesVariance=0,bIgnorePawnAirCushion=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bNoCollision=false,bFindSpot=false,bIgnoreParentRotation=false,bTakeParentCollisionSize=false,bTakeParentMounting=false,bTakeParentActorColors=false,bTakeParentSkins=false,Offset=(X=0,Y=0,Z=0),OffsetVariance=(X=0,Y=40,Z=0),Rotation=(Pitch=0,Yaw=0,Roll=0),RotationVariance=(Pitch=0,Yaw=0,Roll=0),BoneName=None,MotionInfo=none)
    SpawnOnDestroyed(2)=(SpawnClass='Nature_Generic_Boulder_Destructible_Gib_E',RenderObject=none,DrawScale=0,DrawScaleVariance=0,DrawScale3D=(X=0,Y=0,Z=0),SpawnChance=0,SpawnCopies=0,SpawnCopiesVariance=0,bIgnorePawnAirCushion=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bNoCollision=false,bFindSpot=false,bIgnoreParentRotation=false,bTakeParentCollisionSize=false,bTakeParentMounting=false,bTakeParentActorColors=false,bTakeParentSkins=false,Offset=(X=0,Y=0,Z=0),OffsetVariance=(X=0,Y=40,Z=0),Rotation=(Pitch=0,Yaw=0,Roll=0),RotationVariance=(Pitch=0,Yaw=0,Roll=0),BoneName=None,MotionInfo=none)
    SpawnOnDestroyed(3)=(SpawnClass='Nature_Generic_Boulder_Destructible_Gib_C',RenderObject=none,DrawScale=0,DrawScaleVariance=0,DrawScale3D=(X=0,Y=0,Z=0),SpawnChance=0,SpawnCopies=0,SpawnCopiesVariance=0,bIgnorePawnAirCushion=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bNoCollision=false,bFindSpot=false,bIgnoreParentRotation=false,bTakeParentCollisionSize=false,bTakeParentMounting=false,bTakeParentActorColors=false,bTakeParentSkins=false,Offset=(X=0,Y=0,Z=0),OffsetVariance=(X=0,Y=40,Z=0),Rotation=(Pitch=0,Yaw=0,Roll=0),RotationVariance=(Pitch=0,Yaw=0,Roll=0),BoneName=None,MotionInfo=none)
    DestroyedParticleFriendEffects(0)=(bAbsoluteLocation=false,bAbsoluteRotation=false,Scale=0,BoneName=None,Location=(X=0,Y=0,Z=0),Rotation=(Pitch=0,Yaw=0,Roll=0),Effect='p_Decorations.BoulderSplit.BoulderSplitDesert_Spawner')
    begin object name=Boulder_Gibs_Motion class=MotionPrefab
        bUseDamageInfo=false
        bUseParentRotationRate=false
        VelocityRelativeType=3
        Velocity=(X=400,Y=400,Z=400)
        VelocityVariance=(X=200,Y=200,Z=200)
        RotationRateVariance=(Pitch=1638400,Yaw=1638400,Roll=1638400)
    object end
    // Reference: MotionPrefab'Nature_Generic_Boulder_Destructible.Boulder_Gibs_Motion'
    DefaultMotionPrefab=Boulder_Gibs_Motion
    bTakeDamageMomentum=false
    bTakeExplosionDamageMomentum=false
    bCanBreakGlass=true
    PhysicsMaterial='dnMaterial.dnPhysicsMaterial_Stone'
    MinDamageVelocity=100
    MaxImpactDamage=5000
    FixedPhysicsDamageToNotPlayer=100
    FixedPhysicsDamageToPlayer=50
    PhysicsSoundOverrides(0)=(SoundType=0,OtherMaterialTypes=none,OtherMassTypes=none,Sounds=('a_impact.KarmaStone.StoneHeavy01','a_impact.KarmaStone.StoneHeavy02','a_impact.KarmaStone.StoneHeavy03','a_impact.KarmaStone.StoneHeavy04'),SoundInfo=(InputRange=(Min=64,Max=1280),OutputPitchRange=(Min=0.75,Max=1.25),OutputVolumeRange=(Min=0.75,Max=1)),bDisableSoundInWater=true)
    PhysicsSoundOverrides(1)=(SoundType=1,OtherMaterialTypes=none,OtherMassTypes=none,Sounds=('a_impact.KarmaStone.Boulder_Roll_01'),SoundInfo=(InputRange=(Min=0.5,Max=8),OutputPitchRange=(Min=0.5,Max=1),OutputVolumeRange=(Min=0.5,Max=1)),bDisableSoundInWater=true)
    CollisionRadius=90
    CollisionHeight=85
    Mass=2000
    StaticMesh='sm_class_decorations.rocks.RollingRock_1'
}